
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * An area on the unit sphere defined by the intersection with a plane
 * 
 * <p>Java class for halfspaceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="halfspaceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Vector" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double3Type"/>
 *         <element name="Offset" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}hsOffsetType"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "halfspaceType", propOrder = {
    "vector",
    "offset"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class HalfspaceType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * This needs to be a spherical coordinate vector; it is the unit vector that is normal to the plane that forms a constraint for a convex
     * 
     */
    @XmlElement(name = "Vector", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Double3Type vector;
    /**
     * The distance along the normal vector where the constraint plane intersects that vector; if positive, the spherical sector on the far side (seen from the center) is selected; if negative, the point of intersection is in the opposite direction of the vector, resulting in more than a hemisphere; the valid range is -1.0 to +1.0
     * 
     */
    @XmlElement(name = "Offset")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected double offset;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient HalfspaceType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public HalfspaceType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public HalfspaceType(final Double3Type vector, final double offset) {
        this.vector = vector;
        this.offset = offset;
    }

    /**
     * This needs to be a spherical coordinate vector; it is the unit vector that is normal to the plane that forms a constraint for a convex
     * 
     * @return
     *     possible object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Double3Type getVector() {
        return vector;
    }

    /**
     * Sets the value of the vector property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double3Type }
     *     
     * @see #getVector()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setVector(Double3Type value) {
        this.vector = value;
    }

    /**
     * The distance along the normal vector where the constraint plane intersects that vector; if positive, the spherical sector on the far side (seen from the center) is selected; if negative, the point of intersection is in the opposite direction of the vector, resulting in more than a hemisphere; the valid range is -1.0 to +1.0
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public double getOffset() {
        return offset;
    }

    /**
     * Sets the value of the offset property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setOffset(double value) {
        this.offset = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final HalfspaceType that = ((HalfspaceType) object);
        {
            Double3Type leftVector;
            leftVector = this.getVector();
            Double3Type rightVector;
            rightVector = that.getVector();
            if (this.vector!= null) {
                if (that.vector!= null) {
                    if (!leftVector.equals(rightVector)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.vector!= null) {
                    return false;
                }
            }
        }
        {
            double leftOffset;
            leftOffset = this.getOffset();
            double rightOffset;
            rightOffset = that.getOffset();
            if (Double.doubleToLongBits(leftOffset)!= Double.doubleToLongBits(rightOffset)) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            Double3Type theVector;
            theVector = this.getVector();
            if (this.vector!= null) {
                currentHashCode += theVector.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theOffset;
            theOffset = this.getOffset();
            final long theOffsetBits = Double.doubleToLongBits(theOffset);
            currentHashCode += ((int)(theOffsetBits^(theOffsetBits >>> 32)));
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            Double3Type theVector;
            theVector = this.getVector();
            strategy.appendField(locator, this, "vector", buffer, theVector, (this.vector!= null));
        }
        {
            double theOffset;
            theOffset = this.getOffset();
            strategy.appendField(locator, this, "offset", buffer, theOffset, true);
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof HalfspaceType) {
            final HalfspaceType target = this;
            final HalfspaceType leftObject = ((HalfspaceType) left);
            final HalfspaceType rightObject = ((HalfspaceType) right);
            {
                Boolean vectorShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.vector!= null), (rightObject.vector!= null));
                if (vectorShouldBeMergedAndSet == Boolean.TRUE) {
                    Double3Type lhsVector;
                    lhsVector = leftObject.getVector();
                    Double3Type rhsVector;
                    rhsVector = rightObject.getVector();
                    Double3Type mergedVector = ((Double3Type) strategy.merge(LocatorUtils.property(leftLocator, "vector", lhsVector), LocatorUtils.property(rightLocator, "vector", rhsVector), lhsVector, rhsVector, (leftObject.vector!= null), (rightObject.vector!= null)));
                    target.setVector(mergedVector);
                } else {
                    if (vectorShouldBeMergedAndSet == Boolean.FALSE) {
                        target.vector = null;
                    }
                }
            }
            {
                Boolean offsetShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (offsetShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsOffset;
                    lhsOffset = leftObject.getOffset();
                    double rhsOffset;
                    rhsOffset = rightObject.getOffset();
                    double mergedOffset = ((double) strategy.merge(LocatorUtils.property(leftLocator, "offset", lhsOffset), LocatorUtils.property(rightLocator, "offset", rhsOffset), lhsOffset, rhsOffset, true, true));
                    target.setOffset(mergedOffset);
                } else {
                    if (offsetShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new HalfspaceType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType clone() {
        final HalfspaceType _newObject;
        try {
            _newObject = ((HalfspaceType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.vector = ((this.vector == null)?null:this.vector.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType createCopy() {
        final HalfspaceType _newObject;
        try {
            _newObject = ((HalfspaceType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.vector = ((this.vector == null)?null:this.vector.createCopy());
        _newObject.offset = this.offset;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final HalfspaceType _newObject;
        try {
            _newObject = ((HalfspaceType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree vectorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vector"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vectorPropertyTree!= null):((vectorPropertyTree == null)||(!vectorPropertyTree.isLeaf())))) {
            _newObject.vector = ((this.vector == null)?null:this.vector.createCopy(vectorPropertyTree, _propertyTreeUse));
        }
        final PropertyTree offsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetPropertyTree!= null):((offsetPropertyTree == null)||(!offsetPropertyTree.isLeaf())))) {
            _newObject.offset = this.offset;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new HalfspaceType.Modifier();
        }
        return ((HalfspaceType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final HalfspaceType.Builder<_B> _other) {
        _other.vector = ((this.vector == null)?null:this.vector.newCopyBuilder(_other));
        _other.offset = this.offset;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >HalfspaceType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new HalfspaceType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HalfspaceType.Builder<Void> builder() {
        return new HalfspaceType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >HalfspaceType.Builder<_B> copyOf(final HalfspaceType _other) {
        final HalfspaceType.Builder<_B> _newBuilder = new HalfspaceType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final HalfspaceType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree vectorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vector"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vectorPropertyTree!= null):((vectorPropertyTree == null)||(!vectorPropertyTree.isLeaf())))) {
            _other.vector = ((this.vector == null)?null:this.vector.newCopyBuilder(_other, vectorPropertyTree, _propertyTreeUse));
        }
        final PropertyTree offsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetPropertyTree!= null):((offsetPropertyTree == null)||(!offsetPropertyTree.isLeaf())))) {
            _other.offset = this.offset;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >HalfspaceType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new HalfspaceType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >HalfspaceType.Builder<_B> copyOf(final HalfspaceType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final HalfspaceType.Builder<_B> _newBuilder = new HalfspaceType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HalfspaceType.Builder<Void> copyExcept(final HalfspaceType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HalfspaceType.Builder<Void> copyOnly(final HalfspaceType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HalfspaceType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new SingleProperty<>(HalfspaceType.PropInfo.VECTOR, this))&&(this.vector!= null)) {
            this.vector.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(HalfspaceType.PropInfo.OFFSET, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final HalfspaceType _storedValue;
        private Double3Type.Builder<HalfspaceType.Builder<_B>> vector;
        private double offset;

        public Builder(final _B _parentBuilder, final HalfspaceType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.vector = ((_other.vector == null)?null:_other.vector.newCopyBuilder(this));
                    this.offset = _other.offset;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final HalfspaceType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree vectorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vector"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vectorPropertyTree!= null):((vectorPropertyTree == null)||(!vectorPropertyTree.isLeaf())))) {
                        this.vector = ((_other.vector == null)?null:_other.vector.newCopyBuilder(this, vectorPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree offsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offset"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetPropertyTree!= null):((offsetPropertyTree == null)||(!offsetPropertyTree.isLeaf())))) {
                        this.offset = _other.offset;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends HalfspaceType >_P init(final _P _product) {
            _product.vector = ((this.vector == null)?null:this.vector.build());
            _product.offset = this.offset;
            return _product;
        }

        /**
         * Sets the new value of "vector" (any previous value will be replaced)
         * 
         * @param vector
         *     New value of the "vector" property.
         */
        public HalfspaceType.Builder<_B> withVector(final Double3Type vector) {
            this.vector = ((vector == null)?null:new Double3Type.Builder<>(this, vector, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "vector"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "vector" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double3Type.Builder<? extends HalfspaceType.Builder<_B>> withVector() {
            if (this.vector!= null) {
                return this.vector;
            }
            return this.vector = new Double3Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "offset" (any previous value will be replaced)
         * 
         * @param offset
         *     New value of the "offset" property.
         */
        public HalfspaceType.Builder<_B> withOffset(final double offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public HalfspaceType build() {
            if (_storedValue == null) {
                return this.init(new HalfspaceType());
            } else {
                return ((HalfspaceType) _storedValue);
            }
        }

        public HalfspaceType.Builder<_B> copyOf(final HalfspaceType _other) {
            _other.copyTo(this);
            return this;
        }

        public HalfspaceType.Builder<_B> copyOf(final HalfspaceType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setVector(final Double3Type vector) {
            HalfspaceType.this.setVector(vector);
        }

        public void setOffset(final double offset) {
            HalfspaceType.this.setOffset(offset);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<HalfspaceType, Double3Type> VECTOR = new SinglePropertyInfo<HalfspaceType,Double3Type>("vector", HalfspaceType.class, Double3Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Vector"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double3Type"), false) {


            @Override
            public Double3Type get(final HalfspaceType _instance_) {
                return ((_instance_ == null)?null:_instance_.vector);
            }

            @Override
            public void set(final HalfspaceType _instance_, final Double3Type _value_) {
                if (_instance_!= null) {
                    _instance_.vector = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<HalfspaceType, Double> OFFSET = new SinglePropertyInfo<HalfspaceType,Double>("offset", HalfspaceType.class, Double.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Offset"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "hsOffsetType"), false) {


            @Override
            public Double get(final HalfspaceType _instance_) {
                return ((_instance_ == null)?null:_instance_.offset);
            }

            @Override
            public void set(final HalfspaceType _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.offset = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends HalfspaceType.Selector<HalfspaceType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static HalfspaceType.Select _root() {
            return new HalfspaceType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private Double3Type.Selector<TRoot, HalfspaceType.Selector<TRoot, TParent>> vector = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.vector!= null) {
                products.put("vector", this.vector.init());
            }
            return products;
        }

        public Double3Type.Selector<TRoot, HalfspaceType.Selector<TRoot, TParent>> vector() {
            return ((this.vector == null)?this.vector = new Double3Type.Selector<>(this._root, this, "vector"):this.vector);
        }

    }

}
