
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Polygon: one or more vertices; counter-clockwise (as seen from "inside" or from "top") encircled area is enclosed; sides should span less than 180 deg in each coordinate if spherical; a polygon may not intersect itself
 * 
 * <p>Java class for polygonType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="polygonType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Vertex" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}vertexType" maxOccurs="unbounded"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "polygonType", propOrder = {
    "vertices"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class PolygonType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * In order to form polygons, vertices are to be connected with straight line segments. In the case of spherical coordinates: greatcircle segments; if a smallCircle element si present, the vertex and its predecessor are to be connected with a smallcircle, by default in the CoordSys that is referenced; optionally, a pole may be specified (other than the CoordSys pole) that defines the smallcircle system
     * 
     */
    @XmlElement(name = "Vertex", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<VertexType> vertices;

    /**
     * Default no-arg constructor
     * 
     */
    public PolygonType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public PolygonType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final List<VertexType> vertices) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.vertices = vertices;
    }

    /**
     * In order to form polygons, vertices are to be connected with straight line segments. In the case of spherical coordinates: greatcircle segments; if a smallCircle element si present, the vertex and its predecessor are to be connected with a smallcircle, by default in the CoordSys that is referenced; optionally, a pole may be specified (other than the CoordSys pole) that defines the smallcircle system
     * 
     * Gets the value of the vertices property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the vertices property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getVertices().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link VertexType }
     * </p>
     * 
     * 
     * @return
     *     The value of the vertices property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<VertexType> getVertices() {
        if (vertices == null) {
            vertices = new ArrayList<>();
        }
        return this.vertices;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final PolygonType that = ((PolygonType) object);
        {
            List<VertexType> leftVertices;
            leftVertices = (((this.vertices!= null)&&(!this.vertices.isEmpty()))?this.getVertices():null);
            List<VertexType> rightVertices;
            rightVertices = (((that.vertices!= null)&&(!that.vertices.isEmpty()))?that.getVertices():null);
            if ((this.vertices!= null)&&(!this.vertices.isEmpty())) {
                if ((that.vertices!= null)&&(!that.vertices.isEmpty())) {
                    if (!leftVertices.equals(rightVertices)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.vertices!= null)&&(!that.vertices.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<VertexType> theVertices;
            theVertices = (((this.vertices!= null)&&(!this.vertices.isEmpty()))?this.getVertices():null);
            if ((this.vertices!= null)&&(!this.vertices.isEmpty())) {
                currentHashCode += theVertices.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<VertexType> theVertices;
            theVertices = (((this.vertices!= null)&&(!this.vertices.isEmpty()))?this.getVertices():null);
            strategy.appendField(locator, this, "vertices", buffer, theVertices, ((this.vertices!= null)&&(!this.vertices.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof PolygonType) {
            final PolygonType target = this;
            final PolygonType leftObject = ((PolygonType) left);
            final PolygonType rightObject = ((PolygonType) right);
            {
                Boolean verticesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.vertices!= null)&&(!leftObject.vertices.isEmpty())), ((rightObject.vertices!= null)&&(!rightObject.vertices.isEmpty())));
                if (verticesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<VertexType> lhsVertices;
                    lhsVertices = (((leftObject.vertices!= null)&&(!leftObject.vertices.isEmpty()))?leftObject.getVertices():null);
                    List<VertexType> rhsVertices;
                    rhsVertices = (((rightObject.vertices!= null)&&(!rightObject.vertices.isEmpty()))?rightObject.getVertices():null);
                    List<VertexType> mergedVertices = ((List<VertexType> ) strategy.merge(LocatorUtils.property(leftLocator, "vertices", lhsVertices), LocatorUtils.property(rightLocator, "vertices", rhsVertices), lhsVertices, rhsVertices, ((leftObject.vertices!= null)&&(!leftObject.vertices.isEmpty())), ((rightObject.vertices!= null)&&(!rightObject.vertices.isEmpty()))));
                    target.vertices = null;
                    if (mergedVertices!= null) {
                        List<VertexType> uniqueVerticesl = target.getVertices();
                        uniqueVerticesl.addAll(mergedVertices);
                    }
                } else {
                    if (verticesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.vertices = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new PolygonType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType clone() {
        final PolygonType _newObject;
        _newObject = ((PolygonType) super.clone());
        if (this.vertices == null) {
            _newObject.vertices = null;
        } else {
            _newObject.vertices = new ArrayList<>();
            for (VertexType _item: this.vertices) {
                _newObject.vertices.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType createCopy() {
        final PolygonType _newObject = ((PolygonType) super.createCopy());
        if (this.vertices == null) {
            _newObject.vertices = null;
        } else {
            _newObject.vertices = new ArrayList<>();
            for (VertexType _item: this.vertices) {
                _newObject.vertices.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType _newObject = ((PolygonType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree verticesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vertices"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verticesPropertyTree!= null):((verticesPropertyTree == null)||(!verticesPropertyTree.isLeaf())))) {
            if (this.vertices == null) {
                _newObject.vertices = null;
            } else {
                _newObject.vertices = new ArrayList<>();
                for (VertexType _item: this.vertices) {
                    _newObject.vertices.add(((_item == null)?null:_item.createCopy(verticesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new PolygonType.Modifier();
        }
        return ((PolygonType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final PolygonType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.vertices == null) {
            _other.vertices = null;
        } else {
            _other.vertices = new ArrayList<>();
            for (VertexType _item: this.vertices) {
                _other.vertices.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >PolygonType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new PolygonType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> builder() {
        return new PolygonType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final StcBaseType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final RegionType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final ShapeType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final PolygonType _other) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final PolygonType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree verticesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vertices"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verticesPropertyTree!= null):((verticesPropertyTree == null)||(!verticesPropertyTree.isLeaf())))) {
            if (this.vertices == null) {
                _other.vertices = null;
            } else {
                _other.vertices = new ArrayList<>();
                for (VertexType _item: this.vertices) {
                    _other.vertices.add(((_item == null)?null:_item.newCopyBuilder(_other, verticesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >PolygonType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new PolygonType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >PolygonType.Builder<_B> copyOf(final PolygonType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PolygonType.Builder<_B> _newBuilder = new PolygonType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyExcept(final PolygonType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static PolygonType.Builder<Void> copyOnly(final PolygonType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public PolygonType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(PolygonType.PropInfo.VERTICES, this))&&(this.vertices!= null)) {
            for (VertexType _item_: this.vertices) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private List<VertexType.Builder<PolygonType.Builder<_B>>> vertices;

        public Builder(final _B _parentBuilder, final PolygonType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.vertices == null) {
                    this.vertices = null;
                } else {
                    this.vertices = new ArrayList<>();
                    for (VertexType _item: _other.vertices) {
                        this.vertices.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final PolygonType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree verticesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vertices"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verticesPropertyTree!= null):((verticesPropertyTree == null)||(!verticesPropertyTree.isLeaf())))) {
                    if (_other.vertices == null) {
                        this.vertices = null;
                    } else {
                        this.vertices = new ArrayList<>();
                        for (VertexType _item: _other.vertices) {
                            this.vertices.add(((_item == null)?null:_item.newCopyBuilder(this, verticesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends PolygonType >_P init(final _P _product) {
            if (this.vertices!= null) {
                final List<VertexType> vertices = new ArrayList<>(this.vertices.size());
                for (VertexType.Builder<PolygonType.Builder<_B>> _item: this.vertices) {
                    vertices.add(_item.build());
                }
                _product.vertices = vertices;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "vertices"
         * 
         * @param vertices
         *     Items to add to the value of the "vertices" property
         */
        public PolygonType.Builder<_B> addVertices(final Iterable<? extends VertexType> vertices) {
            if (vertices!= null) {
                if (this.vertices == null) {
                    this.vertices = new ArrayList<>();
                }
                for (VertexType _item: vertices) {
                    this.vertices.add(new VertexType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "vertices" (any previous value will be replaced)
         * 
         * @param vertices
         *     New value of the "vertices" property.
         */
        public PolygonType.Builder<_B> withVertices(final Iterable<? extends VertexType> vertices) {
            if (this.vertices!= null) {
                this.vertices.clear();
            }
            return addVertices(vertices);
        }

        /**
         * Adds the given items to the value of "vertices"
         * 
         * @param vertices
         *     Items to add to the value of the "vertices" property
         */
        public PolygonType.Builder<_B> addVertices(VertexType... vertices) {
            addVertices(Arrays.asList(vertices));
            return this;
        }

        /**
         * Sets the new value of "vertices" (any previous value will be replaced)
         * 
         * @param vertices
         *     New value of the "vertices" property.
         */
        public PolygonType.Builder<_B> withVertices(VertexType... vertices) {
            withVertices(Arrays.asList(vertices));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Vertices" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.VertexType.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Vertices" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.VertexType.Builder#end()} to return
         *     to the current builder.
         */
        public VertexType.Builder<? extends PolygonType.Builder<_B>> addVertices() {
            if (this.vertices == null) {
                this.vertices = new ArrayList<>();
            }
            final VertexType.Builder<PolygonType.Builder<_B>> vertices_Builder = new VertexType.Builder<>(this, null, false);
            this.vertices.add(vertices_Builder);
            return vertices_Builder;
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public PolygonType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends PolygonType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends PolygonType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public PolygonType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public PolygonType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public PolygonType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public PolygonType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public PolygonType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public PolygonType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public PolygonType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public PolygonType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public PolygonType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public PolygonType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public PolygonType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public PolygonType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public PolygonType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public PolygonType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public PolygonType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public PolygonType build() {
            if (_storedValue == null) {
                return this.init(new PolygonType());
            } else {
                return ((PolygonType) _storedValue);
            }
        }

        public PolygonType.Builder<_B> copyOf(final PolygonType _other) {
            _other.copyTo(this);
            return this;
        }

        public PolygonType.Builder<_B> copyOf(final PolygonType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public List<VertexType> getVertices() {
            if (PolygonType.this.vertices == null) {
                PolygonType.this.vertices = new ArrayList<>();
            }
            return PolygonType.this.vertices;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<PolygonType, VertexType> VERTICES = new CollectionPropertyInfo<PolygonType,VertexType>("vertices", PolygonType.class, VertexType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Vertex"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "vertexType"), false) {


            @Override
            public List<VertexType> get(final PolygonType _instance_) {
                return ((_instance_ == null)?null:_instance_.vertices);
            }

            @Override
            public void set(final PolygonType _instance_, final List<VertexType> _value_) {
                if (_instance_!= null) {
                    _instance_.vertices = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends PolygonType.Selector<PolygonType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static PolygonType.Select _root() {
            return new PolygonType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private VertexType.Selector<TRoot, PolygonType.Selector<TRoot, TParent>> vertices = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.vertices!= null) {
                products.put("vertices", this.vertices.init());
            }
            return products;
        }

        public VertexType.Selector<TRoot, PolygonType.Selector<TRoot, TParent>> vertices() {
            return ((this.vertices == null)?this.vertices = new VertexType.Selector<>(this._root, this, "vertices"):this.vertices);
        }

    }

}
