
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A spatial coordinate frame consists of a coordinate frame, a reference position, a flavor, and, optionally, an offset center
 * 
 * <p>Java class for spaceFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="spaceFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordFrameType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}SpaceRefFrame"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}ReferencePosition"/>
 *         <element name="OffsetCenter" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordValueType" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}CoordFlavor"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "spaceFrameType", propOrder = {
    "spaceRefFrame",
    "referencePosition",
    "offsetCenter",
    "coordFlavor"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class SpaceFrameType
    extends CoordFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Coordinate reference frame: optional equinox with either a standard reference system (ICRS, FK5, FK4) and optional standard pole (equatorial, ecliptic, galactic, etc.), or pole (positive Z-axis) and positive X-axis direction
     * 
     */
    @XmlElementRef(name = "SpaceRefFrame", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected JAXBElement<? extends CoordRefFrameType> spaceRefFrame;
    /**
     * Origin of the coordinate reference frame: either a "known place" such as geocenter or barycenter, or a position defined in a known coordinate system
     * 
     */
    @XmlElementRef(name = "ReferencePosition", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected JAXBElement<? extends ReferencePositionType> referencePosition;
    @XmlElement(name = "OffsetCenter")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected CoordValueType offsetCenter;
    /**
     * Provides the coordinate definitions: number of axes, SPHERICAL, CARTESIAN, UNITSPHERE, POLAR, or HEALPIX, presence of velocities
     * 
     */
    @XmlElementRef(name = "CoordFlavor", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected JAXBElement<? extends CoordFlavorType> coordFlavor;

    /**
     * Default no-arg constructor
     * 
     */
    public SpaceFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SpaceFrameType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final String name, final JAXBElement<? extends CoordRefFrameType> spaceRefFrame, final JAXBElement<? extends ReferencePositionType> referencePosition, final CoordValueType offsetCenter, final JAXBElement<? extends CoordFlavorType> coordFlavor) {
        super(id, idref, ucd, type, href, idType, idrefType, name);
        this.spaceRefFrame = spaceRefFrame;
        this.referencePosition = referencePosition;
        this.offsetCenter = offsetCenter;
        this.coordFlavor = coordFlavor;
    }

    /**
     * Coordinate reference frame: optional equinox with either a standard reference system (ICRS, FK5, FK4) and optional standard pole (equatorial, ecliptic, galactic, etc.), or pole (positive Z-axis) and positive X-axis direction
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link Cart1DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Cart2DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Cart3DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link GeodType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SphericalRefFrameType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public JAXBElement<? extends CoordRefFrameType> getSpaceRefFrame() {
        return spaceRefFrame;
    }

    /**
     * Sets the value of the spaceRefFrame property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link Cart1DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Cart2DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Cart3DRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordRefFrameType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link FkType }{@code >}
     *     {@link JAXBElement }{@code <}{@link GeodType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IcrsType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SphericalRefFrameType }{@code >}
     *     
     * @see #getSpaceRefFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setSpaceRefFrame(JAXBElement<? extends CoordRefFrameType> value) {
        this.spaceRefFrame = value;
    }

    /**
     * Origin of the coordinate reference frame: either a "known place" such as geocenter or barycenter, or a position defined in a known coordinate system
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public JAXBElement<? extends ReferencePositionType> getReferencePosition() {
        return referencePosition;
    }

    /**
     * Sets the value of the referencePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     * @see #getReferencePosition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setReferencePosition(JAXBElement<? extends ReferencePositionType> value) {
        this.referencePosition = value;
    }

    /**
     * Gets the value of the offsetCenter property.
     * 
     * @return
     *     possible object is
     *     {@link CoordValueType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordValueType getOffsetCenter() {
        return offsetCenter;
    }

    /**
     * Sets the value of the offsetCenter property.
     * 
     * @param value
     *     allowed object is
     *     {@link CoordValueType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setOffsetCenter(CoordValueType value) {
        this.offsetCenter = value;
    }

    /**
     * Provides the coordinate definitions: number of axes, SPHERICAL, CARTESIAN, UNITSPHERE, POLAR, or HEALPIX, presence of velocities
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link HealpixType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public JAXBElement<? extends CoordFlavorType> getCoordFlavor() {
        return coordFlavor;
    }

    /**
     * Sets the value of the coordFlavor property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordFlavorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link HealpixType }{@code >}
     *     
     * @see #getCoordFlavor()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setCoordFlavor(JAXBElement<? extends CoordFlavorType> value) {
        this.coordFlavor = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SpaceFrameType that = ((SpaceFrameType) object);
        {
            JAXBElement<? extends CoordRefFrameType> leftSpaceRefFrame;
            leftSpaceRefFrame = this.getSpaceRefFrame();
            JAXBElement<? extends CoordRefFrameType> rightSpaceRefFrame;
            rightSpaceRefFrame = that.getSpaceRefFrame();
            if (this.spaceRefFrame!= null) {
                if (that.spaceRefFrame!= null) {
                    {
                        final QName leftSpaceRefFrameName = leftSpaceRefFrame.getName();
                        final QName rightSpaceRefFrameName = rightSpaceRefFrame.getName();
                        if (leftSpaceRefFrameName!= null) {
                            if (rightSpaceRefFrameName!= null) {
                                if (!leftSpaceRefFrameName.equals(rightSpaceRefFrameName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightSpaceRefFrameName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final CoordRefFrameType leftSpaceRefFrameValue = leftSpaceRefFrame.getValue();
                        final CoordRefFrameType rightSpaceRefFrameValue = rightSpaceRefFrame.getValue();
                        if (leftSpaceRefFrameValue!= null) {
                            if (rightSpaceRefFrameValue!= null) {
                                if (!leftSpaceRefFrameValue.equals(rightSpaceRefFrameValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightSpaceRefFrameValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends CoordRefFrameType> leftSpaceRefFrameDeclaredType = leftSpaceRefFrame.getDeclaredType();
                        final Class<? extends CoordRefFrameType> rightSpaceRefFrameDeclaredType = rightSpaceRefFrame.getDeclaredType();
                        if (leftSpaceRefFrameDeclaredType!= null) {
                            if (rightSpaceRefFrameDeclaredType!= null) {
                                if (!leftSpaceRefFrameDeclaredType.equals(rightSpaceRefFrameDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightSpaceRefFrameDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftSpaceRefFrameScope = leftSpaceRefFrame.getScope();
                        final Class<?> rightSpaceRefFrameScope = rightSpaceRefFrame.getScope();
                        if (leftSpaceRefFrameScope!= null) {
                            if (rightSpaceRefFrameScope!= null) {
                                if (!leftSpaceRefFrameScope.equals(rightSpaceRefFrameScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightSpaceRefFrameScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftSpaceRefFrameNil = leftSpaceRefFrame.isNil();
                        final boolean rightSpaceRefFrameNil = rightSpaceRefFrame.isNil();
                        if (leftSpaceRefFrameNil!= rightSpaceRefFrameNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.spaceRefFrame!= null) {
                    return false;
                }
            }
        }
        {
            JAXBElement<? extends ReferencePositionType> leftReferencePosition;
            leftReferencePosition = this.getReferencePosition();
            JAXBElement<? extends ReferencePositionType> rightReferencePosition;
            rightReferencePosition = that.getReferencePosition();
            if (this.referencePosition!= null) {
                if (that.referencePosition!= null) {
                    {
                        final QName leftReferencePositionName = leftReferencePosition.getName();
                        final QName rightReferencePositionName = rightReferencePosition.getName();
                        if (leftReferencePositionName!= null) {
                            if (rightReferencePositionName!= null) {
                                if (!leftReferencePositionName.equals(rightReferencePositionName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final ReferencePositionType leftReferencePositionValue = leftReferencePosition.getValue();
                        final ReferencePositionType rightReferencePositionValue = rightReferencePosition.getValue();
                        if (leftReferencePositionValue!= null) {
                            if (rightReferencePositionValue!= null) {
                                if (!leftReferencePositionValue.equals(rightReferencePositionValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends ReferencePositionType> leftReferencePositionDeclaredType = leftReferencePosition.getDeclaredType();
                        final Class<? extends ReferencePositionType> rightReferencePositionDeclaredType = rightReferencePosition.getDeclaredType();
                        if (leftReferencePositionDeclaredType!= null) {
                            if (rightReferencePositionDeclaredType!= null) {
                                if (!leftReferencePositionDeclaredType.equals(rightReferencePositionDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftReferencePositionScope = leftReferencePosition.getScope();
                        final Class<?> rightReferencePositionScope = rightReferencePosition.getScope();
                        if (leftReferencePositionScope!= null) {
                            if (rightReferencePositionScope!= null) {
                                if (!leftReferencePositionScope.equals(rightReferencePositionScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftReferencePositionNil = leftReferencePosition.isNil();
                        final boolean rightReferencePositionNil = rightReferencePosition.isNil();
                        if (leftReferencePositionNil!= rightReferencePositionNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencePosition!= null) {
                    return false;
                }
            }
        }
        {
            CoordValueType leftOffsetCenter;
            leftOffsetCenter = this.getOffsetCenter();
            CoordValueType rightOffsetCenter;
            rightOffsetCenter = that.getOffsetCenter();
            if (this.offsetCenter!= null) {
                if (that.offsetCenter!= null) {
                    if (!leftOffsetCenter.equals(rightOffsetCenter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.offsetCenter!= null) {
                    return false;
                }
            }
        }
        {
            JAXBElement<? extends CoordFlavorType> leftCoordFlavor;
            leftCoordFlavor = this.getCoordFlavor();
            JAXBElement<? extends CoordFlavorType> rightCoordFlavor;
            rightCoordFlavor = that.getCoordFlavor();
            if (this.coordFlavor!= null) {
                if (that.coordFlavor!= null) {
                    {
                        final QName leftCoordFlavorName = leftCoordFlavor.getName();
                        final QName rightCoordFlavorName = rightCoordFlavor.getName();
                        if (leftCoordFlavorName!= null) {
                            if (rightCoordFlavorName!= null) {
                                if (!leftCoordFlavorName.equals(rightCoordFlavorName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightCoordFlavorName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final CoordFlavorType leftCoordFlavorValue = leftCoordFlavor.getValue();
                        final CoordFlavorType rightCoordFlavorValue = rightCoordFlavor.getValue();
                        if (leftCoordFlavorValue!= null) {
                            if (rightCoordFlavorValue!= null) {
                                if (!leftCoordFlavorValue.equals(rightCoordFlavorValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightCoordFlavorValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends CoordFlavorType> leftCoordFlavorDeclaredType = leftCoordFlavor.getDeclaredType();
                        final Class<? extends CoordFlavorType> rightCoordFlavorDeclaredType = rightCoordFlavor.getDeclaredType();
                        if (leftCoordFlavorDeclaredType!= null) {
                            if (rightCoordFlavorDeclaredType!= null) {
                                if (!leftCoordFlavorDeclaredType.equals(rightCoordFlavorDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightCoordFlavorDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftCoordFlavorScope = leftCoordFlavor.getScope();
                        final Class<?> rightCoordFlavorScope = rightCoordFlavor.getScope();
                        if (leftCoordFlavorScope!= null) {
                            if (rightCoordFlavorScope!= null) {
                                if (!leftCoordFlavorScope.equals(rightCoordFlavorScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightCoordFlavorScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftCoordFlavorNil = leftCoordFlavor.isNil();
                        final boolean rightCoordFlavorNil = rightCoordFlavor.isNil();
                        if (leftCoordFlavorNil!= rightCoordFlavorNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.coordFlavor!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends CoordRefFrameType> theSpaceRefFrame;
            theSpaceRefFrame = this.getSpaceRefFrame();
            if (this.spaceRefFrame!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theSpaceRefFrameName = theSpaceRefFrame.getName();
                    if (theSpaceRefFrameName!= null) {
                        currentHashCode += theSpaceRefFrameName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final CoordRefFrameType theSpaceRefFrameValue = theSpaceRefFrame.getValue();
                    if (theSpaceRefFrameValue!= null) {
                        currentHashCode += theSpaceRefFrameValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends CoordRefFrameType> theSpaceRefFrameDeclaredType = theSpaceRefFrame.getDeclaredType();
                    if (theSpaceRefFrameDeclaredType!= null) {
                        currentHashCode += theSpaceRefFrameDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theSpaceRefFrameScope = theSpaceRefFrame.getScope();
                    if (theSpaceRefFrameScope!= null) {
                        currentHashCode += theSpaceRefFrameScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theSpaceRefFrameNil = theSpaceRefFrame.isNil();
                    currentHashCode += (theSpaceRefFrameNil? 1231 : 1237);
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            if (this.referencePosition!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theReferencePositionName = theReferencePosition.getName();
                    if (theReferencePositionName!= null) {
                        currentHashCode += theReferencePositionName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final ReferencePositionType theReferencePositionValue = theReferencePosition.getValue();
                    if (theReferencePositionValue!= null) {
                        currentHashCode += theReferencePositionValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends ReferencePositionType> theReferencePositionDeclaredType = theReferencePosition.getDeclaredType();
                    if (theReferencePositionDeclaredType!= null) {
                        currentHashCode += theReferencePositionDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theReferencePositionScope = theReferencePosition.getScope();
                    if (theReferencePositionScope!= null) {
                        currentHashCode += theReferencePositionScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theReferencePositionNil = theReferencePosition.isNil();
                    currentHashCode += (theReferencePositionNil? 1231 : 1237);
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            CoordValueType theOffsetCenter;
            theOffsetCenter = this.getOffsetCenter();
            if (this.offsetCenter!= null) {
                currentHashCode += theOffsetCenter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends CoordFlavorType> theCoordFlavor;
            theCoordFlavor = this.getCoordFlavor();
            if (this.coordFlavor!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theCoordFlavorName = theCoordFlavor.getName();
                    if (theCoordFlavorName!= null) {
                        currentHashCode += theCoordFlavorName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final CoordFlavorType theCoordFlavorValue = theCoordFlavor.getValue();
                    if (theCoordFlavorValue!= null) {
                        currentHashCode += theCoordFlavorValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends CoordFlavorType> theCoordFlavorDeclaredType = theCoordFlavor.getDeclaredType();
                    if (theCoordFlavorDeclaredType!= null) {
                        currentHashCode += theCoordFlavorDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theCoordFlavorScope = theCoordFlavor.getScope();
                    if (theCoordFlavorScope!= null) {
                        currentHashCode += theCoordFlavorScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theCoordFlavorNil = theCoordFlavor.isNil();
                    currentHashCode += (theCoordFlavorNil? 1231 : 1237);
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            JAXBElement<? extends CoordRefFrameType> theSpaceRefFrame;
            theSpaceRefFrame = this.getSpaceRefFrame();
            strategy.appendField(locator, this, "spaceRefFrame", buffer, theSpaceRefFrame, (this.spaceRefFrame!= null));
        }
        {
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            strategy.appendField(locator, this, "referencePosition", buffer, theReferencePosition, (this.referencePosition!= null));
        }
        {
            CoordValueType theOffsetCenter;
            theOffsetCenter = this.getOffsetCenter();
            strategy.appendField(locator, this, "offsetCenter", buffer, theOffsetCenter, (this.offsetCenter!= null));
        }
        {
            JAXBElement<? extends CoordFlavorType> theCoordFlavor;
            theCoordFlavor = this.getCoordFlavor();
            strategy.appendField(locator, this, "coordFlavor", buffer, theCoordFlavor, (this.coordFlavor!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SpaceFrameType) {
            final SpaceFrameType target = this;
            final SpaceFrameType leftObject = ((SpaceFrameType) left);
            final SpaceFrameType rightObject = ((SpaceFrameType) right);
            {
                Boolean spaceRefFrameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.spaceRefFrame!= null), (rightObject.spaceRefFrame!= null));
                if (spaceRefFrameShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends CoordRefFrameType> lhsSpaceRefFrame;
                    lhsSpaceRefFrame = leftObject.getSpaceRefFrame();
                    JAXBElement<? extends CoordRefFrameType> rhsSpaceRefFrame;
                    rhsSpaceRefFrame = rightObject.getSpaceRefFrame();
                    JAXBElement<? extends CoordRefFrameType> mergedSpaceRefFrame = ((JAXBElement<? extends CoordRefFrameType> ) strategy.merge(LocatorUtils.property(leftLocator, "spaceRefFrame", lhsSpaceRefFrame), LocatorUtils.property(rightLocator, "spaceRefFrame", rhsSpaceRefFrame), lhsSpaceRefFrame, rhsSpaceRefFrame, (leftObject.spaceRefFrame!= null), (rightObject.spaceRefFrame!= null)));
                    target.setSpaceRefFrame(mergedSpaceRefFrame);
                } else {
                    if (spaceRefFrameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spaceRefFrame = null;
                    }
                }
            }
            {
                Boolean referencePositionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null));
                if (referencePositionShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends ReferencePositionType> lhsReferencePosition;
                    lhsReferencePosition = leftObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> rhsReferencePosition;
                    rhsReferencePosition = rightObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> mergedReferencePosition = ((JAXBElement<? extends ReferencePositionType> ) strategy.merge(LocatorUtils.property(leftLocator, "referencePosition", lhsReferencePosition), LocatorUtils.property(rightLocator, "referencePosition", rhsReferencePosition), lhsReferencePosition, rhsReferencePosition, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null)));
                    target.setReferencePosition(mergedReferencePosition);
                } else {
                    if (referencePositionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.referencePosition = null;
                    }
                }
            }
            {
                Boolean offsetCenterShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.offsetCenter!= null), (rightObject.offsetCenter!= null));
                if (offsetCenterShouldBeMergedAndSet == Boolean.TRUE) {
                    CoordValueType lhsOffsetCenter;
                    lhsOffsetCenter = leftObject.getOffsetCenter();
                    CoordValueType rhsOffsetCenter;
                    rhsOffsetCenter = rightObject.getOffsetCenter();
                    CoordValueType mergedOffsetCenter = ((CoordValueType) strategy.merge(LocatorUtils.property(leftLocator, "offsetCenter", lhsOffsetCenter), LocatorUtils.property(rightLocator, "offsetCenter", rhsOffsetCenter), lhsOffsetCenter, rhsOffsetCenter, (leftObject.offsetCenter!= null), (rightObject.offsetCenter!= null)));
                    target.setOffsetCenter(mergedOffsetCenter);
                } else {
                    if (offsetCenterShouldBeMergedAndSet == Boolean.FALSE) {
                        target.offsetCenter = null;
                    }
                }
            }
            {
                Boolean coordFlavorShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.coordFlavor!= null), (rightObject.coordFlavor!= null));
                if (coordFlavorShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends CoordFlavorType> lhsCoordFlavor;
                    lhsCoordFlavor = leftObject.getCoordFlavor();
                    JAXBElement<? extends CoordFlavorType> rhsCoordFlavor;
                    rhsCoordFlavor = rightObject.getCoordFlavor();
                    JAXBElement<? extends CoordFlavorType> mergedCoordFlavor = ((JAXBElement<? extends CoordFlavorType> ) strategy.merge(LocatorUtils.property(leftLocator, "coordFlavor", lhsCoordFlavor), LocatorUtils.property(rightLocator, "coordFlavor", rhsCoordFlavor), lhsCoordFlavor, rhsCoordFlavor, (leftObject.coordFlavor!= null), (rightObject.coordFlavor!= null)));
                    target.setCoordFlavor(mergedCoordFlavor);
                } else {
                    if (coordFlavorShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coordFlavor = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new SpaceFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType clone() {
        final SpaceFrameType _newObject;
        _newObject = ((SpaceFrameType) super.clone());
        _newObject.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType createCopy() {
        final SpaceFrameType _newObject = ((SpaceFrameType) super.createCopy());
        _newObject.spaceRefFrame = this.spaceRefFrame;
        _newObject.referencePosition = this.referencePosition;
        _newObject.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.createCopy());
        _newObject.coordFlavor = this.coordFlavor;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpaceFrameType _newObject = ((SpaceFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree spaceRefFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceRefFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceRefFramePropertyTree!= null):((spaceRefFramePropertyTree == null)||(!spaceRefFramePropertyTree.isLeaf())))) {
            _newObject.spaceRefFrame = this.spaceRefFrame;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _newObject.referencePosition = this.referencePosition;
        }
        final PropertyTree offsetCenterPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offsetCenter"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetCenterPropertyTree!= null):((offsetCenterPropertyTree == null)||(!offsetCenterPropertyTree.isLeaf())))) {
            _newObject.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.createCopy(offsetCenterPropertyTree, _propertyTreeUse));
        }
        final PropertyTree coordFlavorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFlavor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFlavorPropertyTree!= null):((coordFlavorPropertyTree == null)||(!coordFlavorPropertyTree.isLeaf())))) {
            _newObject.coordFlavor = this.coordFlavor;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SpaceFrameType.Modifier();
        }
        return ((SpaceFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SpaceFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.spaceRefFrame = this.spaceRefFrame;
        _other.referencePosition = this.referencePosition;
        _other.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.newCopyBuilder(_other));
        _other.coordFlavor = this.coordFlavor;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SpaceFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SpaceFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> builder() {
        return new SpaceFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final StcBaseType _other) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final CoordFrameType _other) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final SpaceFrameType _other) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SpaceFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree spaceRefFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceRefFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceRefFramePropertyTree!= null):((spaceRefFramePropertyTree == null)||(!spaceRefFramePropertyTree.isLeaf())))) {
            _other.spaceRefFrame = this.spaceRefFrame;
        }
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _other.referencePosition = this.referencePosition;
        }
        final PropertyTree offsetCenterPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offsetCenter"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetCenterPropertyTree!= null):((offsetCenterPropertyTree == null)||(!offsetCenterPropertyTree.isLeaf())))) {
            _other.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.newCopyBuilder(_other, offsetCenterPropertyTree, _propertyTreeUse));
        }
        final PropertyTree coordFlavorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFlavor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFlavorPropertyTree!= null):((coordFlavorPropertyTree == null)||(!coordFlavorPropertyTree.isLeaf())))) {
            _other.coordFlavor = this.coordFlavor;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SpaceFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SpaceFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final CoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SpaceFrameType.Builder<_B> copyOf(final SpaceFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpaceFrameType.Builder<_B> _newBuilder = new SpaceFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyExcept(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyExcept(final SpaceFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyOnly(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SpaceFrameType.Builder<Void> copyOnly(final SpaceFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(SpaceFrameType.PropInfo.SPACE_REF_FRAME, this))&&(this.spaceRefFrame!= null)) {
            this.spaceRefFrame.getValue().visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SpaceFrameType.PropInfo.REFERENCE_POSITION, this))&&(this.referencePosition!= null)) {
            this.referencePosition.getValue().visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SpaceFrameType.PropInfo.OFFSET_CENTER, this))&&(this.offsetCenter!= null)) {
            this.offsetCenter.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SpaceFrameType.PropInfo.COORD_FLAVOR, this))&&(this.coordFlavor!= null)) {
            this.coordFlavor.getValue().visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordFrameType.Builder<_B>
        implements Buildable
    {

        private JAXBElement<? extends CoordRefFrameType> spaceRefFrame;
        private JAXBElement<? extends ReferencePositionType> referencePosition;
        private CoordValueType.Builder<SpaceFrameType.Builder<_B>> offsetCenter;
        private JAXBElement<? extends CoordFlavorType> coordFlavor;

        public Builder(final _B _parentBuilder, final SpaceFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.spaceRefFrame = _other.spaceRefFrame;
                this.referencePosition = _other.referencePosition;
                this.offsetCenter = ((_other.offsetCenter == null)?null:_other.offsetCenter.newCopyBuilder(this));
                this.coordFlavor = _other.coordFlavor;
            }
        }

        public Builder(final _B _parentBuilder, final SpaceFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree spaceRefFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceRefFrame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceRefFramePropertyTree!= null):((spaceRefFramePropertyTree == null)||(!spaceRefFramePropertyTree.isLeaf())))) {
                    this.spaceRefFrame = _other.spaceRefFrame;
                }
                final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
                    this.referencePosition = _other.referencePosition;
                }
                final PropertyTree offsetCenterPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("offsetCenter"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(offsetCenterPropertyTree!= null):((offsetCenterPropertyTree == null)||(!offsetCenterPropertyTree.isLeaf())))) {
                    this.offsetCenter = ((_other.offsetCenter == null)?null:_other.offsetCenter.newCopyBuilder(this, offsetCenterPropertyTree, _propertyTreeUse));
                }
                final PropertyTree coordFlavorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFlavor"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFlavorPropertyTree!= null):((coordFlavorPropertyTree == null)||(!coordFlavorPropertyTree.isLeaf())))) {
                    this.coordFlavor = _other.coordFlavor;
                }
            }
        }

        protected<_P extends SpaceFrameType >_P init(final _P _product) {
            _product.spaceRefFrame = this.spaceRefFrame;
            _product.referencePosition = this.referencePosition;
            _product.offsetCenter = ((this.offsetCenter == null)?null:this.offsetCenter.build());
            _product.coordFlavor = this.coordFlavor;
            return super.init(_product);
        }

        /**
         * Sets the new value of "spaceRefFrame" (any previous value will be replaced)
         * 
         * @param spaceRefFrame
         *     New value of the "spaceRefFrame" property.
         */
        public SpaceFrameType.Builder<_B> withSpaceRefFrame(final JAXBElement<? extends CoordRefFrameType> spaceRefFrame) {
            this.spaceRefFrame = spaceRefFrame;
            return this;
        }

        /**
         * Sets the new value of "referencePosition" (any previous value will be replaced)
         * 
         * @param referencePosition
         *     New value of the "referencePosition" property.
         */
        public SpaceFrameType.Builder<_B> withReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            this.referencePosition = referencePosition;
            return this;
        }

        /**
         * Sets the new value of "offsetCenter" (any previous value will be replaced)
         * 
         * @param offsetCenter
         *     New value of the "offsetCenter" property.
         */
        public SpaceFrameType.Builder<_B> withOffsetCenter(final CoordValueType offsetCenter) {
            this.offsetCenter = ((offsetCenter == null)?null:new CoordValueType.Builder<>(this, offsetCenter, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "offsetCenter" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.CoordValueType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "offsetCenter" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.CoordValueType.Builder#end()} to
         *     return to the current builder.
         */
        public CoordValueType.Builder<? extends SpaceFrameType.Builder<_B>> withOffsetCenter() {
            if (this.offsetCenter!= null) {
                return this.offsetCenter;
            }
            return this.offsetCenter = new CoordValueType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "coordFlavor" (any previous value will be replaced)
         * 
         * @param coordFlavor
         *     New value of the "coordFlavor" property.
         */
        public SpaceFrameType.Builder<_B> withCoordFlavor(final JAXBElement<? extends CoordFlavorType> coordFlavor) {
            this.coordFlavor = coordFlavor;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public SpaceFrameType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public SpaceFrameType build() {
            if (_storedValue == null) {
                return this.init(new SpaceFrameType());
            } else {
                return ((SpaceFrameType) _storedValue);
            }
        }

        public SpaceFrameType.Builder<_B> copyOf(final SpaceFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public SpaceFrameType.Builder<_B> copyOf(final SpaceFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordFrameType.Modifier
    {


        public void setSpaceRefFrame(final JAXBElement<? extends CoordRefFrameType> spaceRefFrame) {
            SpaceFrameType.this.setSpaceRefFrame(spaceRefFrame);
        }

        public void setReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            SpaceFrameType.this.setReferencePosition(referencePosition);
        }

        public void setOffsetCenter(final CoordValueType offsetCenter) {
            SpaceFrameType.this.setOffsetCenter(offsetCenter);
        }

        public void setCoordFlavor(final JAXBElement<? extends CoordFlavorType> coordFlavor) {
            SpaceFrameType.this.setCoordFlavor(coordFlavor);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SpaceFrameType, CoordRefFrameType> SPACE_REF_FRAME = new SinglePropertyInfo<SpaceFrameType,CoordRefFrameType>("spaceRefFrame", SpaceFrameType.class, CoordRefFrameType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SpaceRefFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordRefFrameType"), false) {


            @Override
            public CoordRefFrameType get(final SpaceFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.spaceRefFrame == null)?null:_instance_.spaceRefFrame.getValue()));
            }

            @Override
            public void set(final SpaceFrameType _instance_, final CoordRefFrameType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SpaceFrameType, ReferencePositionType> REFERENCE_POSITION = new SinglePropertyInfo<SpaceFrameType,ReferencePositionType>("referencePosition", SpaceFrameType.class, ReferencePositionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ReferencePosition"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "referencePositionType"), false) {


            @Override
            public ReferencePositionType get(final SpaceFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.referencePosition == null)?null:_instance_.referencePosition.getValue()));
            }

            @Override
            public void set(final SpaceFrameType _instance_, final ReferencePositionType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SpaceFrameType, CoordValueType> OFFSET_CENTER = new SinglePropertyInfo<SpaceFrameType,CoordValueType>("offsetCenter", SpaceFrameType.class, CoordValueType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "OffsetCenter"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordValueType"), false) {


            @Override
            public CoordValueType get(final SpaceFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.offsetCenter);
            }

            @Override
            public void set(final SpaceFrameType _instance_, final CoordValueType _value_) {
                if (_instance_!= null) {
                    _instance_.offsetCenter = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SpaceFrameType, CoordFlavorType> COORD_FLAVOR = new SinglePropertyInfo<SpaceFrameType,CoordFlavorType>("coordFlavor", SpaceFrameType.class, CoordFlavorType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "CoordFlavor"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordFlavorType"), false) {


            @Override
            public CoordFlavorType get(final SpaceFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.coordFlavor == null)?null:_instance_.coordFlavor.getValue()));
            }

            @Override
            public void set(final SpaceFrameType _instance_, final CoordFlavorType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;

    }

    public static class Select
        extends SpaceFrameType.Selector<SpaceFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SpaceFrameType.Select _root() {
            return new SpaceFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordFrameType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> spaceRefFrame = null;
        private com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> referencePosition = null;
        private CoordValueType.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> offsetCenter = null;
        private com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> coordFlavor = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.spaceRefFrame!= null) {
                products.put("spaceRefFrame", this.spaceRefFrame.init());
            }
            if (this.referencePosition!= null) {
                products.put("referencePosition", this.referencePosition.init());
            }
            if (this.offsetCenter!= null) {
                products.put("offsetCenter", this.offsetCenter.init());
            }
            if (this.coordFlavor!= null) {
                products.put("coordFlavor", this.coordFlavor.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> spaceRefFrame() {
            return ((this.spaceRefFrame == null)?this.spaceRefFrame = new com.kscs.util.jaxb.Selector<>(this._root, this, "spaceRefFrame"):this.spaceRefFrame);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> referencePosition() {
            return ((this.referencePosition == null)?this.referencePosition = new com.kscs.util.jaxb.Selector<>(this._root, this, "referencePosition"):this.referencePosition);
        }

        public CoordValueType.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> offsetCenter() {
            return ((this.offsetCenter == null)?this.offsetCenter = new CoordValueType.Selector<>(this._root, this, "offsetCenter"):this.offsetCenter);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpaceFrameType.Selector<TRoot, TParent>> coordFlavor() {
            return ((this.coordFlavor == null)?this.coordFlavor = new com.kscs.util.jaxb.Selector<>(this._root, this, "coordFlavor"):this.coordFlavor);
        }

    }

}
