
package org.javastro.ivoa.entities.stc.v1;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * Spectral units may be frequency (Hz, kHz, MHz, GHz), wavelength (meters, mm, micron, nm, Angstrom), or energy (eV, keV, MeV, GeV, TeV)
 * 
 * <p>Java class for spectralUnitType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="spectralUnitType">
 *   <restriction base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}unitType">
 *     <enumeration value="Hz"/>
 *     <enumeration value="kHz"/>
 *     <enumeration value="MHz"/>
 *     <enumeration value="GHz"/>
 *     <enumeration value="m"/>
 *     <enumeration value="mm"/>
 *     <enumeration value="um"/>
 *     <enumeration value="nm"/>
 *     <enumeration value="Angstrom"/>
 *     <enumeration value="eV"/>
 *     <enumeration value="keV"/>
 *     <enumeration value="MeV"/>
 *     <enumeration value="GeV"/>
 *     <enumeration value="TeV"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "spectralUnitType")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public enum SpectralUnitType implements EnumValue<String>
{

    @XmlEnumValue("Hz")
    HZ("Hz"),
    @XmlEnumValue("kHz")
    K_HZ("kHz"),
    @XmlEnumValue("MHz")
    M_HZ("MHz"),
    @XmlEnumValue("GHz")
    G_HZ("GHz"),
    @XmlEnumValue("m")
    M("m"),
    @XmlEnumValue("mm")
    MM("mm"),
    @XmlEnumValue("um")
    UM("um"),
    @XmlEnumValue("nm")
    NM("nm"),
    @XmlEnumValue("Angstrom")
    ANGSTROM("Angstrom"),
    @XmlEnumValue("eV")
    E_V("eV"),
    @XmlEnumValue("keV")
    KE_V("keV"),
    @XmlEnumValue("MeV")
    ME_V("MeV"),
    @XmlEnumValue("GeV")
    GE_V("GeV"),
    @XmlEnumValue("TeV")
    TE_V("TeV");
    private final String value;

    SpectralUnitType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SpectralUnitType fromValue(String v) {
        for (SpectralUnitType c: SpectralUnitType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
