
package org.javastro.ivoa.entities.uws;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * Enumeration of possible phases of job execution
 * 
 * <p>Java class for ExecutionPhase</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="ExecutionPhase">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="PENDING"/>
 *     <enumeration value="QUEUED"/>
 *     <enumeration value="EXECUTING"/>
 *     <enumeration value="COMPLETED"/>
 *     <enumeration value="ERROR"/>
 *     <enumeration value="UNKNOWN"/>
 *     <enumeration value="HELD"/>
 *     <enumeration value="SUSPENDED"/>
 *     <enumeration value="ABORTED"/>
 *     <enumeration value="ARCHIVED"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ExecutionPhase")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public enum ExecutionPhase implements EnumValue<String>
{


    /**
     * The first phase a job is entered into - this is where
     *                   a job is being set up but no request to run has
     *                   occurred.
     * 
     */
    PENDING,

    /**
     * A job has been accepted for execution but is waiting
     *                   in a queue
     * 
     */
    QUEUED,

    /**
     * A job is running
     * 
     */
    EXECUTING,

    /**
     * A job has completed successfully
     * 
     */
    COMPLETED,

    /**
     * Some form of error has occurred
     * 
     */
    ERROR,

    /**
     * The job is in an unknown state.
     * 
     */
    UNKNOWN,

    /**
     * The job is HELD pending execution and will not
     *                   automatically be executed - can occur after a
     *                   PHASE=RUN request has been made (cf PENDING).
     * 
     */
    HELD,

    /**
     * The job has been suspended by the system during
     *                   execution
     * 
     */
    SUSPENDED,

    /**
     * The job has been aborted, either by user request or by
     *                   the server because of lack or overuse of resources.
     * 
     */
    ABORTED,

    /**
     * The job has been archived by the server at destruction time. An archived job
     *                   may have deleted the results to reclaim resources, but must have job metadata preserved.
     *                   This is an alternative that the server may choose in contrast to completely destroying all record of the job.
     * 
     */
    ARCHIVED;

    public String value() {
        return name();
    }

    public static ExecutionPhase fromValue(String v) {
        return valueOf(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
