
package org.javastro.ivoa.entities.vodml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * This type implements a composition relation between the parent and child ObjectTypes.
 *           Its instances are ONLY used to set the composition field on an ObjectType.
 *           It is a rule that an object type can only be the target of a single composition definition.
 *           A subclass can be assigned a target to a composition if a
 *         baseclass is already assigned such a target, but only if the composition is explicitly 'subsetted'.
 *         A composition is assumed to be a set, i.e.
 *         a given object (as identified by its identifier!) cannot occur
 *         multiple times in the composition.
 *         The composition
 *         may be ordered, which implies that the order in which objects have been added
 *         to
 *         the parent is to be preserved. As clients can always do an explicit sort on any of the child objects' attributes,
 *         it seems not necessary to add functionality for
 *         declaring a composition is
 *         sorted on one or more attributes.
 *         Through the uniqueInCollection constraint that can be assigned to attributes, a composition can impose the
 *         constraint that different objects in the composition
 *         must have distinct values of the
 *         attribute to which that constraint is assigned.
 *         It would be better probably to add the capability to assign such constraints to this composition type.
 *         This would
 *         also give more flexibility in for example creating explicit (named) keys, or defining
 *         multi-attribute uniqueness constraints.
 * 
 * <p>Java class for Composition complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Composition">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VODML/v1}Relation">
 *       <sequence>
 *         <element name="isOrdered" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Composition", propOrder = {
    "isOrdered"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Composition
    extends Relation
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * If true, this composition preserves the ordering of object insertions.
     * 
     */
    @XmlElement(defaultValue = "false")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Boolean isOrdered = false;

    /**
     * Default no-arg constructor
     * 
     */
    public Composition() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Composition(final String vodmlId, final String name, final String description, final String id, final ElementRef datatype, final Multiplicity multiplicity, final Boolean isOrdered) {
        super(vodmlId, name, description, id, datatype, multiplicity);
        this.isOrdered = isOrdered;
    }

    /**
     * If true, this composition preserves the ordering of object insertions.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Boolean isIsOrdered() {
        return isOrdered;
    }

    /**
     * Sets the value of the isOrdered property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isIsOrdered()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setIsOrdered(Boolean value) {
        this.isOrdered = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Composition that = ((Composition) object);
        {
            Boolean leftIsOrdered;
            leftIsOrdered = this.isIsOrdered();
            Boolean rightIsOrdered;
            rightIsOrdered = that.isIsOrdered();
            if (this.isOrdered!= null) {
                if (that.isOrdered!= null) {
                    if (!leftIsOrdered.equals(rightIsOrdered)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.isOrdered!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Boolean theIsOrdered;
            theIsOrdered = this.isIsOrdered();
            if (this.isOrdered!= null) {
                currentHashCode += theIsOrdered.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Boolean theIsOrdered;
            theIsOrdered = this.isIsOrdered();
            strategy.appendField(locator, this, "isOrdered", buffer, theIsOrdered, (this.isOrdered!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Composition) {
            final Composition target = this;
            final Composition leftObject = ((Composition) left);
            final Composition rightObject = ((Composition) right);
            {
                Boolean isOrderedShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.isOrdered!= null), (rightObject.isOrdered!= null));
                if (isOrderedShouldBeMergedAndSet == Boolean.TRUE) {
                    Boolean lhsIsOrdered;
                    lhsIsOrdered = leftObject.isIsOrdered();
                    Boolean rhsIsOrdered;
                    rhsIsOrdered = rightObject.isIsOrdered();
                    Boolean mergedIsOrdered = ((Boolean) strategy.merge(LocatorUtils.property(leftLocator, "isOrdered", lhsIsOrdered), LocatorUtils.property(rightLocator, "isOrdered", rhsIsOrdered), lhsIsOrdered, rhsIsOrdered, (leftObject.isOrdered!= null), (rightObject.isOrdered!= null)));
                    target.setIsOrdered(mergedIsOrdered);
                } else {
                    if (isOrderedShouldBeMergedAndSet == Boolean.FALSE) {
                        target.isOrdered = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Composition();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition clone() {
        final Composition _newObject;
        _newObject = ((Composition) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition createCopy() {
        final Composition _newObject = ((Composition) super.createCopy());
        _newObject.isOrdered = this.isOrdered;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Composition _newObject = ((Composition) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree isOrderedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("isOrdered"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(isOrderedPropertyTree!= null):((isOrderedPropertyTree == null)||(!isOrderedPropertyTree.isLeaf())))) {
            _newObject.isOrdered = this.isOrdered;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Composition.Modifier();
        }
        return ((Composition.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Composition.Builder<_B> _other) {
        super.copyTo(_other);
        _other.isOrdered = this.isOrdered;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Composition.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Composition.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> builder() {
        return new Composition.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final ReferableElement _other) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Role _other) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Relation _other) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Composition _other) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Composition.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree isOrderedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("isOrdered"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(isOrderedPropertyTree!= null):((isOrderedPropertyTree == null)||(!isOrderedPropertyTree.isLeaf())))) {
            _other.isOrdered = this.isOrdered;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Composition.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Composition.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final ReferableElement _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Role _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Relation _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Composition.Builder<_B> copyOf(final Composition _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Composition.Builder<_B> _newBuilder = new Composition.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyExcept(final ReferableElement _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyExcept(final Role _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyExcept(final Relation _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyExcept(final Composition _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyOnly(final ReferableElement _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyOnly(final Role _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyOnly(final Relation _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Composition.Builder<Void> copyOnly(final Composition _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Composition visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(Composition.PropInfo.IS_ORDERED, this));
        return this;
    }

    public static class Builder<_B >
        extends Relation.Builder<_B>
        implements Buildable
    {

        private Boolean isOrdered;

        public Builder(final _B _parentBuilder, final Composition _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.isOrdered = _other.isOrdered;
            }
        }

        public Builder(final _B _parentBuilder, final Composition _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree isOrderedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("isOrdered"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(isOrderedPropertyTree!= null):((isOrderedPropertyTree == null)||(!isOrderedPropertyTree.isLeaf())))) {
                    this.isOrdered = _other.isOrdered;
                }
            }
        }

        protected<_P extends Composition >_P init(final _P _product) {
            _product.isOrdered = this.isOrdered;
            return super.init(_product);
        }

        /**
         * Sets the new value of "isOrdered" (any previous value will be replaced)
         * 
         * @param isOrdered
         *     New value of the "isOrdered" property.
         */
        public Composition.Builder<_B> withIsOrdered(final Boolean isOrdered) {
            this.isOrdered = isOrdered;
            return this;
        }

        /**
         * Sets the new value of "datatype" (any previous value will be replaced)
         * 
         * @param datatype
         *     New value of the "datatype" property.
         */
        @Override
        public Composition.Builder<_B> withDatatype(final ElementRef datatype) {
            super.withDatatype(datatype);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "datatype" property.
         * Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "datatype" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.ElementRef.Builder#end()} to return
         *     to the current builder.
         */
        public ElementRef.Builder<? extends Composition.Builder<_B>> withDatatype() {
            return ((ElementRef.Builder<? extends Composition.Builder<_B>> ) super.withDatatype());
        }

        /**
         * Sets the new value of "multiplicity" (any previous value will be replaced)
         * 
         * @param multiplicity
         *     New value of the "multiplicity" property.
         */
        @Override
        public Composition.Builder<_B> withMultiplicity(final Multiplicity multiplicity) {
            super.withMultiplicity(multiplicity);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "multiplicity" property.
         * Use {@link org.javastro.ivoa.entities.vodml.Multiplicity.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "multiplicity" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.Multiplicity.Builder#end()} to
         *     return to the current builder.
         */
        public Multiplicity.Builder<? extends Composition.Builder<_B>> withMultiplicity() {
            return ((Multiplicity.Builder<? extends Composition.Builder<_B>> ) super.withMultiplicity());
        }

        /**
         * Sets the new value of "vodmlId" (any previous value will be replaced)
         * 
         * @param vodmlId
         *     New value of the "vodmlId" property.
         */
        @Override
        public Composition.Builder<_B> withVodmlId(final String vodmlId) {
            super.withVodmlId(vodmlId);
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public Composition.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public Composition.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public Composition.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        @Override
        public Composition build() {
            if (_storedValue == null) {
                return this.init(new Composition());
            } else {
                return ((Composition) _storedValue);
            }
        }

        public Composition.Builder<_B> copyOf(final Composition _other) {
            _other.copyTo(this);
            return this;
        }

        public Composition.Builder<_B> copyOf(final Composition.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Relation.Modifier
    {


        public void setIsOrdered(final Boolean isOrdered) {
            Composition.this.setIsOrdered(isOrdered);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Composition, Boolean> IS_ORDERED = new SinglePropertyInfo<Composition,Boolean>("isOrdered", Composition.class, Boolean.class, false, null, new QName("", "isOrdered"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), false) {


            @Override
            public Boolean get(final Composition _instance_) {
                return ((_instance_ == null)?null:_instance_.isOrdered);
            }

            @Override
            public void set(final Composition _instance_, final Boolean _value_) {
                if (_instance_!= null) {
                    _instance_.isOrdered = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Composition.Selector<Composition.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Composition.Select _root() {
            return new Composition.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Relation.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Composition.Selector<TRoot, TParent>> isOrdered = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.isOrdered!= null) {
                products.put("isOrdered", this.isOrdered.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Composition.Selector<TRoot, TParent>> isOrdered() {
            return ((this.isOrdered == null)?this.isOrdered = new com.kscs.util.jaxb.Selector<>(this._root, this, "isOrdered"):this.isOrdered);
        }

    }

}
