
package org.javastro.ivoa.entities.vodml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type used to indicate on attributes that they take values representing a concept defined in
 *         an identified semantic vocabulary (SKOS or RDFS), and/or restricted by being narrower/more specific than an
 *         identified "top" concept.
 * 
 * <p>Java class for SemanticConcept complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SemanticConcept">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="topConcept" type="{http://www.w3.org/2001/XMLSchema}anyURI" minOccurs="0"/>
 *         <element name="vocabularyURI" type="{http://www.w3.org/2001/XMLSchema}anyURI" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SemanticConcept", propOrder = {
    "topConcept",
    "vocabularyURIs"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class SemanticConcept implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * A URI identifiying a semantic concept that corresponds to the concept in the model.
     *             Values of a corresponding attributes must be URI-s identifiying objects that are narrower
     *             than the identified concept. This attribute may be null as
     *             certain vocabularies may not have a
     * 
     */
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String topConcept;
    /**
     * If no topConcept is defined, one or more explicit vocabularies can be provided from which the
     *             value must be obtained.
     * 
     */
    @XmlElement(name = "vocabularyURI")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<String> vocabularyURIs;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient SemanticConcept.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public SemanticConcept() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SemanticConcept(final String topConcept, final List<String> vocabularyURIs) {
        this.topConcept = topConcept;
        this.vocabularyURIs = vocabularyURIs;
    }

    /**
     * A URI identifiying a semantic concept that corresponds to the concept in the model.
     *             Values of a corresponding attributes must be URI-s identifiying objects that are narrower
     *             than the identified concept. This attribute may be null as
     *             certain vocabularies may not have a
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getTopConcept() {
        return topConcept;
    }

    /**
     * Sets the value of the topConcept property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTopConcept()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTopConcept(String value) {
        this.topConcept = value;
    }

    /**
     * If no topConcept is defined, one or more explicit vocabularies can be provided from which the
     *             value must be obtained.
     * 
     * Gets the value of the vocabularyURIs property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the vocabularyURIs property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getVocabularyURIs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the vocabularyURIs property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<String> getVocabularyURIs() {
        if (vocabularyURIs == null) {
            vocabularyURIs = new ArrayList<>();
        }
        return this.vocabularyURIs;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SemanticConcept that = ((SemanticConcept) object);
        {
            String leftTopConcept;
            leftTopConcept = this.getTopConcept();
            String rightTopConcept;
            rightTopConcept = that.getTopConcept();
            if (this.topConcept!= null) {
                if (that.topConcept!= null) {
                    if (!leftTopConcept.equals(rightTopConcept)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.topConcept!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftVocabularyURIs;
            leftVocabularyURIs = (((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty()))?this.getVocabularyURIs():null);
            List<String> rightVocabularyURIs;
            rightVocabularyURIs = (((that.vocabularyURIs!= null)&&(!that.vocabularyURIs.isEmpty()))?that.getVocabularyURIs():null);
            if ((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty())) {
                if ((that.vocabularyURIs!= null)&&(!that.vocabularyURIs.isEmpty())) {
                    if (!leftVocabularyURIs.equals(rightVocabularyURIs)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.vocabularyURIs!= null)&&(!that.vocabularyURIs.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theTopConcept;
            theTopConcept = this.getTopConcept();
            if (this.topConcept!= null) {
                currentHashCode += theTopConcept.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theVocabularyURIs;
            theVocabularyURIs = (((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty()))?this.getVocabularyURIs():null);
            if ((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty())) {
                currentHashCode += theVocabularyURIs.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theTopConcept;
            theTopConcept = this.getTopConcept();
            strategy.appendField(locator, this, "topConcept", buffer, theTopConcept, (this.topConcept!= null));
        }
        {
            List<String> theVocabularyURIs;
            theVocabularyURIs = (((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty()))?this.getVocabularyURIs():null);
            strategy.appendField(locator, this, "vocabularyURIs", buffer, theVocabularyURIs, ((this.vocabularyURIs!= null)&&(!this.vocabularyURIs.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof SemanticConcept) {
            final SemanticConcept target = this;
            final SemanticConcept leftObject = ((SemanticConcept) left);
            final SemanticConcept rightObject = ((SemanticConcept) right);
            {
                Boolean topConceptShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.topConcept!= null), (rightObject.topConcept!= null));
                if (topConceptShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTopConcept;
                    lhsTopConcept = leftObject.getTopConcept();
                    String rhsTopConcept;
                    rhsTopConcept = rightObject.getTopConcept();
                    String mergedTopConcept = ((String) strategy.merge(LocatorUtils.property(leftLocator, "topConcept", lhsTopConcept), LocatorUtils.property(rightLocator, "topConcept", rhsTopConcept), lhsTopConcept, rhsTopConcept, (leftObject.topConcept!= null), (rightObject.topConcept!= null)));
                    target.setTopConcept(mergedTopConcept);
                } else {
                    if (topConceptShouldBeMergedAndSet == Boolean.FALSE) {
                        target.topConcept = null;
                    }
                }
            }
            {
                Boolean vocabularyURIsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.vocabularyURIs!= null)&&(!leftObject.vocabularyURIs.isEmpty())), ((rightObject.vocabularyURIs!= null)&&(!rightObject.vocabularyURIs.isEmpty())));
                if (vocabularyURIsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsVocabularyURIs;
                    lhsVocabularyURIs = (((leftObject.vocabularyURIs!= null)&&(!leftObject.vocabularyURIs.isEmpty()))?leftObject.getVocabularyURIs():null);
                    List<String> rhsVocabularyURIs;
                    rhsVocabularyURIs = (((rightObject.vocabularyURIs!= null)&&(!rightObject.vocabularyURIs.isEmpty()))?rightObject.getVocabularyURIs():null);
                    List<String> mergedVocabularyURIs = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "vocabularyURIs", lhsVocabularyURIs), LocatorUtils.property(rightLocator, "vocabularyURIs", rhsVocabularyURIs), lhsVocabularyURIs, rhsVocabularyURIs, ((leftObject.vocabularyURIs!= null)&&(!leftObject.vocabularyURIs.isEmpty())), ((rightObject.vocabularyURIs!= null)&&(!rightObject.vocabularyURIs.isEmpty()))));
                    target.vocabularyURIs = null;
                    if (mergedVocabularyURIs!= null) {
                        List<String> uniqueVocabularyURIsl = target.getVocabularyURIs();
                        uniqueVocabularyURIsl.addAll(mergedVocabularyURIs);
                    }
                } else {
                    if (vocabularyURIsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.vocabularyURIs = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new SemanticConcept();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept clone() {
        final SemanticConcept _newObject;
        try {
            _newObject = ((SemanticConcept) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.vocabularyURIs = ((this.vocabularyURIs == null)?null:new ArrayList<>(this.vocabularyURIs));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept createCopy() {
        final SemanticConcept _newObject;
        try {
            _newObject = ((SemanticConcept) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.topConcept = this.topConcept;
        _newObject.vocabularyURIs = ((this.vocabularyURIs == null)?null:new ArrayList<>(this.vocabularyURIs));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SemanticConcept _newObject;
        try {
            _newObject = ((SemanticConcept) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree topConceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("topConcept"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(topConceptPropertyTree!= null):((topConceptPropertyTree == null)||(!topConceptPropertyTree.isLeaf())))) {
            _newObject.topConcept = this.topConcept;
        }
        final PropertyTree vocabularyURIsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vocabularyURIs"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vocabularyURIsPropertyTree!= null):((vocabularyURIsPropertyTree == null)||(!vocabularyURIsPropertyTree.isLeaf())))) {
            _newObject.vocabularyURIs = ((this.vocabularyURIs == null)?null:new ArrayList<>(this.vocabularyURIs));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SemanticConcept.Modifier();
        }
        return ((SemanticConcept.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SemanticConcept.Builder<_B> _other) {
        _other.topConcept = this.topConcept;
        if (this.vocabularyURIs == null) {
            _other.vocabularyURIs = null;
        } else {
            _other.vocabularyURIs = new ArrayList<>();
            for (String _item: this.vocabularyURIs) {
                _other.vocabularyURIs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SemanticConcept.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SemanticConcept.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SemanticConcept.Builder<Void> builder() {
        return new SemanticConcept.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SemanticConcept.Builder<_B> copyOf(final SemanticConcept _other) {
        final SemanticConcept.Builder<_B> _newBuilder = new SemanticConcept.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SemanticConcept.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree topConceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("topConcept"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(topConceptPropertyTree!= null):((topConceptPropertyTree == null)||(!topConceptPropertyTree.isLeaf())))) {
            _other.topConcept = this.topConcept;
        }
        final PropertyTree vocabularyURIsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vocabularyURIs"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vocabularyURIsPropertyTree!= null):((vocabularyURIsPropertyTree == null)||(!vocabularyURIsPropertyTree.isLeaf())))) {
            if (this.vocabularyURIs == null) {
                _other.vocabularyURIs = null;
            } else {
                _other.vocabularyURIs = new ArrayList<>();
                for (String _item: this.vocabularyURIs) {
                    _other.vocabularyURIs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SemanticConcept.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SemanticConcept.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SemanticConcept.Builder<_B> copyOf(final SemanticConcept _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SemanticConcept.Builder<_B> _newBuilder = new SemanticConcept.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SemanticConcept.Builder<Void> copyExcept(final SemanticConcept _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SemanticConcept.Builder<Void> copyOnly(final SemanticConcept _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SemanticConcept visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(SemanticConcept.PropInfo.TOP_CONCEPT, this));
        _visitor_.visit(new CollectionProperty<>(SemanticConcept.PropInfo.VOCABULARY_UR_IS, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final SemanticConcept _storedValue;
        private String topConcept;
        private List<Buildable> vocabularyURIs;

        public Builder(final _B _parentBuilder, final SemanticConcept _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.topConcept = _other.topConcept;
                    if (_other.vocabularyURIs == null) {
                        this.vocabularyURIs = null;
                    } else {
                        this.vocabularyURIs = new ArrayList<>();
                        for (String _item: _other.vocabularyURIs) {
                            this.vocabularyURIs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final SemanticConcept _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree topConceptPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("topConcept"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(topConceptPropertyTree!= null):((topConceptPropertyTree == null)||(!topConceptPropertyTree.isLeaf())))) {
                        this.topConcept = _other.topConcept;
                    }
                    final PropertyTree vocabularyURIsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vocabularyURIs"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vocabularyURIsPropertyTree!= null):((vocabularyURIsPropertyTree == null)||(!vocabularyURIsPropertyTree.isLeaf())))) {
                        if (_other.vocabularyURIs == null) {
                            this.vocabularyURIs = null;
                        } else {
                            this.vocabularyURIs = new ArrayList<>();
                            for (String _item: _other.vocabularyURIs) {
                                this.vocabularyURIs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends SemanticConcept >_P init(final _P _product) {
            _product.topConcept = this.topConcept;
            if (this.vocabularyURIs!= null) {
                final List<String> vocabularyURIs = new ArrayList<>(this.vocabularyURIs.size());
                for (Buildable _item: this.vocabularyURIs) {
                    vocabularyURIs.add(((String) _item.build()));
                }
                _product.vocabularyURIs = vocabularyURIs;
            }
            return _product;
        }

        /**
         * Sets the new value of "topConcept" (any previous value will be replaced)
         * 
         * @param topConcept
         *     New value of the "topConcept" property.
         */
        public SemanticConcept.Builder<_B> withTopConcept(final String topConcept) {
            this.topConcept = topConcept;
            return this;
        }

        /**
         * Adds the given items to the value of "vocabularyURIs"
         * 
         * @param vocabularyURIs
         *     Items to add to the value of the "vocabularyURIs" property
         */
        public SemanticConcept.Builder<_B> addVocabularyURIs(final Iterable<? extends String> vocabularyURIs) {
            if (vocabularyURIs!= null) {
                if (this.vocabularyURIs == null) {
                    this.vocabularyURIs = new ArrayList<>();
                }
                for (String _item: vocabularyURIs) {
                    this.vocabularyURIs.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "vocabularyURIs" (any previous value will be replaced)
         * 
         * @param vocabularyURIs
         *     New value of the "vocabularyURIs" property.
         */
        public SemanticConcept.Builder<_B> withVocabularyURIs(final Iterable<? extends String> vocabularyURIs) {
            if (this.vocabularyURIs!= null) {
                this.vocabularyURIs.clear();
            }
            return addVocabularyURIs(vocabularyURIs);
        }

        /**
         * Adds the given items to the value of "vocabularyURIs"
         * 
         * @param vocabularyURIs
         *     Items to add to the value of the "vocabularyURIs" property
         */
        public SemanticConcept.Builder<_B> addVocabularyURIs(String... vocabularyURIs) {
            addVocabularyURIs(Arrays.asList(vocabularyURIs));
            return this;
        }

        /**
         * Sets the new value of "vocabularyURIs" (any previous value will be replaced)
         * 
         * @param vocabularyURIs
         *     New value of the "vocabularyURIs" property.
         */
        public SemanticConcept.Builder<_B> withVocabularyURIs(String... vocabularyURIs) {
            withVocabularyURIs(Arrays.asList(vocabularyURIs));
            return this;
        }

        @Override
        public SemanticConcept build() {
            if (_storedValue == null) {
                return this.init(new SemanticConcept());
            } else {
                return ((SemanticConcept) _storedValue);
            }
        }

        public SemanticConcept.Builder<_B> copyOf(final SemanticConcept _other) {
            _other.copyTo(this);
            return this;
        }

        public SemanticConcept.Builder<_B> copyOf(final SemanticConcept.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setTopConcept(final String topConcept) {
            SemanticConcept.this.setTopConcept(topConcept);
        }

        public List<String> getVocabularyURIs() {
            if (SemanticConcept.this.vocabularyURIs == null) {
                SemanticConcept.this.vocabularyURIs = new ArrayList<>();
            }
            return SemanticConcept.this.vocabularyURIs;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SemanticConcept, String> TOP_CONCEPT = new SinglePropertyInfo<SemanticConcept,String>("topConcept", SemanticConcept.class, String.class, false, null, new QName("", "topConcept"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final SemanticConcept _instance_) {
                return ((_instance_ == null)?null:_instance_.topConcept);
            }

            @Override
            public void set(final SemanticConcept _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.topConcept = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<SemanticConcept, String> VOCABULARY_UR_IS = new CollectionPropertyInfo<SemanticConcept,String>("vocabularyURIs", SemanticConcept.class, String.class, true, null, new QName("", "vocabularyURI"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public List<String> get(final SemanticConcept _instance_) {
                return ((_instance_ == null)?null:_instance_.vocabularyURIs);
            }

            @Override
            public void set(final SemanticConcept _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.vocabularyURIs = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SemanticConcept.Selector<SemanticConcept.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SemanticConcept.Select _root() {
            return new SemanticConcept.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SemanticConcept.Selector<TRoot, TParent>> topConcept = null;
        private com.kscs.util.jaxb.Selector<TRoot, SemanticConcept.Selector<TRoot, TParent>> vocabularyURIs = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.topConcept!= null) {
                products.put("topConcept", this.topConcept.init());
            }
            if (this.vocabularyURIs!= null) {
                products.put("vocabularyURIs", this.vocabularyURIs.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SemanticConcept.Selector<TRoot, TParent>> topConcept() {
            return ((this.topConcept == null)?this.topConcept = new com.kscs.util.jaxb.Selector<>(this._root, this, "topConcept"):this.topConcept);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SemanticConcept.Selector<TRoot, TParent>> vocabularyURIs() {
            return ((this.vocabularyURIs == null)?this.vocabularyURIs = new com.kscs.util.jaxb.Selector<>(this._root, this, "vocabularyURIs"):this.vocabularyURIs);
        }

    }

}
