
package org.javastro.ivoa.entities.vosi.tables;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.dataservice.ForeignKey;
import org.javastro.ivoa.entities.resource.dataservice.TableParam;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;


/**
 * A description of a single table supported by the
 *          service associated with a VOSI-enabled resource.
 * 
 * <p>Java class for table element declaration</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <element name="table" type="{http://www.ivoa.net/xml/VODataService/v1.1}Table"/>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "")
@XmlRootElement(name = "table")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Table
    extends org.javastro.ivoa.entities.resource.dataservice.Table
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{


    /**
     * Default no-arg constructor
     * 
     */
    public Table() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Table(final String name, final String title, final String description, final String utype, final BigInteger nrows, final List<TableParam> columns, final List<ForeignKey> foreignKeies, final String type, final Map<QName, String> otherAttributes) {
        super(name, title, description, utype, nrows, columns, foreignKeies, type, otherAttributes);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Table();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table clone() {
        final Table _newObject;
        _newObject = ((Table) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table createCopy() {
        final Table _newObject = ((Table) super.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Table _newObject = ((Table) super.createCopy(_propertyTree, _propertyTreeUse));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Table.Modifier();
        }
        return ((Table.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Table.Builder<_B> _other) {
        super.copyTo(_other);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Table.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Table.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Table.Builder<Void> builder() {
        return new Table.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Table.Builder<_B> copyOf(final org.javastro.ivoa.entities.resource.dataservice.Table _other) {
        final Table.Builder<_B> _newBuilder = new Table.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Table.Builder<_B> copyOf(final Table _other) {
        final Table.Builder<_B> _newBuilder = new Table.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Table.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Table.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Table.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Table.Builder<_B> copyOf(final org.javastro.ivoa.entities.resource.dataservice.Table _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Table.Builder<_B> _newBuilder = new Table.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Table.Builder<_B> copyOf(final Table _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Table.Builder<_B> _newBuilder = new Table.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Table.Builder<Void> copyExcept(final org.javastro.ivoa.entities.resource.dataservice.Table _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Table.Builder<Void> copyExcept(final Table _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Table.Builder<Void> copyOnly(final org.javastro.ivoa.entities.resource.dataservice.Table _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Table.Builder<Void> copyOnly(final Table _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Table visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        return this;
    }

    public static class Builder<_B >
        extends org.javastro.ivoa.entities.resource.dataservice.Table.Builder<_B>
        implements Buildable
    {


        public Builder(final _B _parentBuilder, final Table _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
            }
        }

        public Builder(final _B _parentBuilder, final Table _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
            }
        }

        protected<_P extends Table >_P init(final _P _product) {
            return super.init(_product);
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public Table.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public Table.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public Table.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Sets the new value of "utype" (any previous value will be replaced)
         * 
         * @param utype
         *     New value of the "utype" property.
         */
        @Override
        public Table.Builder<_B> withUtype(final String utype) {
            super.withUtype(utype);
            return this;
        }

        /**
         * Sets the new value of "nrows" (any previous value will be replaced)
         * 
         * @param nrows
         *     New value of the "nrows" property.
         */
        @Override
        public Table.Builder<_B> withNrows(final BigInteger nrows) {
            super.withNrows(nrows);
            return this;
        }

        /**
         * Adds the given items to the value of "columns"
         * 
         * @param columns
         *     Items to add to the value of the "columns" property
         */
        @Override
        public Table.Builder<_B> addColumns(final Iterable<? extends TableParam> columns) {
            super.addColumns(columns);
            return this;
        }

        /**
         * Adds the given items to the value of "columns"
         * 
         * @param columns
         *     Items to add to the value of the "columns" property
         */
        @Override
        public Table.Builder<_B> addColumns(TableParam... columns) {
            super.addColumns(columns);
            return this;
        }

        /**
         * Sets the new value of "columns" (any previous value will be replaced)
         * 
         * @param columns
         *     New value of the "columns" property.
         */
        @Override
        public Table.Builder<_B> withColumns(final Iterable<? extends TableParam> columns) {
            super.withColumns(columns);
            return this;
        }

        /**
         * Sets the new value of "columns" (any previous value will be replaced)
         * 
         * @param columns
         *     New value of the "columns" property.
         */
        @Override
        public Table.Builder<_B> withColumns(TableParam... columns) {
            super.withColumns(columns);
            return this;
        }

        /**
         * Adds the given items to the value of "foreignKeies"
         * 
         * @param foreignKeies
         *     Items to add to the value of the "foreignKeies" property
         */
        @Override
        public Table.Builder<_B> addForeignKeies(final Iterable<? extends ForeignKey> foreignKeies) {
            super.addForeignKeies(foreignKeies);
            return this;
        }

        /**
         * Adds the given items to the value of "foreignKeies"
         * 
         * @param foreignKeies
         *     Items to add to the value of the "foreignKeies" property
         */
        @Override
        public Table.Builder<_B> addForeignKeies(ForeignKey... foreignKeies) {
            super.addForeignKeies(foreignKeies);
            return this;
        }

        /**
         * Sets the new value of "foreignKeies" (any previous value will be replaced)
         * 
         * @param foreignKeies
         *     New value of the "foreignKeies" property.
         */
        @Override
        public Table.Builder<_B> withForeignKeies(final Iterable<? extends ForeignKey> foreignKeies) {
            super.withForeignKeies(foreignKeies);
            return this;
        }

        /**
         * Sets the new value of "foreignKeies" (any previous value will be replaced)
         * 
         * @param foreignKeies
         *     New value of the "foreignKeies" property.
         */
        @Override
        public Table.Builder<_B> withForeignKeies(ForeignKey... foreignKeies) {
            super.withForeignKeies(foreignKeies);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public Table.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        @Override
        public Table build() {
            if (_storedValue == null) {
                return this.init(new Table());
            } else {
                return ((Table) _storedValue);
            }
        }

        public Table.Builder<_B> copyOf(final Table _other) {
            _other.copyTo(this);
            return this;
        }

        public Table.Builder<_B> copyOf(final Table.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends org.javastro.ivoa.entities.resource.dataservice.Table.Modifier
    {


    }

    public static class PropInfo {


    }

    public static class Select
        extends Table.Selector<Table.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Table.Select _root() {
            return new Table.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends org.javastro.ivoa.entities.resource.dataservice.Table.Selector<TRoot, TParent>
    {


        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            return products;
        }

    }

}
