/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.ResourceName;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Organisation", propOrder={"facilities", "instruments"})
public class Organisation
extends Resource
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlElement(name="facility")
    protected List<ResourceName> facilities;
    @XmlElement(name="instrument")
    protected List<ResourceName> instruments;

    public Organisation() {
    }

    public Organisation(List<Validation> validationLevels, String title, String shortName, String identifier, List<String> altIdentifiers, Curation curation, Content content, LocalDateTime created, LocalDateTime updated, String status, String version, List<ResourceName> facilities, List<ResourceName> instruments) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.facilities = facilities;
        this.instruments = instruments;
    }

    public List<ResourceName> getFacilities() {
        if (this.facilities == null) {
            this.facilities = new ArrayList<ResourceName>();
        }
        return this.facilities;
    }

    public List<ResourceName> getInstruments() {
        if (this.instruments == null) {
            this.instruments = new ArrayList<ResourceName>();
        }
        return this.instruments;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<ResourceName> rightInstruments;
        List<ResourceName> rightFacilities;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Organisation that = (Organisation)object;
        List<ResourceName> leftFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        List<ResourceName> list = rightFacilities = that.facilities != null && !that.facilities.isEmpty() ? that.getFacilities() : null;
        if (this.facilities != null && !this.facilities.isEmpty()) {
            if (that.facilities == null || that.facilities.isEmpty()) return false;
            if (!leftFacilities.equals(rightFacilities)) {
                return false;
            }
        } else if (that.facilities != null && !that.facilities.isEmpty()) {
            return false;
        }
        List<ResourceName> leftInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        List<ResourceName> list2 = rightInstruments = that.instruments != null && !that.instruments.isEmpty() ? that.getInstruments() : null;
        if (this.instruments != null && !this.instruments.isEmpty()) {
            if (that.instruments == null || that.instruments.isEmpty()) return false;
            if (leftInstruments.equals(rightInstruments)) return true;
            return false;
        }
        if (that.instruments == null || that.instruments.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<ResourceName> theInstruments;
        List<ResourceName> theFacilities;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<ResourceName> list = theFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        if (this.facilities != null && !this.facilities.isEmpty()) {
            currentHashCode += theFacilities.hashCode();
        }
        currentHashCode *= 31;
        List<ResourceName> list2 = theInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        if (this.instruments != null && !this.instruments.isEmpty()) {
            currentHashCode += theInstruments.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        List<ResourceName> theFacilities = this.facilities != null && !this.facilities.isEmpty() ? this.getFacilities() : null;
        strategy.appendField(locator, (Object)this, "facilities", buffer, theFacilities, this.facilities != null && !this.facilities.isEmpty());
        List<ResourceName> theInstruments = this.instruments != null && !this.instruments.isEmpty() ? this.getInstruments() : null;
        strategy.appendField(locator, (Object)this, "instruments", buffer, theInstruments, this.instruments != null && !this.instruments.isEmpty());
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Organisation) {
            Organisation target = this;
            Organisation leftObject = (Organisation)left;
            Organisation rightObject = (Organisation)right;
            Boolean facilitiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.facilities != null && !leftObject.facilities.isEmpty(), rightObject.facilities != null && !rightObject.facilities.isEmpty());
            if (facilitiesShouldBeMergedAndSet == Boolean.TRUE) {
                List<ResourceName> lhsFacilities = leftObject.facilities != null && !leftObject.facilities.isEmpty() ? leftObject.getFacilities() : null;
                List<ResourceName> rhsFacilities = rightObject.facilities != null && !rightObject.facilities.isEmpty() ? rightObject.getFacilities() : null;
                List mergedFacilities = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"facilities", lhsFacilities), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"facilities", rhsFacilities), lhsFacilities, rhsFacilities, leftObject.facilities != null && !leftObject.facilities.isEmpty(), rightObject.facilities != null && !rightObject.facilities.isEmpty());
                target.facilities = null;
                if (mergedFacilities != null) {
                    List<ResourceName> uniqueFacilitiesl = target.getFacilities();
                    uniqueFacilitiesl.addAll(mergedFacilities);
                }
            } else if (facilitiesShouldBeMergedAndSet == Boolean.FALSE) {
                target.facilities = null;
            }
            Boolean instrumentsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.instruments != null && !leftObject.instruments.isEmpty(), rightObject.instruments != null && !rightObject.instruments.isEmpty());
            if (instrumentsShouldBeMergedAndSet == Boolean.TRUE) {
                List<ResourceName> lhsInstruments = leftObject.instruments != null && !leftObject.instruments.isEmpty() ? leftObject.getInstruments() : null;
                List<ResourceName> rhsInstruments = rightObject.instruments != null && !rightObject.instruments.isEmpty() ? rightObject.getInstruments() : null;
                List mergedInstruments = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"instruments", lhsInstruments), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"instruments", rhsInstruments), lhsInstruments, rhsInstruments, leftObject.instruments != null && !leftObject.instruments.isEmpty(), rightObject.instruments != null && !rightObject.instruments.isEmpty());
                target.instruments = null;
                if (mergedInstruments != null) {
                    List<ResourceName> uniqueInstrumentsl = target.getInstruments();
                    uniqueInstrumentsl.addAll(mergedInstruments);
                }
            } else if (instrumentsShouldBeMergedAndSet == Boolean.FALSE) {
                target.instruments = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new Organisation();
    }

    @Override
    public Organisation clone() {
        Organisation _newObject = (Organisation)super.clone();
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<ResourceName>();
            for (ResourceName _item : this.facilities) {
                _newObject.facilities.add(_item == null ? null : _item.clone());
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<ResourceName>();
            for (ResourceName _item : this.instruments) {
                _newObject.instruments.add(_item == null ? null : _item.clone());
            }
        }
        return _newObject;
    }

    @Override
    public Organisation createCopy() {
        Organisation _newObject = (Organisation)super.createCopy();
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<ResourceName>();
            for (ResourceName _item : this.facilities) {
                _newObject.facilities.add(_item == null ? null : _item.createCopy());
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<ResourceName>();
            for (ResourceName _item : this.instruments) {
                _newObject.instruments.add(_item == null ? null : _item.createCopy());
            }
        }
        return _newObject;
    }

    @Override
    public Organisation createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree instrumentsPropertyTree;
        PropertyTree facilitiesPropertyTree;
        Organisation _newObject = (Organisation)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
            if (this.facilities == null) {
                _newObject.facilities = null;
            } else {
                _newObject.facilities = new ArrayList<ResourceName>();
                for (ResourceName _item : this.facilities) {
                    _newObject.facilities.add(_item == null ? null : _item.createCopy(facilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree2 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
            if (this.instruments == null) {
                _newObject.instruments = null;
            } else {
                _newObject.instruments = new ArrayList<ResourceName>();
                for (ResourceName _item : this.instruments) {
                    _newObject.instruments.add(_item == null ? null : _item.createCopy(instrumentsPropertyTree, _propertyTreeUse));
                }
            }
        }
        return _newObject;
    }

    @Override
    public Organisation copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public Organisation copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        if (this.facilities == null) {
            _other.facilities = null;
        } else {
            _other.facilities = new ArrayList();
            for (ResourceName _item : this.facilities) {
                _other.facilities.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
        if (this.instruments == null) {
            _other.instruments = null;
        } else {
            _other.instruments = new ArrayList();
            for (ResourceName _item : this.instruments) {
                _other.instruments.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Resource _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Organisation _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree instrumentsPropertyTree;
        PropertyTree facilitiesPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
            if (this.facilities == null) {
                _other.facilities = null;
            } else {
                _other.facilities = new ArrayList();
                for (ResourceName _item : this.facilities) {
                    _other.facilities.add(_item == null ? null : _item.newCopyBuilder(_other, facilitiesPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree2 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
            if (this.instruments == null) {
                _other.instruments = null;
            } else {
                _other.instruments = new ArrayList();
                for (ResourceName _item : this.instruments) {
                    _other.instruments.add(_item == null ? null : _item.newCopyBuilder(_other, instrumentsPropertyTree, _propertyTreeUse));
                }
            }
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Resource _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Organisation _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Resource _other, PropertyTree _propertyTree) {
        return Organisation.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(Organisation _other, PropertyTree _propertyTree) {
        return Organisation.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Resource _other, PropertyTree _propertyTree) {
        return Organisation.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(Organisation _other, PropertyTree _propertyTree) {
        return Organisation.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Organisation visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty(PropInfo.FACILITIES, (Object)this)) && this.facilities != null) {
            for (ResourceName _item_ : this.facilities) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.INSTRUMENTS, (Object)this)) && this.instruments != null) {
            for (ResourceName _item_ : this.instruments) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        return this;
    }

    public class Modifier
    extends Resource.Modifier {
        public List<ResourceName> getFacilities() {
            if (Organisation.this.facilities == null) {
                Organisation.this.facilities = new ArrayList<ResourceName>();
            }
            return Organisation.this.facilities;
        }

        public List<ResourceName> getInstruments() {
            if (Organisation.this.instruments == null) {
                Organisation.this.instruments = new ArrayList<ResourceName>();
            }
            return Organisation.this.instruments;
        }
    }

    public static class Builder<_B>
    extends Resource.Builder<_B>
    implements Buildable {
        private List<ResourceName.Builder<Builder<_B>>> facilities;
        private List<ResourceName.Builder<Builder<_B>>> instruments;

        public Builder(_B _parentBuilder, Organisation _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                if (_other.facilities == null) {
                    this.facilities = null;
                } else {
                    this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                    for (ResourceName _item : _other.facilities) {
                        this.facilities.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
                if (_other.instruments == null) {
                    this.instruments = null;
                } else {
                    this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                    for (ResourceName _item : _other.instruments) {
                        this.instruments.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
            }
        }

        public Builder(_B _parentBuilder, Organisation _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree instrumentsPropertyTree;
                PropertyTree facilitiesPropertyTree;
                PropertyTree propertyTree = facilitiesPropertyTree = _propertyTree == null ? null : _propertyTree.get("facilities");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? facilitiesPropertyTree != null : facilitiesPropertyTree == null || !facilitiesPropertyTree.isLeaf()) {
                    if (_other.facilities == null) {
                        this.facilities = null;
                    } else {
                        this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                        for (ResourceName _item : _other.facilities) {
                            this.facilities.add(_item == null ? null : _item.newCopyBuilder(this, facilitiesPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree2 = instrumentsPropertyTree = _propertyTree == null ? null : _propertyTree.get("instruments");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? instrumentsPropertyTree != null : instrumentsPropertyTree == null || !instrumentsPropertyTree.isLeaf()) {
                    if (_other.instruments == null) {
                        this.instruments = null;
                    } else {
                        this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                        for (ResourceName _item : _other.instruments) {
                            this.instruments.add(_item == null ? null : _item.newCopyBuilder(this, instrumentsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
            }
        }

        @Override
        protected <_P extends Organisation> _P init(_P _product) {
            if (this.facilities != null) {
                ArrayList<ResourceName> facilities = new ArrayList<ResourceName>(this.facilities.size());
                for (ResourceName.Builder<Builder<_B>> _item : this.facilities) {
                    facilities.add(_item.build());
                }
                _product.facilities = facilities;
            }
            if (this.instruments != null) {
                ArrayList<ResourceName> instruments = new ArrayList<ResourceName>(this.instruments.size());
                for (ResourceName.Builder<Builder<_B>> _item : this.instruments) {
                    instruments.add(_item.build());
                }
                _product.instruments = instruments;
            }
            return super.init(_product);
        }

        public Builder<_B> addFacilities(Iterable<? extends ResourceName> facilities) {
            if (facilities != null) {
                if (this.facilities == null) {
                    this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                }
                for (ResourceName resourceName : facilities) {
                    this.facilities.add(new ResourceName.Builder<Builder>(this, resourceName, false));
                }
            }
            return this;
        }

        public Builder<_B> withFacilities(Iterable<? extends ResourceName> facilities) {
            if (this.facilities != null) {
                this.facilities.clear();
            }
            return this.addFacilities(facilities);
        }

        public Builder<_B> addFacilities(ResourceName ... facilities) {
            this.addFacilities(Arrays.asList(facilities));
            return this;
        }

        public Builder<_B> withFacilities(ResourceName ... facilities) {
            this.withFacilities(Arrays.asList(facilities));
            return this;
        }

        public ResourceName.Builder<? extends Builder<_B>> addFacilities() {
            if (this.facilities == null) {
                this.facilities = new ArrayList<ResourceName.Builder<Builder<_B>>>();
            }
            ResourceName.Builder<Builder> facilities_Builder = new ResourceName.Builder<Builder>(this, null, false);
            this.facilities.add(facilities_Builder);
            return facilities_Builder;
        }

        public Builder<_B> addInstruments(Iterable<? extends ResourceName> instruments) {
            if (instruments != null) {
                if (this.instruments == null) {
                    this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
                }
                for (ResourceName resourceName : instruments) {
                    this.instruments.add(new ResourceName.Builder<Builder>(this, resourceName, false));
                }
            }
            return this;
        }

        public Builder<_B> withInstruments(Iterable<? extends ResourceName> instruments) {
            if (this.instruments != null) {
                this.instruments.clear();
            }
            return this.addInstruments(instruments);
        }

        public Builder<_B> addInstruments(ResourceName ... instruments) {
            this.addInstruments(Arrays.asList(instruments));
            return this;
        }

        public Builder<_B> withInstruments(ResourceName ... instruments) {
            this.withInstruments(Arrays.asList(instruments));
            return this;
        }

        public ResourceName.Builder<? extends Builder<_B>> addInstruments() {
            if (this.instruments == null) {
                this.instruments = new ArrayList<ResourceName.Builder<Builder<_B>>>();
            }
            ResourceName.Builder<Builder> instruments_Builder = new ResourceName.Builder<Builder>(this, null, false);
            this.instruments.add(instruments_Builder);
            return instruments_Builder;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withTitle(String title) {
            super.withTitle(title);
            return this;
        }

        @Override
        public Builder<_B> withShortName(String shortName) {
            super.withShortName(shortName);
            return this;
        }

        @Override
        public Builder<_B> withIdentifier(String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(String ... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(String ... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withCuration(Curation curation) {
            super.withCuration(curation);
            return this;
        }

        @Override
        public Curation.Builder<? extends Builder<_B>> withCuration() {
            return super.withCuration();
        }

        @Override
        public Builder<_B> withContent(Content content) {
            super.withContent(content);
            return this;
        }

        @Override
        public Content.Builder<? extends Builder<_B>> withContent() {
            return super.withContent();
        }

        @Override
        public Builder<_B> withCreated(LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder<_B> withUpdated(LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public Builder<_B> withStatus(String status) {
            super.withStatus(status);
            return this;
        }

        @Override
        public Builder<_B> withVersion(String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Organisation build() {
            if (this._storedValue == null) {
                return this.init(new Organisation());
            }
            return (Organisation)this._storedValue;
        }

        public Builder<_B> copyOf(Organisation _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient CollectionPropertyInfo<Organisation, ResourceName> FACILITIES = new CollectionPropertyInfo<Organisation, ResourceName>("facilities", Organisation.class, ResourceName.class, true, null, new QName("", "facility"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false){

            public List<ResourceName> get(Organisation _instance_) {
                return _instance_ == null ? null : _instance_.facilities;
            }

            public void set(Organisation _instance_, List<ResourceName> _value_) {
                if (_instance_ != null) {
                    _instance_.facilities = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Organisation, ResourceName> INSTRUMENTS = new CollectionPropertyInfo<Organisation, ResourceName>("instruments", Organisation.class, ResourceName.class, true, null, new QName("", "instrument"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false){

            public List<ResourceName> get(Organisation _instance_) {
                return _instance_ == null ? null : _instance_.instruments;
            }

            public void set(Organisation _instance_, List<ResourceName> _value_) {
                if (_instance_ != null) {
                    _instance_.instruments = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Resource.Selector<TRoot, TParent> {
        private ResourceName.Selector<TRoot, Selector<TRoot, TParent>> facilities = null;
        private ResourceName.Selector<TRoot, Selector<TRoot, TParent>> instruments = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.facilities != null) {
                products.put("facilities", this.facilities.init());
            }
            if (this.instruments != null) {
                products.put("instruments", this.instruments.init());
            }
            return products;
        }

        public ResourceName.Selector<TRoot, Selector<TRoot, TParent>> facilities() {
            return this.facilities == null ? (this.facilities = new ResourceName.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "facilities")) : this.facilities;
        }

        public ResourceName.Selector<TRoot, Selector<TRoot, TParent>> instruments() {
            return this.instruments == null ? (this.instruments = new ResourceName.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "instruments")) : this.instruments;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

