
package org.javastro.ivoa.entities.resource.applications;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Software the cannot be independently executed, but can be
 *             used to build applications
 * 
 * <p>Java class for SoftwareLibrary complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SoftwareLibrary">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOApplication/v1.0rc1}Application">
 *       <sequence>
 *         <element name="library" type="{http://www.ivoa.net/xml/VOApplication/v1.0rc1}ExecutionEnvironment" maxOccurs="unbounded"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SoftwareLibrary", propOrder = {
    "libraries"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class SoftwareLibrary
    extends Application
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "library", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<ExecutionEnvironment> libraries;

    /**
     * Default no-arg constructor
     * 
     */
    public SoftwareLibrary() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SoftwareLibrary(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final ZonedDateTime created, final ZonedDateTime updated, final String status, final String version, final String cost, final String licence, final Boolean openSource, final List<DataFormat> dataFormats, final List<ApplicationCapability> voStandards, final List<String> sourceLanguages, final String sourceCodeURL, final List<ExecutionEnvironment> libraries) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version, cost, licence, openSource, dataFormats, voStandards, sourceLanguages, sourceCodeURL);
        this.libraries = libraries;
    }

    /**
     * Gets the value of the libraries property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the libraries property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLibraries().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExecutionEnvironment }
     * </p>
     * 
     * 
     * @return
     *     The value of the libraries property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<ExecutionEnvironment> getLibraries() {
        if (libraries == null) {
            libraries = new ArrayList<>();
        }
        return this.libraries;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SoftwareLibrary that = ((SoftwareLibrary) object);
        {
            List<ExecutionEnvironment> leftLibraries;
            leftLibraries = (((this.libraries!= null)&&(!this.libraries.isEmpty()))?this.getLibraries():null);
            List<ExecutionEnvironment> rightLibraries;
            rightLibraries = (((that.libraries!= null)&&(!that.libraries.isEmpty()))?that.getLibraries():null);
            if ((this.libraries!= null)&&(!this.libraries.isEmpty())) {
                if ((that.libraries!= null)&&(!that.libraries.isEmpty())) {
                    if (!leftLibraries.equals(rightLibraries)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.libraries!= null)&&(!that.libraries.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<ExecutionEnvironment> theLibraries;
            theLibraries = (((this.libraries!= null)&&(!this.libraries.isEmpty()))?this.getLibraries():null);
            if ((this.libraries!= null)&&(!this.libraries.isEmpty())) {
                currentHashCode += theLibraries.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<ExecutionEnvironment> theLibraries;
            theLibraries = (((this.libraries!= null)&&(!this.libraries.isEmpty()))?this.getLibraries():null);
            strategy.appendField(locator, this, "libraries", buffer, theLibraries, ((this.libraries!= null)&&(!this.libraries.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SoftwareLibrary) {
            final SoftwareLibrary target = this;
            final SoftwareLibrary leftObject = ((SoftwareLibrary) left);
            final SoftwareLibrary rightObject = ((SoftwareLibrary) right);
            {
                Boolean librariesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.libraries!= null)&&(!leftObject.libraries.isEmpty())), ((rightObject.libraries!= null)&&(!rightObject.libraries.isEmpty())));
                if (librariesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ExecutionEnvironment> lhsLibraries;
                    lhsLibraries = (((leftObject.libraries!= null)&&(!leftObject.libraries.isEmpty()))?leftObject.getLibraries():null);
                    List<ExecutionEnvironment> rhsLibraries;
                    rhsLibraries = (((rightObject.libraries!= null)&&(!rightObject.libraries.isEmpty()))?rightObject.getLibraries():null);
                    List<ExecutionEnvironment> mergedLibraries = ((List<ExecutionEnvironment> ) strategy.merge(LocatorUtils.property(leftLocator, "libraries", lhsLibraries), LocatorUtils.property(rightLocator, "libraries", rhsLibraries), lhsLibraries, rhsLibraries, ((leftObject.libraries!= null)&&(!leftObject.libraries.isEmpty())), ((rightObject.libraries!= null)&&(!rightObject.libraries.isEmpty()))));
                    target.libraries = null;
                    if (mergedLibraries!= null) {
                        List<ExecutionEnvironment> uniqueLibrariesl = target.getLibraries();
                        uniqueLibrariesl.addAll(mergedLibraries);
                    }
                } else {
                    if (librariesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.libraries = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new SoftwareLibrary();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary clone() {
        final SoftwareLibrary _newObject;
        _newObject = ((SoftwareLibrary) super.clone());
        if (this.libraries == null) {
            _newObject.libraries = null;
        } else {
            _newObject.libraries = new ArrayList<>();
            for (ExecutionEnvironment _item: this.libraries) {
                _newObject.libraries.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary createCopy() {
        final SoftwareLibrary _newObject = ((SoftwareLibrary) super.createCopy());
        if (this.libraries == null) {
            _newObject.libraries = null;
        } else {
            _newObject.libraries = new ArrayList<>();
            for (ExecutionEnvironment _item: this.libraries) {
                _newObject.libraries.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SoftwareLibrary _newObject = ((SoftwareLibrary) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree librariesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("libraries"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(librariesPropertyTree!= null):((librariesPropertyTree == null)||(!librariesPropertyTree.isLeaf())))) {
            if (this.libraries == null) {
                _newObject.libraries = null;
            } else {
                _newObject.libraries = new ArrayList<>();
                for (ExecutionEnvironment _item: this.libraries) {
                    _newObject.libraries.add(((_item == null)?null:_item.createCopy(librariesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SoftwareLibrary.Modifier();
        }
        return ((SoftwareLibrary.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SoftwareLibrary.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.libraries == null) {
            _other.libraries = null;
        } else {
            _other.libraries = new ArrayList<>();
            for (ExecutionEnvironment _item: this.libraries) {
                _other.libraries.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SoftwareLibrary.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SoftwareLibrary.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> builder() {
        return new SoftwareLibrary.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final Resource _other) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final Application _other) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final SoftwareLibrary _other) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SoftwareLibrary.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree librariesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("libraries"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(librariesPropertyTree!= null):((librariesPropertyTree == null)||(!librariesPropertyTree.isLeaf())))) {
            if (this.libraries == null) {
                _other.libraries = null;
            } else {
                _other.libraries = new ArrayList<>();
                for (ExecutionEnvironment _item: this.libraries) {
                    _other.libraries.add(((_item == null)?null:_item.newCopyBuilder(_other, librariesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SoftwareLibrary.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SoftwareLibrary.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final Application _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SoftwareLibrary.Builder<_B> copyOf(final SoftwareLibrary _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SoftwareLibrary.Builder<_B> _newBuilder = new SoftwareLibrary.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyExcept(final Application _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyExcept(final SoftwareLibrary _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyOnly(final Application _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SoftwareLibrary.Builder<Void> copyOnly(final SoftwareLibrary _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SoftwareLibrary visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(SoftwareLibrary.PropInfo.LIBRARIES, this))&&(this.libraries!= null)) {
            for (ExecutionEnvironment _item_: this.libraries) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends Application.Builder<_B>
        implements Buildable
    {

        private List<ExecutionEnvironment.Builder<SoftwareLibrary.Builder<_B>>> libraries;

        public Builder(final _B _parentBuilder, final SoftwareLibrary _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.libraries == null) {
                    this.libraries = null;
                } else {
                    this.libraries = new ArrayList<>();
                    for (ExecutionEnvironment _item: _other.libraries) {
                        this.libraries.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final SoftwareLibrary _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree librariesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("libraries"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(librariesPropertyTree!= null):((librariesPropertyTree == null)||(!librariesPropertyTree.isLeaf())))) {
                    if (_other.libraries == null) {
                        this.libraries = null;
                    } else {
                        this.libraries = new ArrayList<>();
                        for (ExecutionEnvironment _item: _other.libraries) {
                            this.libraries.add(((_item == null)?null:_item.newCopyBuilder(this, librariesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends SoftwareLibrary >_P init(final _P _product) {
            if (this.libraries!= null) {
                final List<ExecutionEnvironment> libraries = new ArrayList<>(this.libraries.size());
                for (ExecutionEnvironment.Builder<SoftwareLibrary.Builder<_B>> _item: this.libraries) {
                    libraries.add(_item.build());
                }
                _product.libraries = libraries;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "libraries"
         * 
         * @param libraries
         *     Items to add to the value of the "libraries" property
         */
        public SoftwareLibrary.Builder<_B> addLibraries(final Iterable<? extends ExecutionEnvironment> libraries) {
            if (libraries!= null) {
                if (this.libraries == null) {
                    this.libraries = new ArrayList<>();
                }
                for (ExecutionEnvironment _item: libraries) {
                    this.libraries.add(new ExecutionEnvironment.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "libraries" (any previous value will be replaced)
         * 
         * @param libraries
         *     New value of the "libraries" property.
         */
        public SoftwareLibrary.Builder<_B> withLibraries(final Iterable<? extends ExecutionEnvironment> libraries) {
            if (this.libraries!= null) {
                this.libraries.clear();
            }
            return addLibraries(libraries);
        }

        /**
         * Adds the given items to the value of "libraries"
         * 
         * @param libraries
         *     Items to add to the value of the "libraries" property
         */
        public SoftwareLibrary.Builder<_B> addLibraries(ExecutionEnvironment... libraries) {
            addLibraries(Arrays.asList(libraries));
            return this;
        }

        /**
         * Sets the new value of "libraries" (any previous value will be replaced)
         * 
         * @param libraries
         *     New value of the "libraries" property.
         */
        public SoftwareLibrary.Builder<_B> withLibraries(ExecutionEnvironment... libraries) {
            withLibraries(Arrays.asList(libraries));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Libraries" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.applications.ExecutionEnvironment.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Libraries" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.applications.ExecutionEnvironment.Builder#end()}
         *     to return to the current builder.
         */
        public ExecutionEnvironment.Builder<? extends SoftwareLibrary.Builder<_B>> addLibraries() {
            if (this.libraries == null) {
                this.libraries = new ArrayList<>();
            }
            final ExecutionEnvironment.Builder<SoftwareLibrary.Builder<_B>> libraries_Builder = new ExecutionEnvironment.Builder<>(this, null, false);
            this.libraries.add(libraries_Builder);
            return libraries_Builder;
        }

        /**
         * Sets the new value of "cost" (any previous value will be replaced)
         * 
         * @param cost
         *     New value of the "cost" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withCost(final String cost) {
            super.withCost(cost);
            return this;
        }

        /**
         * Sets the new value of "licence" (any previous value will be replaced)
         * 
         * @param licence
         *     New value of the "licence" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withLicence(final String licence) {
            super.withLicence(licence);
            return this;
        }

        /**
         * Sets the new value of "openSource" (any previous value will be replaced)
         * 
         * @param openSource
         *     New value of the "openSource" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withOpenSource(final Boolean openSource) {
            super.withOpenSource(openSource);
            return this;
        }

        /**
         * Adds the given items to the value of "dataFormats"
         * 
         * @param dataFormats
         *     Items to add to the value of the "dataFormats" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addDataFormats(final Iterable<? extends DataFormat> dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        /**
         * Adds the given items to the value of "dataFormats"
         * 
         * @param dataFormats
         *     Items to add to the value of the "dataFormats" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addDataFormats(DataFormat... dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        /**
         * Sets the new value of "dataFormats" (any previous value will be replaced)
         * 
         * @param dataFormats
         *     New value of the "dataFormats" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withDataFormats(final Iterable<? extends DataFormat> dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        /**
         * Sets the new value of "dataFormats" (any previous value will be replaced)
         * 
         * @param dataFormats
         *     New value of the "dataFormats" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withDataFormats(DataFormat... dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        /**
         * Adds the given items to the value of "voStandards"
         * 
         * @param voStandards
         *     Items to add to the value of the "voStandards" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addVoStandards(final Iterable<? extends ApplicationCapability> voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        /**
         * Adds the given items to the value of "voStandards"
         * 
         * @param voStandards
         *     Items to add to the value of the "voStandards" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addVoStandards(ApplicationCapability... voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        /**
         * Sets the new value of "voStandards" (any previous value will be replaced)
         * 
         * @param voStandards
         *     New value of the "voStandards" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withVoStandards(final Iterable<? extends ApplicationCapability> voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        /**
         * Sets the new value of "voStandards" (any previous value will be replaced)
         * 
         * @param voStandards
         *     New value of the "voStandards" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withVoStandards(ApplicationCapability... voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        /**
         * Adds the given items to the value of "sourceLanguages"
         * 
         * @param sourceLanguages
         *     Items to add to the value of the "sourceLanguages" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addSourceLanguages(final Iterable<? extends String> sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Adds the given items to the value of "sourceLanguages"
         * 
         * @param sourceLanguages
         *     Items to add to the value of the "sourceLanguages" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addSourceLanguages(String... sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceLanguages" (any previous value will be replaced)
         * 
         * @param sourceLanguages
         *     New value of the "sourceLanguages" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withSourceLanguages(final Iterable<? extends String> sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceLanguages" (any previous value will be replaced)
         * 
         * @param sourceLanguages
         *     New value of the "sourceLanguages" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withSourceLanguages(String... sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceCodeURL" (any previous value will be replaced)
         * 
         * @param sourceCodeURL
         *     New value of the "sourceCodeURL" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withSourceCodeURL(final String sourceCodeURL) {
            super.withSourceCodeURL(sourceCodeURL);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public SoftwareLibrary.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends SoftwareLibrary.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends SoftwareLibrary.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends SoftwareLibrary.Builder<_B>> withContent() {
            return ((Content.Builder<? extends SoftwareLibrary.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withCreated(final ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withUpdated(final ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public SoftwareLibrary.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public SoftwareLibrary build() {
            if (_storedValue == null) {
                return this.init(new SoftwareLibrary());
            } else {
                return ((SoftwareLibrary) _storedValue);
            }
        }

        public SoftwareLibrary.Builder<_B> copyOf(final SoftwareLibrary _other) {
            _other.copyTo(this);
            return this;
        }

        public SoftwareLibrary.Builder<_B> copyOf(final SoftwareLibrary.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Application.Modifier
    {


        public List<ExecutionEnvironment> getLibraries() {
            if (SoftwareLibrary.this.libraries == null) {
                SoftwareLibrary.this.libraries = new ArrayList<>();
            }
            return SoftwareLibrary.this.libraries;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<SoftwareLibrary, ExecutionEnvironment> LIBRARIES = new CollectionPropertyInfo<SoftwareLibrary,ExecutionEnvironment>("libraries", SoftwareLibrary.class, ExecutionEnvironment.class, true, null, new QName("", "library"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "ExecutionEnvironment"), false) {


            @Override
            public List<ExecutionEnvironment> get(final SoftwareLibrary _instance_) {
                return ((_instance_ == null)?null:_instance_.libraries);
            }

            @Override
            public void set(final SoftwareLibrary _instance_, final List<ExecutionEnvironment> _value_) {
                if (_instance_!= null) {
                    _instance_.libraries = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SoftwareLibrary.Selector<SoftwareLibrary.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SoftwareLibrary.Select _root() {
            return new SoftwareLibrary.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Application.Selector<TRoot, TParent>
    {

        private ExecutionEnvironment.Selector<TRoot, SoftwareLibrary.Selector<TRoot, TParent>> libraries = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.libraries!= null) {
                products.put("libraries", this.libraries.init());
            }
            return products;
        }

        public ExecutionEnvironment.Selector<TRoot, SoftwareLibrary.Selector<TRoot, TParent>> libraries() {
            return ((this.libraries == null)?this.libraries = new ExecutionEnvironment.Selector<>(this._root, this, "libraries"):this.libraries);
        }

    }

}
