
package org.javastro.ivoa.entities.resource.dataservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * When foreign keys are declared in this way, clients can expect
 *             that joins constrained with the foreign keys are preformed
 *             efficiently (e.g., using an index).
 * 
 * <p>Java class for ForeignKey complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ForeignKey">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="targetTable" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         <element name="fkColumn" type="{http://www.ivoa.net/xml/VODataService/v1.1}FKColumn" maxOccurs="unbounded"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="utype" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ForeignKey", propOrder = {
    "targetTable",
    "fkColumns",
    "description",
    "utype"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class ForeignKey implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The fully qualified name (including catalogue and schema, as
     *                applicable) of the table that can be joined with the 
     *                table containing this foreign key.
     * 
     */
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String targetTable;
    /**
     * A pair of column names, one from this table and one
     *                from the target table that should be used to join the
     *                tables in a query.
     * 
     */
    @XmlElement(name = "fkColumn", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<FKColumn> fkColumns;
    /**
     * A free-text description of what this key points to
     *                   and what the relationship means.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String description;
    /**
     * The form of the utype string depends on the data
     *                   model; common forms are sequences of dotted identifiers
     *                   (e.g., in SSA) or URIs (e.g., in RegTAP).
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String utype;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient ForeignKey.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ForeignKey() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ForeignKey(final String targetTable, final List<FKColumn> fkColumns, final String description, final String utype) {
        this.targetTable = targetTable;
        this.fkColumns = fkColumns;
        this.description = description;
        this.utype = utype;
    }

    /**
     * The fully qualified name (including catalogue and schema, as
     *                applicable) of the table that can be joined with the 
     *                table containing this foreign key.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getTargetTable() {
        return targetTable;
    }

    /**
     * Sets the value of the targetTable property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTargetTable()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setTargetTable(String value) {
        this.targetTable = value;
    }

    /**
     * A pair of column names, one from this table and one
     *                from the target table that should be used to join the
     *                tables in a query.
     * 
     * Gets the value of the fkColumns property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fkColumns property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFkColumns().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FKColumn }
     * </p>
     * 
     * 
     * @return
     *     The value of the fkColumns property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<FKColumn> getFkColumns() {
        if (fkColumns == null) {
            fkColumns = new ArrayList<>();
        }
        return this.fkColumns;
    }

    /**
     * A free-text description of what this key points to
     *                   and what the relationship means.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * The form of the utype string depends on the data
     *                   model; common forms are sequences of dotted identifiers
     *                   (e.g., in SSA) or URIs (e.g., in RegTAP).
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getUtype() {
        return utype;
    }

    /**
     * Sets the value of the utype property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUtype()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setUtype(String value) {
        this.utype = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ForeignKey that = ((ForeignKey) object);
        {
            String leftTargetTable;
            leftTargetTable = this.getTargetTable();
            String rightTargetTable;
            rightTargetTable = that.getTargetTable();
            if (this.targetTable!= null) {
                if (that.targetTable!= null) {
                    if (!leftTargetTable.equals(rightTargetTable)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.targetTable!= null) {
                    return false;
                }
            }
        }
        {
            List<FKColumn> leftFkColumns;
            leftFkColumns = (((this.fkColumns!= null)&&(!this.fkColumns.isEmpty()))?this.getFkColumns():null);
            List<FKColumn> rightFkColumns;
            rightFkColumns = (((that.fkColumns!= null)&&(!that.fkColumns.isEmpty()))?that.getFkColumns():null);
            if ((this.fkColumns!= null)&&(!this.fkColumns.isEmpty())) {
                if ((that.fkColumns!= null)&&(!that.fkColumns.isEmpty())) {
                    if (!leftFkColumns.equals(rightFkColumns)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.fkColumns!= null)&&(!that.fkColumns.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            String leftUtype;
            leftUtype = this.getUtype();
            String rightUtype;
            rightUtype = that.getUtype();
            if (this.utype!= null) {
                if (that.utype!= null) {
                    if (!leftUtype.equals(rightUtype)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.utype!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theTargetTable;
            theTargetTable = this.getTargetTable();
            if (this.targetTable!= null) {
                currentHashCode += theTargetTable.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<FKColumn> theFkColumns;
            theFkColumns = (((this.fkColumns!= null)&&(!this.fkColumns.isEmpty()))?this.getFkColumns():null);
            if ((this.fkColumns!= null)&&(!this.fkColumns.isEmpty())) {
                currentHashCode += theFkColumns.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUtype;
            theUtype = this.getUtype();
            if (this.utype!= null) {
                currentHashCode += theUtype.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theTargetTable;
            theTargetTable = this.getTargetTable();
            strategy.appendField(locator, this, "targetTable", buffer, theTargetTable, (this.targetTable!= null));
        }
        {
            List<FKColumn> theFkColumns;
            theFkColumns = (((this.fkColumns!= null)&&(!this.fkColumns.isEmpty()))?this.getFkColumns():null);
            strategy.appendField(locator, this, "fkColumns", buffer, theFkColumns, ((this.fkColumns!= null)&&(!this.fkColumns.isEmpty())));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            String theUtype;
            theUtype = this.getUtype();
            strategy.appendField(locator, this, "utype", buffer, theUtype, (this.utype!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ForeignKey) {
            final ForeignKey target = this;
            final ForeignKey leftObject = ((ForeignKey) left);
            final ForeignKey rightObject = ((ForeignKey) right);
            {
                Boolean targetTableShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.targetTable!= null), (rightObject.targetTable!= null));
                if (targetTableShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTargetTable;
                    lhsTargetTable = leftObject.getTargetTable();
                    String rhsTargetTable;
                    rhsTargetTable = rightObject.getTargetTable();
                    String mergedTargetTable = ((String) strategy.merge(LocatorUtils.property(leftLocator, "targetTable", lhsTargetTable), LocatorUtils.property(rightLocator, "targetTable", rhsTargetTable), lhsTargetTable, rhsTargetTable, (leftObject.targetTable!= null), (rightObject.targetTable!= null)));
                    target.setTargetTable(mergedTargetTable);
                } else {
                    if (targetTableShouldBeMergedAndSet == Boolean.FALSE) {
                        target.targetTable = null;
                    }
                }
            }
            {
                Boolean fkColumnsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.fkColumns!= null)&&(!leftObject.fkColumns.isEmpty())), ((rightObject.fkColumns!= null)&&(!rightObject.fkColumns.isEmpty())));
                if (fkColumnsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<FKColumn> lhsFkColumns;
                    lhsFkColumns = (((leftObject.fkColumns!= null)&&(!leftObject.fkColumns.isEmpty()))?leftObject.getFkColumns():null);
                    List<FKColumn> rhsFkColumns;
                    rhsFkColumns = (((rightObject.fkColumns!= null)&&(!rightObject.fkColumns.isEmpty()))?rightObject.getFkColumns():null);
                    List<FKColumn> mergedFkColumns = ((List<FKColumn> ) strategy.merge(LocatorUtils.property(leftLocator, "fkColumns", lhsFkColumns), LocatorUtils.property(rightLocator, "fkColumns", rhsFkColumns), lhsFkColumns, rhsFkColumns, ((leftObject.fkColumns!= null)&&(!leftObject.fkColumns.isEmpty())), ((rightObject.fkColumns!= null)&&(!rightObject.fkColumns.isEmpty()))));
                    target.fkColumns = null;
                    if (mergedFkColumns!= null) {
                        List<FKColumn> uniqueFkColumnsl = target.getFkColumns();
                        uniqueFkColumnsl.addAll(mergedFkColumns);
                    }
                } else {
                    if (fkColumnsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.fkColumns = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean utypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.utype!= null), (rightObject.utype!= null));
                if (utypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUtype;
                    lhsUtype = leftObject.getUtype();
                    String rhsUtype;
                    rhsUtype = rightObject.getUtype();
                    String mergedUtype = ((String) strategy.merge(LocatorUtils.property(leftLocator, "utype", lhsUtype), LocatorUtils.property(rightLocator, "utype", rhsUtype), lhsUtype, rhsUtype, (leftObject.utype!= null), (rightObject.utype!= null)));
                    target.setUtype(mergedUtype);
                } else {
                    if (utypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.utype = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new ForeignKey();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey clone() {
        final ForeignKey _newObject;
        try {
            _newObject = ((ForeignKey) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.fkColumns == null) {
            _newObject.fkColumns = null;
        } else {
            _newObject.fkColumns = new ArrayList<>();
            for (FKColumn _item: this.fkColumns) {
                _newObject.fkColumns.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey createCopy() {
        final ForeignKey _newObject;
        try {
            _newObject = ((ForeignKey) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.targetTable = this.targetTable;
        if (this.fkColumns == null) {
            _newObject.fkColumns = null;
        } else {
            _newObject.fkColumns = new ArrayList<>();
            for (FKColumn _item: this.fkColumns) {
                _newObject.fkColumns.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.description = this.description;
        _newObject.utype = this.utype;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ForeignKey _newObject;
        try {
            _newObject = ((ForeignKey) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree targetTablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("targetTable"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(targetTablePropertyTree!= null):((targetTablePropertyTree == null)||(!targetTablePropertyTree.isLeaf())))) {
            _newObject.targetTable = this.targetTable;
        }
        final PropertyTree fkColumnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fkColumns"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fkColumnsPropertyTree!= null):((fkColumnsPropertyTree == null)||(!fkColumnsPropertyTree.isLeaf())))) {
            if (this.fkColumns == null) {
                _newObject.fkColumns = null;
            } else {
                _newObject.fkColumns = new ArrayList<>();
                for (FKColumn _item: this.fkColumns) {
                    _newObject.fkColumns.add(((_item == null)?null:_item.createCopy(fkColumnsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
            _newObject.utype = this.utype;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ForeignKey.Modifier();
        }
        return ((ForeignKey.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ForeignKey.Builder<_B> _other) {
        _other.targetTable = this.targetTable;
        if (this.fkColumns == null) {
            _other.fkColumns = null;
        } else {
            _other.fkColumns = new ArrayList<>();
            for (FKColumn _item: this.fkColumns) {
                _other.fkColumns.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.description = this.description;
        _other.utype = this.utype;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >ForeignKey.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ForeignKey.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ForeignKey.Builder<Void> builder() {
        return new ForeignKey.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >ForeignKey.Builder<_B> copyOf(final ForeignKey _other) {
        final ForeignKey.Builder<_B> _newBuilder = new ForeignKey.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ForeignKey.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree targetTablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("targetTable"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(targetTablePropertyTree!= null):((targetTablePropertyTree == null)||(!targetTablePropertyTree.isLeaf())))) {
            _other.targetTable = this.targetTable;
        }
        final PropertyTree fkColumnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fkColumns"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fkColumnsPropertyTree!= null):((fkColumnsPropertyTree == null)||(!fkColumnsPropertyTree.isLeaf())))) {
            if (this.fkColumns == null) {
                _other.fkColumns = null;
            } else {
                _other.fkColumns = new ArrayList<>();
                for (FKColumn _item: this.fkColumns) {
                    _other.fkColumns.add(((_item == null)?null:_item.newCopyBuilder(_other, fkColumnsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
            _other.utype = this.utype;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >ForeignKey.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ForeignKey.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >ForeignKey.Builder<_B> copyOf(final ForeignKey _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ForeignKey.Builder<_B> _newBuilder = new ForeignKey.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ForeignKey.Builder<Void> copyExcept(final ForeignKey _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ForeignKey.Builder<Void> copyOnly(final ForeignKey _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ForeignKey visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ForeignKey.PropInfo.TARGET_TABLE, this));
        if (_visitor_.visit(new CollectionProperty<>(ForeignKey.PropInfo.FK_COLUMNS, this))&&(this.fkColumns!= null)) {
            for (FKColumn _item_: this.fkColumns) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(ForeignKey.PropInfo.DESCRIPTION, this));
        _visitor_.visit(new SingleProperty<>(ForeignKey.PropInfo.UTYPE, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ForeignKey _storedValue;
        private String targetTable;
        private List<FKColumn.Builder<ForeignKey.Builder<_B>>> fkColumns;
        private String description;
        private String utype;

        public Builder(final _B _parentBuilder, final ForeignKey _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.targetTable = _other.targetTable;
                    if (_other.fkColumns == null) {
                        this.fkColumns = null;
                    } else {
                        this.fkColumns = new ArrayList<>();
                        for (FKColumn _item: _other.fkColumns) {
                            this.fkColumns.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.description = _other.description;
                    this.utype = _other.utype;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ForeignKey _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree targetTablePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("targetTable"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(targetTablePropertyTree!= null):((targetTablePropertyTree == null)||(!targetTablePropertyTree.isLeaf())))) {
                        this.targetTable = _other.targetTable;
                    }
                    final PropertyTree fkColumnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fkColumns"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fkColumnsPropertyTree!= null):((fkColumnsPropertyTree == null)||(!fkColumnsPropertyTree.isLeaf())))) {
                        if (_other.fkColumns == null) {
                            this.fkColumns = null;
                        } else {
                            this.fkColumns = new ArrayList<>();
                            for (FKColumn _item: _other.fkColumns) {
                                this.fkColumns.add(((_item == null)?null:_item.newCopyBuilder(this, fkColumnsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
                        this.utype = _other.utype;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ForeignKey >_P init(final _P _product) {
            _product.targetTable = this.targetTable;
            if (this.fkColumns!= null) {
                final List<FKColumn> fkColumns = new ArrayList<>(this.fkColumns.size());
                for (FKColumn.Builder<ForeignKey.Builder<_B>> _item: this.fkColumns) {
                    fkColumns.add(_item.build());
                }
                _product.fkColumns = fkColumns;
            }
            _product.description = this.description;
            _product.utype = this.utype;
            return _product;
        }

        /**
         * Sets the new value of "targetTable" (any previous value will be replaced)
         * 
         * @param targetTable
         *     New value of the "targetTable" property.
         */
        public ForeignKey.Builder<_B> withTargetTable(final String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        /**
         * Adds the given items to the value of "fkColumns"
         * 
         * @param fkColumns
         *     Items to add to the value of the "fkColumns" property
         */
        public ForeignKey.Builder<_B> addFkColumns(final Iterable<? extends FKColumn> fkColumns) {
            if (fkColumns!= null) {
                if (this.fkColumns == null) {
                    this.fkColumns = new ArrayList<>();
                }
                for (FKColumn _item: fkColumns) {
                    this.fkColumns.add(new FKColumn.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "fkColumns" (any previous value will be replaced)
         * 
         * @param fkColumns
         *     New value of the "fkColumns" property.
         */
        public ForeignKey.Builder<_B> withFkColumns(final Iterable<? extends FKColumn> fkColumns) {
            if (this.fkColumns!= null) {
                this.fkColumns.clear();
            }
            return addFkColumns(fkColumns);
        }

        /**
         * Adds the given items to the value of "fkColumns"
         * 
         * @param fkColumns
         *     Items to add to the value of the "fkColumns" property
         */
        public ForeignKey.Builder<_B> addFkColumns(FKColumn... fkColumns) {
            addFkColumns(Arrays.asList(fkColumns));
            return this;
        }

        /**
         * Sets the new value of "fkColumns" (any previous value will be replaced)
         * 
         * @param fkColumns
         *     New value of the "fkColumns" property.
         */
        public ForeignKey.Builder<_B> withFkColumns(FKColumn... fkColumns) {
            withFkColumns(Arrays.asList(fkColumns));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "FkColumns" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.FKColumn.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "FkColumns" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.FKColumn.Builder#end()} to
         *     return to the current builder.
         */
        public FKColumn.Builder<? extends ForeignKey.Builder<_B>> addFkColumns() {
            if (this.fkColumns == null) {
                this.fkColumns = new ArrayList<>();
            }
            final FKColumn.Builder<ForeignKey.Builder<_B>> fkColumns_Builder = new FKColumn.Builder<>(this, null, false);
            this.fkColumns.add(fkColumns_Builder);
            return fkColumns_Builder;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public ForeignKey.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the new value of "utype" (any previous value will be replaced)
         * 
         * @param utype
         *     New value of the "utype" property.
         */
        public ForeignKey.Builder<_B> withUtype(final String utype) {
            this.utype = utype;
            return this;
        }

        @Override
        public ForeignKey build() {
            if (_storedValue == null) {
                return this.init(new ForeignKey());
            } else {
                return ((ForeignKey) _storedValue);
            }
        }

        public ForeignKey.Builder<_B> copyOf(final ForeignKey _other) {
            _other.copyTo(this);
            return this;
        }

        public ForeignKey.Builder<_B> copyOf(final ForeignKey.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setTargetTable(final String targetTable) {
            ForeignKey.this.setTargetTable(targetTable);
        }

        public List<FKColumn> getFkColumns() {
            if (ForeignKey.this.fkColumns == null) {
                ForeignKey.this.fkColumns = new ArrayList<>();
            }
            return ForeignKey.this.fkColumns;
        }

        public void setDescription(final String description) {
            ForeignKey.this.setDescription(description);
        }

        public void setUtype(final String utype) {
            ForeignKey.this.setUtype(utype);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ForeignKey, String> TARGET_TABLE = new SinglePropertyInfo<ForeignKey,String>("targetTable", ForeignKey.class, String.class, false, null, new QName("", "targetTable"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final ForeignKey _instance_) {
                return ((_instance_ == null)?null:_instance_.targetTable);
            }

            @Override
            public void set(final ForeignKey _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.targetTable = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<ForeignKey, FKColumn> FK_COLUMNS = new CollectionPropertyInfo<ForeignKey,FKColumn>("fkColumns", ForeignKey.class, FKColumn.class, true, null, new QName("", "fkColumn"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "FKColumn"), false) {


            @Override
            public List<FKColumn> get(final ForeignKey _instance_) {
                return ((_instance_ == null)?null:_instance_.fkColumns);
            }

            @Override
            public void set(final ForeignKey _instance_, final List<FKColumn> _value_) {
                if (_instance_!= null) {
                    _instance_.fkColumns = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ForeignKey, String> DESCRIPTION = new SinglePropertyInfo<ForeignKey,String>("description", ForeignKey.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final ForeignKey _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final ForeignKey _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ForeignKey, String> UTYPE = new SinglePropertyInfo<ForeignKey,String>("utype", ForeignKey.class, String.class, false, null, new QName("", "utype"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final ForeignKey _instance_) {
                return ((_instance_ == null)?null:_instance_.utype);
            }

            @Override
            public void set(final ForeignKey _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.utype = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ForeignKey.Selector<ForeignKey.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ForeignKey.Select _root() {
            return new ForeignKey.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> targetTable = null;
        private FKColumn.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> fkColumns = null;
        private com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> description = null;
        private com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> utype = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.targetTable!= null) {
                products.put("targetTable", this.targetTable.init());
            }
            if (this.fkColumns!= null) {
                products.put("fkColumns", this.fkColumns.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.utype!= null) {
                products.put("utype", this.utype.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> targetTable() {
            return ((this.targetTable == null)?this.targetTable = new com.kscs.util.jaxb.Selector<>(this._root, this, "targetTable"):this.targetTable);
        }

        public FKColumn.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> fkColumns() {
            return ((this.fkColumns == null)?this.fkColumns = new FKColumn.Selector<>(this._root, this, "fkColumns"):this.fkColumns);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ForeignKey.Selector<TRoot, TParent>> utype() {
            return ((this.utype == null)?this.utype = new com.kscs.util.jaxb.Selector<>(this._root, this, "utype"):this.utype);
        }

    }

}
