
package org.javastro.ivoa.entities.resource.dataservice;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A coverage on a sphere.  By default, this refers to the
 *             celestial sphere in the ICRS frame.  Non-celestial frames
 *             are indicated by non-NULL values of the frame attribute.
 * 
 * <p>Java class for SpatialCoverage complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SpatialCoverage">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>token">
 *       <attribute name="frame" type="{http://www.w3.org/2001/XMLSchema}token" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SpatialCoverage", propOrder = {
    "value"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class SpatialCoverage implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlValue
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String value;
    /**
     * VODataService 1.2 does not prescribe a vocabulary for 
     *                      what values are allowed here; an external standard.  As
     *                      long as no such vocabulary is agreed upon, the frame
     *                      attribute should not be set.
     * 
     */
    @XmlAttribute(name = "frame")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String frame;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient SpatialCoverage.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public SpatialCoverage() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SpatialCoverage(final String value, final String frame) {
        this.value = value;
        this.frame = frame;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * VODataService 1.2 does not prescribe a vocabulary for 
     *                      what values are allowed here; an external standard.  As
     *                      long as no such vocabulary is agreed upon, the frame
     *                      attribute should not be set.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getFrame() {
        return frame;
    }

    /**
     * Sets the value of the frame property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setFrame(String value) {
        this.frame = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SpatialCoverage that = ((SpatialCoverage) object);
        {
            String leftValue;
            leftValue = this.getValue();
            String rightValue;
            rightValue = that.getValue();
            if (this.value!= null) {
                if (that.value!= null) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.value!= null) {
                    return false;
                }
            }
        }
        {
            String leftFrame;
            leftFrame = this.getFrame();
            String rightFrame;
            rightFrame = that.getFrame();
            if (this.frame!= null) {
                if (that.frame!= null) {
                    if (!leftFrame.equals(rightFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.frame!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theValue;
            theValue = this.getValue();
            if (this.value!= null) {
                currentHashCode += theValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theFrame;
            theFrame = this.getFrame();
            if (this.frame!= null) {
                currentHashCode += theFrame.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue, (this.value!= null));
        }
        {
            String theFrame;
            theFrame = this.getFrame();
            strategy.appendField(locator, this, "frame", buffer, theFrame, (this.frame!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof SpatialCoverage) {
            final SpatialCoverage target = this;
            final SpatialCoverage leftObject = ((SpatialCoverage) left);
            final SpatialCoverage rightObject = ((SpatialCoverage) right);
            {
                Boolean valueShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.value!= null), (rightObject.value!= null));
                if (valueShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsValue;
                    lhsValue = leftObject.getValue();
                    String rhsValue;
                    rhsValue = rightObject.getValue();
                    String mergedValue = ((String) strategy.merge(LocatorUtils.property(leftLocator, "value", lhsValue), LocatorUtils.property(rightLocator, "value", rhsValue), lhsValue, rhsValue, (leftObject.value!= null), (rightObject.value!= null)));
                    target.setValue(mergedValue);
                } else {
                    if (valueShouldBeMergedAndSet == Boolean.FALSE) {
                        target.value = null;
                    }
                }
            }
            {
                Boolean frameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.frame!= null), (rightObject.frame!= null));
                if (frameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsFrame;
                    lhsFrame = leftObject.getFrame();
                    String rhsFrame;
                    rhsFrame = rightObject.getFrame();
                    String mergedFrame = ((String) strategy.merge(LocatorUtils.property(leftLocator, "frame", lhsFrame), LocatorUtils.property(rightLocator, "frame", rhsFrame), lhsFrame, rhsFrame, (leftObject.frame!= null), (rightObject.frame!= null)));
                    target.setFrame(mergedFrame);
                } else {
                    if (frameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.frame = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new SpatialCoverage();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage clone() {
        final SpatialCoverage _newObject;
        try {
            _newObject = ((SpatialCoverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage createCopy() {
        final SpatialCoverage _newObject;
        try {
            _newObject = ((SpatialCoverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.value = this.value;
        _newObject.frame = this.frame;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpatialCoverage _newObject;
        try {
            _newObject = ((SpatialCoverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _newObject.value = this.value;
        }
        final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
            _newObject.frame = this.frame;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SpatialCoverage.Modifier();
        }
        return ((SpatialCoverage.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SpatialCoverage.Builder<_B> _other) {
        _other.value = this.value;
        _other.frame = this.frame;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SpatialCoverage.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SpatialCoverage.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpatialCoverage.Builder<Void> builder() {
        return new SpatialCoverage.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpatialCoverage.Builder<_B> copyOf(final SpatialCoverage _other) {
        final SpatialCoverage.Builder<_B> _newBuilder = new SpatialCoverage.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SpatialCoverage.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _other.value = this.value;
        }
        final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
            _other.frame = this.frame;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SpatialCoverage.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SpatialCoverage.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpatialCoverage.Builder<_B> copyOf(final SpatialCoverage _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpatialCoverage.Builder<_B> _newBuilder = new SpatialCoverage.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpatialCoverage.Builder<Void> copyExcept(final SpatialCoverage _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpatialCoverage.Builder<Void> copyOnly(final SpatialCoverage _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpatialCoverage visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(SpatialCoverage.PropInfo.VALUE, this));
        _visitor_.visit(new SingleProperty<>(SpatialCoverage.PropInfo.FRAME, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final SpatialCoverage _storedValue;
        private String value;
        private String frame;

        public Builder(final _B _parentBuilder, final SpatialCoverage _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.value = _other.value;
                    this.frame = _other.frame;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final SpatialCoverage _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
                        this.value = _other.value;
                    }
                    final PropertyTree framePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frame"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(framePropertyTree!= null):((framePropertyTree == null)||(!framePropertyTree.isLeaf())))) {
                        this.frame = _other.frame;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends SpatialCoverage >_P init(final _P _product) {
            _product.value = this.value;
            _product.frame = this.frame;
            return _product;
        }

        /**
         * Sets the new value of "value" (any previous value will be replaced)
         * 
         * @param value
         *     New value of the "value" property.
         */
        public SpatialCoverage.Builder<_B> withValue(final String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the new value of "frame" (any previous value will be replaced)
         * 
         * @param frame
         *     New value of the "frame" property.
         */
        public SpatialCoverage.Builder<_B> withFrame(final String frame) {
            this.frame = frame;
            return this;
        }

        @Override
        public SpatialCoverage build() {
            if (_storedValue == null) {
                return this.init(new SpatialCoverage());
            } else {
                return ((SpatialCoverage) _storedValue);
            }
        }

        public SpatialCoverage.Builder<_B> copyOf(final SpatialCoverage _other) {
            _other.copyTo(this);
            return this;
        }

        public SpatialCoverage.Builder<_B> copyOf(final SpatialCoverage.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setValue(final String value) {
            SpatialCoverage.this.setValue(value);
        }

        public void setFrame(final String frame) {
            SpatialCoverage.this.setFrame(frame);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SpatialCoverage, String> VALUE = new SinglePropertyInfo<SpatialCoverage,String>("value", SpatialCoverage.class, String.class, false, null, new QName("http://www.w3.org/2001/XMLSchema", "token"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final SpatialCoverage _instance_) {
                return ((_instance_ == null)?null:_instance_.value);
            }

            @Override
            public void set(final SpatialCoverage _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.value = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SpatialCoverage, String> FRAME = new SinglePropertyInfo<SpatialCoverage,String>("frame", SpatialCoverage.class, String.class, false, null, new QName("", "frame"), new QName("http://www.w3.org/2001/XMLSchema", "token"), true) {


            @Override
            public String get(final SpatialCoverage _instance_) {
                return ((_instance_ == null)?null:_instance_.frame);
            }

            @Override
            public void set(final SpatialCoverage _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.frame = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SpatialCoverage.Selector<SpatialCoverage.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SpatialCoverage.Select _root() {
            return new SpatialCoverage.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SpatialCoverage.Selector<TRoot, TParent>> value = null;
        private com.kscs.util.jaxb.Selector<TRoot, SpatialCoverage.Selector<TRoot, TParent>> frame = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.value!= null) {
                products.put("value", this.value.init());
            }
            if (this.frame!= null) {
                products.put("frame", this.frame.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpatialCoverage.Selector<TRoot, TParent>> value() {
            return ((this.value == null)?this.value = new com.kscs.util.jaxb.Selector<>(this._root, this, "value"):this.value);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpatialCoverage.Selector<TRoot, TParent>> frame() {
            return ((this.frame == null)?this.frame = new com.kscs.util.jaxb.Selector<>(this._root, this, "frame"):this.frame);
        }

    }

}
