
package org.javastro.ivoa.entities.resource.dataservice;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * 
 * 
 * <p>Java class for Waveband</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="Waveband">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="Radio"/>
 *     <enumeration value="Millimeter"/>
 *     <enumeration value="Infrared"/>
 *     <enumeration value="Optical"/>
 *     <enumeration value="UV"/>
 *     <enumeration value="EUV"/>
 *     <enumeration value="X-ray"/>
 *     <enumeration value="Gamma-ray"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "Waveband")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public enum Waveband implements EnumValue<String>
{


    /**
     * wavelength >= 10 mm; frequency <= 30 GHz.
     * 
     */
    @XmlEnumValue("Radio")
    RADIO("Radio"),

    /**
     *  0.1 mm <= wavelength <= 10 mm; 
     *                  3000 GHz >= frequency >= 30 GHz.
     * 
     */
    @XmlEnumValue("Millimeter")
    MILLIMETER("Millimeter"),

    /**
     *  1 micron <= wavelength <= 100 micons
     * 
     */
    @XmlEnumValue("Infrared")
    INFRARED("Infrared"),

    /**
     *  300 nm <= wavelength <= 1000 nm;
     * 
     */
    @XmlEnumValue("Optical")
    OPTICAL("Optical"),

    /**
     *  100 nm <= wavelength <= 300 nm;
     * 
     */
    UV("UV"),

    /**
     *  12 eV <= energy <= 120 eV
     * 
     */
    EUV("EUV"),

    /**
     *  0.12 keV <= energy <= 120 keV
     * 
     */
    @XmlEnumValue("X-ray")
    X_RAY("X-ray"),

    /**
     * energy >= 120 keV
     * 
     */
    @XmlEnumValue("Gamma-ray")
    GAMMA_RAY("Gamma-ray");
    private final String value;

    Waveband(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static Waveband fromValue(String v) {
        for (Waveband c: Waveband.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
