
package org.javastro.ivoa.entities.resource.sia;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * The class of image service: Cutout, Mosaic, Atlas, Pointed
 * 
 * <p>Java class for ImageServiceType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="ImageServiceType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="Cutout"/>
 *     <enumeration value="Mosaic"/>
 *     <enumeration value="Atlas"/>
 *     <enumeration value="Pointed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ImageServiceType")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public enum ImageServiceType implements EnumValue<String>
{


    /**
     * This is a service which extracts or "cuts out" rectangular
     *          regions of some larger image, returning an image of the
     *          requested size to the client. Such images are usually drawn
     *          from a database or a collection of survey images that cover
     *          some large portion of the sky. To be considered a cutout
     *          service, the returned image should closely approximate (or at
     *          least not exceed) the size of the requested region; however,
     *          a cutout service will not normally resample (rescale or
     *          reproject) the pixel data. A cutout service may mosaic image
     *          segments to cover a large region but is still considered a
     *          cutout service if it does not resample the data.  Image
     *          cutout services are fast and avoid image degredation due to
     *          resampling.
     * 
     */
    @XmlEnumValue("Cutout")
    CUTOUT("Cutout"),

    /**
     * This service is similar to the image cutout service
     *                   but adds the capability to compute an image of the
     *                   size, scale, and projection specified by the
     *                   client. Mosaic services include services which
     *                   resample and reproject existing image data, as well
     *                   as services which generate pixels from some more
     *                   fundamental dataset, e.g., a high energy event list
     *                   or a radio astronomy measurement set. Image mosaics
     *                   can be expensive to generate for large regions but
     *                   they make it easier for the client to overlay image
     *                   data from different sources. Image mosaicing
     *                   services which resample already pixelated data will
     *                   degrade the data slightly, unlike the simpler cutout
     *                   service which returns the data unchanged.
     * 
     */
    @XmlEnumValue("Mosaic")
    MOSAIC("Mosaic"),

    /**
     * This category of service provides access to
     *                   pre-computed images that make up a survey of some
     *                   large portion of the sky. The service, however, is
     *                   not capable of dynamically cutting out requested
     *                   regions, and the size of atlas images is
     *                   predetermined by the survey. Atlas images may range
     *                   in size from small cutouts of extended objects to
     *                   large calibrated survey data frames.
     * 
     */
    @XmlEnumValue("Atlas")
    ATLAS("Atlas"),

    /**
     * This category of service provides access to
     *                   collections of images of many small, "pointed"
     *                   regions of the sky. "Pointed" images normally focus
     *                   on specific sources in the sky as opposed to being
     *                   part of a sky survey. This type of service usually
     *                   applies to instrumental archives from observatories
     *                   with guest observer programs (e.g., the HST archive)
     *                   and other general purpose image archives (e.g., the
     *                   ADIL). If a service provides access to both survey
     *                   and pointed images, then it should be considered a
     *                   Pointed Image Archive for the purposes of this
     *                   specification; if a differentiation between the
     *                   types of data is desired the pointed and survey data
     *                   collections should be registered as separate image
     *                   services.
     * 
     */
    @XmlEnumValue("Pointed")
    POINTED("Pointed");
    private final String value;

    ImageServiceType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static ImageServiceType fromValue(String v) {
        for (ImageServiceType c: ImageServiceType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
