
package org.javastro.ivoa.entities.resource.ssap;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The capabilities of an SSA service implementation.
 * 
 * <p>Java class for SimpleSpectralAccess complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SimpleSpectralAccess">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Capability">
 *       <sequence>
 *         <element name="complianceLevel" type="{http://www.ivoa.net/xml/SSA/v1.1}ComplianceLevel"/>
 *         <element name="dataSource" type="{http://www.ivoa.net/xml/SSA/v1.1}DataSource" maxOccurs="unbounded"/>
 *         <element name="creationType" type="{http://www.ivoa.net/xml/SSA/v1.1}CreationType" maxOccurs="unbounded"/>
 *         <element name="supportedFrame" type="{http://www.ivoa.net/xml/SSA/v1.1}SupportedFrame" maxOccurs="unbounded"/>
 *         <element name="maxSearchRadius" type="{http://www.w3.org/2001/XMLSchema}double" minOccurs="0"/>
 *         <element name="maxRecords" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="defaultMaxRecords" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="maxAperture" type="{http://www.w3.org/2001/XMLSchema}double" minOccurs="0"/>
 *         <element name="maxFileSize" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="testQuery" type="{http://www.ivoa.net/xml/SSA/v1.1}Query" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SimpleSpectralAccess", propOrder = {
    "complianceLevel",
    "dataSources",
    "creationTypes",
    "supportedFrames",
    "maxSearchRadius",
    "maxRecords",
    "defaultMaxRecords",
    "maxAperture",
    "maxFileSize",
    "testQuery"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class SimpleSpectralAccess
    extends Capability
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Allowed values are "query", "minimal", and "full".
     *                         See definitions of allowed values for details.
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected ComplianceLevel complianceLevel;
    /**
     * Allowed values are "survey", "pointed", "custom",
     *                         "theory", "artificial"
     * 
     */
    @XmlElement(name = "dataSource", required = true)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<DataSource> dataSources;
    /**
     * Allowed values are "archival", "cutout", "filtered",
     *                         "mosaic", "projection", "spectralExtraction", 
     *                         "catalogExtraction"
     * 
     */
    @XmlElement(name = "creationType", required = true)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<CreationType> creationTypes;
    /**
     * At least one recognized value must be listed.
     *                         With SSA v1.1, ICRS must be supported; thus,
     *                         this list must include at least this value.
     * 
     */
    @XmlElement(name = "supportedFrame", required = true)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<SupportedFrame> supportedFrames;
    /**
     * Not providing a value is the prefered way to indicate
     *                         that there is no restriction.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Double maxSearchRadius;
    /**
     * This does not refer to the total number of spectra in 
     *                         the archive but rather maximum number of records the 
     *                         service is capable of returning.  A limit that is 
     *                         greater than the number of spectra available in the 
     *                         archive is equivalent to their being no effective 
     *                         limit.  (See RM, Hanisch 2007.)
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger maxRecords;
    /**
     * The largest number of records that the service will
     *                         return when the MAXREC parameter not specified
     *                         in the query input.  Not providing a value means 
     *                         that the hard limit implied by maxRecords will be 
     *                         the default limit.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger defaultMaxRecords;
    /**
     * Not providing a value is the preferred way to 
     *                         indicate that there is no limit.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Double maxAperture;
    /**
     * This is primarily relevant when spectra are created
     *                         on the fly (see creationType).  If the service 
     *                         provides access to static spectra, this should only 
     *                         be specified if there are spectra in the archive that
     *                         can be searched for but not returned because they are 
     *                         too big.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger maxFileSize;
    /**
     * a set of query parameters that is expected to
     *                         produce at least one matched record which can be
     *                         used to test the service.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Query testQuery;

    /**
     * Default no-arg constructor
     * 
     */
    public SimpleSpectralAccess() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SimpleSpectralAccess(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID, final ComplianceLevel complianceLevel, final List<DataSource> dataSources, final List<CreationType> creationTypes, final List<SupportedFrame> supportedFrames, final Double maxSearchRadius, final BigInteger maxRecords, final BigInteger defaultMaxRecords, final Double maxAperture, final BigInteger maxFileSize, final Query testQuery) {
        super(validationLevels, description, interfaces, standardID);
        this.complianceLevel = complianceLevel;
        this.dataSources = dataSources;
        this.creationTypes = creationTypes;
        this.supportedFrames = supportedFrames;
        this.maxSearchRadius = maxSearchRadius;
        this.maxRecords = maxRecords;
        this.defaultMaxRecords = defaultMaxRecords;
        this.maxAperture = maxAperture;
        this.maxFileSize = maxFileSize;
        this.testQuery = testQuery;
    }

    /**
     * Allowed values are "query", "minimal", and "full".
     *                         See definitions of allowed values for details.
     * 
     * @return
     *     possible object is
     *     {@link ComplianceLevel }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ComplianceLevel getComplianceLevel() {
        return complianceLevel;
    }

    /**
     * Sets the value of the complianceLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link ComplianceLevel }
     *     
     * @see #getComplianceLevel()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setComplianceLevel(ComplianceLevel value) {
        this.complianceLevel = value;
    }

    /**
     * Allowed values are "survey", "pointed", "custom",
     *                         "theory", "artificial"
     * 
     * Gets the value of the dataSources property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dataSources property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDataSources().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DataSource }
     * </p>
     * 
     * 
     * @return
     *     The value of the dataSources property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<DataSource> getDataSources() {
        if (dataSources == null) {
            dataSources = new ArrayList<>();
        }
        return this.dataSources;
    }

    /**
     * Allowed values are "archival", "cutout", "filtered",
     *                         "mosaic", "projection", "spectralExtraction", 
     *                         "catalogExtraction"
     * 
     * Gets the value of the creationTypes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the creationTypes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCreationTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CreationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the creationTypes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<CreationType> getCreationTypes() {
        if (creationTypes == null) {
            creationTypes = new ArrayList<>();
        }
        return this.creationTypes;
    }

    /**
     * At least one recognized value must be listed.
     *                         With SSA v1.1, ICRS must be supported; thus,
     *                         this list must include at least this value.
     * 
     * Gets the value of the supportedFrames property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the supportedFrames property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSupportedFrames().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SupportedFrame }
     * </p>
     * 
     * 
     * @return
     *     The value of the supportedFrames property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<SupportedFrame> getSupportedFrames() {
        if (supportedFrames == null) {
            supportedFrames = new ArrayList<>();
        }
        return this.supportedFrames;
    }

    /**
     * Not providing a value is the prefered way to indicate
     *                         that there is no restriction.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Double getMaxSearchRadius() {
        return maxSearchRadius;
    }

    /**
     * Sets the value of the maxSearchRadius property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     * @see #getMaxSearchRadius()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setMaxSearchRadius(Double value) {
        this.maxSearchRadius = value;
    }

    /**
     * This does not refer to the total number of spectra in 
     *                         the archive but rather maximum number of records the 
     *                         service is capable of returning.  A limit that is 
     *                         greater than the number of spectra available in the 
     *                         archive is equivalent to their being no effective 
     *                         limit.  (See RM, Hanisch 2007.)
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getMaxRecords() {
        return maxRecords;
    }

    /**
     * Sets the value of the maxRecords property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getMaxRecords()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setMaxRecords(BigInteger value) {
        this.maxRecords = value;
    }

    /**
     * The largest number of records that the service will
     *                         return when the MAXREC parameter not specified
     *                         in the query input.  Not providing a value means 
     *                         that the hard limit implied by maxRecords will be 
     *                         the default limit.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getDefaultMaxRecords() {
        return defaultMaxRecords;
    }

    /**
     * Sets the value of the defaultMaxRecords property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getDefaultMaxRecords()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setDefaultMaxRecords(BigInteger value) {
        this.defaultMaxRecords = value;
    }

    /**
     * Not providing a value is the preferred way to 
     *                         indicate that there is no limit.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Double getMaxAperture() {
        return maxAperture;
    }

    /**
     * Sets the value of the maxAperture property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     * @see #getMaxAperture()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setMaxAperture(Double value) {
        this.maxAperture = value;
    }

    /**
     * This is primarily relevant when spectra are created
     *                         on the fly (see creationType).  If the service 
     *                         provides access to static spectra, this should only 
     *                         be specified if there are spectra in the archive that
     *                         can be searched for but not returned because they are 
     *                         too big.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getMaxFileSize() {
        return maxFileSize;
    }

    /**
     * Sets the value of the maxFileSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getMaxFileSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setMaxFileSize(BigInteger value) {
        this.maxFileSize = value;
    }

    /**
     * a set of query parameters that is expected to
     *                         produce at least one matched record which can be
     *                         used to test the service.
     * 
     * @return
     *     possible object is
     *     {@link Query }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Query getTestQuery() {
        return testQuery;
    }

    /**
     * Sets the value of the testQuery property.
     * 
     * @param value
     *     allowed object is
     *     {@link Query }
     *     
     * @see #getTestQuery()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setTestQuery(Query value) {
        this.testQuery = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SimpleSpectralAccess that = ((SimpleSpectralAccess) object);
        {
            ComplianceLevel leftComplianceLevel;
            leftComplianceLevel = this.getComplianceLevel();
            ComplianceLevel rightComplianceLevel;
            rightComplianceLevel = that.getComplianceLevel();
            if (this.complianceLevel!= null) {
                if (that.complianceLevel!= null) {
                    if (!leftComplianceLevel.equals(rightComplianceLevel)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.complianceLevel!= null) {
                    return false;
                }
            }
        }
        {
            List<DataSource> leftDataSources;
            leftDataSources = (((this.dataSources!= null)&&(!this.dataSources.isEmpty()))?this.getDataSources():null);
            List<DataSource> rightDataSources;
            rightDataSources = (((that.dataSources!= null)&&(!that.dataSources.isEmpty()))?that.getDataSources():null);
            if ((this.dataSources!= null)&&(!this.dataSources.isEmpty())) {
                if ((that.dataSources!= null)&&(!that.dataSources.isEmpty())) {
                    if (!leftDataSources.equals(rightDataSources)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.dataSources!= null)&&(!that.dataSources.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<CreationType> leftCreationTypes;
            leftCreationTypes = (((this.creationTypes!= null)&&(!this.creationTypes.isEmpty()))?this.getCreationTypes():null);
            List<CreationType> rightCreationTypes;
            rightCreationTypes = (((that.creationTypes!= null)&&(!that.creationTypes.isEmpty()))?that.getCreationTypes():null);
            if ((this.creationTypes!= null)&&(!this.creationTypes.isEmpty())) {
                if ((that.creationTypes!= null)&&(!that.creationTypes.isEmpty())) {
                    if (!leftCreationTypes.equals(rightCreationTypes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.creationTypes!= null)&&(!that.creationTypes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<SupportedFrame> leftSupportedFrames;
            leftSupportedFrames = (((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty()))?this.getSupportedFrames():null);
            List<SupportedFrame> rightSupportedFrames;
            rightSupportedFrames = (((that.supportedFrames!= null)&&(!that.supportedFrames.isEmpty()))?that.getSupportedFrames():null);
            if ((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty())) {
                if ((that.supportedFrames!= null)&&(!that.supportedFrames.isEmpty())) {
                    if (!leftSupportedFrames.equals(rightSupportedFrames)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.supportedFrames!= null)&&(!that.supportedFrames.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Double leftMaxSearchRadius;
            leftMaxSearchRadius = this.getMaxSearchRadius();
            Double rightMaxSearchRadius;
            rightMaxSearchRadius = that.getMaxSearchRadius();
            if (this.maxSearchRadius!= null) {
                if (that.maxSearchRadius!= null) {
                    if (!leftMaxSearchRadius.equals(rightMaxSearchRadius)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxSearchRadius!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMaxRecords;
            leftMaxRecords = this.getMaxRecords();
            BigInteger rightMaxRecords;
            rightMaxRecords = that.getMaxRecords();
            if (this.maxRecords!= null) {
                if (that.maxRecords!= null) {
                    if (!leftMaxRecords.equals(rightMaxRecords)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxRecords!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftDefaultMaxRecords;
            leftDefaultMaxRecords = this.getDefaultMaxRecords();
            BigInteger rightDefaultMaxRecords;
            rightDefaultMaxRecords = that.getDefaultMaxRecords();
            if (this.defaultMaxRecords!= null) {
                if (that.defaultMaxRecords!= null) {
                    if (!leftDefaultMaxRecords.equals(rightDefaultMaxRecords)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.defaultMaxRecords!= null) {
                    return false;
                }
            }
        }
        {
            Double leftMaxAperture;
            leftMaxAperture = this.getMaxAperture();
            Double rightMaxAperture;
            rightMaxAperture = that.getMaxAperture();
            if (this.maxAperture!= null) {
                if (that.maxAperture!= null) {
                    if (!leftMaxAperture.equals(rightMaxAperture)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxAperture!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMaxFileSize;
            leftMaxFileSize = this.getMaxFileSize();
            BigInteger rightMaxFileSize;
            rightMaxFileSize = that.getMaxFileSize();
            if (this.maxFileSize!= null) {
                if (that.maxFileSize!= null) {
                    if (!leftMaxFileSize.equals(rightMaxFileSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxFileSize!= null) {
                    return false;
                }
            }
        }
        {
            Query leftTestQuery;
            leftTestQuery = this.getTestQuery();
            Query rightTestQuery;
            rightTestQuery = that.getTestQuery();
            if (this.testQuery!= null) {
                if (that.testQuery!= null) {
                    if (!leftTestQuery.equals(rightTestQuery)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.testQuery!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ComplianceLevel theComplianceLevel;
            theComplianceLevel = this.getComplianceLevel();
            if (this.complianceLevel!= null) {
                currentHashCode += theComplianceLevel.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<DataSource> theDataSources;
            theDataSources = (((this.dataSources!= null)&&(!this.dataSources.isEmpty()))?this.getDataSources():null);
            if ((this.dataSources!= null)&&(!this.dataSources.isEmpty())) {
                currentHashCode += theDataSources.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<CreationType> theCreationTypes;
            theCreationTypes = (((this.creationTypes!= null)&&(!this.creationTypes.isEmpty()))?this.getCreationTypes():null);
            if ((this.creationTypes!= null)&&(!this.creationTypes.isEmpty())) {
                currentHashCode += theCreationTypes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<SupportedFrame> theSupportedFrames;
            theSupportedFrames = (((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty()))?this.getSupportedFrames():null);
            if ((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty())) {
                currentHashCode += theSupportedFrames.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double theMaxSearchRadius;
            theMaxSearchRadius = this.getMaxSearchRadius();
            if (this.maxSearchRadius!= null) {
                currentHashCode += theMaxSearchRadius.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            if (this.maxRecords!= null) {
                currentHashCode += theMaxRecords.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theDefaultMaxRecords;
            theDefaultMaxRecords = this.getDefaultMaxRecords();
            if (this.defaultMaxRecords!= null) {
                currentHashCode += theDefaultMaxRecords.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double theMaxAperture;
            theMaxAperture = this.getMaxAperture();
            if (this.maxAperture!= null) {
                currentHashCode += theMaxAperture.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMaxFileSize;
            theMaxFileSize = this.getMaxFileSize();
            if (this.maxFileSize!= null) {
                currentHashCode += theMaxFileSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Query theTestQuery;
            theTestQuery = this.getTestQuery();
            if (this.testQuery!= null) {
                currentHashCode += theTestQuery.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            ComplianceLevel theComplianceLevel;
            theComplianceLevel = this.getComplianceLevel();
            strategy.appendField(locator, this, "complianceLevel", buffer, theComplianceLevel, (this.complianceLevel!= null));
        }
        {
            List<DataSource> theDataSources;
            theDataSources = (((this.dataSources!= null)&&(!this.dataSources.isEmpty()))?this.getDataSources():null);
            strategy.appendField(locator, this, "dataSources", buffer, theDataSources, ((this.dataSources!= null)&&(!this.dataSources.isEmpty())));
        }
        {
            List<CreationType> theCreationTypes;
            theCreationTypes = (((this.creationTypes!= null)&&(!this.creationTypes.isEmpty()))?this.getCreationTypes():null);
            strategy.appendField(locator, this, "creationTypes", buffer, theCreationTypes, ((this.creationTypes!= null)&&(!this.creationTypes.isEmpty())));
        }
        {
            List<SupportedFrame> theSupportedFrames;
            theSupportedFrames = (((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty()))?this.getSupportedFrames():null);
            strategy.appendField(locator, this, "supportedFrames", buffer, theSupportedFrames, ((this.supportedFrames!= null)&&(!this.supportedFrames.isEmpty())));
        }
        {
            Double theMaxSearchRadius;
            theMaxSearchRadius = this.getMaxSearchRadius();
            strategy.appendField(locator, this, "maxSearchRadius", buffer, theMaxSearchRadius, (this.maxSearchRadius!= null));
        }
        {
            BigInteger theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            strategy.appendField(locator, this, "maxRecords", buffer, theMaxRecords, (this.maxRecords!= null));
        }
        {
            BigInteger theDefaultMaxRecords;
            theDefaultMaxRecords = this.getDefaultMaxRecords();
            strategy.appendField(locator, this, "defaultMaxRecords", buffer, theDefaultMaxRecords, (this.defaultMaxRecords!= null));
        }
        {
            Double theMaxAperture;
            theMaxAperture = this.getMaxAperture();
            strategy.appendField(locator, this, "maxAperture", buffer, theMaxAperture, (this.maxAperture!= null));
        }
        {
            BigInteger theMaxFileSize;
            theMaxFileSize = this.getMaxFileSize();
            strategy.appendField(locator, this, "maxFileSize", buffer, theMaxFileSize, (this.maxFileSize!= null));
        }
        {
            Query theTestQuery;
            theTestQuery = this.getTestQuery();
            strategy.appendField(locator, this, "testQuery", buffer, theTestQuery, (this.testQuery!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SimpleSpectralAccess) {
            final SimpleSpectralAccess target = this;
            final SimpleSpectralAccess leftObject = ((SimpleSpectralAccess) left);
            final SimpleSpectralAccess rightObject = ((SimpleSpectralAccess) right);
            {
                Boolean complianceLevelShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.complianceLevel!= null), (rightObject.complianceLevel!= null));
                if (complianceLevelShouldBeMergedAndSet == Boolean.TRUE) {
                    ComplianceLevel lhsComplianceLevel;
                    lhsComplianceLevel = leftObject.getComplianceLevel();
                    ComplianceLevel rhsComplianceLevel;
                    rhsComplianceLevel = rightObject.getComplianceLevel();
                    ComplianceLevel mergedComplianceLevel = ((ComplianceLevel) strategy.merge(LocatorUtils.property(leftLocator, "complianceLevel", lhsComplianceLevel), LocatorUtils.property(rightLocator, "complianceLevel", rhsComplianceLevel), lhsComplianceLevel, rhsComplianceLevel, (leftObject.complianceLevel!= null), (rightObject.complianceLevel!= null)));
                    target.setComplianceLevel(mergedComplianceLevel);
                } else {
                    if (complianceLevelShouldBeMergedAndSet == Boolean.FALSE) {
                        target.complianceLevel = null;
                    }
                }
            }
            {
                Boolean dataSourcesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.dataSources!= null)&&(!leftObject.dataSources.isEmpty())), ((rightObject.dataSources!= null)&&(!rightObject.dataSources.isEmpty())));
                if (dataSourcesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<DataSource> lhsDataSources;
                    lhsDataSources = (((leftObject.dataSources!= null)&&(!leftObject.dataSources.isEmpty()))?leftObject.getDataSources():null);
                    List<DataSource> rhsDataSources;
                    rhsDataSources = (((rightObject.dataSources!= null)&&(!rightObject.dataSources.isEmpty()))?rightObject.getDataSources():null);
                    List<DataSource> mergedDataSources = ((List<DataSource> ) strategy.merge(LocatorUtils.property(leftLocator, "dataSources", lhsDataSources), LocatorUtils.property(rightLocator, "dataSources", rhsDataSources), lhsDataSources, rhsDataSources, ((leftObject.dataSources!= null)&&(!leftObject.dataSources.isEmpty())), ((rightObject.dataSources!= null)&&(!rightObject.dataSources.isEmpty()))));
                    target.dataSources = null;
                    if (mergedDataSources!= null) {
                        List<DataSource> uniqueDataSourcesl = target.getDataSources();
                        uniqueDataSourcesl.addAll(mergedDataSources);
                    }
                } else {
                    if (dataSourcesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.dataSources = null;
                    }
                }
            }
            {
                Boolean creationTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.creationTypes!= null)&&(!leftObject.creationTypes.isEmpty())), ((rightObject.creationTypes!= null)&&(!rightObject.creationTypes.isEmpty())));
                if (creationTypesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<CreationType> lhsCreationTypes;
                    lhsCreationTypes = (((leftObject.creationTypes!= null)&&(!leftObject.creationTypes.isEmpty()))?leftObject.getCreationTypes():null);
                    List<CreationType> rhsCreationTypes;
                    rhsCreationTypes = (((rightObject.creationTypes!= null)&&(!rightObject.creationTypes.isEmpty()))?rightObject.getCreationTypes():null);
                    List<CreationType> mergedCreationTypes = ((List<CreationType> ) strategy.merge(LocatorUtils.property(leftLocator, "creationTypes", lhsCreationTypes), LocatorUtils.property(rightLocator, "creationTypes", rhsCreationTypes), lhsCreationTypes, rhsCreationTypes, ((leftObject.creationTypes!= null)&&(!leftObject.creationTypes.isEmpty())), ((rightObject.creationTypes!= null)&&(!rightObject.creationTypes.isEmpty()))));
                    target.creationTypes = null;
                    if (mergedCreationTypes!= null) {
                        List<CreationType> uniqueCreationTypesl = target.getCreationTypes();
                        uniqueCreationTypesl.addAll(mergedCreationTypes);
                    }
                } else {
                    if (creationTypesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.creationTypes = null;
                    }
                }
            }
            {
                Boolean supportedFramesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.supportedFrames!= null)&&(!leftObject.supportedFrames.isEmpty())), ((rightObject.supportedFrames!= null)&&(!rightObject.supportedFrames.isEmpty())));
                if (supportedFramesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<SupportedFrame> lhsSupportedFrames;
                    lhsSupportedFrames = (((leftObject.supportedFrames!= null)&&(!leftObject.supportedFrames.isEmpty()))?leftObject.getSupportedFrames():null);
                    List<SupportedFrame> rhsSupportedFrames;
                    rhsSupportedFrames = (((rightObject.supportedFrames!= null)&&(!rightObject.supportedFrames.isEmpty()))?rightObject.getSupportedFrames():null);
                    List<SupportedFrame> mergedSupportedFrames = ((List<SupportedFrame> ) strategy.merge(LocatorUtils.property(leftLocator, "supportedFrames", lhsSupportedFrames), LocatorUtils.property(rightLocator, "supportedFrames", rhsSupportedFrames), lhsSupportedFrames, rhsSupportedFrames, ((leftObject.supportedFrames!= null)&&(!leftObject.supportedFrames.isEmpty())), ((rightObject.supportedFrames!= null)&&(!rightObject.supportedFrames.isEmpty()))));
                    target.supportedFrames = null;
                    if (mergedSupportedFrames!= null) {
                        List<SupportedFrame> uniqueSupportedFramesl = target.getSupportedFrames();
                        uniqueSupportedFramesl.addAll(mergedSupportedFrames);
                    }
                } else {
                    if (supportedFramesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.supportedFrames = null;
                    }
                }
            }
            {
                Boolean maxSearchRadiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxSearchRadius!= null), (rightObject.maxSearchRadius!= null));
                if (maxSearchRadiusShouldBeMergedAndSet == Boolean.TRUE) {
                    Double lhsMaxSearchRadius;
                    lhsMaxSearchRadius = leftObject.getMaxSearchRadius();
                    Double rhsMaxSearchRadius;
                    rhsMaxSearchRadius = rightObject.getMaxSearchRadius();
                    Double mergedMaxSearchRadius = ((Double) strategy.merge(LocatorUtils.property(leftLocator, "maxSearchRadius", lhsMaxSearchRadius), LocatorUtils.property(rightLocator, "maxSearchRadius", rhsMaxSearchRadius), lhsMaxSearchRadius, rhsMaxSearchRadius, (leftObject.maxSearchRadius!= null), (rightObject.maxSearchRadius!= null)));
                    target.setMaxSearchRadius(mergedMaxSearchRadius);
                } else {
                    if (maxSearchRadiusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxSearchRadius = null;
                    }
                }
            }
            {
                Boolean maxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxRecords!= null), (rightObject.maxRecords!= null));
                if (maxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsMaxRecords;
                    lhsMaxRecords = leftObject.getMaxRecords();
                    BigInteger rhsMaxRecords;
                    rhsMaxRecords = rightObject.getMaxRecords();
                    BigInteger mergedMaxRecords = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "maxRecords", lhsMaxRecords), LocatorUtils.property(rightLocator, "maxRecords", rhsMaxRecords), lhsMaxRecords, rhsMaxRecords, (leftObject.maxRecords!= null), (rightObject.maxRecords!= null)));
                    target.setMaxRecords(mergedMaxRecords);
                } else {
                    if (maxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxRecords = null;
                    }
                }
            }
            {
                Boolean defaultMaxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.defaultMaxRecords!= null), (rightObject.defaultMaxRecords!= null));
                if (defaultMaxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsDefaultMaxRecords;
                    lhsDefaultMaxRecords = leftObject.getDefaultMaxRecords();
                    BigInteger rhsDefaultMaxRecords;
                    rhsDefaultMaxRecords = rightObject.getDefaultMaxRecords();
                    BigInteger mergedDefaultMaxRecords = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "defaultMaxRecords", lhsDefaultMaxRecords), LocatorUtils.property(rightLocator, "defaultMaxRecords", rhsDefaultMaxRecords), lhsDefaultMaxRecords, rhsDefaultMaxRecords, (leftObject.defaultMaxRecords!= null), (rightObject.defaultMaxRecords!= null)));
                    target.setDefaultMaxRecords(mergedDefaultMaxRecords);
                } else {
                    if (defaultMaxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.defaultMaxRecords = null;
                    }
                }
            }
            {
                Boolean maxApertureShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxAperture!= null), (rightObject.maxAperture!= null));
                if (maxApertureShouldBeMergedAndSet == Boolean.TRUE) {
                    Double lhsMaxAperture;
                    lhsMaxAperture = leftObject.getMaxAperture();
                    Double rhsMaxAperture;
                    rhsMaxAperture = rightObject.getMaxAperture();
                    Double mergedMaxAperture = ((Double) strategy.merge(LocatorUtils.property(leftLocator, "maxAperture", lhsMaxAperture), LocatorUtils.property(rightLocator, "maxAperture", rhsMaxAperture), lhsMaxAperture, rhsMaxAperture, (leftObject.maxAperture!= null), (rightObject.maxAperture!= null)));
                    target.setMaxAperture(mergedMaxAperture);
                } else {
                    if (maxApertureShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxAperture = null;
                    }
                }
            }
            {
                Boolean maxFileSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxFileSize!= null), (rightObject.maxFileSize!= null));
                if (maxFileSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsMaxFileSize;
                    lhsMaxFileSize = leftObject.getMaxFileSize();
                    BigInteger rhsMaxFileSize;
                    rhsMaxFileSize = rightObject.getMaxFileSize();
                    BigInteger mergedMaxFileSize = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "maxFileSize", lhsMaxFileSize), LocatorUtils.property(rightLocator, "maxFileSize", rhsMaxFileSize), lhsMaxFileSize, rhsMaxFileSize, (leftObject.maxFileSize!= null), (rightObject.maxFileSize!= null)));
                    target.setMaxFileSize(mergedMaxFileSize);
                } else {
                    if (maxFileSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxFileSize = null;
                    }
                }
            }
            {
                Boolean testQueryShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.testQuery!= null), (rightObject.testQuery!= null));
                if (testQueryShouldBeMergedAndSet == Boolean.TRUE) {
                    Query lhsTestQuery;
                    lhsTestQuery = leftObject.getTestQuery();
                    Query rhsTestQuery;
                    rhsTestQuery = rightObject.getTestQuery();
                    Query mergedTestQuery = ((Query) strategy.merge(LocatorUtils.property(leftLocator, "testQuery", lhsTestQuery), LocatorUtils.property(rightLocator, "testQuery", rhsTestQuery), lhsTestQuery, rhsTestQuery, (leftObject.testQuery!= null), (rightObject.testQuery!= null)));
                    target.setTestQuery(mergedTestQuery);
                } else {
                    if (testQueryShouldBeMergedAndSet == Boolean.FALSE) {
                        target.testQuery = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new SimpleSpectralAccess();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess clone() {
        final SimpleSpectralAccess _newObject;
        _newObject = ((SimpleSpectralAccess) super.clone());
        _newObject.dataSources = ((this.dataSources == null)?null:new ArrayList<>(this.dataSources));
        _newObject.creationTypes = ((this.creationTypes == null)?null:new ArrayList<>(this.creationTypes));
        _newObject.supportedFrames = ((this.supportedFrames == null)?null:new ArrayList<>(this.supportedFrames));
        _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess createCopy() {
        final SimpleSpectralAccess _newObject = ((SimpleSpectralAccess) super.createCopy());
        _newObject.complianceLevel = this.complianceLevel;
        _newObject.dataSources = ((this.dataSources == null)?null:new ArrayList<>(this.dataSources));
        _newObject.creationTypes = ((this.creationTypes == null)?null:new ArrayList<>(this.creationTypes));
        _newObject.supportedFrames = ((this.supportedFrames == null)?null:new ArrayList<>(this.supportedFrames));
        _newObject.maxSearchRadius = this.maxSearchRadius;
        _newObject.maxRecords = this.maxRecords;
        _newObject.defaultMaxRecords = this.defaultMaxRecords;
        _newObject.maxAperture = this.maxAperture;
        _newObject.maxFileSize = this.maxFileSize;
        _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleSpectralAccess _newObject = ((SimpleSpectralAccess) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree complianceLevelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("complianceLevel"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(complianceLevelPropertyTree!= null):((complianceLevelPropertyTree == null)||(!complianceLevelPropertyTree.isLeaf())))) {
            _newObject.complianceLevel = this.complianceLevel;
        }
        final PropertyTree dataSourcesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataSources"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataSourcesPropertyTree!= null):((dataSourcesPropertyTree == null)||(!dataSourcesPropertyTree.isLeaf())))) {
            _newObject.dataSources = ((this.dataSources == null)?null:new ArrayList<>(this.dataSources));
        }
        final PropertyTree creationTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTypesPropertyTree!= null):((creationTypesPropertyTree == null)||(!creationTypesPropertyTree.isLeaf())))) {
            _newObject.creationTypes = ((this.creationTypes == null)?null:new ArrayList<>(this.creationTypes));
        }
        final PropertyTree supportedFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("supportedFrames"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(supportedFramesPropertyTree!= null):((supportedFramesPropertyTree == null)||(!supportedFramesPropertyTree.isLeaf())))) {
            _newObject.supportedFrames = ((this.supportedFrames == null)?null:new ArrayList<>(this.supportedFrames));
        }
        final PropertyTree maxSearchRadiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxSearchRadius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxSearchRadiusPropertyTree!= null):((maxSearchRadiusPropertyTree == null)||(!maxSearchRadiusPropertyTree.isLeaf())))) {
            _newObject.maxSearchRadius = this.maxSearchRadius;
        }
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _newObject.maxRecords = this.maxRecords;
        }
        final PropertyTree defaultMaxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("defaultMaxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(defaultMaxRecordsPropertyTree!= null):((defaultMaxRecordsPropertyTree == null)||(!defaultMaxRecordsPropertyTree.isLeaf())))) {
            _newObject.defaultMaxRecords = this.defaultMaxRecords;
        }
        final PropertyTree maxAperturePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxAperture"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxAperturePropertyTree!= null):((maxAperturePropertyTree == null)||(!maxAperturePropertyTree.isLeaf())))) {
            _newObject.maxAperture = this.maxAperture;
        }
        final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
            _newObject.maxFileSize = this.maxFileSize;
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.createCopy(testQueryPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SimpleSpectralAccess.Modifier();
        }
        return ((SimpleSpectralAccess.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SimpleSpectralAccess.Builder<_B> _other) {
        super.copyTo(_other);
        _other.complianceLevel = this.complianceLevel;
        if (this.dataSources == null) {
            _other.dataSources = null;
        } else {
            _other.dataSources = new ArrayList<>();
            for (DataSource _item: this.dataSources) {
                _other.dataSources.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        if (this.creationTypes == null) {
            _other.creationTypes = null;
        } else {
            _other.creationTypes = new ArrayList<>();
            for (CreationType _item: this.creationTypes) {
                _other.creationTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        if (this.supportedFrames == null) {
            _other.supportedFrames = null;
        } else {
            _other.supportedFrames = new ArrayList<>();
            for (SupportedFrame _item: this.supportedFrames) {
                _other.supportedFrames.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.maxSearchRadius = this.maxSearchRadius;
        _other.maxRecords = this.maxRecords;
        _other.defaultMaxRecords = this.defaultMaxRecords;
        _other.maxAperture = this.maxAperture;
        _other.maxFileSize = this.maxFileSize;
        _other.testQuery = ((this.testQuery == null)?null:this.testQuery.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SimpleSpectralAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SimpleSpectralAccess.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SimpleSpectralAccess.Builder<Void> builder() {
        return new SimpleSpectralAccess.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SimpleSpectralAccess.Builder<_B> copyOf(final Capability _other) {
        final SimpleSpectralAccess.Builder<_B> _newBuilder = new SimpleSpectralAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SimpleSpectralAccess.Builder<_B> copyOf(final SimpleSpectralAccess _other) {
        final SimpleSpectralAccess.Builder<_B> _newBuilder = new SimpleSpectralAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SimpleSpectralAccess.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree complianceLevelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("complianceLevel"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(complianceLevelPropertyTree!= null):((complianceLevelPropertyTree == null)||(!complianceLevelPropertyTree.isLeaf())))) {
            _other.complianceLevel = this.complianceLevel;
        }
        final PropertyTree dataSourcesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataSources"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataSourcesPropertyTree!= null):((dataSourcesPropertyTree == null)||(!dataSourcesPropertyTree.isLeaf())))) {
            if (this.dataSources == null) {
                _other.dataSources = null;
            } else {
                _other.dataSources = new ArrayList<>();
                for (DataSource _item: this.dataSources) {
                    _other.dataSources.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree creationTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTypesPropertyTree!= null):((creationTypesPropertyTree == null)||(!creationTypesPropertyTree.isLeaf())))) {
            if (this.creationTypes == null) {
                _other.creationTypes = null;
            } else {
                _other.creationTypes = new ArrayList<>();
                for (CreationType _item: this.creationTypes) {
                    _other.creationTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree supportedFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("supportedFrames"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(supportedFramesPropertyTree!= null):((supportedFramesPropertyTree == null)||(!supportedFramesPropertyTree.isLeaf())))) {
            if (this.supportedFrames == null) {
                _other.supportedFrames = null;
            } else {
                _other.supportedFrames = new ArrayList<>();
                for (SupportedFrame _item: this.supportedFrames) {
                    _other.supportedFrames.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree maxSearchRadiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxSearchRadius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxSearchRadiusPropertyTree!= null):((maxSearchRadiusPropertyTree == null)||(!maxSearchRadiusPropertyTree.isLeaf())))) {
            _other.maxSearchRadius = this.maxSearchRadius;
        }
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _other.maxRecords = this.maxRecords;
        }
        final PropertyTree defaultMaxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("defaultMaxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(defaultMaxRecordsPropertyTree!= null):((defaultMaxRecordsPropertyTree == null)||(!defaultMaxRecordsPropertyTree.isLeaf())))) {
            _other.defaultMaxRecords = this.defaultMaxRecords;
        }
        final PropertyTree maxAperturePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxAperture"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxAperturePropertyTree!= null):((maxAperturePropertyTree == null)||(!maxAperturePropertyTree.isLeaf())))) {
            _other.maxAperture = this.maxAperture;
        }
        final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
            _other.maxFileSize = this.maxFileSize;
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _other.testQuery = ((this.testQuery == null)?null:this.testQuery.newCopyBuilder(_other, testQueryPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SimpleSpectralAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SimpleSpectralAccess.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SimpleSpectralAccess.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleSpectralAccess.Builder<_B> _newBuilder = new SimpleSpectralAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SimpleSpectralAccess.Builder<_B> copyOf(final SimpleSpectralAccess _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleSpectralAccess.Builder<_B> _newBuilder = new SimpleSpectralAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SimpleSpectralAccess.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SimpleSpectralAccess.Builder<Void> copyExcept(final SimpleSpectralAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SimpleSpectralAccess.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SimpleSpectralAccess.Builder<Void> copyOnly(final SimpleSpectralAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SimpleSpectralAccess visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.COMPLIANCE_LEVEL, this));
        _visitor_.visit(new CollectionProperty<>(SimpleSpectralAccess.PropInfo.DATA_SOURCES, this));
        _visitor_.visit(new CollectionProperty<>(SimpleSpectralAccess.PropInfo.CREATION_TYPES, this));
        _visitor_.visit(new CollectionProperty<>(SimpleSpectralAccess.PropInfo.SUPPORTED_FRAMES, this));
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.MAX_SEARCH_RADIUS, this));
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.MAX_RECORDS, this));
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.DEFAULT_MAX_RECORDS, this));
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.MAX_APERTURE, this));
        _visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.MAX_FILE_SIZE, this));
        if (_visitor_.visit(new SingleProperty<>(SimpleSpectralAccess.PropInfo.TEST_QUERY, this))&&(this.testQuery!= null)) {
            this.testQuery.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends Capability.Builder<_B>
        implements Buildable
    {

        private ComplianceLevel complianceLevel;
        private List<Buildable> dataSources;
        private List<Buildable> creationTypes;
        private List<Buildable> supportedFrames;
        private Double maxSearchRadius;
        private BigInteger maxRecords;
        private BigInteger defaultMaxRecords;
        private Double maxAperture;
        private BigInteger maxFileSize;
        private Query.Builder<SimpleSpectralAccess.Builder<_B>> testQuery;

        public Builder(final _B _parentBuilder, final SimpleSpectralAccess _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.complianceLevel = _other.complianceLevel;
                if (_other.dataSources == null) {
                    this.dataSources = null;
                } else {
                    this.dataSources = new ArrayList<>();
                    for (DataSource _item: _other.dataSources) {
                        this.dataSources.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                if (_other.creationTypes == null) {
                    this.creationTypes = null;
                } else {
                    this.creationTypes = new ArrayList<>();
                    for (CreationType _item: _other.creationTypes) {
                        this.creationTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                if (_other.supportedFrames == null) {
                    this.supportedFrames = null;
                } else {
                    this.supportedFrames = new ArrayList<>();
                    for (SupportedFrame _item: _other.supportedFrames) {
                        this.supportedFrames.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                this.maxSearchRadius = _other.maxSearchRadius;
                this.maxRecords = _other.maxRecords;
                this.defaultMaxRecords = _other.defaultMaxRecords;
                this.maxAperture = _other.maxAperture;
                this.maxFileSize = _other.maxFileSize;
                this.testQuery = ((_other.testQuery == null)?null:_other.testQuery.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final SimpleSpectralAccess _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree complianceLevelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("complianceLevel"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(complianceLevelPropertyTree!= null):((complianceLevelPropertyTree == null)||(!complianceLevelPropertyTree.isLeaf())))) {
                    this.complianceLevel = _other.complianceLevel;
                }
                final PropertyTree dataSourcesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataSources"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataSourcesPropertyTree!= null):((dataSourcesPropertyTree == null)||(!dataSourcesPropertyTree.isLeaf())))) {
                    if (_other.dataSources == null) {
                        this.dataSources = null;
                    } else {
                        this.dataSources = new ArrayList<>();
                        for (DataSource _item: _other.dataSources) {
                            this.dataSources.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree creationTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("creationTypes"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(creationTypesPropertyTree!= null):((creationTypesPropertyTree == null)||(!creationTypesPropertyTree.isLeaf())))) {
                    if (_other.creationTypes == null) {
                        this.creationTypes = null;
                    } else {
                        this.creationTypes = new ArrayList<>();
                        for (CreationType _item: _other.creationTypes) {
                            this.creationTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree supportedFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("supportedFrames"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(supportedFramesPropertyTree!= null):((supportedFramesPropertyTree == null)||(!supportedFramesPropertyTree.isLeaf())))) {
                    if (_other.supportedFrames == null) {
                        this.supportedFrames = null;
                    } else {
                        this.supportedFrames = new ArrayList<>();
                        for (SupportedFrame _item: _other.supportedFrames) {
                            this.supportedFrames.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree maxSearchRadiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxSearchRadius"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxSearchRadiusPropertyTree!= null):((maxSearchRadiusPropertyTree == null)||(!maxSearchRadiusPropertyTree.isLeaf())))) {
                    this.maxSearchRadius = _other.maxSearchRadius;
                }
                final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
                    this.maxRecords = _other.maxRecords;
                }
                final PropertyTree defaultMaxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("defaultMaxRecords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(defaultMaxRecordsPropertyTree!= null):((defaultMaxRecordsPropertyTree == null)||(!defaultMaxRecordsPropertyTree.isLeaf())))) {
                    this.defaultMaxRecords = _other.defaultMaxRecords;
                }
                final PropertyTree maxAperturePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxAperture"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxAperturePropertyTree!= null):((maxAperturePropertyTree == null)||(!maxAperturePropertyTree.isLeaf())))) {
                    this.maxAperture = _other.maxAperture;
                }
                final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
                    this.maxFileSize = _other.maxFileSize;
                }
                final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
                    this.testQuery = ((_other.testQuery == null)?null:_other.testQuery.newCopyBuilder(this, testQueryPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends SimpleSpectralAccess >_P init(final _P _product) {
            _product.complianceLevel = this.complianceLevel;
            if (this.dataSources!= null) {
                final List<DataSource> dataSources = new ArrayList<>(this.dataSources.size());
                for (Buildable _item: this.dataSources) {
                    dataSources.add(((DataSource) _item.build()));
                }
                _product.dataSources = dataSources;
            }
            if (this.creationTypes!= null) {
                final List<CreationType> creationTypes = new ArrayList<>(this.creationTypes.size());
                for (Buildable _item: this.creationTypes) {
                    creationTypes.add(((CreationType) _item.build()));
                }
                _product.creationTypes = creationTypes;
            }
            if (this.supportedFrames!= null) {
                final List<SupportedFrame> supportedFrames = new ArrayList<>(this.supportedFrames.size());
                for (Buildable _item: this.supportedFrames) {
                    supportedFrames.add(((SupportedFrame) _item.build()));
                }
                _product.supportedFrames = supportedFrames;
            }
            _product.maxSearchRadius = this.maxSearchRadius;
            _product.maxRecords = this.maxRecords;
            _product.defaultMaxRecords = this.defaultMaxRecords;
            _product.maxAperture = this.maxAperture;
            _product.maxFileSize = this.maxFileSize;
            _product.testQuery = ((this.testQuery == null)?null:this.testQuery.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "complianceLevel" (any previous value will be replaced)
         * 
         * @param complianceLevel
         *     New value of the "complianceLevel" property.
         */
        public SimpleSpectralAccess.Builder<_B> withComplianceLevel(final ComplianceLevel complianceLevel) {
            this.complianceLevel = complianceLevel;
            return this;
        }

        /**
         * Adds the given items to the value of "dataSources"
         * 
         * @param dataSources
         *     Items to add to the value of the "dataSources" property
         */
        public SimpleSpectralAccess.Builder<_B> addDataSources(final Iterable<? extends DataSource> dataSources) {
            if (dataSources!= null) {
                if (this.dataSources == null) {
                    this.dataSources = new ArrayList<>();
                }
                for (DataSource _item: dataSources) {
                    this.dataSources.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "dataSources" (any previous value will be replaced)
         * 
         * @param dataSources
         *     New value of the "dataSources" property.
         */
        public SimpleSpectralAccess.Builder<_B> withDataSources(final Iterable<? extends DataSource> dataSources) {
            if (this.dataSources!= null) {
                this.dataSources.clear();
            }
            return addDataSources(dataSources);
        }

        /**
         * Adds the given items to the value of "dataSources"
         * 
         * @param dataSources
         *     Items to add to the value of the "dataSources" property
         */
        public SimpleSpectralAccess.Builder<_B> addDataSources(DataSource... dataSources) {
            addDataSources(Arrays.asList(dataSources));
            return this;
        }

        /**
         * Sets the new value of "dataSources" (any previous value will be replaced)
         * 
         * @param dataSources
         *     New value of the "dataSources" property.
         */
        public SimpleSpectralAccess.Builder<_B> withDataSources(DataSource... dataSources) {
            withDataSources(Arrays.asList(dataSources));
            return this;
        }

        /**
         * Adds the given items to the value of "creationTypes"
         * 
         * @param creationTypes
         *     Items to add to the value of the "creationTypes" property
         */
        public SimpleSpectralAccess.Builder<_B> addCreationTypes(final Iterable<? extends CreationType> creationTypes) {
            if (creationTypes!= null) {
                if (this.creationTypes == null) {
                    this.creationTypes = new ArrayList<>();
                }
                for (CreationType _item: creationTypes) {
                    this.creationTypes.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "creationTypes" (any previous value will be replaced)
         * 
         * @param creationTypes
         *     New value of the "creationTypes" property.
         */
        public SimpleSpectralAccess.Builder<_B> withCreationTypes(final Iterable<? extends CreationType> creationTypes) {
            if (this.creationTypes!= null) {
                this.creationTypes.clear();
            }
            return addCreationTypes(creationTypes);
        }

        /**
         * Adds the given items to the value of "creationTypes"
         * 
         * @param creationTypes
         *     Items to add to the value of the "creationTypes" property
         */
        public SimpleSpectralAccess.Builder<_B> addCreationTypes(CreationType... creationTypes) {
            addCreationTypes(Arrays.asList(creationTypes));
            return this;
        }

        /**
         * Sets the new value of "creationTypes" (any previous value will be replaced)
         * 
         * @param creationTypes
         *     New value of the "creationTypes" property.
         */
        public SimpleSpectralAccess.Builder<_B> withCreationTypes(CreationType... creationTypes) {
            withCreationTypes(Arrays.asList(creationTypes));
            return this;
        }

        /**
         * Adds the given items to the value of "supportedFrames"
         * 
         * @param supportedFrames
         *     Items to add to the value of the "supportedFrames" property
         */
        public SimpleSpectralAccess.Builder<_B> addSupportedFrames(final Iterable<? extends SupportedFrame> supportedFrames) {
            if (supportedFrames!= null) {
                if (this.supportedFrames == null) {
                    this.supportedFrames = new ArrayList<>();
                }
                for (SupportedFrame _item: supportedFrames) {
                    this.supportedFrames.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "supportedFrames" (any previous value will be replaced)
         * 
         * @param supportedFrames
         *     New value of the "supportedFrames" property.
         */
        public SimpleSpectralAccess.Builder<_B> withSupportedFrames(final Iterable<? extends SupportedFrame> supportedFrames) {
            if (this.supportedFrames!= null) {
                this.supportedFrames.clear();
            }
            return addSupportedFrames(supportedFrames);
        }

        /**
         * Adds the given items to the value of "supportedFrames"
         * 
         * @param supportedFrames
         *     Items to add to the value of the "supportedFrames" property
         */
        public SimpleSpectralAccess.Builder<_B> addSupportedFrames(SupportedFrame... supportedFrames) {
            addSupportedFrames(Arrays.asList(supportedFrames));
            return this;
        }

        /**
         * Sets the new value of "supportedFrames" (any previous value will be replaced)
         * 
         * @param supportedFrames
         *     New value of the "supportedFrames" property.
         */
        public SimpleSpectralAccess.Builder<_B> withSupportedFrames(SupportedFrame... supportedFrames) {
            withSupportedFrames(Arrays.asList(supportedFrames));
            return this;
        }

        /**
         * Sets the new value of "maxSearchRadius" (any previous value will be replaced)
         * 
         * @param maxSearchRadius
         *     New value of the "maxSearchRadius" property.
         */
        public SimpleSpectralAccess.Builder<_B> withMaxSearchRadius(final Double maxSearchRadius) {
            this.maxSearchRadius = maxSearchRadius;
            return this;
        }

        /**
         * Sets the new value of "maxRecords" (any previous value will be replaced)
         * 
         * @param maxRecords
         *     New value of the "maxRecords" property.
         */
        public SimpleSpectralAccess.Builder<_B> withMaxRecords(final BigInteger maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        /**
         * Sets the new value of "defaultMaxRecords" (any previous value will be replaced)
         * 
         * @param defaultMaxRecords
         *     New value of the "defaultMaxRecords" property.
         */
        public SimpleSpectralAccess.Builder<_B> withDefaultMaxRecords(final BigInteger defaultMaxRecords) {
            this.defaultMaxRecords = defaultMaxRecords;
            return this;
        }

        /**
         * Sets the new value of "maxAperture" (any previous value will be replaced)
         * 
         * @param maxAperture
         *     New value of the "maxAperture" property.
         */
        public SimpleSpectralAccess.Builder<_B> withMaxAperture(final Double maxAperture) {
            this.maxAperture = maxAperture;
            return this;
        }

        /**
         * Sets the new value of "maxFileSize" (any previous value will be replaced)
         * 
         * @param maxFileSize
         *     New value of the "maxFileSize" property.
         */
        public SimpleSpectralAccess.Builder<_B> withMaxFileSize(final BigInteger maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        /**
         * Sets the new value of "testQuery" (any previous value will be replaced)
         * 
         * @param testQuery
         *     New value of the "testQuery" property.
         */
        public SimpleSpectralAccess.Builder<_B> withTestQuery(final Query testQuery) {
            this.testQuery = ((testQuery == null)?null:new Query.Builder<>(this, testQuery, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "testQuery" property.
         * Use {@link org.javastro.ivoa.entities.resource.ssap.Query.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "testQuery" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ssap.Query.Builder#end()} to
         *     return to the current builder.
         */
        public Query.Builder<? extends SimpleSpectralAccess.Builder<_B>> withTestQuery() {
            if (this.testQuery!= null) {
                return this.testQuery;
            }
            return this.testQuery = new Query.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        @Override
        public SimpleSpectralAccess.Builder<_B> withStandardID(final String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public SimpleSpectralAccess build() {
            if (_storedValue == null) {
                return this.init(new SimpleSpectralAccess());
            } else {
                return ((SimpleSpectralAccess) _storedValue);
            }
        }

        public SimpleSpectralAccess.Builder<_B> copyOf(final SimpleSpectralAccess _other) {
            _other.copyTo(this);
            return this;
        }

        public SimpleSpectralAccess.Builder<_B> copyOf(final SimpleSpectralAccess.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Capability.Modifier
    {


        public void setComplianceLevel(final ComplianceLevel complianceLevel) {
            SimpleSpectralAccess.this.setComplianceLevel(complianceLevel);
        }

        public List<DataSource> getDataSources() {
            if (SimpleSpectralAccess.this.dataSources == null) {
                SimpleSpectralAccess.this.dataSources = new ArrayList<>();
            }
            return SimpleSpectralAccess.this.dataSources;
        }

        public List<CreationType> getCreationTypes() {
            if (SimpleSpectralAccess.this.creationTypes == null) {
                SimpleSpectralAccess.this.creationTypes = new ArrayList<>();
            }
            return SimpleSpectralAccess.this.creationTypes;
        }

        public List<SupportedFrame> getSupportedFrames() {
            if (SimpleSpectralAccess.this.supportedFrames == null) {
                SimpleSpectralAccess.this.supportedFrames = new ArrayList<>();
            }
            return SimpleSpectralAccess.this.supportedFrames;
        }

        public void setMaxSearchRadius(final Double maxSearchRadius) {
            SimpleSpectralAccess.this.setMaxSearchRadius(maxSearchRadius);
        }

        public void setMaxRecords(final BigInteger maxRecords) {
            SimpleSpectralAccess.this.setMaxRecords(maxRecords);
        }

        public void setDefaultMaxRecords(final BigInteger defaultMaxRecords) {
            SimpleSpectralAccess.this.setDefaultMaxRecords(defaultMaxRecords);
        }

        public void setMaxAperture(final Double maxAperture) {
            SimpleSpectralAccess.this.setMaxAperture(maxAperture);
        }

        public void setMaxFileSize(final BigInteger maxFileSize) {
            SimpleSpectralAccess.this.setMaxFileSize(maxFileSize);
        }

        public void setTestQuery(final Query testQuery) {
            SimpleSpectralAccess.this.setTestQuery(testQuery);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SimpleSpectralAccess, ComplianceLevel> COMPLIANCE_LEVEL = new SinglePropertyInfo<SimpleSpectralAccess,ComplianceLevel>("complianceLevel", SimpleSpectralAccess.class, ComplianceLevel.class, false, null, new QName("", "complianceLevel"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "ComplianceLevel"), false) {


            @Override
            public ComplianceLevel get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.complianceLevel);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final ComplianceLevel _value_) {
                if (_instance_!= null) {
                    _instance_.complianceLevel = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, DataSource> DATA_SOURCES = new CollectionPropertyInfo<SimpleSpectralAccess,DataSource>("dataSources", SimpleSpectralAccess.class, DataSource.class, true, null, new QName("", "dataSource"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "DataSource"), false) {


            @Override
            public List<DataSource> get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.dataSources);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final List<DataSource> _value_) {
                if (_instance_!= null) {
                    _instance_.dataSources = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, CreationType> CREATION_TYPES = new CollectionPropertyInfo<SimpleSpectralAccess,CreationType>("creationTypes", SimpleSpectralAccess.class, CreationType.class, true, null, new QName("", "creationType"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "CreationType"), false) {


            @Override
            public List<CreationType> get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.creationTypes);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final List<CreationType> _value_) {
                if (_instance_!= null) {
                    _instance_.creationTypes = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<SimpleSpectralAccess, SupportedFrame> SUPPORTED_FRAMES = new CollectionPropertyInfo<SimpleSpectralAccess,SupportedFrame>("supportedFrames", SimpleSpectralAccess.class, SupportedFrame.class, true, null, new QName("", "supportedFrame"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "SupportedFrame"), false) {


            @Override
            public List<SupportedFrame> get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.supportedFrames);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final List<SupportedFrame> _value_) {
                if (_instance_!= null) {
                    _instance_.supportedFrames = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Double> MAX_SEARCH_RADIUS = new SinglePropertyInfo<SimpleSpectralAccess,Double>("maxSearchRadius", SimpleSpectralAccess.class, Double.class, false, null, new QName("", "maxSearchRadius"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxSearchRadius);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.maxSearchRadius = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> MAX_RECORDS = new SinglePropertyInfo<SimpleSpectralAccess,BigInteger>("maxRecords", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "maxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxRecords);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.maxRecords = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> DEFAULT_MAX_RECORDS = new SinglePropertyInfo<SimpleSpectralAccess,BigInteger>("defaultMaxRecords", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "defaultMaxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.defaultMaxRecords);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.defaultMaxRecords = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Double> MAX_APERTURE = new SinglePropertyInfo<SimpleSpectralAccess,Double>("maxAperture", SimpleSpectralAccess.class, Double.class, false, null, new QName("", "maxAperture"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxAperture);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.maxAperture = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, BigInteger> MAX_FILE_SIZE = new SinglePropertyInfo<SimpleSpectralAccess,BigInteger>("maxFileSize", SimpleSpectralAccess.class, BigInteger.class, false, null, new QName("", "maxFileSize"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxFileSize);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.maxFileSize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleSpectralAccess, Query> TEST_QUERY = new SinglePropertyInfo<SimpleSpectralAccess,Query>("testQuery", SimpleSpectralAccess.class, Query.class, false, null, new QName("", "testQuery"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "Query"), false) {


            @Override
            public Query get(final SimpleSpectralAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.testQuery);
            }

            @Override
            public void set(final SimpleSpectralAccess _instance_, final Query _value_) {
                if (_instance_!= null) {
                    _instance_.testQuery = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SimpleSpectralAccess.Selector<SimpleSpectralAccess.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SimpleSpectralAccess.Select _root() {
            return new SimpleSpectralAccess.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Capability.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> complianceLevel = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> dataSources = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> creationTypes = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> supportedFrames = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxSearchRadius = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxRecords = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> defaultMaxRecords = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxAperture = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxFileSize = null;
        private Query.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> testQuery = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.complianceLevel!= null) {
                products.put("complianceLevel", this.complianceLevel.init());
            }
            if (this.dataSources!= null) {
                products.put("dataSources", this.dataSources.init());
            }
            if (this.creationTypes!= null) {
                products.put("creationTypes", this.creationTypes.init());
            }
            if (this.supportedFrames!= null) {
                products.put("supportedFrames", this.supportedFrames.init());
            }
            if (this.maxSearchRadius!= null) {
                products.put("maxSearchRadius", this.maxSearchRadius.init());
            }
            if (this.maxRecords!= null) {
                products.put("maxRecords", this.maxRecords.init());
            }
            if (this.defaultMaxRecords!= null) {
                products.put("defaultMaxRecords", this.defaultMaxRecords.init());
            }
            if (this.maxAperture!= null) {
                products.put("maxAperture", this.maxAperture.init());
            }
            if (this.maxFileSize!= null) {
                products.put("maxFileSize", this.maxFileSize.init());
            }
            if (this.testQuery!= null) {
                products.put("testQuery", this.testQuery.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> complianceLevel() {
            return ((this.complianceLevel == null)?this.complianceLevel = new com.kscs.util.jaxb.Selector<>(this._root, this, "complianceLevel"):this.complianceLevel);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> dataSources() {
            return ((this.dataSources == null)?this.dataSources = new com.kscs.util.jaxb.Selector<>(this._root, this, "dataSources"):this.dataSources);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> creationTypes() {
            return ((this.creationTypes == null)?this.creationTypes = new com.kscs.util.jaxb.Selector<>(this._root, this, "creationTypes"):this.creationTypes);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> supportedFrames() {
            return ((this.supportedFrames == null)?this.supportedFrames = new com.kscs.util.jaxb.Selector<>(this._root, this, "supportedFrames"):this.supportedFrames);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxSearchRadius() {
            return ((this.maxSearchRadius == null)?this.maxSearchRadius = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxSearchRadius"):this.maxSearchRadius);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxRecords() {
            return ((this.maxRecords == null)?this.maxRecords = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxRecords"):this.maxRecords);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> defaultMaxRecords() {
            return ((this.defaultMaxRecords == null)?this.defaultMaxRecords = new com.kscs.util.jaxb.Selector<>(this._root, this, "defaultMaxRecords"):this.defaultMaxRecords);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxAperture() {
            return ((this.maxAperture == null)?this.maxAperture = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxAperture"):this.maxAperture);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> maxFileSize() {
            return ((this.maxFileSize == null)?this.maxFileSize = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxFileSize"):this.maxFileSize);
        }

        public Query.Selector<TRoot, SimpleSpectralAccess.Selector<TRoot, TParent>> testQuery() {
            return ((this.testQuery == null)?this.testQuery = new Query.Selector<>(this._root, this, "testQuery"):this.testQuery);
        }

    }

}
