
package org.javastro.ivoa.entities.resource.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * a description of a schema definition
 * 
 * <p>Java class for Schema complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Schema">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="location" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="example" type="{http://www.w3.org/2001/XMLSchema}anyURI" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="namespace" use="required" type="{http://www.w3.org/2001/XMLSchema}token" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Schema", propOrder = {
    "location",
    "description",
    "examples"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class Schema implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The document should be in a machine-parsable format
     *                   when applicable.  For example, when refering to an
     *                   XML schema, the document should be an XML Schema or 
     *                   similar document that can be used to validate an 
     *                   instance document.
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String location;
    /**
     * A brief description--e.g. one statement--is
     *                   recommended for display purposes.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String description;
    /**
     * When applicable (e.g. XML), the document should be
     *                   in the format defined by the schema document.
     * 
     */
    @XmlElement(name = "example")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<String> examples;
    /**
     * For XML schemas, this should be the schema's namespace URI.
     *                Otherwise, it should be a unique label to distinguish it from 
     *                other schemas described in the same resource description.
     * 
     */
    @XmlAttribute(name = "namespace", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String namespace;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient Schema.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Schema() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Schema(final String location, final String description, final List<String> examples, final String namespace) {
        this.location = location;
        this.description = description;
        this.examples = examples;
        this.namespace = namespace;
    }

    /**
     * The document should be in a machine-parsable format
     *                   when applicable.  For example, when refering to an
     *                   XML schema, the document should be an XML Schema or 
     *                   similar document that can be used to validate an 
     *                   instance document.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getLocation() {
        return location;
    }

    /**
     * Sets the value of the location property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLocation()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setLocation(String value) {
        this.location = value;
    }

    /**
     * A brief description--e.g. one statement--is
     *                   recommended for display purposes.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * When applicable (e.g. XML), the document should be
     *                   in the format defined by the schema document.
     * 
     * Gets the value of the examples property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the examples property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExamples().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the examples property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<String> getExamples() {
        if (examples == null) {
            examples = new ArrayList<>();
        }
        return this.examples;
    }

    /**
     * For XML schemas, this should be the schema's namespace URI.
     *                Otherwise, it should be a unique label to distinguish it from 
     *                other schemas described in the same resource description.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getNamespace()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setNamespace(String value) {
        this.namespace = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Schema that = ((Schema) object);
        {
            String leftLocation;
            leftLocation = this.getLocation();
            String rightLocation;
            rightLocation = that.getLocation();
            if (this.location!= null) {
                if (that.location!= null) {
                    if (!leftLocation.equals(rightLocation)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.location!= null) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftExamples;
            leftExamples = (((this.examples!= null)&&(!this.examples.isEmpty()))?this.getExamples():null);
            List<String> rightExamples;
            rightExamples = (((that.examples!= null)&&(!that.examples.isEmpty()))?that.getExamples():null);
            if ((this.examples!= null)&&(!this.examples.isEmpty())) {
                if ((that.examples!= null)&&(!that.examples.isEmpty())) {
                    if (!leftExamples.equals(rightExamples)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.examples!= null)&&(!that.examples.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftNamespace;
            leftNamespace = this.getNamespace();
            String rightNamespace;
            rightNamespace = that.getNamespace();
            if (this.namespace!= null) {
                if (that.namespace!= null) {
                    if (!leftNamespace.equals(rightNamespace)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.namespace!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theLocation;
            theLocation = this.getLocation();
            if (this.location!= null) {
                currentHashCode += theLocation.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theExamples;
            theExamples = (((this.examples!= null)&&(!this.examples.isEmpty()))?this.getExamples():null);
            if ((this.examples!= null)&&(!this.examples.isEmpty())) {
                currentHashCode += theExamples.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theNamespace;
            theNamespace = this.getNamespace();
            if (this.namespace!= null) {
                currentHashCode += theNamespace.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theLocation;
            theLocation = this.getLocation();
            strategy.appendField(locator, this, "location", buffer, theLocation, (this.location!= null));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            List<String> theExamples;
            theExamples = (((this.examples!= null)&&(!this.examples.isEmpty()))?this.getExamples():null);
            strategy.appendField(locator, this, "examples", buffer, theExamples, ((this.examples!= null)&&(!this.examples.isEmpty())));
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace, (this.namespace!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Schema) {
            final Schema target = this;
            final Schema leftObject = ((Schema) left);
            final Schema rightObject = ((Schema) right);
            {
                Boolean locationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.location!= null), (rightObject.location!= null));
                if (locationShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsLocation;
                    lhsLocation = leftObject.getLocation();
                    String rhsLocation;
                    rhsLocation = rightObject.getLocation();
                    String mergedLocation = ((String) strategy.merge(LocatorUtils.property(leftLocator, "location", lhsLocation), LocatorUtils.property(rightLocator, "location", rhsLocation), lhsLocation, rhsLocation, (leftObject.location!= null), (rightObject.location!= null)));
                    target.setLocation(mergedLocation);
                } else {
                    if (locationShouldBeMergedAndSet == Boolean.FALSE) {
                        target.location = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean examplesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.examples!= null)&&(!leftObject.examples.isEmpty())), ((rightObject.examples!= null)&&(!rightObject.examples.isEmpty())));
                if (examplesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsExamples;
                    lhsExamples = (((leftObject.examples!= null)&&(!leftObject.examples.isEmpty()))?leftObject.getExamples():null);
                    List<String> rhsExamples;
                    rhsExamples = (((rightObject.examples!= null)&&(!rightObject.examples.isEmpty()))?rightObject.getExamples():null);
                    List<String> mergedExamples = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "examples", lhsExamples), LocatorUtils.property(rightLocator, "examples", rhsExamples), lhsExamples, rhsExamples, ((leftObject.examples!= null)&&(!leftObject.examples.isEmpty())), ((rightObject.examples!= null)&&(!rightObject.examples.isEmpty()))));
                    target.examples = null;
                    if (mergedExamples!= null) {
                        List<String> uniqueExamplesl = target.getExamples();
                        uniqueExamplesl.addAll(mergedExamples);
                    }
                } else {
                    if (examplesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.examples = null;
                    }
                }
            }
            {
                Boolean namespaceShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.namespace!= null), (rightObject.namespace!= null));
                if (namespaceShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsNamespace;
                    lhsNamespace = leftObject.getNamespace();
                    String rhsNamespace;
                    rhsNamespace = rightObject.getNamespace();
                    String mergedNamespace = ((String) strategy.merge(LocatorUtils.property(leftLocator, "namespace", lhsNamespace), LocatorUtils.property(rightLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace, (leftObject.namespace!= null), (rightObject.namespace!= null)));
                    target.setNamespace(mergedNamespace);
                } else {
                    if (namespaceShouldBeMergedAndSet == Boolean.FALSE) {
                        target.namespace = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new Schema();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema clone() {
        final Schema _newObject;
        try {
            _newObject = ((Schema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.examples = ((this.examples == null)?null:new ArrayList<>(this.examples));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema createCopy() {
        final Schema _newObject;
        try {
            _newObject = ((Schema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.location = this.location;
        _newObject.description = this.description;
        _newObject.examples = ((this.examples == null)?null:new ArrayList<>(this.examples));
        _newObject.namespace = this.namespace;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Schema _newObject;
        try {
            _newObject = ((Schema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree locationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("location"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(locationPropertyTree!= null):((locationPropertyTree == null)||(!locationPropertyTree.isLeaf())))) {
            _newObject.location = this.location;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree examplesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("examples"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(examplesPropertyTree!= null):((examplesPropertyTree == null)||(!examplesPropertyTree.isLeaf())))) {
            _newObject.examples = ((this.examples == null)?null:new ArrayList<>(this.examples));
        }
        final PropertyTree namespacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("namespace"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namespacePropertyTree!= null):((namespacePropertyTree == null)||(!namespacePropertyTree.isLeaf())))) {
            _newObject.namespace = this.namespace;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Schema.Modifier();
        }
        return ((Schema.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final Schema.Builder<_B> _other) {
        _other.location = this.location;
        _other.description = this.description;
        if (this.examples == null) {
            _other.examples = null;
        } else {
            _other.examples = new ArrayList<>();
            for (String _item: this.examples) {
                _other.examples.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.namespace = this.namespace;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >Schema.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Schema.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Schema.Builder<Void> builder() {
        return new Schema.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >Schema.Builder<_B> copyOf(final Schema _other) {
        final Schema.Builder<_B> _newBuilder = new Schema.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final Schema.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree locationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("location"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(locationPropertyTree!= null):((locationPropertyTree == null)||(!locationPropertyTree.isLeaf())))) {
            _other.location = this.location;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree examplesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("examples"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(examplesPropertyTree!= null):((examplesPropertyTree == null)||(!examplesPropertyTree.isLeaf())))) {
            if (this.examples == null) {
                _other.examples = null;
            } else {
                _other.examples = new ArrayList<>();
                for (String _item: this.examples) {
                    _other.examples.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree namespacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("namespace"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namespacePropertyTree!= null):((namespacePropertyTree == null)||(!namespacePropertyTree.isLeaf())))) {
            _other.namespace = this.namespace;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >Schema.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Schema.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >Schema.Builder<_B> copyOf(final Schema _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Schema.Builder<_B> _newBuilder = new Schema.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Schema.Builder<Void> copyExcept(final Schema _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Schema.Builder<Void> copyOnly(final Schema _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Schema visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Schema.PropInfo.LOCATION, this));
        _visitor_.visit(new SingleProperty<>(Schema.PropInfo.DESCRIPTION, this));
        _visitor_.visit(new CollectionProperty<>(Schema.PropInfo.EXAMPLES, this));
        _visitor_.visit(new SingleProperty<>(Schema.PropInfo.NAMESPACE, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Schema _storedValue;
        private String location;
        private String description;
        private List<Buildable> examples;
        private String namespace;

        public Builder(final _B _parentBuilder, final Schema _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.location = _other.location;
                    this.description = _other.description;
                    if (_other.examples == null) {
                        this.examples = null;
                    } else {
                        this.examples = new ArrayList<>();
                        for (String _item: _other.examples) {
                            this.examples.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.namespace = _other.namespace;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Schema _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree locationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("location"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(locationPropertyTree!= null):((locationPropertyTree == null)||(!locationPropertyTree.isLeaf())))) {
                        this.location = _other.location;
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree examplesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("examples"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(examplesPropertyTree!= null):((examplesPropertyTree == null)||(!examplesPropertyTree.isLeaf())))) {
                        if (_other.examples == null) {
                            this.examples = null;
                        } else {
                            this.examples = new ArrayList<>();
                            for (String _item: _other.examples) {
                                this.examples.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree namespacePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("namespace"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namespacePropertyTree!= null):((namespacePropertyTree == null)||(!namespacePropertyTree.isLeaf())))) {
                        this.namespace = _other.namespace;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Schema >_P init(final _P _product) {
            _product.location = this.location;
            _product.description = this.description;
            if (this.examples!= null) {
                final List<String> examples = new ArrayList<>(this.examples.size());
                for (Buildable _item: this.examples) {
                    examples.add(((String) _item.build()));
                }
                _product.examples = examples;
            }
            _product.namespace = this.namespace;
            return _product;
        }

        /**
         * Sets the new value of "location" (any previous value will be replaced)
         * 
         * @param location
         *     New value of the "location" property.
         */
        public Schema.Builder<_B> withLocation(final String location) {
            this.location = location;
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public Schema.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Adds the given items to the value of "examples"
         * 
         * @param examples
         *     Items to add to the value of the "examples" property
         */
        public Schema.Builder<_B> addExamples(final Iterable<? extends String> examples) {
            if (examples!= null) {
                if (this.examples == null) {
                    this.examples = new ArrayList<>();
                }
                for (String _item: examples) {
                    this.examples.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "examples" (any previous value will be replaced)
         * 
         * @param examples
         *     New value of the "examples" property.
         */
        public Schema.Builder<_B> withExamples(final Iterable<? extends String> examples) {
            if (this.examples!= null) {
                this.examples.clear();
            }
            return addExamples(examples);
        }

        /**
         * Adds the given items to the value of "examples"
         * 
         * @param examples
         *     Items to add to the value of the "examples" property
         */
        public Schema.Builder<_B> addExamples(String... examples) {
            addExamples(Arrays.asList(examples));
            return this;
        }

        /**
         * Sets the new value of "examples" (any previous value will be replaced)
         * 
         * @param examples
         *     New value of the "examples" property.
         */
        public Schema.Builder<_B> withExamples(String... examples) {
            withExamples(Arrays.asList(examples));
            return this;
        }

        /**
         * Sets the new value of "namespace" (any previous value will be replaced)
         * 
         * @param namespace
         *     New value of the "namespace" property.
         */
        public Schema.Builder<_B> withNamespace(final String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Schema build() {
            if (_storedValue == null) {
                return this.init(new Schema());
            } else {
                return ((Schema) _storedValue);
            }
        }

        public Schema.Builder<_B> copyOf(final Schema _other) {
            _other.copyTo(this);
            return this;
        }

        public Schema.Builder<_B> copyOf(final Schema.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setLocation(final String location) {
            Schema.this.setLocation(location);
        }

        public void setDescription(final String description) {
            Schema.this.setDescription(description);
        }

        public List<String> getExamples() {
            if (Schema.this.examples == null) {
                Schema.this.examples = new ArrayList<>();
            }
            return Schema.this.examples;
        }

        public void setNamespace(final String namespace) {
            Schema.this.setNamespace(namespace);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Schema, String> LOCATION = new SinglePropertyInfo<Schema,String>("location", Schema.class, String.class, false, null, new QName("", "location"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final Schema _instance_) {
                return ((_instance_ == null)?null:_instance_.location);
            }

            @Override
            public void set(final Schema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.location = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Schema, String> DESCRIPTION = new SinglePropertyInfo<Schema,String>("description", Schema.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final Schema _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final Schema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Schema, String> EXAMPLES = new CollectionPropertyInfo<Schema,String>("examples", Schema.class, String.class, true, null, new QName("", "example"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public List<String> get(final Schema _instance_) {
                return ((_instance_ == null)?null:_instance_.examples);
            }

            @Override
            public void set(final Schema _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.examples = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Schema, String> NAMESPACE = new SinglePropertyInfo<Schema,String>("namespace", Schema.class, String.class, false, null, new QName("", "namespace"), new QName("http://www.w3.org/2001/XMLSchema", "token"), true) {


            @Override
            public String get(final Schema _instance_) {
                return ((_instance_ == null)?null:_instance_.namespace);
            }

            @Override
            public void set(final Schema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.namespace = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Schema.Selector<Schema.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Schema.Select _root() {
            return new Schema.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> location = null;
        private com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> description = null;
        private com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> examples = null;
        private com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> namespace = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.location!= null) {
                products.put("location", this.location.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.examples!= null) {
                products.put("examples", this.examples.init());
            }
            if (this.namespace!= null) {
                products.put("namespace", this.namespace.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> location() {
            return ((this.location == null)?this.location = new com.kscs.util.jaxb.Selector<>(this._root, this, "location"):this.location);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> examples() {
            return ((this.examples == null)?this.examples = new com.kscs.util.jaxb.Selector<>(this._root, this, "examples"):this.examples);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Schema.Selector<TRoot, TParent>> namespace() {
            return ((this.namespace == null)?this.namespace = new com.kscs.util.jaxb.Selector<>(this._root, this, "namespace"):this.namespace);
        }

    }

}
