
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.jaxb.hacks.RelocatableOriginType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * astronTime is the generalized astronomical time type and consists of one, two, or three elements: optional TimeScale, optional relative time offset, and an absolute time (ISO8601 or a decimal JD or MJD; or it may be an IDREF to one of those three); TimeScale may be omitted only if the element is part of AstroCoords, referring to an AstroCoordSystem that specifies a TimeScale.
 * 
 * <p>Java class for astronTimeType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="astronTimeType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Timescale" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}timeScaleType" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}TimeOffset" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AbsoluteTime"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "astronTimeType", propOrder = {
    "timescale",
    "timeOffset",
    "absoluteTime"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class AstronTimeType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Timescale", nillable = true)
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected TimeScaleType timescale;
    /**
     * Actual elapsed time offset
     * 
     */
    @XmlElement(name = "TimeOffset", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected TimeOffsetType timeOffset;
    /**
     * Substitution group for absoluteTimeType component of astronTimeType
     * 
     */
    @XmlElementRef(name = "AbsoluteTime", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected JAXBElement<?> absoluteTime;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient AstronTimeType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public AstronTimeType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public AstronTimeType(final TimeScaleType timescale, final TimeOffsetType timeOffset, final JAXBElement<?> absoluteTime) {
        this.timescale = timescale;
        this.timeOffset = timeOffset;
        this.absoluteTime = absoluteTime;
    }

    /**
     * Gets the value of the timescale property.
     * 
     * @return
     *     possible object is
     *     {@link TimeScaleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public TimeScaleType getTimescale() {
        return timescale;
    }

    /**
     * Sets the value of the timescale property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeScaleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setTimescale(TimeScaleType value) {
        this.timescale = value;
    }

    /**
     * Actual elapsed time offset
     * 
     * @return
     *     possible object is
     *     {@link TimeOffsetType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public TimeOffsetType getTimeOffset() {
        return timeOffset;
    }

    /**
     * Sets the value of the timeOffset property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeOffsetType }
     *     
     * @see #getTimeOffset()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setTimeOffset(TimeOffsetType value) {
        this.timeOffset = value;
    }

    /**
     * Substitution group for absoluteTimeType component of astronTimeType
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link Object }{@code >}
     *     {@link JAXBElement }{@code <}{@link RelocatableOriginType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IsoTimeType }{@code >}
     *     {@link JAXBElement }{@code <}{@link JdTimeType }{@code >}
     *     {@link JAXBElement }{@code <}{@link JdTimeType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public JAXBElement<?> getAbsoluteTime() {
        return absoluteTime;
    }

    /**
     * Sets the value of the absoluteTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link Object }{@code >}
     *     {@link JAXBElement }{@code <}{@link RelocatableOriginType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IsoTimeType }{@code >}
     *     {@link JAXBElement }{@code <}{@link JdTimeType }{@code >}
     *     {@link JAXBElement }{@code <}{@link JdTimeType }{@code >}
     *     
     * @see #getAbsoluteTime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAbsoluteTime(JAXBElement<?> value) {
        this.absoluteTime = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final AstronTimeType that = ((AstronTimeType) object);
        {
            TimeScaleType leftTimescale;
            leftTimescale = this.getTimescale();
            TimeScaleType rightTimescale;
            rightTimescale = that.getTimescale();
            if (this.timescale!= null) {
                if (that.timescale!= null) {
                    if (!leftTimescale.equals(rightTimescale)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.timescale!= null) {
                    return false;
                }
            }
        }
        {
            TimeOffsetType leftTimeOffset;
            leftTimeOffset = this.getTimeOffset();
            TimeOffsetType rightTimeOffset;
            rightTimeOffset = that.getTimeOffset();
            if (this.timeOffset!= null) {
                if (that.timeOffset!= null) {
                    if (!leftTimeOffset.equals(rightTimeOffset)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.timeOffset!= null) {
                    return false;
                }
            }
        }
        {
            JAXBElement<?> leftAbsoluteTime;
            leftAbsoluteTime = this.getAbsoluteTime();
            JAXBElement<?> rightAbsoluteTime;
            rightAbsoluteTime = that.getAbsoluteTime();
            if (this.absoluteTime!= null) {
                if (that.absoluteTime!= null) {
                    {
                        final QName leftAbsoluteTimeName = leftAbsoluteTime.getName();
                        final QName rightAbsoluteTimeName = rightAbsoluteTime.getName();
                        if (leftAbsoluteTimeName!= null) {
                            if (rightAbsoluteTimeName!= null) {
                                if (!leftAbsoluteTimeName.equals(rightAbsoluteTimeName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightAbsoluteTimeName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Object leftAbsoluteTimeValue = leftAbsoluteTime.getValue();
                        final Object rightAbsoluteTimeValue = rightAbsoluteTime.getValue();
                        if (leftAbsoluteTimeValue!= null) {
                            if (rightAbsoluteTimeValue!= null) {
                                if (!leftAbsoluteTimeValue.equals(rightAbsoluteTimeValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightAbsoluteTimeValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftAbsoluteTimeDeclaredType = leftAbsoluteTime.getDeclaredType();
                        final Class<?> rightAbsoluteTimeDeclaredType = rightAbsoluteTime.getDeclaredType();
                        if (leftAbsoluteTimeDeclaredType!= null) {
                            if (rightAbsoluteTimeDeclaredType!= null) {
                                if (!leftAbsoluteTimeDeclaredType.equals(rightAbsoluteTimeDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightAbsoluteTimeDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftAbsoluteTimeScope = leftAbsoluteTime.getScope();
                        final Class<?> rightAbsoluteTimeScope = rightAbsoluteTime.getScope();
                        if (leftAbsoluteTimeScope!= null) {
                            if (rightAbsoluteTimeScope!= null) {
                                if (!leftAbsoluteTimeScope.equals(rightAbsoluteTimeScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightAbsoluteTimeScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftAbsoluteTimeNil = leftAbsoluteTime.isNil();
                        final boolean rightAbsoluteTimeNil = rightAbsoluteTime.isNil();
                        if (leftAbsoluteTimeNil!= rightAbsoluteTimeNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.absoluteTime!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            TimeScaleType theTimescale;
            theTimescale = this.getTimescale();
            if (this.timescale!= null) {
                currentHashCode += theTimescale.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            TimeOffsetType theTimeOffset;
            theTimeOffset = this.getTimeOffset();
            if (this.timeOffset!= null) {
                currentHashCode += theTimeOffset.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<?> theAbsoluteTime;
            theAbsoluteTime = this.getAbsoluteTime();
            if (this.absoluteTime!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theAbsoluteTimeName = theAbsoluteTime.getName();
                    if (theAbsoluteTimeName!= null) {
                        currentHashCode += theAbsoluteTimeName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Object theAbsoluteTimeValue = theAbsoluteTime.getValue();
                    if (theAbsoluteTimeValue!= null) {
                        currentHashCode += theAbsoluteTimeValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theAbsoluteTimeDeclaredType = theAbsoluteTime.getDeclaredType();
                    if (theAbsoluteTimeDeclaredType!= null) {
                        currentHashCode += theAbsoluteTimeDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theAbsoluteTimeScope = theAbsoluteTime.getScope();
                    if (theAbsoluteTimeScope!= null) {
                        currentHashCode += theAbsoluteTimeScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theAbsoluteTimeNil = theAbsoluteTime.isNil();
                    currentHashCode += (theAbsoluteTimeNil? 1231 : 1237);
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            TimeScaleType theTimescale;
            theTimescale = this.getTimescale();
            strategy.appendField(locator, this, "timescale", buffer, theTimescale, (this.timescale!= null));
        }
        {
            TimeOffsetType theTimeOffset;
            theTimeOffset = this.getTimeOffset();
            strategy.appendField(locator, this, "timeOffset", buffer, theTimeOffset, (this.timeOffset!= null));
        }
        {
            JAXBElement<?> theAbsoluteTime;
            theAbsoluteTime = this.getAbsoluteTime();
            strategy.appendField(locator, this, "absoluteTime", buffer, theAbsoluteTime, (this.absoluteTime!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof AstronTimeType) {
            final AstronTimeType target = this;
            final AstronTimeType leftObject = ((AstronTimeType) left);
            final AstronTimeType rightObject = ((AstronTimeType) right);
            {
                Boolean timescaleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.timescale!= null), (rightObject.timescale!= null));
                if (timescaleShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeScaleType lhsTimescale;
                    lhsTimescale = leftObject.getTimescale();
                    TimeScaleType rhsTimescale;
                    rhsTimescale = rightObject.getTimescale();
                    TimeScaleType mergedTimescale = ((TimeScaleType) strategy.merge(LocatorUtils.property(leftLocator, "timescale", lhsTimescale), LocatorUtils.property(rightLocator, "timescale", rhsTimescale), lhsTimescale, rhsTimescale, (leftObject.timescale!= null), (rightObject.timescale!= null)));
                    target.setTimescale(mergedTimescale);
                } else {
                    if (timescaleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timescale = null;
                    }
                }
            }
            {
                Boolean timeOffsetShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.timeOffset!= null), (rightObject.timeOffset!= null));
                if (timeOffsetShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeOffsetType lhsTimeOffset;
                    lhsTimeOffset = leftObject.getTimeOffset();
                    TimeOffsetType rhsTimeOffset;
                    rhsTimeOffset = rightObject.getTimeOffset();
                    TimeOffsetType mergedTimeOffset = ((TimeOffsetType) strategy.merge(LocatorUtils.property(leftLocator, "timeOffset", lhsTimeOffset), LocatorUtils.property(rightLocator, "timeOffset", rhsTimeOffset), lhsTimeOffset, rhsTimeOffset, (leftObject.timeOffset!= null), (rightObject.timeOffset!= null)));
                    target.setTimeOffset(mergedTimeOffset);
                } else {
                    if (timeOffsetShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timeOffset = null;
                    }
                }
            }
            {
                Boolean absoluteTimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.absoluteTime!= null), (rightObject.absoluteTime!= null));
                if (absoluteTimeShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<?> lhsAbsoluteTime;
                    lhsAbsoluteTime = leftObject.getAbsoluteTime();
                    JAXBElement<?> rhsAbsoluteTime;
                    rhsAbsoluteTime = rightObject.getAbsoluteTime();
                    JAXBElement<?> mergedAbsoluteTime = ((JAXBElement<?> ) strategy.merge(LocatorUtils.property(leftLocator, "absoluteTime", lhsAbsoluteTime), LocatorUtils.property(rightLocator, "absoluteTime", rhsAbsoluteTime), lhsAbsoluteTime, rhsAbsoluteTime, (leftObject.absoluteTime!= null), (rightObject.absoluteTime!= null)));
                    target.setAbsoluteTime(mergedAbsoluteTime);
                } else {
                    if (absoluteTimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.absoluteTime = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new AstronTimeType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType clone() {
        final AstronTimeType _newObject;
        try {
            _newObject = ((AstronTimeType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType createCopy() {
        final AstronTimeType _newObject;
        try {
            _newObject = ((AstronTimeType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.timescale = this.timescale;
        _newObject.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.createCopy());
        _newObject.absoluteTime = this.absoluteTime;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstronTimeType _newObject;
        try {
            _newObject = ((AstronTimeType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree timescalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timescale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timescalePropertyTree!= null):((timescalePropertyTree == null)||(!timescalePropertyTree.isLeaf())))) {
            _newObject.timescale = this.timescale;
        }
        final PropertyTree timeOffsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeOffset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeOffsetPropertyTree!= null):((timeOffsetPropertyTree == null)||(!timeOffsetPropertyTree.isLeaf())))) {
            _newObject.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.createCopy(timeOffsetPropertyTree, _propertyTreeUse));
        }
        final PropertyTree absoluteTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("absoluteTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(absoluteTimePropertyTree!= null):((absoluteTimePropertyTree == null)||(!absoluteTimePropertyTree.isLeaf())))) {
            _newObject.absoluteTime = this.absoluteTime;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new AstronTimeType.Modifier();
        }
        return ((AstronTimeType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final AstronTimeType.Builder<_B> _other) {
        _other.timescale = this.timescale;
        _other.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.newCopyBuilder(_other));
        _other.absoluteTime = this.absoluteTime;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >AstronTimeType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new AstronTimeType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static AstronTimeType.Builder<Void> builder() {
        return new AstronTimeType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >AstronTimeType.Builder<_B> copyOf(final AstronTimeType _other) {
        final AstronTimeType.Builder<_B> _newBuilder = new AstronTimeType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final AstronTimeType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree timescalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timescale"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timescalePropertyTree!= null):((timescalePropertyTree == null)||(!timescalePropertyTree.isLeaf())))) {
            _other.timescale = this.timescale;
        }
        final PropertyTree timeOffsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeOffset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeOffsetPropertyTree!= null):((timeOffsetPropertyTree == null)||(!timeOffsetPropertyTree.isLeaf())))) {
            _other.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.newCopyBuilder(_other, timeOffsetPropertyTree, _propertyTreeUse));
        }
        final PropertyTree absoluteTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("absoluteTime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(absoluteTimePropertyTree!= null):((absoluteTimePropertyTree == null)||(!absoluteTimePropertyTree.isLeaf())))) {
            _other.absoluteTime = this.absoluteTime;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >AstronTimeType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new AstronTimeType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >AstronTimeType.Builder<_B> copyOf(final AstronTimeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstronTimeType.Builder<_B> _newBuilder = new AstronTimeType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static AstronTimeType.Builder<Void> copyExcept(final AstronTimeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static AstronTimeType.Builder<Void> copyOnly(final AstronTimeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstronTimeType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(AstronTimeType.PropInfo.TIMESCALE, this));
        if (_visitor_.visit(new SingleProperty<>(AstronTimeType.PropInfo.TIME_OFFSET, this))&&(this.timeOffset!= null)) {
            this.timeOffset.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(AstronTimeType.PropInfo.ABSOLUTE_TIME, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final AstronTimeType _storedValue;
        private TimeScaleType timescale;
        private TimeOffsetType.Builder<AstronTimeType.Builder<_B>> timeOffset;
        private JAXBElement<?> absoluteTime;

        public Builder(final _B _parentBuilder, final AstronTimeType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.timescale = _other.timescale;
                    this.timeOffset = ((_other.timeOffset == null)?null:_other.timeOffset.newCopyBuilder(this));
                    this.absoluteTime = _other.absoluteTime;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final AstronTimeType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree timescalePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timescale"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timescalePropertyTree!= null):((timescalePropertyTree == null)||(!timescalePropertyTree.isLeaf())))) {
                        this.timescale = _other.timescale;
                    }
                    final PropertyTree timeOffsetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeOffset"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeOffsetPropertyTree!= null):((timeOffsetPropertyTree == null)||(!timeOffsetPropertyTree.isLeaf())))) {
                        this.timeOffset = ((_other.timeOffset == null)?null:_other.timeOffset.newCopyBuilder(this, timeOffsetPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree absoluteTimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("absoluteTime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(absoluteTimePropertyTree!= null):((absoluteTimePropertyTree == null)||(!absoluteTimePropertyTree.isLeaf())))) {
                        this.absoluteTime = _other.absoluteTime;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends AstronTimeType >_P init(final _P _product) {
            _product.timescale = this.timescale;
            _product.timeOffset = ((this.timeOffset == null)?null:this.timeOffset.build());
            _product.absoluteTime = this.absoluteTime;
            return _product;
        }

        /**
         * Sets the new value of "timescale" (any previous value will be replaced)
         * 
         * @param timescale
         *     New value of the "timescale" property.
         */
        public AstronTimeType.Builder<_B> withTimescale(final TimeScaleType timescale) {
            this.timescale = timescale;
            return this;
        }

        /**
         * Sets the new value of "timeOffset" (any previous value will be replaced)
         * 
         * @param timeOffset
         *     New value of the "timeOffset" property.
         */
        public AstronTimeType.Builder<_B> withTimeOffset(final TimeOffsetType timeOffset) {
            this.timeOffset = ((timeOffset == null)?null:new TimeOffsetType.Builder<>(this, timeOffset, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "timeOffset" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.TimeOffsetType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "timeOffset" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.TimeOffsetType.Builder#end()} to
         *     return to the current builder.
         */
        public TimeOffsetType.Builder<? extends AstronTimeType.Builder<_B>> withTimeOffset() {
            if (this.timeOffset!= null) {
                return this.timeOffset;
            }
            return this.timeOffset = new TimeOffsetType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "absoluteTime" (any previous value will be replaced)
         * 
         * @param absoluteTime
         *     New value of the "absoluteTime" property.
         */
        public AstronTimeType.Builder<_B> withAbsoluteTime(final JAXBElement<?> absoluteTime) {
            this.absoluteTime = absoluteTime;
            return this;
        }

        @Override
        public AstronTimeType build() {
            if (_storedValue == null) {
                return this.init(new AstronTimeType());
            } else {
                return ((AstronTimeType) _storedValue);
            }
        }

        public AstronTimeType.Builder<_B> copyOf(final AstronTimeType _other) {
            _other.copyTo(this);
            return this;
        }

        public AstronTimeType.Builder<_B> copyOf(final AstronTimeType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setTimescale(final TimeScaleType timescale) {
            AstronTimeType.this.setTimescale(timescale);
        }

        public void setTimeOffset(final TimeOffsetType timeOffset) {
            AstronTimeType.this.setTimeOffset(timeOffset);
        }

        public void setAbsoluteTime(final JAXBElement<?> absoluteTime) {
            AstronTimeType.this.setAbsoluteTime(absoluteTime);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<AstronTimeType, TimeScaleType> TIMESCALE = new SinglePropertyInfo<AstronTimeType,TimeScaleType>("timescale", AstronTimeType.class, TimeScaleType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Timescale"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeScaleType"), false) {


            @Override
            public TimeScaleType get(final AstronTimeType _instance_) {
                return ((_instance_ == null)?null:_instance_.timescale);
            }

            @Override
            public void set(final AstronTimeType _instance_, final TimeScaleType _value_) {
                if (_instance_!= null) {
                    _instance_.timescale = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstronTimeType, TimeOffsetType> TIME_OFFSET = new SinglePropertyInfo<AstronTimeType,TimeOffsetType>("timeOffset", AstronTimeType.class, TimeOffsetType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeOffset"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeOffsetType"), false) {


            @Override
            public TimeOffsetType get(final AstronTimeType _instance_) {
                return ((_instance_ == null)?null:_instance_.timeOffset);
            }

            @Override
            public void set(final AstronTimeType _instance_, final TimeOffsetType _value_) {
                if (_instance_!= null) {
                    _instance_.timeOffset = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstronTimeType, Object> ABSOLUTE_TIME = new SinglePropertyInfo<AstronTimeType,Object>("absoluteTime", AstronTimeType.class, Object.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AbsoluteTime"), new QName("http://www.w3.org/2001/XMLSchema", "anyType"), false) {


            @Override
            public Object get(final AstronTimeType _instance_) {
                return ((_instance_ == null)?null:((_instance_.absoluteTime == null)?null:_instance_.absoluteTime.getValue()));
            }

            @Override
            public void set(final AstronTimeType _instance_, final Object _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;

    }

    public static class Select
        extends AstronTimeType.Selector<AstronTimeType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static AstronTimeType.Select _root() {
            return new AstronTimeType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> timescale = null;
        private TimeOffsetType.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> timeOffset = null;
        private com.kscs.util.jaxb.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> absoluteTime = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.timescale!= null) {
                products.put("timescale", this.timescale.init());
            }
            if (this.timeOffset!= null) {
                products.put("timeOffset", this.timeOffset.init());
            }
            if (this.absoluteTime!= null) {
                products.put("absoluteTime", this.absoluteTime.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> timescale() {
            return ((this.timescale == null)?this.timescale = new com.kscs.util.jaxb.Selector<>(this._root, this, "timescale"):this.timescale);
        }

        public TimeOffsetType.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> timeOffset() {
            return ((this.timeOffset == null)?this.timeOffset = new TimeOffsetType.Selector<>(this._root, this, "timeOffset"):this.timeOffset);
        }

        public com.kscs.util.jaxb.Selector<TRoot, AstronTimeType.Selector<TRoot, TParent>> absoluteTime() {
            return ((this.absoluteTime == null)?this.absoluteTime = new com.kscs.util.jaxb.Selector<>(this._root, this, "absoluteTime"):this.absoluteTime);
        }

    }

}
