
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Generalized coordinate area type
 * 
 * <p>Java class for coordAreaType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="coordAreaType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcBaseType">
 *       <sequence maxOccurs="unbounded" minOccurs="0">
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}CoordInterval"/>
 *       </sequence>
 *       <attribute name="coord_system_id" use="required" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordAreaType", propOrder = {
    "coordIntervals"
})
@XmlSeeAlso({
    AstroCoordAreaType.class,
    PixelCoordAreaType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class CoordAreaType
    extends StcBaseType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The 1-, 2-, or 3-D coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     */
    @XmlElementRef(name = "CoordInterval", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class, required = false)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<JAXBElement<? extends CoordIntervalType>> coordIntervals;
    @XmlAttribute(name = "coord_system_id", required = true)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Object coordSystemId;

    /**
     * Default no-arg constructor
     * 
     */
    public CoordAreaType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CoordAreaType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<JAXBElement<? extends CoordIntervalType>> coordIntervals, final Object coordSystemId) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.coordIntervals = coordIntervals;
        this.coordSystemId = coordSystemId;
    }

    /**
     * The 1-, 2-, or 3-D coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     * Gets the value of the coordIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the coordIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCoordIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link CoordIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link UCoord2VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link UCoord3VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link UCoordScalarIntervalType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the coordIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<JAXBElement<? extends CoordIntervalType>> getCoordIntervals() {
        if (coordIntervals == null) {
            coordIntervals = new ArrayList<>();
        }
        return this.coordIntervals;
    }

    /**
     * Gets the value of the coordSystemId property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object getCoordSystemId() {
        return coordSystemId;
    }

    /**
     * Sets the value of the coordSystemId property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setCoordSystemId(Object value) {
        this.coordSystemId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CoordAreaType that = ((CoordAreaType) object);
        {
            List<JAXBElement<? extends CoordIntervalType>> leftCoordIntervals;
            leftCoordIntervals = (((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty()))?this.getCoordIntervals():null);
            List<JAXBElement<? extends CoordIntervalType>> rightCoordIntervals;
            rightCoordIntervals = (((that.coordIntervals!= null)&&(!that.coordIntervals.isEmpty()))?that.getCoordIntervals():null);
            if ((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty())) {
                if ((that.coordIntervals!= null)&&(!that.coordIntervals.isEmpty())) {
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> leftCoordIntervalsListIterator = leftCoordIntervals.listIterator();
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> rightCoordIntervalsListIterator = rightCoordIntervals.listIterator();
                    while (rightCoordIntervalsListIterator.hasNext()&&leftCoordIntervalsListIterator.hasNext()) {
                        final JAXBElement<? extends CoordIntervalType> rightCoordIntervalsListIteratorElement = rightCoordIntervalsListIterator.next();
                        final JAXBElement<? extends CoordIntervalType> leftCoordIntervalsListIteratorElement = leftCoordIntervalsListIterator.next();
                        if (rightCoordIntervalsListIteratorElement!= null) {
                            if (leftCoordIntervalsListIteratorElement!= null) {
                                {
                                    final QName rightCoordIntervalsListIteratorElementName = rightCoordIntervalsListIteratorElement.getName();
                                    final QName leftCoordIntervalsListIteratorElementName = leftCoordIntervalsListIteratorElement.getName();
                                    if (rightCoordIntervalsListIteratorElementName!= null) {
                                        if (leftCoordIntervalsListIteratorElementName!= null) {
                                            if (!rightCoordIntervalsListIteratorElementName.equals(leftCoordIntervalsListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftCoordIntervalsListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final CoordIntervalType rightCoordIntervalsListIteratorElementValue = rightCoordIntervalsListIteratorElement.getValue();
                                    final CoordIntervalType leftCoordIntervalsListIteratorElementValue = leftCoordIntervalsListIteratorElement.getValue();
                                    if (rightCoordIntervalsListIteratorElementValue!= null) {
                                        if (leftCoordIntervalsListIteratorElementValue!= null) {
                                            if (!rightCoordIntervalsListIteratorElementValue.equals(leftCoordIntervalsListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftCoordIntervalsListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends CoordIntervalType> rightCoordIntervalsListIteratorElementDeclaredType = rightCoordIntervalsListIteratorElement.getDeclaredType();
                                    final Class<? extends CoordIntervalType> leftCoordIntervalsListIteratorElementDeclaredType = leftCoordIntervalsListIteratorElement.getDeclaredType();
                                    if (rightCoordIntervalsListIteratorElementDeclaredType!= null) {
                                        if (leftCoordIntervalsListIteratorElementDeclaredType!= null) {
                                            if (!rightCoordIntervalsListIteratorElementDeclaredType.equals(leftCoordIntervalsListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftCoordIntervalsListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightCoordIntervalsListIteratorElementScope = rightCoordIntervalsListIteratorElement.getScope();
                                    final Class<?> leftCoordIntervalsListIteratorElementScope = leftCoordIntervalsListIteratorElement.getScope();
                                    if (rightCoordIntervalsListIteratorElementScope!= null) {
                                        if (leftCoordIntervalsListIteratorElementScope!= null) {
                                            if (!rightCoordIntervalsListIteratorElementScope.equals(leftCoordIntervalsListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftCoordIntervalsListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightCoordIntervalsListIteratorElementNil = rightCoordIntervalsListIteratorElement.isNil();
                                    final boolean leftCoordIntervalsListIteratorElementNil = leftCoordIntervalsListIteratorElement.isNil();
                                    if (rightCoordIntervalsListIteratorElementNil!= leftCoordIntervalsListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftCoordIntervalsListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightCoordIntervalsListIterator.hasNext()||leftCoordIntervalsListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.coordIntervals!= null)&&(!that.coordIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Object leftCoordSystemId;
            leftCoordSystemId = this.getCoordSystemId();
            Object rightCoordSystemId;
            rightCoordSystemId = that.getCoordSystemId();
            if (this.coordSystemId!= null) {
                if (that.coordSystemId!= null) {
                    if (!leftCoordSystemId.equals(rightCoordSystemId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.coordSystemId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends CoordIntervalType>> theCoordIntervals;
            theCoordIntervals = (((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty()))?this.getCoordIntervals():null);
            if ((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty())) {
                final ListIterator<JAXBElement<? extends CoordIntervalType>> theCoordIntervalsListIterator = theCoordIntervals.listIterator();
                while (theCoordIntervalsListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends CoordIntervalType> theCoordIntervalsListIteratorElement = theCoordIntervalsListIterator.next();
                    if (theCoordIntervalsListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName theCoordIntervalsListIteratorElementName = theCoordIntervalsListIteratorElement.getName();
                            if (theCoordIntervalsListIteratorElementName!= null) {
                                currentHashCode += theCoordIntervalsListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final CoordIntervalType theCoordIntervalsListIteratorElementValue = theCoordIntervalsListIteratorElement.getValue();
                            if (theCoordIntervalsListIteratorElementValue!= null) {
                                currentHashCode += theCoordIntervalsListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends CoordIntervalType> theCoordIntervalsListIteratorElementDeclaredType = theCoordIntervalsListIteratorElement.getDeclaredType();
                            if (theCoordIntervalsListIteratorElementDeclaredType!= null) {
                                currentHashCode += theCoordIntervalsListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> theCoordIntervalsListIteratorElementScope = theCoordIntervalsListIteratorElement.getScope();
                            if (theCoordIntervalsListIteratorElementScope!= null) {
                                currentHashCode += theCoordIntervalsListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean theCoordIntervalsListIteratorElementNil = theCoordIntervalsListIteratorElement.isNil();
                            currentHashCode += (theCoordIntervalsListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Object theCoordSystemId;
            theCoordSystemId = this.getCoordSystemId();
            if (this.coordSystemId!= null) {
                currentHashCode += theCoordSystemId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<JAXBElement<? extends CoordIntervalType>> theCoordIntervals;
            theCoordIntervals = (((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty()))?this.getCoordIntervals():null);
            strategy.appendField(locator, this, "coordIntervals", buffer, theCoordIntervals, ((this.coordIntervals!= null)&&(!this.coordIntervals.isEmpty())));
        }
        {
            Object theCoordSystemId;
            theCoordSystemId = this.getCoordSystemId();
            strategy.appendField(locator, this, "coordSystemId", buffer, theCoordSystemId, (this.coordSystemId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof CoordAreaType) {
            final CoordAreaType target = this;
            final CoordAreaType leftObject = ((CoordAreaType) left);
            final CoordAreaType rightObject = ((CoordAreaType) right);
            {
                Boolean coordIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.coordIntervals!= null)&&(!leftObject.coordIntervals.isEmpty())), ((rightObject.coordIntervals!= null)&&(!rightObject.coordIntervals.isEmpty())));
                if (coordIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends CoordIntervalType>> lhsCoordIntervals;
                    lhsCoordIntervals = (((leftObject.coordIntervals!= null)&&(!leftObject.coordIntervals.isEmpty()))?leftObject.getCoordIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> rhsCoordIntervals;
                    rhsCoordIntervals = (((rightObject.coordIntervals!= null)&&(!rightObject.coordIntervals.isEmpty()))?rightObject.getCoordIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> mergedCoordIntervals = ((List<JAXBElement<? extends CoordIntervalType>> ) strategy.merge(LocatorUtils.property(leftLocator, "coordIntervals", lhsCoordIntervals), LocatorUtils.property(rightLocator, "coordIntervals", rhsCoordIntervals), lhsCoordIntervals, rhsCoordIntervals, ((leftObject.coordIntervals!= null)&&(!leftObject.coordIntervals.isEmpty())), ((rightObject.coordIntervals!= null)&&(!rightObject.coordIntervals.isEmpty()))));
                    target.coordIntervals = null;
                    if (mergedCoordIntervals!= null) {
                        List<JAXBElement<? extends CoordIntervalType>> uniqueCoordIntervalsl = target.getCoordIntervals();
                        uniqueCoordIntervalsl.addAll(mergedCoordIntervals);
                    }
                } else {
                    if (coordIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coordIntervals = null;
                    }
                }
            }
            {
                Boolean coordSystemIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.coordSystemId!= null), (rightObject.coordSystemId!= null));
                if (coordSystemIdShouldBeMergedAndSet == Boolean.TRUE) {
                    Object lhsCoordSystemId;
                    lhsCoordSystemId = leftObject.getCoordSystemId();
                    Object rhsCoordSystemId;
                    rhsCoordSystemId = rightObject.getCoordSystemId();
                    Object mergedCoordSystemId = ((Object) strategy.merge(LocatorUtils.property(leftLocator, "coordSystemId", lhsCoordSystemId), LocatorUtils.property(rightLocator, "coordSystemId", rhsCoordSystemId), lhsCoordSystemId, rhsCoordSystemId, (leftObject.coordSystemId!= null), (rightObject.coordSystemId!= null)));
                    target.setCoordSystemId(mergedCoordSystemId);
                } else {
                    if (coordSystemIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coordSystemId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new CoordAreaType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType clone() {
        final CoordAreaType _newObject;
        _newObject = ((CoordAreaType) super.clone());
        _newObject.coordIntervals = ((this.coordIntervals == null)?null:new ArrayList<>(this.coordIntervals));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType createCopy() {
        final CoordAreaType _newObject = ((CoordAreaType) super.createCopy());
        _newObject.coordIntervals = ((this.coordIntervals == null)?null:new ArrayList<>(this.coordIntervals));
        _newObject.coordSystemId = this.coordSystemId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordAreaType _newObject = ((CoordAreaType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree coordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordIntervalsPropertyTree!= null):((coordIntervalsPropertyTree == null)||(!coordIntervalsPropertyTree.isLeaf())))) {
            _newObject.coordIntervals = ((this.coordIntervals == null)?null:new ArrayList<>(this.coordIntervals));
        }
        final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
            _newObject.coordSystemId = this.coordSystemId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CoordAreaType.Modifier();
        }
        return ((CoordAreaType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final CoordAreaType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.coordIntervals == null) {
            _other.coordIntervals = null;
        } else {
            _other.coordIntervals = new ArrayList<>();
            for (JAXBElement<? extends CoordIntervalType> _item: this.coordIntervals) {
                _other.coordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.coordSystemId = this.coordSystemId;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >CoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CoordAreaType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordAreaType.Builder<Void> builder() {
        return new CoordAreaType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordAreaType.Builder<_B> copyOf(final StcBaseType _other) {
        final CoordAreaType.Builder<_B> _newBuilder = new CoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordAreaType.Builder<_B> copyOf(final CoordAreaType _other) {
        final CoordAreaType.Builder<_B> _newBuilder = new CoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final CoordAreaType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree coordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordIntervalsPropertyTree!= null):((coordIntervalsPropertyTree == null)||(!coordIntervalsPropertyTree.isLeaf())))) {
            if (this.coordIntervals == null) {
                _other.coordIntervals = null;
            } else {
                _other.coordIntervals = new ArrayList<>();
                for (JAXBElement<? extends CoordIntervalType> _item: this.coordIntervals) {
                    _other.coordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
            _other.coordSystemId = this.coordSystemId;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >CoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CoordAreaType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordAreaType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordAreaType.Builder<_B> _newBuilder = new CoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordAreaType.Builder<_B> copyOf(final CoordAreaType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordAreaType.Builder<_B> _newBuilder = new CoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordAreaType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordAreaType.Builder<Void> copyExcept(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordAreaType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordAreaType.Builder<Void> copyOnly(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordAreaType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new IndirectCollectionProperty<>(CoordAreaType.PropInfo.COORD_INTERVALS, this))&&(this.coordIntervals!= null)) {
            for (JAXBElement<? extends CoordIntervalType> _item_: this.coordIntervals) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(CoordAreaType.PropInfo.COORD_SYSTEM_ID, this));
        return this;
    }

    public static class Builder<_B >
        extends StcBaseType.Builder<_B>
        implements Buildable
    {

        private List<Buildable> coordIntervals;
        private Object coordSystemId;

        public Builder(final _B _parentBuilder, final CoordAreaType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.coordIntervals == null) {
                    this.coordIntervals = null;
                } else {
                    this.coordIntervals = new ArrayList<>();
                    for (JAXBElement<? extends CoordIntervalType> _item: _other.coordIntervals) {
                        this.coordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                this.coordSystemId = _other.coordSystemId;
            }
        }

        public Builder(final _B _parentBuilder, final CoordAreaType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree coordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordIntervalsPropertyTree!= null):((coordIntervalsPropertyTree == null)||(!coordIntervalsPropertyTree.isLeaf())))) {
                    if (_other.coordIntervals == null) {
                        this.coordIntervals = null;
                    } else {
                        this.coordIntervals = new ArrayList<>();
                        for (JAXBElement<? extends CoordIntervalType> _item: _other.coordIntervals) {
                            this.coordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
                    this.coordSystemId = _other.coordSystemId;
                }
            }
        }

        protected<_P extends CoordAreaType >_P init(final _P _product) {
            if (this.coordIntervals!= null) {
                final List<JAXBElement<? extends CoordIntervalType>> coordIntervals = new ArrayList<>(this.coordIntervals.size());
                for (Buildable _item: this.coordIntervals) {
                    coordIntervals.add(((JAXBElement<? extends CoordIntervalType> ) _item.build()));
                }
                _product.coordIntervals = coordIntervals;
            }
            _product.coordSystemId = this.coordSystemId;
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        public CoordAreaType.Builder<_B> addCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            if (coordIntervals!= null) {
                if (this.coordIntervals == null) {
                    this.coordIntervals = new ArrayList<>();
                }
                for (JAXBElement<? extends CoordIntervalType> _item: coordIntervals) {
                    this.coordIntervals.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        public CoordAreaType.Builder<_B> withCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            if (this.coordIntervals!= null) {
                this.coordIntervals.clear();
            }
            return addCoordIntervals(coordIntervals);
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        public CoordAreaType.Builder<_B> addCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            addCoordIntervals(Arrays.asList(coordIntervals));
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        public CoordAreaType.Builder<_B> withCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            withCoordIntervals(Arrays.asList(coordIntervals));
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        public CoordAreaType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            this.coordSystemId = coordSystemId;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public CoordAreaType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public CoordAreaType build() {
            if (_storedValue == null) {
                return this.init(new CoordAreaType());
            } else {
                return ((CoordAreaType) _storedValue);
            }
        }

        public CoordAreaType.Builder<_B> copyOf(final CoordAreaType _other) {
            _other.copyTo(this);
            return this;
        }

        public CoordAreaType.Builder<_B> copyOf(final CoordAreaType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcBaseType.Modifier
    {


        public List<JAXBElement<? extends CoordIntervalType>> getCoordIntervals() {
            if (CoordAreaType.this.coordIntervals == null) {
                CoordAreaType.this.coordIntervals = new ArrayList<>();
            }
            return CoordAreaType.this.coordIntervals;
        }

        public void setCoordSystemId(final Object coordSystemId) {
            CoordAreaType.this.setCoordSystemId(coordSystemId);
        }

    }

    public static class PropInfo {

        public static final transient IndirectCollectionPropertyInfo<CoordAreaType, CoordIntervalType> COORD_INTERVALS = new IndirectCollectionPropertyInfo<CoordAreaType,CoordIntervalType>("coordIntervals", CoordAreaType.class, CoordIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "CoordInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordIntervalType"), false) {


            @Override
            public List<JAXBElement<? extends CoordIntervalType>> get(final CoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.coordIntervals);
            }

            @Override
            public void set(final CoordAreaType _instance_, final List<JAXBElement<? extends CoordIntervalType>> _value_) {
                if (_instance_!= null) {
                    _instance_.coordIntervals = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordAreaType, Object> COORD_SYSTEM_ID = new SinglePropertyInfo<CoordAreaType,Object>("coordSystemId", CoordAreaType.class, Object.class, false, null, new QName("", "coord_system_id"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true) {


            @Override
            public Object get(final CoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.coordSystemId);
            }

            @Override
            public void set(final CoordAreaType _instance_, final Object _value_) {
                if (_instance_!= null) {
                    _instance_.coordSystemId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CoordAreaType.Selector<CoordAreaType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CoordAreaType.Select _root() {
            return new CoordAreaType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcBaseType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, CoordAreaType.Selector<TRoot, TParent>> coordIntervals = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordAreaType.Selector<TRoot, TParent>> coordSystemId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.coordIntervals!= null) {
                products.put("coordIntervals", this.coordIntervals.init());
            }
            if (this.coordSystemId!= null) {
                products.put("coordSystemId", this.coordSystemId.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordAreaType.Selector<TRoot, TParent>> coordIntervals() {
            return ((this.coordIntervals == null)?this.coordIntervals = new com.kscs.util.jaxb.Selector<>(this._root, this, "coordIntervals"):this.coordIntervals);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordAreaType.Selector<TRoot, TParent>> coordSystemId() {
            return ((this.coordSystemId == null)?this.coordSystemId = new com.kscs.util.jaxb.Selector<>(this._root, this, "coordSystemId"):this.coordSystemId);
        }

    }

}
