
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Abstact coordinate interval type
 * 
 * <p>Java class for coordIntervalType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="coordIntervalType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcBaseType">
 *       <attribute name="lo_include" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="hi_include" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="fill_factor" type="{http://www.w3.org/2001/XMLSchema}float" default="1.0" />
 *       <attribute name="frame_id" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordIntervalType")
@XmlSeeAlso({
    UCoordScalarIntervalType.class,
    UCoord2VecIntervalType.class,
    UCoord3VecIntervalType.class,
    Coord2VecIntervalType.class,
    Coord3VecIntervalType.class,
    TimeIntervalType.class,
    SpatialIntervalType.class,
    CoordScalarIntervalType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class CoordIntervalType
    extends StcBaseType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Limit to be included?
     * 
     */
    @XmlAttribute(name = "lo_include")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Boolean loInclude;
    /**
     * Limit to be included?
     * 
     */
    @XmlAttribute(name = "hi_include")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Boolean hiInclude;
    /**
     * Fraction of interval that is occupied by data
     * 
     */
    @XmlAttribute(name = "fill_factor")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Float fillFactor;
    @XmlAttribute(name = "frame_id")
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Object frameId;

    /**
     * Default no-arg constructor
     * 
     */
    public CoordIntervalType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CoordIntervalType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.loInclude = loInclude;
        this.hiInclude = hiInclude;
        this.fillFactor = fillFactor;
        this.frameId = frameId;
    }

    /**
     * Limit to be included?
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean isLoInclude() {
        if (loInclude == null) {
            return true;
        } else {
            return loInclude;
        }
    }

    /**
     * Sets the value of the loInclude property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isLoInclude()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setLoInclude(Boolean value) {
        this.loInclude = value;
    }

    /**
     * Limit to be included?
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean isHiInclude() {
        if (hiInclude == null) {
            return true;
        } else {
            return hiInclude;
        }
    }

    /**
     * Sets the value of the hiInclude property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     * @see #isHiInclude()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setHiInclude(Boolean value) {
        this.hiInclude = value;
    }

    /**
     * Fraction of interval that is occupied by data
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public float getFillFactor() {
        if (fillFactor == null) {
            return  1.0F;
        } else {
            return fillFactor;
        }
    }

    /**
     * Sets the value of the fillFactor property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getFillFactor()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setFillFactor(Float value) {
        this.fillFactor = value;
    }

    /**
     * Gets the value of the frameId property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object getFrameId() {
        return frameId;
    }

    /**
     * Sets the value of the frameId property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setFrameId(Object value) {
        this.frameId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CoordIntervalType that = ((CoordIntervalType) object);
        {
            boolean leftLoInclude;
            leftLoInclude = ((this.loInclude!= null)?this.isLoInclude():true);
            boolean rightLoInclude;
            rightLoInclude = ((that.loInclude!= null)?that.isLoInclude():true);
            if (this.loInclude!= null) {
                if (that.loInclude!= null) {
                    if (leftLoInclude!= rightLoInclude) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.loInclude!= null) {
                    return false;
                }
            }
        }
        {
            boolean leftHiInclude;
            leftHiInclude = ((this.hiInclude!= null)?this.isHiInclude():true);
            boolean rightHiInclude;
            rightHiInclude = ((that.hiInclude!= null)?that.isHiInclude():true);
            if (this.hiInclude!= null) {
                if (that.hiInclude!= null) {
                    if (leftHiInclude!= rightHiInclude) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.hiInclude!= null) {
                    return false;
                }
            }
        }
        {
            float leftFillFactor;
            leftFillFactor = ((this.fillFactor!= null)?this.getFillFactor(): 1.0F);
            float rightFillFactor;
            rightFillFactor = ((that.fillFactor!= null)?that.getFillFactor(): 1.0F);
            if (this.fillFactor!= null) {
                if (that.fillFactor!= null) {
                    if (Float.floatToIntBits(leftFillFactor)!= Float.floatToIntBits(rightFillFactor)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.fillFactor!= null) {
                    return false;
                }
            }
        }
        {
            Object leftFrameId;
            leftFrameId = this.getFrameId();
            Object rightFrameId;
            rightFrameId = that.getFrameId();
            if (this.frameId!= null) {
                if (that.frameId!= null) {
                    if (!leftFrameId.equals(rightFrameId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.frameId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            boolean theLoInclude;
            theLoInclude = ((this.loInclude!= null)?this.isLoInclude():true);
            if (this.loInclude!= null) {
                currentHashCode += (theLoInclude? 1231 : 1237);
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            boolean theHiInclude;
            theHiInclude = ((this.hiInclude!= null)?this.isHiInclude():true);
            if (this.hiInclude!= null) {
                currentHashCode += (theHiInclude? 1231 : 1237);
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            float theFillFactor;
            theFillFactor = ((this.fillFactor!= null)?this.getFillFactor(): 1.0F);
            if (this.fillFactor!= null) {
                currentHashCode += Float.floatToIntBits(theFillFactor);
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Object theFrameId;
            theFrameId = this.getFrameId();
            if (this.frameId!= null) {
                currentHashCode += theFrameId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            boolean theLoInclude;
            theLoInclude = ((this.loInclude!= null)?this.isLoInclude():true);
            strategy.appendField(locator, this, "loInclude", buffer, theLoInclude, (this.loInclude!= null));
        }
        {
            boolean theHiInclude;
            theHiInclude = ((this.hiInclude!= null)?this.isHiInclude():true);
            strategy.appendField(locator, this, "hiInclude", buffer, theHiInclude, (this.hiInclude!= null));
        }
        {
            float theFillFactor;
            theFillFactor = ((this.fillFactor!= null)?this.getFillFactor(): 1.0F);
            strategy.appendField(locator, this, "fillFactor", buffer, theFillFactor, (this.fillFactor!= null));
        }
        {
            Object theFrameId;
            theFrameId = this.getFrameId();
            strategy.appendField(locator, this, "frameId", buffer, theFrameId, (this.frameId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof CoordIntervalType) {
            final CoordIntervalType target = this;
            final CoordIntervalType leftObject = ((CoordIntervalType) left);
            final CoordIntervalType rightObject = ((CoordIntervalType) right);
            {
                Boolean loIncludeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.loInclude!= null), (rightObject.loInclude!= null));
                if (loIncludeShouldBeMergedAndSet == Boolean.TRUE) {
                    boolean lhsLoInclude;
                    lhsLoInclude = ((leftObject.loInclude!= null)?leftObject.isLoInclude():true);
                    boolean rhsLoInclude;
                    rhsLoInclude = ((rightObject.loInclude!= null)?rightObject.isLoInclude():true);
                    boolean mergedLoInclude = ((boolean) strategy.merge(LocatorUtils.property(leftLocator, "loInclude", lhsLoInclude), LocatorUtils.property(rightLocator, "loInclude", rhsLoInclude), lhsLoInclude, rhsLoInclude, (leftObject.loInclude!= null), (rightObject.loInclude!= null)));
                    target.setLoInclude(mergedLoInclude);
                } else {
                    if (loIncludeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.loInclude = null;
                    }
                }
            }
            {
                Boolean hiIncludeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.hiInclude!= null), (rightObject.hiInclude!= null));
                if (hiIncludeShouldBeMergedAndSet == Boolean.TRUE) {
                    boolean lhsHiInclude;
                    lhsHiInclude = ((leftObject.hiInclude!= null)?leftObject.isHiInclude():true);
                    boolean rhsHiInclude;
                    rhsHiInclude = ((rightObject.hiInclude!= null)?rightObject.isHiInclude():true);
                    boolean mergedHiInclude = ((boolean) strategy.merge(LocatorUtils.property(leftLocator, "hiInclude", lhsHiInclude), LocatorUtils.property(rightLocator, "hiInclude", rhsHiInclude), lhsHiInclude, rhsHiInclude, (leftObject.hiInclude!= null), (rightObject.hiInclude!= null)));
                    target.setHiInclude(mergedHiInclude);
                } else {
                    if (hiIncludeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.hiInclude = null;
                    }
                }
            }
            {
                Boolean fillFactorShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.fillFactor!= null), (rightObject.fillFactor!= null));
                if (fillFactorShouldBeMergedAndSet == Boolean.TRUE) {
                    float lhsFillFactor;
                    lhsFillFactor = ((leftObject.fillFactor!= null)?leftObject.getFillFactor(): 1.0F);
                    float rhsFillFactor;
                    rhsFillFactor = ((rightObject.fillFactor!= null)?rightObject.getFillFactor(): 1.0F);
                    float mergedFillFactor = ((float) strategy.merge(LocatorUtils.property(leftLocator, "fillFactor", lhsFillFactor), LocatorUtils.property(rightLocator, "fillFactor", rhsFillFactor), lhsFillFactor, rhsFillFactor, (leftObject.fillFactor!= null), (rightObject.fillFactor!= null)));
                    target.setFillFactor(mergedFillFactor);
                } else {
                    if (fillFactorShouldBeMergedAndSet == Boolean.FALSE) {
                        target.fillFactor = null;
                    }
                }
            }
            {
                Boolean frameIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.frameId!= null), (rightObject.frameId!= null));
                if (frameIdShouldBeMergedAndSet == Boolean.TRUE) {
                    Object lhsFrameId;
                    lhsFrameId = leftObject.getFrameId();
                    Object rhsFrameId;
                    rhsFrameId = rightObject.getFrameId();
                    Object mergedFrameId = ((Object) strategy.merge(LocatorUtils.property(leftLocator, "frameId", lhsFrameId), LocatorUtils.property(rightLocator, "frameId", rhsFrameId), lhsFrameId, rhsFrameId, (leftObject.frameId!= null), (rightObject.frameId!= null)));
                    target.setFrameId(mergedFrameId);
                } else {
                    if (frameIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.frameId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new CoordIntervalType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType clone() {
        final CoordIntervalType _newObject;
        _newObject = ((CoordIntervalType) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType createCopy() {
        final CoordIntervalType _newObject = ((CoordIntervalType) super.createCopy());
        _newObject.loInclude = this.loInclude;
        _newObject.hiInclude = this.hiInclude;
        _newObject.fillFactor = this.fillFactor;
        _newObject.frameId = this.frameId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordIntervalType _newObject = ((CoordIntervalType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree loIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("loInclude"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(loIncludePropertyTree!= null):((loIncludePropertyTree == null)||(!loIncludePropertyTree.isLeaf())))) {
            _newObject.loInclude = this.loInclude;
        }
        final PropertyTree hiIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("hiInclude"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hiIncludePropertyTree!= null):((hiIncludePropertyTree == null)||(!hiIncludePropertyTree.isLeaf())))) {
            _newObject.hiInclude = this.hiInclude;
        }
        final PropertyTree fillFactorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fillFactor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fillFactorPropertyTree!= null):((fillFactorPropertyTree == null)||(!fillFactorPropertyTree.isLeaf())))) {
            _newObject.fillFactor = this.fillFactor;
        }
        final PropertyTree frameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frameId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(frameIdPropertyTree!= null):((frameIdPropertyTree == null)||(!frameIdPropertyTree.isLeaf())))) {
            _newObject.frameId = this.frameId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CoordIntervalType.Modifier();
        }
        return ((CoordIntervalType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final CoordIntervalType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.loInclude = this.loInclude;
        _other.hiInclude = this.hiInclude;
        _other.fillFactor = this.fillFactor;
        _other.frameId = this.frameId;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >CoordIntervalType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CoordIntervalType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordIntervalType.Builder<Void> builder() {
        return new CoordIntervalType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordIntervalType.Builder<_B> copyOf(final StcBaseType _other) {
        final CoordIntervalType.Builder<_B> _newBuilder = new CoordIntervalType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordIntervalType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final CoordIntervalType.Builder<_B> _newBuilder = new CoordIntervalType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final CoordIntervalType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree loIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("loInclude"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(loIncludePropertyTree!= null):((loIncludePropertyTree == null)||(!loIncludePropertyTree.isLeaf())))) {
            _other.loInclude = this.loInclude;
        }
        final PropertyTree hiIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("hiInclude"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hiIncludePropertyTree!= null):((hiIncludePropertyTree == null)||(!hiIncludePropertyTree.isLeaf())))) {
            _other.hiInclude = this.hiInclude;
        }
        final PropertyTree fillFactorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fillFactor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fillFactorPropertyTree!= null):((fillFactorPropertyTree == null)||(!fillFactorPropertyTree.isLeaf())))) {
            _other.fillFactor = this.fillFactor;
        }
        final PropertyTree frameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frameId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(frameIdPropertyTree!= null):((frameIdPropertyTree == null)||(!frameIdPropertyTree.isLeaf())))) {
            _other.frameId = this.frameId;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >CoordIntervalType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CoordIntervalType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordIntervalType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordIntervalType.Builder<_B> _newBuilder = new CoordIntervalType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >CoordIntervalType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordIntervalType.Builder<_B> _newBuilder = new CoordIntervalType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordIntervalType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordIntervalType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordIntervalType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static CoordIntervalType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public CoordIntervalType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(CoordIntervalType.PropInfo.LO_INCLUDE, this));
        _visitor_.visit(new SingleProperty<>(CoordIntervalType.PropInfo.HI_INCLUDE, this));
        _visitor_.visit(new SingleProperty<>(CoordIntervalType.PropInfo.FILL_FACTOR, this));
        _visitor_.visit(new SingleProperty<>(CoordIntervalType.PropInfo.FRAME_ID, this));
        return this;
    }

    public static class Builder<_B >
        extends StcBaseType.Builder<_B>
        implements Buildable
    {

        private Boolean loInclude = true;
        private Boolean hiInclude = true;
        private Float fillFactor = 1.0F;
        private Object frameId;

        public Builder(final _B _parentBuilder, final CoordIntervalType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.loInclude = _other.loInclude;
                this.hiInclude = _other.hiInclude;
                this.fillFactor = _other.fillFactor;
                this.frameId = _other.frameId;
            }
        }

        public Builder(final _B _parentBuilder, final CoordIntervalType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree loIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("loInclude"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(loIncludePropertyTree!= null):((loIncludePropertyTree == null)||(!loIncludePropertyTree.isLeaf())))) {
                    this.loInclude = _other.loInclude;
                }
                final PropertyTree hiIncludePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("hiInclude"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hiIncludePropertyTree!= null):((hiIncludePropertyTree == null)||(!hiIncludePropertyTree.isLeaf())))) {
                    this.hiInclude = _other.hiInclude;
                }
                final PropertyTree fillFactorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("fillFactor"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fillFactorPropertyTree!= null):((fillFactorPropertyTree == null)||(!fillFactorPropertyTree.isLeaf())))) {
                    this.fillFactor = _other.fillFactor;
                }
                final PropertyTree frameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("frameId"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(frameIdPropertyTree!= null):((frameIdPropertyTree == null)||(!frameIdPropertyTree.isLeaf())))) {
                    this.frameId = _other.frameId;
                }
            }
        }

        protected<_P extends CoordIntervalType >_P init(final _P _product) {
            _product.loInclude = this.loInclude;
            _product.hiInclude = this.hiInclude;
            _product.fillFactor = this.fillFactor;
            _product.frameId = this.frameId;
            return super.init(_product);
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        public CoordIntervalType.Builder<_B> withLoInclude(final Boolean loInclude) {
            this.loInclude = loInclude;
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        public CoordIntervalType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            this.hiInclude = hiInclude;
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        public CoordIntervalType.Builder<_B> withFillFactor(final Float fillFactor) {
            this.fillFactor = fillFactor;
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        public CoordIntervalType.Builder<_B> withFrameId(final Object frameId) {
            this.frameId = frameId;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public CoordIntervalType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public CoordIntervalType build() {
            if (_storedValue == null) {
                return this.init(new CoordIntervalType());
            } else {
                return ((CoordIntervalType) _storedValue);
            }
        }

        public CoordIntervalType.Builder<_B> copyOf(final CoordIntervalType _other) {
            _other.copyTo(this);
            return this;
        }

        public CoordIntervalType.Builder<_B> copyOf(final CoordIntervalType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcBaseType.Modifier
    {


        public void setLoInclude(final Boolean loInclude) {
            CoordIntervalType.this.setLoInclude(loInclude);
        }

        public void setHiInclude(final Boolean hiInclude) {
            CoordIntervalType.this.setHiInclude(hiInclude);
        }

        public void setFillFactor(final Float fillFactor) {
            CoordIntervalType.this.setFillFactor(fillFactor);
        }

        public void setFrameId(final Object frameId) {
            CoordIntervalType.this.setFrameId(frameId);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<CoordIntervalType, Boolean> LO_INCLUDE = new SinglePropertyInfo<CoordIntervalType,Boolean>("loInclude", CoordIntervalType.class, Boolean.class, false, true, new QName("", "lo_include"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), true) {


            @Override
            public Boolean get(final CoordIntervalType _instance_) {
                return ((_instance_ == null)?null:_instance_.loInclude);
            }

            @Override
            public void set(final CoordIntervalType _instance_, final Boolean _value_) {
                if (_instance_!= null) {
                    _instance_.loInclude = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordIntervalType, Boolean> HI_INCLUDE = new SinglePropertyInfo<CoordIntervalType,Boolean>("hiInclude", CoordIntervalType.class, Boolean.class, false, true, new QName("", "hi_include"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), true) {


            @Override
            public Boolean get(final CoordIntervalType _instance_) {
                return ((_instance_ == null)?null:_instance_.hiInclude);
            }

            @Override
            public void set(final CoordIntervalType _instance_, final Boolean _value_) {
                if (_instance_!= null) {
                    _instance_.hiInclude = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordIntervalType, Float> FILL_FACTOR = new SinglePropertyInfo<CoordIntervalType,Float>("fillFactor", CoordIntervalType.class, Float.class, false, 1.0F, new QName("", "fill_factor"), new QName("http://www.w3.org/2001/XMLSchema", "float"), true) {


            @Override
            public Float get(final CoordIntervalType _instance_) {
                return ((_instance_ == null)?null:_instance_.fillFactor);
            }

            @Override
            public void set(final CoordIntervalType _instance_, final Float _value_) {
                if (_instance_!= null) {
                    _instance_.fillFactor = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordIntervalType, Object> FRAME_ID = new SinglePropertyInfo<CoordIntervalType,Object>("frameId", CoordIntervalType.class, Object.class, false, null, new QName("", "frame_id"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true) {


            @Override
            public Object get(final CoordIntervalType _instance_) {
                return ((_instance_ == null)?null:_instance_.frameId);
            }

            @Override
            public void set(final CoordIntervalType _instance_, final Object _value_) {
                if (_instance_!= null) {
                    _instance_.frameId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CoordIntervalType.Selector<CoordIntervalType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CoordIntervalType.Select _root() {
            return new CoordIntervalType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcBaseType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> loInclude = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> hiInclude = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> fillFactor = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> frameId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.loInclude!= null) {
                products.put("loInclude", this.loInclude.init());
            }
            if (this.hiInclude!= null) {
                products.put("hiInclude", this.hiInclude.init());
            }
            if (this.fillFactor!= null) {
                products.put("fillFactor", this.fillFactor.init());
            }
            if (this.frameId!= null) {
                products.put("frameId", this.frameId.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> loInclude() {
            return ((this.loInclude == null)?this.loInclude = new com.kscs.util.jaxb.Selector<>(this._root, this, "loInclude"):this.loInclude);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> hiInclude() {
            return ((this.hiInclude == null)?this.hiInclude = new com.kscs.util.jaxb.Selector<>(this._root, this, "hiInclude"):this.hiInclude);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> fillFactor() {
            return ((this.fillFactor == null)?this.fillFactor = new com.kscs.util.jaxb.Selector<>(this._root, this, "fillFactor"):this.fillFactor);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordIntervalType.Selector<TRoot, TParent>> frameId() {
            return ((this.frameId == null)?this.frameId = new com.kscs.util.jaxb.Selector<>(this._root, this, "frameId"):this.frameId);
        }

    }

}
