
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Pixel area type
 * 
 * <p>Java class for pixelCoordAreaType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="pixelCoordAreaType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordAreaType">
 *       <sequence maxOccurs="unbounded" minOccurs="0">
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}PixelCoordInterval"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "pixelCoordAreaType", propOrder = {
    "pixelCoordIntervals"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class PixelCoordAreaType
    extends CoordAreaType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The 1-, 2-, or 3-D pixel coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     */
    @XmlElementRef(name = "PixelCoordInterval", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class, required = false)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<JAXBElement<? extends CoordIntervalType>> pixelCoordIntervals;

    /**
     * Default no-arg constructor
     * 
     */
    public PixelCoordAreaType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public PixelCoordAreaType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<JAXBElement<? extends CoordIntervalType>> coordIntervals, final Object coordSystemId, final List<JAXBElement<? extends CoordIntervalType>> pixelCoordIntervals) {
        super(id, idref, ucd, type, href, idType, idrefType, coordIntervals, coordSystemId);
        this.pixelCoordIntervals = pixelCoordIntervals;
    }

    /**
     * The 1-, 2-, or 3-D pixel coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     * Gets the value of the pixelCoordIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pixelCoordIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPixelCoordIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link Coord2VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link Coord3VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link CoordIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link CoordScalarIntervalType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the pixelCoordIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<JAXBElement<? extends CoordIntervalType>> getPixelCoordIntervals() {
        if (pixelCoordIntervals == null) {
            pixelCoordIntervals = new ArrayList<>();
        }
        return this.pixelCoordIntervals;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final PixelCoordAreaType that = ((PixelCoordAreaType) object);
        {
            List<JAXBElement<? extends CoordIntervalType>> leftPixelCoordIntervals;
            leftPixelCoordIntervals = (((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty()))?this.getPixelCoordIntervals():null);
            List<JAXBElement<? extends CoordIntervalType>> rightPixelCoordIntervals;
            rightPixelCoordIntervals = (((that.pixelCoordIntervals!= null)&&(!that.pixelCoordIntervals.isEmpty()))?that.getPixelCoordIntervals():null);
            if ((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty())) {
                if ((that.pixelCoordIntervals!= null)&&(!that.pixelCoordIntervals.isEmpty())) {
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> leftPixelCoordIntervalsListIterator = leftPixelCoordIntervals.listIterator();
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> rightPixelCoordIntervalsListIterator = rightPixelCoordIntervals.listIterator();
                    while (rightPixelCoordIntervalsListIterator.hasNext()&&leftPixelCoordIntervalsListIterator.hasNext()) {
                        final JAXBElement<? extends CoordIntervalType> rightPixelCoordIntervalsListIteratorElement = rightPixelCoordIntervalsListIterator.next();
                        final JAXBElement<? extends CoordIntervalType> leftPixelCoordIntervalsListIteratorElement = leftPixelCoordIntervalsListIterator.next();
                        if (rightPixelCoordIntervalsListIteratorElement!= null) {
                            if (leftPixelCoordIntervalsListIteratorElement!= null) {
                                {
                                    final QName rightPixelCoordIntervalsListIteratorElementName = rightPixelCoordIntervalsListIteratorElement.getName();
                                    final QName leftPixelCoordIntervalsListIteratorElementName = leftPixelCoordIntervalsListIteratorElement.getName();
                                    if (rightPixelCoordIntervalsListIteratorElementName!= null) {
                                        if (leftPixelCoordIntervalsListIteratorElementName!= null) {
                                            if (!rightPixelCoordIntervalsListIteratorElementName.equals(leftPixelCoordIntervalsListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftPixelCoordIntervalsListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final CoordIntervalType rightPixelCoordIntervalsListIteratorElementValue = rightPixelCoordIntervalsListIteratorElement.getValue();
                                    final CoordIntervalType leftPixelCoordIntervalsListIteratorElementValue = leftPixelCoordIntervalsListIteratorElement.getValue();
                                    if (rightPixelCoordIntervalsListIteratorElementValue!= null) {
                                        if (leftPixelCoordIntervalsListIteratorElementValue!= null) {
                                            if (!rightPixelCoordIntervalsListIteratorElementValue.equals(leftPixelCoordIntervalsListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftPixelCoordIntervalsListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends CoordIntervalType> rightPixelCoordIntervalsListIteratorElementDeclaredType = rightPixelCoordIntervalsListIteratorElement.getDeclaredType();
                                    final Class<? extends CoordIntervalType> leftPixelCoordIntervalsListIteratorElementDeclaredType = leftPixelCoordIntervalsListIteratorElement.getDeclaredType();
                                    if (rightPixelCoordIntervalsListIteratorElementDeclaredType!= null) {
                                        if (leftPixelCoordIntervalsListIteratorElementDeclaredType!= null) {
                                            if (!rightPixelCoordIntervalsListIteratorElementDeclaredType.equals(leftPixelCoordIntervalsListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftPixelCoordIntervalsListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightPixelCoordIntervalsListIteratorElementScope = rightPixelCoordIntervalsListIteratorElement.getScope();
                                    final Class<?> leftPixelCoordIntervalsListIteratorElementScope = leftPixelCoordIntervalsListIteratorElement.getScope();
                                    if (rightPixelCoordIntervalsListIteratorElementScope!= null) {
                                        if (leftPixelCoordIntervalsListIteratorElementScope!= null) {
                                            if (!rightPixelCoordIntervalsListIteratorElementScope.equals(leftPixelCoordIntervalsListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftPixelCoordIntervalsListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightPixelCoordIntervalsListIteratorElementNil = rightPixelCoordIntervalsListIteratorElement.isNil();
                                    final boolean leftPixelCoordIntervalsListIteratorElementNil = leftPixelCoordIntervalsListIteratorElement.isNil();
                                    if (rightPixelCoordIntervalsListIteratorElementNil!= leftPixelCoordIntervalsListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftPixelCoordIntervalsListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightPixelCoordIntervalsListIterator.hasNext()||leftPixelCoordIntervalsListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.pixelCoordIntervals!= null)&&(!that.pixelCoordIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends CoordIntervalType>> thePixelCoordIntervals;
            thePixelCoordIntervals = (((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty()))?this.getPixelCoordIntervals():null);
            if ((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty())) {
                final ListIterator<JAXBElement<? extends CoordIntervalType>> thePixelCoordIntervalsListIterator = thePixelCoordIntervals.listIterator();
                while (thePixelCoordIntervalsListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends CoordIntervalType> thePixelCoordIntervalsListIteratorElement = thePixelCoordIntervalsListIterator.next();
                    if (thePixelCoordIntervalsListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName thePixelCoordIntervalsListIteratorElementName = thePixelCoordIntervalsListIteratorElement.getName();
                            if (thePixelCoordIntervalsListIteratorElementName!= null) {
                                currentHashCode += thePixelCoordIntervalsListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final CoordIntervalType thePixelCoordIntervalsListIteratorElementValue = thePixelCoordIntervalsListIteratorElement.getValue();
                            if (thePixelCoordIntervalsListIteratorElementValue!= null) {
                                currentHashCode += thePixelCoordIntervalsListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends CoordIntervalType> thePixelCoordIntervalsListIteratorElementDeclaredType = thePixelCoordIntervalsListIteratorElement.getDeclaredType();
                            if (thePixelCoordIntervalsListIteratorElementDeclaredType!= null) {
                                currentHashCode += thePixelCoordIntervalsListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> thePixelCoordIntervalsListIteratorElementScope = thePixelCoordIntervalsListIteratorElement.getScope();
                            if (thePixelCoordIntervalsListIteratorElementScope!= null) {
                                currentHashCode += thePixelCoordIntervalsListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean thePixelCoordIntervalsListIteratorElementNil = thePixelCoordIntervalsListIteratorElement.isNil();
                            currentHashCode += (thePixelCoordIntervalsListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<JAXBElement<? extends CoordIntervalType>> thePixelCoordIntervals;
            thePixelCoordIntervals = (((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty()))?this.getPixelCoordIntervals():null);
            strategy.appendField(locator, this, "pixelCoordIntervals", buffer, thePixelCoordIntervals, ((this.pixelCoordIntervals!= null)&&(!this.pixelCoordIntervals.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof PixelCoordAreaType) {
            final PixelCoordAreaType target = this;
            final PixelCoordAreaType leftObject = ((PixelCoordAreaType) left);
            final PixelCoordAreaType rightObject = ((PixelCoordAreaType) right);
            {
                Boolean pixelCoordIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.pixelCoordIntervals!= null)&&(!leftObject.pixelCoordIntervals.isEmpty())), ((rightObject.pixelCoordIntervals!= null)&&(!rightObject.pixelCoordIntervals.isEmpty())));
                if (pixelCoordIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends CoordIntervalType>> lhsPixelCoordIntervals;
                    lhsPixelCoordIntervals = (((leftObject.pixelCoordIntervals!= null)&&(!leftObject.pixelCoordIntervals.isEmpty()))?leftObject.getPixelCoordIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> rhsPixelCoordIntervals;
                    rhsPixelCoordIntervals = (((rightObject.pixelCoordIntervals!= null)&&(!rightObject.pixelCoordIntervals.isEmpty()))?rightObject.getPixelCoordIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> mergedPixelCoordIntervals = ((List<JAXBElement<? extends CoordIntervalType>> ) strategy.merge(LocatorUtils.property(leftLocator, "pixelCoordIntervals", lhsPixelCoordIntervals), LocatorUtils.property(rightLocator, "pixelCoordIntervals", rhsPixelCoordIntervals), lhsPixelCoordIntervals, rhsPixelCoordIntervals, ((leftObject.pixelCoordIntervals!= null)&&(!leftObject.pixelCoordIntervals.isEmpty())), ((rightObject.pixelCoordIntervals!= null)&&(!rightObject.pixelCoordIntervals.isEmpty()))));
                    target.pixelCoordIntervals = null;
                    if (mergedPixelCoordIntervals!= null) {
                        List<JAXBElement<? extends CoordIntervalType>> uniquePixelCoordIntervalsl = target.getPixelCoordIntervals();
                        uniquePixelCoordIntervalsl.addAll(mergedPixelCoordIntervals);
                    }
                } else {
                    if (pixelCoordIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.pixelCoordIntervals = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new PixelCoordAreaType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType clone() {
        final PixelCoordAreaType _newObject;
        _newObject = ((PixelCoordAreaType) super.clone());
        _newObject.pixelCoordIntervals = ((this.pixelCoordIntervals == null)?null:new ArrayList<>(this.pixelCoordIntervals));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType createCopy() {
        final PixelCoordAreaType _newObject = ((PixelCoordAreaType) super.createCopy());
        _newObject.pixelCoordIntervals = ((this.pixelCoordIntervals == null)?null:new ArrayList<>(this.pixelCoordIntervals));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelCoordAreaType _newObject = ((PixelCoordAreaType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree pixelCoordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelCoordIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelCoordIntervalsPropertyTree!= null):((pixelCoordIntervalsPropertyTree == null)||(!pixelCoordIntervalsPropertyTree.isLeaf())))) {
            _newObject.pixelCoordIntervals = ((this.pixelCoordIntervals == null)?null:new ArrayList<>(this.pixelCoordIntervals));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new PixelCoordAreaType.Modifier();
        }
        return ((PixelCoordAreaType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final PixelCoordAreaType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.pixelCoordIntervals == null) {
            _other.pixelCoordIntervals = null;
        } else {
            _other.pixelCoordIntervals = new ArrayList<>();
            for (JAXBElement<? extends CoordIntervalType> _item: this.pixelCoordIntervals) {
                _other.pixelCoordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >PixelCoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new PixelCoordAreaType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> builder() {
        return new PixelCoordAreaType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final StcBaseType _other) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final CoordAreaType _other) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final PixelCoordAreaType _other) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final PixelCoordAreaType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree pixelCoordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelCoordIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelCoordIntervalsPropertyTree!= null):((pixelCoordIntervalsPropertyTree == null)||(!pixelCoordIntervalsPropertyTree.isLeaf())))) {
            if (this.pixelCoordIntervals == null) {
                _other.pixelCoordIntervals = null;
            } else {
                _other.pixelCoordIntervals = new ArrayList<>();
                for (JAXBElement<? extends CoordIntervalType> _item: this.pixelCoordIntervals) {
                    _other.pixelCoordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >PixelCoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new PixelCoordAreaType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final CoordAreaType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelCoordAreaType.Builder<_B> copyOf(final PixelCoordAreaType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelCoordAreaType.Builder<_B> _newBuilder = new PixelCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyExcept(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyExcept(final PixelCoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyOnly(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelCoordAreaType.Builder<Void> copyOnly(final PixelCoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelCoordAreaType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new IndirectCollectionProperty<>(PixelCoordAreaType.PropInfo.PIXEL_COORD_INTERVALS, this))&&(this.pixelCoordIntervals!= null)) {
            for (JAXBElement<? extends CoordIntervalType> _item_: this.pixelCoordIntervals) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordAreaType.Builder<_B>
        implements Buildable
    {

        private List<Buildable> pixelCoordIntervals;

        public Builder(final _B _parentBuilder, final PixelCoordAreaType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.pixelCoordIntervals == null) {
                    this.pixelCoordIntervals = null;
                } else {
                    this.pixelCoordIntervals = new ArrayList<>();
                    for (JAXBElement<? extends CoordIntervalType> _item: _other.pixelCoordIntervals) {
                        this.pixelCoordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final PixelCoordAreaType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree pixelCoordIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixelCoordIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixelCoordIntervalsPropertyTree!= null):((pixelCoordIntervalsPropertyTree == null)||(!pixelCoordIntervalsPropertyTree.isLeaf())))) {
                    if (_other.pixelCoordIntervals == null) {
                        this.pixelCoordIntervals = null;
                    } else {
                        this.pixelCoordIntervals = new ArrayList<>();
                        for (JAXBElement<? extends CoordIntervalType> _item: _other.pixelCoordIntervals) {
                            this.pixelCoordIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
            }
        }

        protected<_P extends PixelCoordAreaType >_P init(final _P _product) {
            if (this.pixelCoordIntervals!= null) {
                final List<JAXBElement<? extends CoordIntervalType>> pixelCoordIntervals = new ArrayList<>(this.pixelCoordIntervals.size());
                for (Buildable _item: this.pixelCoordIntervals) {
                    pixelCoordIntervals.add(((JAXBElement<? extends CoordIntervalType> ) _item.build()));
                }
                _product.pixelCoordIntervals = pixelCoordIntervals;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "pixelCoordIntervals"
         * 
         * @param pixelCoordIntervals
         *     Items to add to the value of the "pixelCoordIntervals" property
         */
        public PixelCoordAreaType.Builder<_B> addPixelCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> pixelCoordIntervals) {
            if (pixelCoordIntervals!= null) {
                if (this.pixelCoordIntervals == null) {
                    this.pixelCoordIntervals = new ArrayList<>();
                }
                for (JAXBElement<? extends CoordIntervalType> _item: pixelCoordIntervals) {
                    this.pixelCoordIntervals.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "pixelCoordIntervals" (any previous value will be
         * replaced)
         * 
         * @param pixelCoordIntervals
         *     New value of the "pixelCoordIntervals" property.
         */
        public PixelCoordAreaType.Builder<_B> withPixelCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> pixelCoordIntervals) {
            if (this.pixelCoordIntervals!= null) {
                this.pixelCoordIntervals.clear();
            }
            return addPixelCoordIntervals(pixelCoordIntervals);
        }

        /**
         * Adds the given items to the value of "pixelCoordIntervals"
         * 
         * @param pixelCoordIntervals
         *     Items to add to the value of the "pixelCoordIntervals" property
         */
        public PixelCoordAreaType.Builder<_B> addPixelCoordIntervals(JAXBElement<? extends CoordIntervalType> ... pixelCoordIntervals) {
            addPixelCoordIntervals(Arrays.asList(pixelCoordIntervals));
            return this;
        }

        /**
         * Sets the new value of "pixelCoordIntervals" (any previous value will be
         * replaced)
         * 
         * @param pixelCoordIntervals
         *     New value of the "pixelCoordIntervals" property.
         */
        public PixelCoordAreaType.Builder<_B> withPixelCoordIntervals(JAXBElement<? extends CoordIntervalType> ... pixelCoordIntervals) {
            withPixelCoordIntervals(Arrays.asList(pixelCoordIntervals));
            return this;
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        @Override
        public PixelCoordAreaType.Builder<_B> addCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            super.addCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        @Override
        public PixelCoordAreaType.Builder<_B> addCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            super.addCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            super.withCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            super.withCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public PixelCoordAreaType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public PixelCoordAreaType build() {
            if (_storedValue == null) {
                return this.init(new PixelCoordAreaType());
            } else {
                return ((PixelCoordAreaType) _storedValue);
            }
        }

        public PixelCoordAreaType.Builder<_B> copyOf(final PixelCoordAreaType _other) {
            _other.copyTo(this);
            return this;
        }

        public PixelCoordAreaType.Builder<_B> copyOf(final PixelCoordAreaType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordAreaType.Modifier
    {


        public List<JAXBElement<? extends CoordIntervalType>> getPixelCoordIntervals() {
            if (PixelCoordAreaType.this.pixelCoordIntervals == null) {
                PixelCoordAreaType.this.pixelCoordIntervals = new ArrayList<>();
            }
            return PixelCoordAreaType.this.pixelCoordIntervals;
        }

    }

    public static class PropInfo {

        public static final transient IndirectCollectionPropertyInfo<PixelCoordAreaType, CoordIntervalType> PIXEL_COORD_INTERVALS = new IndirectCollectionPropertyInfo<PixelCoordAreaType,CoordIntervalType>("pixelCoordIntervals", PixelCoordAreaType.class, CoordIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PixelCoordInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordIntervalType"), false) {


            @Override
            public List<JAXBElement<? extends CoordIntervalType>> get(final PixelCoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.pixelCoordIntervals);
            }

            @Override
            public void set(final PixelCoordAreaType _instance_, final List<JAXBElement<? extends CoordIntervalType>> _value_) {
                if (_instance_!= null) {
                    _instance_.pixelCoordIntervals = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends PixelCoordAreaType.Selector<PixelCoordAreaType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static PixelCoordAreaType.Select _root() {
            return new PixelCoordAreaType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordAreaType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, PixelCoordAreaType.Selector<TRoot, TParent>> pixelCoordIntervals = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.pixelCoordIntervals!= null) {
                products.put("pixelCoordIntervals", this.pixelCoordIntervals.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, PixelCoordAreaType.Selector<TRoot, TParent>> pixelCoordIntervals() {
            return ((this.pixelCoordIntervals == null)?this.pixelCoordIntervals = new com.kscs.util.jaxb.Selector<>(this._root, this, "pixelCoordIntervals"):this.pixelCoordIntervals);
        }

    }

}
