
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A pixel coordinate frame (which may be 1-D, 2-D, or 3-D) consists of a coordinate frame, a reference position, a flavor, a reference pixel array and the order in which the pixel axes appear in the pixel array
 * 
 * <p>Java class for pixelFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="pixelFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}genericCoordFrameType">
 *       <sequence>
 *         <element name="ReferencePixel" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}pixelType" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="axis1_order" use="required" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       <attribute name="axis2_order" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       <attribute name="axis3_order" type="{http://www.w3.org/2001/XMLSchema}integer" />
 *       <attribute name="ref_frame_id" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "pixelFrameType", propOrder = {
    "referencePixel"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class PixelFrameType
    extends GenericCoordFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "ReferencePixel", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected PixelType referencePixel;
    @XmlAttribute(name = "axis1_order", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger axis1Order;
    @XmlAttribute(name = "axis2_order")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger axis2Order;
    @XmlAttribute(name = "axis3_order")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected BigInteger axis3Order;
    @XmlAttribute(name = "ref_frame_id")
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Object refFrameId;

    /**
     * Default no-arg constructor
     * 
     */
    public PixelFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public PixelFrameType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final String name, final JAXBElement<? extends CoordRefFrameType> coordRefFrame, final CustomRefPosType coordRefPos, final JAXBElement<? extends CoordFlavorType> coordFlavor, final PixelType referencePixel, final BigInteger axis1Order, final BigInteger axis2Order, final BigInteger axis3Order, final Object refFrameId) {
        super(id, idref, ucd, type, href, idType, idrefType, name, coordRefFrame, coordRefPos, coordFlavor);
        this.referencePixel = referencePixel;
        this.axis1Order = axis1Order;
        this.axis2Order = axis2Order;
        this.axis3Order = axis3Order;
        this.refFrameId = refFrameId;
    }

    /**
     * Gets the value of the referencePixel property.
     * 
     * @return
     *     possible object is
     *     {@link PixelType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelType getReferencePixel() {
        return referencePixel;
    }

    /**
     * Sets the value of the referencePixel property.
     * 
     * @param value
     *     allowed object is
     *     {@link PixelType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setReferencePixel(PixelType value) {
        this.referencePixel = value;
    }

    /**
     * Gets the value of the axis1Order property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getAxis1Order() {
        return axis1Order;
    }

    /**
     * Sets the value of the axis1Order property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAxis1Order(BigInteger value) {
        this.axis1Order = value;
    }

    /**
     * Gets the value of the axis2Order property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getAxis2Order() {
        return axis2Order;
    }

    /**
     * Sets the value of the axis2Order property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAxis2Order(BigInteger value) {
        this.axis2Order = value;
    }

    /**
     * Gets the value of the axis3Order property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public BigInteger getAxis3Order() {
        return axis3Order;
    }

    /**
     * Sets the value of the axis3Order property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAxis3Order(BigInteger value) {
        this.axis3Order = value;
    }

    /**
     * Gets the value of the refFrameId property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object getRefFrameId() {
        return refFrameId;
    }

    /**
     * Sets the value of the refFrameId property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setRefFrameId(Object value) {
        this.refFrameId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final PixelFrameType that = ((PixelFrameType) object);
        {
            PixelType leftReferencePixel;
            leftReferencePixel = this.getReferencePixel();
            PixelType rightReferencePixel;
            rightReferencePixel = that.getReferencePixel();
            if (this.referencePixel!= null) {
                if (that.referencePixel!= null) {
                    if (!leftReferencePixel.equals(rightReferencePixel)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencePixel!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftAxis1Order;
            leftAxis1Order = this.getAxis1Order();
            BigInteger rightAxis1Order;
            rightAxis1Order = that.getAxis1Order();
            if (this.axis1Order!= null) {
                if (that.axis1Order!= null) {
                    if (!leftAxis1Order.equals(rightAxis1Order)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.axis1Order!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftAxis2Order;
            leftAxis2Order = this.getAxis2Order();
            BigInteger rightAxis2Order;
            rightAxis2Order = that.getAxis2Order();
            if (this.axis2Order!= null) {
                if (that.axis2Order!= null) {
                    if (!leftAxis2Order.equals(rightAxis2Order)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.axis2Order!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftAxis3Order;
            leftAxis3Order = this.getAxis3Order();
            BigInteger rightAxis3Order;
            rightAxis3Order = that.getAxis3Order();
            if (this.axis3Order!= null) {
                if (that.axis3Order!= null) {
                    if (!leftAxis3Order.equals(rightAxis3Order)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.axis3Order!= null) {
                    return false;
                }
            }
        }
        {
            Object leftRefFrameId;
            leftRefFrameId = this.getRefFrameId();
            Object rightRefFrameId;
            rightRefFrameId = that.getRefFrameId();
            if (this.refFrameId!= null) {
                if (that.refFrameId!= null) {
                    if (!leftRefFrameId.equals(rightRefFrameId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.refFrameId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            PixelType theReferencePixel;
            theReferencePixel = this.getReferencePixel();
            if (this.referencePixel!= null) {
                currentHashCode += theReferencePixel.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theAxis1Order;
            theAxis1Order = this.getAxis1Order();
            if (this.axis1Order!= null) {
                currentHashCode += theAxis1Order.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theAxis2Order;
            theAxis2Order = this.getAxis2Order();
            if (this.axis2Order!= null) {
                currentHashCode += theAxis2Order.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theAxis3Order;
            theAxis3Order = this.getAxis3Order();
            if (this.axis3Order!= null) {
                currentHashCode += theAxis3Order.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Object theRefFrameId;
            theRefFrameId = this.getRefFrameId();
            if (this.refFrameId!= null) {
                currentHashCode += theRefFrameId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            PixelType theReferencePixel;
            theReferencePixel = this.getReferencePixel();
            strategy.appendField(locator, this, "referencePixel", buffer, theReferencePixel, (this.referencePixel!= null));
        }
        {
            BigInteger theAxis1Order;
            theAxis1Order = this.getAxis1Order();
            strategy.appendField(locator, this, "axis1Order", buffer, theAxis1Order, (this.axis1Order!= null));
        }
        {
            BigInteger theAxis2Order;
            theAxis2Order = this.getAxis2Order();
            strategy.appendField(locator, this, "axis2Order", buffer, theAxis2Order, (this.axis2Order!= null));
        }
        {
            BigInteger theAxis3Order;
            theAxis3Order = this.getAxis3Order();
            strategy.appendField(locator, this, "axis3Order", buffer, theAxis3Order, (this.axis3Order!= null));
        }
        {
            Object theRefFrameId;
            theRefFrameId = this.getRefFrameId();
            strategy.appendField(locator, this, "refFrameId", buffer, theRefFrameId, (this.refFrameId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof PixelFrameType) {
            final PixelFrameType target = this;
            final PixelFrameType leftObject = ((PixelFrameType) left);
            final PixelFrameType rightObject = ((PixelFrameType) right);
            {
                Boolean referencePixelShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.referencePixel!= null), (rightObject.referencePixel!= null));
                if (referencePixelShouldBeMergedAndSet == Boolean.TRUE) {
                    PixelType lhsReferencePixel;
                    lhsReferencePixel = leftObject.getReferencePixel();
                    PixelType rhsReferencePixel;
                    rhsReferencePixel = rightObject.getReferencePixel();
                    PixelType mergedReferencePixel = ((PixelType) strategy.merge(LocatorUtils.property(leftLocator, "referencePixel", lhsReferencePixel), LocatorUtils.property(rightLocator, "referencePixel", rhsReferencePixel), lhsReferencePixel, rhsReferencePixel, (leftObject.referencePixel!= null), (rightObject.referencePixel!= null)));
                    target.setReferencePixel(mergedReferencePixel);
                } else {
                    if (referencePixelShouldBeMergedAndSet == Boolean.FALSE) {
                        target.referencePixel = null;
                    }
                }
            }
            {
                Boolean axis1OrderShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.axis1Order!= null), (rightObject.axis1Order!= null));
                if (axis1OrderShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsAxis1Order;
                    lhsAxis1Order = leftObject.getAxis1Order();
                    BigInteger rhsAxis1Order;
                    rhsAxis1Order = rightObject.getAxis1Order();
                    BigInteger mergedAxis1Order = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "axis1Order", lhsAxis1Order), LocatorUtils.property(rightLocator, "axis1Order", rhsAxis1Order), lhsAxis1Order, rhsAxis1Order, (leftObject.axis1Order!= null), (rightObject.axis1Order!= null)));
                    target.setAxis1Order(mergedAxis1Order);
                } else {
                    if (axis1OrderShouldBeMergedAndSet == Boolean.FALSE) {
                        target.axis1Order = null;
                    }
                }
            }
            {
                Boolean axis2OrderShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.axis2Order!= null), (rightObject.axis2Order!= null));
                if (axis2OrderShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsAxis2Order;
                    lhsAxis2Order = leftObject.getAxis2Order();
                    BigInteger rhsAxis2Order;
                    rhsAxis2Order = rightObject.getAxis2Order();
                    BigInteger mergedAxis2Order = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "axis2Order", lhsAxis2Order), LocatorUtils.property(rightLocator, "axis2Order", rhsAxis2Order), lhsAxis2Order, rhsAxis2Order, (leftObject.axis2Order!= null), (rightObject.axis2Order!= null)));
                    target.setAxis2Order(mergedAxis2Order);
                } else {
                    if (axis2OrderShouldBeMergedAndSet == Boolean.FALSE) {
                        target.axis2Order = null;
                    }
                }
            }
            {
                Boolean axis3OrderShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.axis3Order!= null), (rightObject.axis3Order!= null));
                if (axis3OrderShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsAxis3Order;
                    lhsAxis3Order = leftObject.getAxis3Order();
                    BigInteger rhsAxis3Order;
                    rhsAxis3Order = rightObject.getAxis3Order();
                    BigInteger mergedAxis3Order = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "axis3Order", lhsAxis3Order), LocatorUtils.property(rightLocator, "axis3Order", rhsAxis3Order), lhsAxis3Order, rhsAxis3Order, (leftObject.axis3Order!= null), (rightObject.axis3Order!= null)));
                    target.setAxis3Order(mergedAxis3Order);
                } else {
                    if (axis3OrderShouldBeMergedAndSet == Boolean.FALSE) {
                        target.axis3Order = null;
                    }
                }
            }
            {
                Boolean refFrameIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.refFrameId!= null), (rightObject.refFrameId!= null));
                if (refFrameIdShouldBeMergedAndSet == Boolean.TRUE) {
                    Object lhsRefFrameId;
                    lhsRefFrameId = leftObject.getRefFrameId();
                    Object rhsRefFrameId;
                    rhsRefFrameId = rightObject.getRefFrameId();
                    Object mergedRefFrameId = ((Object) strategy.merge(LocatorUtils.property(leftLocator, "refFrameId", lhsRefFrameId), LocatorUtils.property(rightLocator, "refFrameId", rhsRefFrameId), lhsRefFrameId, rhsRefFrameId, (leftObject.refFrameId!= null), (rightObject.refFrameId!= null)));
                    target.setRefFrameId(mergedRefFrameId);
                } else {
                    if (refFrameIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.refFrameId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new PixelFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType clone() {
        final PixelFrameType _newObject;
        _newObject = ((PixelFrameType) super.clone());
        _newObject.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType createCopy() {
        final PixelFrameType _newObject = ((PixelFrameType) super.createCopy());
        _newObject.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.createCopy());
        _newObject.axis1Order = this.axis1Order;
        _newObject.axis2Order = this.axis2Order;
        _newObject.axis3Order = this.axis3Order;
        _newObject.refFrameId = this.refFrameId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelFrameType _newObject = ((PixelFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree referencePixelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePixel"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePixelPropertyTree!= null):((referencePixelPropertyTree == null)||(!referencePixelPropertyTree.isLeaf())))) {
            _newObject.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.createCopy(referencePixelPropertyTree, _propertyTreeUse));
        }
        final PropertyTree axis1OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis1Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis1OrderPropertyTree!= null):((axis1OrderPropertyTree == null)||(!axis1OrderPropertyTree.isLeaf())))) {
            _newObject.axis1Order = this.axis1Order;
        }
        final PropertyTree axis2OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis2Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis2OrderPropertyTree!= null):((axis2OrderPropertyTree == null)||(!axis2OrderPropertyTree.isLeaf())))) {
            _newObject.axis2Order = this.axis2Order;
        }
        final PropertyTree axis3OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis3Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis3OrderPropertyTree!= null):((axis3OrderPropertyTree == null)||(!axis3OrderPropertyTree.isLeaf())))) {
            _newObject.axis3Order = this.axis3Order;
        }
        final PropertyTree refFrameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refFrameId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refFrameIdPropertyTree!= null):((refFrameIdPropertyTree == null)||(!refFrameIdPropertyTree.isLeaf())))) {
            _newObject.refFrameId = this.refFrameId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new PixelFrameType.Modifier();
        }
        return ((PixelFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final PixelFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.newCopyBuilder(_other));
        _other.axis1Order = this.axis1Order;
        _other.axis2Order = this.axis2Order;
        _other.axis3Order = this.axis3Order;
        _other.refFrameId = this.refFrameId;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >PixelFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new PixelFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> builder() {
        return new PixelFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final StcBaseType _other) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final CoordFrameType _other) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final GenericCoordFrameType _other) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final PixelFrameType _other) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final PixelFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree referencePixelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePixel"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePixelPropertyTree!= null):((referencePixelPropertyTree == null)||(!referencePixelPropertyTree.isLeaf())))) {
            _other.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.newCopyBuilder(_other, referencePixelPropertyTree, _propertyTreeUse));
        }
        final PropertyTree axis1OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis1Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis1OrderPropertyTree!= null):((axis1OrderPropertyTree == null)||(!axis1OrderPropertyTree.isLeaf())))) {
            _other.axis1Order = this.axis1Order;
        }
        final PropertyTree axis2OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis2Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis2OrderPropertyTree!= null):((axis2OrderPropertyTree == null)||(!axis2OrderPropertyTree.isLeaf())))) {
            _other.axis2Order = this.axis2Order;
        }
        final PropertyTree axis3OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis3Order"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis3OrderPropertyTree!= null):((axis3OrderPropertyTree == null)||(!axis3OrderPropertyTree.isLeaf())))) {
            _other.axis3Order = this.axis3Order;
        }
        final PropertyTree refFrameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refFrameId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refFrameIdPropertyTree!= null):((refFrameIdPropertyTree == null)||(!refFrameIdPropertyTree.isLeaf())))) {
            _other.refFrameId = this.refFrameId;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >PixelFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new PixelFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final CoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final GenericCoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >PixelFrameType.Builder<_B> copyOf(final PixelFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PixelFrameType.Builder<_B> _newBuilder = new PixelFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyExcept(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyExcept(final GenericCoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyExcept(final PixelFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyOnly(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyOnly(final GenericCoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static PixelFrameType.Builder<Void> copyOnly(final PixelFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PixelFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(PixelFrameType.PropInfo.REFERENCE_PIXEL, this))&&(this.referencePixel!= null)) {
            this.referencePixel.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(PixelFrameType.PropInfo.AXIS_1_ORDER, this));
        _visitor_.visit(new SingleProperty<>(PixelFrameType.PropInfo.AXIS_2_ORDER, this));
        _visitor_.visit(new SingleProperty<>(PixelFrameType.PropInfo.AXIS_3_ORDER, this));
        _visitor_.visit(new SingleProperty<>(PixelFrameType.PropInfo.REF_FRAME_ID, this));
        return this;
    }

    public static class Builder<_B >
        extends GenericCoordFrameType.Builder<_B>
        implements Buildable
    {

        private PixelType.Builder<PixelFrameType.Builder<_B>> referencePixel;
        private BigInteger axis1Order;
        private BigInteger axis2Order;
        private BigInteger axis3Order;
        private Object refFrameId;

        public Builder(final _B _parentBuilder, final PixelFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.referencePixel = ((_other.referencePixel == null)?null:_other.referencePixel.newCopyBuilder(this));
                this.axis1Order = _other.axis1Order;
                this.axis2Order = _other.axis2Order;
                this.axis3Order = _other.axis3Order;
                this.refFrameId = _other.refFrameId;
            }
        }

        public Builder(final _B _parentBuilder, final PixelFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree referencePixelPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePixel"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePixelPropertyTree!= null):((referencePixelPropertyTree == null)||(!referencePixelPropertyTree.isLeaf())))) {
                    this.referencePixel = ((_other.referencePixel == null)?null:_other.referencePixel.newCopyBuilder(this, referencePixelPropertyTree, _propertyTreeUse));
                }
                final PropertyTree axis1OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis1Order"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis1OrderPropertyTree!= null):((axis1OrderPropertyTree == null)||(!axis1OrderPropertyTree.isLeaf())))) {
                    this.axis1Order = _other.axis1Order;
                }
                final PropertyTree axis2OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis2Order"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis2OrderPropertyTree!= null):((axis2OrderPropertyTree == null)||(!axis2OrderPropertyTree.isLeaf())))) {
                    this.axis2Order = _other.axis2Order;
                }
                final PropertyTree axis3OrderPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("axis3Order"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(axis3OrderPropertyTree!= null):((axis3OrderPropertyTree == null)||(!axis3OrderPropertyTree.isLeaf())))) {
                    this.axis3Order = _other.axis3Order;
                }
                final PropertyTree refFrameIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refFrameId"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refFrameIdPropertyTree!= null):((refFrameIdPropertyTree == null)||(!refFrameIdPropertyTree.isLeaf())))) {
                    this.refFrameId = _other.refFrameId;
                }
            }
        }

        protected<_P extends PixelFrameType >_P init(final _P _product) {
            _product.referencePixel = ((this.referencePixel == null)?null:this.referencePixel.build());
            _product.axis1Order = this.axis1Order;
            _product.axis2Order = this.axis2Order;
            _product.axis3Order = this.axis3Order;
            _product.refFrameId = this.refFrameId;
            return super.init(_product);
        }

        /**
         * Sets the new value of "referencePixel" (any previous value will be replaced)
         * 
         * @param referencePixel
         *     New value of the "referencePixel" property.
         */
        public PixelFrameType.Builder<_B> withReferencePixel(final PixelType referencePixel) {
            this.referencePixel = ((referencePixel == null)?null:new PixelType.Builder<>(this, referencePixel, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "referencePixel" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.PixelType.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "referencePixel" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.PixelType.Builder#end()} to return
         *     to the current builder.
         */
        public PixelType.Builder<? extends PixelFrameType.Builder<_B>> withReferencePixel() {
            if (this.referencePixel!= null) {
                return this.referencePixel;
            }
            return this.referencePixel = new PixelType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "axis1Order" (any previous value will be replaced)
         * 
         * @param axis1Order
         *     New value of the "axis1Order" property.
         */
        public PixelFrameType.Builder<_B> withAxis1Order(final BigInteger axis1Order) {
            this.axis1Order = axis1Order;
            return this;
        }

        /**
         * Sets the new value of "axis2Order" (any previous value will be replaced)
         * 
         * @param axis2Order
         *     New value of the "axis2Order" property.
         */
        public PixelFrameType.Builder<_B> withAxis2Order(final BigInteger axis2Order) {
            this.axis2Order = axis2Order;
            return this;
        }

        /**
         * Sets the new value of "axis3Order" (any previous value will be replaced)
         * 
         * @param axis3Order
         *     New value of the "axis3Order" property.
         */
        public PixelFrameType.Builder<_B> withAxis3Order(final BigInteger axis3Order) {
            this.axis3Order = axis3Order;
            return this;
        }

        /**
         * Sets the new value of "refFrameId" (any previous value will be replaced)
         * 
         * @param refFrameId
         *     New value of the "refFrameId" property.
         */
        public PixelFrameType.Builder<_B> withRefFrameId(final Object refFrameId) {
            this.refFrameId = refFrameId;
            return this;
        }

        /**
         * Sets the new value of "coordRefFrame" (any previous value will be replaced)
         * 
         * @param coordRefFrame
         *     New value of the "coordRefFrame" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withCoordRefFrame(final JAXBElement<? extends CoordRefFrameType> coordRefFrame) {
            super.withCoordRefFrame(coordRefFrame);
            return this;
        }

        /**
         * Sets the new value of "coordRefPos" (any previous value will be replaced)
         * 
         * @param coordRefPos
         *     New value of the "coordRefPos" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withCoordRefPos(final CustomRefPosType coordRefPos) {
            super.withCoordRefPos(coordRefPos);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "coordRefPos" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.CustomRefPosType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "coordRefPos" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.CustomRefPosType.Builder#end()} to
         *     return to the current builder.
         */
        public CustomRefPosType.Builder<? extends PixelFrameType.Builder<_B>> withCoordRefPos() {
            return ((CustomRefPosType.Builder<? extends PixelFrameType.Builder<_B>> ) super.withCoordRefPos());
        }

        /**
         * Sets the new value of "coordFlavor" (any previous value will be replaced)
         * 
         * @param coordFlavor
         *     New value of the "coordFlavor" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withCoordFlavor(final JAXBElement<? extends CoordFlavorType> coordFlavor) {
            super.withCoordFlavor(coordFlavor);
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public PixelFrameType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public PixelFrameType build() {
            if (_storedValue == null) {
                return this.init(new PixelFrameType());
            } else {
                return ((PixelFrameType) _storedValue);
            }
        }

        public PixelFrameType.Builder<_B> copyOf(final PixelFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public PixelFrameType.Builder<_B> copyOf(final PixelFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends GenericCoordFrameType.Modifier
    {


        public void setReferencePixel(final PixelType referencePixel) {
            PixelFrameType.this.setReferencePixel(referencePixel);
        }

        public void setAxis1Order(final BigInteger axis1Order) {
            PixelFrameType.this.setAxis1Order(axis1Order);
        }

        public void setAxis2Order(final BigInteger axis2Order) {
            PixelFrameType.this.setAxis2Order(axis2Order);
        }

        public void setAxis3Order(final BigInteger axis3Order) {
            PixelFrameType.this.setAxis3Order(axis3Order);
        }

        public void setRefFrameId(final Object refFrameId) {
            PixelFrameType.this.setRefFrameId(refFrameId);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<PixelFrameType, PixelType> REFERENCE_PIXEL = new SinglePropertyInfo<PixelFrameType,PixelType>("referencePixel", PixelFrameType.class, PixelType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ReferencePixel"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "pixelType"), false) {


            @Override
            public PixelType get(final PixelFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.referencePixel);
            }

            @Override
            public void set(final PixelFrameType _instance_, final PixelType _value_) {
                if (_instance_!= null) {
                    _instance_.referencePixel = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PixelFrameType, BigInteger> AXIS_1_ORDER = new SinglePropertyInfo<PixelFrameType,BigInteger>("axis1Order", PixelFrameType.class, BigInteger.class, false, null, new QName("", "axis1_order"), new QName("http://www.w3.org/2001/XMLSchema", "integer"), true) {


            @Override
            public BigInteger get(final PixelFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.axis1Order);
            }

            @Override
            public void set(final PixelFrameType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.axis1Order = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PixelFrameType, BigInteger> AXIS_2_ORDER = new SinglePropertyInfo<PixelFrameType,BigInteger>("axis2Order", PixelFrameType.class, BigInteger.class, false, null, new QName("", "axis2_order"), new QName("http://www.w3.org/2001/XMLSchema", "integer"), true) {


            @Override
            public BigInteger get(final PixelFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.axis2Order);
            }

            @Override
            public void set(final PixelFrameType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.axis2Order = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PixelFrameType, BigInteger> AXIS_3_ORDER = new SinglePropertyInfo<PixelFrameType,BigInteger>("axis3Order", PixelFrameType.class, BigInteger.class, false, null, new QName("", "axis3_order"), new QName("http://www.w3.org/2001/XMLSchema", "integer"), true) {


            @Override
            public BigInteger get(final PixelFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.axis3Order);
            }

            @Override
            public void set(final PixelFrameType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.axis3Order = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PixelFrameType, Object> REF_FRAME_ID = new SinglePropertyInfo<PixelFrameType,Object>("refFrameId", PixelFrameType.class, Object.class, false, null, new QName("", "ref_frame_id"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true) {


            @Override
            public Object get(final PixelFrameType _instance_) {
                return ((_instance_ == null)?null:_instance_.refFrameId);
            }

            @Override
            public void set(final PixelFrameType _instance_, final Object _value_) {
                if (_instance_!= null) {
                    _instance_.refFrameId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends PixelFrameType.Selector<PixelFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static PixelFrameType.Select _root() {
            return new PixelFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends GenericCoordFrameType.Selector<TRoot, TParent>
    {

        private PixelType.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> referencePixel = null;
        private com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis1Order = null;
        private com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis2Order = null;
        private com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis3Order = null;
        private com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> refFrameId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.referencePixel!= null) {
                products.put("referencePixel", this.referencePixel.init());
            }
            if (this.axis1Order!= null) {
                products.put("axis1Order", this.axis1Order.init());
            }
            if (this.axis2Order!= null) {
                products.put("axis2Order", this.axis2Order.init());
            }
            if (this.axis3Order!= null) {
                products.put("axis3Order", this.axis3Order.init());
            }
            if (this.refFrameId!= null) {
                products.put("refFrameId", this.refFrameId.init());
            }
            return products;
        }

        public PixelType.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> referencePixel() {
            return ((this.referencePixel == null)?this.referencePixel = new PixelType.Selector<>(this._root, this, "referencePixel"):this.referencePixel);
        }

        public com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis1Order() {
            return ((this.axis1Order == null)?this.axis1Order = new com.kscs.util.jaxb.Selector<>(this._root, this, "axis1Order"):this.axis1Order);
        }

        public com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis2Order() {
            return ((this.axis2Order == null)?this.axis2Order = new com.kscs.util.jaxb.Selector<>(this._root, this, "axis2Order"):this.axis2Order);
        }

        public com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> axis3Order() {
            return ((this.axis3Order == null)?this.axis3Order = new com.kscs.util.jaxb.Selector<>(this._root, this, "axis3Order"):this.axis3Order);
        }

        public com.kscs.util.jaxb.Selector<TRoot, PixelFrameType.Selector<TRoot, TParent>> refFrameId() {
            return ((this.refFrameId == null)?this.refFrameId = new com.kscs.util.jaxb.Selector<>(this._root, this, "refFrameId"):this.refFrameId);
        }

    }

}
