
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Type for STC Coordinate
 * 
 * <p>Java class for STCCoordinate complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="STCCoordinate">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcMetadataType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AstroCoordSystem"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}AstroCoords"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "STCCoordinate", propOrder = {
    "astroCoordSystem",
    "astroCoords"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class STCCoordinate
    extends StcMetadataType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     */
    @XmlElement(name = "AstroCoordSystem", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected AstroCoordSystemType astroCoordSystem;
    /**
     * The coordinate element consists either of a coordinate file or a sequence of time element, spatial coordinate element, velocity element, and redshift element; the spatial and velocity elements may be scalar or vector; it needs to refer to a coordinate system
     * 
     */
    @XmlElement(name = "AstroCoords", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected AstroCoordsType astroCoords;

    /**
     * Default no-arg constructor
     * 
     */
    public STCCoordinate() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public STCCoordinate(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final AstroCoordSystemType astroCoordSystem, final AstroCoordsType astroCoords) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.astroCoordSystem = astroCoordSystem;
        this.astroCoords = astroCoords;
    }

    /**
     * The coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; the spectral fromae and redshift/Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordSystemType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstroCoordSystemType getAstroCoordSystem() {
        return astroCoordSystem;
    }

    /**
     * Sets the value of the astroCoordSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordSystemType }
     *     
     * @see #getAstroCoordSystem()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAstroCoordSystem(AstroCoordSystemType value) {
        this.astroCoordSystem = value;
    }

    /**
     * The coordinate element consists either of a coordinate file or a sequence of time element, spatial coordinate element, velocity element, and redshift element; the spatial and velocity elements may be scalar or vector; it needs to refer to a coordinate system
     * 
     * @return
     *     possible object is
     *     {@link AstroCoordsType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public AstroCoordsType getAstroCoords() {
        return astroCoords;
    }

    /**
     * Sets the value of the astroCoords property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroCoordsType }
     *     
     * @see #getAstroCoords()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setAstroCoords(AstroCoordsType value) {
        this.astroCoords = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final STCCoordinate that = ((STCCoordinate) object);
        {
            AstroCoordSystemType leftAstroCoordSystem;
            leftAstroCoordSystem = this.getAstroCoordSystem();
            AstroCoordSystemType rightAstroCoordSystem;
            rightAstroCoordSystem = that.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                if (that.astroCoordSystem!= null) {
                    if (!leftAstroCoordSystem.equals(rightAstroCoordSystem)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.astroCoordSystem!= null) {
                    return false;
                }
            }
        }
        {
            AstroCoordsType leftAstroCoords;
            leftAstroCoords = this.getAstroCoords();
            AstroCoordsType rightAstroCoords;
            rightAstroCoords = that.getAstroCoords();
            if (this.astroCoords!= null) {
                if (that.astroCoords!= null) {
                    if (!leftAstroCoords.equals(rightAstroCoords)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.astroCoords!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            if (this.astroCoordSystem!= null) {
                currentHashCode += theAstroCoordSystem.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AstroCoordsType theAstroCoords;
            theAstroCoords = this.getAstroCoords();
            if (this.astroCoords!= null) {
                currentHashCode += theAstroCoords.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            AstroCoordSystemType theAstroCoordSystem;
            theAstroCoordSystem = this.getAstroCoordSystem();
            strategy.appendField(locator, this, "astroCoordSystem", buffer, theAstroCoordSystem, (this.astroCoordSystem!= null));
        }
        {
            AstroCoordsType theAstroCoords;
            theAstroCoords = this.getAstroCoords();
            strategy.appendField(locator, this, "astroCoords", buffer, theAstroCoords, (this.astroCoords!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof STCCoordinate) {
            final STCCoordinate target = this;
            final STCCoordinate leftObject = ((STCCoordinate) left);
            final STCCoordinate rightObject = ((STCCoordinate) right);
            {
                Boolean astroCoordSystemShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null));
                if (astroCoordSystemShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordSystemType lhsAstroCoordSystem;
                    lhsAstroCoordSystem = leftObject.getAstroCoordSystem();
                    AstroCoordSystemType rhsAstroCoordSystem;
                    rhsAstroCoordSystem = rightObject.getAstroCoordSystem();
                    AstroCoordSystemType mergedAstroCoordSystem = ((AstroCoordSystemType) strategy.merge(LocatorUtils.property(leftLocator, "astroCoordSystem", lhsAstroCoordSystem), LocatorUtils.property(rightLocator, "astroCoordSystem", rhsAstroCoordSystem), lhsAstroCoordSystem, rhsAstroCoordSystem, (leftObject.astroCoordSystem!= null), (rightObject.astroCoordSystem!= null)));
                    target.setAstroCoordSystem(mergedAstroCoordSystem);
                } else {
                    if (astroCoordSystemShouldBeMergedAndSet == Boolean.FALSE) {
                        target.astroCoordSystem = null;
                    }
                }
            }
            {
                Boolean astroCoordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.astroCoords!= null), (rightObject.astroCoords!= null));
                if (astroCoordsShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroCoordsType lhsAstroCoords;
                    lhsAstroCoords = leftObject.getAstroCoords();
                    AstroCoordsType rhsAstroCoords;
                    rhsAstroCoords = rightObject.getAstroCoords();
                    AstroCoordsType mergedAstroCoords = ((AstroCoordsType) strategy.merge(LocatorUtils.property(leftLocator, "astroCoords", lhsAstroCoords), LocatorUtils.property(rightLocator, "astroCoords", rhsAstroCoords), lhsAstroCoords, rhsAstroCoords, (leftObject.astroCoords!= null), (rightObject.astroCoords!= null)));
                    target.setAstroCoords(mergedAstroCoords);
                } else {
                    if (astroCoordsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.astroCoords = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new STCCoordinate();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate clone() {
        final STCCoordinate _newObject;
        _newObject = ((STCCoordinate) super.clone());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.clone());
        _newObject.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate createCopy() {
        final STCCoordinate _newObject = ((STCCoordinate) super.createCopy());
        _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy());
        _newObject.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinate _newObject = ((STCCoordinate) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _newObject.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.createCopy(astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
            _newObject.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.createCopy(astroCoordsPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new STCCoordinate.Modifier();
        }
        return ((STCCoordinate.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final STCCoordinate.Builder<_B> _other) {
        super.copyTo(_other);
        _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other));
        _other.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >STCCoordinate.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new STCCoordinate.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> builder() {
        return new STCCoordinate.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final StcBaseType _other) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final StcMetadataType _other) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final STCCoordinate _other) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final STCCoordinate.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
            _other.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.newCopyBuilder(_other, astroCoordSystemPropertyTree, _propertyTreeUse));
        }
        final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
            _other.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.newCopyBuilder(_other, astroCoordsPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >STCCoordinate.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new STCCoordinate.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final StcMetadataType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >STCCoordinate.Builder<_B> copyOf(final STCCoordinate _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final STCCoordinate.Builder<_B> _newBuilder = new STCCoordinate.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyExcept(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyExcept(final STCCoordinate _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyOnly(final StcMetadataType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static STCCoordinate.Builder<Void> copyOnly(final STCCoordinate _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public STCCoordinate visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(STCCoordinate.PropInfo.ASTRO_COORD_SYSTEM, this))&&(this.astroCoordSystem!= null)) {
            this.astroCoordSystem.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(STCCoordinate.PropInfo.ASTRO_COORDS, this))&&(this.astroCoords!= null)) {
            this.astroCoords.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends StcMetadataType.Builder<_B>
        implements Buildable
    {

        private AstroCoordSystemType.Builder<STCCoordinate.Builder<_B>> astroCoordSystem;
        private AstroCoordsType.Builder<STCCoordinate.Builder<_B>> astroCoords;

        public Builder(final _B _parentBuilder, final STCCoordinate _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this));
                this.astroCoords = ((_other.astroCoords == null)?null:_other.astroCoords.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final STCCoordinate _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree astroCoordSystemPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoordSystem"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordSystemPropertyTree!= null):((astroCoordSystemPropertyTree == null)||(!astroCoordSystemPropertyTree.isLeaf())))) {
                    this.astroCoordSystem = ((_other.astroCoordSystem == null)?null:_other.astroCoordSystem.newCopyBuilder(this, astroCoordSystemPropertyTree, _propertyTreeUse));
                }
                final PropertyTree astroCoordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("astroCoords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(astroCoordsPropertyTree!= null):((astroCoordsPropertyTree == null)||(!astroCoordsPropertyTree.isLeaf())))) {
                    this.astroCoords = ((_other.astroCoords == null)?null:_other.astroCoords.newCopyBuilder(this, astroCoordsPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends STCCoordinate >_P init(final _P _product) {
            _product.astroCoordSystem = ((this.astroCoordSystem == null)?null:this.astroCoordSystem.build());
            _product.astroCoords = ((this.astroCoords == null)?null:this.astroCoords.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "astroCoordSystem" (any previous value will be replaced)
         * 
         * @param astroCoordSystem
         *     New value of the "astroCoordSystem" property.
         */
        public STCCoordinate.Builder<_B> withAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            this.astroCoordSystem = ((astroCoordSystem == null)?null:new AstroCoordSystemType.Builder<>(this, astroCoordSystem, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "astroCoordSystem" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "astroCoordSystem" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordSystemType.Builder#end()}
         *     to return to the current builder.
         */
        public AstroCoordSystemType.Builder<? extends STCCoordinate.Builder<_B>> withAstroCoordSystem() {
            if (this.astroCoordSystem!= null) {
                return this.astroCoordSystem;
            }
            return this.astroCoordSystem = new AstroCoordSystemType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "astroCoords" (any previous value will be replaced)
         * 
         * @param astroCoords
         *     New value of the "astroCoords" property.
         */
        public STCCoordinate.Builder<_B> withAstroCoords(final AstroCoordsType astroCoords) {
            this.astroCoords = ((astroCoords == null)?null:new AstroCoordsType.Builder<>(this, astroCoords, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "astroCoords" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "astroCoords" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.AstroCoordsType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroCoordsType.Builder<? extends STCCoordinate.Builder<_B>> withAstroCoords() {
            if (this.astroCoords!= null) {
                return this.astroCoords;
            }
            return this.astroCoords = new AstroCoordsType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public STCCoordinate.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public STCCoordinate build() {
            if (_storedValue == null) {
                return this.init(new STCCoordinate());
            } else {
                return ((STCCoordinate) _storedValue);
            }
        }

        public STCCoordinate.Builder<_B> copyOf(final STCCoordinate _other) {
            _other.copyTo(this);
            return this;
        }

        public STCCoordinate.Builder<_B> copyOf(final STCCoordinate.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcMetadataType.Modifier
    {


        public void setAstroCoordSystem(final AstroCoordSystemType astroCoordSystem) {
            STCCoordinate.this.setAstroCoordSystem(astroCoordSystem);
        }

        public void setAstroCoords(final AstroCoordsType astroCoords) {
            STCCoordinate.this.setAstroCoords(astroCoords);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<STCCoordinate, AstroCoordSystemType> ASTRO_COORD_SYSTEM = new SinglePropertyInfo<STCCoordinate,AstroCoordSystemType>("astroCoordSystem", STCCoordinate.class, AstroCoordSystemType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AstroCoordSystem"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordSystemType"), false) {


            @Override
            public AstroCoordSystemType get(final STCCoordinate _instance_) {
                return ((_instance_ == null)?null:_instance_.astroCoordSystem);
            }

            @Override
            public void set(final STCCoordinate _instance_, final AstroCoordSystemType _value_) {
                if (_instance_!= null) {
                    _instance_.astroCoordSystem = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<STCCoordinate, AstroCoordsType> ASTRO_COORDS = new SinglePropertyInfo<STCCoordinate,AstroCoordsType>("astroCoords", STCCoordinate.class, AstroCoordsType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "AstroCoords"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroCoordsType"), false) {


            @Override
            public AstroCoordsType get(final STCCoordinate _instance_) {
                return ((_instance_ == null)?null:_instance_.astroCoords);
            }

            @Override
            public void set(final STCCoordinate _instance_, final AstroCoordsType _value_) {
                if (_instance_!= null) {
                    _instance_.astroCoords = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends STCCoordinate.Selector<STCCoordinate.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static STCCoordinate.Select _root() {
            return new STCCoordinate.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcMetadataType.Selector<TRoot, TParent>
    {

        private AstroCoordSystemType.Selector<TRoot, STCCoordinate.Selector<TRoot, TParent>> astroCoordSystem = null;
        private AstroCoordsType.Selector<TRoot, STCCoordinate.Selector<TRoot, TParent>> astroCoords = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.astroCoordSystem!= null) {
                products.put("astroCoordSystem", this.astroCoordSystem.init());
            }
            if (this.astroCoords!= null) {
                products.put("astroCoords", this.astroCoords.init());
            }
            return products;
        }

        public AstroCoordSystemType.Selector<TRoot, STCCoordinate.Selector<TRoot, TParent>> astroCoordSystem() {
            return ((this.astroCoordSystem == null)?this.astroCoordSystem = new AstroCoordSystemType.Selector<>(this._root, this, "astroCoordSystem"):this.astroCoordSystem);
        }

        public AstroCoordsType.Selector<TRoot, STCCoordinate.Selector<TRoot, TParent>> astroCoords() {
            return ((this.astroCoords == null)?this.astroCoords = new AstroCoordsType.Selector<>(this._root, this, "astroCoords"):this.astroCoords);
        }

    }

}
