
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A sector is the counter-clockwise area between two half-lines
 * 
 * <p>Java class for sectorType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="sectorType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Position" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double2Type"/>
 *         <element name="PosAngle1" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}posAngleType"/>
 *         <element name="PosAngle2" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}posAngleType"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "sectorType", propOrder = {
    "position",
    "posAngle1",
    "posAngle2"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class SectorType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The vertex position of the sector
     * 
     */
    @XmlElement(name = "Position", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Double2Type position;
    /**
     * The area ccw from this position angle is included
     * 
     */
    @XmlElement(name = "PosAngle1", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected PosAngleType posAngle1;
    /**
     * The area cw from this position angle is included
     * 
     */
    @XmlElement(name = "PosAngle2", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected PosAngleType posAngle2;

    /**
     * Default no-arg constructor
     * 
     */
    public SectorType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SectorType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final Double2Type position, final PosAngleType posAngle1, final PosAngleType posAngle2) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.position = position;
        this.posAngle1 = posAngle1;
        this.posAngle2 = posAngle2;
    }

    /**
     * The vertex position of the sector
     * 
     * @return
     *     possible object is
     *     {@link Double2Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Double2Type getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double2Type }
     *     
     * @see #getPosition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setPosition(Double2Type value) {
        this.position = value;
    }

    /**
     * The area ccw from this position angle is included
     * 
     * @return
     *     possible object is
     *     {@link PosAngleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PosAngleType getPosAngle1() {
        return posAngle1;
    }

    /**
     * Sets the value of the posAngle1 property.
     * 
     * @param value
     *     allowed object is
     *     {@link PosAngleType }
     *     
     * @see #getPosAngle1()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setPosAngle1(PosAngleType value) {
        this.posAngle1 = value;
    }

    /**
     * The area cw from this position angle is included
     * 
     * @return
     *     possible object is
     *     {@link PosAngleType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public PosAngleType getPosAngle2() {
        return posAngle2;
    }

    /**
     * Sets the value of the posAngle2 property.
     * 
     * @param value
     *     allowed object is
     *     {@link PosAngleType }
     *     
     * @see #getPosAngle2()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setPosAngle2(PosAngleType value) {
        this.posAngle2 = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SectorType that = ((SectorType) object);
        {
            Double2Type leftPosition;
            leftPosition = this.getPosition();
            Double2Type rightPosition;
            rightPosition = that.getPosition();
            if (this.position!= null) {
                if (that.position!= null) {
                    if (!leftPosition.equals(rightPosition)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.position!= null) {
                    return false;
                }
            }
        }
        {
            PosAngleType leftPosAngle1;
            leftPosAngle1 = this.getPosAngle1();
            PosAngleType rightPosAngle1;
            rightPosAngle1 = that.getPosAngle1();
            if (this.posAngle1 != null) {
                if (that.posAngle1 != null) {
                    if (!leftPosAngle1 .equals(rightPosAngle1)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.posAngle1 != null) {
                    return false;
                }
            }
        }
        {
            PosAngleType leftPosAngle2;
            leftPosAngle2 = this.getPosAngle2();
            PosAngleType rightPosAngle2;
            rightPosAngle2 = that.getPosAngle2();
            if (this.posAngle2 != null) {
                if (that.posAngle2 != null) {
                    if (!leftPosAngle2 .equals(rightPosAngle2)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.posAngle2 != null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double2Type thePosition;
            thePosition = this.getPosition();
            if (this.position!= null) {
                currentHashCode += thePosition.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            PosAngleType thePosAngle1;
            thePosAngle1 = this.getPosAngle1();
            if (this.posAngle1 != null) {
                currentHashCode += thePosAngle1 .hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            PosAngleType thePosAngle2;
            thePosAngle2 = this.getPosAngle2();
            if (this.posAngle2 != null) {
                currentHashCode += thePosAngle2 .hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double2Type thePosition;
            thePosition = this.getPosition();
            strategy.appendField(locator, this, "position", buffer, thePosition, (this.position!= null));
        }
        {
            PosAngleType thePosAngle1;
            thePosAngle1 = this.getPosAngle1();
            strategy.appendField(locator, this, "posAngle1", buffer, thePosAngle1, (this.posAngle1 != null));
        }
        {
            PosAngleType thePosAngle2;
            thePosAngle2 = this.getPosAngle2();
            strategy.appendField(locator, this, "posAngle2", buffer, thePosAngle2, (this.posAngle2 != null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SectorType) {
            final SectorType target = this;
            final SectorType leftObject = ((SectorType) left);
            final SectorType rightObject = ((SectorType) right);
            {
                Boolean positionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.position!= null), (rightObject.position!= null));
                if (positionShouldBeMergedAndSet == Boolean.TRUE) {
                    Double2Type lhsPosition;
                    lhsPosition = leftObject.getPosition();
                    Double2Type rhsPosition;
                    rhsPosition = rightObject.getPosition();
                    Double2Type mergedPosition = ((Double2Type) strategy.merge(LocatorUtils.property(leftLocator, "position", lhsPosition), LocatorUtils.property(rightLocator, "position", rhsPosition), lhsPosition, rhsPosition, (leftObject.position!= null), (rightObject.position!= null)));
                    target.setPosition(mergedPosition);
                } else {
                    if (positionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.position = null;
                    }
                }
            }
            {
                Boolean posAngle1ShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.posAngle1 != null), (rightObject.posAngle1 != null));
                if (posAngle1ShouldBeMergedAndSet == Boolean.TRUE) {
                    PosAngleType lhsPosAngle1;
                    lhsPosAngle1 = leftObject.getPosAngle1();
                    PosAngleType rhsPosAngle1;
                    rhsPosAngle1 = rightObject.getPosAngle1();
                    PosAngleType mergedPosAngle1 = ((PosAngleType) strategy.merge(LocatorUtils.property(leftLocator, "posAngle1", lhsPosAngle1), LocatorUtils.property(rightLocator, "posAngle1", rhsPosAngle1), lhsPosAngle1, rhsPosAngle1, (leftObject.posAngle1 != null), (rightObject.posAngle1 != null)));
                    target.setPosAngle1(mergedPosAngle1);
                } else {
                    if (posAngle1ShouldBeMergedAndSet == Boolean.FALSE) {
                        target.posAngle1 = null;
                    }
                }
            }
            {
                Boolean posAngle2ShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.posAngle2 != null), (rightObject.posAngle2 != null));
                if (posAngle2ShouldBeMergedAndSet == Boolean.TRUE) {
                    PosAngleType lhsPosAngle2;
                    lhsPosAngle2 = leftObject.getPosAngle2();
                    PosAngleType rhsPosAngle2;
                    rhsPosAngle2 = rightObject.getPosAngle2();
                    PosAngleType mergedPosAngle2 = ((PosAngleType) strategy.merge(LocatorUtils.property(leftLocator, "posAngle2", lhsPosAngle2), LocatorUtils.property(rightLocator, "posAngle2", rhsPosAngle2), lhsPosAngle2, rhsPosAngle2, (leftObject.posAngle2 != null), (rightObject.posAngle2 != null)));
                    target.setPosAngle2(mergedPosAngle2);
                } else {
                    if (posAngle2ShouldBeMergedAndSet == Boolean.FALSE) {
                        target.posAngle2 = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new SectorType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType clone() {
        final SectorType _newObject;
        _newObject = ((SectorType) super.clone());
        _newObject.position = ((this.position == null)?null:this.position.clone());
        _newObject.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .clone());
        _newObject.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType createCopy() {
        final SectorType _newObject = ((SectorType) super.createCopy());
        _newObject.position = ((this.position == null)?null:this.position.createCopy());
        _newObject.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .createCopy());
        _newObject.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType _newObject = ((SectorType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree positionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("position"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionPropertyTree!= null):((positionPropertyTree == null)||(!positionPropertyTree.isLeaf())))) {
            _newObject.position = ((this.position == null)?null:this.position.createCopy(positionPropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAngle1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle1"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle1PropertyTree!= null):((posAngle1PropertyTree == null)||(!posAngle1PropertyTree.isLeaf())))) {
            _newObject.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .createCopy(posAngle1PropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAngle2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle2"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle2PropertyTree!= null):((posAngle2PropertyTree == null)||(!posAngle2PropertyTree.isLeaf())))) {
            _newObject.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .createCopy(posAngle2PropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SectorType.Modifier();
        }
        return ((SectorType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SectorType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.position = ((this.position == null)?null:this.position.newCopyBuilder(_other));
        _other.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .newCopyBuilder(_other));
        _other.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SectorType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SectorType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> builder() {
        return new SectorType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final StcBaseType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final RegionType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final ShapeType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final SectorType _other) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SectorType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree positionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("position"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionPropertyTree!= null):((positionPropertyTree == null)||(!positionPropertyTree.isLeaf())))) {
            _other.position = ((this.position == null)?null:this.position.newCopyBuilder(_other, positionPropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAngle1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle1"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle1PropertyTree!= null):((posAngle1PropertyTree == null)||(!posAngle1PropertyTree.isLeaf())))) {
            _other.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .newCopyBuilder(_other, posAngle1PropertyTree, _propertyTreeUse));
        }
        final PropertyTree posAngle2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle2"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle2PropertyTree!= null):((posAngle2PropertyTree == null)||(!posAngle2PropertyTree.isLeaf())))) {
            _other.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .newCopyBuilder(_other, posAngle2PropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SectorType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SectorType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SectorType.Builder<_B> copyOf(final SectorType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SectorType.Builder<_B> _newBuilder = new SectorType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyExcept(final SectorType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SectorType.Builder<Void> copyOnly(final SectorType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SectorType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(SectorType.PropInfo.POSITION, this))&&(this.position!= null)) {
            this.position.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SectorType.PropInfo.POS_ANGLE_1, this))&&(this.posAngle1 != null)) {
            this.posAngle1 .visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SectorType.PropInfo.POS_ANGLE_2, this))&&(this.posAngle2 != null)) {
            this.posAngle2 .visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private Double2Type.Builder<SectorType.Builder<_B>> position;
        private PosAngleType.Builder<SectorType.Builder<_B>> posAngle1;
        private PosAngleType.Builder<SectorType.Builder<_B>> posAngle2;

        public Builder(final _B _parentBuilder, final SectorType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.position = ((_other.position == null)?null:_other.position.newCopyBuilder(this));
                this.posAngle1 = ((_other.posAngle1 == null)?null:_other.posAngle1 .newCopyBuilder(this));
                this.posAngle2 = ((_other.posAngle2 == null)?null:_other.posAngle2 .newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final SectorType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree positionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("position"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionPropertyTree!= null):((positionPropertyTree == null)||(!positionPropertyTree.isLeaf())))) {
                    this.position = ((_other.position == null)?null:_other.position.newCopyBuilder(this, positionPropertyTree, _propertyTreeUse));
                }
                final PropertyTree posAngle1PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle1"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle1PropertyTree!= null):((posAngle1PropertyTree == null)||(!posAngle1PropertyTree.isLeaf())))) {
                    this.posAngle1 = ((_other.posAngle1 == null)?null:_other.posAngle1 .newCopyBuilder(this, posAngle1PropertyTree, _propertyTreeUse));
                }
                final PropertyTree posAngle2PropertyTree = ((_propertyTree == null)?null:_propertyTree.get("posAngle2"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posAngle2PropertyTree!= null):((posAngle2PropertyTree == null)||(!posAngle2PropertyTree.isLeaf())))) {
                    this.posAngle2 = ((_other.posAngle2 == null)?null:_other.posAngle2 .newCopyBuilder(this, posAngle2PropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends SectorType >_P init(final _P _product) {
            _product.position = ((this.position == null)?null:this.position.build());
            _product.posAngle1 = ((this.posAngle1 == null)?null:this.posAngle1 .build());
            _product.posAngle2 = ((this.posAngle2 == null)?null:this.posAngle2 .build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "position" (any previous value will be replaced)
         * 
         * @param position
         *     New value of the "position" property.
         */
        public SectorType.Builder<_B> withPosition(final Double2Type position) {
            this.position = ((position == null)?null:new Double2Type.Builder<>(this, position, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "position" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "position" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double2Type.Builder<? extends SectorType.Builder<_B>> withPosition() {
            if (this.position!= null) {
                return this.position;
            }
            return this.position = new Double2Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "posAngle1" (any previous value will be replaced)
         * 
         * @param posAngle1
         *     New value of the "posAngle1" property.
         */
        public SectorType.Builder<_B> withPosAngle1(final PosAngleType posAngle1) {
            this.posAngle1 = ((posAngle1 == null)?null:new PosAngleType.Builder<>(this, posAngle1, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "posAngle1" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "posAngle1" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         *     return to the current builder.
         */
        public PosAngleType.Builder<? extends SectorType.Builder<_B>> withPosAngle1() {
            if (this.posAngle1 != null) {
                return this.posAngle1;
            }
            return this.posAngle1 = new PosAngleType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "posAngle2" (any previous value will be replaced)
         * 
         * @param posAngle2
         *     New value of the "posAngle2" property.
         */
        public SectorType.Builder<_B> withPosAngle2(final PosAngleType posAngle2) {
            this.posAngle2 = ((posAngle2 == null)?null:new PosAngleType.Builder<>(this, posAngle2, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "posAngle2" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "posAngle2" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.PosAngleType.Builder#end()} to
         *     return to the current builder.
         */
        public PosAngleType.Builder<? extends SectorType.Builder<_B>> withPosAngle2() {
            if (this.posAngle2 != null) {
                return this.posAngle2;
            }
            return this.posAngle2 = new PosAngleType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public SectorType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends SectorType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends SectorType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public SectorType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public SectorType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public SectorType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public SectorType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public SectorType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public SectorType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public SectorType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public SectorType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public SectorType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public SectorType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public SectorType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public SectorType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public SectorType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public SectorType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public SectorType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public SectorType build() {
            if (_storedValue == null) {
                return this.init(new SectorType());
            } else {
                return ((SectorType) _storedValue);
            }
        }

        public SectorType.Builder<_B> copyOf(final SectorType _other) {
            _other.copyTo(this);
            return this;
        }

        public SectorType.Builder<_B> copyOf(final SectorType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public void setPosition(final Double2Type position) {
            SectorType.this.setPosition(position);
        }

        public void setPosAngle1(final PosAngleType posAngle1) {
            SectorType.this.setPosAngle1(posAngle1);
        }

        public void setPosAngle2(final PosAngleType posAngle2) {
            SectorType.this.setPosAngle2(posAngle2);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SectorType, Double2Type> POSITION = new SinglePropertyInfo<SectorType,Double2Type>("position", SectorType.class, Double2Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Position"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double2Type"), false) {


            @Override
            public Double2Type get(final SectorType _instance_) {
                return ((_instance_ == null)?null:_instance_.position);
            }

            @Override
            public void set(final SectorType _instance_, final Double2Type _value_) {
                if (_instance_!= null) {
                    _instance_.position = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SectorType, PosAngleType> POS_ANGLE_1 = new SinglePropertyInfo<SectorType,PosAngleType>("posAngle1", SectorType.class, PosAngleType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PosAngle1"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posAngleType"), false) {


            @Override
            public PosAngleType get(final SectorType _instance_) {
                return ((_instance_ == null)?null:_instance_.posAngle1);
            }

            @Override
            public void set(final SectorType _instance_, final PosAngleType _value_) {
                if (_instance_!= null) {
                    _instance_.posAngle1 = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SectorType, PosAngleType> POS_ANGLE_2 = new SinglePropertyInfo<SectorType,PosAngleType>("posAngle2", SectorType.class, PosAngleType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PosAngle2"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posAngleType"), false) {


            @Override
            public PosAngleType get(final SectorType _instance_) {
                return ((_instance_ == null)?null:_instance_.posAngle2);
            }

            @Override
            public void set(final SectorType _instance_, final PosAngleType _value_) {
                if (_instance_!= null) {
                    _instance_.posAngle2 = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SectorType.Selector<SectorType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SectorType.Select _root() {
            return new SectorType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private Double2Type.Selector<TRoot, SectorType.Selector<TRoot, TParent>> position = null;
        private PosAngleType.Selector<TRoot, SectorType.Selector<TRoot, TParent>> posAngle1 = null;
        private PosAngleType.Selector<TRoot, SectorType.Selector<TRoot, TParent>> posAngle2 = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.position!= null) {
                products.put("position", this.position.init());
            }
            if (this.posAngle1 != null) {
                products.put("posAngle1", this.posAngle1 .init());
            }
            if (this.posAngle2 != null) {
                products.put("posAngle2", this.posAngle2 .init());
            }
            return products;
        }

        public Double2Type.Selector<TRoot, SectorType.Selector<TRoot, TParent>> position() {
            return ((this.position == null)?this.position = new Double2Type.Selector<>(this._root, this, "position"):this.position);
        }

        public PosAngleType.Selector<TRoot, SectorType.Selector<TRoot, TParent>> posAngle1() {
            return ((this.posAngle1 == null)?this.posAngle1 = new PosAngleType.Selector<>(this._root, this, "posAngle1"):this.posAngle1);
        }

        public PosAngleType.Selector<TRoot, SectorType.Selector<TRoot, TParent>> posAngle2() {
            return ((this.posAngle2 == null)?this.posAngle2 = new PosAngleType.Selector<>(this._root, this, "posAngle2"):this.posAngle2);
        }

    }

}
