
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Contains the spectral frame reference position
 * 
 * <p>Java class for spectralFrameType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="spectralFrameType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordFrameType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}ReferencePosition"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "spectralFrameType", propOrder = {
    "referencePosition"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class SpectralFrameType
    extends CoordFrameType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The reference frame for the spectral scale; note presence of LSR
     * 
     */
    @XmlElementRef(name = "ReferencePosition", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected JAXBElement<? extends ReferencePositionType> referencePosition;

    /**
     * Default no-arg constructor
     * 
     */
    public SpectralFrameType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SpectralFrameType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final String name, final JAXBElement<? extends ReferencePositionType> referencePosition) {
        super(id, idref, ucd, type, href, idType, idrefType, name);
        this.referencePosition = referencePosition;
    }

    /**
     * The reference frame for the spectral scale; note presence of LSR
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public JAXBElement<? extends ReferencePositionType> getReferencePosition() {
        return referencePosition;
    }

    /**
     * Sets the value of the referencePosition property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link CustomRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ReferencePositionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     {@link JAXBElement }{@code <}{@link StdRefPosType }{@code >}
     *     
     * @see #getReferencePosition()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setReferencePosition(JAXBElement<? extends ReferencePositionType> value) {
        this.referencePosition = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SpectralFrameType that = ((SpectralFrameType) object);
        {
            JAXBElement<? extends ReferencePositionType> leftReferencePosition;
            leftReferencePosition = this.getReferencePosition();
            JAXBElement<? extends ReferencePositionType> rightReferencePosition;
            rightReferencePosition = that.getReferencePosition();
            if (this.referencePosition!= null) {
                if (that.referencePosition!= null) {
                    {
                        final QName leftReferencePositionName = leftReferencePosition.getName();
                        final QName rightReferencePositionName = rightReferencePosition.getName();
                        if (leftReferencePositionName!= null) {
                            if (rightReferencePositionName!= null) {
                                if (!leftReferencePositionName.equals(rightReferencePositionName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final ReferencePositionType leftReferencePositionValue = leftReferencePosition.getValue();
                        final ReferencePositionType rightReferencePositionValue = rightReferencePosition.getValue();
                        if (leftReferencePositionValue!= null) {
                            if (rightReferencePositionValue!= null) {
                                if (!leftReferencePositionValue.equals(rightReferencePositionValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends ReferencePositionType> leftReferencePositionDeclaredType = leftReferencePosition.getDeclaredType();
                        final Class<? extends ReferencePositionType> rightReferencePositionDeclaredType = rightReferencePosition.getDeclaredType();
                        if (leftReferencePositionDeclaredType!= null) {
                            if (rightReferencePositionDeclaredType!= null) {
                                if (!leftReferencePositionDeclaredType.equals(rightReferencePositionDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftReferencePositionScope = leftReferencePosition.getScope();
                        final Class<?> rightReferencePositionScope = rightReferencePosition.getScope();
                        if (leftReferencePositionScope!= null) {
                            if (rightReferencePositionScope!= null) {
                                if (!leftReferencePositionScope.equals(rightReferencePositionScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightReferencePositionScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftReferencePositionNil = leftReferencePosition.isNil();
                        final boolean rightReferencePositionNil = rightReferencePosition.isNil();
                        if (leftReferencePositionNil!= rightReferencePositionNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.referencePosition!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            if (this.referencePosition!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName theReferencePositionName = theReferencePosition.getName();
                    if (theReferencePositionName!= null) {
                        currentHashCode += theReferencePositionName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final ReferencePositionType theReferencePositionValue = theReferencePosition.getValue();
                    if (theReferencePositionValue!= null) {
                        currentHashCode += theReferencePositionValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends ReferencePositionType> theReferencePositionDeclaredType = theReferencePosition.getDeclaredType();
                    if (theReferencePositionDeclaredType!= null) {
                        currentHashCode += theReferencePositionDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> theReferencePositionScope = theReferencePosition.getScope();
                    if (theReferencePositionScope!= null) {
                        currentHashCode += theReferencePositionScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean theReferencePositionNil = theReferencePosition.isNil();
                    currentHashCode += (theReferencePositionNil? 1231 : 1237);
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            JAXBElement<? extends ReferencePositionType> theReferencePosition;
            theReferencePosition = this.getReferencePosition();
            strategy.appendField(locator, this, "referencePosition", buffer, theReferencePosition, (this.referencePosition!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SpectralFrameType) {
            final SpectralFrameType target = this;
            final SpectralFrameType leftObject = ((SpectralFrameType) left);
            final SpectralFrameType rightObject = ((SpectralFrameType) right);
            {
                Boolean referencePositionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null));
                if (referencePositionShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends ReferencePositionType> lhsReferencePosition;
                    lhsReferencePosition = leftObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> rhsReferencePosition;
                    rhsReferencePosition = rightObject.getReferencePosition();
                    JAXBElement<? extends ReferencePositionType> mergedReferencePosition = ((JAXBElement<? extends ReferencePositionType> ) strategy.merge(LocatorUtils.property(leftLocator, "referencePosition", lhsReferencePosition), LocatorUtils.property(rightLocator, "referencePosition", rhsReferencePosition), lhsReferencePosition, rhsReferencePosition, (leftObject.referencePosition!= null), (rightObject.referencePosition!= null)));
                    target.setReferencePosition(mergedReferencePosition);
                } else {
                    if (referencePositionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.referencePosition = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new SpectralFrameType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType clone() {
        final SpectralFrameType _newObject;
        _newObject = ((SpectralFrameType) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType createCopy() {
        final SpectralFrameType _newObject = ((SpectralFrameType) super.createCopy());
        _newObject.referencePosition = this.referencePosition;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpectralFrameType _newObject = ((SpectralFrameType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _newObject.referencePosition = this.referencePosition;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SpectralFrameType.Modifier();
        }
        return ((SpectralFrameType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SpectralFrameType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.referencePosition = this.referencePosition;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SpectralFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SpectralFrameType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> builder() {
        return new SpectralFrameType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final StcBaseType _other) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final CoordFrameType _other) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final SpectralFrameType _other) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final SpectralFrameType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
            _other.referencePosition = this.referencePosition;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >SpectralFrameType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SpectralFrameType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final CoordFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >SpectralFrameType.Builder<_B> copyOf(final SpectralFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SpectralFrameType.Builder<_B> _newBuilder = new SpectralFrameType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyExcept(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyExcept(final SpectralFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyOnly(final CoordFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static SpectralFrameType.Builder<Void> copyOnly(final SpectralFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public SpectralFrameType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(SpectralFrameType.PropInfo.REFERENCE_POSITION, this))&&(this.referencePosition!= null)) {
            this.referencePosition.getValue().visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordFrameType.Builder<_B>
        implements Buildable
    {

        private JAXBElement<? extends ReferencePositionType> referencePosition;

        public Builder(final _B _parentBuilder, final SpectralFrameType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.referencePosition = _other.referencePosition;
            }
        }

        public Builder(final _B _parentBuilder, final SpectralFrameType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree referencePositionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("referencePosition"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(referencePositionPropertyTree!= null):((referencePositionPropertyTree == null)||(!referencePositionPropertyTree.isLeaf())))) {
                    this.referencePosition = _other.referencePosition;
                }
            }
        }

        protected<_P extends SpectralFrameType >_P init(final _P _product) {
            _product.referencePosition = this.referencePosition;
            return super.init(_product);
        }

        /**
         * Sets the new value of "referencePosition" (any previous value will be replaced)
         * 
         * @param referencePosition
         *     New value of the "referencePosition" property.
         */
        public SpectralFrameType.Builder<_B> withReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            this.referencePosition = referencePosition;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public SpectralFrameType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public SpectralFrameType build() {
            if (_storedValue == null) {
                return this.init(new SpectralFrameType());
            } else {
                return ((SpectralFrameType) _storedValue);
            }
        }

        public SpectralFrameType.Builder<_B> copyOf(final SpectralFrameType _other) {
            _other.copyTo(this);
            return this;
        }

        public SpectralFrameType.Builder<_B> copyOf(final SpectralFrameType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordFrameType.Modifier
    {


        public void setReferencePosition(final JAXBElement<? extends ReferencePositionType> referencePosition) {
            SpectralFrameType.this.setReferencePosition(referencePosition);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SpectralFrameType, ReferencePositionType> REFERENCE_POSITION = new SinglePropertyInfo<SpectralFrameType,ReferencePositionType>("referencePosition", SpectralFrameType.class, ReferencePositionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "ReferencePosition"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "referencePositionType"), false) {


            @Override
            public ReferencePositionType get(final SpectralFrameType _instance_) {
                return ((_instance_ == null)?null:((_instance_.referencePosition == null)?null:_instance_.referencePosition.getValue()));
            }

            @Override
            public void set(final SpectralFrameType _instance_, final ReferencePositionType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;

    }

    public static class Select
        extends SpectralFrameType.Selector<SpectralFrameType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SpectralFrameType.Select _root() {
            return new SpectralFrameType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordFrameType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SpectralFrameType.Selector<TRoot, TParent>> referencePosition = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.referencePosition!= null) {
                products.put("referencePosition", this.referencePosition.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SpectralFrameType.Selector<TRoot, TParent>> referencePosition() {
            return ((this.referencePosition == null)?this.referencePosition = new com.kscs.util.jaxb.Selector<>(this._root, this, "referencePosition"):this.referencePosition);
        }

    }

}
