
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * STC standard base type. Elements of derived types may contain real content, be a reference to another element in the document (idref), or be a reference to a distributed resource; the href is to be a standard IVOA identifier or a valid URL. Actuation is up to the client. At this time it is required to be of type simple. An id is optional; it allows referencing by other elements.
 * 
 * <p>Java class for stcBaseType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="stcBaseType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attGroup ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}STCReference"/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "stcBaseType")
@XmlSeeAlso({
    Double4Type.class,
    Double9Type.class,
    CoordSysType.class,
    Double2Type.class,
    Curve2Type.class,
    Double3Type.class,
    Curve3Type.class,
    CoordsType.class,
    CoordAreaType.class,
    CoordFrameType.class,
    CoordinateType.class,
    CoordIntervalType.class,
    StcMetadataType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public abstract class StcBaseType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String id;
    @XmlAttribute(name = "idref")
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Object idref;
    @XmlAttribute(name = "ucd")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String ucd;
    @XmlAttribute(name = "type", namespace = "http://www.w3.org/1999/xlink")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String type;
    @XmlAttribute(name = "href", namespace = "http://www.w3.org/1999/xlink")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String href;
    @XmlAttribute(name = "ID_type")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String idType;
    @XmlAttribute(name = "IDREF_type")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String idrefType;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient StcBaseType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public StcBaseType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public StcBaseType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType) {
        this.id = id;
        this.idref = idref;
        this.ucd = ucd;
        this.type = type;
        this.href = href;
        this.idType = idType;
        this.idrefType = idrefType;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the idref property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object getIdref() {
        return idref;
    }

    /**
     * Sets the value of the idref property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setIdref(Object value) {
        this.idref = value;
    }

    /**
     * Gets the value of the ucd property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getUcd() {
        return ucd;
    }

    /**
     * Sets the value of the ucd property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setUcd(String value) {
        this.ucd = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getType() {
        if (type == null) {
            return "simple";
        } else {
            return type;
        }
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the href property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getHref() {
        return href;
    }

    /**
     * Sets the value of the href property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setHref(String value) {
        this.href = value;
    }

    /**
     * Gets the value of the idType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getIDType() {
        return idType;
    }

    /**
     * Sets the value of the idType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setIDType(String value) {
        this.idType = value;
    }

    /**
     * Gets the value of the idrefType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getIDREFType() {
        return idrefType;
    }

    /**
     * Sets the value of the idrefType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setIDREFType(String value) {
        this.idrefType = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StcBaseType that = ((StcBaseType) object);
        {
            String leftId;
            leftId = this.getId();
            String rightId;
            rightId = that.getId();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftId.equals(rightId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        {
            Object leftIdref;
            leftIdref = this.getIdref();
            Object rightIdref;
            rightIdref = that.getIdref();
            if (this.idref!= null) {
                if (that.idref!= null) {
                    if (!leftIdref.equals(rightIdref)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.idref!= null) {
                    return false;
                }
            }
        }
        {
            String leftUcd;
            leftUcd = this.getUcd();
            String rightUcd;
            rightUcd = that.getUcd();
            if (this.ucd!= null) {
                if (that.ucd!= null) {
                    if (!leftUcd.equals(rightUcd)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ucd!= null) {
                    return false;
                }
            }
        }
        {
            String leftType;
            leftType = this.getType();
            String rightType;
            rightType = that.getType();
            if (this.type!= null) {
                if (that.type!= null) {
                    if (!leftType.equals(rightType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.type!= null) {
                    return false;
                }
            }
        }
        {
            String leftHref;
            leftHref = this.getHref();
            String rightHref;
            rightHref = that.getHref();
            if (this.href!= null) {
                if (that.href!= null) {
                    if (!leftHref.equals(rightHref)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.href!= null) {
                    return false;
                }
            }
        }
        {
            String leftIDType;
            leftIDType = this.getIDType();
            String rightIDType;
            rightIDType = that.getIDType();
            if (this.idType!= null) {
                if (that.idType!= null) {
                    if (!leftIDType.equals(rightIDType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.idType!= null) {
                    return false;
                }
            }
        }
        {
            String leftIDREFType;
            leftIDREFType = this.getIDREFType();
            String rightIDREFType;
            rightIDREFType = that.getIDREFType();
            if (this.idrefType!= null) {
                if (that.idrefType!= null) {
                    if (!leftIDREFType.equals(rightIDREFType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.idrefType!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theId;
            theId = this.getId();
            if (this.id!= null) {
                currentHashCode += theId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Object theIdref;
            theIdref = this.getIdref();
            if (this.idref!= null) {
                currentHashCode += theIdref.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUcd;
            theUcd = this.getUcd();
            if (this.ucd!= null) {
                currentHashCode += theUcd.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theType;
            theType = this.getType();
            if (this.type!= null) {
                currentHashCode += theType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theHref;
            theHref = this.getHref();
            if (this.href!= null) {
                currentHashCode += theHref.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIDType;
            theIDType = this.getIDType();
            if (this.idType!= null) {
                currentHashCode += theIDType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIDREFType;
            theIDREFType = this.getIDREFType();
            if (this.idrefType!= null) {
                currentHashCode += theIDREFType.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        {
            Object theIdref;
            theIdref = this.getIdref();
            strategy.appendField(locator, this, "idref", buffer, theIdref, (this.idref!= null));
        }
        {
            String theUcd;
            theUcd = this.getUcd();
            strategy.appendField(locator, this, "ucd", buffer, theUcd, (this.ucd!= null));
        }
        {
            String theType;
            theType = this.getType();
            strategy.appendField(locator, this, "type", buffer, theType, (this.type!= null));
        }
        {
            String theHref;
            theHref = this.getHref();
            strategy.appendField(locator, this, "href", buffer, theHref, (this.href!= null));
        }
        {
            String theIDType;
            theIDType = this.getIDType();
            strategy.appendField(locator, this, "idType", buffer, theIDType, (this.idType!= null));
        }
        {
            String theIDREFType;
            theIDREFType = this.getIDREFType();
            strategy.appendField(locator, this, "idrefType", buffer, theIDREFType, (this.idrefType!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof StcBaseType) {
            final StcBaseType target = this;
            final StcBaseType leftObject = ((StcBaseType) left);
            final StcBaseType rightObject = ((StcBaseType) right);
            {
                Boolean idShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.id!= null), (rightObject.id!= null));
                if (idShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsId;
                    lhsId = leftObject.getId();
                    String rhsId;
                    rhsId = rightObject.getId();
                    String mergedId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "id", lhsId), LocatorUtils.property(rightLocator, "id", rhsId), lhsId, rhsId, (leftObject.id!= null), (rightObject.id!= null)));
                    target.setId(mergedId);
                } else {
                    if (idShouldBeMergedAndSet == Boolean.FALSE) {
                        target.id = null;
                    }
                }
            }
            {
                Boolean idrefShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.idref!= null), (rightObject.idref!= null));
                if (idrefShouldBeMergedAndSet == Boolean.TRUE) {
                    Object lhsIdref;
                    lhsIdref = leftObject.getIdref();
                    Object rhsIdref;
                    rhsIdref = rightObject.getIdref();
                    Object mergedIdref = ((Object) strategy.merge(LocatorUtils.property(leftLocator, "idref", lhsIdref), LocatorUtils.property(rightLocator, "idref", rhsIdref), lhsIdref, rhsIdref, (leftObject.idref!= null), (rightObject.idref!= null)));
                    target.setIdref(mergedIdref);
                } else {
                    if (idrefShouldBeMergedAndSet == Boolean.FALSE) {
                        target.idref = null;
                    }
                }
            }
            {
                Boolean ucdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.ucd!= null), (rightObject.ucd!= null));
                if (ucdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUcd;
                    lhsUcd = leftObject.getUcd();
                    String rhsUcd;
                    rhsUcd = rightObject.getUcd();
                    String mergedUcd = ((String) strategy.merge(LocatorUtils.property(leftLocator, "ucd", lhsUcd), LocatorUtils.property(rightLocator, "ucd", rhsUcd), lhsUcd, rhsUcd, (leftObject.ucd!= null), (rightObject.ucd!= null)));
                    target.setUcd(mergedUcd);
                } else {
                    if (ucdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.ucd = null;
                    }
                }
            }
            {
                Boolean typeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.type!= null), (rightObject.type!= null));
                if (typeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsType;
                    lhsType = leftObject.getType();
                    String rhsType;
                    rhsType = rightObject.getType();
                    String mergedType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "type", lhsType), LocatorUtils.property(rightLocator, "type", rhsType), lhsType, rhsType, (leftObject.type!= null), (rightObject.type!= null)));
                    target.setType(mergedType);
                } else {
                    if (typeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.type = null;
                    }
                }
            }
            {
                Boolean hrefShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.href!= null), (rightObject.href!= null));
                if (hrefShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsHref;
                    lhsHref = leftObject.getHref();
                    String rhsHref;
                    rhsHref = rightObject.getHref();
                    String mergedHref = ((String) strategy.merge(LocatorUtils.property(leftLocator, "href", lhsHref), LocatorUtils.property(rightLocator, "href", rhsHref), lhsHref, rhsHref, (leftObject.href!= null), (rightObject.href!= null)));
                    target.setHref(mergedHref);
                } else {
                    if (hrefShouldBeMergedAndSet == Boolean.FALSE) {
                        target.href = null;
                    }
                }
            }
            {
                Boolean idTypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.idType!= null), (rightObject.idType!= null));
                if (idTypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIDType;
                    lhsIDType = leftObject.getIDType();
                    String rhsIDType;
                    rhsIDType = rightObject.getIDType();
                    String mergedIDType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "idType", lhsIDType), LocatorUtils.property(rightLocator, "idType", rhsIDType), lhsIDType, rhsIDType, (leftObject.idType!= null), (rightObject.idType!= null)));
                    target.setIDType(mergedIDType);
                } else {
                    if (idTypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.idType = null;
                    }
                }
            }
            {
                Boolean idrefTypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.idrefType!= null), (rightObject.idrefType!= null));
                if (idrefTypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIDREFType;
                    lhsIDREFType = leftObject.getIDREFType();
                    String rhsIDREFType;
                    rhsIDREFType = rightObject.getIDREFType();
                    String mergedIDREFType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "idrefType", lhsIDREFType), LocatorUtils.property(rightLocator, "idrefType", rhsIDREFType), lhsIDREFType, rhsIDREFType, (leftObject.idrefType!= null), (rightObject.idrefType!= null)));
                    target.setIDREFType(mergedIDREFType);
                } else {
                    if (idrefTypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.idrefType = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType clone() {
        final StcBaseType _newObject;
        try {
            _newObject = ((StcBaseType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType createCopy() {
        final StcBaseType _newObject;
        try {
            _newObject = ((StcBaseType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.id = this.id;
        _newObject.idref = this.idref;
        _newObject.ucd = this.ucd;
        _newObject.type = this.type;
        _newObject.href = this.href;
        _newObject.idType = this.idType;
        _newObject.idrefType = this.idrefType;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final StcBaseType _newObject;
        try {
            _newObject = ((StcBaseType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _newObject.id = this.id;
        }
        final PropertyTree idrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idref"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefPropertyTree!= null):((idrefPropertyTree == null)||(!idrefPropertyTree.isLeaf())))) {
            _newObject.idref = this.idref;
        }
        final PropertyTree ucdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ucd"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ucdPropertyTree!= null):((ucdPropertyTree == null)||(!ucdPropertyTree.isLeaf())))) {
            _newObject.ucd = this.ucd;
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _newObject.type = this.type;
        }
        final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
            _newObject.href = this.href;
        }
        final PropertyTree idTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idTypePropertyTree!= null):((idTypePropertyTree == null)||(!idTypePropertyTree.isLeaf())))) {
            _newObject.idType = this.idType;
        }
        final PropertyTree idrefTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idrefType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefTypePropertyTree!= null):((idrefTypePropertyTree == null)||(!idrefTypePropertyTree.isLeaf())))) {
            _newObject.idrefType = this.idrefType;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new StcBaseType.Modifier();
        }
        return ((StcBaseType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final StcBaseType.Builder<_B> _other) {
        _other.id = this.id;
        _other.idref = this.idref;
        _other.ucd = this.ucd;
        _other.type = this.type;
        _other.href = this.href;
        _other.idType = this.idType;
        _other.idrefType = this.idrefType;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract<_B >StcBaseType.Builder<_B> newCopyBuilder(final _B _parentBuilder);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract StcBaseType.Builder<Void> newCopyBuilder();

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final StcBaseType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _other.id = this.id;
        }
        final PropertyTree idrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idref"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefPropertyTree!= null):((idrefPropertyTree == null)||(!idrefPropertyTree.isLeaf())))) {
            _other.idref = this.idref;
        }
        final PropertyTree ucdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ucd"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ucdPropertyTree!= null):((ucdPropertyTree == null)||(!ucdPropertyTree.isLeaf())))) {
            _other.ucd = this.ucd;
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _other.type = this.type;
        }
        final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
            _other.href = this.href;
        }
        final PropertyTree idTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idTypePropertyTree!= null):((idTypePropertyTree == null)||(!idTypePropertyTree.isLeaf())))) {
            _other.idType = this.idType;
        }
        final PropertyTree idrefTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idrefType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefTypePropertyTree!= null):((idrefTypePropertyTree == null)||(!idrefTypePropertyTree.isLeaf())))) {
            _other.idrefType = this.idrefType;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract<_B >StcBaseType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract StcBaseType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StcBaseType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.ID, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.IDREF, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.UCD, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.TYPE, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.HREF, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.ID_TYPE, this));
        _visitor_.visit(new SingleProperty<>(StcBaseType.PropInfo.IDREF_TYPE, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final StcBaseType _storedValue;
        private String id;
        private Object idref;
        private String ucd;
        private String type = "simple";
        private String href;
        private String idType;
        private String idrefType;

        public Builder(final _B _parentBuilder, final StcBaseType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.id = _other.id;
                    this.idref = _other.idref;
                    this.ucd = _other.ucd;
                    this.type = _other.type;
                    this.href = _other.href;
                    this.idType = _other.idType;
                    this.idrefType = _other.idrefType;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final StcBaseType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
                        this.id = _other.id;
                    }
                    final PropertyTree idrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idref"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefPropertyTree!= null):((idrefPropertyTree == null)||(!idrefPropertyTree.isLeaf())))) {
                        this.idref = _other.idref;
                    }
                    final PropertyTree ucdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ucd"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ucdPropertyTree!= null):((ucdPropertyTree == null)||(!ucdPropertyTree.isLeaf())))) {
                        this.ucd = _other.ucd;
                    }
                    final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
                        this.type = _other.type;
                    }
                    final PropertyTree hrefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("href"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(hrefPropertyTree!= null):((hrefPropertyTree == null)||(!hrefPropertyTree.isLeaf())))) {
                        this.href = _other.href;
                    }
                    final PropertyTree idTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idType"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idTypePropertyTree!= null):((idTypePropertyTree == null)||(!idTypePropertyTree.isLeaf())))) {
                        this.idType = _other.idType;
                    }
                    final PropertyTree idrefTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("idrefType"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idrefTypePropertyTree!= null):((idrefTypePropertyTree == null)||(!idrefTypePropertyTree.isLeaf())))) {
                        this.idrefType = _other.idrefType;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends StcBaseType >_P init(final _P _product) {
            _product.id = this.id;
            _product.idref = this.idref;
            _product.ucd = this.ucd;
            _product.type = this.type;
            _product.href = this.href;
            _product.idType = this.idType;
            _product.idrefType = this.idrefType;
            return _product;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        public StcBaseType.Builder<_B> withId(final String id) {
            this.id = id;
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        public StcBaseType.Builder<_B> withIdref(final Object idref) {
            this.idref = idref;
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        public StcBaseType.Builder<_B> withUcd(final String ucd) {
            this.ucd = ucd;
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        public StcBaseType.Builder<_B> withType(final String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        public StcBaseType.Builder<_B> withHref(final String href) {
            this.href = href;
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        public StcBaseType.Builder<_B> withIDType(final String idType) {
            this.idType = idType;
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        public StcBaseType.Builder<_B> withIDREFType(final String idrefType) {
            this.idrefType = idrefType;
            return this;
        }

        @Override
        public StcBaseType build() {
            return ((StcBaseType) _storedValue);
        }

        public StcBaseType.Builder<_B> copyOf(final StcBaseType _other) {
            _other.copyTo(this);
            return this;
        }

        public StcBaseType.Builder<_B> copyOf(final StcBaseType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setId(final String id) {
            StcBaseType.this.setId(id);
        }

        public void setIdref(final Object idref) {
            StcBaseType.this.setIdref(idref);
        }

        public void setUcd(final String ucd) {
            StcBaseType.this.setUcd(ucd);
        }

        public void setType(final String type) {
            StcBaseType.this.setType(type);
        }

        public void setHref(final String href) {
            StcBaseType.this.setHref(href);
        }

        public void setIDType(final String idType) {
            StcBaseType.this.setIDType(idType);
        }

        public void setIDREFType(final String idrefType) {
            StcBaseType.this.setIDREFType(idrefType);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<StcBaseType, String> ID = new SinglePropertyInfo<StcBaseType,String>("id", StcBaseType.class, String.class, false, null, new QName("", "id"), new QName("http://www.w3.org/2001/XMLSchema", "ID"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.id);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.id = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, Object> IDREF = new SinglePropertyInfo<StcBaseType,Object>("idref", StcBaseType.class, Object.class, false, null, new QName("", "idref"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true) {


            @Override
            public Object get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.idref);
            }

            @Override
            public void set(final StcBaseType _instance_, final Object _value_) {
                if (_instance_!= null) {
                    _instance_.idref = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, String> UCD = new SinglePropertyInfo<StcBaseType,String>("ucd", StcBaseType.class, String.class, false, null, new QName("", "ucd"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.ucd);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.ucd = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, String> TYPE = new SinglePropertyInfo<StcBaseType,String>("type", StcBaseType.class, String.class, false, "simple", new QName("http://www.w3.org/1999/xlink", "type"), new QName("http://www.w3.org/1999/xlink", "anonymousAttributeType"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.type);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.type = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, String> HREF = new SinglePropertyInfo<StcBaseType,String>("href", StcBaseType.class, String.class, false, null, new QName("http://www.w3.org/1999/xlink", "href"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.href);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.href = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, String> ID_TYPE = new SinglePropertyInfo<StcBaseType,String>("idType", StcBaseType.class, String.class, false, null, new QName("", "ID_type"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.idType);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.idType = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<StcBaseType, String> IDREF_TYPE = new SinglePropertyInfo<StcBaseType,String>("idrefType", StcBaseType.class, String.class, false, null, new QName("", "IDREF_type"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final StcBaseType _instance_) {
                return ((_instance_ == null)?null:_instance_.idrefType);
            }

            @Override
            public void set(final StcBaseType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.idrefType = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends StcBaseType.Selector<StcBaseType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static StcBaseType.Select _root() {
            return new StcBaseType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> id = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idref = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> ucd = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> type = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> href = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idType = null;
        private com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idrefType = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.id!= null) {
                products.put("id", this.id.init());
            }
            if (this.idref!= null) {
                products.put("idref", this.idref.init());
            }
            if (this.ucd!= null) {
                products.put("ucd", this.ucd.init());
            }
            if (this.type!= null) {
                products.put("type", this.type.init());
            }
            if (this.href!= null) {
                products.put("href", this.href.init());
            }
            if (this.idType!= null) {
                products.put("idType", this.idType.init());
            }
            if (this.idrefType!= null) {
                products.put("idrefType", this.idrefType.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> id() {
            return ((this.id == null)?this.id = new com.kscs.util.jaxb.Selector<>(this._root, this, "id"):this.id);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idref() {
            return ((this.idref == null)?this.idref = new com.kscs.util.jaxb.Selector<>(this._root, this, "idref"):this.idref);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> ucd() {
            return ((this.ucd == null)?this.ucd = new com.kscs.util.jaxb.Selector<>(this._root, this, "ucd"):this.ucd);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> type() {
            return ((this.type == null)?this.type = new com.kscs.util.jaxb.Selector<>(this._root, this, "type"):this.type);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> href() {
            return ((this.href == null)?this.href = new com.kscs.util.jaxb.Selector<>(this._root, this, "href"):this.href);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idType() {
            return ((this.idType == null)?this.idType = new com.kscs.util.jaxb.Selector<>(this._root, this, "idType"):this.idType);
        }

        public com.kscs.util.jaxb.Selector<TRoot, StcBaseType.Selector<TRoot, TParent>> idrefType() {
            return ((this.idrefType == null)?this.idrefType = new com.kscs.util.jaxb.Selector<>(this._root, this, "idrefType"):this.idrefType);
        }

    }

}
