
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The union of two or more regions is a region
 * 
 * <p>Java class for unionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="unionType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}regionType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}Region" maxOccurs="unbounded" minOccurs="2"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "unionType", propOrder = {
    "regions"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class UnionType
    extends RegionType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Head element of the Region substitution group; a Region is a Shape or the result of a Region Operation on one or more Regions
     * 
     */
    @XmlElementRef(name = "Region", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<JAXBElement<? extends RegionType>> regions;

    /**
     * Default no-arg constructor
     * 
     */
    public UnionType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public UnionType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final List<JAXBElement<? extends RegionType>> regions) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.regions = regions;
    }

    /**
     * Head element of the Region substitution group; a Region is a Shape or the result of a Region Operation on one or more Regions
     * 
     * Gets the value of the regions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the regions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRegions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     * {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     * {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     * {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     * {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     * {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     * {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     * {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     * {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     * {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     * {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     * {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     * {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     * {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the regions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<JAXBElement<? extends RegionType>> getRegions() {
        if (regions == null) {
            regions = new ArrayList<>();
        }
        return this.regions;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final UnionType that = ((UnionType) object);
        {
            List<JAXBElement<? extends RegionType>> leftRegions;
            leftRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            List<JAXBElement<? extends RegionType>> rightRegions;
            rightRegions = (((that.regions!= null)&&(!that.regions.isEmpty()))?that.getRegions():null);
            if ((this.regions!= null)&&(!this.regions.isEmpty())) {
                if ((that.regions!= null)&&(!that.regions.isEmpty())) {
                    final ListIterator<JAXBElement<? extends RegionType>> leftRegionsListIterator = leftRegions.listIterator();
                    final ListIterator<JAXBElement<? extends RegionType>> rightRegionsListIterator = rightRegions.listIterator();
                    while (rightRegionsListIterator.hasNext()&&leftRegionsListIterator.hasNext()) {
                        final JAXBElement<? extends RegionType> rightRegionsListIteratorElement = rightRegionsListIterator.next();
                        final JAXBElement<? extends RegionType> leftRegionsListIteratorElement = leftRegionsListIterator.next();
                        if (rightRegionsListIteratorElement!= null) {
                            if (leftRegionsListIteratorElement!= null) {
                                {
                                    final QName rightRegionsListIteratorElementName = rightRegionsListIteratorElement.getName();
                                    final QName leftRegionsListIteratorElementName = leftRegionsListIteratorElement.getName();
                                    if (rightRegionsListIteratorElementName!= null) {
                                        if (leftRegionsListIteratorElementName!= null) {
                                            if (!rightRegionsListIteratorElementName.equals(leftRegionsListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final RegionType rightRegionsListIteratorElementValue = rightRegionsListIteratorElement.getValue();
                                    final RegionType leftRegionsListIteratorElementValue = leftRegionsListIteratorElement.getValue();
                                    if (rightRegionsListIteratorElementValue!= null) {
                                        if (leftRegionsListIteratorElementValue!= null) {
                                            if (!rightRegionsListIteratorElementValue.equals(leftRegionsListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends RegionType> rightRegionsListIteratorElementDeclaredType = rightRegionsListIteratorElement.getDeclaredType();
                                    final Class<? extends RegionType> leftRegionsListIteratorElementDeclaredType = leftRegionsListIteratorElement.getDeclaredType();
                                    if (rightRegionsListIteratorElementDeclaredType!= null) {
                                        if (leftRegionsListIteratorElementDeclaredType!= null) {
                                            if (!rightRegionsListIteratorElementDeclaredType.equals(leftRegionsListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightRegionsListIteratorElementScope = rightRegionsListIteratorElement.getScope();
                                    final Class<?> leftRegionsListIteratorElementScope = leftRegionsListIteratorElement.getScope();
                                    if (rightRegionsListIteratorElementScope!= null) {
                                        if (leftRegionsListIteratorElementScope!= null) {
                                            if (!rightRegionsListIteratorElementScope.equals(leftRegionsListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftRegionsListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightRegionsListIteratorElementNil = rightRegionsListIteratorElement.isNil();
                                    final boolean leftRegionsListIteratorElementNil = leftRegionsListIteratorElement.isNil();
                                    if (rightRegionsListIteratorElementNil!= leftRegionsListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftRegionsListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightRegionsListIterator.hasNext()||leftRegionsListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.regions!= null)&&(!that.regions.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends RegionType>> theRegions;
            theRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            if ((this.regions!= null)&&(!this.regions.isEmpty())) {
                final ListIterator<JAXBElement<? extends RegionType>> theRegionsListIterator = theRegions.listIterator();
                while (theRegionsListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends RegionType> theRegionsListIteratorElement = theRegionsListIterator.next();
                    if (theRegionsListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName theRegionsListIteratorElementName = theRegionsListIteratorElement.getName();
                            if (theRegionsListIteratorElementName!= null) {
                                currentHashCode += theRegionsListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final RegionType theRegionsListIteratorElementValue = theRegionsListIteratorElement.getValue();
                            if (theRegionsListIteratorElementValue!= null) {
                                currentHashCode += theRegionsListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends RegionType> theRegionsListIteratorElementDeclaredType = theRegionsListIteratorElement.getDeclaredType();
                            if (theRegionsListIteratorElementDeclaredType!= null) {
                                currentHashCode += theRegionsListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> theRegionsListIteratorElementScope = theRegionsListIteratorElement.getScope();
                            if (theRegionsListIteratorElementScope!= null) {
                                currentHashCode += theRegionsListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean theRegionsListIteratorElementNil = theRegionsListIteratorElement.isNil();
                            currentHashCode += (theRegionsListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<JAXBElement<? extends RegionType>> theRegions;
            theRegions = (((this.regions!= null)&&(!this.regions.isEmpty()))?this.getRegions():null);
            strategy.appendField(locator, this, "regions", buffer, theRegions, ((this.regions!= null)&&(!this.regions.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof UnionType) {
            final UnionType target = this;
            final UnionType leftObject = ((UnionType) left);
            final UnionType rightObject = ((UnionType) right);
            {
                Boolean regionsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.regions!= null)&&(!leftObject.regions.isEmpty())), ((rightObject.regions!= null)&&(!rightObject.regions.isEmpty())));
                if (regionsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends RegionType>> lhsRegions;
                    lhsRegions = (((leftObject.regions!= null)&&(!leftObject.regions.isEmpty()))?leftObject.getRegions():null);
                    List<JAXBElement<? extends RegionType>> rhsRegions;
                    rhsRegions = (((rightObject.regions!= null)&&(!rightObject.regions.isEmpty()))?rightObject.getRegions():null);
                    List<JAXBElement<? extends RegionType>> mergedRegions = ((List<JAXBElement<? extends RegionType>> ) strategy.merge(LocatorUtils.property(leftLocator, "regions", lhsRegions), LocatorUtils.property(rightLocator, "regions", rhsRegions), lhsRegions, rhsRegions, ((leftObject.regions!= null)&&(!leftObject.regions.isEmpty())), ((rightObject.regions!= null)&&(!rightObject.regions.isEmpty()))));
                    target.regions = null;
                    if (mergedRegions!= null) {
                        List<JAXBElement<? extends RegionType>> uniqueRegionsl = target.getRegions();
                        uniqueRegionsl.addAll(mergedRegions);
                    }
                } else {
                    if (regionsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.regions = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new UnionType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType clone() {
        final UnionType _newObject;
        _newObject = ((UnionType) super.clone());
        _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType createCopy() {
        final UnionType _newObject = ((UnionType) super.createCopy());
        _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType _newObject = ((UnionType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
            _newObject.regions = ((this.regions == null)?null:new ArrayList<>(this.regions));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new UnionType.Modifier();
        }
        return ((UnionType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final UnionType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.regions == null) {
            _other.regions = null;
        } else {
            _other.regions = new ArrayList<>();
            for (JAXBElement<? extends RegionType> _item: this.regions) {
                _other.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >UnionType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new UnionType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> builder() {
        return new UnionType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final StcBaseType _other) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final RegionType _other) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final UnionType _other) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final UnionType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
            if (this.regions == null) {
                _other.regions = null;
            } else {
                _other.regions = new ArrayList<>();
                for (JAXBElement<? extends RegionType> _item: this.regions) {
                    _other.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >UnionType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new UnionType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >UnionType.Builder<_B> copyOf(final UnionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UnionType.Builder<_B> _newBuilder = new UnionType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyExcept(final UnionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static UnionType.Builder<Void> copyOnly(final UnionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public UnionType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new IndirectCollectionProperty<>(UnionType.PropInfo.REGIONS, this))&&(this.regions!= null)) {
            for (JAXBElement<? extends RegionType> _item_: this.regions) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends RegionType.Builder<_B>
        implements Buildable
    {

        private List<Buildable> regions;

        public Builder(final _B _parentBuilder, final UnionType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.regions == null) {
                    this.regions = null;
                } else {
                    this.regions = new ArrayList<>();
                    for (JAXBElement<? extends RegionType> _item: _other.regions) {
                        this.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final UnionType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree regionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regions"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionsPropertyTree!= null):((regionsPropertyTree == null)||(!regionsPropertyTree.isLeaf())))) {
                    if (_other.regions == null) {
                        this.regions = null;
                    } else {
                        this.regions = new ArrayList<>();
                        for (JAXBElement<? extends RegionType> _item: _other.regions) {
                            this.regions.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
            }
        }

        protected<_P extends UnionType >_P init(final _P _product) {
            if (this.regions!= null) {
                final List<JAXBElement<? extends RegionType>> regions = new ArrayList<>(this.regions.size());
                for (Buildable _item: this.regions) {
                    regions.add(((JAXBElement<? extends RegionType> ) _item.build()));
                }
                _product.regions = regions;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "regions"
         * 
         * @param regions
         *     Items to add to the value of the "regions" property
         */
        public UnionType.Builder<_B> addRegions(final Iterable<? extends JAXBElement<? extends RegionType>> regions) {
            if (regions!= null) {
                if (this.regions == null) {
                    this.regions = new ArrayList<>();
                }
                for (JAXBElement<? extends RegionType> _item: regions) {
                    this.regions.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "regions" (any previous value will be replaced)
         * 
         * @param regions
         *     New value of the "regions" property.
         */
        public UnionType.Builder<_B> withRegions(final Iterable<? extends JAXBElement<? extends RegionType>> regions) {
            if (this.regions!= null) {
                this.regions.clear();
            }
            return addRegions(regions);
        }

        /**
         * Adds the given items to the value of "regions"
         * 
         * @param regions
         *     Items to add to the value of the "regions" property
         */
        public UnionType.Builder<_B> addRegions(JAXBElement<? extends RegionType> ... regions) {
            addRegions(Arrays.asList(regions));
            return this;
        }

        /**
         * Sets the new value of "regions" (any previous value will be replaced)
         * 
         * @param regions
         *     New value of the "regions" property.
         */
        public UnionType.Builder<_B> withRegions(JAXBElement<? extends RegionType> ... regions) {
            withRegions(Arrays.asList(regions));
            return this;
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public UnionType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends UnionType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends UnionType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public UnionType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public UnionType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public UnionType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public UnionType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public UnionType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public UnionType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public UnionType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public UnionType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public UnionType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public UnionType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public UnionType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public UnionType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public UnionType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public UnionType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public UnionType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public UnionType build() {
            if (_storedValue == null) {
                return this.init(new UnionType());
            } else {
                return ((UnionType) _storedValue);
            }
        }

        public UnionType.Builder<_B> copyOf(final UnionType _other) {
            _other.copyTo(this);
            return this;
        }

        public UnionType.Builder<_B> copyOf(final UnionType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends RegionType.Modifier
    {


        public List<JAXBElement<? extends RegionType>> getRegions() {
            if (UnionType.this.regions == null) {
                UnionType.this.regions = new ArrayList<>();
            }
            return UnionType.this.regions;
        }

    }

    public static class PropInfo {

        public static final transient IndirectCollectionPropertyInfo<UnionType, RegionType> REGIONS = new IndirectCollectionPropertyInfo<UnionType,RegionType>("regions", UnionType.class, RegionType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Region"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "regionType"), false) {


            @Override
            public List<JAXBElement<? extends RegionType>> get(final UnionType _instance_) {
                return ((_instance_ == null)?null:_instance_.regions);
            }

            @Override
            public void set(final UnionType _instance_, final List<JAXBElement<? extends RegionType>> _value_) {
                if (_instance_!= null) {
                    _instance_.regions = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends UnionType.Selector<UnionType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static UnionType.Select _root() {
            return new UnionType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends RegionType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, UnionType.Selector<TRoot, TParent>> regions = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.regions!= null) {
                products.put("regions", this.regions.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, UnionType.Selector<TRoot, TParent>> regions() {
            return ((this.regions == null)?this.regions = new com.kscs.util.jaxb.Selector<>(this._root, this, "regions"):this.regions);
        }

    }

}
