
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Defines a velocity sphere
 * 
 * A special kind of area is a circle or sphere (in two or three dimensions), defined by a center position and a radius; the radius requires a unit
 * 
 * <p>Java class for velocitySphereType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="velocitySphereType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}velocityIntervalType">
 *       <sequence>
 *         <element name="Radius" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double1Type"/>
 *         <element name="Center" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double3Type"/>
 *       </sequence>
 *       <attribute name="radius_unit" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}posUnitType" default="deg" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "velocitySphereType", propOrder = {
    "radius",
    "center"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class VelocitySphereType
    extends VelocityIntervalType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Radius", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Double1Type radius;
    @XmlElement(name = "Center", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected Double3Type center;
    @XmlAttribute(name = "radius_unit")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String radiusUnit;

    /**
     * Default no-arg constructor
     * 
     */
    public VelocitySphereType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public VelocitySphereType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final VelTimeUnitType velTimeUnit, final Double1Type radius, final Double3Type center, final String radiusUnit) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, velTimeUnit);
        this.radius = radius;
        this.center = center;
        this.radiusUnit = radiusUnit;
    }

    /**
     * Gets the value of the radius property.
     * 
     * @return
     *     possible object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Double1Type getRadius() {
        return radius;
    }

    /**
     * Sets the value of the radius property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double1Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setRadius(Double1Type value) {
        this.radius = value;
    }

    /**
     * Gets the value of the center property.
     * 
     * @return
     *     possible object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Double3Type getCenter() {
        return center;
    }

    /**
     * Sets the value of the center property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double3Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setCenter(Double3Type value) {
        this.center = value;
    }

    /**
     * Gets the value of the radiusUnit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getRadiusUnit() {
        if (radiusUnit == null) {
            return "deg";
        } else {
            return radiusUnit;
        }
    }

    /**
     * Sets the value of the radiusUnit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setRadiusUnit(String value) {
        this.radiusUnit = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final VelocitySphereType that = ((VelocitySphereType) object);
        {
            Double1Type leftRadius;
            leftRadius = this.getRadius();
            Double1Type rightRadius;
            rightRadius = that.getRadius();
            if (this.radius!= null) {
                if (that.radius!= null) {
                    if (!leftRadius.equals(rightRadius)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.radius!= null) {
                    return false;
                }
            }
        }
        {
            Double3Type leftCenter;
            leftCenter = this.getCenter();
            Double3Type rightCenter;
            rightCenter = that.getCenter();
            if (this.center!= null) {
                if (that.center!= null) {
                    if (!leftCenter.equals(rightCenter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.center!= null) {
                    return false;
                }
            }
        }
        {
            String leftRadiusUnit;
            leftRadiusUnit = this.getRadiusUnit();
            String rightRadiusUnit;
            rightRadiusUnit = that.getRadiusUnit();
            if (this.radiusUnit!= null) {
                if (that.radiusUnit!= null) {
                    if (!leftRadiusUnit.equals(rightRadiusUnit)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.radiusUnit!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double1Type theRadius;
            theRadius = this.getRadius();
            if (this.radius!= null) {
                currentHashCode += theRadius.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double3Type theCenter;
            theCenter = this.getCenter();
            if (this.center!= null) {
                currentHashCode += theCenter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRadiusUnit;
            theRadiusUnit = this.getRadiusUnit();
            if (this.radiusUnit!= null) {
                currentHashCode += theRadiusUnit.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double1Type theRadius;
            theRadius = this.getRadius();
            strategy.appendField(locator, this, "radius", buffer, theRadius, (this.radius!= null));
        }
        {
            Double3Type theCenter;
            theCenter = this.getCenter();
            strategy.appendField(locator, this, "center", buffer, theCenter, (this.center!= null));
        }
        {
            String theRadiusUnit;
            theRadiusUnit = this.getRadiusUnit();
            strategy.appendField(locator, this, "radiusUnit", buffer, theRadiusUnit, (this.radiusUnit!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof VelocitySphereType) {
            final VelocitySphereType target = this;
            final VelocitySphereType leftObject = ((VelocitySphereType) left);
            final VelocitySphereType rightObject = ((VelocitySphereType) right);
            {
                Boolean radiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.radius!= null), (rightObject.radius!= null));
                if (radiusShouldBeMergedAndSet == Boolean.TRUE) {
                    Double1Type lhsRadius;
                    lhsRadius = leftObject.getRadius();
                    Double1Type rhsRadius;
                    rhsRadius = rightObject.getRadius();
                    Double1Type mergedRadius = ((Double1Type) strategy.merge(LocatorUtils.property(leftLocator, "radius", lhsRadius), LocatorUtils.property(rightLocator, "radius", rhsRadius), lhsRadius, rhsRadius, (leftObject.radius!= null), (rightObject.radius!= null)));
                    target.setRadius(mergedRadius);
                } else {
                    if (radiusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.radius = null;
                    }
                }
            }
            {
                Boolean centerShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.center!= null), (rightObject.center!= null));
                if (centerShouldBeMergedAndSet == Boolean.TRUE) {
                    Double3Type lhsCenter;
                    lhsCenter = leftObject.getCenter();
                    Double3Type rhsCenter;
                    rhsCenter = rightObject.getCenter();
                    Double3Type mergedCenter = ((Double3Type) strategy.merge(LocatorUtils.property(leftLocator, "center", lhsCenter), LocatorUtils.property(rightLocator, "center", rhsCenter), lhsCenter, rhsCenter, (leftObject.center!= null), (rightObject.center!= null)));
                    target.setCenter(mergedCenter);
                } else {
                    if (centerShouldBeMergedAndSet == Boolean.FALSE) {
                        target.center = null;
                    }
                }
            }
            {
                Boolean radiusUnitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.radiusUnit!= null), (rightObject.radiusUnit!= null));
                if (radiusUnitShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsRadiusUnit;
                    lhsRadiusUnit = leftObject.getRadiusUnit();
                    String rhsRadiusUnit;
                    rhsRadiusUnit = rightObject.getRadiusUnit();
                    String mergedRadiusUnit = ((String) strategy.merge(LocatorUtils.property(leftLocator, "radiusUnit", lhsRadiusUnit), LocatorUtils.property(rightLocator, "radiusUnit", rhsRadiusUnit), lhsRadiusUnit, rhsRadiusUnit, (leftObject.radiusUnit!= null), (rightObject.radiusUnit!= null)));
                    target.setRadiusUnit(mergedRadiusUnit);
                } else {
                    if (radiusUnitShouldBeMergedAndSet == Boolean.FALSE) {
                        target.radiusUnit = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new VelocitySphereType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType clone() {
        final VelocitySphereType _newObject;
        _newObject = ((VelocitySphereType) super.clone());
        _newObject.radius = ((this.radius == null)?null:this.radius.clone());
        _newObject.center = ((this.center == null)?null:this.center.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType createCopy() {
        final VelocitySphereType _newObject = ((VelocitySphereType) super.createCopy());
        _newObject.radius = ((this.radius == null)?null:this.radius.createCopy());
        _newObject.center = ((this.center == null)?null:this.center.createCopy());
        _newObject.radiusUnit = this.radiusUnit;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType _newObject = ((VelocitySphereType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _newObject.radius = ((this.radius == null)?null:this.radius.createCopy(radiusPropertyTree, _propertyTreeUse));
        }
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _newObject.center = ((this.center == null)?null:this.center.createCopy(centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree radiusUnitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radiusUnit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusUnitPropertyTree!= null):((radiusUnitPropertyTree == null)||(!radiusUnitPropertyTree.isLeaf())))) {
            _newObject.radiusUnit = this.radiusUnit;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new VelocitySphereType.Modifier();
        }
        return ((VelocitySphereType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final VelocitySphereType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.radius = ((this.radius == null)?null:this.radius.newCopyBuilder(_other));
        _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other));
        _other.radiusUnit = this.radiusUnit;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >VelocitySphereType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new VelocitySphereType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> builder() {
        return new VelocitySphereType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final StcBaseType _other) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final VelocityIntervalType _other) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final VelocitySphereType _other) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final VelocitySphereType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _other.radius = ((this.radius == null)?null:this.radius.newCopyBuilder(_other, radiusPropertyTree, _propertyTreeUse));
        }
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other, centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree radiusUnitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radiusUnit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusUnitPropertyTree!= null):((radiusUnitPropertyTree == null)||(!radiusUnitPropertyTree.isLeaf())))) {
            _other.radiusUnit = this.radiusUnit;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >VelocitySphereType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new VelocitySphereType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final VelocityIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >VelocitySphereType.Builder<_B> copyOf(final VelocitySphereType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final VelocitySphereType.Builder<_B> _newBuilder = new VelocitySphereType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyExcept(final VelocityIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyExcept(final VelocitySphereType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyOnly(final VelocityIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static VelocitySphereType.Builder<Void> copyOnly(final VelocitySphereType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public VelocitySphereType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(VelocitySphereType.PropInfo.RADIUS, this))&&(this.radius!= null)) {
            this.radius.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(VelocitySphereType.PropInfo.CENTER, this))&&(this.center!= null)) {
            this.center.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(VelocitySphereType.PropInfo.RADIUS_UNIT, this));
        return this;
    }

    public static class Builder<_B >
        extends VelocityIntervalType.Builder<_B>
        implements Buildable
    {

        private Double1Type.Builder<VelocitySphereType.Builder<_B>> radius;
        private Double3Type.Builder<VelocitySphereType.Builder<_B>> center;
        private String radiusUnit = "deg";

        public Builder(final _B _parentBuilder, final VelocitySphereType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.radius = ((_other.radius == null)?null:_other.radius.newCopyBuilder(this));
                this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this));
                this.radiusUnit = _other.radiusUnit;
            }
        }

        public Builder(final _B _parentBuilder, final VelocitySphereType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
                    this.radius = ((_other.radius == null)?null:_other.radius.newCopyBuilder(this, radiusPropertyTree, _propertyTreeUse));
                }
                final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
                    this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this, centerPropertyTree, _propertyTreeUse));
                }
                final PropertyTree radiusUnitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radiusUnit"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusUnitPropertyTree!= null):((radiusUnitPropertyTree == null)||(!radiusUnitPropertyTree.isLeaf())))) {
                    this.radiusUnit = _other.radiusUnit;
                }
            }
        }

        protected<_P extends VelocitySphereType >_P init(final _P _product) {
            _product.radius = ((this.radius == null)?null:this.radius.build());
            _product.center = ((this.center == null)?null:this.center.build());
            _product.radiusUnit = this.radiusUnit;
            return super.init(_product);
        }

        /**
         * Sets the new value of "radius" (any previous value will be replaced)
         * 
         * @param radius
         *     New value of the "radius" property.
         */
        public VelocitySphereType.Builder<_B> withRadius(final Double1Type radius) {
            this.radius = ((radius == null)?null:new Double1Type.Builder<>(this, radius, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "radius"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "radius" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double1Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double1Type.Builder<? extends VelocitySphereType.Builder<_B>> withRadius() {
            if (this.radius!= null) {
                return this.radius;
            }
            return this.radius = new Double1Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "center" (any previous value will be replaced)
         * 
         * @param center
         *     New value of the "center" property.
         */
        public VelocitySphereType.Builder<_B> withCenter(final Double3Type center) {
            this.center = ((center == null)?null:new Double3Type.Builder<>(this, center, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "center"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "center" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double3Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double3Type.Builder<? extends VelocitySphereType.Builder<_B>> withCenter() {
            if (this.center!= null) {
                return this.center;
            }
            return this.center = new Double3Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "radiusUnit" (any previous value will be replaced)
         * 
         * @param radiusUnit
         *     New value of the "radiusUnit" property.
         */
        public VelocitySphereType.Builder<_B> withRadiusUnit(final String radiusUnit) {
            this.radiusUnit = radiusUnit;
            return this;
        }

        /**
         * Sets the new value of "velTimeUnit" (any previous value will be replaced)
         * 
         * @param velTimeUnit
         *     New value of the "velTimeUnit" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withVelTimeUnit(final VelTimeUnitType velTimeUnit) {
            super.withVelTimeUnit(velTimeUnit);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public VelocitySphereType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public VelocitySphereType build() {
            if (_storedValue == null) {
                return this.init(new VelocitySphereType());
            } else {
                return ((VelocitySphereType) _storedValue);
            }
        }

        public VelocitySphereType.Builder<_B> copyOf(final VelocitySphereType _other) {
            _other.copyTo(this);
            return this;
        }

        public VelocitySphereType.Builder<_B> copyOf(final VelocitySphereType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends VelocityIntervalType.Modifier
    {


        public void setRadius(final Double1Type radius) {
            VelocitySphereType.this.setRadius(radius);
        }

        public void setCenter(final Double3Type center) {
            VelocitySphereType.this.setCenter(center);
        }

        public void setRadiusUnit(final String radiusUnit) {
            VelocitySphereType.this.setRadiusUnit(radiusUnit);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<VelocitySphereType, Double1Type> RADIUS = new SinglePropertyInfo<VelocitySphereType,Double1Type>("radius", VelocitySphereType.class, Double1Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Radius"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false) {


            @Override
            public Double1Type get(final VelocitySphereType _instance_) {
                return ((_instance_ == null)?null:_instance_.radius);
            }

            @Override
            public void set(final VelocitySphereType _instance_, final Double1Type _value_) {
                if (_instance_!= null) {
                    _instance_.radius = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<VelocitySphereType, Double3Type> CENTER = new SinglePropertyInfo<VelocitySphereType,Double3Type>("center", VelocitySphereType.class, Double3Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Center"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double3Type"), false) {


            @Override
            public Double3Type get(final VelocitySphereType _instance_) {
                return ((_instance_ == null)?null:_instance_.center);
            }

            @Override
            public void set(final VelocitySphereType _instance_, final Double3Type _value_) {
                if (_instance_!= null) {
                    _instance_.center = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<VelocitySphereType, String> RADIUS_UNIT = new SinglePropertyInfo<VelocitySphereType,String>("radiusUnit", VelocitySphereType.class, String.class, false, "deg", new QName("", "radius_unit"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posUnitType"), true) {


            @Override
            public String get(final VelocitySphereType _instance_) {
                return ((_instance_ == null)?null:_instance_.radiusUnit);
            }

            @Override
            public void set(final VelocitySphereType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.radiusUnit = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends VelocitySphereType.Selector<VelocitySphereType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static VelocitySphereType.Select _root() {
            return new VelocitySphereType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends VelocityIntervalType.Selector<TRoot, TParent>
    {

        private Double1Type.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> radius = null;
        private Double3Type.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> center = null;
        private com.kscs.util.jaxb.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> radiusUnit = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.radius!= null) {
                products.put("radius", this.radius.init());
            }
            if (this.center!= null) {
                products.put("center", this.center.init());
            }
            if (this.radiusUnit!= null) {
                products.put("radiusUnit", this.radiusUnit.init());
            }
            return products;
        }

        public Double1Type.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> radius() {
            return ((this.radius == null)?this.radius = new Double1Type.Selector<>(this._root, this, "radius"):this.radius);
        }

        public Double3Type.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> center() {
            return ((this.center == null)?this.center = new Double3Type.Selector<>(this._root, this, "center"):this.center);
        }

        public com.kscs.util.jaxb.Selector<TRoot, VelocitySphereType.Selector<TRoot, TParent>> radiusUnit() {
            return ((this.radiusUnit == null)?this.radiusUnit = new com.kscs.util.jaxb.Selector<>(this._root, this, "radiusUnit"):this.radiusUnit);
        }

    }

}
