
package org.javastro.ivoa.entities.vodml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * This type represents how to reference a ReferencableElement.
 *         It can serve as base class to those types that explicitly reference another type, such as relations and roles.
 *         It provides for a uniform way to represent the reference to
 *         the target element using the 'utyperef' element.
 *         An important design choice is that we wish to allow references to elements in remote models.
 *         For that reasons we can not use an ID/IDREF or key/keyref pattern.
 *         Instead we define various constraints on
 *         this type and its usage in various contexts using
 *         the Schematron file in vo-dml.sch.xml.
 * 
 * <p>Java class for ElementRef complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ElementRef">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="vodml-ref" type="{http://www.ivoa.net/xml/VODML/v1}VODMLREF"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ElementRef", propOrder = {
    "vodmlRef"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class ElementRef implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The element identifying the referenced target element.
     *             See the documentation for the VODMLREF type.
     * 
     */
    @XmlElement(name = "vodml-ref", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String vodmlRef;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient ElementRef.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ElementRef() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ElementRef(final String vodmlRef) {
        this.vodmlRef = vodmlRef;
    }

    /**
     * The element identifying the referenced target element.
     *             See the documentation for the VODMLREF type.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getVodmlRef() {
        return vodmlRef;
    }

    /**
     * Sets the value of the vodmlRef property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVodmlRef()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setVodmlRef(String value) {
        this.vodmlRef = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ElementRef that = ((ElementRef) object);
        {
            String leftVodmlRef;
            leftVodmlRef = this.getVodmlRef();
            String rightVodmlRef;
            rightVodmlRef = that.getVodmlRef();
            if (this.vodmlRef!= null) {
                if (that.vodmlRef!= null) {
                    if (!leftVodmlRef.equals(rightVodmlRef)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.vodmlRef!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theVodmlRef;
            theVodmlRef = this.getVodmlRef();
            if (this.vodmlRef!= null) {
                currentHashCode += theVodmlRef.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theVodmlRef;
            theVodmlRef = this.getVodmlRef();
            strategy.appendField(locator, this, "vodmlRef", buffer, theVodmlRef, (this.vodmlRef!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ElementRef) {
            final ElementRef target = this;
            final ElementRef leftObject = ((ElementRef) left);
            final ElementRef rightObject = ((ElementRef) right);
            {
                Boolean vodmlRefShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.vodmlRef!= null), (rightObject.vodmlRef!= null));
                if (vodmlRefShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVodmlRef;
                    lhsVodmlRef = leftObject.getVodmlRef();
                    String rhsVodmlRef;
                    rhsVodmlRef = rightObject.getVodmlRef();
                    String mergedVodmlRef = ((String) strategy.merge(LocatorUtils.property(leftLocator, "vodmlRef", lhsVodmlRef), LocatorUtils.property(rightLocator, "vodmlRef", rhsVodmlRef), lhsVodmlRef, rhsVodmlRef, (leftObject.vodmlRef!= null), (rightObject.vodmlRef!= null)));
                    target.setVodmlRef(mergedVodmlRef);
                } else {
                    if (vodmlRefShouldBeMergedAndSet == Boolean.FALSE) {
                        target.vodmlRef = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new ElementRef();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef clone() {
        final ElementRef _newObject;
        try {
            _newObject = ((ElementRef) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef createCopy() {
        final ElementRef _newObject;
        try {
            _newObject = ((ElementRef) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.vodmlRef = this.vodmlRef;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ElementRef _newObject;
        try {
            _newObject = ((ElementRef) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree vodmlRefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlRef"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlRefPropertyTree!= null):((vodmlRefPropertyTree == null)||(!vodmlRefPropertyTree.isLeaf())))) {
            _newObject.vodmlRef = this.vodmlRef;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ElementRef.Modifier();
        }
        return ((ElementRef.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ElementRef.Builder<_B> _other) {
        _other.vodmlRef = this.vodmlRef;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >ElementRef.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ElementRef.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ElementRef.Builder<Void> builder() {
        return new ElementRef.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >ElementRef.Builder<_B> copyOf(final ElementRef _other) {
        final ElementRef.Builder<_B> _newBuilder = new ElementRef.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ElementRef.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree vodmlRefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlRef"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlRefPropertyTree!= null):((vodmlRefPropertyTree == null)||(!vodmlRefPropertyTree.isLeaf())))) {
            _other.vodmlRef = this.vodmlRef;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >ElementRef.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ElementRef.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >ElementRef.Builder<_B> copyOf(final ElementRef _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ElementRef.Builder<_B> _newBuilder = new ElementRef.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ElementRef.Builder<Void> copyExcept(final ElementRef _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static ElementRef.Builder<Void> copyOnly(final ElementRef _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ElementRef visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ElementRef.PropInfo.VODML_REF, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ElementRef _storedValue;
        private String vodmlRef;

        public Builder(final _B _parentBuilder, final ElementRef _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.vodmlRef = _other.vodmlRef;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ElementRef _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree vodmlRefPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlRef"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlRefPropertyTree!= null):((vodmlRefPropertyTree == null)||(!vodmlRefPropertyTree.isLeaf())))) {
                        this.vodmlRef = _other.vodmlRef;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ElementRef >_P init(final _P _product) {
            _product.vodmlRef = this.vodmlRef;
            return _product;
        }

        /**
         * Sets the new value of "vodmlRef" (any previous value will be replaced)
         * 
         * @param vodmlRef
         *     New value of the "vodmlRef" property.
         */
        public ElementRef.Builder<_B> withVodmlRef(final String vodmlRef) {
            this.vodmlRef = vodmlRef;
            return this;
        }

        @Override
        public ElementRef build() {
            if (_storedValue == null) {
                return this.init(new ElementRef());
            } else {
                return ((ElementRef) _storedValue);
            }
        }

        public ElementRef.Builder<_B> copyOf(final ElementRef _other) {
            _other.copyTo(this);
            return this;
        }

        public ElementRef.Builder<_B> copyOf(final ElementRef.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setVodmlRef(final String vodmlRef) {
            ElementRef.this.setVodmlRef(vodmlRef);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ElementRef, String> VODML_REF = new SinglePropertyInfo<ElementRef,String>("vodmlRef", ElementRef.class, String.class, false, null, new QName("", "vodml-ref"), new QName("http://www.ivoa.net/xml/VODML/v1", "VODMLREF"), false) {


            @Override
            public String get(final ElementRef _instance_) {
                return ((_instance_ == null)?null:_instance_.vodmlRef);
            }

            @Override
            public void set(final ElementRef _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.vodmlRef = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ElementRef.Selector<ElementRef.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ElementRef.Select _root() {
            return new ElementRef.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ElementRef.Selector<TRoot, TParent>> vodmlRef = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.vodmlRef!= null) {
                products.put("vodmlRef", this.vodmlRef.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ElementRef.Selector<TRoot, TParent>> vodmlRef() {
            return ((this.vodmlRef == null)?this.vodmlRef = new com.kscs.util.jaxb.Selector<>(this._root, this, "vodmlRef"):this.vodmlRef);
        }

    }

}
