
package org.javastro.ivoa.entities.vodml;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.jaxb.adapters.ZonedDateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Represents a complete data model and is the type of the (single) declared root element for
 *                 VO-DML/XML representation documents.
 * 
 * <p>Java class for Model complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Model">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="name" type="{http://www.ivoa.net/xml/VODML/v1}ModelName"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="identifier" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="uri" type="{http://www.w3.org/2001/XMLSchema}anyURI"/>
 *         <element name="title" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="author" type="{http://www.w3.org/2001/XMLSchema}string" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="version" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         <element name="previousVersion" type="{http://www.w3.org/2001/XMLSchema}anyURI" minOccurs="0"/>
 *         <element name="lastModified" type="{http://www.w3.org/2001/XMLSchema}dateTime"/>
 *         <element name="import" type="{http://www.ivoa.net/xml/VODML/v1}ModelImport" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="primitiveType" type="{http://www.ivoa.net/xml/VODML/v1}PrimitiveType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="enumeration" type="{http://www.ivoa.net/xml/VODML/v1}Enumeration" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="dataType" type="{http://www.ivoa.net/xml/VODML/v1}DataType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="objectType" type="{http://www.ivoa.net/xml/VODML/v1}ObjectType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="package" type="{http://www.ivoa.net/xml/VODML/v1}Package" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="version" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Model", propOrder = {
    "name",
    "description",
    "identifier",
    "uri",
    "title",
    "authors",
    "version",
    "previousVersion",
    "lastModified",
    "imports",
    "primitiveTypes",
    "enumerations",
    "dataTypes",
    "objectTypes",
    "packages"
})
@XmlRootElement(name = "model")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public class Model implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Short name of the model.
     *                         NOTE this name MUST be used as prefix in any utype reference to elements in this model.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String name;
    /**
     * The description of the model.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String description;
    /**
     * A string holding the identifier by which the model is registered in an 
     *                         IVOA compatible registry. Its structure must therefore conform to the IVOA Identifier 
     *                         specification in http://www.ivoa.net/documents/IVOAIdentifiers/. 
     *                         If the model is an IVOA standard, the naming authority for the identifier should be the 
     *                         IVOA DM working group.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String identifier;
    /**
     * Each model has an associated model URI that MUST be used to reference it, for example in ModelImports 
     *                 or in VOTable annotations. 
     *                 Dereferencing the model URI and following redirects yields the latest VO-DML for the data model
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String uri;
    /**
     * The title of the model by which it is officially known.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String title;
    /**
     * List of authors of the model, only defined by name so far.
     *             TBD could be expanded with email, affiliation and so on.
     * 
     */
    @XmlElement(name = "author")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<String> authors;
    /**
     * Label giving the version of the model.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String version;
    /**
     * URI identifying a VO-DML model that is the version from which the current version of model is derived.
     *             TBD could be an IVO Identifier once models get properly registered?
     * 
     */
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String previousVersion;
    /**
     * Timestamp when the last change to the current model was made.
     * 
     */
    @XmlElement(required = true, type = String.class)
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected ZonedDateTime lastModified;
    /**
     * TBD We might require that every data model MUST include a version of the IVOA data model
     *             to gain access to the standard
     *             primitive types and some other types.
     *             We may require that that standard model should be included *completely*,
     *             i.e. including all its type definitions explicitly.
     *             This would be similar to treating it as a UML Profile, rather than an import.
     *             This would mean that the most common type assignments for attributes
     *             can be checked within the model and not require
     *             importing the remote model during validation.
     * 
     */
    @XmlElement(name = "import")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<ModelImport> imports;
    /**
     * Collection of PrimitiveType definitions directly under the model, i.e. not contained in a
     *                         Package.
     * 
     */
    @XmlElement(name = "primitiveType")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<PrimitiveType> primitiveTypes;
    /**
     * Collection of Enumeration definitions directly under the model, i.e. not contained in a Package.
     * 
     */
    @XmlElement(name = "enumeration")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<Enumeration> enumerations;
    /**
     * Collection of DataType definitions directly under the model, i.e. not contained in a Package.
     * 
     */
    @XmlElement(name = "dataType")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<DataType> dataTypes;
    /**
     * Collection of ObjectType definitions directly under the model, i.e. not contained in a Package.
     * 
     */
    @XmlElement(name = "objectType")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<ObjectType> objectTypes;
    /**
     * The collection of packages which can contain further detailed name spacing to
     *                         the type definitions in the model.
     * 
     */
    @XmlElement(name = "package")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected List<Package> packages;
    /**
     * The major.minor version this VO-DML document.
     * 
     */
    @XmlAttribute(name = "version")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String schemaVersion;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient Model.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Model() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Model(final String name, final String description, final String identifier, final String uri, final String title, final List<String> authors, final String version, final String previousVersion, final ZonedDateTime lastModified, final List<ModelImport> imports, final List<PrimitiveType> primitiveTypes, final List<Enumeration> enumerations, final List<DataType> dataTypes, final List<ObjectType> objectTypes, final List<Package> packages, final String schemaVersion) {
        this.name = name;
        this.description = description;
        this.identifier = identifier;
        this.uri = uri;
        this.title = title;
        this.authors = authors;
        this.version = version;
        this.previousVersion = previousVersion;
        this.lastModified = lastModified;
        this.imports = imports;
        this.primitiveTypes = primitiveTypes;
        this.enumerations = enumerations;
        this.dataTypes = dataTypes;
        this.objectTypes = objectTypes;
        this.packages = packages;
        this.schemaVersion = schemaVersion;
    }

    /**
     * Short name of the model.
     *                         NOTE this name MUST be used as prefix in any utype reference to elements in this model.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * The description of the model.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * A string holding the identifier by which the model is registered in an 
     *                         IVOA compatible registry. Its structure must therefore conform to the IVOA Identifier 
     *                         specification in http://www.ivoa.net/documents/IVOAIdentifiers/. 
     *                         If the model is an IVOA standard, the naming authority for the identifier should be the 
     *                         IVOA DM working group.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Sets the value of the identifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIdentifier()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setIdentifier(String value) {
        this.identifier = value;
    }

    /**
     * Each model has an associated model URI that MUST be used to reference it, for example in ModelImports 
     *                 or in VOTable annotations. 
     *                 Dereferencing the model URI and following redirects yields the latest VO-DML for the data model
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getUri() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUri()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setUri(String value) {
        this.uri = value;
    }

    /**
     * The title of the model by which it is officially known.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTitle()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * List of authors of the model, only defined by name so far.
     *             TBD could be expanded with email, affiliation and so on.
     * 
     * Gets the value of the authors property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the authors property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAuthors().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the authors property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<String> getAuthors() {
        if (authors == null) {
            authors = new ArrayList<>();
        }
        return this.authors;
    }

    /**
     * Label giving the version of the model.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setVersion(String value) {
        this.version = value;
    }

    /**
     * URI identifying a VO-DML model that is the version from which the current version of model is derived.
     *             TBD could be an IVO Identifier once models get properly registered?
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getPreviousVersion() {
        return previousVersion;
    }

    /**
     * Sets the value of the previousVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPreviousVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setPreviousVersion(String value) {
        this.previousVersion = value;
    }

    /**
     * Timestamp when the last change to the current model was made.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ZonedDateTime getLastModified() {
        return lastModified;
    }

    /**
     * Sets the value of the lastModified property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getLastModified()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setLastModified(ZonedDateTime value) {
        this.lastModified = value;
    }

    /**
     * TBD We might require that every data model MUST include a version of the IVOA data model
     *             to gain access to the standard
     *             primitive types and some other types.
     *             We may require that that standard model should be included *completely*,
     *             i.e. including all its type definitions explicitly.
     *             This would be similar to treating it as a UML Profile, rather than an import.
     *             This would mean that the most common type assignments for attributes
     *             can be checked within the model and not require
     *             importing the remote model during validation.
     * 
     * Gets the value of the imports property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the imports property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getImports().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ModelImport }
     * </p>
     * 
     * 
     * @return
     *     The value of the imports property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<ModelImport> getImports() {
        if (imports == null) {
            imports = new ArrayList<>();
        }
        return this.imports;
    }

    /**
     * Collection of PrimitiveType definitions directly under the model, i.e. not contained in a
     *                         Package.
     * 
     * Gets the value of the primitiveTypes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the primitiveTypes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPrimitiveTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PrimitiveType }
     * </p>
     * 
     * 
     * @return
     *     The value of the primitiveTypes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<PrimitiveType> getPrimitiveTypes() {
        if (primitiveTypes == null) {
            primitiveTypes = new ArrayList<>();
        }
        return this.primitiveTypes;
    }

    /**
     * Collection of Enumeration definitions directly under the model, i.e. not contained in a Package.
     * 
     * Gets the value of the enumerations property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the enumerations property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEnumerations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Enumeration }
     * </p>
     * 
     * 
     * @return
     *     The value of the enumerations property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<Enumeration> getEnumerations() {
        if (enumerations == null) {
            enumerations = new ArrayList<>();
        }
        return this.enumerations;
    }

    /**
     * Collection of DataType definitions directly under the model, i.e. not contained in a Package.
     * 
     * Gets the value of the dataTypes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dataTypes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDataTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DataType }
     * </p>
     * 
     * 
     * @return
     *     The value of the dataTypes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<DataType> getDataTypes() {
        if (dataTypes == null) {
            dataTypes = new ArrayList<>();
        }
        return this.dataTypes;
    }

    /**
     * Collection of ObjectType definitions directly under the model, i.e. not contained in a Package.
     * 
     * Gets the value of the objectTypes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the objectTypes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getObjectTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ObjectType }
     * </p>
     * 
     * 
     * @return
     *     The value of the objectTypes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<ObjectType> getObjectTypes() {
        if (objectTypes == null) {
            objectTypes = new ArrayList<>();
        }
        return this.objectTypes;
    }

    /**
     * The collection of packages which can contain further detailed name spacing to
     *                         the type definitions in the model.
     * 
     * Gets the value of the packages property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the packages property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPackages().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Package }
     * </p>
     * 
     * 
     * @return
     *     The value of the packages property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public List<Package> getPackages() {
        if (packages == null) {
            packages = new ArrayList<>();
        }
        return this.packages;
    }

    /**
     * The major.minor version this VO-DML document.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * Sets the value of the schemaVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSchemaVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setSchemaVersion(String value) {
        this.schemaVersion = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Model that = ((Model) object);
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            String leftIdentifier;
            leftIdentifier = this.getIdentifier();
            String rightIdentifier;
            rightIdentifier = that.getIdentifier();
            if (this.identifier!= null) {
                if (that.identifier!= null) {
                    if (!leftIdentifier.equals(rightIdentifier)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.identifier!= null) {
                    return false;
                }
            }
        }
        {
            String leftUri;
            leftUri = this.getUri();
            String rightUri;
            rightUri = that.getUri();
            if (this.uri!= null) {
                if (that.uri!= null) {
                    if (!leftUri.equals(rightUri)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.uri!= null) {
                    return false;
                }
            }
        }
        {
            String leftTitle;
            leftTitle = this.getTitle();
            String rightTitle;
            rightTitle = that.getTitle();
            if (this.title!= null) {
                if (that.title!= null) {
                    if (!leftTitle.equals(rightTitle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.title!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftAuthors;
            leftAuthors = (((this.authors!= null)&&(!this.authors.isEmpty()))?this.getAuthors():null);
            List<String> rightAuthors;
            rightAuthors = (((that.authors!= null)&&(!that.authors.isEmpty()))?that.getAuthors():null);
            if ((this.authors!= null)&&(!this.authors.isEmpty())) {
                if ((that.authors!= null)&&(!that.authors.isEmpty())) {
                    if (!leftAuthors.equals(rightAuthors)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.authors!= null)&&(!that.authors.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftVersion;
            leftVersion = this.getVersion();
            String rightVersion;
            rightVersion = that.getVersion();
            if (this.version!= null) {
                if (that.version!= null) {
                    if (!leftVersion.equals(rightVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.version!= null) {
                    return false;
                }
            }
        }
        {
            String leftPreviousVersion;
            leftPreviousVersion = this.getPreviousVersion();
            String rightPreviousVersion;
            rightPreviousVersion = that.getPreviousVersion();
            if (this.previousVersion!= null) {
                if (that.previousVersion!= null) {
                    if (!leftPreviousVersion.equals(rightPreviousVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.previousVersion!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftLastModified;
            leftLastModified = this.getLastModified();
            ZonedDateTime rightLastModified;
            rightLastModified = that.getLastModified();
            if (this.lastModified!= null) {
                if (that.lastModified!= null) {
                    if (!leftLastModified.equals(rightLastModified)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.lastModified!= null) {
                    return false;
                }
            }
        }
        {
            List<ModelImport> leftImports;
            leftImports = (((this.imports!= null)&&(!this.imports.isEmpty()))?this.getImports():null);
            List<ModelImport> rightImports;
            rightImports = (((that.imports!= null)&&(!that.imports.isEmpty()))?that.getImports():null);
            if ((this.imports!= null)&&(!this.imports.isEmpty())) {
                if ((that.imports!= null)&&(!that.imports.isEmpty())) {
                    if (!leftImports.equals(rightImports)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.imports!= null)&&(!that.imports.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<PrimitiveType> leftPrimitiveTypes;
            leftPrimitiveTypes = (((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty()))?this.getPrimitiveTypes():null);
            List<PrimitiveType> rightPrimitiveTypes;
            rightPrimitiveTypes = (((that.primitiveTypes!= null)&&(!that.primitiveTypes.isEmpty()))?that.getPrimitiveTypes():null);
            if ((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty())) {
                if ((that.primitiveTypes!= null)&&(!that.primitiveTypes.isEmpty())) {
                    if (!leftPrimitiveTypes.equals(rightPrimitiveTypes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.primitiveTypes!= null)&&(!that.primitiveTypes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Enumeration> leftEnumerations;
            leftEnumerations = (((this.enumerations!= null)&&(!this.enumerations.isEmpty()))?this.getEnumerations():null);
            List<Enumeration> rightEnumerations;
            rightEnumerations = (((that.enumerations!= null)&&(!that.enumerations.isEmpty()))?that.getEnumerations():null);
            if ((this.enumerations!= null)&&(!this.enumerations.isEmpty())) {
                if ((that.enumerations!= null)&&(!that.enumerations.isEmpty())) {
                    if (!leftEnumerations.equals(rightEnumerations)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.enumerations!= null)&&(!that.enumerations.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<DataType> leftDataTypes;
            leftDataTypes = (((this.dataTypes!= null)&&(!this.dataTypes.isEmpty()))?this.getDataTypes():null);
            List<DataType> rightDataTypes;
            rightDataTypes = (((that.dataTypes!= null)&&(!that.dataTypes.isEmpty()))?that.getDataTypes():null);
            if ((this.dataTypes!= null)&&(!this.dataTypes.isEmpty())) {
                if ((that.dataTypes!= null)&&(!that.dataTypes.isEmpty())) {
                    if (!leftDataTypes.equals(rightDataTypes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.dataTypes!= null)&&(!that.dataTypes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<ObjectType> leftObjectTypes;
            leftObjectTypes = (((this.objectTypes!= null)&&(!this.objectTypes.isEmpty()))?this.getObjectTypes():null);
            List<ObjectType> rightObjectTypes;
            rightObjectTypes = (((that.objectTypes!= null)&&(!that.objectTypes.isEmpty()))?that.getObjectTypes():null);
            if ((this.objectTypes!= null)&&(!this.objectTypes.isEmpty())) {
                if ((that.objectTypes!= null)&&(!that.objectTypes.isEmpty())) {
                    if (!leftObjectTypes.equals(rightObjectTypes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.objectTypes!= null)&&(!that.objectTypes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Package> leftPackages;
            leftPackages = (((this.packages!= null)&&(!this.packages.isEmpty()))?this.getPackages():null);
            List<Package> rightPackages;
            rightPackages = (((that.packages!= null)&&(!that.packages.isEmpty()))?that.getPackages():null);
            if ((this.packages!= null)&&(!this.packages.isEmpty())) {
                if ((that.packages!= null)&&(!that.packages.isEmpty())) {
                    if (!leftPackages.equals(rightPackages)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.packages!= null)&&(!that.packages.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftSchemaVersion;
            leftSchemaVersion = this.getSchemaVersion();
            String rightSchemaVersion;
            rightSchemaVersion = that.getSchemaVersion();
            if (this.schemaVersion!= null) {
                if (that.schemaVersion!= null) {
                    if (!leftSchemaVersion.equals(rightSchemaVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.schemaVersion!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            if (this.identifier!= null) {
                currentHashCode += theIdentifier.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUri;
            theUri = this.getUri();
            if (this.uri!= null) {
                currentHashCode += theUri.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theTitle;
            theTitle = this.getTitle();
            if (this.title!= null) {
                currentHashCode += theTitle.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theAuthors;
            theAuthors = (((this.authors!= null)&&(!this.authors.isEmpty()))?this.getAuthors():null);
            if ((this.authors!= null)&&(!this.authors.isEmpty())) {
                currentHashCode += theAuthors.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theVersion;
            theVersion = this.getVersion();
            if (this.version!= null) {
                currentHashCode += theVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String thePreviousVersion;
            thePreviousVersion = this.getPreviousVersion();
            if (this.previousVersion!= null) {
                currentHashCode += thePreviousVersion.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theLastModified;
            theLastModified = this.getLastModified();
            if (this.lastModified!= null) {
                currentHashCode += theLastModified.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ModelImport> theImports;
            theImports = (((this.imports!= null)&&(!this.imports.isEmpty()))?this.getImports():null);
            if ((this.imports!= null)&&(!this.imports.isEmpty())) {
                currentHashCode += theImports.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<PrimitiveType> thePrimitiveTypes;
            thePrimitiveTypes = (((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty()))?this.getPrimitiveTypes():null);
            if ((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty())) {
                currentHashCode += thePrimitiveTypes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Enumeration> theEnumerations;
            theEnumerations = (((this.enumerations!= null)&&(!this.enumerations.isEmpty()))?this.getEnumerations():null);
            if ((this.enumerations!= null)&&(!this.enumerations.isEmpty())) {
                currentHashCode += theEnumerations.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<DataType> theDataTypes;
            theDataTypes = (((this.dataTypes!= null)&&(!this.dataTypes.isEmpty()))?this.getDataTypes():null);
            if ((this.dataTypes!= null)&&(!this.dataTypes.isEmpty())) {
                currentHashCode += theDataTypes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ObjectType> theObjectTypes;
            theObjectTypes = (((this.objectTypes!= null)&&(!this.objectTypes.isEmpty()))?this.getObjectTypes():null);
            if ((this.objectTypes!= null)&&(!this.objectTypes.isEmpty())) {
                currentHashCode += theObjectTypes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Package> thePackages;
            thePackages = (((this.packages!= null)&&(!this.packages.isEmpty()))?this.getPackages():null);
            if ((this.packages!= null)&&(!this.packages.isEmpty())) {
                currentHashCode += thePackages.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSchemaVersion;
            theSchemaVersion = this.getSchemaVersion();
            if (this.schemaVersion!= null) {
                currentHashCode += theSchemaVersion.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            strategy.appendField(locator, this, "identifier", buffer, theIdentifier, (this.identifier!= null));
        }
        {
            String theUri;
            theUri = this.getUri();
            strategy.appendField(locator, this, "uri", buffer, theUri, (this.uri!= null));
        }
        {
            String theTitle;
            theTitle = this.getTitle();
            strategy.appendField(locator, this, "title", buffer, theTitle, (this.title!= null));
        }
        {
            List<String> theAuthors;
            theAuthors = (((this.authors!= null)&&(!this.authors.isEmpty()))?this.getAuthors():null);
            strategy.appendField(locator, this, "authors", buffer, theAuthors, ((this.authors!= null)&&(!this.authors.isEmpty())));
        }
        {
            String theVersion;
            theVersion = this.getVersion();
            strategy.appendField(locator, this, "version", buffer, theVersion, (this.version!= null));
        }
        {
            String thePreviousVersion;
            thePreviousVersion = this.getPreviousVersion();
            strategy.appendField(locator, this, "previousVersion", buffer, thePreviousVersion, (this.previousVersion!= null));
        }
        {
            ZonedDateTime theLastModified;
            theLastModified = this.getLastModified();
            strategy.appendField(locator, this, "lastModified", buffer, theLastModified, (this.lastModified!= null));
        }
        {
            List<ModelImport> theImports;
            theImports = (((this.imports!= null)&&(!this.imports.isEmpty()))?this.getImports():null);
            strategy.appendField(locator, this, "imports", buffer, theImports, ((this.imports!= null)&&(!this.imports.isEmpty())));
        }
        {
            List<PrimitiveType> thePrimitiveTypes;
            thePrimitiveTypes = (((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty()))?this.getPrimitiveTypes():null);
            strategy.appendField(locator, this, "primitiveTypes", buffer, thePrimitiveTypes, ((this.primitiveTypes!= null)&&(!this.primitiveTypes.isEmpty())));
        }
        {
            List<Enumeration> theEnumerations;
            theEnumerations = (((this.enumerations!= null)&&(!this.enumerations.isEmpty()))?this.getEnumerations():null);
            strategy.appendField(locator, this, "enumerations", buffer, theEnumerations, ((this.enumerations!= null)&&(!this.enumerations.isEmpty())));
        }
        {
            List<DataType> theDataTypes;
            theDataTypes = (((this.dataTypes!= null)&&(!this.dataTypes.isEmpty()))?this.getDataTypes():null);
            strategy.appendField(locator, this, "dataTypes", buffer, theDataTypes, ((this.dataTypes!= null)&&(!this.dataTypes.isEmpty())));
        }
        {
            List<ObjectType> theObjectTypes;
            theObjectTypes = (((this.objectTypes!= null)&&(!this.objectTypes.isEmpty()))?this.getObjectTypes():null);
            strategy.appendField(locator, this, "objectTypes", buffer, theObjectTypes, ((this.objectTypes!= null)&&(!this.objectTypes.isEmpty())));
        }
        {
            List<Package> thePackages;
            thePackages = (((this.packages!= null)&&(!this.packages.isEmpty()))?this.getPackages():null);
            strategy.appendField(locator, this, "packages", buffer, thePackages, ((this.packages!= null)&&(!this.packages.isEmpty())));
        }
        {
            String theSchemaVersion;
            theSchemaVersion = this.getSchemaVersion();
            strategy.appendField(locator, this, "schemaVersion", buffer, theSchemaVersion, (this.schemaVersion!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Model) {
            final Model target = this;
            final Model leftObject = ((Model) left);
            final Model rightObject = ((Model) right);
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean identifierShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.identifier!= null), (rightObject.identifier!= null));
                if (identifierShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIdentifier;
                    lhsIdentifier = leftObject.getIdentifier();
                    String rhsIdentifier;
                    rhsIdentifier = rightObject.getIdentifier();
                    String mergedIdentifier = ((String) strategy.merge(LocatorUtils.property(leftLocator, "identifier", lhsIdentifier), LocatorUtils.property(rightLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, (leftObject.identifier!= null), (rightObject.identifier!= null)));
                    target.setIdentifier(mergedIdentifier);
                } else {
                    if (identifierShouldBeMergedAndSet == Boolean.FALSE) {
                        target.identifier = null;
                    }
                }
            }
            {
                Boolean uriShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.uri!= null), (rightObject.uri!= null));
                if (uriShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUri;
                    lhsUri = leftObject.getUri();
                    String rhsUri;
                    rhsUri = rightObject.getUri();
                    String mergedUri = ((String) strategy.merge(LocatorUtils.property(leftLocator, "uri", lhsUri), LocatorUtils.property(rightLocator, "uri", rhsUri), lhsUri, rhsUri, (leftObject.uri!= null), (rightObject.uri!= null)));
                    target.setUri(mergedUri);
                } else {
                    if (uriShouldBeMergedAndSet == Boolean.FALSE) {
                        target.uri = null;
                    }
                }
            }
            {
                Boolean titleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.title!= null), (rightObject.title!= null));
                if (titleShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTitle;
                    lhsTitle = leftObject.getTitle();
                    String rhsTitle;
                    rhsTitle = rightObject.getTitle();
                    String mergedTitle = ((String) strategy.merge(LocatorUtils.property(leftLocator, "title", lhsTitle), LocatorUtils.property(rightLocator, "title", rhsTitle), lhsTitle, rhsTitle, (leftObject.title!= null), (rightObject.title!= null)));
                    target.setTitle(mergedTitle);
                } else {
                    if (titleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.title = null;
                    }
                }
            }
            {
                Boolean authorsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.authors!= null)&&(!leftObject.authors.isEmpty())), ((rightObject.authors!= null)&&(!rightObject.authors.isEmpty())));
                if (authorsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsAuthors;
                    lhsAuthors = (((leftObject.authors!= null)&&(!leftObject.authors.isEmpty()))?leftObject.getAuthors():null);
                    List<String> rhsAuthors;
                    rhsAuthors = (((rightObject.authors!= null)&&(!rightObject.authors.isEmpty()))?rightObject.getAuthors():null);
                    List<String> mergedAuthors = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "authors", lhsAuthors), LocatorUtils.property(rightLocator, "authors", rhsAuthors), lhsAuthors, rhsAuthors, ((leftObject.authors!= null)&&(!leftObject.authors.isEmpty())), ((rightObject.authors!= null)&&(!rightObject.authors.isEmpty()))));
                    target.authors = null;
                    if (mergedAuthors!= null) {
                        List<String> uniqueAuthorsl = target.getAuthors();
                        uniqueAuthorsl.addAll(mergedAuthors);
                    }
                } else {
                    if (authorsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.authors = null;
                    }
                }
            }
            {
                Boolean versionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.version!= null), (rightObject.version!= null));
                if (versionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVersion;
                    lhsVersion = leftObject.getVersion();
                    String rhsVersion;
                    rhsVersion = rightObject.getVersion();
                    String mergedVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "version", lhsVersion), LocatorUtils.property(rightLocator, "version", rhsVersion), lhsVersion, rhsVersion, (leftObject.version!= null), (rightObject.version!= null)));
                    target.setVersion(mergedVersion);
                } else {
                    if (versionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.version = null;
                    }
                }
            }
            {
                Boolean previousVersionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.previousVersion!= null), (rightObject.previousVersion!= null));
                if (previousVersionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsPreviousVersion;
                    lhsPreviousVersion = leftObject.getPreviousVersion();
                    String rhsPreviousVersion;
                    rhsPreviousVersion = rightObject.getPreviousVersion();
                    String mergedPreviousVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "previousVersion", lhsPreviousVersion), LocatorUtils.property(rightLocator, "previousVersion", rhsPreviousVersion), lhsPreviousVersion, rhsPreviousVersion, (leftObject.previousVersion!= null), (rightObject.previousVersion!= null)));
                    target.setPreviousVersion(mergedPreviousVersion);
                } else {
                    if (previousVersionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.previousVersion = null;
                    }
                }
            }
            {
                Boolean lastModifiedShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.lastModified!= null), (rightObject.lastModified!= null));
                if (lastModifiedShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsLastModified;
                    lhsLastModified = leftObject.getLastModified();
                    ZonedDateTime rhsLastModified;
                    rhsLastModified = rightObject.getLastModified();
                    ZonedDateTime mergedLastModified = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "lastModified", lhsLastModified), LocatorUtils.property(rightLocator, "lastModified", rhsLastModified), lhsLastModified, rhsLastModified, (leftObject.lastModified!= null), (rightObject.lastModified!= null)));
                    target.setLastModified(mergedLastModified);
                } else {
                    if (lastModifiedShouldBeMergedAndSet == Boolean.FALSE) {
                        target.lastModified = null;
                    }
                }
            }
            {
                Boolean importsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.imports!= null)&&(!leftObject.imports.isEmpty())), ((rightObject.imports!= null)&&(!rightObject.imports.isEmpty())));
                if (importsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ModelImport> lhsImports;
                    lhsImports = (((leftObject.imports!= null)&&(!leftObject.imports.isEmpty()))?leftObject.getImports():null);
                    List<ModelImport> rhsImports;
                    rhsImports = (((rightObject.imports!= null)&&(!rightObject.imports.isEmpty()))?rightObject.getImports():null);
                    List<ModelImport> mergedImports = ((List<ModelImport> ) strategy.merge(LocatorUtils.property(leftLocator, "imports", lhsImports), LocatorUtils.property(rightLocator, "imports", rhsImports), lhsImports, rhsImports, ((leftObject.imports!= null)&&(!leftObject.imports.isEmpty())), ((rightObject.imports!= null)&&(!rightObject.imports.isEmpty()))));
                    target.imports = null;
                    if (mergedImports!= null) {
                        List<ModelImport> uniqueImportsl = target.getImports();
                        uniqueImportsl.addAll(mergedImports);
                    }
                } else {
                    if (importsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.imports = null;
                    }
                }
            }
            {
                Boolean primitiveTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.primitiveTypes!= null)&&(!leftObject.primitiveTypes.isEmpty())), ((rightObject.primitiveTypes!= null)&&(!rightObject.primitiveTypes.isEmpty())));
                if (primitiveTypesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<PrimitiveType> lhsPrimitiveTypes;
                    lhsPrimitiveTypes = (((leftObject.primitiveTypes!= null)&&(!leftObject.primitiveTypes.isEmpty()))?leftObject.getPrimitiveTypes():null);
                    List<PrimitiveType> rhsPrimitiveTypes;
                    rhsPrimitiveTypes = (((rightObject.primitiveTypes!= null)&&(!rightObject.primitiveTypes.isEmpty()))?rightObject.getPrimitiveTypes():null);
                    List<PrimitiveType> mergedPrimitiveTypes = ((List<PrimitiveType> ) strategy.merge(LocatorUtils.property(leftLocator, "primitiveTypes", lhsPrimitiveTypes), LocatorUtils.property(rightLocator, "primitiveTypes", rhsPrimitiveTypes), lhsPrimitiveTypes, rhsPrimitiveTypes, ((leftObject.primitiveTypes!= null)&&(!leftObject.primitiveTypes.isEmpty())), ((rightObject.primitiveTypes!= null)&&(!rightObject.primitiveTypes.isEmpty()))));
                    target.primitiveTypes = null;
                    if (mergedPrimitiveTypes!= null) {
                        List<PrimitiveType> uniquePrimitiveTypesl = target.getPrimitiveTypes();
                        uniquePrimitiveTypesl.addAll(mergedPrimitiveTypes);
                    }
                } else {
                    if (primitiveTypesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.primitiveTypes = null;
                    }
                }
            }
            {
                Boolean enumerationsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.enumerations!= null)&&(!leftObject.enumerations.isEmpty())), ((rightObject.enumerations!= null)&&(!rightObject.enumerations.isEmpty())));
                if (enumerationsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Enumeration> lhsEnumerations;
                    lhsEnumerations = (((leftObject.enumerations!= null)&&(!leftObject.enumerations.isEmpty()))?leftObject.getEnumerations():null);
                    List<Enumeration> rhsEnumerations;
                    rhsEnumerations = (((rightObject.enumerations!= null)&&(!rightObject.enumerations.isEmpty()))?rightObject.getEnumerations():null);
                    List<Enumeration> mergedEnumerations = ((List<Enumeration> ) strategy.merge(LocatorUtils.property(leftLocator, "enumerations", lhsEnumerations), LocatorUtils.property(rightLocator, "enumerations", rhsEnumerations), lhsEnumerations, rhsEnumerations, ((leftObject.enumerations!= null)&&(!leftObject.enumerations.isEmpty())), ((rightObject.enumerations!= null)&&(!rightObject.enumerations.isEmpty()))));
                    target.enumerations = null;
                    if (mergedEnumerations!= null) {
                        List<Enumeration> uniqueEnumerationsl = target.getEnumerations();
                        uniqueEnumerationsl.addAll(mergedEnumerations);
                    }
                } else {
                    if (enumerationsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.enumerations = null;
                    }
                }
            }
            {
                Boolean dataTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.dataTypes!= null)&&(!leftObject.dataTypes.isEmpty())), ((rightObject.dataTypes!= null)&&(!rightObject.dataTypes.isEmpty())));
                if (dataTypesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<DataType> lhsDataTypes;
                    lhsDataTypes = (((leftObject.dataTypes!= null)&&(!leftObject.dataTypes.isEmpty()))?leftObject.getDataTypes():null);
                    List<DataType> rhsDataTypes;
                    rhsDataTypes = (((rightObject.dataTypes!= null)&&(!rightObject.dataTypes.isEmpty()))?rightObject.getDataTypes():null);
                    List<DataType> mergedDataTypes = ((List<DataType> ) strategy.merge(LocatorUtils.property(leftLocator, "dataTypes", lhsDataTypes), LocatorUtils.property(rightLocator, "dataTypes", rhsDataTypes), lhsDataTypes, rhsDataTypes, ((leftObject.dataTypes!= null)&&(!leftObject.dataTypes.isEmpty())), ((rightObject.dataTypes!= null)&&(!rightObject.dataTypes.isEmpty()))));
                    target.dataTypes = null;
                    if (mergedDataTypes!= null) {
                        List<DataType> uniqueDataTypesl = target.getDataTypes();
                        uniqueDataTypesl.addAll(mergedDataTypes);
                    }
                } else {
                    if (dataTypesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.dataTypes = null;
                    }
                }
            }
            {
                Boolean objectTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.objectTypes!= null)&&(!leftObject.objectTypes.isEmpty())), ((rightObject.objectTypes!= null)&&(!rightObject.objectTypes.isEmpty())));
                if (objectTypesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ObjectType> lhsObjectTypes;
                    lhsObjectTypes = (((leftObject.objectTypes!= null)&&(!leftObject.objectTypes.isEmpty()))?leftObject.getObjectTypes():null);
                    List<ObjectType> rhsObjectTypes;
                    rhsObjectTypes = (((rightObject.objectTypes!= null)&&(!rightObject.objectTypes.isEmpty()))?rightObject.getObjectTypes():null);
                    List<ObjectType> mergedObjectTypes = ((List<ObjectType> ) strategy.merge(LocatorUtils.property(leftLocator, "objectTypes", lhsObjectTypes), LocatorUtils.property(rightLocator, "objectTypes", rhsObjectTypes), lhsObjectTypes, rhsObjectTypes, ((leftObject.objectTypes!= null)&&(!leftObject.objectTypes.isEmpty())), ((rightObject.objectTypes!= null)&&(!rightObject.objectTypes.isEmpty()))));
                    target.objectTypes = null;
                    if (mergedObjectTypes!= null) {
                        List<ObjectType> uniqueObjectTypesl = target.getObjectTypes();
                        uniqueObjectTypesl.addAll(mergedObjectTypes);
                    }
                } else {
                    if (objectTypesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.objectTypes = null;
                    }
                }
            }
            {
                Boolean packagesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.packages!= null)&&(!leftObject.packages.isEmpty())), ((rightObject.packages!= null)&&(!rightObject.packages.isEmpty())));
                if (packagesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Package> lhsPackages;
                    lhsPackages = (((leftObject.packages!= null)&&(!leftObject.packages.isEmpty()))?leftObject.getPackages():null);
                    List<Package> rhsPackages;
                    rhsPackages = (((rightObject.packages!= null)&&(!rightObject.packages.isEmpty()))?rightObject.getPackages():null);
                    List<Package> mergedPackages = ((List<Package> ) strategy.merge(LocatorUtils.property(leftLocator, "packages", lhsPackages), LocatorUtils.property(rightLocator, "packages", rhsPackages), lhsPackages, rhsPackages, ((leftObject.packages!= null)&&(!leftObject.packages.isEmpty())), ((rightObject.packages!= null)&&(!rightObject.packages.isEmpty()))));
                    target.packages = null;
                    if (mergedPackages!= null) {
                        List<Package> uniquePackagesl = target.getPackages();
                        uniquePackagesl.addAll(mergedPackages);
                    }
                } else {
                    if (packagesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.packages = null;
                    }
                }
            }
            {
                Boolean schemaVersionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.schemaVersion!= null), (rightObject.schemaVersion!= null));
                if (schemaVersionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsSchemaVersion;
                    lhsSchemaVersion = leftObject.getSchemaVersion();
                    String rhsSchemaVersion;
                    rhsSchemaVersion = rightObject.getSchemaVersion();
                    String mergedSchemaVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "schemaVersion", lhsSchemaVersion), LocatorUtils.property(rightLocator, "schemaVersion", rhsSchemaVersion), lhsSchemaVersion, rhsSchemaVersion, (leftObject.schemaVersion!= null), (rightObject.schemaVersion!= null)));
                    target.setSchemaVersion(mergedSchemaVersion);
                } else {
                    if (schemaVersionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.schemaVersion = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Object createNewInstance() {
        return new Model();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model clone() {
        final Model _newObject;
        try {
            _newObject = ((Model) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.authors = ((this.authors == null)?null:new ArrayList<>(this.authors));
        if (this.imports == null) {
            _newObject.imports = null;
        } else {
            _newObject.imports = new ArrayList<>();
            for (ModelImport _item: this.imports) {
                _newObject.imports.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.primitiveTypes == null) {
            _newObject.primitiveTypes = null;
        } else {
            _newObject.primitiveTypes = new ArrayList<>();
            for (PrimitiveType _item: this.primitiveTypes) {
                _newObject.primitiveTypes.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.enumerations == null) {
            _newObject.enumerations = null;
        } else {
            _newObject.enumerations = new ArrayList<>();
            for (Enumeration _item: this.enumerations) {
                _newObject.enumerations.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.dataTypes == null) {
            _newObject.dataTypes = null;
        } else {
            _newObject.dataTypes = new ArrayList<>();
            for (DataType _item: this.dataTypes) {
                _newObject.dataTypes.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.objectTypes == null) {
            _newObject.objectTypes = null;
        } else {
            _newObject.objectTypes = new ArrayList<>();
            for (ObjectType _item: this.objectTypes) {
                _newObject.objectTypes.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.packages == null) {
            _newObject.packages = null;
        } else {
            _newObject.packages = new ArrayList<>();
            for (Package _item: this.packages) {
                _newObject.packages.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model createCopy() {
        final Model _newObject;
        try {
            _newObject = ((Model) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.name = this.name;
        _newObject.description = this.description;
        _newObject.identifier = this.identifier;
        _newObject.uri = this.uri;
        _newObject.title = this.title;
        _newObject.authors = ((this.authors == null)?null:new ArrayList<>(this.authors));
        _newObject.version = this.version;
        _newObject.previousVersion = this.previousVersion;
        _newObject.lastModified = this.lastModified;
        if (this.imports == null) {
            _newObject.imports = null;
        } else {
            _newObject.imports = new ArrayList<>();
            for (ModelImport _item: this.imports) {
                _newObject.imports.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.primitiveTypes == null) {
            _newObject.primitiveTypes = null;
        } else {
            _newObject.primitiveTypes = new ArrayList<>();
            for (PrimitiveType _item: this.primitiveTypes) {
                _newObject.primitiveTypes.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.enumerations == null) {
            _newObject.enumerations = null;
        } else {
            _newObject.enumerations = new ArrayList<>();
            for (Enumeration _item: this.enumerations) {
                _newObject.enumerations.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.dataTypes == null) {
            _newObject.dataTypes = null;
        } else {
            _newObject.dataTypes = new ArrayList<>();
            for (DataType _item: this.dataTypes) {
                _newObject.dataTypes.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.objectTypes == null) {
            _newObject.objectTypes = null;
        } else {
            _newObject.objectTypes = new ArrayList<>();
            for (ObjectType _item: this.objectTypes) {
                _newObject.objectTypes.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.packages == null) {
            _newObject.packages = null;
        } else {
            _newObject.packages = new ArrayList<>();
            for (Package _item: this.packages) {
                _newObject.packages.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.schemaVersion = this.schemaVersion;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Model _newObject;
        try {
            _newObject = ((Model) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _newObject.identifier = this.identifier;
        }
        final PropertyTree uriPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uri"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uriPropertyTree!= null):((uriPropertyTree == null)||(!uriPropertyTree.isLeaf())))) {
            _newObject.uri = this.uri;
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _newObject.title = this.title;
        }
        final PropertyTree authorsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("authors"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(authorsPropertyTree!= null):((authorsPropertyTree == null)||(!authorsPropertyTree.isLeaf())))) {
            _newObject.authors = ((this.authors == null)?null:new ArrayList<>(this.authors));
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _newObject.version = this.version;
        }
        final PropertyTree previousVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("previousVersion"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(previousVersionPropertyTree!= null):((previousVersionPropertyTree == null)||(!previousVersionPropertyTree.isLeaf())))) {
            _newObject.previousVersion = this.previousVersion;
        }
        final PropertyTree lastModifiedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lastModified"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(lastModifiedPropertyTree!= null):((lastModifiedPropertyTree == null)||(!lastModifiedPropertyTree.isLeaf())))) {
            _newObject.lastModified = this.lastModified;
        }
        final PropertyTree importsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imports"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(importsPropertyTree!= null):((importsPropertyTree == null)||(!importsPropertyTree.isLeaf())))) {
            if (this.imports == null) {
                _newObject.imports = null;
            } else {
                _newObject.imports = new ArrayList<>();
                for (ModelImport _item: this.imports) {
                    _newObject.imports.add(((_item == null)?null:_item.createCopy(importsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree primitiveTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("primitiveTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(primitiveTypesPropertyTree!= null):((primitiveTypesPropertyTree == null)||(!primitiveTypesPropertyTree.isLeaf())))) {
            if (this.primitiveTypes == null) {
                _newObject.primitiveTypes = null;
            } else {
                _newObject.primitiveTypes = new ArrayList<>();
                for (PrimitiveType _item: this.primitiveTypes) {
                    _newObject.primitiveTypes.add(((_item == null)?null:_item.createCopy(primitiveTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree enumerationsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("enumerations"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(enumerationsPropertyTree!= null):((enumerationsPropertyTree == null)||(!enumerationsPropertyTree.isLeaf())))) {
            if (this.enumerations == null) {
                _newObject.enumerations = null;
            } else {
                _newObject.enumerations = new ArrayList<>();
                for (Enumeration _item: this.enumerations) {
                    _newObject.enumerations.add(((_item == null)?null:_item.createCopy(enumerationsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree dataTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataTypesPropertyTree!= null):((dataTypesPropertyTree == null)||(!dataTypesPropertyTree.isLeaf())))) {
            if (this.dataTypes == null) {
                _newObject.dataTypes = null;
            } else {
                _newObject.dataTypes = new ArrayList<>();
                for (DataType _item: this.dataTypes) {
                    _newObject.dataTypes.add(((_item == null)?null:_item.createCopy(dataTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree objectTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("objectTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(objectTypesPropertyTree!= null):((objectTypesPropertyTree == null)||(!objectTypesPropertyTree.isLeaf())))) {
            if (this.objectTypes == null) {
                _newObject.objectTypes = null;
            } else {
                _newObject.objectTypes = new ArrayList<>();
                for (ObjectType _item: this.objectTypes) {
                    _newObject.objectTypes.add(((_item == null)?null:_item.createCopy(objectTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree packagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("packages"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(packagesPropertyTree!= null):((packagesPropertyTree == null)||(!packagesPropertyTree.isLeaf())))) {
            if (this.packages == null) {
                _newObject.packages = null;
            } else {
                _newObject.packages = new ArrayList<>();
                for (Package _item: this.packages) {
                    _newObject.packages.add(((_item == null)?null:_item.createCopy(packagesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree schemaVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemaVersion"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemaVersionPropertyTree!= null):((schemaVersionPropertyTree == null)||(!schemaVersionPropertyTree.isLeaf())))) {
            _newObject.schemaVersion = this.schemaVersion;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Model.Modifier();
        }
        return ((Model.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final Model.Builder<_B> _other) {
        _other.name = this.name;
        _other.description = this.description;
        _other.identifier = this.identifier;
        _other.uri = this.uri;
        _other.title = this.title;
        if (this.authors == null) {
            _other.authors = null;
        } else {
            _other.authors = new ArrayList<>();
            for (String _item: this.authors) {
                _other.authors.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.version = this.version;
        _other.previousVersion = this.previousVersion;
        _other.lastModified = this.lastModified;
        if (this.imports == null) {
            _other.imports = null;
        } else {
            _other.imports = new ArrayList<>();
            for (ModelImport _item: this.imports) {
                _other.imports.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.primitiveTypes == null) {
            _other.primitiveTypes = null;
        } else {
            _other.primitiveTypes = new ArrayList<>();
            for (PrimitiveType _item: this.primitiveTypes) {
                _other.primitiveTypes.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.enumerations == null) {
            _other.enumerations = null;
        } else {
            _other.enumerations = new ArrayList<>();
            for (Enumeration _item: this.enumerations) {
                _other.enumerations.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.dataTypes == null) {
            _other.dataTypes = null;
        } else {
            _other.dataTypes = new ArrayList<>();
            for (DataType _item: this.dataTypes) {
                _other.dataTypes.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.objectTypes == null) {
            _other.objectTypes = null;
        } else {
            _other.objectTypes = new ArrayList<>();
            for (ObjectType _item: this.objectTypes) {
                _other.objectTypes.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.packages == null) {
            _other.packages = null;
        } else {
            _other.packages = new ArrayList<>();
            for (Package _item: this.packages) {
                _other.packages.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.schemaVersion = this.schemaVersion;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >Model.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Model.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Model.Builder<Void> builder() {
        return new Model.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >Model.Builder<_B> copyOf(final Model _other) {
        final Model.Builder<_B> _newBuilder = new Model.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final Model.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _other.identifier = this.identifier;
        }
        final PropertyTree uriPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uri"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uriPropertyTree!= null):((uriPropertyTree == null)||(!uriPropertyTree.isLeaf())))) {
            _other.uri = this.uri;
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _other.title = this.title;
        }
        final PropertyTree authorsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("authors"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(authorsPropertyTree!= null):((authorsPropertyTree == null)||(!authorsPropertyTree.isLeaf())))) {
            if (this.authors == null) {
                _other.authors = null;
            } else {
                _other.authors = new ArrayList<>();
                for (String _item: this.authors) {
                    _other.authors.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _other.version = this.version;
        }
        final PropertyTree previousVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("previousVersion"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(previousVersionPropertyTree!= null):((previousVersionPropertyTree == null)||(!previousVersionPropertyTree.isLeaf())))) {
            _other.previousVersion = this.previousVersion;
        }
        final PropertyTree lastModifiedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lastModified"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(lastModifiedPropertyTree!= null):((lastModifiedPropertyTree == null)||(!lastModifiedPropertyTree.isLeaf())))) {
            _other.lastModified = this.lastModified;
        }
        final PropertyTree importsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imports"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(importsPropertyTree!= null):((importsPropertyTree == null)||(!importsPropertyTree.isLeaf())))) {
            if (this.imports == null) {
                _other.imports = null;
            } else {
                _other.imports = new ArrayList<>();
                for (ModelImport _item: this.imports) {
                    _other.imports.add(((_item == null)?null:_item.newCopyBuilder(_other, importsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree primitiveTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("primitiveTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(primitiveTypesPropertyTree!= null):((primitiveTypesPropertyTree == null)||(!primitiveTypesPropertyTree.isLeaf())))) {
            if (this.primitiveTypes == null) {
                _other.primitiveTypes = null;
            } else {
                _other.primitiveTypes = new ArrayList<>();
                for (PrimitiveType _item: this.primitiveTypes) {
                    _other.primitiveTypes.add(((_item == null)?null:_item.newCopyBuilder(_other, primitiveTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree enumerationsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("enumerations"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(enumerationsPropertyTree!= null):((enumerationsPropertyTree == null)||(!enumerationsPropertyTree.isLeaf())))) {
            if (this.enumerations == null) {
                _other.enumerations = null;
            } else {
                _other.enumerations = new ArrayList<>();
                for (Enumeration _item: this.enumerations) {
                    _other.enumerations.add(((_item == null)?null:_item.newCopyBuilder(_other, enumerationsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree dataTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataTypesPropertyTree!= null):((dataTypesPropertyTree == null)||(!dataTypesPropertyTree.isLeaf())))) {
            if (this.dataTypes == null) {
                _other.dataTypes = null;
            } else {
                _other.dataTypes = new ArrayList<>();
                for (DataType _item: this.dataTypes) {
                    _other.dataTypes.add(((_item == null)?null:_item.newCopyBuilder(_other, dataTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree objectTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("objectTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(objectTypesPropertyTree!= null):((objectTypesPropertyTree == null)||(!objectTypesPropertyTree.isLeaf())))) {
            if (this.objectTypes == null) {
                _other.objectTypes = null;
            } else {
                _other.objectTypes = new ArrayList<>();
                for (ObjectType _item: this.objectTypes) {
                    _other.objectTypes.add(((_item == null)?null:_item.newCopyBuilder(_other, objectTypesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree packagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("packages"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(packagesPropertyTree!= null):((packagesPropertyTree == null)||(!packagesPropertyTree.isLeaf())))) {
            if (this.packages == null) {
                _other.packages = null;
            } else {
                _other.packages = new ArrayList<>();
                for (Package _item: this.packages) {
                    _other.packages.add(((_item == null)?null:_item.newCopyBuilder(_other, packagesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree schemaVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemaVersion"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemaVersionPropertyTree!= null):((schemaVersionPropertyTree == null)||(!schemaVersionPropertyTree.isLeaf())))) {
            _other.schemaVersion = this.schemaVersion;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >Model.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Model.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static<_B >Model.Builder<_B> copyOf(final Model _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Model.Builder<_B> _newBuilder = new Model.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Model.Builder<Void> copyExcept(final Model _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public static Model.Builder<Void> copyOnly(final Model _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public Model visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.NAME, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.DESCRIPTION, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.IDENTIFIER, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.URI, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.TITLE, this));
        _visitor_.visit(new CollectionProperty<>(Model.PropInfo.AUTHORS, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.VERSION, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.PREVIOUS_VERSION, this));
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.LAST_MODIFIED, this));
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.IMPORTS, this))&&(this.imports!= null)) {
            for (ModelImport _item_: this.imports) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.PRIMITIVE_TYPES, this))&&(this.primitiveTypes!= null)) {
            for (PrimitiveType _item_: this.primitiveTypes) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.ENUMERATIONS, this))&&(this.enumerations!= null)) {
            for (Enumeration _item_: this.enumerations) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.DATA_TYPES, this))&&(this.dataTypes!= null)) {
            for (DataType _item_: this.dataTypes) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.OBJECT_TYPES, this))&&(this.objectTypes!= null)) {
            for (ObjectType _item_: this.objectTypes) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Model.PropInfo.PACKAGES, this))&&(this.packages!= null)) {
            for (Package _item_: this.packages) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Model.PropInfo.SCHEMA_VERSION, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Model _storedValue;
        private String name;
        private String description;
        private String identifier;
        private String uri;
        private String title;
        private List<Buildable> authors;
        private String version;
        private String previousVersion;
        private ZonedDateTime lastModified;
        private List<ModelImport.Builder<Model.Builder<_B>>> imports;
        private List<PrimitiveType.Builder<Model.Builder<_B>>> primitiveTypes;
        private List<Enumeration.Builder<Model.Builder<_B>>> enumerations;
        private List<DataType.Builder<Model.Builder<_B>>> dataTypes;
        private List<ObjectType.Builder<Model.Builder<_B>>> objectTypes;
        private List<Package.Builder<Model.Builder<_B>>> packages;
        private String schemaVersion;

        public Builder(final _B _parentBuilder, final Model _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.name = _other.name;
                    this.description = _other.description;
                    this.identifier = _other.identifier;
                    this.uri = _other.uri;
                    this.title = _other.title;
                    if (_other.authors == null) {
                        this.authors = null;
                    } else {
                        this.authors = new ArrayList<>();
                        for (String _item: _other.authors) {
                            this.authors.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.version = _other.version;
                    this.previousVersion = _other.previousVersion;
                    this.lastModified = _other.lastModified;
                    if (_other.imports == null) {
                        this.imports = null;
                    } else {
                        this.imports = new ArrayList<>();
                        for (ModelImport _item: _other.imports) {
                            this.imports.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    if (_other.primitiveTypes == null) {
                        this.primitiveTypes = null;
                    } else {
                        this.primitiveTypes = new ArrayList<>();
                        for (PrimitiveType _item: _other.primitiveTypes) {
                            this.primitiveTypes.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    if (_other.enumerations == null) {
                        this.enumerations = null;
                    } else {
                        this.enumerations = new ArrayList<>();
                        for (Enumeration _item: _other.enumerations) {
                            this.enumerations.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    if (_other.dataTypes == null) {
                        this.dataTypes = null;
                    } else {
                        this.dataTypes = new ArrayList<>();
                        for (DataType _item: _other.dataTypes) {
                            this.dataTypes.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    if (_other.objectTypes == null) {
                        this.objectTypes = null;
                    } else {
                        this.objectTypes = new ArrayList<>();
                        for (ObjectType _item: _other.objectTypes) {
                            this.objectTypes.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    if (_other.packages == null) {
                        this.packages = null;
                    } else {
                        this.packages = new ArrayList<>();
                        for (Package _item: _other.packages) {
                            this.packages.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.schemaVersion = _other.schemaVersion;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Model _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
                        this.identifier = _other.identifier;
                    }
                    final PropertyTree uriPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uri"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uriPropertyTree!= null):((uriPropertyTree == null)||(!uriPropertyTree.isLeaf())))) {
                        this.uri = _other.uri;
                    }
                    final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
                        this.title = _other.title;
                    }
                    final PropertyTree authorsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("authors"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(authorsPropertyTree!= null):((authorsPropertyTree == null)||(!authorsPropertyTree.isLeaf())))) {
                        if (_other.authors == null) {
                            this.authors = null;
                        } else {
                            this.authors = new ArrayList<>();
                            for (String _item: _other.authors) {
                                this.authors.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
                        this.version = _other.version;
                    }
                    final PropertyTree previousVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("previousVersion"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(previousVersionPropertyTree!= null):((previousVersionPropertyTree == null)||(!previousVersionPropertyTree.isLeaf())))) {
                        this.previousVersion = _other.previousVersion;
                    }
                    final PropertyTree lastModifiedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lastModified"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(lastModifiedPropertyTree!= null):((lastModifiedPropertyTree == null)||(!lastModifiedPropertyTree.isLeaf())))) {
                        this.lastModified = _other.lastModified;
                    }
                    final PropertyTree importsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imports"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(importsPropertyTree!= null):((importsPropertyTree == null)||(!importsPropertyTree.isLeaf())))) {
                        if (_other.imports == null) {
                            this.imports = null;
                        } else {
                            this.imports = new ArrayList<>();
                            for (ModelImport _item: _other.imports) {
                                this.imports.add(((_item == null)?null:_item.newCopyBuilder(this, importsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree primitiveTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("primitiveTypes"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(primitiveTypesPropertyTree!= null):((primitiveTypesPropertyTree == null)||(!primitiveTypesPropertyTree.isLeaf())))) {
                        if (_other.primitiveTypes == null) {
                            this.primitiveTypes = null;
                        } else {
                            this.primitiveTypes = new ArrayList<>();
                            for (PrimitiveType _item: _other.primitiveTypes) {
                                this.primitiveTypes.add(((_item == null)?null:_item.newCopyBuilder(this, primitiveTypesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree enumerationsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("enumerations"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(enumerationsPropertyTree!= null):((enumerationsPropertyTree == null)||(!enumerationsPropertyTree.isLeaf())))) {
                        if (_other.enumerations == null) {
                            this.enumerations = null;
                        } else {
                            this.enumerations = new ArrayList<>();
                            for (Enumeration _item: _other.enumerations) {
                                this.enumerations.add(((_item == null)?null:_item.newCopyBuilder(this, enumerationsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree dataTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataTypes"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataTypesPropertyTree!= null):((dataTypesPropertyTree == null)||(!dataTypesPropertyTree.isLeaf())))) {
                        if (_other.dataTypes == null) {
                            this.dataTypes = null;
                        } else {
                            this.dataTypes = new ArrayList<>();
                            for (DataType _item: _other.dataTypes) {
                                this.dataTypes.add(((_item == null)?null:_item.newCopyBuilder(this, dataTypesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree objectTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("objectTypes"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(objectTypesPropertyTree!= null):((objectTypesPropertyTree == null)||(!objectTypesPropertyTree.isLeaf())))) {
                        if (_other.objectTypes == null) {
                            this.objectTypes = null;
                        } else {
                            this.objectTypes = new ArrayList<>();
                            for (ObjectType _item: _other.objectTypes) {
                                this.objectTypes.add(((_item == null)?null:_item.newCopyBuilder(this, objectTypesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree packagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("packages"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(packagesPropertyTree!= null):((packagesPropertyTree == null)||(!packagesPropertyTree.isLeaf())))) {
                        if (_other.packages == null) {
                            this.packages = null;
                        } else {
                            this.packages = new ArrayList<>();
                            for (Package _item: _other.packages) {
                                this.packages.add(((_item == null)?null:_item.newCopyBuilder(this, packagesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree schemaVersionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemaVersion"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemaVersionPropertyTree!= null):((schemaVersionPropertyTree == null)||(!schemaVersionPropertyTree.isLeaf())))) {
                        this.schemaVersion = _other.schemaVersion;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Model >_P init(final _P _product) {
            _product.name = this.name;
            _product.description = this.description;
            _product.identifier = this.identifier;
            _product.uri = this.uri;
            _product.title = this.title;
            if (this.authors!= null) {
                final List<String> authors = new ArrayList<>(this.authors.size());
                for (Buildable _item: this.authors) {
                    authors.add(((String) _item.build()));
                }
                _product.authors = authors;
            }
            _product.version = this.version;
            _product.previousVersion = this.previousVersion;
            _product.lastModified = this.lastModified;
            if (this.imports!= null) {
                final List<ModelImport> imports = new ArrayList<>(this.imports.size());
                for (ModelImport.Builder<Model.Builder<_B>> _item: this.imports) {
                    imports.add(_item.build());
                }
                _product.imports = imports;
            }
            if (this.primitiveTypes!= null) {
                final List<PrimitiveType> primitiveTypes = new ArrayList<>(this.primitiveTypes.size());
                for (PrimitiveType.Builder<Model.Builder<_B>> _item: this.primitiveTypes) {
                    primitiveTypes.add(_item.build());
                }
                _product.primitiveTypes = primitiveTypes;
            }
            if (this.enumerations!= null) {
                final List<Enumeration> enumerations = new ArrayList<>(this.enumerations.size());
                for (Enumeration.Builder<Model.Builder<_B>> _item: this.enumerations) {
                    enumerations.add(_item.build());
                }
                _product.enumerations = enumerations;
            }
            if (this.dataTypes!= null) {
                final List<DataType> dataTypes = new ArrayList<>(this.dataTypes.size());
                for (DataType.Builder<Model.Builder<_B>> _item: this.dataTypes) {
                    dataTypes.add(_item.build());
                }
                _product.dataTypes = dataTypes;
            }
            if (this.objectTypes!= null) {
                final List<ObjectType> objectTypes = new ArrayList<>(this.objectTypes.size());
                for (ObjectType.Builder<Model.Builder<_B>> _item: this.objectTypes) {
                    objectTypes.add(_item.build());
                }
                _product.objectTypes = objectTypes;
            }
            if (this.packages!= null) {
                final List<Package> packages = new ArrayList<>(this.packages.size());
                for (Package.Builder<Model.Builder<_B>> _item: this.packages) {
                    packages.add(_item.build());
                }
                _product.packages = packages;
            }
            _product.schemaVersion = this.schemaVersion;
            return _product;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public Model.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public Model.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        public Model.Builder<_B> withIdentifier(final String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the new value of "uri" (any previous value will be replaced)
         * 
         * @param uri
         *     New value of the "uri" property.
         */
        public Model.Builder<_B> withUri(final String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        public Model.Builder<_B> withTitle(final String title) {
            this.title = title;
            return this;
        }

        /**
         * Adds the given items to the value of "authors"
         * 
         * @param authors
         *     Items to add to the value of the "authors" property
         */
        public Model.Builder<_B> addAuthors(final Iterable<? extends String> authors) {
            if (authors!= null) {
                if (this.authors == null) {
                    this.authors = new ArrayList<>();
                }
                for (String _item: authors) {
                    this.authors.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "authors" (any previous value will be replaced)
         * 
         * @param authors
         *     New value of the "authors" property.
         */
        public Model.Builder<_B> withAuthors(final Iterable<? extends String> authors) {
            if (this.authors!= null) {
                this.authors.clear();
            }
            return addAuthors(authors);
        }

        /**
         * Adds the given items to the value of "authors"
         * 
         * @param authors
         *     Items to add to the value of the "authors" property
         */
        public Model.Builder<_B> addAuthors(String... authors) {
            addAuthors(Arrays.asList(authors));
            return this;
        }

        /**
         * Sets the new value of "authors" (any previous value will be replaced)
         * 
         * @param authors
         *     New value of the "authors" property.
         */
        public Model.Builder<_B> withAuthors(String... authors) {
            withAuthors(Arrays.asList(authors));
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        public Model.Builder<_B> withVersion(final String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the new value of "previousVersion" (any previous value will be replaced)
         * 
         * @param previousVersion
         *     New value of the "previousVersion" property.
         */
        public Model.Builder<_B> withPreviousVersion(final String previousVersion) {
            this.previousVersion = previousVersion;
            return this;
        }

        /**
         * Sets the new value of "lastModified" (any previous value will be replaced)
         * 
         * @param lastModified
         *     New value of the "lastModified" property.
         */
        public Model.Builder<_B> withLastModified(final ZonedDateTime lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        /**
         * Adds the given items to the value of "imports"
         * 
         * @param imports
         *     Items to add to the value of the "imports" property
         */
        public Model.Builder<_B> addImports(final Iterable<? extends ModelImport> imports) {
            if (imports!= null) {
                if (this.imports == null) {
                    this.imports = new ArrayList<>();
                }
                for (ModelImport _item: imports) {
                    this.imports.add(new ModelImport.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "imports" (any previous value will be replaced)
         * 
         * @param imports
         *     New value of the "imports" property.
         */
        public Model.Builder<_B> withImports(final Iterable<? extends ModelImport> imports) {
            if (this.imports!= null) {
                this.imports.clear();
            }
            return addImports(imports);
        }

        /**
         * Adds the given items to the value of "imports"
         * 
         * @param imports
         *     Items to add to the value of the "imports" property
         */
        public Model.Builder<_B> addImports(ModelImport... imports) {
            addImports(Arrays.asList(imports));
            return this;
        }

        /**
         * Sets the new value of "imports" (any previous value will be replaced)
         * 
         * @param imports
         *     New value of the "imports" property.
         */
        public Model.Builder<_B> withImports(ModelImport... imports) {
            withImports(Arrays.asList(imports));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Imports" property.
         * Use {@link org.javastro.ivoa.entities.vodml.ModelImport.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Imports" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.ModelImport.Builder#end()} to return
         *     to the current builder.
         */
        public ModelImport.Builder<? extends Model.Builder<_B>> addImports() {
            if (this.imports == null) {
                this.imports = new ArrayList<>();
            }
            final ModelImport.Builder<Model.Builder<_B>> imports_Builder = new ModelImport.Builder<>(this, null, false);
            this.imports.add(imports_Builder);
            return imports_Builder;
        }

        /**
         * Adds the given items to the value of "primitiveTypes"
         * 
         * @param primitiveTypes
         *     Items to add to the value of the "primitiveTypes" property
         */
        public Model.Builder<_B> addPrimitiveTypes(final Iterable<? extends PrimitiveType> primitiveTypes) {
            if (primitiveTypes!= null) {
                if (this.primitiveTypes == null) {
                    this.primitiveTypes = new ArrayList<>();
                }
                for (PrimitiveType _item: primitiveTypes) {
                    this.primitiveTypes.add(new PrimitiveType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "primitiveTypes" (any previous value will be replaced)
         * 
         * @param primitiveTypes
         *     New value of the "primitiveTypes" property.
         */
        public Model.Builder<_B> withPrimitiveTypes(final Iterable<? extends PrimitiveType> primitiveTypes) {
            if (this.primitiveTypes!= null) {
                this.primitiveTypes.clear();
            }
            return addPrimitiveTypes(primitiveTypes);
        }

        /**
         * Adds the given items to the value of "primitiveTypes"
         * 
         * @param primitiveTypes
         *     Items to add to the value of the "primitiveTypes" property
         */
        public Model.Builder<_B> addPrimitiveTypes(PrimitiveType... primitiveTypes) {
            addPrimitiveTypes(Arrays.asList(primitiveTypes));
            return this;
        }

        /**
         * Sets the new value of "primitiveTypes" (any previous value will be replaced)
         * 
         * @param primitiveTypes
         *     New value of the "primitiveTypes" property.
         */
        public Model.Builder<_B> withPrimitiveTypes(PrimitiveType... primitiveTypes) {
            withPrimitiveTypes(Arrays.asList(primitiveTypes));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "PrimitiveTypes"
         * property.
         * Use {@link org.javastro.ivoa.entities.vodml.PrimitiveType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "PrimitiveTypes" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.PrimitiveType.Builder#end()} to
         *     return to the current builder.
         */
        public PrimitiveType.Builder<? extends Model.Builder<_B>> addPrimitiveTypes() {
            if (this.primitiveTypes == null) {
                this.primitiveTypes = new ArrayList<>();
            }
            final PrimitiveType.Builder<Model.Builder<_B>> primitiveTypes_Builder = new PrimitiveType.Builder<>(this, null, false);
            this.primitiveTypes.add(primitiveTypes_Builder);
            return primitiveTypes_Builder;
        }

        /**
         * Adds the given items to the value of "enumerations"
         * 
         * @param enumerations
         *     Items to add to the value of the "enumerations" property
         */
        public Model.Builder<_B> addEnumerations(final Iterable<? extends Enumeration> enumerations) {
            if (enumerations!= null) {
                if (this.enumerations == null) {
                    this.enumerations = new ArrayList<>();
                }
                for (Enumeration _item: enumerations) {
                    this.enumerations.add(new Enumeration.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "enumerations" (any previous value will be replaced)
         * 
         * @param enumerations
         *     New value of the "enumerations" property.
         */
        public Model.Builder<_B> withEnumerations(final Iterable<? extends Enumeration> enumerations) {
            if (this.enumerations!= null) {
                this.enumerations.clear();
            }
            return addEnumerations(enumerations);
        }

        /**
         * Adds the given items to the value of "enumerations"
         * 
         * @param enumerations
         *     Items to add to the value of the "enumerations" property
         */
        public Model.Builder<_B> addEnumerations(Enumeration... enumerations) {
            addEnumerations(Arrays.asList(enumerations));
            return this;
        }

        /**
         * Sets the new value of "enumerations" (any previous value will be replaced)
         * 
         * @param enumerations
         *     New value of the "enumerations" property.
         */
        public Model.Builder<_B> withEnumerations(Enumeration... enumerations) {
            withEnumerations(Arrays.asList(enumerations));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Enumerations"
         * property.
         * Use {@link org.javastro.ivoa.entities.vodml.Enumeration.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Enumerations" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.Enumeration.Builder#end()} to return
         *     to the current builder.
         */
        public Enumeration.Builder<? extends Model.Builder<_B>> addEnumerations() {
            if (this.enumerations == null) {
                this.enumerations = new ArrayList<>();
            }
            final Enumeration.Builder<Model.Builder<_B>> enumerations_Builder = new Enumeration.Builder<>(this, null, false);
            this.enumerations.add(enumerations_Builder);
            return enumerations_Builder;
        }

        /**
         * Adds the given items to the value of "dataTypes"
         * 
         * @param dataTypes
         *     Items to add to the value of the "dataTypes" property
         */
        public Model.Builder<_B> addDataTypes(final Iterable<? extends DataType> dataTypes) {
            if (dataTypes!= null) {
                if (this.dataTypes == null) {
                    this.dataTypes = new ArrayList<>();
                }
                for (DataType _item: dataTypes) {
                    this.dataTypes.add(new DataType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "dataTypes" (any previous value will be replaced)
         * 
         * @param dataTypes
         *     New value of the "dataTypes" property.
         */
        public Model.Builder<_B> withDataTypes(final Iterable<? extends DataType> dataTypes) {
            if (this.dataTypes!= null) {
                this.dataTypes.clear();
            }
            return addDataTypes(dataTypes);
        }

        /**
         * Adds the given items to the value of "dataTypes"
         * 
         * @param dataTypes
         *     Items to add to the value of the "dataTypes" property
         */
        public Model.Builder<_B> addDataTypes(DataType... dataTypes) {
            addDataTypes(Arrays.asList(dataTypes));
            return this;
        }

        /**
         * Sets the new value of "dataTypes" (any previous value will be replaced)
         * 
         * @param dataTypes
         *     New value of the "dataTypes" property.
         */
        public Model.Builder<_B> withDataTypes(DataType... dataTypes) {
            withDataTypes(Arrays.asList(dataTypes));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "DataTypes" property.
         * Use {@link org.javastro.ivoa.entities.vodml.DataType.Builder#end()} to return to
         * the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "DataTypes" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.DataType.Builder#end()} to return to
         *     the current builder.
         */
        public DataType.Builder<? extends Model.Builder<_B>> addDataTypes() {
            if (this.dataTypes == null) {
                this.dataTypes = new ArrayList<>();
            }
            final DataType.Builder<Model.Builder<_B>> dataTypes_Builder = new DataType.Builder<>(this, null, false);
            this.dataTypes.add(dataTypes_Builder);
            return dataTypes_Builder;
        }

        /**
         * Adds the given items to the value of "objectTypes"
         * 
         * @param objectTypes
         *     Items to add to the value of the "objectTypes" property
         */
        public Model.Builder<_B> addObjectTypes(final Iterable<? extends ObjectType> objectTypes) {
            if (objectTypes!= null) {
                if (this.objectTypes == null) {
                    this.objectTypes = new ArrayList<>();
                }
                for (ObjectType _item: objectTypes) {
                    this.objectTypes.add(new ObjectType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "objectTypes" (any previous value will be replaced)
         * 
         * @param objectTypes
         *     New value of the "objectTypes" property.
         */
        public Model.Builder<_B> withObjectTypes(final Iterable<? extends ObjectType> objectTypes) {
            if (this.objectTypes!= null) {
                this.objectTypes.clear();
            }
            return addObjectTypes(objectTypes);
        }

        /**
         * Adds the given items to the value of "objectTypes"
         * 
         * @param objectTypes
         *     Items to add to the value of the "objectTypes" property
         */
        public Model.Builder<_B> addObjectTypes(ObjectType... objectTypes) {
            addObjectTypes(Arrays.asList(objectTypes));
            return this;
        }

        /**
         * Sets the new value of "objectTypes" (any previous value will be replaced)
         * 
         * @param objectTypes
         *     New value of the "objectTypes" property.
         */
        public Model.Builder<_B> withObjectTypes(ObjectType... objectTypes) {
            withObjectTypes(Arrays.asList(objectTypes));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "ObjectTypes"
         * property.
         * Use {@link org.javastro.ivoa.entities.vodml.ObjectType.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "ObjectTypes" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.ObjectType.Builder#end()} to return
         *     to the current builder.
         */
        public ObjectType.Builder<? extends Model.Builder<_B>> addObjectTypes() {
            if (this.objectTypes == null) {
                this.objectTypes = new ArrayList<>();
            }
            final ObjectType.Builder<Model.Builder<_B>> objectTypes_Builder = new ObjectType.Builder<>(this, null, false);
            this.objectTypes.add(objectTypes_Builder);
            return objectTypes_Builder;
        }

        /**
         * Adds the given items to the value of "packages"
         * 
         * @param packages
         *     Items to add to the value of the "packages" property
         */
        public Model.Builder<_B> addPackages(final Iterable<? extends Package> packages) {
            if (packages!= null) {
                if (this.packages == null) {
                    this.packages = new ArrayList<>();
                }
                for (Package _item: packages) {
                    this.packages.add(new Package.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "packages" (any previous value will be replaced)
         * 
         * @param packages
         *     New value of the "packages" property.
         */
        public Model.Builder<_B> withPackages(final Iterable<? extends Package> packages) {
            if (this.packages!= null) {
                this.packages.clear();
            }
            return addPackages(packages);
        }

        /**
         * Adds the given items to the value of "packages"
         * 
         * @param packages
         *     Items to add to the value of the "packages" property
         */
        public Model.Builder<_B> addPackages(Package... packages) {
            addPackages(Arrays.asList(packages));
            return this;
        }

        /**
         * Sets the new value of "packages" (any previous value will be replaced)
         * 
         * @param packages
         *     New value of the "packages" property.
         */
        public Model.Builder<_B> withPackages(Package... packages) {
            withPackages(Arrays.asList(packages));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Packages" property.
         * Use {@link org.javastro.ivoa.entities.vodml.Package.Builder#end()} to return to
         * the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Packages" property.
         *     Use {@link org.javastro.ivoa.entities.vodml.Package.Builder#end()} to return to
         *     the current builder.
         */
        public Package.Builder<? extends Model.Builder<_B>> addPackages() {
            if (this.packages == null) {
                this.packages = new ArrayList<>();
            }
            final Package.Builder<Model.Builder<_B>> packages_Builder = new Package.Builder<>(this, null, false);
            this.packages.add(packages_Builder);
            return packages_Builder;
        }

        /**
         * Sets the new value of "schemaVersion" (any previous value will be replaced)
         * 
         * @param schemaVersion
         *     New value of the "schemaVersion" property.
         */
        public Model.Builder<_B> withSchemaVersion(final String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        @Override
        public Model build() {
            if (_storedValue == null) {
                return this.init(new Model());
            } else {
                return ((Model) _storedValue);
            }
        }

        public Model.Builder<_B> copyOf(final Model _other) {
            _other.copyTo(this);
            return this;
        }

        public Model.Builder<_B> copyOf(final Model.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setName(final String name) {
            Model.this.setName(name);
        }

        public void setDescription(final String description) {
            Model.this.setDescription(description);
        }

        public void setIdentifier(final String identifier) {
            Model.this.setIdentifier(identifier);
        }

        public void setUri(final String uri) {
            Model.this.setUri(uri);
        }

        public void setTitle(final String title) {
            Model.this.setTitle(title);
        }

        public List<String> getAuthors() {
            if (Model.this.authors == null) {
                Model.this.authors = new ArrayList<>();
            }
            return Model.this.authors;
        }

        public void setVersion(final String version) {
            Model.this.setVersion(version);
        }

        public void setPreviousVersion(final String previousVersion) {
            Model.this.setPreviousVersion(previousVersion);
        }

        public void setLastModified(final ZonedDateTime lastModified) {
            Model.this.setLastModified(lastModified);
        }

        public List<ModelImport> getImports() {
            if (Model.this.imports == null) {
                Model.this.imports = new ArrayList<>();
            }
            return Model.this.imports;
        }

        public List<PrimitiveType> getPrimitiveTypes() {
            if (Model.this.primitiveTypes == null) {
                Model.this.primitiveTypes = new ArrayList<>();
            }
            return Model.this.primitiveTypes;
        }

        public List<Enumeration> getEnumerations() {
            if (Model.this.enumerations == null) {
                Model.this.enumerations = new ArrayList<>();
            }
            return Model.this.enumerations;
        }

        public List<DataType> getDataTypes() {
            if (Model.this.dataTypes == null) {
                Model.this.dataTypes = new ArrayList<>();
            }
            return Model.this.dataTypes;
        }

        public List<ObjectType> getObjectTypes() {
            if (Model.this.objectTypes == null) {
                Model.this.objectTypes = new ArrayList<>();
            }
            return Model.this.objectTypes;
        }

        public List<Package> getPackages() {
            if (Model.this.packages == null) {
                Model.this.packages = new ArrayList<>();
            }
            return Model.this.packages;
        }

        public void setSchemaVersion(final String schemaVersion) {
            Model.this.setSchemaVersion(schemaVersion);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Model, String> NAME = new SinglePropertyInfo<Model,String>("name", Model.class, String.class, false, null, new QName("", "name"), new QName("http://www.ivoa.net/xml/VODML/v1", "ModelName"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> DESCRIPTION = new SinglePropertyInfo<Model,String>("description", Model.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> IDENTIFIER = new SinglePropertyInfo<Model,String>("identifier", Model.class, String.class, false, null, new QName("", "identifier"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.identifier);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.identifier = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> URI = new SinglePropertyInfo<Model,String>("uri", Model.class, String.class, false, null, new QName("", "uri"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.uri);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.uri = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> TITLE = new SinglePropertyInfo<Model,String>("title", Model.class, String.class, false, null, new QName("", "title"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.title);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.title = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, String> AUTHORS = new CollectionPropertyInfo<Model,String>("authors", Model.class, String.class, true, null, new QName("", "author"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public List<String> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.authors);
            }

            @Override
            public void set(final Model _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.authors = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> VERSION = new SinglePropertyInfo<Model,String>("version", Model.class, String.class, false, null, new QName("", "version"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.version);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.version = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> PREVIOUS_VERSION = new SinglePropertyInfo<Model,String>("previousVersion", Model.class, String.class, false, null, new QName("", "previousVersion"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.previousVersion);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.previousVersion = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, ZonedDateTime> LAST_MODIFIED = new SinglePropertyInfo<Model,ZonedDateTime>("lastModified", Model.class, ZonedDateTime.class, false, null, new QName("", "lastModified"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), false) {


            @Override
            public ZonedDateTime get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.lastModified);
            }

            @Override
            public void set(final Model _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.lastModified = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, ModelImport> IMPORTS = new CollectionPropertyInfo<Model,ModelImport>("imports", Model.class, ModelImport.class, true, null, new QName("", "import"), new QName("http://www.ivoa.net/xml/VODML/v1", "ModelImport"), false) {


            @Override
            public List<ModelImport> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.imports);
            }

            @Override
            public void set(final Model _instance_, final List<ModelImport> _value_) {
                if (_instance_!= null) {
                    _instance_.imports = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, PrimitiveType> PRIMITIVE_TYPES = new CollectionPropertyInfo<Model,PrimitiveType>("primitiveTypes", Model.class, PrimitiveType.class, true, null, new QName("", "primitiveType"), new QName("http://www.ivoa.net/xml/VODML/v1", "PrimitiveType"), false) {


            @Override
            public List<PrimitiveType> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.primitiveTypes);
            }

            @Override
            public void set(final Model _instance_, final List<PrimitiveType> _value_) {
                if (_instance_!= null) {
                    _instance_.primitiveTypes = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, Enumeration> ENUMERATIONS = new CollectionPropertyInfo<Model,Enumeration>("enumerations", Model.class, Enumeration.class, true, null, new QName("", "enumeration"), new QName("http://www.ivoa.net/xml/VODML/v1", "Enumeration"), false) {


            @Override
            public List<Enumeration> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.enumerations);
            }

            @Override
            public void set(final Model _instance_, final List<Enumeration> _value_) {
                if (_instance_!= null) {
                    _instance_.enumerations = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, DataType> DATA_TYPES = new CollectionPropertyInfo<Model,DataType>("dataTypes", Model.class, DataType.class, true, null, new QName("", "dataType"), new QName("http://www.ivoa.net/xml/VODML/v1", "DataType"), false) {


            @Override
            public List<DataType> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.dataTypes);
            }

            @Override
            public void set(final Model _instance_, final List<DataType> _value_) {
                if (_instance_!= null) {
                    _instance_.dataTypes = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, ObjectType> OBJECT_TYPES = new CollectionPropertyInfo<Model,ObjectType>("objectTypes", Model.class, ObjectType.class, true, null, new QName("", "objectType"), new QName("http://www.ivoa.net/xml/VODML/v1", "ObjectType"), false) {


            @Override
            public List<ObjectType> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.objectTypes);
            }

            @Override
            public void set(final Model _instance_, final List<ObjectType> _value_) {
                if (_instance_!= null) {
                    _instance_.objectTypes = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Model, Package> PACKAGES = new CollectionPropertyInfo<Model,Package>("packages", Model.class, Package.class, true, null, new QName("", "package"), new QName("http://www.ivoa.net/xml/VODML/v1", "Package"), false) {


            @Override
            public List<Package> get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.packages);
            }

            @Override
            public void set(final Model _instance_, final List<Package> _value_) {
                if (_instance_!= null) {
                    _instance_.packages = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Model, String> SCHEMA_VERSION = new SinglePropertyInfo<Model,String>("schemaVersion", Model.class, String.class, false, null, new QName("", "version"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final Model _instance_) {
                return ((_instance_ == null)?null:_instance_.schemaVersion);
            }

            @Override
            public void set(final Model _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.schemaVersion = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Model.Selector<Model.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Model.Select _root() {
            return new Model.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> name = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> description = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> identifier = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> uri = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> title = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> authors = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> version = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> previousVersion = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> lastModified = null;
        private ModelImport.Selector<TRoot, Model.Selector<TRoot, TParent>> imports = null;
        private PrimitiveType.Selector<TRoot, Model.Selector<TRoot, TParent>> primitiveTypes = null;
        private Enumeration.Selector<TRoot, Model.Selector<TRoot, TParent>> enumerations = null;
        private DataType.Selector<TRoot, Model.Selector<TRoot, TParent>> dataTypes = null;
        private ObjectType.Selector<TRoot, Model.Selector<TRoot, TParent>> objectTypes = null;
        private Package.Selector<TRoot, Model.Selector<TRoot, TParent>> packages = null;
        private com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> schemaVersion = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.identifier!= null) {
                products.put("identifier", this.identifier.init());
            }
            if (this.uri!= null) {
                products.put("uri", this.uri.init());
            }
            if (this.title!= null) {
                products.put("title", this.title.init());
            }
            if (this.authors!= null) {
                products.put("authors", this.authors.init());
            }
            if (this.version!= null) {
                products.put("version", this.version.init());
            }
            if (this.previousVersion!= null) {
                products.put("previousVersion", this.previousVersion.init());
            }
            if (this.lastModified!= null) {
                products.put("lastModified", this.lastModified.init());
            }
            if (this.imports!= null) {
                products.put("imports", this.imports.init());
            }
            if (this.primitiveTypes!= null) {
                products.put("primitiveTypes", this.primitiveTypes.init());
            }
            if (this.enumerations!= null) {
                products.put("enumerations", this.enumerations.init());
            }
            if (this.dataTypes!= null) {
                products.put("dataTypes", this.dataTypes.init());
            }
            if (this.objectTypes!= null) {
                products.put("objectTypes", this.objectTypes.init());
            }
            if (this.packages!= null) {
                products.put("packages", this.packages.init());
            }
            if (this.schemaVersion!= null) {
                products.put("schemaVersion", this.schemaVersion.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> identifier() {
            return ((this.identifier == null)?this.identifier = new com.kscs.util.jaxb.Selector<>(this._root, this, "identifier"):this.identifier);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> uri() {
            return ((this.uri == null)?this.uri = new com.kscs.util.jaxb.Selector<>(this._root, this, "uri"):this.uri);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> title() {
            return ((this.title == null)?this.title = new com.kscs.util.jaxb.Selector<>(this._root, this, "title"):this.title);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> authors() {
            return ((this.authors == null)?this.authors = new com.kscs.util.jaxb.Selector<>(this._root, this, "authors"):this.authors);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> version() {
            return ((this.version == null)?this.version = new com.kscs.util.jaxb.Selector<>(this._root, this, "version"):this.version);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> previousVersion() {
            return ((this.previousVersion == null)?this.previousVersion = new com.kscs.util.jaxb.Selector<>(this._root, this, "previousVersion"):this.previousVersion);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> lastModified() {
            return ((this.lastModified == null)?this.lastModified = new com.kscs.util.jaxb.Selector<>(this._root, this, "lastModified"):this.lastModified);
        }

        public ModelImport.Selector<TRoot, Model.Selector<TRoot, TParent>> imports() {
            return ((this.imports == null)?this.imports = new ModelImport.Selector<>(this._root, this, "imports"):this.imports);
        }

        public PrimitiveType.Selector<TRoot, Model.Selector<TRoot, TParent>> primitiveTypes() {
            return ((this.primitiveTypes == null)?this.primitiveTypes = new PrimitiveType.Selector<>(this._root, this, "primitiveTypes"):this.primitiveTypes);
        }

        public Enumeration.Selector<TRoot, Model.Selector<TRoot, TParent>> enumerations() {
            return ((this.enumerations == null)?this.enumerations = new Enumeration.Selector<>(this._root, this, "enumerations"):this.enumerations);
        }

        public DataType.Selector<TRoot, Model.Selector<TRoot, TParent>> dataTypes() {
            return ((this.dataTypes == null)?this.dataTypes = new DataType.Selector<>(this._root, this, "dataTypes"):this.dataTypes);
        }

        public ObjectType.Selector<TRoot, Model.Selector<TRoot, TParent>> objectTypes() {
            return ((this.objectTypes == null)?this.objectTypes = new ObjectType.Selector<>(this._root, this, "objectTypes"):this.objectTypes);
        }

        public Package.Selector<TRoot, Model.Selector<TRoot, TParent>> packages() {
            return ((this.packages == null)?this.packages = new Package.Selector<>(this._root, this, "packages"):this.packages);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Model.Selector<TRoot, TParent>> schemaVersion() {
            return ((this.schemaVersion == null)?this.schemaVersion = new com.kscs.util.jaxb.Selector<>(this._root, this, "schemaVersion"):this.schemaVersion);
        }

    }

}
