
package org.javastro.ivoa.entities.vodml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * This is the base type for all types whose elements can be explicitly referenced.
 *         To this end it has a 'vodml-id' element of type VODMLID that allows explicit and unique identification of 
 *         these elements within the context of the model.
 *         Generally these are also elements that can be
 *         represented explicitly in alternative serialisations of
 *         a data model, such as a VOTable or a relational model.
 *         These should use the value of the utype element to "point into a data model" and identify a
 *         model element. VO-DML itself also has needs of pointing to other elements, sometimes in another model.
 *         The VODMLREF type is used for such references, which will always be named 'vodml-ref'.
 * 
 * <p>Java class for ReferableElement complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ReferableElement">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="vodml-id" type="{http://www.ivoa.net/xml/VODML/v1}VODMLID"/>
 *         <element name="name" type="{http://www.ivoa.net/xml/VODML/v1}VODMLName"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="id" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReferableElement", propOrder = {
    "vodmlId",
    "name",
    "description"
})
@XmlSeeAlso({
    Package.class,
    Type.class,
    EnumLiteral.class,
    Role.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
public abstract class ReferableElement implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Identifier for its containing element.
     *               Extracted as a separate type so that we can easily adapt to a different identifier design.
     * 
     */
    @XmlElement(name = "vodml-id", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String vodmlId;
    /**
     * The name of the model element. 
     *             MUST NOT be an empty string.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String name;
    /**
     * Human readable description of the model element.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String description;
    /**
     * A referencable element may be given an @id attribute to reflect an identifier
     *           defined in some source document form which a VO-DML model may have been derived.
     * 
     */
    @XmlAttribute(name = "id")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected String id;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    protected transient ReferableElement.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ReferableElement() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ReferableElement(final String vodmlId, final String name, final String description, final String id) {
        this.vodmlId = vodmlId;
        this.name = name;
        this.description = description;
        this.id = id;
    }

    /**
     * Identifier for its containing element.
     *               Extracted as a separate type so that we can easily adapt to a different identifier design.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getVodmlId() {
        return vodmlId;
    }

    /**
     * Sets the value of the vodmlId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVodmlId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setVodmlId(String value) {
        this.vodmlId = value;
    }

    /**
     * The name of the model element. 
     *             MUST NOT be an empty string.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Human readable description of the model element.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * A referencable element may be given an @id attribute to reflect an identifier
     *           defined in some source document form which a VO-DML model may have been derived.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void setId(String value) {
        this.id = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ReferableElement that = ((ReferableElement) object);
        {
            String leftVodmlId;
            leftVodmlId = this.getVodmlId();
            String rightVodmlId;
            rightVodmlId = that.getVodmlId();
            if (this.vodmlId!= null) {
                if (that.vodmlId!= null) {
                    if (!leftVodmlId.equals(rightVodmlId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.vodmlId!= null) {
                    return false;
                }
            }
        }
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            String leftId;
            leftId = this.getId();
            String rightId;
            rightId = that.getId();
            if (this.id!= null) {
                if (that.id!= null) {
                    if (!leftId.equals(rightId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.id!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theVodmlId;
            theVodmlId = this.getVodmlId();
            if (this.vodmlId!= null) {
                currentHashCode += theVodmlId.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theId;
            theId = this.getId();
            if (this.id!= null) {
                currentHashCode += theId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theVodmlId;
            theVodmlId = this.getVodmlId();
            strategy.appendField(locator, this, "vodmlId", buffer, theVodmlId, (this.vodmlId!= null));
        }
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ReferableElement) {
            final ReferableElement target = this;
            final ReferableElement leftObject = ((ReferableElement) left);
            final ReferableElement rightObject = ((ReferableElement) right);
            {
                Boolean vodmlIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.vodmlId!= null), (rightObject.vodmlId!= null));
                if (vodmlIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVodmlId;
                    lhsVodmlId = leftObject.getVodmlId();
                    String rhsVodmlId;
                    rhsVodmlId = rightObject.getVodmlId();
                    String mergedVodmlId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "vodmlId", lhsVodmlId), LocatorUtils.property(rightLocator, "vodmlId", rhsVodmlId), lhsVodmlId, rhsVodmlId, (leftObject.vodmlId!= null), (rightObject.vodmlId!= null)));
                    target.setVodmlId(mergedVodmlId);
                } else {
                    if (vodmlIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.vodmlId = null;
                    }
                }
            }
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean idShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.id!= null), (rightObject.id!= null));
                if (idShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsId;
                    lhsId = leftObject.getId();
                    String rhsId;
                    rhsId = rightObject.getId();
                    String mergedId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "id", lhsId), LocatorUtils.property(rightLocator, "id", rhsId), lhsId, rhsId, (leftObject.id!= null), (rightObject.id!= null)));
                    target.setId(mergedId);
                } else {
                    if (idShouldBeMergedAndSet == Boolean.FALSE) {
                        target.id = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement clone() {
        final ReferableElement _newObject;
        try {
            _newObject = ((ReferableElement) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement createCopy() {
        final ReferableElement _newObject;
        try {
            _newObject = ((ReferableElement) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.vodmlId = this.vodmlId;
        _newObject.name = this.name;
        _newObject.description = this.description;
        _newObject.id = this.id;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ReferableElement _newObject;
        try {
            _newObject = ((ReferableElement) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree vodmlIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlIdPropertyTree!= null):((vodmlIdPropertyTree == null)||(!vodmlIdPropertyTree.isLeaf())))) {
            _newObject.vodmlId = this.vodmlId;
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _newObject.id = this.id;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ReferableElement.Modifier();
        }
        return ((ReferableElement.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ReferableElement.Builder<_B> _other) {
        _other.vodmlId = this.vodmlId;
        _other.name = this.name;
        _other.description = this.description;
        _other.id = this.id;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract<_B >ReferableElement.Builder<_B> newCopyBuilder(final _B _parentBuilder);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract ReferableElement.Builder<Void> newCopyBuilder();

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public<_B >void copyTo(final ReferableElement.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree vodmlIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlIdPropertyTree!= null):((vodmlIdPropertyTree == null)||(!vodmlIdPropertyTree.isLeaf())))) {
            _other.vodmlId = this.vodmlId;
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
            _other.id = this.id;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract<_B >ReferableElement.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public abstract ReferableElement.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-08-12T08:31:32+01:00")
    public ReferableElement visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ReferableElement.PropInfo.VODML_ID, this));
        _visitor_.visit(new SingleProperty<>(ReferableElement.PropInfo.NAME, this));
        _visitor_.visit(new SingleProperty<>(ReferableElement.PropInfo.DESCRIPTION, this));
        _visitor_.visit(new SingleProperty<>(ReferableElement.PropInfo.ID, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ReferableElement _storedValue;
        private String vodmlId;
        private String name;
        private String description;
        private String id;

        public Builder(final _B _parentBuilder, final ReferableElement _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.vodmlId = _other.vodmlId;
                    this.name = _other.name;
                    this.description = _other.description;
                    this.id = _other.id;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ReferableElement _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree vodmlIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("vodmlId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(vodmlIdPropertyTree!= null):((vodmlIdPropertyTree == null)||(!vodmlIdPropertyTree.isLeaf())))) {
                        this.vodmlId = _other.vodmlId;
                    }
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree idPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("id"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(idPropertyTree!= null):((idPropertyTree == null)||(!idPropertyTree.isLeaf())))) {
                        this.id = _other.id;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ReferableElement >_P init(final _P _product) {
            _product.vodmlId = this.vodmlId;
            _product.name = this.name;
            _product.description = this.description;
            _product.id = this.id;
            return _product;
        }

        /**
         * Sets the new value of "vodmlId" (any previous value will be replaced)
         * 
         * @param vodmlId
         *     New value of the "vodmlId" property.
         */
        public ReferableElement.Builder<_B> withVodmlId(final String vodmlId) {
            this.vodmlId = vodmlId;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public ReferableElement.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public ReferableElement.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        public ReferableElement.Builder<_B> withId(final String id) {
            this.id = id;
            return this;
        }

        @Override
        public ReferableElement build() {
            return ((ReferableElement) _storedValue);
        }

        public ReferableElement.Builder<_B> copyOf(final ReferableElement _other) {
            _other.copyTo(this);
            return this;
        }

        public ReferableElement.Builder<_B> copyOf(final ReferableElement.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setVodmlId(final String vodmlId) {
            ReferableElement.this.setVodmlId(vodmlId);
        }

        public void setName(final String name) {
            ReferableElement.this.setName(name);
        }

        public void setDescription(final String description) {
            ReferableElement.this.setDescription(description);
        }

        public void setId(final String id) {
            ReferableElement.this.setId(id);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ReferableElement, String> VODML_ID = new SinglePropertyInfo<ReferableElement,String>("vodmlId", ReferableElement.class, String.class, false, null, new QName("", "vodml-id"), new QName("http://www.ivoa.net/xml/VODML/v1", "VODMLID"), false) {


            @Override
            public String get(final ReferableElement _instance_) {
                return ((_instance_ == null)?null:_instance_.vodmlId);
            }

            @Override
            public void set(final ReferableElement _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.vodmlId = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ReferableElement, String> NAME = new SinglePropertyInfo<ReferableElement,String>("name", ReferableElement.class, String.class, false, null, new QName("", "name"), new QName("http://www.ivoa.net/xml/VODML/v1", "VODMLName"), false) {


            @Override
            public String get(final ReferableElement _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final ReferableElement _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ReferableElement, String> DESCRIPTION = new SinglePropertyInfo<ReferableElement,String>("description", ReferableElement.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ReferableElement _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final ReferableElement _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ReferableElement, String> ID = new SinglePropertyInfo<ReferableElement,String>("id", ReferableElement.class, String.class, false, null, new QName("", "id"), new QName("http://www.w3.org/2001/XMLSchema", "string"), true) {


            @Override
            public String get(final ReferableElement _instance_) {
                return ((_instance_ == null)?null:_instance_.id);
            }

            @Override
            public void set(final ReferableElement _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.id = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ReferableElement.Selector<ReferableElement.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ReferableElement.Select _root() {
            return new ReferableElement.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> vodmlId = null;
        private com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> name = null;
        private com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> description = null;
        private com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> id = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.vodmlId!= null) {
                products.put("vodmlId", this.vodmlId.init());
            }
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.id!= null) {
                products.put("id", this.id.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> vodmlId() {
            return ((this.vodmlId == null)?this.vodmlId = new com.kscs.util.jaxb.Selector<>(this._root, this, "vodmlId"):this.vodmlId);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ReferableElement.Selector<TRoot, TParent>> id() {
            return ((this.id == null)?this.id = new com.kscs.util.jaxb.Selector<>(this._root, this, "id"):this.id);
        }

    }

}
