/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.resource.applications;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Validation;
import org.javastro.ivoa.entities.resource.applications.ApplicationCapability;
import org.javastro.ivoa.entities.resource.applications.DataFormat;
import org.javastro.ivoa.entities.resource.applications.DesktopApplication;
import org.javastro.ivoa.entities.resource.applications.SoftwareLibrary;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Application", propOrder={"cost", "licence", "openSource", "dataFormats", "voStandards", "sourceLanguages", "sourceCodeURL"})
@XmlSeeAlso(value={DesktopApplication.class, SoftwareLibrary.class})
public class Application
extends Resource
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    protected String cost;
    protected String licence;
    protected Boolean openSource;
    @XmlElement(name="dataFormat")
    protected List<DataFormat> dataFormats;
    @XmlElement(name="voStandard")
    protected List<ApplicationCapability> voStandards;
    @XmlElement(name="sourceLanguage")
    @XmlSchemaType(name="anyURI")
    protected List<String> sourceLanguages;
    @XmlSchemaType(name="anyURI")
    protected String sourceCodeURL;

    public Application() {
    }

    public Application(List<Validation> validationLevels, String title, String shortName, String identifier, List<String> altIdentifiers, Curation curation, Content content, ZonedDateTime created, ZonedDateTime updated, String status, String version, String cost, String licence, Boolean openSource, List<DataFormat> dataFormats, List<ApplicationCapability> voStandards, List<String> sourceLanguages, String sourceCodeURL) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.cost = cost;
        this.licence = licence;
        this.openSource = openSource;
        this.dataFormats = dataFormats;
        this.voStandards = voStandards;
        this.sourceLanguages = sourceLanguages;
        this.sourceCodeURL = sourceCodeURL;
    }

    public String getCost() {
        return this.cost;
    }

    public void setCost(String value) {
        this.cost = value;
    }

    public String getLicence() {
        return this.licence;
    }

    public void setLicence(String value) {
        this.licence = value;
    }

    public Boolean isOpenSource() {
        return this.openSource;
    }

    public void setOpenSource(Boolean value) {
        this.openSource = value;
    }

    public List<DataFormat> getDataFormats() {
        if (this.dataFormats == null) {
            this.dataFormats = new ArrayList<DataFormat>();
        }
        return this.dataFormats;
    }

    public List<ApplicationCapability> getVoStandards() {
        if (this.voStandards == null) {
            this.voStandards = new ArrayList<ApplicationCapability>();
        }
        return this.voStandards;
    }

    public List<String> getSourceLanguages() {
        if (this.sourceLanguages == null) {
            this.sourceLanguages = new ArrayList<String>();
        }
        return this.sourceLanguages;
    }

    public String getSourceCodeURL() {
        return this.sourceCodeURL;
    }

    public void setSourceCodeURL(String value) {
        this.sourceCodeURL = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightSourceLanguages;
        List<ApplicationCapability> rightVoStandards;
        List<DataFormat> rightDataFormats;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Application that = (Application)object;
        String leftCost = this.getCost();
        String rightCost = that.getCost();
        if (this.cost != null) {
            if (that.cost == null) return false;
            if (!leftCost.equals(rightCost)) {
                return false;
            }
        } else if (that.cost != null) {
            return false;
        }
        String leftLicence = this.getLicence();
        String rightLicence = that.getLicence();
        if (this.licence != null) {
            if (that.licence == null) return false;
            if (!leftLicence.equals(rightLicence)) {
                return false;
            }
        } else if (that.licence != null) {
            return false;
        }
        Boolean leftOpenSource = this.isOpenSource();
        Boolean rightOpenSource = that.isOpenSource();
        if (this.openSource != null) {
            if (that.openSource == null) return false;
            if (!leftOpenSource.equals(rightOpenSource)) {
                return false;
            }
        } else if (that.openSource != null) {
            return false;
        }
        List<DataFormat> leftDataFormats = this.dataFormats != null && !this.dataFormats.isEmpty() ? this.getDataFormats() : null;
        List<DataFormat> list = rightDataFormats = that.dataFormats != null && !that.dataFormats.isEmpty() ? that.getDataFormats() : null;
        if (this.dataFormats != null && !this.dataFormats.isEmpty()) {
            if (that.dataFormats == null || that.dataFormats.isEmpty()) return false;
            if (!leftDataFormats.equals(rightDataFormats)) {
                return false;
            }
        } else if (that.dataFormats != null && !that.dataFormats.isEmpty()) {
            return false;
        }
        List<ApplicationCapability> leftVoStandards = this.voStandards != null && !this.voStandards.isEmpty() ? this.getVoStandards() : null;
        List<ApplicationCapability> list2 = rightVoStandards = that.voStandards != null && !that.voStandards.isEmpty() ? that.getVoStandards() : null;
        if (this.voStandards != null && !this.voStandards.isEmpty()) {
            if (that.voStandards == null || that.voStandards.isEmpty()) return false;
            if (!leftVoStandards.equals(rightVoStandards)) {
                return false;
            }
        } else if (that.voStandards != null && !that.voStandards.isEmpty()) {
            return false;
        }
        List<String> leftSourceLanguages = this.sourceLanguages != null && !this.sourceLanguages.isEmpty() ? this.getSourceLanguages() : null;
        List<String> list3 = rightSourceLanguages = that.sourceLanguages != null && !that.sourceLanguages.isEmpty() ? that.getSourceLanguages() : null;
        if (this.sourceLanguages != null && !this.sourceLanguages.isEmpty()) {
            if (that.sourceLanguages == null || that.sourceLanguages.isEmpty()) return false;
            if (!leftSourceLanguages.equals(rightSourceLanguages)) {
                return false;
            }
        } else if (that.sourceLanguages != null && !that.sourceLanguages.isEmpty()) {
            return false;
        }
        String leftSourceCodeURL = this.getSourceCodeURL();
        String rightSourceCodeURL = that.getSourceCodeURL();
        if (this.sourceCodeURL != null) {
            if (that.sourceCodeURL == null) return false;
            if (leftSourceCodeURL.equals(rightSourceCodeURL)) return true;
            return false;
        }
        if (that.sourceCodeURL == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theSourceLanguages;
        List<ApplicationCapability> theVoStandards;
        List<DataFormat> theDataFormats;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        String theCost = this.getCost();
        if (this.cost != null) {
            currentHashCode += theCost.hashCode();
        }
        currentHashCode *= 31;
        String theLicence = this.getLicence();
        if (this.licence != null) {
            currentHashCode += theLicence.hashCode();
        }
        currentHashCode *= 31;
        Boolean theOpenSource = this.isOpenSource();
        if (this.openSource != null) {
            currentHashCode += theOpenSource.hashCode();
        }
        currentHashCode *= 31;
        List<DataFormat> list = theDataFormats = this.dataFormats != null && !this.dataFormats.isEmpty() ? this.getDataFormats() : null;
        if (this.dataFormats != null && !this.dataFormats.isEmpty()) {
            currentHashCode += theDataFormats.hashCode();
        }
        currentHashCode *= 31;
        List<ApplicationCapability> list2 = theVoStandards = this.voStandards != null && !this.voStandards.isEmpty() ? this.getVoStandards() : null;
        if (this.voStandards != null && !this.voStandards.isEmpty()) {
            currentHashCode += theVoStandards.hashCode();
        }
        currentHashCode *= 31;
        List<String> list3 = theSourceLanguages = this.sourceLanguages != null && !this.sourceLanguages.isEmpty() ? this.getSourceLanguages() : null;
        if (this.sourceLanguages != null && !this.sourceLanguages.isEmpty()) {
            currentHashCode += theSourceLanguages.hashCode();
        }
        currentHashCode *= 31;
        String theSourceCodeURL = this.getSourceCodeURL();
        if (this.sourceCodeURL != null) {
            currentHashCode += theSourceCodeURL.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        String theCost = this.getCost();
        strategy.appendField(locator, (Object)this, "cost", buffer, (Object)theCost, this.cost != null);
        String theLicence = this.getLicence();
        strategy.appendField(locator, (Object)this, "licence", buffer, (Object)theLicence, this.licence != null);
        Boolean theOpenSource = this.isOpenSource();
        strategy.appendField(locator, (Object)this, "openSource", buffer, (Object)theOpenSource, this.openSource != null);
        List<DataFormat> theDataFormats = this.dataFormats != null && !this.dataFormats.isEmpty() ? this.getDataFormats() : null;
        strategy.appendField(locator, (Object)this, "dataFormats", buffer, theDataFormats, this.dataFormats != null && !this.dataFormats.isEmpty());
        List<ApplicationCapability> theVoStandards = this.voStandards != null && !this.voStandards.isEmpty() ? this.getVoStandards() : null;
        strategy.appendField(locator, (Object)this, "voStandards", buffer, theVoStandards, this.voStandards != null && !this.voStandards.isEmpty());
        List<String> theSourceLanguages = this.sourceLanguages != null && !this.sourceLanguages.isEmpty() ? this.getSourceLanguages() : null;
        strategy.appendField(locator, (Object)this, "sourceLanguages", buffer, theSourceLanguages, this.sourceLanguages != null && !this.sourceLanguages.isEmpty());
        String theSourceCodeURL = this.getSourceCodeURL();
        strategy.appendField(locator, (Object)this, "sourceCodeURL", buffer, (Object)theSourceCodeURL, this.sourceCodeURL != null);
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Application) {
            Application target = this;
            Application leftObject = (Application)left;
            Application rightObject = (Application)right;
            Boolean costShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.cost != null, rightObject.cost != null);
            if (costShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsCost = leftObject.getCost();
                String rhsCost = rightObject.getCost();
                String mergedCost = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"cost", (Object)lhsCost), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"cost", (Object)rhsCost), (Object)lhsCost, (Object)rhsCost, leftObject.cost != null, rightObject.cost != null);
                target.setCost(mergedCost);
            } else if (costShouldBeMergedAndSet == Boolean.FALSE) {
                target.cost = null;
            }
            Boolean licenceShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.licence != null, rightObject.licence != null);
            if (licenceShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsLicence = leftObject.getLicence();
                String rhsLicence = rightObject.getLicence();
                String mergedLicence = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"licence", (Object)lhsLicence), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"licence", (Object)rhsLicence), (Object)lhsLicence, (Object)rhsLicence, leftObject.licence != null, rightObject.licence != null);
                target.setLicence(mergedLicence);
            } else if (licenceShouldBeMergedAndSet == Boolean.FALSE) {
                target.licence = null;
            }
            Boolean openSourceShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.openSource != null, rightObject.openSource != null);
            if (openSourceShouldBeMergedAndSet == Boolean.TRUE) {
                Boolean lhsOpenSource = leftObject.isOpenSource();
                Boolean rhsOpenSource = rightObject.isOpenSource();
                Boolean mergedOpenSource = (Boolean)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"openSource", (Object)lhsOpenSource), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"openSource", (Object)rhsOpenSource), (Object)lhsOpenSource, (Object)rhsOpenSource, leftObject.openSource != null, rightObject.openSource != null);
                target.setOpenSource(mergedOpenSource);
            } else if (openSourceShouldBeMergedAndSet == Boolean.FALSE) {
                target.openSource = null;
            }
            Boolean dataFormatsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.dataFormats != null && !leftObject.dataFormats.isEmpty(), rightObject.dataFormats != null && !rightObject.dataFormats.isEmpty());
            if (dataFormatsShouldBeMergedAndSet == Boolean.TRUE) {
                List<DataFormat> lhsDataFormats = leftObject.dataFormats != null && !leftObject.dataFormats.isEmpty() ? leftObject.getDataFormats() : null;
                List<DataFormat> rhsDataFormats = rightObject.dataFormats != null && !rightObject.dataFormats.isEmpty() ? rightObject.getDataFormats() : null;
                List mergedDataFormats = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"dataFormats", lhsDataFormats), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"dataFormats", rhsDataFormats), lhsDataFormats, rhsDataFormats, leftObject.dataFormats != null && !leftObject.dataFormats.isEmpty(), rightObject.dataFormats != null && !rightObject.dataFormats.isEmpty());
                target.dataFormats = null;
                if (mergedDataFormats != null) {
                    List<DataFormat> uniqueDataFormatsl = target.getDataFormats();
                    uniqueDataFormatsl.addAll(mergedDataFormats);
                }
            } else if (dataFormatsShouldBeMergedAndSet == Boolean.FALSE) {
                target.dataFormats = null;
            }
            Boolean voStandardsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.voStandards != null && !leftObject.voStandards.isEmpty(), rightObject.voStandards != null && !rightObject.voStandards.isEmpty());
            if (voStandardsShouldBeMergedAndSet == Boolean.TRUE) {
                List<ApplicationCapability> lhsVoStandards = leftObject.voStandards != null && !leftObject.voStandards.isEmpty() ? leftObject.getVoStandards() : null;
                List<ApplicationCapability> rhsVoStandards = rightObject.voStandards != null && !rightObject.voStandards.isEmpty() ? rightObject.getVoStandards() : null;
                List mergedVoStandards = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"voStandards", lhsVoStandards), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"voStandards", rhsVoStandards), lhsVoStandards, rhsVoStandards, leftObject.voStandards != null && !leftObject.voStandards.isEmpty(), rightObject.voStandards != null && !rightObject.voStandards.isEmpty());
                target.voStandards = null;
                if (mergedVoStandards != null) {
                    List<ApplicationCapability> uniqueVoStandardsl = target.getVoStandards();
                    uniqueVoStandardsl.addAll(mergedVoStandards);
                }
            } else if (voStandardsShouldBeMergedAndSet == Boolean.FALSE) {
                target.voStandards = null;
            }
            Boolean sourceLanguagesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.sourceLanguages != null && !leftObject.sourceLanguages.isEmpty(), rightObject.sourceLanguages != null && !rightObject.sourceLanguages.isEmpty());
            if (sourceLanguagesShouldBeMergedAndSet == Boolean.TRUE) {
                List<String> lhsSourceLanguages = leftObject.sourceLanguages != null && !leftObject.sourceLanguages.isEmpty() ? leftObject.getSourceLanguages() : null;
                List<String> rhsSourceLanguages = rightObject.sourceLanguages != null && !rightObject.sourceLanguages.isEmpty() ? rightObject.getSourceLanguages() : null;
                List mergedSourceLanguages = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"sourceLanguages", lhsSourceLanguages), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"sourceLanguages", rhsSourceLanguages), lhsSourceLanguages, rhsSourceLanguages, leftObject.sourceLanguages != null && !leftObject.sourceLanguages.isEmpty(), rightObject.sourceLanguages != null && !rightObject.sourceLanguages.isEmpty());
                target.sourceLanguages = null;
                if (mergedSourceLanguages != null) {
                    List<String> uniqueSourceLanguagesl = target.getSourceLanguages();
                    uniqueSourceLanguagesl.addAll(mergedSourceLanguages);
                }
            } else if (sourceLanguagesShouldBeMergedAndSet == Boolean.FALSE) {
                target.sourceLanguages = null;
            }
            Boolean sourceCodeURLShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.sourceCodeURL != null, rightObject.sourceCodeURL != null);
            if (sourceCodeURLShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsSourceCodeURL = leftObject.getSourceCodeURL();
                String rhsSourceCodeURL = rightObject.getSourceCodeURL();
                String mergedSourceCodeURL = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"sourceCodeURL", (Object)lhsSourceCodeURL), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"sourceCodeURL", (Object)rhsSourceCodeURL), (Object)lhsSourceCodeURL, (Object)rhsSourceCodeURL, leftObject.sourceCodeURL != null, rightObject.sourceCodeURL != null);
                target.setSourceCodeURL(mergedSourceCodeURL);
            } else if (sourceCodeURLShouldBeMergedAndSet == Boolean.FALSE) {
                target.sourceCodeURL = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new Application();
    }

    @Override
    public Application clone() {
        Application _newObject = (Application)super.clone();
        if (this.dataFormats == null) {
            _newObject.dataFormats = null;
        } else {
            _newObject.dataFormats = new ArrayList<DataFormat>();
            for (DataFormat dataFormat : this.dataFormats) {
                _newObject.dataFormats.add(dataFormat == null ? null : dataFormat.clone());
            }
        }
        if (this.voStandards == null) {
            _newObject.voStandards = null;
        } else {
            _newObject.voStandards = new ArrayList<ApplicationCapability>();
            for (ApplicationCapability applicationCapability : this.voStandards) {
                _newObject.voStandards.add(applicationCapability == null ? null : applicationCapability.clone());
            }
        }
        _newObject.sourceLanguages = this.sourceLanguages == null ? null : new ArrayList<String>(this.sourceLanguages);
        return _newObject;
    }

    @Override
    public Application createCopy() {
        Application _newObject = (Application)super.createCopy();
        _newObject.cost = this.cost;
        _newObject.licence = this.licence;
        _newObject.openSource = this.openSource;
        if (this.dataFormats == null) {
            _newObject.dataFormats = null;
        } else {
            _newObject.dataFormats = new ArrayList<DataFormat>();
            for (DataFormat dataFormat : this.dataFormats) {
                _newObject.dataFormats.add(dataFormat == null ? null : dataFormat.createCopy());
            }
        }
        if (this.voStandards == null) {
            _newObject.voStandards = null;
        } else {
            _newObject.voStandards = new ArrayList<ApplicationCapability>();
            for (ApplicationCapability applicationCapability : this.voStandards) {
                _newObject.voStandards.add(applicationCapability == null ? null : applicationCapability.createCopy());
            }
        }
        _newObject.sourceLanguages = this.sourceLanguages == null ? null : new ArrayList<String>(this.sourceLanguages);
        _newObject.sourceCodeURL = this.sourceCodeURL;
        return _newObject;
    }

    @Override
    public Application createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree sourceCodeURLPropertyTree;
        PropertyTree propertyTree;
        PropertyTree voStandardsPropertyTree;
        PropertyTree dataFormatsPropertyTree;
        PropertyTree openSourcePropertyTree;
        PropertyTree licencePropertyTree;
        PropertyTree costPropertyTree;
        Application _newObject = (Application)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree2 = costPropertyTree = _propertyTree == null ? null : _propertyTree.get("cost");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? costPropertyTree != null : costPropertyTree == null || !costPropertyTree.isLeaf()) {
            _newObject.cost = this.cost;
        }
        PropertyTree propertyTree3 = licencePropertyTree = _propertyTree == null ? null : _propertyTree.get("licence");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? licencePropertyTree != null : licencePropertyTree == null || !licencePropertyTree.isLeaf()) {
            _newObject.licence = this.licence;
        }
        PropertyTree propertyTree4 = openSourcePropertyTree = _propertyTree == null ? null : _propertyTree.get("openSource");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? openSourcePropertyTree != null : openSourcePropertyTree == null || !openSourcePropertyTree.isLeaf()) {
            _newObject.openSource = this.openSource;
        }
        PropertyTree propertyTree5 = dataFormatsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataFormats");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataFormatsPropertyTree != null : dataFormatsPropertyTree == null || !dataFormatsPropertyTree.isLeaf()) {
            if (this.dataFormats == null) {
                _newObject.dataFormats = null;
            } else {
                _newObject.dataFormats = new ArrayList<DataFormat>();
                for (DataFormat dataFormat : this.dataFormats) {
                    _newObject.dataFormats.add(dataFormat == null ? null : dataFormat.createCopy(dataFormatsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree6 = voStandardsPropertyTree = _propertyTree == null ? null : _propertyTree.get("voStandards");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? voStandardsPropertyTree != null : voStandardsPropertyTree == null || !voStandardsPropertyTree.isLeaf()) {
            if (this.voStandards == null) {
                _newObject.voStandards = null;
            } else {
                _newObject.voStandards = new ArrayList<ApplicationCapability>();
                for (ApplicationCapability _item : this.voStandards) {
                    _newObject.voStandards.add(_item == null ? null : _item.createCopy(voStandardsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree = _propertyTree == null ? null : _propertyTree.get("sourceLanguages");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _newObject.sourceLanguages = this.sourceLanguages == null ? null : new ArrayList<String>(this.sourceLanguages);
        }
        PropertyTree propertyTree8 = sourceCodeURLPropertyTree = _propertyTree == null ? null : _propertyTree.get("sourceCodeURL");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? sourceCodeURLPropertyTree != null : sourceCodeURLPropertyTree == null || !sourceCodeURLPropertyTree.isLeaf()) {
            _newObject.sourceCodeURL = this.sourceCodeURL;
        }
        return _newObject;
    }

    @Override
    public Application copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public Application copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        _other.cost = this.cost;
        _other.licence = this.licence;
        _other.openSource = this.openSource;
        if (this.dataFormats == null) {
            _other.dataFormats = null;
        } else {
            _other.dataFormats = new ArrayList();
            for (DataFormat dataFormat : this.dataFormats) {
                _other.dataFormats.add(dataFormat == null ? null : dataFormat.newCopyBuilder(_other));
            }
        }
        if (this.voStandards == null) {
            _other.voStandards = null;
        } else {
            _other.voStandards = new ArrayList();
            for (ApplicationCapability applicationCapability : this.voStandards) {
                _other.voStandards.add(applicationCapability == null ? null : applicationCapability.newCopyBuilder(_other));
            }
        }
        if (this.sourceLanguages == null) {
            _other.sourceLanguages = null;
        } else {
            _other.sourceLanguages = new ArrayList<Buildable>();
            for (String string : this.sourceLanguages) {
                _other.sourceLanguages.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
            }
        }
        _other.sourceCodeURL = this.sourceCodeURL;
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(Resource _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Application _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree voStandardsPropertyTree;
        PropertyTree dataFormatsPropertyTree;
        PropertyTree openSourcePropertyTree;
        PropertyTree licencePropertyTree;
        PropertyTree costPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree3 = costPropertyTree = _propertyTree == null ? null : _propertyTree.get("cost");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? costPropertyTree != null : costPropertyTree == null || !costPropertyTree.isLeaf()) {
            _other.cost = this.cost;
        }
        PropertyTree propertyTree4 = licencePropertyTree = _propertyTree == null ? null : _propertyTree.get("licence");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? licencePropertyTree != null : licencePropertyTree == null || !licencePropertyTree.isLeaf()) {
            _other.licence = this.licence;
        }
        PropertyTree propertyTree5 = openSourcePropertyTree = _propertyTree == null ? null : _propertyTree.get("openSource");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? openSourcePropertyTree != null : openSourcePropertyTree == null || !openSourcePropertyTree.isLeaf()) {
            _other.openSource = this.openSource;
        }
        PropertyTree propertyTree6 = dataFormatsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataFormats");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataFormatsPropertyTree != null : dataFormatsPropertyTree == null || !dataFormatsPropertyTree.isLeaf()) {
            if (this.dataFormats == null) {
                _other.dataFormats = null;
            } else {
                _other.dataFormats = new ArrayList();
                for (DataFormat dataFormat : this.dataFormats) {
                    _other.dataFormats.add(dataFormat == null ? null : dataFormat.newCopyBuilder(_other, dataFormatsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = voStandardsPropertyTree = _propertyTree == null ? null : _propertyTree.get("voStandards");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? voStandardsPropertyTree != null : voStandardsPropertyTree == null || !voStandardsPropertyTree.isLeaf()) {
            if (this.voStandards == null) {
                _other.voStandards = null;
            } else {
                _other.voStandards = new ArrayList();
                for (ApplicationCapability applicationCapability : this.voStandards) {
                    _other.voStandards.add(applicationCapability == null ? null : applicationCapability.newCopyBuilder(_other, voStandardsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree8 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("sourceLanguages");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.sourceLanguages == null) {
                _other.sourceLanguages = null;
            } else {
                _other.sourceLanguages = new ArrayList<Buildable>();
                for (String _item : this.sourceLanguages) {
                    _other.sourceLanguages.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                }
            }
        }
        PropertyTree propertyTree9 = propertyTree = _propertyTree == null ? null : _propertyTree.get("sourceCodeURL");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _other.sourceCodeURL = this.sourceCodeURL;
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(Resource _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(Application _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(Resource _other, PropertyTree _propertyTree) {
        return Application.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(Application _other, PropertyTree _propertyTree) {
        return Application.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(Resource _other, PropertyTree _propertyTree) {
        return Application.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(Application _other, PropertyTree _propertyTree) {
        return Application.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Application visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty(PropInfo.COST, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.LICENCE, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.OPEN_SOURCE, (Object)this));
        if (_visitor_.visit(new CollectionProperty(PropInfo.DATA_FORMATS, (Object)this)) && this.dataFormats != null) {
            for (DataFormat dataFormat : this.dataFormats) {
                if (dataFormat == null) continue;
                dataFormat.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.VO_STANDARDS, (Object)this)) && this.voStandards != null) {
            for (ApplicationCapability applicationCapability : this.voStandards) {
                if (applicationCapability == null) continue;
                applicationCapability.visit(_visitor_);
            }
        }
        _visitor_.visit(new CollectionProperty(PropInfo.SOURCE_LANGUAGES, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.SOURCE_CODE_URL, (Object)this));
        return this;
    }

    public class Modifier
    extends Resource.Modifier {
        public void setCost(String cost) {
            Application.this.setCost(cost);
        }

        public void setLicence(String licence) {
            Application.this.setLicence(licence);
        }

        public void setOpenSource(Boolean openSource) {
            Application.this.setOpenSource(openSource);
        }

        public List<DataFormat> getDataFormats() {
            if (Application.this.dataFormats == null) {
                Application.this.dataFormats = new ArrayList<DataFormat>();
            }
            return Application.this.dataFormats;
        }

        public List<ApplicationCapability> getVoStandards() {
            if (Application.this.voStandards == null) {
                Application.this.voStandards = new ArrayList<ApplicationCapability>();
            }
            return Application.this.voStandards;
        }

        public List<String> getSourceLanguages() {
            if (Application.this.sourceLanguages == null) {
                Application.this.sourceLanguages = new ArrayList<String>();
            }
            return Application.this.sourceLanguages;
        }

        public void setSourceCodeURL(String sourceCodeURL) {
            Application.this.setSourceCodeURL(sourceCodeURL);
        }
    }

    public static class Builder<_B>
    extends Resource.Builder<_B>
    implements Buildable {
        private String cost;
        private String licence;
        private Boolean openSource;
        private List<DataFormat.Builder<Builder<_B>>> dataFormats;
        private List<ApplicationCapability.Builder<Builder<_B>>> voStandards;
        private List<Buildable> sourceLanguages;
        private String sourceCodeURL;

        public Builder(_B _parentBuilder, Application _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                this.cost = _other.cost;
                this.licence = _other.licence;
                this.openSource = _other.openSource;
                if (_other.dataFormats == null) {
                    this.dataFormats = null;
                } else {
                    this.dataFormats = new ArrayList<DataFormat.Builder<Builder<_B>>>();
                    for (DataFormat dataFormat : _other.dataFormats) {
                        this.dataFormats.add(dataFormat == null ? null : dataFormat.newCopyBuilder(this));
                    }
                }
                if (_other.voStandards == null) {
                    this.voStandards = null;
                } else {
                    this.voStandards = new ArrayList<ApplicationCapability.Builder<Builder<_B>>>();
                    for (ApplicationCapability applicationCapability : _other.voStandards) {
                        this.voStandards.add(applicationCapability == null ? null : applicationCapability.newCopyBuilder(this));
                    }
                }
                if (_other.sourceLanguages == null) {
                    this.sourceLanguages = null;
                } else {
                    this.sourceLanguages = new ArrayList<Buildable>();
                    for (String string : _other.sourceLanguages) {
                        this.sourceLanguages.add((Buildable)(string == null ? null : new Buildable.PrimitiveBuildable((Object)string)));
                    }
                }
                this.sourceCodeURL = _other.sourceCodeURL;
            }
        }

        public Builder(_B _parentBuilder, Application _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree propertyTree;
                PropertyTree propertyTree2;
                PropertyTree voStandardsPropertyTree;
                PropertyTree dataFormatsPropertyTree;
                PropertyTree openSourcePropertyTree;
                PropertyTree licencePropertyTree;
                PropertyTree costPropertyTree;
                PropertyTree propertyTree3 = costPropertyTree = _propertyTree == null ? null : _propertyTree.get("cost");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? costPropertyTree != null : costPropertyTree == null || !costPropertyTree.isLeaf()) {
                    this.cost = _other.cost;
                }
                PropertyTree propertyTree4 = licencePropertyTree = _propertyTree == null ? null : _propertyTree.get("licence");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? licencePropertyTree != null : licencePropertyTree == null || !licencePropertyTree.isLeaf()) {
                    this.licence = _other.licence;
                }
                PropertyTree propertyTree5 = openSourcePropertyTree = _propertyTree == null ? null : _propertyTree.get("openSource");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? openSourcePropertyTree != null : openSourcePropertyTree == null || !openSourcePropertyTree.isLeaf()) {
                    this.openSource = _other.openSource;
                }
                PropertyTree propertyTree6 = dataFormatsPropertyTree = _propertyTree == null ? null : _propertyTree.get("dataFormats");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? dataFormatsPropertyTree != null : dataFormatsPropertyTree == null || !dataFormatsPropertyTree.isLeaf()) {
                    if (_other.dataFormats == null) {
                        this.dataFormats = null;
                    } else {
                        this.dataFormats = new ArrayList<DataFormat.Builder<Builder<_B>>>();
                        for (DataFormat dataFormat : _other.dataFormats) {
                            this.dataFormats.add(dataFormat == null ? null : dataFormat.newCopyBuilder(this, dataFormatsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree7 = voStandardsPropertyTree = _propertyTree == null ? null : _propertyTree.get("voStandards");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? voStandardsPropertyTree != null : voStandardsPropertyTree == null || !voStandardsPropertyTree.isLeaf()) {
                    if (_other.voStandards == null) {
                        this.voStandards = null;
                    } else {
                        this.voStandards = new ArrayList<ApplicationCapability.Builder<Builder<_B>>>();
                        for (ApplicationCapability applicationCapability : _other.voStandards) {
                            this.voStandards.add(applicationCapability == null ? null : applicationCapability.newCopyBuilder(this, voStandardsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree8 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("sourceLanguages");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
                    if (_other.sourceLanguages == null) {
                        this.sourceLanguages = null;
                    } else {
                        this.sourceLanguages = new ArrayList<Buildable>();
                        for (String _item : _other.sourceLanguages) {
                            this.sourceLanguages.add((Buildable)(_item == null ? null : new Buildable.PrimitiveBuildable((Object)_item)));
                        }
                    }
                }
                PropertyTree propertyTree9 = propertyTree = _propertyTree == null ? null : _propertyTree.get("sourceCodeURL");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
                    this.sourceCodeURL = _other.sourceCodeURL;
                }
            }
        }

        @Override
        protected <_P extends Application> _P init(_P _product) {
            _product.cost = this.cost;
            _product.licence = this.licence;
            _product.openSource = this.openSource;
            if (this.dataFormats != null) {
                ArrayList<DataFormat> dataFormats = new ArrayList<DataFormat>(this.dataFormats.size());
                for (DataFormat.Builder builder : this.dataFormats) {
                    dataFormats.add(builder.build());
                }
                _product.dataFormats = dataFormats;
            }
            if (this.voStandards != null) {
                ArrayList<ApplicationCapability> voStandards = new ArrayList<ApplicationCapability>(this.voStandards.size());
                for (ApplicationCapability.Builder builder : this.voStandards) {
                    voStandards.add(builder.build());
                }
                _product.voStandards = voStandards;
            }
            if (this.sourceLanguages != null) {
                ArrayList<String> sourceLanguages = new ArrayList<String>(this.sourceLanguages.size());
                for (Buildable buildable : this.sourceLanguages) {
                    sourceLanguages.add((String)buildable.build());
                }
                _product.sourceLanguages = sourceLanguages;
            }
            _product.sourceCodeURL = this.sourceCodeURL;
            return super.init(_product);
        }

        public Builder<_B> withCost(String cost) {
            this.cost = cost;
            return this;
        }

        public Builder<_B> withLicence(String licence) {
            this.licence = licence;
            return this;
        }

        public Builder<_B> withOpenSource(Boolean openSource) {
            this.openSource = openSource;
            return this;
        }

        public Builder<_B> addDataFormats(Iterable<? extends DataFormat> dataFormats) {
            if (dataFormats != null) {
                if (this.dataFormats == null) {
                    this.dataFormats = new ArrayList<DataFormat.Builder<Builder<_B>>>();
                }
                for (DataFormat dataFormat : dataFormats) {
                    this.dataFormats.add(new DataFormat.Builder<Builder>(this, dataFormat, false));
                }
            }
            return this;
        }

        public Builder<_B> withDataFormats(Iterable<? extends DataFormat> dataFormats) {
            if (this.dataFormats != null) {
                this.dataFormats.clear();
            }
            return this.addDataFormats(dataFormats);
        }

        public Builder<_B> addDataFormats(DataFormat ... dataFormats) {
            this.addDataFormats(Arrays.asList(dataFormats));
            return this;
        }

        public Builder<_B> withDataFormats(DataFormat ... dataFormats) {
            this.withDataFormats(Arrays.asList(dataFormats));
            return this;
        }

        public DataFormat.Builder<? extends Builder<_B>> addDataFormats() {
            if (this.dataFormats == null) {
                this.dataFormats = new ArrayList<DataFormat.Builder<Builder<_B>>>();
            }
            DataFormat.Builder<Builder> dataFormats_Builder = new DataFormat.Builder<Builder>(this, null, false);
            this.dataFormats.add(dataFormats_Builder);
            return dataFormats_Builder;
        }

        public Builder<_B> addVoStandards(Iterable<? extends ApplicationCapability> voStandards) {
            if (voStandards != null) {
                if (this.voStandards == null) {
                    this.voStandards = new ArrayList<ApplicationCapability.Builder<Builder<_B>>>();
                }
                for (ApplicationCapability applicationCapability : voStandards) {
                    this.voStandards.add(new ApplicationCapability.Builder<Builder>(this, applicationCapability, false));
                }
            }
            return this;
        }

        public Builder<_B> withVoStandards(Iterable<? extends ApplicationCapability> voStandards) {
            if (this.voStandards != null) {
                this.voStandards.clear();
            }
            return this.addVoStandards(voStandards);
        }

        public Builder<_B> addVoStandards(ApplicationCapability ... voStandards) {
            this.addVoStandards(Arrays.asList(voStandards));
            return this;
        }

        public Builder<_B> withVoStandards(ApplicationCapability ... voStandards) {
            this.withVoStandards(Arrays.asList(voStandards));
            return this;
        }

        public ApplicationCapability.Builder<? extends Builder<_B>> addVoStandards() {
            if (this.voStandards == null) {
                this.voStandards = new ArrayList<ApplicationCapability.Builder<Builder<_B>>>();
            }
            ApplicationCapability.Builder<Builder> voStandards_Builder = new ApplicationCapability.Builder<Builder>(this, null, false);
            this.voStandards.add(voStandards_Builder);
            return voStandards_Builder;
        }

        public Builder<_B> addSourceLanguages(Iterable<? extends String> sourceLanguages) {
            if (sourceLanguages != null) {
                if (this.sourceLanguages == null) {
                    this.sourceLanguages = new ArrayList<Buildable>();
                }
                for (String string : sourceLanguages) {
                    this.sourceLanguages.add((Buildable)new Buildable.PrimitiveBuildable((Object)string));
                }
            }
            return this;
        }

        public Builder<_B> withSourceLanguages(Iterable<? extends String> sourceLanguages) {
            if (this.sourceLanguages != null) {
                this.sourceLanguages.clear();
            }
            return this.addSourceLanguages(sourceLanguages);
        }

        public Builder<_B> addSourceLanguages(String ... sourceLanguages) {
            this.addSourceLanguages(Arrays.asList(sourceLanguages));
            return this;
        }

        public Builder<_B> withSourceLanguages(String ... sourceLanguages) {
            this.withSourceLanguages(Arrays.asList(sourceLanguages));
            return this;
        }

        public Builder<_B> withSourceCodeURL(String sourceCodeURL) {
            this.sourceCodeURL = sourceCodeURL;
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> addValidationLevels(Validation ... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withValidationLevels(Validation ... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        @Override
        public Builder<_B> withTitle(String title) {
            super.withTitle(title);
            return this;
        }

        @Override
        public Builder<_B> withShortName(String shortName) {
            super.withShortName(shortName);
            return this;
        }

        @Override
        public Builder<_B> withIdentifier(String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> addAltIdentifiers(String ... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withAltIdentifiers(String ... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        @Override
        public Builder<_B> withCuration(Curation curation) {
            super.withCuration(curation);
            return this;
        }

        @Override
        public Curation.Builder<? extends Builder<_B>> withCuration() {
            return super.withCuration();
        }

        @Override
        public Builder<_B> withContent(Content content) {
            super.withContent(content);
            return this;
        }

        @Override
        public Content.Builder<? extends Builder<_B>> withContent() {
            return super.withContent();
        }

        @Override
        public Builder<_B> withCreated(ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        @Override
        public Builder<_B> withUpdated(ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        @Override
        public Builder<_B> withStatus(String status) {
            super.withStatus(status);
            return this;
        }

        @Override
        public Builder<_B> withVersion(String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Application build() {
            if (this._storedValue == null) {
                return this.init(new Application());
            }
            return (Application)this._storedValue;
        }

        public Builder<_B> copyOf(Application _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<Application, String> COST = new SinglePropertyInfo<Application, String>("cost", Application.class, String.class, false, null, new QName("", "cost"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false){

            public String get(Application _instance_) {
                return _instance_ == null ? null : _instance_.cost;
            }

            public void set(Application _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.cost = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Application, String> LICENCE = new SinglePropertyInfo<Application, String>("licence", Application.class, String.class, false, null, new QName("", "licence"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false){

            public String get(Application _instance_) {
                return _instance_ == null ? null : _instance_.licence;
            }

            public void set(Application _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.licence = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Application, Boolean> OPEN_SOURCE = new SinglePropertyInfo<Application, Boolean>("openSource", Application.class, Boolean.class, false, null, new QName("", "openSource"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), false){

            public Boolean get(Application _instance_) {
                return _instance_ == null ? null : _instance_.openSource;
            }

            public void set(Application _instance_, Boolean _value_) {
                if (_instance_ != null) {
                    _instance_.openSource = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Application, DataFormat> DATA_FORMATS = new CollectionPropertyInfo<Application, DataFormat>("dataFormats", Application.class, DataFormat.class, true, null, new QName("", "dataFormat"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "DataFormat"), false){

            public List<DataFormat> get(Application _instance_) {
                return _instance_ == null ? null : _instance_.dataFormats;
            }

            public void set(Application _instance_, List<DataFormat> _value_) {
                if (_instance_ != null) {
                    _instance_.dataFormats = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Application, ApplicationCapability> VO_STANDARDS = new CollectionPropertyInfo<Application, ApplicationCapability>("voStandards", Application.class, ApplicationCapability.class, true, null, new QName("", "voStandard"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "ApplicationCapability"), false){

            public List<ApplicationCapability> get(Application _instance_) {
                return _instance_ == null ? null : _instance_.voStandards;
            }

            public void set(Application _instance_, List<ApplicationCapability> _value_) {
                if (_instance_ != null) {
                    _instance_.voStandards = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<Application, String> SOURCE_LANGUAGES = new CollectionPropertyInfo<Application, String>("sourceLanguages", Application.class, String.class, true, null, new QName("", "sourceLanguage"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "ProgrammingLanguage"), false){

            public List<String> get(Application _instance_) {
                return _instance_ == null ? null : _instance_.sourceLanguages;
            }

            public void set(Application _instance_, List<String> _value_) {
                if (_instance_ != null) {
                    _instance_.sourceLanguages = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<Application, String> SOURCE_CODE_URL = new SinglePropertyInfo<Application, String>("sourceCodeURL", Application.class, String.class, false, null, new QName("", "sourceCodeURL"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false){

            public String get(Application _instance_) {
                return _instance_ == null ? null : _instance_.sourceCodeURL;
            }

            public void set(Application _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.sourceCodeURL = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends Resource.Selector<TRoot, TParent> {
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> cost = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> licence = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> openSource = null;
        private DataFormat.Selector<TRoot, Selector<TRoot, TParent>> dataFormats = null;
        private ApplicationCapability.Selector<TRoot, Selector<TRoot, TParent>> voStandards = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> sourceLanguages = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> sourceCodeURL = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.cost != null) {
                products.put("cost", this.cost.init());
            }
            if (this.licence != null) {
                products.put("licence", this.licence.init());
            }
            if (this.openSource != null) {
                products.put("openSource", this.openSource.init());
            }
            if (this.dataFormats != null) {
                products.put("dataFormats", this.dataFormats.init());
            }
            if (this.voStandards != null) {
                products.put("voStandards", this.voStandards.init());
            }
            if (this.sourceLanguages != null) {
                products.put("sourceLanguages", this.sourceLanguages.init());
            }
            if (this.sourceCodeURL != null) {
                products.put("sourceCodeURL", this.sourceCodeURL.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> cost() {
            return this.cost == null ? (this.cost = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "cost")) : this.cost;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> licence() {
            return this.licence == null ? (this.licence = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "licence")) : this.licence;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> openSource() {
            return this.openSource == null ? (this.openSource = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "openSource")) : this.openSource;
        }

        public DataFormat.Selector<TRoot, Selector<TRoot, TParent>> dataFormats() {
            return this.dataFormats == null ? (this.dataFormats = new DataFormat.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "dataFormats")) : this.dataFormats;
        }

        public ApplicationCapability.Selector<TRoot, Selector<TRoot, TParent>> voStandards() {
            return this.voStandards == null ? (this.voStandards = new ApplicationCapability.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "voStandards")) : this.voStandards;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> sourceLanguages() {
            return this.sourceLanguages == null ? (this.sourceLanguages = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "sourceLanguages")) : this.sourceLanguages;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> sourceCodeURL() {
            return this.sourceCodeURL == null ? (this.sourceCodeURL = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "sourceCodeURL")) : this.sourceCodeURL;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

