/*
 * Decompiled with CFR 0.152.
 */
package org.javastro.ivoa.entities.stc.v1;

import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.javastro.ivoa.entities.stc.v1.AstronTimeType;
import org.javastro.ivoa.entities.stc.v1.CoordinateType;
import org.javastro.ivoa.entities.stc.v1.Double1Type;
import org.javastro.ivoa.entities.stc.v1.StcBaseType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="timeCoordinateType", propOrder={"timeInstant", "errors", "resolutions", "sizes", "pixSizes"})
public class TimeCoordinateType
extends CoordinateType
implements Cloneable,
Copyable,
PartialCopyable,
MergeFrom,
ToString {
    @XmlElement(name="TimeInstant")
    protected AstronTimeType timeInstant;
    @XmlElement(name="Error", nillable=true)
    protected List<Double1Type> errors;
    @XmlElement(name="Resolution", nillable=true)
    protected List<Double1Type> resolutions;
    @XmlElement(name="Size", nillable=true)
    protected List<Double1Type> sizes;
    @XmlElement(name="PixSize", nillable=true)
    protected List<Double1Type> pixSizes;
    @XmlAttribute(name="coord_system_id")
    @XmlIDREF
    @XmlSchemaType(name="IDREF")
    protected Object coordSystemId;
    @XmlAttribute(name="unit")
    protected String unit;

    public TimeCoordinateType() {
    }

    public TimeCoordinateType(String id, Object idref, String ucd, String type, String href, String idType, String idrefType, String name, Object frameId, AstronTimeType timeInstant, List<Double1Type> errors, List<Double1Type> resolutions, List<Double1Type> sizes, List<Double1Type> pixSizes, Object coordSystemId, String unit) {
        super(id, idref, ucd, type, href, idType, idrefType, name, frameId);
        this.timeInstant = timeInstant;
        this.errors = errors;
        this.resolutions = resolutions;
        this.sizes = sizes;
        this.pixSizes = pixSizes;
        this.coordSystemId = coordSystemId;
        this.unit = unit;
    }

    public AstronTimeType getTimeInstant() {
        return this.timeInstant;
    }

    public void setTimeInstant(AstronTimeType value) {
        this.timeInstant = value;
    }

    public List<Double1Type> getErrors() {
        if (this.errors == null) {
            this.errors = new ArrayList<Double1Type>();
        }
        return this.errors;
    }

    public List<Double1Type> getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = new ArrayList<Double1Type>();
        }
        return this.resolutions;
    }

    public List<Double1Type> getSizes() {
        if (this.sizes == null) {
            this.sizes = new ArrayList<Double1Type>();
        }
        return this.sizes;
    }

    public List<Double1Type> getPixSizes() {
        if (this.pixSizes == null) {
            this.pixSizes = new ArrayList<Double1Type>();
        }
        return this.pixSizes;
    }

    public Object getCoordSystemId() {
        return this.coordSystemId;
    }

    public void setCoordSystemId(Object value) {
        this.coordSystemId = value;
    }

    public String getUnit() {
        if (this.unit == null) {
            return "s";
        }
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Double1Type> rightPixSizes;
        List<Double1Type> rightSizes;
        List<Double1Type> rightResolutions;
        List<Double1Type> rightErrors;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TimeCoordinateType that = (TimeCoordinateType)object;
        AstronTimeType leftTimeInstant = this.getTimeInstant();
        AstronTimeType rightTimeInstant = that.getTimeInstant();
        if (this.timeInstant != null) {
            if (that.timeInstant == null) return false;
            if (!leftTimeInstant.equals(rightTimeInstant)) {
                return false;
            }
        } else if (that.timeInstant != null) {
            return false;
        }
        List<Double1Type> leftErrors = this.errors != null && !this.errors.isEmpty() ? this.getErrors() : null;
        List<Double1Type> list = rightErrors = that.errors != null && !that.errors.isEmpty() ? that.getErrors() : null;
        if (this.errors != null && !this.errors.isEmpty()) {
            if (that.errors == null || that.errors.isEmpty()) return false;
            if (!leftErrors.equals(rightErrors)) {
                return false;
            }
        } else if (that.errors != null && !that.errors.isEmpty()) {
            return false;
        }
        List<Double1Type> leftResolutions = this.resolutions != null && !this.resolutions.isEmpty() ? this.getResolutions() : null;
        List<Double1Type> list2 = rightResolutions = that.resolutions != null && !that.resolutions.isEmpty() ? that.getResolutions() : null;
        if (this.resolutions != null && !this.resolutions.isEmpty()) {
            if (that.resolutions == null || that.resolutions.isEmpty()) return false;
            if (!leftResolutions.equals(rightResolutions)) {
                return false;
            }
        } else if (that.resolutions != null && !that.resolutions.isEmpty()) {
            return false;
        }
        List<Double1Type> leftSizes = this.sizes != null && !this.sizes.isEmpty() ? this.getSizes() : null;
        List<Double1Type> list3 = rightSizes = that.sizes != null && !that.sizes.isEmpty() ? that.getSizes() : null;
        if (this.sizes != null && !this.sizes.isEmpty()) {
            if (that.sizes == null || that.sizes.isEmpty()) return false;
            if (!leftSizes.equals(rightSizes)) {
                return false;
            }
        } else if (that.sizes != null && !that.sizes.isEmpty()) {
            return false;
        }
        List<Double1Type> leftPixSizes = this.pixSizes != null && !this.pixSizes.isEmpty() ? this.getPixSizes() : null;
        List<Double1Type> list4 = rightPixSizes = that.pixSizes != null && !that.pixSizes.isEmpty() ? that.getPixSizes() : null;
        if (this.pixSizes != null && !this.pixSizes.isEmpty()) {
            if (that.pixSizes == null || that.pixSizes.isEmpty()) return false;
            if (!leftPixSizes.equals(rightPixSizes)) {
                return false;
            }
        } else if (that.pixSizes != null && !that.pixSizes.isEmpty()) {
            return false;
        }
        Object leftCoordSystemId = this.getCoordSystemId();
        Object rightCoordSystemId = that.getCoordSystemId();
        if (this.coordSystemId != null) {
            if (that.coordSystemId == null) return false;
            if (!leftCoordSystemId.equals(rightCoordSystemId)) {
                return false;
            }
        } else if (that.coordSystemId != null) {
            return false;
        }
        String leftUnit = this.getUnit();
        String rightUnit = that.getUnit();
        if (this.unit != null) {
            if (that.unit == null) return false;
            if (leftUnit.equals(rightUnit)) return true;
            return false;
        }
        if (that.unit == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Double1Type> thePixSizes;
        List<Double1Type> theSizes;
        List<Double1Type> theResolutions;
        List<Double1Type> theErrors;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        AstronTimeType theTimeInstant = this.getTimeInstant();
        if (this.timeInstant != null) {
            currentHashCode += theTimeInstant.hashCode();
        }
        currentHashCode *= 31;
        List<Double1Type> list = theErrors = this.errors != null && !this.errors.isEmpty() ? this.getErrors() : null;
        if (this.errors != null && !this.errors.isEmpty()) {
            currentHashCode += theErrors.hashCode();
        }
        currentHashCode *= 31;
        List<Double1Type> list2 = theResolutions = this.resolutions != null && !this.resolutions.isEmpty() ? this.getResolutions() : null;
        if (this.resolutions != null && !this.resolutions.isEmpty()) {
            currentHashCode += theResolutions.hashCode();
        }
        currentHashCode *= 31;
        List<Double1Type> list3 = theSizes = this.sizes != null && !this.sizes.isEmpty() ? this.getSizes() : null;
        if (this.sizes != null && !this.sizes.isEmpty()) {
            currentHashCode += theSizes.hashCode();
        }
        currentHashCode *= 31;
        List<Double1Type> list4 = thePixSizes = this.pixSizes != null && !this.pixSizes.isEmpty() ? this.getPixSizes() : null;
        if (this.pixSizes != null && !this.pixSizes.isEmpty()) {
            currentHashCode += thePixSizes.hashCode();
        }
        currentHashCode *= 31;
        Object theCoordSystemId = this.getCoordSystemId();
        if (this.coordSystemId != null) {
            currentHashCode += theCoordSystemId.hashCode();
        }
        currentHashCode *= 31;
        String theUnit = this.getUnit();
        if (this.unit != null) {
            currentHashCode += theUnit.hashCode();
        }
        return currentHashCode;
    }

    @Override
    public String toString() {
        JAXBToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        StringBuilder buffer = new StringBuilder();
        this.append(null, buffer, (ToStringStrategy)strategy);
        return buffer.toString();
    }

    @Override
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, (Object)this, buffer);
        this.appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, (Object)this, buffer);
        return buffer;
    }

    @Override
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        AstronTimeType theTimeInstant = this.getTimeInstant();
        strategy.appendField(locator, (Object)this, "timeInstant", buffer, (Object)theTimeInstant, this.timeInstant != null);
        List<Double1Type> theErrors = this.errors != null && !this.errors.isEmpty() ? this.getErrors() : null;
        strategy.appendField(locator, (Object)this, "errors", buffer, theErrors, this.errors != null && !this.errors.isEmpty());
        List<Double1Type> theResolutions = this.resolutions != null && !this.resolutions.isEmpty() ? this.getResolutions() : null;
        strategy.appendField(locator, (Object)this, "resolutions", buffer, theResolutions, this.resolutions != null && !this.resolutions.isEmpty());
        List<Double1Type> theSizes = this.sizes != null && !this.sizes.isEmpty() ? this.getSizes() : null;
        strategy.appendField(locator, (Object)this, "sizes", buffer, theSizes, this.sizes != null && !this.sizes.isEmpty());
        List<Double1Type> thePixSizes = this.pixSizes != null && !this.pixSizes.isEmpty() ? this.getPixSizes() : null;
        strategy.appendField(locator, (Object)this, "pixSizes", buffer, thePixSizes, this.pixSizes != null && !this.pixSizes.isEmpty());
        Object theCoordSystemId = this.getCoordSystemId();
        strategy.appendField(locator, (Object)this, "coordSystemId", buffer, theCoordSystemId, this.coordSystemId != null);
        String theUnit = this.getUnit();
        strategy.appendField(locator, (Object)this, "unit", buffer, (Object)theUnit, this.unit != null);
        return buffer;
    }

    @Override
    public void mergeFrom(Object left, Object right) {
        JAXBMergeStrategy strategy = JAXBMergeStrategy.getInstance();
        this.mergeFrom(null, null, left, right, (MergeStrategy)strategy);
    }

    @Override
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof TimeCoordinateType) {
            TimeCoordinateType target = this;
            TimeCoordinateType leftObject = (TimeCoordinateType)left;
            TimeCoordinateType rightObject = (TimeCoordinateType)right;
            Boolean timeInstantShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.timeInstant != null, rightObject.timeInstant != null);
            if (timeInstantShouldBeMergedAndSet == Boolean.TRUE) {
                AstronTimeType lhsTimeInstant = leftObject.getTimeInstant();
                AstronTimeType rhsTimeInstant = rightObject.getTimeInstant();
                AstronTimeType mergedTimeInstant = (AstronTimeType)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"timeInstant", (Object)lhsTimeInstant), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"timeInstant", (Object)rhsTimeInstant), (Object)lhsTimeInstant, (Object)rhsTimeInstant, leftObject.timeInstant != null, rightObject.timeInstant != null);
                target.setTimeInstant(mergedTimeInstant);
            } else if (timeInstantShouldBeMergedAndSet == Boolean.FALSE) {
                target.timeInstant = null;
            }
            Boolean errorsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.errors != null && !leftObject.errors.isEmpty(), rightObject.errors != null && !rightObject.errors.isEmpty());
            if (errorsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Double1Type> lhsErrors = leftObject.errors != null && !leftObject.errors.isEmpty() ? leftObject.getErrors() : null;
                List<Double1Type> rhsErrors = rightObject.errors != null && !rightObject.errors.isEmpty() ? rightObject.getErrors() : null;
                List mergedErrors = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"errors", lhsErrors), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"errors", rhsErrors), lhsErrors, rhsErrors, leftObject.errors != null && !leftObject.errors.isEmpty(), rightObject.errors != null && !rightObject.errors.isEmpty());
                target.errors = null;
                if (mergedErrors != null) {
                    List<Double1Type> uniqueErrorsl = target.getErrors();
                    uniqueErrorsl.addAll(mergedErrors);
                }
            } else if (errorsShouldBeMergedAndSet == Boolean.FALSE) {
                target.errors = null;
            }
            Boolean resolutionsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.resolutions != null && !leftObject.resolutions.isEmpty(), rightObject.resolutions != null && !rightObject.resolutions.isEmpty());
            if (resolutionsShouldBeMergedAndSet == Boolean.TRUE) {
                List<Double1Type> lhsResolutions = leftObject.resolutions != null && !leftObject.resolutions.isEmpty() ? leftObject.getResolutions() : null;
                List<Double1Type> rhsResolutions = rightObject.resolutions != null && !rightObject.resolutions.isEmpty() ? rightObject.getResolutions() : null;
                List mergedResolutions = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"resolutions", lhsResolutions), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"resolutions", rhsResolutions), lhsResolutions, rhsResolutions, leftObject.resolutions != null && !leftObject.resolutions.isEmpty(), rightObject.resolutions != null && !rightObject.resolutions.isEmpty());
                target.resolutions = null;
                if (mergedResolutions != null) {
                    List<Double1Type> uniqueResolutionsl = target.getResolutions();
                    uniqueResolutionsl.addAll(mergedResolutions);
                }
            } else if (resolutionsShouldBeMergedAndSet == Boolean.FALSE) {
                target.resolutions = null;
            }
            Boolean sizesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.sizes != null && !leftObject.sizes.isEmpty(), rightObject.sizes != null && !rightObject.sizes.isEmpty());
            if (sizesShouldBeMergedAndSet == Boolean.TRUE) {
                List<Double1Type> lhsSizes = leftObject.sizes != null && !leftObject.sizes.isEmpty() ? leftObject.getSizes() : null;
                List<Double1Type> rhsSizes = rightObject.sizes != null && !rightObject.sizes.isEmpty() ? rightObject.getSizes() : null;
                List mergedSizes = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"sizes", lhsSizes), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"sizes", rhsSizes), lhsSizes, rhsSizes, leftObject.sizes != null && !leftObject.sizes.isEmpty(), rightObject.sizes != null && !rightObject.sizes.isEmpty());
                target.sizes = null;
                if (mergedSizes != null) {
                    List<Double1Type> uniqueSizesl = target.getSizes();
                    uniqueSizesl.addAll(mergedSizes);
                }
            } else if (sizesShouldBeMergedAndSet == Boolean.FALSE) {
                target.sizes = null;
            }
            Boolean pixSizesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.pixSizes != null && !leftObject.pixSizes.isEmpty(), rightObject.pixSizes != null && !rightObject.pixSizes.isEmpty());
            if (pixSizesShouldBeMergedAndSet == Boolean.TRUE) {
                List<Double1Type> lhsPixSizes = leftObject.pixSizes != null && !leftObject.pixSizes.isEmpty() ? leftObject.getPixSizes() : null;
                List<Double1Type> rhsPixSizes = rightObject.pixSizes != null && !rightObject.pixSizes.isEmpty() ? rightObject.getPixSizes() : null;
                List mergedPixSizes = (List)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"pixSizes", lhsPixSizes), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"pixSizes", rhsPixSizes), lhsPixSizes, rhsPixSizes, leftObject.pixSizes != null && !leftObject.pixSizes.isEmpty(), rightObject.pixSizes != null && !rightObject.pixSizes.isEmpty());
                target.pixSizes = null;
                if (mergedPixSizes != null) {
                    List<Double1Type> uniquePixSizesl = target.getPixSizes();
                    uniquePixSizesl.addAll(mergedPixSizes);
                }
            } else if (pixSizesShouldBeMergedAndSet == Boolean.FALSE) {
                target.pixSizes = null;
            }
            Boolean coordSystemIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.coordSystemId != null, rightObject.coordSystemId != null);
            if (coordSystemIdShouldBeMergedAndSet == Boolean.TRUE) {
                Object lhsCoordSystemId = leftObject.getCoordSystemId();
                Object rhsCoordSystemId = rightObject.getCoordSystemId();
                Object mergedCoordSystemId = strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"coordSystemId", (Object)lhsCoordSystemId), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"coordSystemId", (Object)rhsCoordSystemId), lhsCoordSystemId, rhsCoordSystemId, leftObject.coordSystemId != null, rightObject.coordSystemId != null);
                target.setCoordSystemId(mergedCoordSystemId);
            } else if (coordSystemIdShouldBeMergedAndSet == Boolean.FALSE) {
                target.coordSystemId = null;
            }
            Boolean unitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, leftObject.unit != null, rightObject.unit != null);
            if (unitShouldBeMergedAndSet == Boolean.TRUE) {
                String lhsUnit = leftObject.getUnit();
                String rhsUnit = rightObject.getUnit();
                String mergedUnit = (String)strategy.merge((ObjectLocator)LocatorUtils.property((ObjectLocator)leftLocator, (String)"unit", (Object)lhsUnit), (ObjectLocator)LocatorUtils.property((ObjectLocator)rightLocator, (String)"unit", (Object)rhsUnit), (Object)lhsUnit, (Object)rhsUnit, leftObject.unit != null, rightObject.unit != null);
                target.setUnit(mergedUnit);
            } else if (unitShouldBeMergedAndSet == Boolean.FALSE) {
                target.unit = null;
            }
        }
    }

    @Override
    public Object createNewInstance() {
        return new TimeCoordinateType();
    }

    @Override
    public TimeCoordinateType clone() {
        TimeCoordinateType _newObject = (TimeCoordinateType)super.clone();
        AstronTimeType astronTimeType = _newObject.timeInstant = this.timeInstant == null ? null : this.timeInstant.clone();
        if (this.errors == null) {
            _newObject.errors = null;
        } else {
            _newObject.errors = new ArrayList<Double1Type>();
            for (Double1Type _item : this.errors) {
                _newObject.errors.add(_item == null ? null : _item.clone());
            }
        }
        if (this.resolutions == null) {
            _newObject.resolutions = null;
        } else {
            _newObject.resolutions = new ArrayList<Double1Type>();
            for (Double1Type _item : this.resolutions) {
                _newObject.resolutions.add(_item == null ? null : _item.clone());
            }
        }
        if (this.sizes == null) {
            _newObject.sizes = null;
        } else {
            _newObject.sizes = new ArrayList<Double1Type>();
            for (Double1Type _item : this.sizes) {
                _newObject.sizes.add(_item == null ? null : _item.clone());
            }
        }
        if (this.pixSizes == null) {
            _newObject.pixSizes = null;
        } else {
            _newObject.pixSizes = new ArrayList<Double1Type>();
            for (Double1Type _item : this.pixSizes) {
                _newObject.pixSizes.add(_item == null ? null : _item.clone());
            }
        }
        return _newObject;
    }

    @Override
    public TimeCoordinateType createCopy() {
        TimeCoordinateType _newObject = (TimeCoordinateType)super.createCopy();
        AstronTimeType astronTimeType = _newObject.timeInstant = this.timeInstant == null ? null : this.timeInstant.createCopy();
        if (this.errors == null) {
            _newObject.errors = null;
        } else {
            _newObject.errors = new ArrayList<Double1Type>();
            for (Double1Type _item : this.errors) {
                _newObject.errors.add(_item == null ? null : _item.createCopy());
            }
        }
        if (this.resolutions == null) {
            _newObject.resolutions = null;
        } else {
            _newObject.resolutions = new ArrayList<Double1Type>();
            for (Double1Type _item : this.resolutions) {
                _newObject.resolutions.add(_item == null ? null : _item.createCopy());
            }
        }
        if (this.sizes == null) {
            _newObject.sizes = null;
        } else {
            _newObject.sizes = new ArrayList<Double1Type>();
            for (Double1Type _item : this.sizes) {
                _newObject.sizes.add(_item == null ? null : _item.createCopy());
            }
        }
        if (this.pixSizes == null) {
            _newObject.pixSizes = null;
        } else {
            _newObject.pixSizes = new ArrayList<Double1Type>();
            for (Double1Type _item : this.pixSizes) {
                _newObject.pixSizes.add(_item == null ? null : _item.createCopy());
            }
        }
        _newObject.coordSystemId = this.coordSystemId;
        _newObject.unit = this.unit;
        return _newObject;
    }

    @Override
    public TimeCoordinateType createCopy(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree unitPropertyTree;
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree propertyTree3;
        PropertyTree resolutionsPropertyTree;
        PropertyTree errorsPropertyTree;
        PropertyTree timeInstantPropertyTree;
        TimeCoordinateType _newObject = (TimeCoordinateType)super.createCopy(_propertyTree, _propertyTreeUse);
        PropertyTree propertyTree4 = timeInstantPropertyTree = _propertyTree == null ? null : _propertyTree.get("timeInstant");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? timeInstantPropertyTree != null : timeInstantPropertyTree == null || !timeInstantPropertyTree.isLeaf()) {
            _newObject.timeInstant = this.timeInstant == null ? null : this.timeInstant.createCopy(timeInstantPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree5 = errorsPropertyTree = _propertyTree == null ? null : _propertyTree.get("errors");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? errorsPropertyTree != null : errorsPropertyTree == null || !errorsPropertyTree.isLeaf()) {
            if (this.errors == null) {
                _newObject.errors = null;
            } else {
                _newObject.errors = new ArrayList<Double1Type>();
                for (Double1Type double1Type : this.errors) {
                    _newObject.errors.add(double1Type == null ? null : double1Type.createCopy(errorsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree6 = resolutionsPropertyTree = _propertyTree == null ? null : _propertyTree.get("resolutions");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? resolutionsPropertyTree != null : resolutionsPropertyTree == null || !resolutionsPropertyTree.isLeaf()) {
            if (this.resolutions == null) {
                _newObject.resolutions = null;
            } else {
                _newObject.resolutions = new ArrayList<Double1Type>();
                for (Double1Type double1Type : this.resolutions) {
                    _newObject.resolutions.add(double1Type == null ? null : double1Type.createCopy(resolutionsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("sizes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
            if (this.sizes == null) {
                _newObject.sizes = null;
            } else {
                _newObject.sizes = new ArrayList<Double1Type>();
                for (Double1Type double1Type : this.sizes) {
                    _newObject.sizes.add(double1Type == null ? null : double1Type.createCopy(propertyTree3, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree8 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("pixSizes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.pixSizes == null) {
                _newObject.pixSizes = null;
            } else {
                _newObject.pixSizes = new ArrayList<Double1Type>();
                for (Double1Type _item : this.pixSizes) {
                    _newObject.pixSizes.add(_item == null ? null : _item.createCopy(propertyTree2, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree9 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coordSystemId");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _newObject.coordSystemId = this.coordSystemId;
        }
        PropertyTree propertyTree10 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
            _newObject.unit = this.unit;
        }
        return _newObject;
    }

    @Override
    public TimeCoordinateType copyExcept(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    public TimeCoordinateType copyOnly(PropertyTree _propertyTree) {
        return this.createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Modifier();
        }
        return (Modifier)this.__cachedModifier__;
    }

    public <_B> void copyTo(Builder<_B> _other) {
        super.copyTo(_other);
        AstronTimeType.Builder<Builder<Builder<_B>>> builder = _other.timeInstant = this.timeInstant == null ? null : this.timeInstant.newCopyBuilder(_other);
        if (this.errors == null) {
            _other.errors = null;
        } else {
            _other.errors = new ArrayList();
            for (Double1Type _item : this.errors) {
                _other.errors.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
        if (this.resolutions == null) {
            _other.resolutions = null;
        } else {
            _other.resolutions = new ArrayList();
            for (Double1Type _item : this.resolutions) {
                _other.resolutions.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
        if (this.sizes == null) {
            _other.sizes = null;
        } else {
            _other.sizes = new ArrayList();
            for (Double1Type _item : this.sizes) {
                _other.sizes.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
        if (this.pixSizes == null) {
            _other.pixSizes = null;
        } else {
            _other.pixSizes = new ArrayList();
            for (Double1Type _item : this.pixSizes) {
                _other.pixSizes.add(_item == null ? null : _item.newCopyBuilder(_other));
            }
        }
        _other.coordSystemId = this.coordSystemId;
        _other.unit = this.unit;
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder) {
        return new Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    public Builder<Void> newCopyBuilder() {
        return this.newCopyBuilder((Object)null);
    }

    public static Builder<Void> builder() {
        return new Builder<Object>(null, null, false);
    }

    public static <_B> Builder<_B> copyOf(StcBaseType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(CoordinateType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(TimeCoordinateType _other) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    public <_B> void copyTo(Builder<_B> _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        PropertyTree unitPropertyTree;
        PropertyTree propertyTree;
        PropertyTree propertyTree2;
        PropertyTree propertyTree3;
        PropertyTree resolutionsPropertyTree;
        PropertyTree errorsPropertyTree;
        PropertyTree timeInstantPropertyTree;
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        PropertyTree propertyTree4 = timeInstantPropertyTree = _propertyTree == null ? null : _propertyTree.get("timeInstant");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? timeInstantPropertyTree != null : timeInstantPropertyTree == null || !timeInstantPropertyTree.isLeaf()) {
            _other.timeInstant = this.timeInstant == null ? null : this.timeInstant.newCopyBuilder(_other, timeInstantPropertyTree, _propertyTreeUse);
        }
        PropertyTree propertyTree5 = errorsPropertyTree = _propertyTree == null ? null : _propertyTree.get("errors");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? errorsPropertyTree != null : errorsPropertyTree == null || !errorsPropertyTree.isLeaf()) {
            if (this.errors == null) {
                _other.errors = null;
            } else {
                _other.errors = new ArrayList();
                for (Double1Type double1Type : this.errors) {
                    _other.errors.add(double1Type == null ? null : double1Type.newCopyBuilder(_other, errorsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree6 = resolutionsPropertyTree = _propertyTree == null ? null : _propertyTree.get("resolutions");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? resolutionsPropertyTree != null : resolutionsPropertyTree == null || !resolutionsPropertyTree.isLeaf()) {
            if (this.resolutions == null) {
                _other.resolutions = null;
            } else {
                _other.resolutions = new ArrayList();
                for (Double1Type double1Type : this.resolutions) {
                    _other.resolutions.add(double1Type == null ? null : double1Type.newCopyBuilder(_other, resolutionsPropertyTree, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree7 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("sizes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
            if (this.sizes == null) {
                _other.sizes = null;
            } else {
                _other.sizes = new ArrayList();
                for (Double1Type double1Type : this.sizes) {
                    _other.sizes.add(double1Type == null ? null : double1Type.newCopyBuilder(_other, propertyTree3, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree8 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("pixSizes");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
            if (this.pixSizes == null) {
                _other.pixSizes = null;
            } else {
                _other.pixSizes = new ArrayList();
                for (Double1Type _item : this.pixSizes) {
                    _other.pixSizes.add(_item == null ? null : _item.newCopyBuilder(_other, propertyTree2, _propertyTreeUse));
                }
            }
        }
        PropertyTree propertyTree9 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coordSystemId");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
            _other.coordSystemId = this.coordSystemId;
        }
        PropertyTree propertyTree10 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
        if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
            _other.unit = this.unit;
        }
    }

    public <_B> Builder<_B> newCopyBuilder(_B _parentBuilder, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return new Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    public Builder<Void> newCopyBuilder(PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        return this.newCopyBuilder((Object)null, _propertyTree, _propertyTreeUse);
    }

    public static <_B> Builder<_B> copyOf(StcBaseType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(CoordinateType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static <_B> Builder<_B> copyOf(TimeCoordinateType _other, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
        Builder<Object> _newBuilder = new Builder<Object>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    public static Builder<Void> copyExcept(StcBaseType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(CoordinateType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyExcept(TimeCoordinateType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    public static Builder<Void> copyOnly(StcBaseType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(CoordinateType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    public static Builder<Void> copyOnly(TimeCoordinateType _other, PropertyTree _propertyTree) {
        return TimeCoordinateType.copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Override
    public TimeCoordinateType visit(PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty(PropInfo.TIME_INSTANT, (Object)this)) && this.timeInstant != null) {
            this.timeInstant.visit(_visitor_);
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.ERRORS, (Object)this)) && this.errors != null) {
            for (Double1Type _item_ : this.errors) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.RESOLUTIONS, (Object)this)) && this.resolutions != null) {
            for (Double1Type _item_ : this.resolutions) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.SIZES, (Object)this)) && this.sizes != null) {
            for (Double1Type _item_ : this.sizes) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        if (_visitor_.visit(new CollectionProperty(PropInfo.PIX_SIZES, (Object)this)) && this.pixSizes != null) {
            for (Double1Type _item_ : this.pixSizes) {
                if (_item_ == null) continue;
                _item_.visit(_visitor_);
            }
        }
        _visitor_.visit(new SingleProperty(PropInfo.COORD_SYSTEM_ID, (Object)this));
        _visitor_.visit(new SingleProperty(PropInfo.UNIT, (Object)this));
        return this;
    }

    public class Modifier
    extends CoordinateType.Modifier {
        public void setTimeInstant(AstronTimeType timeInstant) {
            TimeCoordinateType.this.setTimeInstant(timeInstant);
        }

        public List<Double1Type> getErrors() {
            if (TimeCoordinateType.this.errors == null) {
                TimeCoordinateType.this.errors = new ArrayList<Double1Type>();
            }
            return TimeCoordinateType.this.errors;
        }

        public List<Double1Type> getResolutions() {
            if (TimeCoordinateType.this.resolutions == null) {
                TimeCoordinateType.this.resolutions = new ArrayList<Double1Type>();
            }
            return TimeCoordinateType.this.resolutions;
        }

        public List<Double1Type> getSizes() {
            if (TimeCoordinateType.this.sizes == null) {
                TimeCoordinateType.this.sizes = new ArrayList<Double1Type>();
            }
            return TimeCoordinateType.this.sizes;
        }

        public List<Double1Type> getPixSizes() {
            if (TimeCoordinateType.this.pixSizes == null) {
                TimeCoordinateType.this.pixSizes = new ArrayList<Double1Type>();
            }
            return TimeCoordinateType.this.pixSizes;
        }

        public void setCoordSystemId(Object coordSystemId) {
            TimeCoordinateType.this.setCoordSystemId(coordSystemId);
        }

        public void setUnit(String unit) {
            TimeCoordinateType.this.setUnit(unit);
        }
    }

    public static class Builder<_B>
    extends CoordinateType.Builder<_B>
    implements Buildable {
        private AstronTimeType.Builder<Builder<_B>> timeInstant;
        private List<Double1Type.Builder<Builder<_B>>> errors;
        private List<Double1Type.Builder<Builder<_B>>> resolutions;
        private List<Double1Type.Builder<Builder<_B>>> sizes;
        private List<Double1Type.Builder<Builder<_B>>> pixSizes;
        private Object coordSystemId;
        private String unit = "s";

        public Builder(_B _parentBuilder, TimeCoordinateType _other, boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other != null) {
                AstronTimeType.Builder<Builder> builder = this.timeInstant = _other.timeInstant == null ? null : _other.timeInstant.newCopyBuilder(this);
                if (_other.errors == null) {
                    this.errors = null;
                } else {
                    this.errors = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                    for (Double1Type _item : _other.errors) {
                        this.errors.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
                if (_other.resolutions == null) {
                    this.resolutions = null;
                } else {
                    this.resolutions = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                    for (Double1Type _item : _other.resolutions) {
                        this.resolutions.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
                if (_other.sizes == null) {
                    this.sizes = null;
                } else {
                    this.sizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                    for (Double1Type _item : _other.sizes) {
                        this.sizes.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
                if (_other.pixSizes == null) {
                    this.pixSizes = null;
                } else {
                    this.pixSizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                    for (Double1Type _item : _other.pixSizes) {
                        this.pixSizes.add(_item == null ? null : _item.newCopyBuilder(this));
                    }
                }
                this.coordSystemId = _other.coordSystemId;
                this.unit = _other.unit;
            }
        }

        public Builder(_B _parentBuilder, TimeCoordinateType _other, boolean _copy, PropertyTree _propertyTree, PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other != null) {
                PropertyTree unitPropertyTree;
                PropertyTree propertyTree;
                PropertyTree propertyTree2;
                PropertyTree propertyTree3;
                PropertyTree resolutionsPropertyTree;
                PropertyTree errorsPropertyTree;
                PropertyTree timeInstantPropertyTree;
                PropertyTree propertyTree4 = timeInstantPropertyTree = _propertyTree == null ? null : _propertyTree.get("timeInstant");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? timeInstantPropertyTree != null : timeInstantPropertyTree == null || !timeInstantPropertyTree.isLeaf()) {
                    this.timeInstant = _other.timeInstant == null ? null : _other.timeInstant.newCopyBuilder(this, timeInstantPropertyTree, _propertyTreeUse);
                }
                PropertyTree propertyTree5 = errorsPropertyTree = _propertyTree == null ? null : _propertyTree.get("errors");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? errorsPropertyTree != null : errorsPropertyTree == null || !errorsPropertyTree.isLeaf()) {
                    if (_other.errors == null) {
                        this.errors = null;
                    } else {
                        this.errors = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                        for (Double1Type double1Type : _other.errors) {
                            this.errors.add(double1Type == null ? null : double1Type.newCopyBuilder(this, errorsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree6 = resolutionsPropertyTree = _propertyTree == null ? null : _propertyTree.get("resolutions");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? resolutionsPropertyTree != null : resolutionsPropertyTree == null || !resolutionsPropertyTree.isLeaf()) {
                    if (_other.resolutions == null) {
                        this.resolutions = null;
                    } else {
                        this.resolutions = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                        for (Double1Type double1Type : _other.resolutions) {
                            this.resolutions.add(double1Type == null ? null : double1Type.newCopyBuilder(this, resolutionsPropertyTree, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree7 = propertyTree3 = _propertyTree == null ? null : _propertyTree.get("sizes");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree3 != null : propertyTree3 == null || !propertyTree3.isLeaf()) {
                    if (_other.sizes == null) {
                        this.sizes = null;
                    } else {
                        this.sizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                        for (Double1Type double1Type : _other.sizes) {
                            this.sizes.add(double1Type == null ? null : double1Type.newCopyBuilder(this, propertyTree3, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree8 = propertyTree2 = _propertyTree == null ? null : _propertyTree.get("pixSizes");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree2 != null : propertyTree2 == null || !propertyTree2.isLeaf()) {
                    if (_other.pixSizes == null) {
                        this.pixSizes = null;
                    } else {
                        this.pixSizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                        for (Double1Type _item : _other.pixSizes) {
                            this.pixSizes.add(_item == null ? null : _item.newCopyBuilder(this, propertyTree2, _propertyTreeUse));
                        }
                    }
                }
                PropertyTree propertyTree9 = propertyTree = _propertyTree == null ? null : _propertyTree.get("coordSystemId");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? propertyTree != null : propertyTree == null || !propertyTree.isLeaf()) {
                    this.coordSystemId = _other.coordSystemId;
                }
                PropertyTree propertyTree10 = unitPropertyTree = _propertyTree == null ? null : _propertyTree.get("unit");
                if (_propertyTreeUse == PropertyTreeUse.INCLUDE ? unitPropertyTree != null : unitPropertyTree == null || !unitPropertyTree.isLeaf()) {
                    this.unit = _other.unit;
                }
            }
        }

        @Override
        protected <_P extends TimeCoordinateType> _P init(_P _product) {
            AstronTimeType astronTimeType = _product.timeInstant = this.timeInstant == null ? null : this.timeInstant.build();
            if (this.errors != null) {
                ArrayList<Double1Type> errors = new ArrayList<Double1Type>(this.errors.size());
                for (Double1Type.Builder<Builder<_B>> _item : this.errors) {
                    errors.add(_item.build());
                }
                _product.errors = errors;
            }
            if (this.resolutions != null) {
                ArrayList<Double1Type> resolutions = new ArrayList<Double1Type>(this.resolutions.size());
                for (Double1Type.Builder<Builder<_B>> _item : this.resolutions) {
                    resolutions.add(_item.build());
                }
                _product.resolutions = resolutions;
            }
            if (this.sizes != null) {
                ArrayList<Double1Type> sizes = new ArrayList<Double1Type>(this.sizes.size());
                for (Double1Type.Builder<Builder<_B>> _item : this.sizes) {
                    sizes.add(_item.build());
                }
                _product.sizes = sizes;
            }
            if (this.pixSizes != null) {
                ArrayList<Double1Type> pixSizes = new ArrayList<Double1Type>(this.pixSizes.size());
                for (Double1Type.Builder<Builder<_B>> _item : this.pixSizes) {
                    pixSizes.add(_item.build());
                }
                _product.pixSizes = pixSizes;
            }
            _product.coordSystemId = this.coordSystemId;
            _product.unit = this.unit;
            return super.init(_product);
        }

        public Builder<_B> withTimeInstant(AstronTimeType timeInstant) {
            this.timeInstant = timeInstant == null ? null : new AstronTimeType.Builder<Builder>(this, timeInstant, false);
            return this;
        }

        public AstronTimeType.Builder<? extends Builder<_B>> withTimeInstant() {
            if (this.timeInstant != null) {
                return this.timeInstant;
            }
            this.timeInstant = new AstronTimeType.Builder<Builder>(this, null, false);
            return this.timeInstant;
        }

        public Builder<_B> addErrors(Iterable<? extends Double1Type> errors) {
            if (errors != null) {
                if (this.errors == null) {
                    this.errors = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                }
                for (Double1Type double1Type : errors) {
                    this.errors.add(new Double1Type.Builder<Builder>(this, double1Type, false));
                }
            }
            return this;
        }

        public Builder<_B> withErrors(Iterable<? extends Double1Type> errors) {
            if (this.errors != null) {
                this.errors.clear();
            }
            return this.addErrors(errors);
        }

        public Builder<_B> addErrors(Double1Type ... errors) {
            this.addErrors(Arrays.asList(errors));
            return this;
        }

        public Builder<_B> withErrors(Double1Type ... errors) {
            this.withErrors(Arrays.asList(errors));
            return this;
        }

        public Double1Type.Builder<? extends Builder<_B>> addErrors() {
            if (this.errors == null) {
                this.errors = new ArrayList<Double1Type.Builder<Builder<_B>>>();
            }
            Double1Type.Builder<Builder> errors_Builder = new Double1Type.Builder<Builder>(this, null, false);
            this.errors.add(errors_Builder);
            return errors_Builder;
        }

        public Builder<_B> addResolutions(Iterable<? extends Double1Type> resolutions) {
            if (resolutions != null) {
                if (this.resolutions == null) {
                    this.resolutions = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                }
                for (Double1Type double1Type : resolutions) {
                    this.resolutions.add(new Double1Type.Builder<Builder>(this, double1Type, false));
                }
            }
            return this;
        }

        public Builder<_B> withResolutions(Iterable<? extends Double1Type> resolutions) {
            if (this.resolutions != null) {
                this.resolutions.clear();
            }
            return this.addResolutions(resolutions);
        }

        public Builder<_B> addResolutions(Double1Type ... resolutions) {
            this.addResolutions(Arrays.asList(resolutions));
            return this;
        }

        public Builder<_B> withResolutions(Double1Type ... resolutions) {
            this.withResolutions(Arrays.asList(resolutions));
            return this;
        }

        public Double1Type.Builder<? extends Builder<_B>> addResolutions() {
            if (this.resolutions == null) {
                this.resolutions = new ArrayList<Double1Type.Builder<Builder<_B>>>();
            }
            Double1Type.Builder<Builder> resolutions_Builder = new Double1Type.Builder<Builder>(this, null, false);
            this.resolutions.add(resolutions_Builder);
            return resolutions_Builder;
        }

        public Builder<_B> addSizes(Iterable<? extends Double1Type> sizes) {
            if (sizes != null) {
                if (this.sizes == null) {
                    this.sizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                }
                for (Double1Type double1Type : sizes) {
                    this.sizes.add(new Double1Type.Builder<Builder>(this, double1Type, false));
                }
            }
            return this;
        }

        public Builder<_B> withSizes(Iterable<? extends Double1Type> sizes) {
            if (this.sizes != null) {
                this.sizes.clear();
            }
            return this.addSizes(sizes);
        }

        public Builder<_B> addSizes(Double1Type ... sizes) {
            this.addSizes(Arrays.asList(sizes));
            return this;
        }

        public Builder<_B> withSizes(Double1Type ... sizes) {
            this.withSizes(Arrays.asList(sizes));
            return this;
        }

        public Double1Type.Builder<? extends Builder<_B>> addSizes() {
            if (this.sizes == null) {
                this.sizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
            }
            Double1Type.Builder<Builder> sizes_Builder = new Double1Type.Builder<Builder>(this, null, false);
            this.sizes.add(sizes_Builder);
            return sizes_Builder;
        }

        public Builder<_B> addPixSizes(Iterable<? extends Double1Type> pixSizes) {
            if (pixSizes != null) {
                if (this.pixSizes == null) {
                    this.pixSizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
                }
                for (Double1Type double1Type : pixSizes) {
                    this.pixSizes.add(new Double1Type.Builder<Builder>(this, double1Type, false));
                }
            }
            return this;
        }

        public Builder<_B> withPixSizes(Iterable<? extends Double1Type> pixSizes) {
            if (this.pixSizes != null) {
                this.pixSizes.clear();
            }
            return this.addPixSizes(pixSizes);
        }

        public Builder<_B> addPixSizes(Double1Type ... pixSizes) {
            this.addPixSizes(Arrays.asList(pixSizes));
            return this;
        }

        public Builder<_B> withPixSizes(Double1Type ... pixSizes) {
            this.withPixSizes(Arrays.asList(pixSizes));
            return this;
        }

        public Double1Type.Builder<? extends Builder<_B>> addPixSizes() {
            if (this.pixSizes == null) {
                this.pixSizes = new ArrayList<Double1Type.Builder<Builder<_B>>>();
            }
            Double1Type.Builder<Builder> pixSizes_Builder = new Double1Type.Builder<Builder>(this, null, false);
            this.pixSizes.add(pixSizes_Builder);
            return pixSizes_Builder;
        }

        public Builder<_B> withCoordSystemId(Object coordSystemId) {
            this.coordSystemId = coordSystemId;
            return this;
        }

        public Builder<_B> withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public Builder<_B> withName(String name) {
            super.withName(name);
            return this;
        }

        @Override
        public Builder<_B> withFrameId(Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        @Override
        public Builder<_B> withId(String id) {
            super.withId(id);
            return this;
        }

        @Override
        public Builder<_B> withIdref(Object idref) {
            super.withIdref(idref);
            return this;
        }

        @Override
        public Builder<_B> withUcd(String ucd) {
            super.withUcd(ucd);
            return this;
        }

        @Override
        public Builder<_B> withType(String type) {
            super.withType(type);
            return this;
        }

        @Override
        public Builder<_B> withHref(String href) {
            super.withHref(href);
            return this;
        }

        @Override
        public Builder<_B> withIDType(String idType) {
            super.withIDType(idType);
            return this;
        }

        @Override
        public Builder<_B> withIDREFType(String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public TimeCoordinateType build() {
            if (this._storedValue == null) {
                return this.init(new TimeCoordinateType());
            }
            return (TimeCoordinateType)this._storedValue;
        }

        public Builder<_B> copyOf(TimeCoordinateType _other) {
            _other.copyTo(this);
            return this;
        }

        public Builder<_B> copyOf(Builder _other) {
            return this.copyOf(_other.build());
        }
    }

    public static class PropInfo {
        public static final transient SinglePropertyInfo<TimeCoordinateType, AstronTimeType> TIME_INSTANT = new SinglePropertyInfo<TimeCoordinateType, AstronTimeType>("timeInstant", TimeCoordinateType.class, AstronTimeType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeInstant"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astronTimeType"), false){

            public AstronTimeType get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.timeInstant;
            }

            public void set(TimeCoordinateType _instance_, AstronTimeType _value_) {
                if (_instance_ != null) {
                    _instance_.timeInstant = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<TimeCoordinateType, Double1Type> ERRORS = new CollectionPropertyInfo<TimeCoordinateType, Double1Type>("errors", TimeCoordinateType.class, Double1Type.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Error"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false){

            public List<Double1Type> get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.errors;
            }

            public void set(TimeCoordinateType _instance_, List<Double1Type> _value_) {
                if (_instance_ != null) {
                    _instance_.errors = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<TimeCoordinateType, Double1Type> RESOLUTIONS = new CollectionPropertyInfo<TimeCoordinateType, Double1Type>("resolutions", TimeCoordinateType.class, Double1Type.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Resolution"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false){

            public List<Double1Type> get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.resolutions;
            }

            public void set(TimeCoordinateType _instance_, List<Double1Type> _value_) {
                if (_instance_ != null) {
                    _instance_.resolutions = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<TimeCoordinateType, Double1Type> SIZES = new CollectionPropertyInfo<TimeCoordinateType, Double1Type>("sizes", TimeCoordinateType.class, Double1Type.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Size"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false){

            public List<Double1Type> get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.sizes;
            }

            public void set(TimeCoordinateType _instance_, List<Double1Type> _value_) {
                if (_instance_ != null) {
                    _instance_.sizes = _value_;
                }
            }
        };
        public static final transient CollectionPropertyInfo<TimeCoordinateType, Double1Type> PIX_SIZES = new CollectionPropertyInfo<TimeCoordinateType, Double1Type>("pixSizes", TimeCoordinateType.class, Double1Type.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PixSize"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double1Type"), false){

            public List<Double1Type> get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.pixSizes;
            }

            public void set(TimeCoordinateType _instance_, List<Double1Type> _value_) {
                if (_instance_ != null) {
                    _instance_.pixSizes = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<TimeCoordinateType, Object> COORD_SYSTEM_ID = new SinglePropertyInfo<TimeCoordinateType, Object>("coordSystemId", TimeCoordinateType.class, Object.class, false, null, new QName("", "coord_system_id"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true){

            public Object get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.coordSystemId;
            }

            public void set(TimeCoordinateType _instance_, Object _value_) {
                if (_instance_ != null) {
                    _instance_.coordSystemId = _value_;
                }
            }
        };
        public static final transient SinglePropertyInfo<TimeCoordinateType, String> UNIT = new SinglePropertyInfo<TimeCoordinateType, String>("unit", TimeCoordinateType.class, String.class, false, "s", new QName("", "unit"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeUnitType"), true){

            public String get(TimeCoordinateType _instance_) {
                return _instance_ == null ? null : _instance_.unit;
            }

            public void set(TimeCoordinateType _instance_, String _value_) {
                if (_instance_ != null) {
                    _instance_.unit = _value_;
                }
            }
        };
    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?>, TParent>
    extends CoordinateType.Selector<TRoot, TParent> {
        private AstronTimeType.Selector<TRoot, Selector<TRoot, TParent>> timeInstant = null;
        private Double1Type.Selector<TRoot, Selector<TRoot, TParent>> errors = null;
        private Double1Type.Selector<TRoot, Selector<TRoot, TParent>> resolutions = null;
        private Double1Type.Selector<TRoot, Selector<TRoot, TParent>> sizes = null;
        private Double1Type.Selector<TRoot, Selector<TRoot, TParent>> pixSizes = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> coordSystemId = null;
        private com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> unit = null;

        public Selector(TRoot root, TParent parent, String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            HashMap<String, PropertyTree> products = new HashMap<String, PropertyTree>();
            products.putAll(super.buildChildren());
            if (this.timeInstant != null) {
                products.put("timeInstant", this.timeInstant.init());
            }
            if (this.errors != null) {
                products.put("errors", this.errors.init());
            }
            if (this.resolutions != null) {
                products.put("resolutions", this.resolutions.init());
            }
            if (this.sizes != null) {
                products.put("sizes", this.sizes.init());
            }
            if (this.pixSizes != null) {
                products.put("pixSizes", this.pixSizes.init());
            }
            if (this.coordSystemId != null) {
                products.put("coordSystemId", this.coordSystemId.init());
            }
            if (this.unit != null) {
                products.put("unit", this.unit.init());
            }
            return products;
        }

        public AstronTimeType.Selector<TRoot, Selector<TRoot, TParent>> timeInstant() {
            return this.timeInstant == null ? (this.timeInstant = new AstronTimeType.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "timeInstant")) : this.timeInstant;
        }

        public Double1Type.Selector<TRoot, Selector<TRoot, TParent>> errors() {
            return this.errors == null ? (this.errors = new Double1Type.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "errors")) : this.errors;
        }

        public Double1Type.Selector<TRoot, Selector<TRoot, TParent>> resolutions() {
            return this.resolutions == null ? (this.resolutions = new Double1Type.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "resolutions")) : this.resolutions;
        }

        public Double1Type.Selector<TRoot, Selector<TRoot, TParent>> sizes() {
            return this.sizes == null ? (this.sizes = new Double1Type.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "sizes")) : this.sizes;
        }

        public Double1Type.Selector<TRoot, Selector<TRoot, TParent>> pixSizes() {
            return this.pixSizes == null ? (this.pixSizes = new Double1Type.Selector<com.kscs.util.jaxb.Selector, Selector>(this._root, this, "pixSizes")) : this.pixSizes;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> coordSystemId() {
            return this.coordSystemId == null ? (this.coordSystemId = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "coordSystemId")) : this.coordSystemId;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Selector<TRoot, TParent>> unit() {
            return this.unit == null ? (this.unit = new com.kscs.util.jaxb.Selector(this._root, (Object)this, "unit")) : this.unit;
        }
    }

    public static class Select
    extends Selector<Select, Void> {
        Select() {
            super(null, null, null);
        }

        public static Select _root() {
            return new Select();
        }
    }
}

