
package org.javastro.ivoa.entities.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.cone.CSCapRestriction;
import org.javastro.ivoa.entities.resource.registry.RegCapRestriction;
import org.javastro.ivoa.entities.resource.sia.SIACapRestriction;
import org.javastro.ivoa.entities.resource.ssap.SimpleSpectralAccess;
import org.javastro.ivoa.entities.resource.tap.TableAccess;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * a description of what the service does (in terms of 
 *             context-specific behavior), and how to use it (in terms of
 *             an interface)
 * 
 * <p>Java class for Capability complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Capability">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="validationLevel" type="{http://www.ivoa.net/xml/VOResource/v1.0}Validation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="interface" type="{http://www.ivoa.net/xml/VOResource/v1.0}Interface" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="standardID" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Capability", propOrder = {
    "validationLevels",
    "description",
    "interfaces"
})
@XmlSeeAlso({
    CSCapRestriction.class,
    SIACapRestriction.class,
    TableAccess.class,
    RegCapRestriction.class,
    SimpleSpectralAccess.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Capability implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * See vr:ValidationLevel for an explanation of the
     *                   allowed levels.
     * 
     */
    @XmlElement(name = "validationLevel")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<Validation> validationLevels;
    /**
     * Use of this optional element is especially encouraged when
     *                   this capability is non-standard and is one of several 
     *                   capabilities listed.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String description;
    /**
     * Multiple occurences can describe different interfaces to 
     *                   the logically same capability, i.e. data or functionality.
     *                   That is, the inputs accepted and the output provides should
     *                   be logically the same.  For example, a WebBrowser interface
     *                   given in addition to a WebService interface would simply 
     *                   provide an interactive, human-targeted interface to the 
     *                   underlying WebService interface.
     * 
     */
    @XmlElement(name = "interface")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<ServiceInterface> interfaces;
    /**
     * This provides a unique way to refer to a service
     *                specification standard, such as a Simple Image Access service.
     *                The use of an IVOA identifier here implies that a
     *                VOResource description of the standard is registered and 
     *                accessible.
     * 
     */
    @XmlAttribute(name = "standardID")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String standardID;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Capability.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Capability() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Capability(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID) {
        this.validationLevels = validationLevels;
        this.description = description;
        this.interfaces = interfaces;
        this.standardID = standardID;
    }

    /**
     * See vr:ValidationLevel for an explanation of the
     *                   allowed levels.
     * 
     * Gets the value of the validationLevels property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validationLevels property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getValidationLevels().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Validation }
     * </p>
     * 
     * 
     * @return
     *     The value of the validationLevels property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<Validation> getValidationLevels() {
        if (validationLevels == null) {
            validationLevels = new ArrayList<>();
        }
        return this.validationLevels;
    }

    /**
     * Use of this optional element is especially encouraged when
     *                   this capability is non-standard and is one of several 
     *                   capabilities listed.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Multiple occurences can describe different interfaces to 
     *                   the logically same capability, i.e. data or functionality.
     *                   That is, the inputs accepted and the output provides should
     *                   be logically the same.  For example, a WebBrowser interface
     *                   given in addition to a WebService interface would simply 
     *                   provide an interactive, human-targeted interface to the 
     *                   underlying WebService interface.
     * 
     * Gets the value of the interfaces property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the interfaces property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInterfaces().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ServiceInterface }
     * </p>
     * 
     * 
     * @return
     *     The value of the interfaces property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<ServiceInterface> getInterfaces() {
        if (interfaces == null) {
            interfaces = new ArrayList<>();
        }
        return this.interfaces;
    }

    /**
     * This provides a unique way to refer to a service
     *                specification standard, such as a Simple Image Access service.
     *                The use of an IVOA identifier here implies that a
     *                VOResource description of the standard is registered and 
     *                accessible.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getStandardID() {
        return standardID;
    }

    /**
     * Sets the value of the standardID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getStandardID()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setStandardID(String value) {
        this.standardID = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Capability that = ((Capability) object);
        {
            List<Validation> leftValidationLevels;
            leftValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            List<Validation> rightValidationLevels;
            rightValidationLevels = (((that.validationLevels!= null)&&(!that.validationLevels.isEmpty()))?that.getValidationLevels():null);
            if ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())) {
                if ((that.validationLevels!= null)&&(!that.validationLevels.isEmpty())) {
                    if (!leftValidationLevels.equals(rightValidationLevels)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.validationLevels!= null)&&(!that.validationLevels.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            List<ServiceInterface> leftInterfaces;
            leftInterfaces = (((this.interfaces!= null)&&(!this.interfaces.isEmpty()))?this.getInterfaces():null);
            List<ServiceInterface> rightInterfaces;
            rightInterfaces = (((that.interfaces!= null)&&(!that.interfaces.isEmpty()))?that.getInterfaces():null);
            if ((this.interfaces!= null)&&(!this.interfaces.isEmpty())) {
                if ((that.interfaces!= null)&&(!that.interfaces.isEmpty())) {
                    if (!leftInterfaces.equals(rightInterfaces)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.interfaces!= null)&&(!that.interfaces.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftStandardID;
            leftStandardID = this.getStandardID();
            String rightStandardID;
            rightStandardID = that.getStandardID();
            if (this.standardID!= null) {
                if (that.standardID!= null) {
                    if (!leftStandardID.equals(rightStandardID)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.standardID!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Validation> theValidationLevels;
            theValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            if ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())) {
                currentHashCode += theValidationLevels.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ServiceInterface> theInterfaces;
            theInterfaces = (((this.interfaces!= null)&&(!this.interfaces.isEmpty()))?this.getInterfaces():null);
            if ((this.interfaces!= null)&&(!this.interfaces.isEmpty())) {
                currentHashCode += theInterfaces.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theStandardID;
            theStandardID = this.getStandardID();
            if (this.standardID!= null) {
                currentHashCode += theStandardID.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<Validation> theValidationLevels;
            theValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            strategy.appendField(locator, this, "validationLevels", buffer, theValidationLevels, ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            List<ServiceInterface> theInterfaces;
            theInterfaces = (((this.interfaces!= null)&&(!this.interfaces.isEmpty()))?this.getInterfaces():null);
            strategy.appendField(locator, this, "interfaces", buffer, theInterfaces, ((this.interfaces!= null)&&(!this.interfaces.isEmpty())));
        }
        {
            String theStandardID;
            theStandardID = this.getStandardID();
            strategy.appendField(locator, this, "standardID", buffer, theStandardID, (this.standardID!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Capability) {
            final Capability target = this;
            final Capability leftObject = ((Capability) left);
            final Capability rightObject = ((Capability) right);
            {
                Boolean validationLevelsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty())), ((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty())));
                if (validationLevelsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Validation> lhsValidationLevels;
                    lhsValidationLevels = (((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty()))?leftObject.getValidationLevels():null);
                    List<Validation> rhsValidationLevels;
                    rhsValidationLevels = (((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty()))?rightObject.getValidationLevels():null);
                    List<Validation> mergedValidationLevels = ((List<Validation> ) strategy.merge(LocatorUtils.property(leftLocator, "validationLevels", lhsValidationLevels), LocatorUtils.property(rightLocator, "validationLevels", rhsValidationLevels), lhsValidationLevels, rhsValidationLevels, ((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty())), ((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty()))));
                    target.validationLevels = null;
                    if (mergedValidationLevels!= null) {
                        List<Validation> uniqueValidationLevelsl = target.getValidationLevels();
                        uniqueValidationLevelsl.addAll(mergedValidationLevels);
                    }
                } else {
                    if (validationLevelsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.validationLevels = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean interfacesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.interfaces!= null)&&(!leftObject.interfaces.isEmpty())), ((rightObject.interfaces!= null)&&(!rightObject.interfaces.isEmpty())));
                if (interfacesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ServiceInterface> lhsInterfaces;
                    lhsInterfaces = (((leftObject.interfaces!= null)&&(!leftObject.interfaces.isEmpty()))?leftObject.getInterfaces():null);
                    List<ServiceInterface> rhsInterfaces;
                    rhsInterfaces = (((rightObject.interfaces!= null)&&(!rightObject.interfaces.isEmpty()))?rightObject.getInterfaces():null);
                    List<ServiceInterface> mergedInterfaces = ((List<ServiceInterface> ) strategy.merge(LocatorUtils.property(leftLocator, "interfaces", lhsInterfaces), LocatorUtils.property(rightLocator, "interfaces", rhsInterfaces), lhsInterfaces, rhsInterfaces, ((leftObject.interfaces!= null)&&(!leftObject.interfaces.isEmpty())), ((rightObject.interfaces!= null)&&(!rightObject.interfaces.isEmpty()))));
                    target.interfaces = null;
                    if (mergedInterfaces!= null) {
                        List<ServiceInterface> uniqueInterfacesl = target.getInterfaces();
                        uniqueInterfacesl.addAll(mergedInterfaces);
                    }
                } else {
                    if (interfacesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.interfaces = null;
                    }
                }
            }
            {
                Boolean standardIDShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.standardID!= null), (rightObject.standardID!= null));
                if (standardIDShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsStandardID;
                    lhsStandardID = leftObject.getStandardID();
                    String rhsStandardID;
                    rhsStandardID = rightObject.getStandardID();
                    String mergedStandardID = ((String) strategy.merge(LocatorUtils.property(leftLocator, "standardID", lhsStandardID), LocatorUtils.property(rightLocator, "standardID", rhsStandardID), lhsStandardID, rhsStandardID, (leftObject.standardID!= null), (rightObject.standardID!= null)));
                    target.setStandardID(mergedStandardID);
                } else {
                    if (standardIDShouldBeMergedAndSet == Boolean.FALSE) {
                        target.standardID = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Capability();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability clone() {
        final Capability _newObject;
        try {
            _newObject = ((Capability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.validationLevels == null) {
            _newObject.validationLevels = null;
        } else {
            _newObject.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _newObject.validationLevels.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.interfaces == null) {
            _newObject.interfaces = null;
        } else {
            _newObject.interfaces = new ArrayList<>();
            for (ServiceInterface _item: this.interfaces) {
                _newObject.interfaces.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability createCopy() {
        final Capability _newObject;
        try {
            _newObject = ((Capability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.validationLevels == null) {
            _newObject.validationLevels = null;
        } else {
            _newObject.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _newObject.validationLevels.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.description = this.description;
        if (this.interfaces == null) {
            _newObject.interfaces = null;
        } else {
            _newObject.interfaces = new ArrayList<>();
            for (ServiceInterface _item: this.interfaces) {
                _newObject.interfaces.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.standardID = this.standardID;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Capability _newObject;
        try {
            _newObject = ((Capability) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
            if (this.validationLevels == null) {
                _newObject.validationLevels = null;
            } else {
                _newObject.validationLevels = new ArrayList<>();
                for (Validation _item: this.validationLevels) {
                    _newObject.validationLevels.add(((_item == null)?null:_item.createCopy(validationLevelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree interfacesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("interfaces"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(interfacesPropertyTree!= null):((interfacesPropertyTree == null)||(!interfacesPropertyTree.isLeaf())))) {
            if (this.interfaces == null) {
                _newObject.interfaces = null;
            } else {
                _newObject.interfaces = new ArrayList<>();
                for (ServiceInterface _item: this.interfaces) {
                    _newObject.interfaces.add(((_item == null)?null:_item.createCopy(interfacesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree standardIDPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("standardID"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(standardIDPropertyTree!= null):((standardIDPropertyTree == null)||(!standardIDPropertyTree.isLeaf())))) {
            _newObject.standardID = this.standardID;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Capability.Modifier();
        }
        return ((Capability.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Capability.Builder<_B> _other) {
        if (this.validationLevels == null) {
            _other.validationLevels = null;
        } else {
            _other.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _other.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.description = this.description;
        if (this.interfaces == null) {
            _other.interfaces = null;
        } else {
            _other.interfaces = new ArrayList<>();
            for (ServiceInterface _item: this.interfaces) {
                _other.interfaces.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.standardID = this.standardID;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Capability.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Capability.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Capability.Builder<Void> builder() {
        return new Capability.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Capability.Builder<_B> copyOf(final Capability _other) {
        final Capability.Builder<_B> _newBuilder = new Capability.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Capability.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
            if (this.validationLevels == null) {
                _other.validationLevels = null;
            } else {
                _other.validationLevels = new ArrayList<>();
                for (Validation _item: this.validationLevels) {
                    _other.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(_other, validationLevelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree interfacesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("interfaces"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(interfacesPropertyTree!= null):((interfacesPropertyTree == null)||(!interfacesPropertyTree.isLeaf())))) {
            if (this.interfaces == null) {
                _other.interfaces = null;
            } else {
                _other.interfaces = new ArrayList<>();
                for (ServiceInterface _item: this.interfaces) {
                    _other.interfaces.add(((_item == null)?null:_item.newCopyBuilder(_other, interfacesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree standardIDPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("standardID"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(standardIDPropertyTree!= null):((standardIDPropertyTree == null)||(!standardIDPropertyTree.isLeaf())))) {
            _other.standardID = this.standardID;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Capability.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Capability.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Capability.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Capability.Builder<_B> _newBuilder = new Capability.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Capability.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Capability.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Capability visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new CollectionProperty<>(Capability.PropInfo.VALIDATION_LEVELS, this))&&(this.validationLevels!= null)) {
            for (Validation _item_: this.validationLevels) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Capability.PropInfo.DESCRIPTION, this));
        if (_visitor_.visit(new CollectionProperty<>(Capability.PropInfo.INTERFACES, this))&&(this.interfaces!= null)) {
            for (ServiceInterface _item_: this.interfaces) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Capability.PropInfo.STANDARD_ID, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Capability _storedValue;
        private List<Validation.Builder<Capability.Builder<_B>>> validationLevels;
        private String description;
        private List<ServiceInterface.Builder<Capability.Builder<_B>>> interfaces;
        private String standardID;

        public Builder(final _B _parentBuilder, final Capability _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    if (_other.validationLevels == null) {
                        this.validationLevels = null;
                    } else {
                        this.validationLevels = new ArrayList<>();
                        for (Validation _item: _other.validationLevels) {
                            this.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.description = _other.description;
                    if (_other.interfaces == null) {
                        this.interfaces = null;
                    } else {
                        this.interfaces = new ArrayList<>();
                        for (ServiceInterface _item: _other.interfaces) {
                            this.interfaces.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.standardID = _other.standardID;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Capability _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
                        if (_other.validationLevels == null) {
                            this.validationLevels = null;
                        } else {
                            this.validationLevels = new ArrayList<>();
                            for (Validation _item: _other.validationLevels) {
                                this.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(this, validationLevelsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree interfacesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("interfaces"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(interfacesPropertyTree!= null):((interfacesPropertyTree == null)||(!interfacesPropertyTree.isLeaf())))) {
                        if (_other.interfaces == null) {
                            this.interfaces = null;
                        } else {
                            this.interfaces = new ArrayList<>();
                            for (ServiceInterface _item: _other.interfaces) {
                                this.interfaces.add(((_item == null)?null:_item.newCopyBuilder(this, interfacesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree standardIDPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("standardID"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(standardIDPropertyTree!= null):((standardIDPropertyTree == null)||(!standardIDPropertyTree.isLeaf())))) {
                        this.standardID = _other.standardID;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Capability >_P init(final _P _product) {
            if (this.validationLevels!= null) {
                final List<Validation> validationLevels = new ArrayList<>(this.validationLevels.size());
                for (Validation.Builder<Capability.Builder<_B>> _item: this.validationLevels) {
                    validationLevels.add(_item.build());
                }
                _product.validationLevels = validationLevels;
            }
            _product.description = this.description;
            if (this.interfaces!= null) {
                final List<ServiceInterface> interfaces = new ArrayList<>(this.interfaces.size());
                for (ServiceInterface.Builder<Capability.Builder<_B>> _item: this.interfaces) {
                    interfaces.add(_item.build());
                }
                _product.interfaces = interfaces;
            }
            _product.standardID = this.standardID;
            return _product;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        public Capability.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            if (validationLevels!= null) {
                if (this.validationLevels == null) {
                    this.validationLevels = new ArrayList<>();
                }
                for (Validation _item: validationLevels) {
                    this.validationLevels.add(new Validation.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        public Capability.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            if (this.validationLevels!= null) {
                this.validationLevels.clear();
            }
            return addValidationLevels(validationLevels);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        public Capability.Builder<_B> addValidationLevels(Validation... validationLevels) {
            addValidationLevels(Arrays.asList(validationLevels));
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        public Capability.Builder<_B> withValidationLevels(Validation... validationLevels) {
            withValidationLevels(Arrays.asList(validationLevels));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "ValidationLevels"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.Validation.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "ValidationLevels" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Validation.Builder#end()} to
         *     return to the current builder.
         */
        public Validation.Builder<? extends Capability.Builder<_B>> addValidationLevels() {
            if (this.validationLevels == null) {
                this.validationLevels = new ArrayList<>();
            }
            final Validation.Builder<Capability.Builder<_B>> validationLevels_Builder = new Validation.Builder<>(this, null, false);
            this.validationLevels.add(validationLevels_Builder);
            return validationLevels_Builder;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public Capability.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        public Capability.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            if (interfaces!= null) {
                if (this.interfaces == null) {
                    this.interfaces = new ArrayList<>();
                }
                for (ServiceInterface _item: interfaces) {
                    this.interfaces.add(new ServiceInterface.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        public Capability.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            if (this.interfaces!= null) {
                this.interfaces.clear();
            }
            return addInterfaces(interfaces);
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        public Capability.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            addInterfaces(Arrays.asList(interfaces));
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        public Capability.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            withInterfaces(Arrays.asList(interfaces));
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        public Capability.Builder<_B> withStandardID(final String standardID) {
            this.standardID = standardID;
            return this;
        }

        @Override
        public Capability build() {
            if (_storedValue == null) {
                return this.init(new Capability());
            } else {
                return ((Capability) _storedValue);
            }
        }

        public Capability.Builder<_B> copyOf(final Capability _other) {
            _other.copyTo(this);
            return this;
        }

        public Capability.Builder<_B> copyOf(final Capability.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public List<Validation> getValidationLevels() {
            if (Capability.this.validationLevels == null) {
                Capability.this.validationLevels = new ArrayList<>();
            }
            return Capability.this.validationLevels;
        }

        public void setDescription(final String description) {
            Capability.this.setDescription(description);
        }

        public List<ServiceInterface> getInterfaces() {
            if (Capability.this.interfaces == null) {
                Capability.this.interfaces = new ArrayList<>();
            }
            return Capability.this.interfaces;
        }

        public void setStandardID(final String standardID) {
            Capability.this.setStandardID(standardID);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<Capability, Validation> VALIDATION_LEVELS = new CollectionPropertyInfo<Capability,Validation>("validationLevels", Capability.class, Validation.class, true, null, new QName("", "validationLevel"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Validation"), false) {


            @Override
            public List<Validation> get(final Capability _instance_) {
                return ((_instance_ == null)?null:_instance_.validationLevels);
            }

            @Override
            public void set(final Capability _instance_, final List<Validation> _value_) {
                if (_instance_!= null) {
                    _instance_.validationLevels = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Capability, String> DESCRIPTION = new SinglePropertyInfo<Capability,String>("description", Capability.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Capability _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final Capability _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Capability, ServiceInterface> INTERFACES = new CollectionPropertyInfo<Capability,ServiceInterface>("interfaces", Capability.class, ServiceInterface.class, true, null, new QName("", "interface"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Interface"), false) {


            @Override
            public List<ServiceInterface> get(final Capability _instance_) {
                return ((_instance_ == null)?null:_instance_.interfaces);
            }

            @Override
            public void set(final Capability _instance_, final List<ServiceInterface> _value_) {
                if (_instance_!= null) {
                    _instance_.interfaces = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Capability, String> STANDARD_ID = new SinglePropertyInfo<Capability,String>("standardID", Capability.class, String.class, false, null, new QName("", "standardID"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final Capability _instance_) {
                return ((_instance_ == null)?null:_instance_.standardID);
            }

            @Override
            public void set(final Capability _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.standardID = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Capability.Selector<Capability.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Capability.Select _root() {
            return new Capability.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private Validation.Selector<TRoot, Capability.Selector<TRoot, TParent>> validationLevels = null;
        private com.kscs.util.jaxb.Selector<TRoot, Capability.Selector<TRoot, TParent>> description = null;
        private ServiceInterface.Selector<TRoot, Capability.Selector<TRoot, TParent>> interfaces = null;
        private com.kscs.util.jaxb.Selector<TRoot, Capability.Selector<TRoot, TParent>> standardID = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.validationLevels!= null) {
                products.put("validationLevels", this.validationLevels.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.interfaces!= null) {
                products.put("interfaces", this.interfaces.init());
            }
            if (this.standardID!= null) {
                products.put("standardID", this.standardID.init());
            }
            return products;
        }

        public Validation.Selector<TRoot, Capability.Selector<TRoot, TParent>> validationLevels() {
            return ((this.validationLevels == null)?this.validationLevels = new Validation.Selector<>(this._root, this, "validationLevels"):this.validationLevels);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Capability.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public ServiceInterface.Selector<TRoot, Capability.Selector<TRoot, TParent>> interfaces() {
            return ((this.interfaces == null)?this.interfaces = new ServiceInterface.Selector<>(this._root, this, "interfaces"):this.interfaces);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Capability.Selector<TRoot, TParent>> standardID() {
            return ((this.standardID == null)?this.standardID = new com.kscs.util.jaxb.Selector<>(this._root, this, "standardID"):this.standardID);
        }

    }

}
