
package org.javastro.ivoa.entities.resource.applications;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * An application that can actually be run on a user's desktop
 *             computer.
 * 
 * <p>Java class for DesktopApplication complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DesktopApplication">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOApplication/v1.0rc1}Application">
 *       <sequence>
 *         <element name="binarySize" type="{http://www.w3.org/2001/XMLSchema}int" minOccurs="0"/>
 *         <element name="memoryRequirement" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="network" type="{http://www.ivoa.net/xml/VOApplication/v1.0rc1}NetworkRequirement" minOccurs="0"/>
 *         <element name="dependsOn" type="{http://www.ivoa.net/xml/VOResource/v1.0}IdentifierURI" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="executable" type="{http://www.ivoa.net/xml/VOApplication/v1.0rc1}ExecutionEnvironment" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DesktopApplication", propOrder = {
    "binarySize",
    "memoryRequirement",
    "network",
    "dependsOns",
    "executables"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class DesktopApplication
    extends Application
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The size of the executable in bytes.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Integer binarySize;
    /**
     * An estimate in bytes of the mimimum memory that
     *                         the application requires to function with
     *                         acceptable interactive performance.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String memoryRequirement;
    /**
     * This can take on the values;
     *                         
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;dl xmlns="http://www.ivoa.net/xml/VOApplication/v1.0rc1" xmlns:p777619_="https://jakarta.ee/xml/ns/jaxb" xmlns:p829474_="urn:jaxb.jvnet.org:plugin:namespace-prefix" xmlns:vm="http://www.ivoa.net/xml/VOMetadata/v0.1" xmlns:vr="http://www.ivoa.net/xml/VOResource/v1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;dt&gt;Essential&lt;/dt&gt;&lt;dd&gt;
     *                               The application will not even start
     *                               without a network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Useful&lt;/dt&gt;&lt;dd&gt;
     *                               The application will start, but the
     *                               primary use for the application requires a
     *                               network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Limited&lt;/dt&gt;&lt;dd&gt;
     *                               The application makes only limited use of
     *                               network facilities, thus the majority of
     *                               its functionality is still available
     *                               without a network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Unnecessary&lt;/dt&gt;&lt;dd&gt;
     *                               The application makes no use of the
     *                               network.
     *                            &lt;/dd&gt;&lt;/dl&gt;
     * </pre>
     * 
     */
    @XmlSchemaType(name = "string")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected NetworkRequirement network;
    /**
     * Can be used to indicate other
     *                         applications/software libraries that the
     *                         application depends upon. This should only be
     *                         used to indicate dependencies that must be
     *                         installed separately from the main application
     *                         installation for it to function properly.
     * 
     */
    @XmlElement(name = "dependsOn")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<String> dependsOns;
    /**
     * how to obtain the executable
     * 
     */
    @XmlElement(name = "executable")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<ExecutionEnvironment> executables;

    /**
     * Default no-arg constructor
     * 
     */
    public DesktopApplication() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public DesktopApplication(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final ZonedDateTime created, final ZonedDateTime updated, final String status, final String version, final String cost, final String licence, final Boolean openSource, final List<DataFormat> dataFormats, final List<ApplicationCapability> voStandards, final List<String> sourceLanguages, final String sourceCodeURL, final Integer binarySize, final String memoryRequirement, final NetworkRequirement network, final List<String> dependsOns, final List<ExecutionEnvironment> executables) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version, cost, licence, openSource, dataFormats, voStandards, sourceLanguages, sourceCodeURL);
        this.binarySize = binarySize;
        this.memoryRequirement = memoryRequirement;
        this.network = network;
        this.dependsOns = dependsOns;
        this.executables = executables;
    }

    /**
     * The size of the executable in bytes.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Integer getBinarySize() {
        return binarySize;
    }

    /**
     * Sets the value of the binarySize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     * @see #getBinarySize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setBinarySize(Integer value) {
        this.binarySize = value;
    }

    /**
     * An estimate in bytes of the mimimum memory that
     *                         the application requires to function with
     *                         acceptable interactive performance.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getMemoryRequirement() {
        return memoryRequirement;
    }

    /**
     * Sets the value of the memoryRequirement property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getMemoryRequirement()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setMemoryRequirement(String value) {
        this.memoryRequirement = value;
    }

    /**
     * This can take on the values;
     *                         
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;dl xmlns="http://www.ivoa.net/xml/VOApplication/v1.0rc1" xmlns:p777619_="https://jakarta.ee/xml/ns/jaxb" xmlns:p829474_="urn:jaxb.jvnet.org:plugin:namespace-prefix" xmlns:vm="http://www.ivoa.net/xml/VOMetadata/v0.1" xmlns:vr="http://www.ivoa.net/xml/VOResource/v1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;&lt;dt&gt;Essential&lt;/dt&gt;&lt;dd&gt;
     *                               The application will not even start
     *                               without a network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Useful&lt;/dt&gt;&lt;dd&gt;
     *                               The application will start, but the
     *                               primary use for the application requires a
     *                               network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Limited&lt;/dt&gt;&lt;dd&gt;
     *                               The application makes only limited use of
     *                               network facilities, thus the majority of
     *                               its functionality is still available
     *                               without a network connection.
     *                            &lt;/dd&gt;&lt;dt&gt;Unnecessary&lt;/dt&gt;&lt;dd&gt;
     *                               The application makes no use of the
     *                               network.
     *                            &lt;/dd&gt;&lt;/dl&gt;
     * </pre>
     * 
     * @return
     *     possible object is
     *     {@link NetworkRequirement }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public NetworkRequirement getNetwork() {
        return network;
    }

    /**
     * Sets the value of the network property.
     * 
     * @param value
     *     allowed object is
     *     {@link NetworkRequirement }
     *     
     * @see #getNetwork()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setNetwork(NetworkRequirement value) {
        this.network = value;
    }

    /**
     * Can be used to indicate other
     *                         applications/software libraries that the
     *                         application depends upon. This should only be
     *                         used to indicate dependencies that must be
     *                         installed separately from the main application
     *                         installation for it to function properly.
     * 
     * Gets the value of the dependsOns property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dependsOns property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDependsOns().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the dependsOns property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<String> getDependsOns() {
        if (dependsOns == null) {
            dependsOns = new ArrayList<>();
        }
        return this.dependsOns;
    }

    /**
     * how to obtain the executable
     * 
     * Gets the value of the executables property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the executables property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExecutables().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExecutionEnvironment }
     * </p>
     * 
     * 
     * @return
     *     The value of the executables property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<ExecutionEnvironment> getExecutables() {
        if (executables == null) {
            executables = new ArrayList<>();
        }
        return this.executables;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final DesktopApplication that = ((DesktopApplication) object);
        {
            Integer leftBinarySize;
            leftBinarySize = this.getBinarySize();
            Integer rightBinarySize;
            rightBinarySize = that.getBinarySize();
            if (this.binarySize!= null) {
                if (that.binarySize!= null) {
                    if (!leftBinarySize.equals(rightBinarySize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.binarySize!= null) {
                    return false;
                }
            }
        }
        {
            String leftMemoryRequirement;
            leftMemoryRequirement = this.getMemoryRequirement();
            String rightMemoryRequirement;
            rightMemoryRequirement = that.getMemoryRequirement();
            if (this.memoryRequirement!= null) {
                if (that.memoryRequirement!= null) {
                    if (!leftMemoryRequirement.equals(rightMemoryRequirement)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.memoryRequirement!= null) {
                    return false;
                }
            }
        }
        {
            NetworkRequirement leftNetwork;
            leftNetwork = this.getNetwork();
            NetworkRequirement rightNetwork;
            rightNetwork = that.getNetwork();
            if (this.network!= null) {
                if (that.network!= null) {
                    if (!leftNetwork.equals(rightNetwork)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.network!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftDependsOns;
            leftDependsOns = (((this.dependsOns!= null)&&(!this.dependsOns.isEmpty()))?this.getDependsOns():null);
            List<String> rightDependsOns;
            rightDependsOns = (((that.dependsOns!= null)&&(!that.dependsOns.isEmpty()))?that.getDependsOns():null);
            if ((this.dependsOns!= null)&&(!this.dependsOns.isEmpty())) {
                if ((that.dependsOns!= null)&&(!that.dependsOns.isEmpty())) {
                    if (!leftDependsOns.equals(rightDependsOns)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.dependsOns!= null)&&(!that.dependsOns.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<ExecutionEnvironment> leftExecutables;
            leftExecutables = (((this.executables!= null)&&(!this.executables.isEmpty()))?this.getExecutables():null);
            List<ExecutionEnvironment> rightExecutables;
            rightExecutables = (((that.executables!= null)&&(!that.executables.isEmpty()))?that.getExecutables():null);
            if ((this.executables!= null)&&(!this.executables.isEmpty())) {
                if ((that.executables!= null)&&(!that.executables.isEmpty())) {
                    if (!leftExecutables.equals(rightExecutables)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.executables!= null)&&(!that.executables.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Integer theBinarySize;
            theBinarySize = this.getBinarySize();
            if (this.binarySize!= null) {
                currentHashCode += theBinarySize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theMemoryRequirement;
            theMemoryRequirement = this.getMemoryRequirement();
            if (this.memoryRequirement!= null) {
                currentHashCode += theMemoryRequirement.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            NetworkRequirement theNetwork;
            theNetwork = this.getNetwork();
            if (this.network!= null) {
                currentHashCode += theNetwork.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theDependsOns;
            theDependsOns = (((this.dependsOns!= null)&&(!this.dependsOns.isEmpty()))?this.getDependsOns():null);
            if ((this.dependsOns!= null)&&(!this.dependsOns.isEmpty())) {
                currentHashCode += theDependsOns.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ExecutionEnvironment> theExecutables;
            theExecutables = (((this.executables!= null)&&(!this.executables.isEmpty()))?this.getExecutables():null);
            if ((this.executables!= null)&&(!this.executables.isEmpty())) {
                currentHashCode += theExecutables.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Integer theBinarySize;
            theBinarySize = this.getBinarySize();
            strategy.appendField(locator, this, "binarySize", buffer, theBinarySize, (this.binarySize!= null));
        }
        {
            String theMemoryRequirement;
            theMemoryRequirement = this.getMemoryRequirement();
            strategy.appendField(locator, this, "memoryRequirement", buffer, theMemoryRequirement, (this.memoryRequirement!= null));
        }
        {
            NetworkRequirement theNetwork;
            theNetwork = this.getNetwork();
            strategy.appendField(locator, this, "network", buffer, theNetwork, (this.network!= null));
        }
        {
            List<String> theDependsOns;
            theDependsOns = (((this.dependsOns!= null)&&(!this.dependsOns.isEmpty()))?this.getDependsOns():null);
            strategy.appendField(locator, this, "dependsOns", buffer, theDependsOns, ((this.dependsOns!= null)&&(!this.dependsOns.isEmpty())));
        }
        {
            List<ExecutionEnvironment> theExecutables;
            theExecutables = (((this.executables!= null)&&(!this.executables.isEmpty()))?this.getExecutables():null);
            strategy.appendField(locator, this, "executables", buffer, theExecutables, ((this.executables!= null)&&(!this.executables.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof DesktopApplication) {
            final DesktopApplication target = this;
            final DesktopApplication leftObject = ((DesktopApplication) left);
            final DesktopApplication rightObject = ((DesktopApplication) right);
            {
                Boolean binarySizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.binarySize!= null), (rightObject.binarySize!= null));
                if (binarySizeShouldBeMergedAndSet == Boolean.TRUE) {
                    Integer lhsBinarySize;
                    lhsBinarySize = leftObject.getBinarySize();
                    Integer rhsBinarySize;
                    rhsBinarySize = rightObject.getBinarySize();
                    Integer mergedBinarySize = ((Integer) strategy.merge(LocatorUtils.property(leftLocator, "binarySize", lhsBinarySize), LocatorUtils.property(rightLocator, "binarySize", rhsBinarySize), lhsBinarySize, rhsBinarySize, (leftObject.binarySize!= null), (rightObject.binarySize!= null)));
                    target.setBinarySize(mergedBinarySize);
                } else {
                    if (binarySizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.binarySize = null;
                    }
                }
            }
            {
                Boolean memoryRequirementShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.memoryRequirement!= null), (rightObject.memoryRequirement!= null));
                if (memoryRequirementShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsMemoryRequirement;
                    lhsMemoryRequirement = leftObject.getMemoryRequirement();
                    String rhsMemoryRequirement;
                    rhsMemoryRequirement = rightObject.getMemoryRequirement();
                    String mergedMemoryRequirement = ((String) strategy.merge(LocatorUtils.property(leftLocator, "memoryRequirement", lhsMemoryRequirement), LocatorUtils.property(rightLocator, "memoryRequirement", rhsMemoryRequirement), lhsMemoryRequirement, rhsMemoryRequirement, (leftObject.memoryRequirement!= null), (rightObject.memoryRequirement!= null)));
                    target.setMemoryRequirement(mergedMemoryRequirement);
                } else {
                    if (memoryRequirementShouldBeMergedAndSet == Boolean.FALSE) {
                        target.memoryRequirement = null;
                    }
                }
            }
            {
                Boolean networkShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.network!= null), (rightObject.network!= null));
                if (networkShouldBeMergedAndSet == Boolean.TRUE) {
                    NetworkRequirement lhsNetwork;
                    lhsNetwork = leftObject.getNetwork();
                    NetworkRequirement rhsNetwork;
                    rhsNetwork = rightObject.getNetwork();
                    NetworkRequirement mergedNetwork = ((NetworkRequirement) strategy.merge(LocatorUtils.property(leftLocator, "network", lhsNetwork), LocatorUtils.property(rightLocator, "network", rhsNetwork), lhsNetwork, rhsNetwork, (leftObject.network!= null), (rightObject.network!= null)));
                    target.setNetwork(mergedNetwork);
                } else {
                    if (networkShouldBeMergedAndSet == Boolean.FALSE) {
                        target.network = null;
                    }
                }
            }
            {
                Boolean dependsOnsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.dependsOns!= null)&&(!leftObject.dependsOns.isEmpty())), ((rightObject.dependsOns!= null)&&(!rightObject.dependsOns.isEmpty())));
                if (dependsOnsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsDependsOns;
                    lhsDependsOns = (((leftObject.dependsOns!= null)&&(!leftObject.dependsOns.isEmpty()))?leftObject.getDependsOns():null);
                    List<String> rhsDependsOns;
                    rhsDependsOns = (((rightObject.dependsOns!= null)&&(!rightObject.dependsOns.isEmpty()))?rightObject.getDependsOns():null);
                    List<String> mergedDependsOns = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "dependsOns", lhsDependsOns), LocatorUtils.property(rightLocator, "dependsOns", rhsDependsOns), lhsDependsOns, rhsDependsOns, ((leftObject.dependsOns!= null)&&(!leftObject.dependsOns.isEmpty())), ((rightObject.dependsOns!= null)&&(!rightObject.dependsOns.isEmpty()))));
                    target.dependsOns = null;
                    if (mergedDependsOns!= null) {
                        List<String> uniqueDependsOnsl = target.getDependsOns();
                        uniqueDependsOnsl.addAll(mergedDependsOns);
                    }
                } else {
                    if (dependsOnsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.dependsOns = null;
                    }
                }
            }
            {
                Boolean executablesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.executables!= null)&&(!leftObject.executables.isEmpty())), ((rightObject.executables!= null)&&(!rightObject.executables.isEmpty())));
                if (executablesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ExecutionEnvironment> lhsExecutables;
                    lhsExecutables = (((leftObject.executables!= null)&&(!leftObject.executables.isEmpty()))?leftObject.getExecutables():null);
                    List<ExecutionEnvironment> rhsExecutables;
                    rhsExecutables = (((rightObject.executables!= null)&&(!rightObject.executables.isEmpty()))?rightObject.getExecutables():null);
                    List<ExecutionEnvironment> mergedExecutables = ((List<ExecutionEnvironment> ) strategy.merge(LocatorUtils.property(leftLocator, "executables", lhsExecutables), LocatorUtils.property(rightLocator, "executables", rhsExecutables), lhsExecutables, rhsExecutables, ((leftObject.executables!= null)&&(!leftObject.executables.isEmpty())), ((rightObject.executables!= null)&&(!rightObject.executables.isEmpty()))));
                    target.executables = null;
                    if (mergedExecutables!= null) {
                        List<ExecutionEnvironment> uniqueExecutablesl = target.getExecutables();
                        uniqueExecutablesl.addAll(mergedExecutables);
                    }
                } else {
                    if (executablesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.executables = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new DesktopApplication();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication clone() {
        final DesktopApplication _newObject;
        _newObject = ((DesktopApplication) super.clone());
        _newObject.dependsOns = ((this.dependsOns == null)?null:new ArrayList<>(this.dependsOns));
        if (this.executables == null) {
            _newObject.executables = null;
        } else {
            _newObject.executables = new ArrayList<>();
            for (ExecutionEnvironment _item: this.executables) {
                _newObject.executables.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication createCopy() {
        final DesktopApplication _newObject = ((DesktopApplication) super.createCopy());
        _newObject.binarySize = this.binarySize;
        _newObject.memoryRequirement = this.memoryRequirement;
        _newObject.network = this.network;
        _newObject.dependsOns = ((this.dependsOns == null)?null:new ArrayList<>(this.dependsOns));
        if (this.executables == null) {
            _newObject.executables = null;
        } else {
            _newObject.executables = new ArrayList<>();
            for (ExecutionEnvironment _item: this.executables) {
                _newObject.executables.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DesktopApplication _newObject = ((DesktopApplication) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree binarySizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("binarySize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(binarySizePropertyTree!= null):((binarySizePropertyTree == null)||(!binarySizePropertyTree.isLeaf())))) {
            _newObject.binarySize = this.binarySize;
        }
        final PropertyTree memoryRequirementPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("memoryRequirement"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(memoryRequirementPropertyTree!= null):((memoryRequirementPropertyTree == null)||(!memoryRequirementPropertyTree.isLeaf())))) {
            _newObject.memoryRequirement = this.memoryRequirement;
        }
        final PropertyTree networkPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("network"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(networkPropertyTree!= null):((networkPropertyTree == null)||(!networkPropertyTree.isLeaf())))) {
            _newObject.network = this.network;
        }
        final PropertyTree dependsOnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dependsOns"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dependsOnsPropertyTree!= null):((dependsOnsPropertyTree == null)||(!dependsOnsPropertyTree.isLeaf())))) {
            _newObject.dependsOns = ((this.dependsOns == null)?null:new ArrayList<>(this.dependsOns));
        }
        final PropertyTree executablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executables"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executablesPropertyTree!= null):((executablesPropertyTree == null)||(!executablesPropertyTree.isLeaf())))) {
            if (this.executables == null) {
                _newObject.executables = null;
            } else {
                _newObject.executables = new ArrayList<>();
                for (ExecutionEnvironment _item: this.executables) {
                    _newObject.executables.add(((_item == null)?null:_item.createCopy(executablesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new DesktopApplication.Modifier();
        }
        return ((DesktopApplication.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final DesktopApplication.Builder<_B> _other) {
        super.copyTo(_other);
        _other.binarySize = this.binarySize;
        _other.memoryRequirement = this.memoryRequirement;
        _other.network = this.network;
        if (this.dependsOns == null) {
            _other.dependsOns = null;
        } else {
            _other.dependsOns = new ArrayList<>();
            for (String _item: this.dependsOns) {
                _other.dependsOns.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        if (this.executables == null) {
            _other.executables = null;
        } else {
            _other.executables = new ArrayList<>();
            for (ExecutionEnvironment _item: this.executables) {
                _other.executables.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >DesktopApplication.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new DesktopApplication.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> builder() {
        return new DesktopApplication.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final Resource _other) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final Application _other) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final DesktopApplication _other) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final DesktopApplication.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree binarySizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("binarySize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(binarySizePropertyTree!= null):((binarySizePropertyTree == null)||(!binarySizePropertyTree.isLeaf())))) {
            _other.binarySize = this.binarySize;
        }
        final PropertyTree memoryRequirementPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("memoryRequirement"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(memoryRequirementPropertyTree!= null):((memoryRequirementPropertyTree == null)||(!memoryRequirementPropertyTree.isLeaf())))) {
            _other.memoryRequirement = this.memoryRequirement;
        }
        final PropertyTree networkPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("network"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(networkPropertyTree!= null):((networkPropertyTree == null)||(!networkPropertyTree.isLeaf())))) {
            _other.network = this.network;
        }
        final PropertyTree dependsOnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dependsOns"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dependsOnsPropertyTree!= null):((dependsOnsPropertyTree == null)||(!dependsOnsPropertyTree.isLeaf())))) {
            if (this.dependsOns == null) {
                _other.dependsOns = null;
            } else {
                _other.dependsOns = new ArrayList<>();
                for (String _item: this.dependsOns) {
                    _other.dependsOns.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree executablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executables"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executablesPropertyTree!= null):((executablesPropertyTree == null)||(!executablesPropertyTree.isLeaf())))) {
            if (this.executables == null) {
                _other.executables = null;
            } else {
                _other.executables = new ArrayList<>();
                for (ExecutionEnvironment _item: this.executables) {
                    _other.executables.add(((_item == null)?null:_item.newCopyBuilder(_other, executablesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >DesktopApplication.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new DesktopApplication.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final Application _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >DesktopApplication.Builder<_B> copyOf(final DesktopApplication _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DesktopApplication.Builder<_B> _newBuilder = new DesktopApplication.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyExcept(final Application _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyExcept(final DesktopApplication _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyOnly(final Application _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static DesktopApplication.Builder<Void> copyOnly(final DesktopApplication _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DesktopApplication visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(DesktopApplication.PropInfo.BINARY_SIZE, this));
        _visitor_.visit(new SingleProperty<>(DesktopApplication.PropInfo.MEMORY_REQUIREMENT, this));
        _visitor_.visit(new SingleProperty<>(DesktopApplication.PropInfo.NETWORK, this));
        _visitor_.visit(new CollectionProperty<>(DesktopApplication.PropInfo.DEPENDS_ONS, this));
        if (_visitor_.visit(new CollectionProperty<>(DesktopApplication.PropInfo.EXECUTABLES, this))&&(this.executables!= null)) {
            for (ExecutionEnvironment _item_: this.executables) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends Application.Builder<_B>
        implements Buildable
    {

        private Integer binarySize;
        private String memoryRequirement;
        private NetworkRequirement network;
        private List<Buildable> dependsOns;
        private List<ExecutionEnvironment.Builder<DesktopApplication.Builder<_B>>> executables;

        public Builder(final _B _parentBuilder, final DesktopApplication _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.binarySize = _other.binarySize;
                this.memoryRequirement = _other.memoryRequirement;
                this.network = _other.network;
                if (_other.dependsOns == null) {
                    this.dependsOns = null;
                } else {
                    this.dependsOns = new ArrayList<>();
                    for (String _item: _other.dependsOns) {
                        this.dependsOns.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                if (_other.executables == null) {
                    this.executables = null;
                } else {
                    this.executables = new ArrayList<>();
                    for (ExecutionEnvironment _item: _other.executables) {
                        this.executables.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final DesktopApplication _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree binarySizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("binarySize"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(binarySizePropertyTree!= null):((binarySizePropertyTree == null)||(!binarySizePropertyTree.isLeaf())))) {
                    this.binarySize = _other.binarySize;
                }
                final PropertyTree memoryRequirementPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("memoryRequirement"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(memoryRequirementPropertyTree!= null):((memoryRequirementPropertyTree == null)||(!memoryRequirementPropertyTree.isLeaf())))) {
                    this.memoryRequirement = _other.memoryRequirement;
                }
                final PropertyTree networkPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("network"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(networkPropertyTree!= null):((networkPropertyTree == null)||(!networkPropertyTree.isLeaf())))) {
                    this.network = _other.network;
                }
                final PropertyTree dependsOnsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dependsOns"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dependsOnsPropertyTree!= null):((dependsOnsPropertyTree == null)||(!dependsOnsPropertyTree.isLeaf())))) {
                    if (_other.dependsOns == null) {
                        this.dependsOns = null;
                    } else {
                        this.dependsOns = new ArrayList<>();
                        for (String _item: _other.dependsOns) {
                            this.dependsOns.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree executablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executables"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executablesPropertyTree!= null):((executablesPropertyTree == null)||(!executablesPropertyTree.isLeaf())))) {
                    if (_other.executables == null) {
                        this.executables = null;
                    } else {
                        this.executables = new ArrayList<>();
                        for (ExecutionEnvironment _item: _other.executables) {
                            this.executables.add(((_item == null)?null:_item.newCopyBuilder(this, executablesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends DesktopApplication >_P init(final _P _product) {
            _product.binarySize = this.binarySize;
            _product.memoryRequirement = this.memoryRequirement;
            _product.network = this.network;
            if (this.dependsOns!= null) {
                final List<String> dependsOns = new ArrayList<>(this.dependsOns.size());
                for (Buildable _item: this.dependsOns) {
                    dependsOns.add(((String) _item.build()));
                }
                _product.dependsOns = dependsOns;
            }
            if (this.executables!= null) {
                final List<ExecutionEnvironment> executables = new ArrayList<>(this.executables.size());
                for (ExecutionEnvironment.Builder<DesktopApplication.Builder<_B>> _item: this.executables) {
                    executables.add(_item.build());
                }
                _product.executables = executables;
            }
            return super.init(_product);
        }

        /**
         * Sets the new value of "binarySize" (any previous value will be replaced)
         * 
         * @param binarySize
         *     New value of the "binarySize" property.
         */
        public DesktopApplication.Builder<_B> withBinarySize(final Integer binarySize) {
            this.binarySize = binarySize;
            return this;
        }

        /**
         * Sets the new value of "memoryRequirement" (any previous value will be replaced)
         * 
         * @param memoryRequirement
         *     New value of the "memoryRequirement" property.
         */
        public DesktopApplication.Builder<_B> withMemoryRequirement(final String memoryRequirement) {
            this.memoryRequirement = memoryRequirement;
            return this;
        }

        /**
         * Sets the new value of "network" (any previous value will be replaced)
         * 
         * @param network
         *     New value of the "network" property.
         */
        public DesktopApplication.Builder<_B> withNetwork(final NetworkRequirement network) {
            this.network = network;
            return this;
        }

        /**
         * Adds the given items to the value of "dependsOns"
         * 
         * @param dependsOns
         *     Items to add to the value of the "dependsOns" property
         */
        public DesktopApplication.Builder<_B> addDependsOns(final Iterable<? extends String> dependsOns) {
            if (dependsOns!= null) {
                if (this.dependsOns == null) {
                    this.dependsOns = new ArrayList<>();
                }
                for (String _item: dependsOns) {
                    this.dependsOns.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "dependsOns" (any previous value will be replaced)
         * 
         * @param dependsOns
         *     New value of the "dependsOns" property.
         */
        public DesktopApplication.Builder<_B> withDependsOns(final Iterable<? extends String> dependsOns) {
            if (this.dependsOns!= null) {
                this.dependsOns.clear();
            }
            return addDependsOns(dependsOns);
        }

        /**
         * Adds the given items to the value of "dependsOns"
         * 
         * @param dependsOns
         *     Items to add to the value of the "dependsOns" property
         */
        public DesktopApplication.Builder<_B> addDependsOns(String... dependsOns) {
            addDependsOns(Arrays.asList(dependsOns));
            return this;
        }

        /**
         * Sets the new value of "dependsOns" (any previous value will be replaced)
         * 
         * @param dependsOns
         *     New value of the "dependsOns" property.
         */
        public DesktopApplication.Builder<_B> withDependsOns(String... dependsOns) {
            withDependsOns(Arrays.asList(dependsOns));
            return this;
        }

        /**
         * Adds the given items to the value of "executables"
         * 
         * @param executables
         *     Items to add to the value of the "executables" property
         */
        public DesktopApplication.Builder<_B> addExecutables(final Iterable<? extends ExecutionEnvironment> executables) {
            if (executables!= null) {
                if (this.executables == null) {
                    this.executables = new ArrayList<>();
                }
                for (ExecutionEnvironment _item: executables) {
                    this.executables.add(new ExecutionEnvironment.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "executables" (any previous value will be replaced)
         * 
         * @param executables
         *     New value of the "executables" property.
         */
        public DesktopApplication.Builder<_B> withExecutables(final Iterable<? extends ExecutionEnvironment> executables) {
            if (this.executables!= null) {
                this.executables.clear();
            }
            return addExecutables(executables);
        }

        /**
         * Adds the given items to the value of "executables"
         * 
         * @param executables
         *     Items to add to the value of the "executables" property
         */
        public DesktopApplication.Builder<_B> addExecutables(ExecutionEnvironment... executables) {
            addExecutables(Arrays.asList(executables));
            return this;
        }

        /**
         * Sets the new value of "executables" (any previous value will be replaced)
         * 
         * @param executables
         *     New value of the "executables" property.
         */
        public DesktopApplication.Builder<_B> withExecutables(ExecutionEnvironment... executables) {
            withExecutables(Arrays.asList(executables));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Executables"
         * property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.applications.ExecutionEnvironment.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Executables" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.applications.ExecutionEnvironment.Builder#end()}
         *     to return to the current builder.
         */
        public ExecutionEnvironment.Builder<? extends DesktopApplication.Builder<_B>> addExecutables() {
            if (this.executables == null) {
                this.executables = new ArrayList<>();
            }
            final ExecutionEnvironment.Builder<DesktopApplication.Builder<_B>> executables_Builder = new ExecutionEnvironment.Builder<>(this, null, false);
            this.executables.add(executables_Builder);
            return executables_Builder;
        }

        /**
         * Sets the new value of "cost" (any previous value will be replaced)
         * 
         * @param cost
         *     New value of the "cost" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withCost(final String cost) {
            super.withCost(cost);
            return this;
        }

        /**
         * Sets the new value of "licence" (any previous value will be replaced)
         * 
         * @param licence
         *     New value of the "licence" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withLicence(final String licence) {
            super.withLicence(licence);
            return this;
        }

        /**
         * Sets the new value of "openSource" (any previous value will be replaced)
         * 
         * @param openSource
         *     New value of the "openSource" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withOpenSource(final Boolean openSource) {
            super.withOpenSource(openSource);
            return this;
        }

        /**
         * Adds the given items to the value of "dataFormats"
         * 
         * @param dataFormats
         *     Items to add to the value of the "dataFormats" property
         */
        @Override
        public DesktopApplication.Builder<_B> addDataFormats(final Iterable<? extends DataFormat> dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        /**
         * Adds the given items to the value of "dataFormats"
         * 
         * @param dataFormats
         *     Items to add to the value of the "dataFormats" property
         */
        @Override
        public DesktopApplication.Builder<_B> addDataFormats(DataFormat... dataFormats) {
            super.addDataFormats(dataFormats);
            return this;
        }

        /**
         * Sets the new value of "dataFormats" (any previous value will be replaced)
         * 
         * @param dataFormats
         *     New value of the "dataFormats" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withDataFormats(final Iterable<? extends DataFormat> dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        /**
         * Sets the new value of "dataFormats" (any previous value will be replaced)
         * 
         * @param dataFormats
         *     New value of the "dataFormats" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withDataFormats(DataFormat... dataFormats) {
            super.withDataFormats(dataFormats);
            return this;
        }

        /**
         * Adds the given items to the value of "voStandards"
         * 
         * @param voStandards
         *     Items to add to the value of the "voStandards" property
         */
        @Override
        public DesktopApplication.Builder<_B> addVoStandards(final Iterable<? extends ApplicationCapability> voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        /**
         * Adds the given items to the value of "voStandards"
         * 
         * @param voStandards
         *     Items to add to the value of the "voStandards" property
         */
        @Override
        public DesktopApplication.Builder<_B> addVoStandards(ApplicationCapability... voStandards) {
            super.addVoStandards(voStandards);
            return this;
        }

        /**
         * Sets the new value of "voStandards" (any previous value will be replaced)
         * 
         * @param voStandards
         *     New value of the "voStandards" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withVoStandards(final Iterable<? extends ApplicationCapability> voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        /**
         * Sets the new value of "voStandards" (any previous value will be replaced)
         * 
         * @param voStandards
         *     New value of the "voStandards" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withVoStandards(ApplicationCapability... voStandards) {
            super.withVoStandards(voStandards);
            return this;
        }

        /**
         * Adds the given items to the value of "sourceLanguages"
         * 
         * @param sourceLanguages
         *     Items to add to the value of the "sourceLanguages" property
         */
        @Override
        public DesktopApplication.Builder<_B> addSourceLanguages(final Iterable<? extends String> sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Adds the given items to the value of "sourceLanguages"
         * 
         * @param sourceLanguages
         *     Items to add to the value of the "sourceLanguages" property
         */
        @Override
        public DesktopApplication.Builder<_B> addSourceLanguages(String... sourceLanguages) {
            super.addSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceLanguages" (any previous value will be replaced)
         * 
         * @param sourceLanguages
         *     New value of the "sourceLanguages" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withSourceLanguages(final Iterable<? extends String> sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceLanguages" (any previous value will be replaced)
         * 
         * @param sourceLanguages
         *     New value of the "sourceLanguages" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withSourceLanguages(String... sourceLanguages) {
            super.withSourceLanguages(sourceLanguages);
            return this;
        }

        /**
         * Sets the new value of "sourceCodeURL" (any previous value will be replaced)
         * 
         * @param sourceCodeURL
         *     New value of the "sourceCodeURL" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withSourceCodeURL(final String sourceCodeURL) {
            super.withSourceCodeURL(sourceCodeURL);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public DesktopApplication.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public DesktopApplication.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public DesktopApplication.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public DesktopApplication.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends DesktopApplication.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends DesktopApplication.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends DesktopApplication.Builder<_B>> withContent() {
            return ((Content.Builder<? extends DesktopApplication.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withCreated(final ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withUpdated(final ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public DesktopApplication.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public DesktopApplication build() {
            if (_storedValue == null) {
                return this.init(new DesktopApplication());
            } else {
                return ((DesktopApplication) _storedValue);
            }
        }

        public DesktopApplication.Builder<_B> copyOf(final DesktopApplication _other) {
            _other.copyTo(this);
            return this;
        }

        public DesktopApplication.Builder<_B> copyOf(final DesktopApplication.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Application.Modifier
    {


        public void setBinarySize(final Integer binarySize) {
            DesktopApplication.this.setBinarySize(binarySize);
        }

        public void setMemoryRequirement(final String memoryRequirement) {
            DesktopApplication.this.setMemoryRequirement(memoryRequirement);
        }

        public void setNetwork(final NetworkRequirement network) {
            DesktopApplication.this.setNetwork(network);
        }

        public List<String> getDependsOns() {
            if (DesktopApplication.this.dependsOns == null) {
                DesktopApplication.this.dependsOns = new ArrayList<>();
            }
            return DesktopApplication.this.dependsOns;
        }

        public List<ExecutionEnvironment> getExecutables() {
            if (DesktopApplication.this.executables == null) {
                DesktopApplication.this.executables = new ArrayList<>();
            }
            return DesktopApplication.this.executables;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<DesktopApplication, Integer> BINARY_SIZE = new SinglePropertyInfo<DesktopApplication,Integer>("binarySize", DesktopApplication.class, Integer.class, false, null, new QName("", "binarySize"), new QName("http://www.w3.org/2001/XMLSchema", "int"), false) {


            @Override
            public Integer get(final DesktopApplication _instance_) {
                return ((_instance_ == null)?null:_instance_.binarySize);
            }

            @Override
            public void set(final DesktopApplication _instance_, final Integer _value_) {
                if (_instance_!= null) {
                    _instance_.binarySize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<DesktopApplication, String> MEMORY_REQUIREMENT = new SinglePropertyInfo<DesktopApplication,String>("memoryRequirement", DesktopApplication.class, String.class, false, null, new QName("", "memoryRequirement"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final DesktopApplication _instance_) {
                return ((_instance_ == null)?null:_instance_.memoryRequirement);
            }

            @Override
            public void set(final DesktopApplication _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.memoryRequirement = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<DesktopApplication, NetworkRequirement> NETWORK = new SinglePropertyInfo<DesktopApplication,NetworkRequirement>("network", DesktopApplication.class, NetworkRequirement.class, false, null, new QName("", "network"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "NetworkRequirement"), false) {


            @Override
            public NetworkRequirement get(final DesktopApplication _instance_) {
                return ((_instance_ == null)?null:_instance_.network);
            }

            @Override
            public void set(final DesktopApplication _instance_, final NetworkRequirement _value_) {
                if (_instance_!= null) {
                    _instance_.network = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<DesktopApplication, String> DEPENDS_ONS = new CollectionPropertyInfo<DesktopApplication,String>("dependsOns", DesktopApplication.class, String.class, true, null, new QName("", "dependsOn"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "IdentifierURI"), false) {


            @Override
            public List<String> get(final DesktopApplication _instance_) {
                return ((_instance_ == null)?null:_instance_.dependsOns);
            }

            @Override
            public void set(final DesktopApplication _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.dependsOns = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<DesktopApplication, ExecutionEnvironment> EXECUTABLES = new CollectionPropertyInfo<DesktopApplication,ExecutionEnvironment>("executables", DesktopApplication.class, ExecutionEnvironment.class, true, null, new QName("", "executable"), new QName("http://www.ivoa.net/xml/VOApplication/v1.0rc1", "ExecutionEnvironment"), false) {


            @Override
            public List<ExecutionEnvironment> get(final DesktopApplication _instance_) {
                return ((_instance_ == null)?null:_instance_.executables);
            }

            @Override
            public void set(final DesktopApplication _instance_, final List<ExecutionEnvironment> _value_) {
                if (_instance_!= null) {
                    _instance_.executables = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends DesktopApplication.Selector<DesktopApplication.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static DesktopApplication.Select _root() {
            return new DesktopApplication.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Application.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> binarySize = null;
        private com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> memoryRequirement = null;
        private com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> network = null;
        private com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> dependsOns = null;
        private ExecutionEnvironment.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> executables = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.binarySize!= null) {
                products.put("binarySize", this.binarySize.init());
            }
            if (this.memoryRequirement!= null) {
                products.put("memoryRequirement", this.memoryRequirement.init());
            }
            if (this.network!= null) {
                products.put("network", this.network.init());
            }
            if (this.dependsOns!= null) {
                products.put("dependsOns", this.dependsOns.init());
            }
            if (this.executables!= null) {
                products.put("executables", this.executables.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> binarySize() {
            return ((this.binarySize == null)?this.binarySize = new com.kscs.util.jaxb.Selector<>(this._root, this, "binarySize"):this.binarySize);
        }

        public com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> memoryRequirement() {
            return ((this.memoryRequirement == null)?this.memoryRequirement = new com.kscs.util.jaxb.Selector<>(this._root, this, "memoryRequirement"):this.memoryRequirement);
        }

        public com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> network() {
            return ((this.network == null)?this.network = new com.kscs.util.jaxb.Selector<>(this._root, this, "network"):this.network);
        }

        public com.kscs.util.jaxb.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> dependsOns() {
            return ((this.dependsOns == null)?this.dependsOns = new com.kscs.util.jaxb.Selector<>(this._root, this, "dependsOns"):this.dependsOns);
        }

        public ExecutionEnvironment.Selector<TRoot, DesktopApplication.Selector<TRoot, TParent>> executables() {
            return ((this.executables == null)?this.executables = new ExecutionEnvironment.Selector<>(this._root, this, "executables"):this.executables);
        }

    }

}
