
package org.javastro.ivoa.entities.resource.applications;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * Characterization as to whether a network connection is
 *             required by the application.
 * 
 * <p>Java class for NetworkRequirement</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="NetworkRequirement">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="Essential"/>
 *     <enumeration value="Useful"/>
 *     <enumeration value="Limited"/>
 *     <enumeration value="Unnecessary"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "NetworkRequirement")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum NetworkRequirement implements EnumValue<String>
{


    /**
     * The application cannot function without a network
     *                   connection
     * 
     */
    @XmlEnumValue("Essential")
    ESSENTIAL("Essential"),

    /**
     * The application will function without a network
     *                   connection, but the primary use for the application
     *                   requires a network connection.
     * 
     */
    @XmlEnumValue("Useful")
    USEFUL("Useful"),

    /**
     * The application makes only limited use of network
     *                   facilities, thus the majority of its functionality is
     *                   still available without a network connection.
     * 
     */
    @XmlEnumValue("Limited")
    LIMITED("Limited"),

    /**
     * The application makes no use of the network.
     * 
     */
    @XmlEnumValue("Unnecessary")
    UNNECESSARY("Unnecessary");
    private final String value;

    NetworkRequirement(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static NetworkRequirement fromValue(String v) {
        for (NetworkRequirement c: NetworkRequirement.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
