
package org.javastro.ivoa.entities.resource.cone;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A query to be sent to the service
 * 
 * <p>Java class for Query complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Query">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="ra" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="dec" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="sr" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="verb" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="catalog" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="extras" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Query", propOrder = {
    "ra",
    "dec",
    "sr",
    "verb",
    "catalog",
    "extras"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Query implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the right ascension of the search cone's center in
     *                    decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected double ra;
    /**
     * the declination of the search cone's center in
     *                    decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected double dec;
    /**
     * the radius of the search cone in decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected double sr;
    /**
     * the verbosity level to use where 1 means the bare
     *                    minimum set of columns and 3 means the full set of 
     *                    available columns.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected BigInteger verb;
    /**
     * When the service can access more than one catalog,
     *                    this input parameter, if available, is used to
     *                    indicate which service to access.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String catalog;
    /**
     * this value should be in the form of name=value
     *                    pairs delimited with ampersands (&).
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String extras;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Query.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Query() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Query(final double ra, final double dec, final double sr, final BigInteger verb, final String catalog, final String extras) {
        this.ra = ra;
        this.dec = dec;
        this.sr = sr;
        this.verb = verb;
        this.catalog = catalog;
        this.extras = extras;
    }

    /**
     * the right ascension of the search cone's center in
     *                    decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public double getRa() {
        return ra;
    }

    /**
     * Sets the value of the ra property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRa(double value) {
        this.ra = value;
    }

    /**
     * the declination of the search cone's center in
     *                    decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public double getDec() {
        return dec;
    }

    /**
     * Sets the value of the dec property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDec(double value) {
        this.dec = value;
    }

    /**
     * the radius of the search cone in decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public double getSr() {
        return sr;
    }

    /**
     * Sets the value of the sr property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSr(double value) {
        this.sr = value;
    }

    /**
     * the verbosity level to use where 1 means the bare
     *                    minimum set of columns and 3 means the full set of 
     *                    available columns.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BigInteger getVerb() {
        return verb;
    }

    /**
     * Sets the value of the verb property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getVerb()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setVerb(BigInteger value) {
        this.verb = value;
    }

    /**
     * When the service can access more than one catalog,
     *                    this input parameter, if available, is used to
     *                    indicate which service to access.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getCatalog() {
        return catalog;
    }

    /**
     * Sets the value of the catalog property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCatalog()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCatalog(String value) {
        this.catalog = value;
    }

    /**
     * this value should be in the form of name=value
     *                    pairs delimited with ampersands (&).
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getExtras() {
        return extras;
    }

    /**
     * Sets the value of the extras property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getExtras()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setExtras(String value) {
        this.extras = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Query that = ((Query) object);
        {
            double leftRa;
            leftRa = this.getRa();
            double rightRa;
            rightRa = that.getRa();
            if (Double.doubleToLongBits(leftRa)!= Double.doubleToLongBits(rightRa)) {
                return false;
            }
        }
        {
            double leftDec;
            leftDec = this.getDec();
            double rightDec;
            rightDec = that.getDec();
            if (Double.doubleToLongBits(leftDec)!= Double.doubleToLongBits(rightDec)) {
                return false;
            }
        }
        {
            double leftSr;
            leftSr = this.getSr();
            double rightSr;
            rightSr = that.getSr();
            if (Double.doubleToLongBits(leftSr)!= Double.doubleToLongBits(rightSr)) {
                return false;
            }
        }
        {
            BigInteger leftVerb;
            leftVerb = this.getVerb();
            BigInteger rightVerb;
            rightVerb = that.getVerb();
            if (this.verb!= null) {
                if (that.verb!= null) {
                    if (!leftVerb.equals(rightVerb)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.verb!= null) {
                    return false;
                }
            }
        }
        {
            String leftCatalog;
            leftCatalog = this.getCatalog();
            String rightCatalog;
            rightCatalog = that.getCatalog();
            if (this.catalog!= null) {
                if (that.catalog!= null) {
                    if (!leftCatalog.equals(rightCatalog)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.catalog!= null) {
                    return false;
                }
            }
        }
        {
            String leftExtras;
            leftExtras = this.getExtras();
            String rightExtras;
            rightExtras = that.getExtras();
            if (this.extras!= null) {
                if (that.extras!= null) {
                    if (!leftExtras.equals(rightExtras)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.extras!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            double theRa;
            theRa = this.getRa();
            final long theRaBits = Double.doubleToLongBits(theRa);
            currentHashCode += ((int)(theRaBits^(theRaBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theDec;
            theDec = this.getDec();
            final long theDecBits = Double.doubleToLongBits(theDec);
            currentHashCode += ((int)(theDecBits^(theDecBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theSr;
            theSr = this.getSr();
            final long theSrBits = Double.doubleToLongBits(theSr);
            currentHashCode += ((int)(theSrBits^(theSrBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theVerb;
            theVerb = this.getVerb();
            if (this.verb!= null) {
                currentHashCode += theVerb.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCatalog;
            theCatalog = this.getCatalog();
            if (this.catalog!= null) {
                currentHashCode += theCatalog.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theExtras;
            theExtras = this.getExtras();
            if (this.extras!= null) {
                currentHashCode += theExtras.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            double theRa;
            theRa = this.getRa();
            strategy.appendField(locator, this, "ra", buffer, theRa, true);
        }
        {
            double theDec;
            theDec = this.getDec();
            strategy.appendField(locator, this, "dec", buffer, theDec, true);
        }
        {
            double theSr;
            theSr = this.getSr();
            strategy.appendField(locator, this, "sr", buffer, theSr, true);
        }
        {
            BigInteger theVerb;
            theVerb = this.getVerb();
            strategy.appendField(locator, this, "verb", buffer, theVerb, (this.verb!= null));
        }
        {
            String theCatalog;
            theCatalog = this.getCatalog();
            strategy.appendField(locator, this, "catalog", buffer, theCatalog, (this.catalog!= null));
        }
        {
            String theExtras;
            theExtras = this.getExtras();
            strategy.appendField(locator, this, "extras", buffer, theExtras, (this.extras!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Query) {
            final Query target = this;
            final Query leftObject = ((Query) left);
            final Query rightObject = ((Query) right);
            {
                Boolean raShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (raShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsRa;
                    lhsRa = leftObject.getRa();
                    double rhsRa;
                    rhsRa = rightObject.getRa();
                    double mergedRa = ((double) strategy.merge(LocatorUtils.property(leftLocator, "ra", lhsRa), LocatorUtils.property(rightLocator, "ra", rhsRa), lhsRa, rhsRa, true, true));
                    target.setRa(mergedRa);
                } else {
                    if (raShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean decShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (decShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsDec;
                    lhsDec = leftObject.getDec();
                    double rhsDec;
                    rhsDec = rightObject.getDec();
                    double mergedDec = ((double) strategy.merge(LocatorUtils.property(leftLocator, "dec", lhsDec), LocatorUtils.property(rightLocator, "dec", rhsDec), lhsDec, rhsDec, true, true));
                    target.setDec(mergedDec);
                } else {
                    if (decShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean srShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (srShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsSr;
                    lhsSr = leftObject.getSr();
                    double rhsSr;
                    rhsSr = rightObject.getSr();
                    double mergedSr = ((double) strategy.merge(LocatorUtils.property(leftLocator, "sr", lhsSr), LocatorUtils.property(rightLocator, "sr", rhsSr), lhsSr, rhsSr, true, true));
                    target.setSr(mergedSr);
                } else {
                    if (srShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean verbShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.verb!= null), (rightObject.verb!= null));
                if (verbShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsVerb;
                    lhsVerb = leftObject.getVerb();
                    BigInteger rhsVerb;
                    rhsVerb = rightObject.getVerb();
                    BigInteger mergedVerb = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "verb", lhsVerb), LocatorUtils.property(rightLocator, "verb", rhsVerb), lhsVerb, rhsVerb, (leftObject.verb!= null), (rightObject.verb!= null)));
                    target.setVerb(mergedVerb);
                } else {
                    if (verbShouldBeMergedAndSet == Boolean.FALSE) {
                        target.verb = null;
                    }
                }
            }
            {
                Boolean catalogShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.catalog!= null), (rightObject.catalog!= null));
                if (catalogShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsCatalog;
                    lhsCatalog = leftObject.getCatalog();
                    String rhsCatalog;
                    rhsCatalog = rightObject.getCatalog();
                    String mergedCatalog = ((String) strategy.merge(LocatorUtils.property(leftLocator, "catalog", lhsCatalog), LocatorUtils.property(rightLocator, "catalog", rhsCatalog), lhsCatalog, rhsCatalog, (leftObject.catalog!= null), (rightObject.catalog!= null)));
                    target.setCatalog(mergedCatalog);
                } else {
                    if (catalogShouldBeMergedAndSet == Boolean.FALSE) {
                        target.catalog = null;
                    }
                }
            }
            {
                Boolean extrasShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.extras!= null), (rightObject.extras!= null));
                if (extrasShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsExtras;
                    lhsExtras = leftObject.getExtras();
                    String rhsExtras;
                    rhsExtras = rightObject.getExtras();
                    String mergedExtras = ((String) strategy.merge(LocatorUtils.property(leftLocator, "extras", lhsExtras), LocatorUtils.property(rightLocator, "extras", rhsExtras), lhsExtras, rhsExtras, (leftObject.extras!= null), (rightObject.extras!= null)));
                    target.setExtras(mergedExtras);
                } else {
                    if (extrasShouldBeMergedAndSet == Boolean.FALSE) {
                        target.extras = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Query();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query clone() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.ra = this.ra;
        _newObject.dec = this.dec;
        _newObject.sr = this.sr;
        _newObject.verb = this.verb;
        _newObject.catalog = this.catalog;
        _newObject.extras = this.extras;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree raPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ra"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(raPropertyTree!= null):((raPropertyTree == null)||(!raPropertyTree.isLeaf())))) {
            _newObject.ra = this.ra;
        }
        final PropertyTree decPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dec"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(decPropertyTree!= null):((decPropertyTree == null)||(!decPropertyTree.isLeaf())))) {
            _newObject.dec = this.dec;
        }
        final PropertyTree srPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("sr"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(srPropertyTree!= null):((srPropertyTree == null)||(!srPropertyTree.isLeaf())))) {
            _newObject.sr = this.sr;
        }
        final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
            _newObject.verb = this.verb;
        }
        final PropertyTree catalogPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("catalog"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(catalogPropertyTree!= null):((catalogPropertyTree == null)||(!catalogPropertyTree.isLeaf())))) {
            _newObject.catalog = this.catalog;
        }
        final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
            _newObject.extras = this.extras;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Query.Modifier();
        }
        return ((Query.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other) {
        _other.ra = this.ra;
        _other.dec = this.dec;
        _other.sr = this.sr;
        _other.verb = this.verb;
        _other.catalog = this.catalog;
        _other.extras = this.extras;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Query.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> builder() {
        return new Query.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree raPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ra"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(raPropertyTree!= null):((raPropertyTree == null)||(!raPropertyTree.isLeaf())))) {
            _other.ra = this.ra;
        }
        final PropertyTree decPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dec"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(decPropertyTree!= null):((decPropertyTree == null)||(!decPropertyTree.isLeaf())))) {
            _other.dec = this.dec;
        }
        final PropertyTree srPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("sr"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(srPropertyTree!= null):((srPropertyTree == null)||(!srPropertyTree.isLeaf())))) {
            _other.sr = this.sr;
        }
        final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
            _other.verb = this.verb;
        }
        final PropertyTree catalogPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("catalog"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(catalogPropertyTree!= null):((catalogPropertyTree == null)||(!catalogPropertyTree.isLeaf())))) {
            _other.catalog = this.catalog;
        }
        final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
            _other.extras = this.extras;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Query.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyExcept(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyOnly(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.RA, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.DEC, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.SR, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.VERB, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.CATALOG, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.EXTRAS, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Query _storedValue;
        private double ra;
        private double dec;
        private double sr;
        private BigInteger verb;
        private String catalog;
        private String extras;

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.ra = _other.ra;
                    this.dec = _other.dec;
                    this.sr = _other.sr;
                    this.verb = _other.verb;
                    this.catalog = _other.catalog;
                    this.extras = _other.extras;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree raPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ra"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(raPropertyTree!= null):((raPropertyTree == null)||(!raPropertyTree.isLeaf())))) {
                        this.ra = _other.ra;
                    }
                    final PropertyTree decPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dec"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(decPropertyTree!= null):((decPropertyTree == null)||(!decPropertyTree.isLeaf())))) {
                        this.dec = _other.dec;
                    }
                    final PropertyTree srPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("sr"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(srPropertyTree!= null):((srPropertyTree == null)||(!srPropertyTree.isLeaf())))) {
                        this.sr = _other.sr;
                    }
                    final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
                        this.verb = _other.verb;
                    }
                    final PropertyTree catalogPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("catalog"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(catalogPropertyTree!= null):((catalogPropertyTree == null)||(!catalogPropertyTree.isLeaf())))) {
                        this.catalog = _other.catalog;
                    }
                    final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
                        this.extras = _other.extras;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Query >_P init(final _P _product) {
            _product.ra = this.ra;
            _product.dec = this.dec;
            _product.sr = this.sr;
            _product.verb = this.verb;
            _product.catalog = this.catalog;
            _product.extras = this.extras;
            return _product;
        }

        /**
         * Sets the new value of "ra" (any previous value will be replaced)
         * 
         * @param ra
         *     New value of the "ra" property.
         */
        public Query.Builder<_B> withRa(final double ra) {
            this.ra = ra;
            return this;
        }

        /**
         * Sets the new value of "dec" (any previous value will be replaced)
         * 
         * @param dec
         *     New value of the "dec" property.
         */
        public Query.Builder<_B> withDec(final double dec) {
            this.dec = dec;
            return this;
        }

        /**
         * Sets the new value of "sr" (any previous value will be replaced)
         * 
         * @param sr
         *     New value of the "sr" property.
         */
        public Query.Builder<_B> withSr(final double sr) {
            this.sr = sr;
            return this;
        }

        /**
         * Sets the new value of "verb" (any previous value will be replaced)
         * 
         * @param verb
         *     New value of the "verb" property.
         */
        public Query.Builder<_B> withVerb(final BigInteger verb) {
            this.verb = verb;
            return this;
        }

        /**
         * Sets the new value of "catalog" (any previous value will be replaced)
         * 
         * @param catalog
         *     New value of the "catalog" property.
         */
        public Query.Builder<_B> withCatalog(final String catalog) {
            this.catalog = catalog;
            return this;
        }

        /**
         * Sets the new value of "extras" (any previous value will be replaced)
         * 
         * @param extras
         *     New value of the "extras" property.
         */
        public Query.Builder<_B> withExtras(final String extras) {
            this.extras = extras;
            return this;
        }

        @Override
        public Query build() {
            if (_storedValue == null) {
                return this.init(new Query());
            } else {
                return ((Query) _storedValue);
            }
        }

        public Query.Builder<_B> copyOf(final Query _other) {
            _other.copyTo(this);
            return this;
        }

        public Query.Builder<_B> copyOf(final Query.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setRa(final double ra) {
            Query.this.setRa(ra);
        }

        public void setDec(final double dec) {
            Query.this.setDec(dec);
        }

        public void setSr(final double sr) {
            Query.this.setSr(sr);
        }

        public void setVerb(final BigInteger verb) {
            Query.this.setVerb(verb);
        }

        public void setCatalog(final String catalog) {
            Query.this.setCatalog(catalog);
        }

        public void setExtras(final String extras) {
            Query.this.setExtras(extras);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Query, Double> RA = new SinglePropertyInfo<Query,Double>("ra", Query.class, Double.class, false, null, new QName("", "ra"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.ra);
            }

            @Override
            public void set(final Query _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.ra = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, Double> DEC = new SinglePropertyInfo<Query,Double>("dec", Query.class, Double.class, false, null, new QName("", "dec"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.dec);
            }

            @Override
            public void set(final Query _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.dec = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, Double> SR = new SinglePropertyInfo<Query,Double>("sr", Query.class, Double.class, false, null, new QName("", "sr"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.sr);
            }

            @Override
            public void set(final Query _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.sr = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, BigInteger> VERB = new SinglePropertyInfo<Query,BigInteger>("verb", Query.class, BigInteger.class, false, null, new QName("", "verb"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.verb);
            }

            @Override
            public void set(final Query _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.verb = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, String> CATALOG = new SinglePropertyInfo<Query,String>("catalog", Query.class, String.class, false, null, new QName("", "catalog"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.catalog);
            }

            @Override
            public void set(final Query _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.catalog = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, String> EXTRAS = new SinglePropertyInfo<Query,String>("extras", Query.class, String.class, false, null, new QName("", "extras"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.extras);
            }

            @Override
            public void set(final Query _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.extras = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Query.Selector<Query.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Query.Select _root() {
            return new Query.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> verb = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> catalog = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> extras = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.verb!= null) {
                products.put("verb", this.verb.init());
            }
            if (this.catalog!= null) {
                products.put("catalog", this.catalog.init());
            }
            if (this.extras!= null) {
                products.put("extras", this.extras.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> verb() {
            return ((this.verb == null)?this.verb = new com.kscs.util.jaxb.Selector<>(this._root, this, "verb"):this.verb);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> catalog() {
            return ((this.catalog == null)?this.catalog = new com.kscs.util.jaxb.Selector<>(this._root, this, "catalog"):this.catalog);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> extras() {
            return ((this.extras == null)?this.extras = new com.kscs.util.jaxb.Selector<>(this._root, this, "extras"):this.extras);
        }

    }

}
