
package org.javastro.ivoa.entities.resource.dataservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A description of how a resource's contents or behavior maps
 *            to the sky, to time, and to frequency space, including
 *            coverage and resolution.
 * 
 * <p>Java class for Coverage complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Coverage">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}STCResourceProfile" minOccurs="0"/>
 *         <element name="spatial" type="{http://www.ivoa.net/xml/VODataService/v1.1}SpatialCoverage" minOccurs="0"/>
 *         <element name="temporal" type="{http://www.ivoa.net/xml/VODataService/v1.1}FloatInterval" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="spectral" type="{http://www.ivoa.net/xml/VODataService/v1.1}FloatInterval" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="footprint" type="{http://www.ivoa.net/xml/VODataService/v1.1}ServiceReference" minOccurs="0"/>
 *         <element name="waveband" type="{http://www.ivoa.net/xml/VODataService/v1.1}Waveband" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="regionOfRegard" type="{http://www.w3.org/2001/XMLSchema}float" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Coverage", propOrder = {
    "stcResourceProfile",
    "spatial",
    "temporals",
    "spectrals",
    "footprint",
    "wavebands",
    "regionOfRegard"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Coverage implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * An STC 1.0 description of the location of the resource's 
     *                  data on the sky, in time, and in frequency space, 
     *                  including resolution.   This is deprecated in favour
     *                  of the separate spatial, temporal, and spectral elements.
     * 
     */
    @XmlElement(name = "STCResourceProfile", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected AstroSTCDescriptionType stcResourceProfile;
    /**
     * The MOC is to be understood in the ICRS reference frame 
     *                   unless a frame attribute is given.
     *                   Resources should give the coverage at least to order 6
     *                   (a resolution of about one degree).  The order should be
     *                   chosen so as to keep the resulting MOC smaller than a few
     *                   dozens of kB.  If desired, a more precise MOC can be provided
     *                   on a dedicated endpoint declared in the footprint element.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected SpatialCoverage spatial;
    /**
     * This is written as for VOTable tabledata (i.e., 
     *                   whitespace-separated C-style floating point literals).
     *                   The limits must be given as MJD.  While they
     *                   are not intended to be precise, they are to be understood
     *                   in TDB for the solar system barycenter.  The total coverage
     *                   of the resource is the union of all such intervals.
     * 
     */
    @XmlElement(name = "temporal")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<String> temporals;
    /**
     * For instance, the Johnson V waveband (480 .. 730 nm)
     *                   would be specified as “2.72e-19 4.14e-19”
     * 
     */
    @XmlElement(name = "spectral")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<String> spectrals;
    /**
     * The ivo-id attribute here refers to the standard in which
     *                   the footprint is given.  The only value defined by 
     *                   VODataService at this point is ivo://ivoa.net/std/moc, 
     *                   which indicates that retrieving the footprint URL will return
     *                   a MOC (any IVOA-approved serialisation is legal).  Note that
     *                   the ivo-id attribute was intended to have a different
     *                   function in VODataService 1.1.  The current meaning is what
     *                   implementors actually adopted.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ServiceReference footprint;
    /**
     * Observations using non-electromagnetic messengers should
     *                   not give a waveband in version 1.2 of VODataService.  It
     *                   is expected that additional terms for these will be provided
     *                   in a future version.
     * 
     */
    @XmlElement(name = "waveband")
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<Waveband> wavebands;
    /**
     * In the case of image repositories, it might refer to
     *                   a typical field-of-view size, or the primary beam
     *                   size for radio aperture synthesis data.  In the case
     *                   of object catalogues RoR should normally be the
     *                   largest of the typical size of the objects, the
     *                   astrometric errors in the positions, or the
     *                   resolution of the data.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Float regionOfRegard;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Coverage.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Coverage() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Coverage(final AstroSTCDescriptionType stcResourceProfile, final SpatialCoverage spatial, final List<String> temporals, final List<String> spectrals, final ServiceReference footprint, final List<Waveband> wavebands, final Float regionOfRegard) {
        this.stcResourceProfile = stcResourceProfile;
        this.spatial = spatial;
        this.temporals = temporals;
        this.spectrals = spectrals;
        this.footprint = footprint;
        this.wavebands = wavebands;
        this.regionOfRegard = regionOfRegard;
    }

    /**
     * An STC 1.0 description of the location of the resource's 
     *                  data on the sky, in time, and in frequency space, 
     *                  including resolution.   This is deprecated in favour
     *                  of the separate spatial, temporal, and spectral elements.
     * 
     * @return
     *     possible object is
     *     {@link AstroSTCDescriptionType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroSTCDescriptionType getSTCResourceProfile() {
        return stcResourceProfile;
    }

    /**
     * Sets the value of the stcResourceProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link AstroSTCDescriptionType }
     *     
     * @see #getSTCResourceProfile()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSTCResourceProfile(AstroSTCDescriptionType value) {
        this.stcResourceProfile = value;
    }

    /**
     * The MOC is to be understood in the ICRS reference frame 
     *                   unless a frame attribute is given.
     *                   Resources should give the coverage at least to order 6
     *                   (a resolution of about one degree).  The order should be
     *                   chosen so as to keep the resulting MOC smaller than a few
     *                   dozens of kB.  If desired, a more precise MOC can be provided
     *                   on a dedicated endpoint declared in the footprint element.
     * 
     * @return
     *     possible object is
     *     {@link SpatialCoverage }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SpatialCoverage getSpatial() {
        return spatial;
    }

    /**
     * Sets the value of the spatial property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpatialCoverage }
     *     
     * @see #getSpatial()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSpatial(SpatialCoverage value) {
        this.spatial = value;
    }

    /**
     * This is written as for VOTable tabledata (i.e., 
     *                   whitespace-separated C-style floating point literals).
     *                   The limits must be given as MJD.  While they
     *                   are not intended to be precise, they are to be understood
     *                   in TDB for the solar system barycenter.  The total coverage
     *                   of the resource is the union of all such intervals.
     * 
     * Gets the value of the temporals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the temporals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTemporals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the temporals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<String> getTemporals() {
        if (temporals == null) {
            temporals = new ArrayList<>();
        }
        return this.temporals;
    }

    /**
     * For instance, the Johnson V waveband (480 .. 730 nm)
     *                   would be specified as “2.72e-19 4.14e-19”
     * 
     * Gets the value of the spectrals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spectrals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSpectrals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the spectrals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<String> getSpectrals() {
        if (spectrals == null) {
            spectrals = new ArrayList<>();
        }
        return this.spectrals;
    }

    /**
     * The ivo-id attribute here refers to the standard in which
     *                   the footprint is given.  The only value defined by 
     *                   VODataService at this point is ivo://ivoa.net/std/moc, 
     *                   which indicates that retrieving the footprint URL will return
     *                   a MOC (any IVOA-approved serialisation is legal).  Note that
     *                   the ivo-id attribute was intended to have a different
     *                   function in VODataService 1.1.  The current meaning is what
     *                   implementors actually adopted.
     * 
     * @return
     *     possible object is
     *     {@link ServiceReference }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ServiceReference getFootprint() {
        return footprint;
    }

    /**
     * Sets the value of the footprint property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceReference }
     *     
     * @see #getFootprint()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setFootprint(ServiceReference value) {
        this.footprint = value;
    }

    /**
     * Observations using non-electromagnetic messengers should
     *                   not give a waveband in version 1.2 of VODataService.  It
     *                   is expected that additional terms for these will be provided
     *                   in a future version.
     * 
     * Gets the value of the wavebands property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the wavebands property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getWavebands().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Waveband }
     * </p>
     * 
     * 
     * @return
     *     The value of the wavebands property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<Waveband> getWavebands() {
        if (wavebands == null) {
            wavebands = new ArrayList<>();
        }
        return this.wavebands;
    }

    /**
     * In the case of image repositories, it might refer to
     *                   a typical field-of-view size, or the primary beam
     *                   size for radio aperture synthesis data.  In the case
     *                   of object catalogues RoR should normally be the
     *                   largest of the typical size of the objects, the
     *                   astrometric errors in the positions, or the
     *                   resolution of the data.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Float getRegionOfRegard() {
        return regionOfRegard;
    }

    /**
     * Sets the value of the regionOfRegard property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     * @see #getRegionOfRegard()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRegionOfRegard(Float value) {
        this.regionOfRegard = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Coverage that = ((Coverage) object);
        {
            AstroSTCDescriptionType leftSTCResourceProfile;
            leftSTCResourceProfile = this.getSTCResourceProfile();
            AstroSTCDescriptionType rightSTCResourceProfile;
            rightSTCResourceProfile = that.getSTCResourceProfile();
            if (this.stcResourceProfile!= null) {
                if (that.stcResourceProfile!= null) {
                    if (!leftSTCResourceProfile.equals(rightSTCResourceProfile)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.stcResourceProfile!= null) {
                    return false;
                }
            }
        }
        {
            SpatialCoverage leftSpatial;
            leftSpatial = this.getSpatial();
            SpatialCoverage rightSpatial;
            rightSpatial = that.getSpatial();
            if (this.spatial!= null) {
                if (that.spatial!= null) {
                    if (!leftSpatial.equals(rightSpatial)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.spatial!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftTemporals;
            leftTemporals = (((this.temporals!= null)&&(!this.temporals.isEmpty()))?this.getTemporals():null);
            List<String> rightTemporals;
            rightTemporals = (((that.temporals!= null)&&(!that.temporals.isEmpty()))?that.getTemporals():null);
            if ((this.temporals!= null)&&(!this.temporals.isEmpty())) {
                if ((that.temporals!= null)&&(!that.temporals.isEmpty())) {
                    if (!leftTemporals.equals(rightTemporals)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.temporals!= null)&&(!that.temporals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<String> leftSpectrals;
            leftSpectrals = (((this.spectrals!= null)&&(!this.spectrals.isEmpty()))?this.getSpectrals():null);
            List<String> rightSpectrals;
            rightSpectrals = (((that.spectrals!= null)&&(!that.spectrals.isEmpty()))?that.getSpectrals():null);
            if ((this.spectrals!= null)&&(!this.spectrals.isEmpty())) {
                if ((that.spectrals!= null)&&(!that.spectrals.isEmpty())) {
                    if (!leftSpectrals.equals(rightSpectrals)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.spectrals!= null)&&(!that.spectrals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            ServiceReference leftFootprint;
            leftFootprint = this.getFootprint();
            ServiceReference rightFootprint;
            rightFootprint = that.getFootprint();
            if (this.footprint!= null) {
                if (that.footprint!= null) {
                    if (!leftFootprint.equals(rightFootprint)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.footprint!= null) {
                    return false;
                }
            }
        }
        {
            List<Waveband> leftWavebands;
            leftWavebands = (((this.wavebands!= null)&&(!this.wavebands.isEmpty()))?this.getWavebands():null);
            List<Waveband> rightWavebands;
            rightWavebands = (((that.wavebands!= null)&&(!that.wavebands.isEmpty()))?that.getWavebands():null);
            if ((this.wavebands!= null)&&(!this.wavebands.isEmpty())) {
                if ((that.wavebands!= null)&&(!that.wavebands.isEmpty())) {
                    if (!leftWavebands.equals(rightWavebands)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.wavebands!= null)&&(!that.wavebands.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Float leftRegionOfRegard;
            leftRegionOfRegard = this.getRegionOfRegard();
            Float rightRegionOfRegard;
            rightRegionOfRegard = that.getRegionOfRegard();
            if (this.regionOfRegard!= null) {
                if (that.regionOfRegard!= null) {
                    if (!leftRegionOfRegard.equals(rightRegionOfRegard)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.regionOfRegard!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            AstroSTCDescriptionType theSTCResourceProfile;
            theSTCResourceProfile = this.getSTCResourceProfile();
            if (this.stcResourceProfile!= null) {
                currentHashCode += theSTCResourceProfile.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SpatialCoverage theSpatial;
            theSpatial = this.getSpatial();
            if (this.spatial!= null) {
                currentHashCode += theSpatial.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theTemporals;
            theTemporals = (((this.temporals!= null)&&(!this.temporals.isEmpty()))?this.getTemporals():null);
            if ((this.temporals!= null)&&(!this.temporals.isEmpty())) {
                currentHashCode += theTemporals.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theSpectrals;
            theSpectrals = (((this.spectrals!= null)&&(!this.spectrals.isEmpty()))?this.getSpectrals():null);
            if ((this.spectrals!= null)&&(!this.spectrals.isEmpty())) {
                currentHashCode += theSpectrals.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ServiceReference theFootprint;
            theFootprint = this.getFootprint();
            if (this.footprint!= null) {
                currentHashCode += theFootprint.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Waveband> theWavebands;
            theWavebands = (((this.wavebands!= null)&&(!this.wavebands.isEmpty()))?this.getWavebands():null);
            if ((this.wavebands!= null)&&(!this.wavebands.isEmpty())) {
                currentHashCode += theWavebands.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Float theRegionOfRegard;
            theRegionOfRegard = this.getRegionOfRegard();
            if (this.regionOfRegard!= null) {
                currentHashCode += theRegionOfRegard.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            AstroSTCDescriptionType theSTCResourceProfile;
            theSTCResourceProfile = this.getSTCResourceProfile();
            strategy.appendField(locator, this, "stcResourceProfile", buffer, theSTCResourceProfile, (this.stcResourceProfile!= null));
        }
        {
            SpatialCoverage theSpatial;
            theSpatial = this.getSpatial();
            strategy.appendField(locator, this, "spatial", buffer, theSpatial, (this.spatial!= null));
        }
        {
            List<String> theTemporals;
            theTemporals = (((this.temporals!= null)&&(!this.temporals.isEmpty()))?this.getTemporals():null);
            strategy.appendField(locator, this, "temporals", buffer, theTemporals, ((this.temporals!= null)&&(!this.temporals.isEmpty())));
        }
        {
            List<String> theSpectrals;
            theSpectrals = (((this.spectrals!= null)&&(!this.spectrals.isEmpty()))?this.getSpectrals():null);
            strategy.appendField(locator, this, "spectrals", buffer, theSpectrals, ((this.spectrals!= null)&&(!this.spectrals.isEmpty())));
        }
        {
            ServiceReference theFootprint;
            theFootprint = this.getFootprint();
            strategy.appendField(locator, this, "footprint", buffer, theFootprint, (this.footprint!= null));
        }
        {
            List<Waveband> theWavebands;
            theWavebands = (((this.wavebands!= null)&&(!this.wavebands.isEmpty()))?this.getWavebands():null);
            strategy.appendField(locator, this, "wavebands", buffer, theWavebands, ((this.wavebands!= null)&&(!this.wavebands.isEmpty())));
        }
        {
            Float theRegionOfRegard;
            theRegionOfRegard = this.getRegionOfRegard();
            strategy.appendField(locator, this, "regionOfRegard", buffer, theRegionOfRegard, (this.regionOfRegard!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Coverage) {
            final Coverage target = this;
            final Coverage leftObject = ((Coverage) left);
            final Coverage rightObject = ((Coverage) right);
            {
                Boolean stcResourceProfileShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.stcResourceProfile!= null), (rightObject.stcResourceProfile!= null));
                if (stcResourceProfileShouldBeMergedAndSet == Boolean.TRUE) {
                    AstroSTCDescriptionType lhsSTCResourceProfile;
                    lhsSTCResourceProfile = leftObject.getSTCResourceProfile();
                    AstroSTCDescriptionType rhsSTCResourceProfile;
                    rhsSTCResourceProfile = rightObject.getSTCResourceProfile();
                    AstroSTCDescriptionType mergedSTCResourceProfile = ((AstroSTCDescriptionType) strategy.merge(LocatorUtils.property(leftLocator, "stcResourceProfile", lhsSTCResourceProfile), LocatorUtils.property(rightLocator, "stcResourceProfile", rhsSTCResourceProfile), lhsSTCResourceProfile, rhsSTCResourceProfile, (leftObject.stcResourceProfile!= null), (rightObject.stcResourceProfile!= null)));
                    target.setSTCResourceProfile(mergedSTCResourceProfile);
                } else {
                    if (stcResourceProfileShouldBeMergedAndSet == Boolean.FALSE) {
                        target.stcResourceProfile = null;
                    }
                }
            }
            {
                Boolean spatialShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.spatial!= null), (rightObject.spatial!= null));
                if (spatialShouldBeMergedAndSet == Boolean.TRUE) {
                    SpatialCoverage lhsSpatial;
                    lhsSpatial = leftObject.getSpatial();
                    SpatialCoverage rhsSpatial;
                    rhsSpatial = rightObject.getSpatial();
                    SpatialCoverage mergedSpatial = ((SpatialCoverage) strategy.merge(LocatorUtils.property(leftLocator, "spatial", lhsSpatial), LocatorUtils.property(rightLocator, "spatial", rhsSpatial), lhsSpatial, rhsSpatial, (leftObject.spatial!= null), (rightObject.spatial!= null)));
                    target.setSpatial(mergedSpatial);
                } else {
                    if (spatialShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spatial = null;
                    }
                }
            }
            {
                Boolean temporalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.temporals!= null)&&(!leftObject.temporals.isEmpty())), ((rightObject.temporals!= null)&&(!rightObject.temporals.isEmpty())));
                if (temporalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsTemporals;
                    lhsTemporals = (((leftObject.temporals!= null)&&(!leftObject.temporals.isEmpty()))?leftObject.getTemporals():null);
                    List<String> rhsTemporals;
                    rhsTemporals = (((rightObject.temporals!= null)&&(!rightObject.temporals.isEmpty()))?rightObject.getTemporals():null);
                    List<String> mergedTemporals = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "temporals", lhsTemporals), LocatorUtils.property(rightLocator, "temporals", rhsTemporals), lhsTemporals, rhsTemporals, ((leftObject.temporals!= null)&&(!leftObject.temporals.isEmpty())), ((rightObject.temporals!= null)&&(!rightObject.temporals.isEmpty()))));
                    target.temporals = null;
                    if (mergedTemporals!= null) {
                        List<String> uniqueTemporalsl = target.getTemporals();
                        uniqueTemporalsl.addAll(mergedTemporals);
                    }
                } else {
                    if (temporalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.temporals = null;
                    }
                }
            }
            {
                Boolean spectralsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.spectrals!= null)&&(!leftObject.spectrals.isEmpty())), ((rightObject.spectrals!= null)&&(!rightObject.spectrals.isEmpty())));
                if (spectralsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsSpectrals;
                    lhsSpectrals = (((leftObject.spectrals!= null)&&(!leftObject.spectrals.isEmpty()))?leftObject.getSpectrals():null);
                    List<String> rhsSpectrals;
                    rhsSpectrals = (((rightObject.spectrals!= null)&&(!rightObject.spectrals.isEmpty()))?rightObject.getSpectrals():null);
                    List<String> mergedSpectrals = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "spectrals", lhsSpectrals), LocatorUtils.property(rightLocator, "spectrals", rhsSpectrals), lhsSpectrals, rhsSpectrals, ((leftObject.spectrals!= null)&&(!leftObject.spectrals.isEmpty())), ((rightObject.spectrals!= null)&&(!rightObject.spectrals.isEmpty()))));
                    target.spectrals = null;
                    if (mergedSpectrals!= null) {
                        List<String> uniqueSpectralsl = target.getSpectrals();
                        uniqueSpectralsl.addAll(mergedSpectrals);
                    }
                } else {
                    if (spectralsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spectrals = null;
                    }
                }
            }
            {
                Boolean footprintShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.footprint!= null), (rightObject.footprint!= null));
                if (footprintShouldBeMergedAndSet == Boolean.TRUE) {
                    ServiceReference lhsFootprint;
                    lhsFootprint = leftObject.getFootprint();
                    ServiceReference rhsFootprint;
                    rhsFootprint = rightObject.getFootprint();
                    ServiceReference mergedFootprint = ((ServiceReference) strategy.merge(LocatorUtils.property(leftLocator, "footprint", lhsFootprint), LocatorUtils.property(rightLocator, "footprint", rhsFootprint), lhsFootprint, rhsFootprint, (leftObject.footprint!= null), (rightObject.footprint!= null)));
                    target.setFootprint(mergedFootprint);
                } else {
                    if (footprintShouldBeMergedAndSet == Boolean.FALSE) {
                        target.footprint = null;
                    }
                }
            }
            {
                Boolean wavebandsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.wavebands!= null)&&(!leftObject.wavebands.isEmpty())), ((rightObject.wavebands!= null)&&(!rightObject.wavebands.isEmpty())));
                if (wavebandsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Waveband> lhsWavebands;
                    lhsWavebands = (((leftObject.wavebands!= null)&&(!leftObject.wavebands.isEmpty()))?leftObject.getWavebands():null);
                    List<Waveband> rhsWavebands;
                    rhsWavebands = (((rightObject.wavebands!= null)&&(!rightObject.wavebands.isEmpty()))?rightObject.getWavebands():null);
                    List<Waveband> mergedWavebands = ((List<Waveband> ) strategy.merge(LocatorUtils.property(leftLocator, "wavebands", lhsWavebands), LocatorUtils.property(rightLocator, "wavebands", rhsWavebands), lhsWavebands, rhsWavebands, ((leftObject.wavebands!= null)&&(!leftObject.wavebands.isEmpty())), ((rightObject.wavebands!= null)&&(!rightObject.wavebands.isEmpty()))));
                    target.wavebands = null;
                    if (mergedWavebands!= null) {
                        List<Waveband> uniqueWavebandsl = target.getWavebands();
                        uniqueWavebandsl.addAll(mergedWavebands);
                    }
                } else {
                    if (wavebandsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.wavebands = null;
                    }
                }
            }
            {
                Boolean regionOfRegardShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.regionOfRegard!= null), (rightObject.regionOfRegard!= null));
                if (regionOfRegardShouldBeMergedAndSet == Boolean.TRUE) {
                    Float lhsRegionOfRegard;
                    lhsRegionOfRegard = leftObject.getRegionOfRegard();
                    Float rhsRegionOfRegard;
                    rhsRegionOfRegard = rightObject.getRegionOfRegard();
                    Float mergedRegionOfRegard = ((Float) strategy.merge(LocatorUtils.property(leftLocator, "regionOfRegard", lhsRegionOfRegard), LocatorUtils.property(rightLocator, "regionOfRegard", rhsRegionOfRegard), lhsRegionOfRegard, rhsRegionOfRegard, (leftObject.regionOfRegard!= null), (rightObject.regionOfRegard!= null)));
                    target.setRegionOfRegard(mergedRegionOfRegard);
                } else {
                    if (regionOfRegardShouldBeMergedAndSet == Boolean.FALSE) {
                        target.regionOfRegard = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Coverage();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage clone() {
        final Coverage _newObject;
        try {
            _newObject = ((Coverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.clone());
        _newObject.spatial = ((this.spatial == null)?null:this.spatial.clone());
        _newObject.temporals = ((this.temporals == null)?null:new ArrayList<>(this.temporals));
        _newObject.spectrals = ((this.spectrals == null)?null:new ArrayList<>(this.spectrals));
        _newObject.footprint = ((this.footprint == null)?null:this.footprint.clone());
        _newObject.wavebands = ((this.wavebands == null)?null:new ArrayList<>(this.wavebands));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage createCopy() {
        final Coverage _newObject;
        try {
            _newObject = ((Coverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.createCopy());
        _newObject.spatial = ((this.spatial == null)?null:this.spatial.createCopy());
        _newObject.temporals = ((this.temporals == null)?null:new ArrayList<>(this.temporals));
        _newObject.spectrals = ((this.spectrals == null)?null:new ArrayList<>(this.spectrals));
        _newObject.footprint = ((this.footprint == null)?null:this.footprint.createCopy());
        _newObject.wavebands = ((this.wavebands == null)?null:new ArrayList<>(this.wavebands));
        _newObject.regionOfRegard = this.regionOfRegard;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Coverage _newObject;
        try {
            _newObject = ((Coverage) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree stcResourceProfilePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("stcResourceProfile"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(stcResourceProfilePropertyTree!= null):((stcResourceProfilePropertyTree == null)||(!stcResourceProfilePropertyTree.isLeaf())))) {
            _newObject.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.createCopy(stcResourceProfilePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spatialPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spatial"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spatialPropertyTree!= null):((spatialPropertyTree == null)||(!spatialPropertyTree.isLeaf())))) {
            _newObject.spatial = ((this.spatial == null)?null:this.spatial.createCopy(spatialPropertyTree, _propertyTreeUse));
        }
        final PropertyTree temporalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("temporals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(temporalsPropertyTree!= null):((temporalsPropertyTree == null)||(!temporalsPropertyTree.isLeaf())))) {
            _newObject.temporals = ((this.temporals == null)?null:new ArrayList<>(this.temporals));
        }
        final PropertyTree spectralsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectrals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralsPropertyTree!= null):((spectralsPropertyTree == null)||(!spectralsPropertyTree.isLeaf())))) {
            _newObject.spectrals = ((this.spectrals == null)?null:new ArrayList<>(this.spectrals));
        }
        final PropertyTree footprintPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("footprint"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(footprintPropertyTree!= null):((footprintPropertyTree == null)||(!footprintPropertyTree.isLeaf())))) {
            _newObject.footprint = ((this.footprint == null)?null:this.footprint.createCopy(footprintPropertyTree, _propertyTreeUse));
        }
        final PropertyTree wavebandsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("wavebands"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(wavebandsPropertyTree!= null):((wavebandsPropertyTree == null)||(!wavebandsPropertyTree.isLeaf())))) {
            _newObject.wavebands = ((this.wavebands == null)?null:new ArrayList<>(this.wavebands));
        }
        final PropertyTree regionOfRegardPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regionOfRegard"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionOfRegardPropertyTree!= null):((regionOfRegardPropertyTree == null)||(!regionOfRegardPropertyTree.isLeaf())))) {
            _newObject.regionOfRegard = this.regionOfRegard;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Coverage.Modifier();
        }
        return ((Coverage.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Coverage.Builder<_B> _other) {
        _other.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.newCopyBuilder(_other));
        _other.spatial = ((this.spatial == null)?null:this.spatial.newCopyBuilder(_other));
        if (this.temporals == null) {
            _other.temporals = null;
        } else {
            _other.temporals = new ArrayList<>();
            for (String _item: this.temporals) {
                _other.temporals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        if (this.spectrals == null) {
            _other.spectrals = null;
        } else {
            _other.spectrals = new ArrayList<>();
            for (String _item: this.spectrals) {
                _other.spectrals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.footprint = ((this.footprint == null)?null:this.footprint.newCopyBuilder(_other));
        if (this.wavebands == null) {
            _other.wavebands = null;
        } else {
            _other.wavebands = new ArrayList<>();
            for (Waveband _item: this.wavebands) {
                _other.wavebands.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.regionOfRegard = this.regionOfRegard;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Coverage.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Coverage.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Coverage.Builder<Void> builder() {
        return new Coverage.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Coverage.Builder<_B> copyOf(final Coverage _other) {
        final Coverage.Builder<_B> _newBuilder = new Coverage.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Coverage.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree stcResourceProfilePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("stcResourceProfile"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(stcResourceProfilePropertyTree!= null):((stcResourceProfilePropertyTree == null)||(!stcResourceProfilePropertyTree.isLeaf())))) {
            _other.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.newCopyBuilder(_other, stcResourceProfilePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spatialPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spatial"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spatialPropertyTree!= null):((spatialPropertyTree == null)||(!spatialPropertyTree.isLeaf())))) {
            _other.spatial = ((this.spatial == null)?null:this.spatial.newCopyBuilder(_other, spatialPropertyTree, _propertyTreeUse));
        }
        final PropertyTree temporalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("temporals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(temporalsPropertyTree!= null):((temporalsPropertyTree == null)||(!temporalsPropertyTree.isLeaf())))) {
            if (this.temporals == null) {
                _other.temporals = null;
            } else {
                _other.temporals = new ArrayList<>();
                for (String _item: this.temporals) {
                    _other.temporals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree spectralsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectrals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralsPropertyTree!= null):((spectralsPropertyTree == null)||(!spectralsPropertyTree.isLeaf())))) {
            if (this.spectrals == null) {
                _other.spectrals = null;
            } else {
                _other.spectrals = new ArrayList<>();
                for (String _item: this.spectrals) {
                    _other.spectrals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree footprintPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("footprint"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(footprintPropertyTree!= null):((footprintPropertyTree == null)||(!footprintPropertyTree.isLeaf())))) {
            _other.footprint = ((this.footprint == null)?null:this.footprint.newCopyBuilder(_other, footprintPropertyTree, _propertyTreeUse));
        }
        final PropertyTree wavebandsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("wavebands"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(wavebandsPropertyTree!= null):((wavebandsPropertyTree == null)||(!wavebandsPropertyTree.isLeaf())))) {
            if (this.wavebands == null) {
                _other.wavebands = null;
            } else {
                _other.wavebands = new ArrayList<>();
                for (Waveband _item: this.wavebands) {
                    _other.wavebands.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree regionOfRegardPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regionOfRegard"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionOfRegardPropertyTree!= null):((regionOfRegardPropertyTree == null)||(!regionOfRegardPropertyTree.isLeaf())))) {
            _other.regionOfRegard = this.regionOfRegard;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Coverage.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Coverage.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Coverage.Builder<_B> copyOf(final Coverage _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Coverage.Builder<_B> _newBuilder = new Coverage.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Coverage.Builder<Void> copyExcept(final Coverage _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Coverage.Builder<Void> copyOnly(final Coverage _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Coverage visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new SingleProperty<>(Coverage.PropInfo.STC_RESOURCE_PROFILE, this))&&(this.stcResourceProfile!= null)) {
            this.stcResourceProfile.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Coverage.PropInfo.SPATIAL, this))&&(this.spatial!= null)) {
            this.spatial.visit(_visitor_);
        }
        _visitor_.visit(new CollectionProperty<>(Coverage.PropInfo.TEMPORALS, this));
        _visitor_.visit(new CollectionProperty<>(Coverage.PropInfo.SPECTRALS, this));
        if (_visitor_.visit(new SingleProperty<>(Coverage.PropInfo.FOOTPRINT, this))&&(this.footprint!= null)) {
            this.footprint.visit(_visitor_);
        }
        _visitor_.visit(new CollectionProperty<>(Coverage.PropInfo.WAVEBANDS, this));
        _visitor_.visit(new SingleProperty<>(Coverage.PropInfo.REGION_OF_REGARD, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Coverage _storedValue;
        private AstroSTCDescriptionType.Builder<Coverage.Builder<_B>> stcResourceProfile;
        private SpatialCoverage.Builder<Coverage.Builder<_B>> spatial;
        private List<Buildable> temporals;
        private List<Buildable> spectrals;
        private ServiceReference.Builder<Coverage.Builder<_B>> footprint;
        private List<Buildable> wavebands;
        private Float regionOfRegard;

        public Builder(final _B _parentBuilder, final Coverage _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.stcResourceProfile = ((_other.stcResourceProfile == null)?null:_other.stcResourceProfile.newCopyBuilder(this));
                    this.spatial = ((_other.spatial == null)?null:_other.spatial.newCopyBuilder(this));
                    if (_other.temporals == null) {
                        this.temporals = null;
                    } else {
                        this.temporals = new ArrayList<>();
                        for (String _item: _other.temporals) {
                            this.temporals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    if (_other.spectrals == null) {
                        this.spectrals = null;
                    } else {
                        this.spectrals = new ArrayList<>();
                        for (String _item: _other.spectrals) {
                            this.spectrals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.footprint = ((_other.footprint == null)?null:_other.footprint.newCopyBuilder(this));
                    if (_other.wavebands == null) {
                        this.wavebands = null;
                    } else {
                        this.wavebands = new ArrayList<>();
                        for (Waveband _item: _other.wavebands) {
                            this.wavebands.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.regionOfRegard = _other.regionOfRegard;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Coverage _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree stcResourceProfilePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("stcResourceProfile"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(stcResourceProfilePropertyTree!= null):((stcResourceProfilePropertyTree == null)||(!stcResourceProfilePropertyTree.isLeaf())))) {
                        this.stcResourceProfile = ((_other.stcResourceProfile == null)?null:_other.stcResourceProfile.newCopyBuilder(this, stcResourceProfilePropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree spatialPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spatial"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spatialPropertyTree!= null):((spatialPropertyTree == null)||(!spatialPropertyTree.isLeaf())))) {
                        this.spatial = ((_other.spatial == null)?null:_other.spatial.newCopyBuilder(this, spatialPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree temporalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("temporals"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(temporalsPropertyTree!= null):((temporalsPropertyTree == null)||(!temporalsPropertyTree.isLeaf())))) {
                        if (_other.temporals == null) {
                            this.temporals = null;
                        } else {
                            this.temporals = new ArrayList<>();
                            for (String _item: _other.temporals) {
                                this.temporals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree spectralsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectrals"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralsPropertyTree!= null):((spectralsPropertyTree == null)||(!spectralsPropertyTree.isLeaf())))) {
                        if (_other.spectrals == null) {
                            this.spectrals = null;
                        } else {
                            this.spectrals = new ArrayList<>();
                            for (String _item: _other.spectrals) {
                                this.spectrals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree footprintPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("footprint"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(footprintPropertyTree!= null):((footprintPropertyTree == null)||(!footprintPropertyTree.isLeaf())))) {
                        this.footprint = ((_other.footprint == null)?null:_other.footprint.newCopyBuilder(this, footprintPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree wavebandsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("wavebands"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(wavebandsPropertyTree!= null):((wavebandsPropertyTree == null)||(!wavebandsPropertyTree.isLeaf())))) {
                        if (_other.wavebands == null) {
                            this.wavebands = null;
                        } else {
                            this.wavebands = new ArrayList<>();
                            for (Waveband _item: _other.wavebands) {
                                this.wavebands.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree regionOfRegardPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("regionOfRegard"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(regionOfRegardPropertyTree!= null):((regionOfRegardPropertyTree == null)||(!regionOfRegardPropertyTree.isLeaf())))) {
                        this.regionOfRegard = _other.regionOfRegard;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Coverage >_P init(final _P _product) {
            _product.stcResourceProfile = ((this.stcResourceProfile == null)?null:this.stcResourceProfile.build());
            _product.spatial = ((this.spatial == null)?null:this.spatial.build());
            if (this.temporals!= null) {
                final List<String> temporals = new ArrayList<>(this.temporals.size());
                for (Buildable _item: this.temporals) {
                    temporals.add(((String) _item.build()));
                }
                _product.temporals = temporals;
            }
            if (this.spectrals!= null) {
                final List<String> spectrals = new ArrayList<>(this.spectrals.size());
                for (Buildable _item: this.spectrals) {
                    spectrals.add(((String) _item.build()));
                }
                _product.spectrals = spectrals;
            }
            _product.footprint = ((this.footprint == null)?null:this.footprint.build());
            if (this.wavebands!= null) {
                final List<Waveband> wavebands = new ArrayList<>(this.wavebands.size());
                for (Buildable _item: this.wavebands) {
                    wavebands.add(((Waveband) _item.build()));
                }
                _product.wavebands = wavebands;
            }
            _product.regionOfRegard = this.regionOfRegard;
            return _product;
        }

        /**
         * Sets the new value of "stcResourceProfile" (any previous value will be replaced)
         * 
         * @param stcResourceProfile
         *     New value of the "stcResourceProfile" property.
         */
        public Coverage.Builder<_B> withSTCResourceProfile(final AstroSTCDescriptionType stcResourceProfile) {
            this.stcResourceProfile = ((stcResourceProfile == null)?null:new AstroSTCDescriptionType.Builder<>(this, stcResourceProfile, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "stcResourceProfile" property.
         * Use {@link
         * org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "stcResourceProfile" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.stc.v1.AstroSTCDescriptionType.Builder#end()} to
         *     return to the current builder.
         */
        public AstroSTCDescriptionType.Builder<? extends Coverage.Builder<_B>> withSTCResourceProfile() {
            if (this.stcResourceProfile!= null) {
                return this.stcResourceProfile;
            }
            return this.stcResourceProfile = new AstroSTCDescriptionType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "spatial" (any previous value will be replaced)
         * 
         * @param spatial
         *     New value of the "spatial" property.
         */
        public Coverage.Builder<_B> withSpatial(final SpatialCoverage spatial) {
            this.spatial = ((spatial == null)?null:new SpatialCoverage.Builder<>(this, spatial, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "spatial" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.SpatialCoverage.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "spatial" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.SpatialCoverage.Builder#end()}
         *     to return to the current builder.
         */
        public SpatialCoverage.Builder<? extends Coverage.Builder<_B>> withSpatial() {
            if (this.spatial!= null) {
                return this.spatial;
            }
            return this.spatial = new SpatialCoverage.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "temporals"
         * 
         * @param temporals
         *     Items to add to the value of the "temporals" property
         */
        public Coverage.Builder<_B> addTemporals(final Iterable<? extends String> temporals) {
            if (temporals!= null) {
                if (this.temporals == null) {
                    this.temporals = new ArrayList<>();
                }
                for (String _item: temporals) {
                    this.temporals.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "temporals" (any previous value will be replaced)
         * 
         * @param temporals
         *     New value of the "temporals" property.
         */
        public Coverage.Builder<_B> withTemporals(final Iterable<? extends String> temporals) {
            if (this.temporals!= null) {
                this.temporals.clear();
            }
            return addTemporals(temporals);
        }

        /**
         * Adds the given items to the value of "temporals"
         * 
         * @param temporals
         *     Items to add to the value of the "temporals" property
         */
        public Coverage.Builder<_B> addTemporals(String... temporals) {
            addTemporals(Arrays.asList(temporals));
            return this;
        }

        /**
         * Sets the new value of "temporals" (any previous value will be replaced)
         * 
         * @param temporals
         *     New value of the "temporals" property.
         */
        public Coverage.Builder<_B> withTemporals(String... temporals) {
            withTemporals(Arrays.asList(temporals));
            return this;
        }

        /**
         * Adds the given items to the value of "spectrals"
         * 
         * @param spectrals
         *     Items to add to the value of the "spectrals" property
         */
        public Coverage.Builder<_B> addSpectrals(final Iterable<? extends String> spectrals) {
            if (spectrals!= null) {
                if (this.spectrals == null) {
                    this.spectrals = new ArrayList<>();
                }
                for (String _item: spectrals) {
                    this.spectrals.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "spectrals" (any previous value will be replaced)
         * 
         * @param spectrals
         *     New value of the "spectrals" property.
         */
        public Coverage.Builder<_B> withSpectrals(final Iterable<? extends String> spectrals) {
            if (this.spectrals!= null) {
                this.spectrals.clear();
            }
            return addSpectrals(spectrals);
        }

        /**
         * Adds the given items to the value of "spectrals"
         * 
         * @param spectrals
         *     Items to add to the value of the "spectrals" property
         */
        public Coverage.Builder<_B> addSpectrals(String... spectrals) {
            addSpectrals(Arrays.asList(spectrals));
            return this;
        }

        /**
         * Sets the new value of "spectrals" (any previous value will be replaced)
         * 
         * @param spectrals
         *     New value of the "spectrals" property.
         */
        public Coverage.Builder<_B> withSpectrals(String... spectrals) {
            withSpectrals(Arrays.asList(spectrals));
            return this;
        }

        /**
         * Sets the new value of "footprint" (any previous value will be replaced)
         * 
         * @param footprint
         *     New value of the "footprint" property.
         */
        public Coverage.Builder<_B> withFootprint(final ServiceReference footprint) {
            this.footprint = ((footprint == null)?null:new ServiceReference.Builder<>(this, footprint, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "footprint" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.ServiceReference.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "footprint" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.ServiceReference.Builder#end()}
         *     to return to the current builder.
         */
        public ServiceReference.Builder<? extends Coverage.Builder<_B>> withFootprint() {
            if (this.footprint!= null) {
                return this.footprint;
            }
            return this.footprint = new ServiceReference.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "wavebands"
         * 
         * @param wavebands
         *     Items to add to the value of the "wavebands" property
         */
        public Coverage.Builder<_B> addWavebands(final Iterable<? extends Waveband> wavebands) {
            if (wavebands!= null) {
                if (this.wavebands == null) {
                    this.wavebands = new ArrayList<>();
                }
                for (Waveband _item: wavebands) {
                    this.wavebands.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "wavebands" (any previous value will be replaced)
         * 
         * @param wavebands
         *     New value of the "wavebands" property.
         */
        public Coverage.Builder<_B> withWavebands(final Iterable<? extends Waveband> wavebands) {
            if (this.wavebands!= null) {
                this.wavebands.clear();
            }
            return addWavebands(wavebands);
        }

        /**
         * Adds the given items to the value of "wavebands"
         * 
         * @param wavebands
         *     Items to add to the value of the "wavebands" property
         */
        public Coverage.Builder<_B> addWavebands(Waveband... wavebands) {
            addWavebands(Arrays.asList(wavebands));
            return this;
        }

        /**
         * Sets the new value of "wavebands" (any previous value will be replaced)
         * 
         * @param wavebands
         *     New value of the "wavebands" property.
         */
        public Coverage.Builder<_B> withWavebands(Waveband... wavebands) {
            withWavebands(Arrays.asList(wavebands));
            return this;
        }

        /**
         * Sets the new value of "regionOfRegard" (any previous value will be replaced)
         * 
         * @param regionOfRegard
         *     New value of the "regionOfRegard" property.
         */
        public Coverage.Builder<_B> withRegionOfRegard(final Float regionOfRegard) {
            this.regionOfRegard = regionOfRegard;
            return this;
        }

        @Override
        public Coverage build() {
            if (_storedValue == null) {
                return this.init(new Coverage());
            } else {
                return ((Coverage) _storedValue);
            }
        }

        public Coverage.Builder<_B> copyOf(final Coverage _other) {
            _other.copyTo(this);
            return this;
        }

        public Coverage.Builder<_B> copyOf(final Coverage.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setSTCResourceProfile(final AstroSTCDescriptionType stcResourceProfile) {
            Coverage.this.setSTCResourceProfile(stcResourceProfile);
        }

        public void setSpatial(final SpatialCoverage spatial) {
            Coverage.this.setSpatial(spatial);
        }

        public List<String> getTemporals() {
            if (Coverage.this.temporals == null) {
                Coverage.this.temporals = new ArrayList<>();
            }
            return Coverage.this.temporals;
        }

        public List<String> getSpectrals() {
            if (Coverage.this.spectrals == null) {
                Coverage.this.spectrals = new ArrayList<>();
            }
            return Coverage.this.spectrals;
        }

        public void setFootprint(final ServiceReference footprint) {
            Coverage.this.setFootprint(footprint);
        }

        public List<Waveband> getWavebands() {
            if (Coverage.this.wavebands == null) {
                Coverage.this.wavebands = new ArrayList<>();
            }
            return Coverage.this.wavebands;
        }

        public void setRegionOfRegard(final Float regionOfRegard) {
            Coverage.this.setRegionOfRegard(regionOfRegard);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Coverage, AstroSTCDescriptionType> STC_RESOURCE_PROFILE = new SinglePropertyInfo<Coverage,AstroSTCDescriptionType>("stcResourceProfile", Coverage.class, AstroSTCDescriptionType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "STCResourceProfile"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "astroSTCDescriptionType"), false) {


            @Override
            public AstroSTCDescriptionType get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.stcResourceProfile);
            }

            @Override
            public void set(final Coverage _instance_, final AstroSTCDescriptionType _value_) {
                if (_instance_!= null) {
                    _instance_.stcResourceProfile = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Coverage, SpatialCoverage> SPATIAL = new SinglePropertyInfo<Coverage,SpatialCoverage>("spatial", Coverage.class, SpatialCoverage.class, false, null, new QName("", "spatial"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "SpatialCoverage"), false) {


            @Override
            public SpatialCoverage get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.spatial);
            }

            @Override
            public void set(final Coverage _instance_, final SpatialCoverage _value_) {
                if (_instance_!= null) {
                    _instance_.spatial = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Coverage, String> TEMPORALS = new CollectionPropertyInfo<Coverage,String>("temporals", Coverage.class, String.class, true, null, new QName("", "temporal"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "FloatInterval"), false) {


            @Override
            public List<String> get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.temporals);
            }

            @Override
            public void set(final Coverage _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.temporals = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Coverage, String> SPECTRALS = new CollectionPropertyInfo<Coverage,String>("spectrals", Coverage.class, String.class, true, null, new QName("", "spectral"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "FloatInterval"), false) {


            @Override
            public List<String> get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.spectrals);
            }

            @Override
            public void set(final Coverage _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.spectrals = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Coverage, ServiceReference> FOOTPRINT = new SinglePropertyInfo<Coverage,ServiceReference>("footprint", Coverage.class, ServiceReference.class, false, null, new QName("", "footprint"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "ServiceReference"), false) {


            @Override
            public ServiceReference get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.footprint);
            }

            @Override
            public void set(final Coverage _instance_, final ServiceReference _value_) {
                if (_instance_!= null) {
                    _instance_.footprint = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Coverage, Waveband> WAVEBANDS = new CollectionPropertyInfo<Coverage,Waveband>("wavebands", Coverage.class, Waveband.class, true, null, new QName("", "waveband"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Waveband"), false) {


            @Override
            public List<Waveband> get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.wavebands);
            }

            @Override
            public void set(final Coverage _instance_, final List<Waveband> _value_) {
                if (_instance_!= null) {
                    _instance_.wavebands = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Coverage, Float> REGION_OF_REGARD = new SinglePropertyInfo<Coverage,Float>("regionOfRegard", Coverage.class, Float.class, false, null, new QName("", "regionOfRegard"), new QName("http://www.w3.org/2001/XMLSchema", "float"), false) {


            @Override
            public Float get(final Coverage _instance_) {
                return ((_instance_ == null)?null:_instance_.regionOfRegard);
            }

            @Override
            public void set(final Coverage _instance_, final Float _value_) {
                if (_instance_!= null) {
                    _instance_.regionOfRegard = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Coverage.Selector<Coverage.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Coverage.Select _root() {
            return new Coverage.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private AstroSTCDescriptionType.Selector<TRoot, Coverage.Selector<TRoot, TParent>> stcResourceProfile = null;
        private SpatialCoverage.Selector<TRoot, Coverage.Selector<TRoot, TParent>> spatial = null;
        private com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> temporals = null;
        private com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> spectrals = null;
        private ServiceReference.Selector<TRoot, Coverage.Selector<TRoot, TParent>> footprint = null;
        private com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> wavebands = null;
        private com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> regionOfRegard = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.stcResourceProfile!= null) {
                products.put("stcResourceProfile", this.stcResourceProfile.init());
            }
            if (this.spatial!= null) {
                products.put("spatial", this.spatial.init());
            }
            if (this.temporals!= null) {
                products.put("temporals", this.temporals.init());
            }
            if (this.spectrals!= null) {
                products.put("spectrals", this.spectrals.init());
            }
            if (this.footprint!= null) {
                products.put("footprint", this.footprint.init());
            }
            if (this.wavebands!= null) {
                products.put("wavebands", this.wavebands.init());
            }
            if (this.regionOfRegard!= null) {
                products.put("regionOfRegard", this.regionOfRegard.init());
            }
            return products;
        }

        public AstroSTCDescriptionType.Selector<TRoot, Coverage.Selector<TRoot, TParent>> stcResourceProfile() {
            return ((this.stcResourceProfile == null)?this.stcResourceProfile = new AstroSTCDescriptionType.Selector<>(this._root, this, "stcResourceProfile"):this.stcResourceProfile);
        }

        public SpatialCoverage.Selector<TRoot, Coverage.Selector<TRoot, TParent>> spatial() {
            return ((this.spatial == null)?this.spatial = new SpatialCoverage.Selector<>(this._root, this, "spatial"):this.spatial);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> temporals() {
            return ((this.temporals == null)?this.temporals = new com.kscs.util.jaxb.Selector<>(this._root, this, "temporals"):this.temporals);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> spectrals() {
            return ((this.spectrals == null)?this.spectrals = new com.kscs.util.jaxb.Selector<>(this._root, this, "spectrals"):this.spectrals);
        }

        public ServiceReference.Selector<TRoot, Coverage.Selector<TRoot, TParent>> footprint() {
            return ((this.footprint == null)?this.footprint = new ServiceReference.Selector<>(this._root, this, "footprint"):this.footprint);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> wavebands() {
            return ((this.wavebands == null)?this.wavebands = new com.kscs.util.jaxb.Selector<>(this._root, this, "wavebands"):this.wavebands);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Coverage.Selector<TRoot, TParent>> regionOfRegard() {
            return ((this.regionOfRegard == null)?this.regionOfRegard = new com.kscs.util.jaxb.Selector<>(this._root, this, "regionOfRegard"):this.regionOfRegard);
        }

    }

}
