
package org.javastro.ivoa.entities.resource.registry;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Rights;
import org.javastro.ivoa.entities.resource.Service;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A registry is considered a publishing registry if it
 *            contains a capability element with xsi:type="vg:Harvest".  
 *            It is considered a searchable registry if it contains a
 *            capability element with xsi:type="vg:Search".
 * 
 * <p>Java class for Registry complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Registry">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Service">
 *       <sequence>
 *         <element name="full" type="{http://www.w3.org/2001/XMLSchema}boolean"/>
 *         <element name="managedAuthority" type="{http://www.ivoa.net/xml/VOResource/v1.0}AuthorityID" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Registry", propOrder = {
    "full",
    "managedAuthorities"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Registry
    extends Service
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * A registry typically collects everything by harvesting 
     *                        from all registries listed in the IVOA Registry of 
     *                        Registries.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected boolean full;
    /**
     * Typically, this means the AuthorityIDs that originated 
     *                        (i.e. were first published by) this registry.  Currently,
     *                        only one registry can lay claim to an AuthorityID via
     *                        this element at a time.
     * 
     */
    @XmlElement(name = "managedAuthority")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<String> managedAuthorities;

    /**
     * Default no-arg constructor
     * 
     */
    public Registry() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Registry(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final ZonedDateTime created, final ZonedDateTime updated, final String status, final String version, final List<Rights> rights, final List<Capability> capabilities, final boolean full, final List<String> managedAuthorities) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version, rights, capabilities);
        this.full = full;
        this.managedAuthorities = managedAuthorities;
    }

    /**
     * A registry typically collects everything by harvesting 
     *                        from all registries listed in the IVOA Registry of 
     *                        Registries.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean isFull() {
        return full;
    }

    /**
     * Sets the value of the full property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setFull(boolean value) {
        this.full = value;
    }

    /**
     * Typically, this means the AuthorityIDs that originated 
     *                        (i.e. were first published by) this registry.  Currently,
     *                        only one registry can lay claim to an AuthorityID via
     *                        this element at a time.
     * 
     * Gets the value of the managedAuthorities property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the managedAuthorities property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getManagedAuthorities().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the managedAuthorities property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<String> getManagedAuthorities() {
        if (managedAuthorities == null) {
            managedAuthorities = new ArrayList<>();
        }
        return this.managedAuthorities;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Registry that = ((Registry) object);
        {
            boolean leftFull;
            leftFull = this.isFull();
            boolean rightFull;
            rightFull = that.isFull();
            if (leftFull!= rightFull) {
                return false;
            }
        }
        {
            List<String> leftManagedAuthorities;
            leftManagedAuthorities = (((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty()))?this.getManagedAuthorities():null);
            List<String> rightManagedAuthorities;
            rightManagedAuthorities = (((that.managedAuthorities!= null)&&(!that.managedAuthorities.isEmpty()))?that.getManagedAuthorities():null);
            if ((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty())) {
                if ((that.managedAuthorities!= null)&&(!that.managedAuthorities.isEmpty())) {
                    if (!leftManagedAuthorities.equals(rightManagedAuthorities)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.managedAuthorities!= null)&&(!that.managedAuthorities.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            boolean theFull;
            theFull = this.isFull();
            currentHashCode += (theFull? 1231 : 1237);
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theManagedAuthorities;
            theManagedAuthorities = (((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty()))?this.getManagedAuthorities():null);
            if ((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty())) {
                currentHashCode += theManagedAuthorities.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            boolean theFull;
            theFull = this.isFull();
            strategy.appendField(locator, this, "full", buffer, theFull, true);
        }
        {
            List<String> theManagedAuthorities;
            theManagedAuthorities = (((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty()))?this.getManagedAuthorities():null);
            strategy.appendField(locator, this, "managedAuthorities", buffer, theManagedAuthorities, ((this.managedAuthorities!= null)&&(!this.managedAuthorities.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Registry) {
            final Registry target = this;
            final Registry leftObject = ((Registry) left);
            final Registry rightObject = ((Registry) right);
            {
                Boolean fullShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (fullShouldBeMergedAndSet == Boolean.TRUE) {
                    boolean lhsFull;
                    lhsFull = leftObject.isFull();
                    boolean rhsFull;
                    rhsFull = rightObject.isFull();
                    boolean mergedFull = ((boolean) strategy.merge(LocatorUtils.property(leftLocator, "full", lhsFull), LocatorUtils.property(rightLocator, "full", rhsFull), lhsFull, rhsFull, true, true));
                    target.setFull(mergedFull);
                } else {
                    if (fullShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean managedAuthoritiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.managedAuthorities!= null)&&(!leftObject.managedAuthorities.isEmpty())), ((rightObject.managedAuthorities!= null)&&(!rightObject.managedAuthorities.isEmpty())));
                if (managedAuthoritiesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsManagedAuthorities;
                    lhsManagedAuthorities = (((leftObject.managedAuthorities!= null)&&(!leftObject.managedAuthorities.isEmpty()))?leftObject.getManagedAuthorities():null);
                    List<String> rhsManagedAuthorities;
                    rhsManagedAuthorities = (((rightObject.managedAuthorities!= null)&&(!rightObject.managedAuthorities.isEmpty()))?rightObject.getManagedAuthorities():null);
                    List<String> mergedManagedAuthorities = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "managedAuthorities", lhsManagedAuthorities), LocatorUtils.property(rightLocator, "managedAuthorities", rhsManagedAuthorities), lhsManagedAuthorities, rhsManagedAuthorities, ((leftObject.managedAuthorities!= null)&&(!leftObject.managedAuthorities.isEmpty())), ((rightObject.managedAuthorities!= null)&&(!rightObject.managedAuthorities.isEmpty()))));
                    target.managedAuthorities = null;
                    if (mergedManagedAuthorities!= null) {
                        List<String> uniqueManagedAuthoritiesl = target.getManagedAuthorities();
                        uniqueManagedAuthoritiesl.addAll(mergedManagedAuthorities);
                    }
                } else {
                    if (managedAuthoritiesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.managedAuthorities = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Registry();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry clone() {
        final Registry _newObject;
        _newObject = ((Registry) super.clone());
        _newObject.managedAuthorities = ((this.managedAuthorities == null)?null:new ArrayList<>(this.managedAuthorities));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry createCopy() {
        final Registry _newObject = ((Registry) super.createCopy());
        _newObject.full = this.full;
        _newObject.managedAuthorities = ((this.managedAuthorities == null)?null:new ArrayList<>(this.managedAuthorities));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Registry _newObject = ((Registry) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree fullPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("full"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fullPropertyTree!= null):((fullPropertyTree == null)||(!fullPropertyTree.isLeaf())))) {
            _newObject.full = this.full;
        }
        final PropertyTree managedAuthoritiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managedAuthorities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managedAuthoritiesPropertyTree!= null):((managedAuthoritiesPropertyTree == null)||(!managedAuthoritiesPropertyTree.isLeaf())))) {
            _newObject.managedAuthorities = ((this.managedAuthorities == null)?null:new ArrayList<>(this.managedAuthorities));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Registry.Modifier();
        }
        return ((Registry.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Registry.Builder<_B> _other) {
        super.copyTo(_other);
        _other.full = this.full;
        if (this.managedAuthorities == null) {
            _other.managedAuthorities = null;
        } else {
            _other.managedAuthorities = new ArrayList<>();
            for (String _item: this.managedAuthorities) {
                _other.managedAuthorities.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Registry.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Registry.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> builder() {
        return new Registry.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Resource _other) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Service _other) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Registry _other) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Registry.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree fullPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("full"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fullPropertyTree!= null):((fullPropertyTree == null)||(!fullPropertyTree.isLeaf())))) {
            _other.full = this.full;
        }
        final PropertyTree managedAuthoritiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managedAuthorities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managedAuthoritiesPropertyTree!= null):((managedAuthoritiesPropertyTree == null)||(!managedAuthoritiesPropertyTree.isLeaf())))) {
            if (this.managedAuthorities == null) {
                _other.managedAuthorities = null;
            } else {
                _other.managedAuthorities = new ArrayList<>();
                for (String _item: this.managedAuthorities) {
                    _other.managedAuthorities.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Registry.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Registry.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Service _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Registry.Builder<_B> copyOf(final Registry _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Registry.Builder<_B> _newBuilder = new Registry.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyExcept(final Service _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyExcept(final Registry _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyOnly(final Service _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Registry.Builder<Void> copyOnly(final Registry _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Registry visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(Registry.PropInfo.FULL, this));
        _visitor_.visit(new CollectionProperty<>(Registry.PropInfo.MANAGED_AUTHORITIES, this));
        return this;
    }

    public static class Builder<_B >
        extends Service.Builder<_B>
        implements Buildable
    {

        private boolean full;
        private List<Buildable> managedAuthorities;

        public Builder(final _B _parentBuilder, final Registry _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.full = _other.full;
                if (_other.managedAuthorities == null) {
                    this.managedAuthorities = null;
                } else {
                    this.managedAuthorities = new ArrayList<>();
                    for (String _item: _other.managedAuthorities) {
                        this.managedAuthorities.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final Registry _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree fullPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("full"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(fullPropertyTree!= null):((fullPropertyTree == null)||(!fullPropertyTree.isLeaf())))) {
                    this.full = _other.full;
                }
                final PropertyTree managedAuthoritiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managedAuthorities"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managedAuthoritiesPropertyTree!= null):((managedAuthoritiesPropertyTree == null)||(!managedAuthoritiesPropertyTree.isLeaf())))) {
                    if (_other.managedAuthorities == null) {
                        this.managedAuthorities = null;
                    } else {
                        this.managedAuthorities = new ArrayList<>();
                        for (String _item: _other.managedAuthorities) {
                            this.managedAuthorities.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
            }
        }

        protected<_P extends Registry >_P init(final _P _product) {
            _product.full = this.full;
            if (this.managedAuthorities!= null) {
                final List<String> managedAuthorities = new ArrayList<>(this.managedAuthorities.size());
                for (Buildable _item: this.managedAuthorities) {
                    managedAuthorities.add(((String) _item.build()));
                }
                _product.managedAuthorities = managedAuthorities;
            }
            return super.init(_product);
        }

        /**
         * Sets the new value of "full" (any previous value will be replaced)
         * 
         * @param full
         *     New value of the "full" property.
         */
        public Registry.Builder<_B> withFull(final boolean full) {
            this.full = full;
            return this;
        }

        /**
         * Adds the given items to the value of "managedAuthorities"
         * 
         * @param managedAuthorities
         *     Items to add to the value of the "managedAuthorities" property
         */
        public Registry.Builder<_B> addManagedAuthorities(final Iterable<? extends String> managedAuthorities) {
            if (managedAuthorities!= null) {
                if (this.managedAuthorities == null) {
                    this.managedAuthorities = new ArrayList<>();
                }
                for (String _item: managedAuthorities) {
                    this.managedAuthorities.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "managedAuthorities" (any previous value will be replaced)
         * 
         * @param managedAuthorities
         *     New value of the "managedAuthorities" property.
         */
        public Registry.Builder<_B> withManagedAuthorities(final Iterable<? extends String> managedAuthorities) {
            if (this.managedAuthorities!= null) {
                this.managedAuthorities.clear();
            }
            return addManagedAuthorities(managedAuthorities);
        }

        /**
         * Adds the given items to the value of "managedAuthorities"
         * 
         * @param managedAuthorities
         *     Items to add to the value of the "managedAuthorities" property
         */
        public Registry.Builder<_B> addManagedAuthorities(String... managedAuthorities) {
            addManagedAuthorities(Arrays.asList(managedAuthorities));
            return this;
        }

        /**
         * Sets the new value of "managedAuthorities" (any previous value will be replaced)
         * 
         * @param managedAuthorities
         *     New value of the "managedAuthorities" property.
         */
        public Registry.Builder<_B> withManagedAuthorities(String... managedAuthorities) {
            withManagedAuthorities(Arrays.asList(managedAuthorities));
            return this;
        }

        /**
         * Adds the given items to the value of "rights"
         * 
         * @param rights
         *     Items to add to the value of the "rights" property
         */
        @Override
        public Registry.Builder<_B> addRights(final Iterable<? extends Rights> rights) {
            super.addRights(rights);
            return this;
        }

        /**
         * Adds the given items to the value of "rights"
         * 
         * @param rights
         *     Items to add to the value of the "rights" property
         */
        @Override
        public Registry.Builder<_B> addRights(Rights... rights) {
            super.addRights(rights);
            return this;
        }

        /**
         * Sets the new value of "rights" (any previous value will be replaced)
         * 
         * @param rights
         *     New value of the "rights" property.
         */
        @Override
        public Registry.Builder<_B> withRights(final Iterable<? extends Rights> rights) {
            super.withRights(rights);
            return this;
        }

        /**
         * Sets the new value of "rights" (any previous value will be replaced)
         * 
         * @param rights
         *     New value of the "rights" property.
         */
        @Override
        public Registry.Builder<_B> withRights(Rights... rights) {
            super.withRights(rights);
            return this;
        }

        /**
         * Adds the given items to the value of "capabilities"
         * 
         * @param capabilities
         *     Items to add to the value of the "capabilities" property
         */
        @Override
        public Registry.Builder<_B> addCapabilities(final Iterable<? extends Capability> capabilities) {
            super.addCapabilities(capabilities);
            return this;
        }

        /**
         * Adds the given items to the value of "capabilities"
         * 
         * @param capabilities
         *     Items to add to the value of the "capabilities" property
         */
        @Override
        public Registry.Builder<_B> addCapabilities(Capability... capabilities) {
            super.addCapabilities(capabilities);
            return this;
        }

        /**
         * Sets the new value of "capabilities" (any previous value will be replaced)
         * 
         * @param capabilities
         *     New value of the "capabilities" property.
         */
        @Override
        public Registry.Builder<_B> withCapabilities(final Iterable<? extends Capability> capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        /**
         * Sets the new value of "capabilities" (any previous value will be replaced)
         * 
         * @param capabilities
         *     New value of the "capabilities" property.
         */
        @Override
        public Registry.Builder<_B> withCapabilities(Capability... capabilities) {
            super.withCapabilities(capabilities);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Registry.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Registry.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Registry.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Registry.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public Registry.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public Registry.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public Registry.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Registry.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Registry.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Registry.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Registry.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public Registry.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends Registry.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends Registry.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public Registry.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends Registry.Builder<_B>> withContent() {
            return ((Content.Builder<? extends Registry.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public Registry.Builder<_B> withCreated(final ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public Registry.Builder<_B> withUpdated(final ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public Registry.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public Registry.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Registry build() {
            if (_storedValue == null) {
                return this.init(new Registry());
            } else {
                return ((Registry) _storedValue);
            }
        }

        public Registry.Builder<_B> copyOf(final Registry _other) {
            _other.copyTo(this);
            return this;
        }

        public Registry.Builder<_B> copyOf(final Registry.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Service.Modifier
    {


        public void setFull(final boolean full) {
            Registry.this.setFull(full);
        }

        public List<String> getManagedAuthorities() {
            if (Registry.this.managedAuthorities == null) {
                Registry.this.managedAuthorities = new ArrayList<>();
            }
            return Registry.this.managedAuthorities;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Registry, Boolean> FULL = new SinglePropertyInfo<Registry,Boolean>("full", Registry.class, Boolean.class, false, null, new QName("", "full"), new QName("http://www.w3.org/2001/XMLSchema", "boolean"), false) {


            @Override
            public Boolean get(final Registry _instance_) {
                return ((_instance_ == null)?null:_instance_.full);
            }

            @Override
            public void set(final Registry _instance_, final Boolean _value_) {
                if (_instance_!= null) {
                    _instance_.full = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Registry, String> MANAGED_AUTHORITIES = new CollectionPropertyInfo<Registry,String>("managedAuthorities", Registry.class, String.class, true, null, new QName("", "managedAuthority"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "AuthorityID"), false) {


            @Override
            public List<String> get(final Registry _instance_) {
                return ((_instance_ == null)?null:_instance_.managedAuthorities);
            }

            @Override
            public void set(final Registry _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.managedAuthorities = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Registry.Selector<Registry.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Registry.Select _root() {
            return new Registry.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Service.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Registry.Selector<TRoot, TParent>> managedAuthorities = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.managedAuthorities!= null) {
                products.put("managedAuthorities", this.managedAuthorities.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Registry.Selector<TRoot, TParent>> managedAuthorities() {
            return ((this.managedAuthorities == null)?this.managedAuthorities = new com.kscs.util.jaxb.Selector<>(this._root, this, "managedAuthorities"):this.managedAuthorities);
        }

    }

}
