
package org.javastro.ivoa.entities.resource.registry.oaipmh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A record has a header, a metadata part, and
 *         an optional about container
 * 
 * <p>Java class for recordType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="recordType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="header" type="{http://www.openarchives.org/OAI/2.0/}headerType"/>
 *         <element name="metadata" type="{http://www.openarchives.org/OAI/2.0/}metadataType" minOccurs="0"/>
 *         <element name="about" type="{http://www.openarchives.org/OAI/2.0/}aboutType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "recordType", propOrder = {
    "header",
    "metadata",
    "abouts"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class RecordType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected HeaderType header;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected MetadataType metadata;
    @XmlElement(name = "about")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<AboutType> abouts;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient RecordType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public RecordType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public RecordType(final HeaderType header, final MetadataType metadata, final List<AboutType> abouts) {
        this.header = header;
        this.metadata = metadata;
        this.abouts = abouts;
    }

    /**
     * Gets the value of the header property.
     * 
     * @return
     *     possible object is
     *     {@link HeaderType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public HeaderType getHeader() {
        return header;
    }

    /**
     * Sets the value of the header property.
     * 
     * @param value
     *     allowed object is
     *     {@link HeaderType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setHeader(HeaderType value) {
        this.header = value;
    }

    /**
     * Gets the value of the metadata property.
     * 
     * @return
     *     possible object is
     *     {@link MetadataType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public MetadataType getMetadata() {
        return metadata;
    }

    /**
     * Sets the value of the metadata property.
     * 
     * @param value
     *     allowed object is
     *     {@link MetadataType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setMetadata(MetadataType value) {
        this.metadata = value;
    }

    /**
     * Gets the value of the abouts property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the abouts property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAbouts().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AboutType }
     * </p>
     * 
     * 
     * @return
     *     The value of the abouts property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<AboutType> getAbouts() {
        if (abouts == null) {
            abouts = new ArrayList<>();
        }
        return this.abouts;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final RecordType that = ((RecordType) object);
        {
            HeaderType leftHeader;
            leftHeader = this.getHeader();
            HeaderType rightHeader;
            rightHeader = that.getHeader();
            if (this.header!= null) {
                if (that.header!= null) {
                    if (!leftHeader.equals(rightHeader)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.header!= null) {
                    return false;
                }
            }
        }
        {
            MetadataType leftMetadata;
            leftMetadata = this.getMetadata();
            MetadataType rightMetadata;
            rightMetadata = that.getMetadata();
            if (this.metadata!= null) {
                if (that.metadata!= null) {
                    if (!leftMetadata.equals(rightMetadata)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.metadata!= null) {
                    return false;
                }
            }
        }
        {
            List<AboutType> leftAbouts;
            leftAbouts = (((this.abouts!= null)&&(!this.abouts.isEmpty()))?this.getAbouts():null);
            List<AboutType> rightAbouts;
            rightAbouts = (((that.abouts!= null)&&(!that.abouts.isEmpty()))?that.getAbouts():null);
            if ((this.abouts!= null)&&(!this.abouts.isEmpty())) {
                if ((that.abouts!= null)&&(!that.abouts.isEmpty())) {
                    if (!leftAbouts.equals(rightAbouts)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.abouts!= null)&&(!that.abouts.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            HeaderType theHeader;
            theHeader = this.getHeader();
            if (this.header!= null) {
                currentHashCode += theHeader.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            MetadataType theMetadata;
            theMetadata = this.getMetadata();
            if (this.metadata!= null) {
                currentHashCode += theMetadata.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<AboutType> theAbouts;
            theAbouts = (((this.abouts!= null)&&(!this.abouts.isEmpty()))?this.getAbouts():null);
            if ((this.abouts!= null)&&(!this.abouts.isEmpty())) {
                currentHashCode += theAbouts.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            HeaderType theHeader;
            theHeader = this.getHeader();
            strategy.appendField(locator, this, "header", buffer, theHeader, (this.header!= null));
        }
        {
            MetadataType theMetadata;
            theMetadata = this.getMetadata();
            strategy.appendField(locator, this, "metadata", buffer, theMetadata, (this.metadata!= null));
        }
        {
            List<AboutType> theAbouts;
            theAbouts = (((this.abouts!= null)&&(!this.abouts.isEmpty()))?this.getAbouts():null);
            strategy.appendField(locator, this, "abouts", buffer, theAbouts, ((this.abouts!= null)&&(!this.abouts.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof RecordType) {
            final RecordType target = this;
            final RecordType leftObject = ((RecordType) left);
            final RecordType rightObject = ((RecordType) right);
            {
                Boolean headerShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.header!= null), (rightObject.header!= null));
                if (headerShouldBeMergedAndSet == Boolean.TRUE) {
                    HeaderType lhsHeader;
                    lhsHeader = leftObject.getHeader();
                    HeaderType rhsHeader;
                    rhsHeader = rightObject.getHeader();
                    HeaderType mergedHeader = ((HeaderType) strategy.merge(LocatorUtils.property(leftLocator, "header", lhsHeader), LocatorUtils.property(rightLocator, "header", rhsHeader), lhsHeader, rhsHeader, (leftObject.header!= null), (rightObject.header!= null)));
                    target.setHeader(mergedHeader);
                } else {
                    if (headerShouldBeMergedAndSet == Boolean.FALSE) {
                        target.header = null;
                    }
                }
            }
            {
                Boolean metadataShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.metadata!= null), (rightObject.metadata!= null));
                if (metadataShouldBeMergedAndSet == Boolean.TRUE) {
                    MetadataType lhsMetadata;
                    lhsMetadata = leftObject.getMetadata();
                    MetadataType rhsMetadata;
                    rhsMetadata = rightObject.getMetadata();
                    MetadataType mergedMetadata = ((MetadataType) strategy.merge(LocatorUtils.property(leftLocator, "metadata", lhsMetadata), LocatorUtils.property(rightLocator, "metadata", rhsMetadata), lhsMetadata, rhsMetadata, (leftObject.metadata!= null), (rightObject.metadata!= null)));
                    target.setMetadata(mergedMetadata);
                } else {
                    if (metadataShouldBeMergedAndSet == Boolean.FALSE) {
                        target.metadata = null;
                    }
                }
            }
            {
                Boolean aboutsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.abouts!= null)&&(!leftObject.abouts.isEmpty())), ((rightObject.abouts!= null)&&(!rightObject.abouts.isEmpty())));
                if (aboutsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<AboutType> lhsAbouts;
                    lhsAbouts = (((leftObject.abouts!= null)&&(!leftObject.abouts.isEmpty()))?leftObject.getAbouts():null);
                    List<AboutType> rhsAbouts;
                    rhsAbouts = (((rightObject.abouts!= null)&&(!rightObject.abouts.isEmpty()))?rightObject.getAbouts():null);
                    List<AboutType> mergedAbouts = ((List<AboutType> ) strategy.merge(LocatorUtils.property(leftLocator, "abouts", lhsAbouts), LocatorUtils.property(rightLocator, "abouts", rhsAbouts), lhsAbouts, rhsAbouts, ((leftObject.abouts!= null)&&(!leftObject.abouts.isEmpty())), ((rightObject.abouts!= null)&&(!rightObject.abouts.isEmpty()))));
                    target.abouts = null;
                    if (mergedAbouts!= null) {
                        List<AboutType> uniqueAboutsl = target.getAbouts();
                        uniqueAboutsl.addAll(mergedAbouts);
                    }
                } else {
                    if (aboutsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.abouts = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new RecordType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType clone() {
        final RecordType _newObject;
        try {
            _newObject = ((RecordType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.header = ((this.header == null)?null:this.header.clone());
        _newObject.metadata = ((this.metadata == null)?null:this.metadata.clone());
        if (this.abouts == null) {
            _newObject.abouts = null;
        } else {
            _newObject.abouts = new ArrayList<>();
            for (AboutType _item: this.abouts) {
                _newObject.abouts.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType createCopy() {
        final RecordType _newObject;
        try {
            _newObject = ((RecordType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.header = ((this.header == null)?null:this.header.createCopy());
        _newObject.metadata = ((this.metadata == null)?null:this.metadata.createCopy());
        if (this.abouts == null) {
            _newObject.abouts = null;
        } else {
            _newObject.abouts = new ArrayList<>();
            for (AboutType _item: this.abouts) {
                _newObject.abouts.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RecordType _newObject;
        try {
            _newObject = ((RecordType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree headerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("header"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(headerPropertyTree!= null):((headerPropertyTree == null)||(!headerPropertyTree.isLeaf())))) {
            _newObject.header = ((this.header == null)?null:this.header.createCopy(headerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree metadataPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("metadata"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(metadataPropertyTree!= null):((metadataPropertyTree == null)||(!metadataPropertyTree.isLeaf())))) {
            _newObject.metadata = ((this.metadata == null)?null:this.metadata.createCopy(metadataPropertyTree, _propertyTreeUse));
        }
        final PropertyTree aboutsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("abouts"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aboutsPropertyTree!= null):((aboutsPropertyTree == null)||(!aboutsPropertyTree.isLeaf())))) {
            if (this.abouts == null) {
                _newObject.abouts = null;
            } else {
                _newObject.abouts = new ArrayList<>();
                for (AboutType _item: this.abouts) {
                    _newObject.abouts.add(((_item == null)?null:_item.createCopy(aboutsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new RecordType.Modifier();
        }
        return ((RecordType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final RecordType.Builder<_B> _other) {
        _other.header = ((this.header == null)?null:this.header.newCopyBuilder(_other));
        _other.metadata = ((this.metadata == null)?null:this.metadata.newCopyBuilder(_other));
        if (this.abouts == null) {
            _other.abouts = null;
        } else {
            _other.abouts = new ArrayList<>();
            for (AboutType _item: this.abouts) {
                _other.abouts.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >RecordType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new RecordType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RecordType.Builder<Void> builder() {
        return new RecordType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RecordType.Builder<_B> copyOf(final RecordType _other) {
        final RecordType.Builder<_B> _newBuilder = new RecordType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final RecordType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree headerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("header"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(headerPropertyTree!= null):((headerPropertyTree == null)||(!headerPropertyTree.isLeaf())))) {
            _other.header = ((this.header == null)?null:this.header.newCopyBuilder(_other, headerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree metadataPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("metadata"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(metadataPropertyTree!= null):((metadataPropertyTree == null)||(!metadataPropertyTree.isLeaf())))) {
            _other.metadata = ((this.metadata == null)?null:this.metadata.newCopyBuilder(_other, metadataPropertyTree, _propertyTreeUse));
        }
        final PropertyTree aboutsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("abouts"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aboutsPropertyTree!= null):((aboutsPropertyTree == null)||(!aboutsPropertyTree.isLeaf())))) {
            if (this.abouts == null) {
                _other.abouts = null;
            } else {
                _other.abouts = new ArrayList<>();
                for (AboutType _item: this.abouts) {
                    _other.abouts.add(((_item == null)?null:_item.newCopyBuilder(_other, aboutsPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >RecordType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new RecordType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >RecordType.Builder<_B> copyOf(final RecordType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final RecordType.Builder<_B> _newBuilder = new RecordType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RecordType.Builder<Void> copyExcept(final RecordType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static RecordType.Builder<Void> copyOnly(final RecordType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public RecordType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new SingleProperty<>(RecordType.PropInfo.HEADER, this))&&(this.header!= null)) {
            this.header.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(RecordType.PropInfo.METADATA, this))&&(this.metadata!= null)) {
            this.metadata.visit(_visitor_);
        }
        if (_visitor_.visit(new CollectionProperty<>(RecordType.PropInfo.ABOUTS, this))&&(this.abouts!= null)) {
            for (AboutType _item_: this.abouts) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final RecordType _storedValue;
        private HeaderType.Builder<RecordType.Builder<_B>> header;
        private MetadataType.Builder<RecordType.Builder<_B>> metadata;
        private List<AboutType.Builder<RecordType.Builder<_B>>> abouts;

        public Builder(final _B _parentBuilder, final RecordType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.header = ((_other.header == null)?null:_other.header.newCopyBuilder(this));
                    this.metadata = ((_other.metadata == null)?null:_other.metadata.newCopyBuilder(this));
                    if (_other.abouts == null) {
                        this.abouts = null;
                    } else {
                        this.abouts = new ArrayList<>();
                        for (AboutType _item: _other.abouts) {
                            this.abouts.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final RecordType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree headerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("header"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(headerPropertyTree!= null):((headerPropertyTree == null)||(!headerPropertyTree.isLeaf())))) {
                        this.header = ((_other.header == null)?null:_other.header.newCopyBuilder(this, headerPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree metadataPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("metadata"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(metadataPropertyTree!= null):((metadataPropertyTree == null)||(!metadataPropertyTree.isLeaf())))) {
                        this.metadata = ((_other.metadata == null)?null:_other.metadata.newCopyBuilder(this, metadataPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree aboutsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("abouts"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aboutsPropertyTree!= null):((aboutsPropertyTree == null)||(!aboutsPropertyTree.isLeaf())))) {
                        if (_other.abouts == null) {
                            this.abouts = null;
                        } else {
                            this.abouts = new ArrayList<>();
                            for (AboutType _item: _other.abouts) {
                                this.abouts.add(((_item == null)?null:_item.newCopyBuilder(this, aboutsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends RecordType >_P init(final _P _product) {
            _product.header = ((this.header == null)?null:this.header.build());
            _product.metadata = ((this.metadata == null)?null:this.metadata.build());
            if (this.abouts!= null) {
                final List<AboutType> abouts = new ArrayList<>(this.abouts.size());
                for (AboutType.Builder<RecordType.Builder<_B>> _item: this.abouts) {
                    abouts.add(_item.build());
                }
                _product.abouts = abouts;
            }
            return _product;
        }

        /**
         * Sets the new value of "header" (any previous value will be replaced)
         * 
         * @param header
         *     New value of the "header" property.
         */
        public RecordType.Builder<_B> withHeader(final HeaderType header) {
            this.header = ((header == null)?null:new HeaderType.Builder<>(this, header, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "header"
         * property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.registry.oaipmh.HeaderType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "header" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.registry.oaipmh.HeaderType.Builder#end()} to
         *     return to the current builder.
         */
        public HeaderType.Builder<? extends RecordType.Builder<_B>> withHeader() {
            if (this.header!= null) {
                return this.header;
            }
            return this.header = new HeaderType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "metadata" (any previous value will be replaced)
         * 
         * @param metadata
         *     New value of the "metadata" property.
         */
        public RecordType.Builder<_B> withMetadata(final MetadataType metadata) {
            this.metadata = ((metadata == null)?null:new MetadataType.Builder<>(this, metadata, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "metadata" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.registry.oaipmh.MetadataType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "metadata" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.registry.oaipmh.MetadataType.Builder#end()}
         *     to return to the current builder.
         */
        public MetadataType.Builder<? extends RecordType.Builder<_B>> withMetadata() {
            if (this.metadata!= null) {
                return this.metadata;
            }
            return this.metadata = new MetadataType.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "abouts"
         * 
         * @param abouts
         *     Items to add to the value of the "abouts" property
         */
        public RecordType.Builder<_B> addAbouts(final Iterable<? extends AboutType> abouts) {
            if (abouts!= null) {
                if (this.abouts == null) {
                    this.abouts = new ArrayList<>();
                }
                for (AboutType _item: abouts) {
                    this.abouts.add(new AboutType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "abouts" (any previous value will be replaced)
         * 
         * @param abouts
         *     New value of the "abouts" property.
         */
        public RecordType.Builder<_B> withAbouts(final Iterable<? extends AboutType> abouts) {
            if (this.abouts!= null) {
                this.abouts.clear();
            }
            return addAbouts(abouts);
        }

        /**
         * Adds the given items to the value of "abouts"
         * 
         * @param abouts
         *     Items to add to the value of the "abouts" property
         */
        public RecordType.Builder<_B> addAbouts(AboutType... abouts) {
            addAbouts(Arrays.asList(abouts));
            return this;
        }

        /**
         * Sets the new value of "abouts" (any previous value will be replaced)
         * 
         * @param abouts
         *     New value of the "abouts" property.
         */
        public RecordType.Builder<_B> withAbouts(AboutType... abouts) {
            withAbouts(Arrays.asList(abouts));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Abouts" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.registry.oaipmh.AboutType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Abouts" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.registry.oaipmh.AboutType.Builder#end()} to
         *     return to the current builder.
         */
        public AboutType.Builder<? extends RecordType.Builder<_B>> addAbouts() {
            if (this.abouts == null) {
                this.abouts = new ArrayList<>();
            }
            final AboutType.Builder<RecordType.Builder<_B>> abouts_Builder = new AboutType.Builder<>(this, null, false);
            this.abouts.add(abouts_Builder);
            return abouts_Builder;
        }

        @Override
        public RecordType build() {
            if (_storedValue == null) {
                return this.init(new RecordType());
            } else {
                return ((RecordType) _storedValue);
            }
        }

        public RecordType.Builder<_B> copyOf(final RecordType _other) {
            _other.copyTo(this);
            return this;
        }

        public RecordType.Builder<_B> copyOf(final RecordType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setHeader(final HeaderType header) {
            RecordType.this.setHeader(header);
        }

        public void setMetadata(final MetadataType metadata) {
            RecordType.this.setMetadata(metadata);
        }

        public List<AboutType> getAbouts() {
            if (RecordType.this.abouts == null) {
                RecordType.this.abouts = new ArrayList<>();
            }
            return RecordType.this.abouts;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<RecordType, HeaderType> HEADER = new SinglePropertyInfo<RecordType,HeaderType>("header", RecordType.class, HeaderType.class, false, null, new QName("http://www.openarchives.org/OAI/2.0/", "header"), new QName("http://www.openarchives.org/OAI/2.0/", "headerType"), false) {


            @Override
            public HeaderType get(final RecordType _instance_) {
                return ((_instance_ == null)?null:_instance_.header);
            }

            @Override
            public void set(final RecordType _instance_, final HeaderType _value_) {
                if (_instance_!= null) {
                    _instance_.header = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<RecordType, MetadataType> METADATA = new SinglePropertyInfo<RecordType,MetadataType>("metadata", RecordType.class, MetadataType.class, false, null, new QName("http://www.openarchives.org/OAI/2.0/", "metadata"), new QName("http://www.openarchives.org/OAI/2.0/", "metadataType"), false) {


            @Override
            public MetadataType get(final RecordType _instance_) {
                return ((_instance_ == null)?null:_instance_.metadata);
            }

            @Override
            public void set(final RecordType _instance_, final MetadataType _value_) {
                if (_instance_!= null) {
                    _instance_.metadata = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<RecordType, AboutType> ABOUTS = new CollectionPropertyInfo<RecordType,AboutType>("abouts", RecordType.class, AboutType.class, true, null, new QName("http://www.openarchives.org/OAI/2.0/", "about"), new QName("http://www.openarchives.org/OAI/2.0/", "aboutType"), false) {


            @Override
            public List<AboutType> get(final RecordType _instance_) {
                return ((_instance_ == null)?null:_instance_.abouts);
            }

            @Override
            public void set(final RecordType _instance_, final List<AboutType> _value_) {
                if (_instance_!= null) {
                    _instance_.abouts = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends RecordType.Selector<RecordType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static RecordType.Select _root() {
            return new RecordType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private HeaderType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> header = null;
        private MetadataType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> metadata = null;
        private AboutType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> abouts = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.header!= null) {
                products.put("header", this.header.init());
            }
            if (this.metadata!= null) {
                products.put("metadata", this.metadata.init());
            }
            if (this.abouts!= null) {
                products.put("abouts", this.abouts.init());
            }
            return products;
        }

        public HeaderType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> header() {
            return ((this.header == null)?this.header = new HeaderType.Selector<>(this._root, this, "header"):this.header);
        }

        public MetadataType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> metadata() {
            return ((this.metadata == null)?this.metadata = new MetadataType.Selector<>(this._root, this, "metadata"):this.metadata);
        }

        public AboutType.Selector<TRoot, RecordType.Selector<TRoot, TParent>> abouts() {
            return ((this.abouts == null)?this.abouts = new AboutType.Selector<>(this._root, this, "abouts"):this.abouts);
        }

    }

}
