
package org.javastro.ivoa.entities.resource.registry.oaipmh;

import java.math.BigInteger;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.jaxb.adapters.ZonedDateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A resumptionToken may have 3 optional attributes
 *        and can be used in ListSets, ListIdentifiers, ListRecords
 *        responses.
 * 
 * <p>Java class for resumptionTokenType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="resumptionTokenType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>string">
 *       <attribute name="expirationDate" type="{http://www.w3.org/2001/XMLSchema}dateTime" />
 *       <attribute name="completeListSize" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" />
 *       <attribute name="cursor" type="{http://www.w3.org/2001/XMLSchema}nonNegativeInteger" />
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "resumptionTokenType", propOrder = {
    "value"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class ResumptionTokenType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlValue
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String value;
    @XmlAttribute(name = "expirationDate")
    @XmlJavaTypeAdapter(ZonedDateTimeXmlAdapter.class)
    @XmlSchemaType(name = "dateTime")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected ZonedDateTime expirationDate;
    @XmlAttribute(name = "completeListSize")
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected BigInteger completeListSize;
    @XmlAttribute(name = "cursor")
    @XmlSchemaType(name = "nonNegativeInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected BigInteger cursor;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient ResumptionTokenType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public ResumptionTokenType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ResumptionTokenType(final String value, final ZonedDateTime expirationDate, final BigInteger completeListSize, final BigInteger cursor) {
        this.value = value;
        this.expirationDate = expirationDate;
        this.completeListSize = completeListSize;
        this.cursor = cursor;
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Gets the value of the expirationDate property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ZonedDateTime getExpirationDate() {
        return expirationDate;
    }

    /**
     * Sets the value of the expirationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setExpirationDate(ZonedDateTime value) {
        this.expirationDate = value;
    }

    /**
     * Gets the value of the completeListSize property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BigInteger getCompleteListSize() {
        return completeListSize;
    }

    /**
     * Sets the value of the completeListSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCompleteListSize(BigInteger value) {
        this.completeListSize = value;
    }

    /**
     * Gets the value of the cursor property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BigInteger getCursor() {
        return cursor;
    }

    /**
     * Sets the value of the cursor property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCursor(BigInteger value) {
        this.cursor = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ResumptionTokenType that = ((ResumptionTokenType) object);
        {
            String leftValue;
            leftValue = this.getValue();
            String rightValue;
            rightValue = that.getValue();
            if (this.value!= null) {
                if (that.value!= null) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.value!= null) {
                    return false;
                }
            }
        }
        {
            ZonedDateTime leftExpirationDate;
            leftExpirationDate = this.getExpirationDate();
            ZonedDateTime rightExpirationDate;
            rightExpirationDate = that.getExpirationDate();
            if (this.expirationDate!= null) {
                if (that.expirationDate!= null) {
                    if (!leftExpirationDate.equals(rightExpirationDate)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.expirationDate!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftCompleteListSize;
            leftCompleteListSize = this.getCompleteListSize();
            BigInteger rightCompleteListSize;
            rightCompleteListSize = that.getCompleteListSize();
            if (this.completeListSize!= null) {
                if (that.completeListSize!= null) {
                    if (!leftCompleteListSize.equals(rightCompleteListSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.completeListSize!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftCursor;
            leftCursor = this.getCursor();
            BigInteger rightCursor;
            rightCursor = that.getCursor();
            if (this.cursor!= null) {
                if (that.cursor!= null) {
                    if (!leftCursor.equals(rightCursor)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.cursor!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theValue;
            theValue = this.getValue();
            if (this.value!= null) {
                currentHashCode += theValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            ZonedDateTime theExpirationDate;
            theExpirationDate = this.getExpirationDate();
            if (this.expirationDate!= null) {
                currentHashCode += theExpirationDate.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theCompleteListSize;
            theCompleteListSize = this.getCompleteListSize();
            if (this.completeListSize!= null) {
                currentHashCode += theCompleteListSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theCursor;
            theCursor = this.getCursor();
            if (this.cursor!= null) {
                currentHashCode += theCursor.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue, (this.value!= null));
        }
        {
            ZonedDateTime theExpirationDate;
            theExpirationDate = this.getExpirationDate();
            strategy.appendField(locator, this, "expirationDate", buffer, theExpirationDate, (this.expirationDate!= null));
        }
        {
            BigInteger theCompleteListSize;
            theCompleteListSize = this.getCompleteListSize();
            strategy.appendField(locator, this, "completeListSize", buffer, theCompleteListSize, (this.completeListSize!= null));
        }
        {
            BigInteger theCursor;
            theCursor = this.getCursor();
            strategy.appendField(locator, this, "cursor", buffer, theCursor, (this.cursor!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof ResumptionTokenType) {
            final ResumptionTokenType target = this;
            final ResumptionTokenType leftObject = ((ResumptionTokenType) left);
            final ResumptionTokenType rightObject = ((ResumptionTokenType) right);
            {
                Boolean valueShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.value!= null), (rightObject.value!= null));
                if (valueShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsValue;
                    lhsValue = leftObject.getValue();
                    String rhsValue;
                    rhsValue = rightObject.getValue();
                    String mergedValue = ((String) strategy.merge(LocatorUtils.property(leftLocator, "value", lhsValue), LocatorUtils.property(rightLocator, "value", rhsValue), lhsValue, rhsValue, (leftObject.value!= null), (rightObject.value!= null)));
                    target.setValue(mergedValue);
                } else {
                    if (valueShouldBeMergedAndSet == Boolean.FALSE) {
                        target.value = null;
                    }
                }
            }
            {
                Boolean expirationDateShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.expirationDate!= null), (rightObject.expirationDate!= null));
                if (expirationDateShouldBeMergedAndSet == Boolean.TRUE) {
                    ZonedDateTime lhsExpirationDate;
                    lhsExpirationDate = leftObject.getExpirationDate();
                    ZonedDateTime rhsExpirationDate;
                    rhsExpirationDate = rightObject.getExpirationDate();
                    ZonedDateTime mergedExpirationDate = ((ZonedDateTime) strategy.merge(LocatorUtils.property(leftLocator, "expirationDate", lhsExpirationDate), LocatorUtils.property(rightLocator, "expirationDate", rhsExpirationDate), lhsExpirationDate, rhsExpirationDate, (leftObject.expirationDate!= null), (rightObject.expirationDate!= null)));
                    target.setExpirationDate(mergedExpirationDate);
                } else {
                    if (expirationDateShouldBeMergedAndSet == Boolean.FALSE) {
                        target.expirationDate = null;
                    }
                }
            }
            {
                Boolean completeListSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.completeListSize!= null), (rightObject.completeListSize!= null));
                if (completeListSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsCompleteListSize;
                    lhsCompleteListSize = leftObject.getCompleteListSize();
                    BigInteger rhsCompleteListSize;
                    rhsCompleteListSize = rightObject.getCompleteListSize();
                    BigInteger mergedCompleteListSize = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "completeListSize", lhsCompleteListSize), LocatorUtils.property(rightLocator, "completeListSize", rhsCompleteListSize), lhsCompleteListSize, rhsCompleteListSize, (leftObject.completeListSize!= null), (rightObject.completeListSize!= null)));
                    target.setCompleteListSize(mergedCompleteListSize);
                } else {
                    if (completeListSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.completeListSize = null;
                    }
                }
            }
            {
                Boolean cursorShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.cursor!= null), (rightObject.cursor!= null));
                if (cursorShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsCursor;
                    lhsCursor = leftObject.getCursor();
                    BigInteger rhsCursor;
                    rhsCursor = rightObject.getCursor();
                    BigInteger mergedCursor = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "cursor", lhsCursor), LocatorUtils.property(rightLocator, "cursor", rhsCursor), lhsCursor, rhsCursor, (leftObject.cursor!= null), (rightObject.cursor!= null)));
                    target.setCursor(mergedCursor);
                } else {
                    if (cursorShouldBeMergedAndSet == Boolean.FALSE) {
                        target.cursor = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new ResumptionTokenType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType clone() {
        final ResumptionTokenType _newObject;
        try {
            _newObject = ((ResumptionTokenType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType createCopy() {
        final ResumptionTokenType _newObject;
        try {
            _newObject = ((ResumptionTokenType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.value = this.value;
        _newObject.expirationDate = this.expirationDate;
        _newObject.completeListSize = this.completeListSize;
        _newObject.cursor = this.cursor;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ResumptionTokenType _newObject;
        try {
            _newObject = ((ResumptionTokenType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _newObject.value = this.value;
        }
        final PropertyTree expirationDatePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("expirationDate"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(expirationDatePropertyTree!= null):((expirationDatePropertyTree == null)||(!expirationDatePropertyTree.isLeaf())))) {
            _newObject.expirationDate = this.expirationDate;
        }
        final PropertyTree completeListSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("completeListSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(completeListSizePropertyTree!= null):((completeListSizePropertyTree == null)||(!completeListSizePropertyTree.isLeaf())))) {
            _newObject.completeListSize = this.completeListSize;
        }
        final PropertyTree cursorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("cursor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(cursorPropertyTree!= null):((cursorPropertyTree == null)||(!cursorPropertyTree.isLeaf())))) {
            _newObject.cursor = this.cursor;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ResumptionTokenType.Modifier();
        }
        return ((ResumptionTokenType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ResumptionTokenType.Builder<_B> _other) {
        _other.value = this.value;
        _other.expirationDate = this.expirationDate;
        _other.completeListSize = this.completeListSize;
        _other.cursor = this.cursor;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ResumptionTokenType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ResumptionTokenType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ResumptionTokenType.Builder<Void> builder() {
        return new ResumptionTokenType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ResumptionTokenType.Builder<_B> copyOf(final ResumptionTokenType _other) {
        final ResumptionTokenType.Builder<_B> _newBuilder = new ResumptionTokenType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final ResumptionTokenType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _other.value = this.value;
        }
        final PropertyTree expirationDatePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("expirationDate"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(expirationDatePropertyTree!= null):((expirationDatePropertyTree == null)||(!expirationDatePropertyTree.isLeaf())))) {
            _other.expirationDate = this.expirationDate;
        }
        final PropertyTree completeListSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("completeListSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(completeListSizePropertyTree!= null):((completeListSizePropertyTree == null)||(!completeListSizePropertyTree.isLeaf())))) {
            _other.completeListSize = this.completeListSize;
        }
        final PropertyTree cursorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("cursor"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(cursorPropertyTree!= null):((cursorPropertyTree == null)||(!cursorPropertyTree.isLeaf())))) {
            _other.cursor = this.cursor;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >ResumptionTokenType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ResumptionTokenType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >ResumptionTokenType.Builder<_B> copyOf(final ResumptionTokenType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ResumptionTokenType.Builder<_B> _newBuilder = new ResumptionTokenType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ResumptionTokenType.Builder<Void> copyExcept(final ResumptionTokenType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static ResumptionTokenType.Builder<Void> copyOnly(final ResumptionTokenType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public ResumptionTokenType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(ResumptionTokenType.PropInfo.VALUE, this));
        _visitor_.visit(new SingleProperty<>(ResumptionTokenType.PropInfo.EXPIRATION_DATE, this));
        _visitor_.visit(new SingleProperty<>(ResumptionTokenType.PropInfo.COMPLETE_LIST_SIZE, this));
        _visitor_.visit(new SingleProperty<>(ResumptionTokenType.PropInfo.CURSOR, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final ResumptionTokenType _storedValue;
        private String value;
        private ZonedDateTime expirationDate;
        private BigInteger completeListSize;
        private BigInteger cursor;

        public Builder(final _B _parentBuilder, final ResumptionTokenType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.value = _other.value;
                    this.expirationDate = _other.expirationDate;
                    this.completeListSize = _other.completeListSize;
                    this.cursor = _other.cursor;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final ResumptionTokenType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
                        this.value = _other.value;
                    }
                    final PropertyTree expirationDatePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("expirationDate"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(expirationDatePropertyTree!= null):((expirationDatePropertyTree == null)||(!expirationDatePropertyTree.isLeaf())))) {
                        this.expirationDate = _other.expirationDate;
                    }
                    final PropertyTree completeListSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("completeListSize"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(completeListSizePropertyTree!= null):((completeListSizePropertyTree == null)||(!completeListSizePropertyTree.isLeaf())))) {
                        this.completeListSize = _other.completeListSize;
                    }
                    final PropertyTree cursorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("cursor"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(cursorPropertyTree!= null):((cursorPropertyTree == null)||(!cursorPropertyTree.isLeaf())))) {
                        this.cursor = _other.cursor;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends ResumptionTokenType >_P init(final _P _product) {
            _product.value = this.value;
            _product.expirationDate = this.expirationDate;
            _product.completeListSize = this.completeListSize;
            _product.cursor = this.cursor;
            return _product;
        }

        /**
         * Sets the new value of "value" (any previous value will be replaced)
         * 
         * @param value
         *     New value of the "value" property.
         */
        public ResumptionTokenType.Builder<_B> withValue(final String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the new value of "expirationDate" (any previous value will be replaced)
         * 
         * @param expirationDate
         *     New value of the "expirationDate" property.
         */
        public ResumptionTokenType.Builder<_B> withExpirationDate(final ZonedDateTime expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        /**
         * Sets the new value of "completeListSize" (any previous value will be replaced)
         * 
         * @param completeListSize
         *     New value of the "completeListSize" property.
         */
        public ResumptionTokenType.Builder<_B> withCompleteListSize(final BigInteger completeListSize) {
            this.completeListSize = completeListSize;
            return this;
        }

        /**
         * Sets the new value of "cursor" (any previous value will be replaced)
         * 
         * @param cursor
         *     New value of the "cursor" property.
         */
        public ResumptionTokenType.Builder<_B> withCursor(final BigInteger cursor) {
            this.cursor = cursor;
            return this;
        }

        @Override
        public ResumptionTokenType build() {
            if (_storedValue == null) {
                return this.init(new ResumptionTokenType());
            } else {
                return ((ResumptionTokenType) _storedValue);
            }
        }

        public ResumptionTokenType.Builder<_B> copyOf(final ResumptionTokenType _other) {
            _other.copyTo(this);
            return this;
        }

        public ResumptionTokenType.Builder<_B> copyOf(final ResumptionTokenType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setValue(final String value) {
            ResumptionTokenType.this.setValue(value);
        }

        public void setExpirationDate(final ZonedDateTime expirationDate) {
            ResumptionTokenType.this.setExpirationDate(expirationDate);
        }

        public void setCompleteListSize(final BigInteger completeListSize) {
            ResumptionTokenType.this.setCompleteListSize(completeListSize);
        }

        public void setCursor(final BigInteger cursor) {
            ResumptionTokenType.this.setCursor(cursor);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<ResumptionTokenType, String> VALUE = new SinglePropertyInfo<ResumptionTokenType,String>("value", ResumptionTokenType.class, String.class, false, null, new QName("http://www.w3.org/2001/XMLSchema", "string"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ResumptionTokenType _instance_) {
                return ((_instance_ == null)?null:_instance_.value);
            }

            @Override
            public void set(final ResumptionTokenType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.value = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ResumptionTokenType, ZonedDateTime> EXPIRATION_DATE = new SinglePropertyInfo<ResumptionTokenType,ZonedDateTime>("expirationDate", ResumptionTokenType.class, ZonedDateTime.class, false, null, new QName("", "expirationDate"), new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), true) {


            @Override
            public ZonedDateTime get(final ResumptionTokenType _instance_) {
                return ((_instance_ == null)?null:_instance_.expirationDate);
            }

            @Override
            public void set(final ResumptionTokenType _instance_, final ZonedDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.expirationDate = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ResumptionTokenType, BigInteger> COMPLETE_LIST_SIZE = new SinglePropertyInfo<ResumptionTokenType,BigInteger>("completeListSize", ResumptionTokenType.class, BigInteger.class, false, null, new QName("", "completeListSize"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), true) {


            @Override
            public BigInteger get(final ResumptionTokenType _instance_) {
                return ((_instance_ == null)?null:_instance_.completeListSize);
            }

            @Override
            public void set(final ResumptionTokenType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.completeListSize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ResumptionTokenType, BigInteger> CURSOR = new SinglePropertyInfo<ResumptionTokenType,BigInteger>("cursor", ResumptionTokenType.class, BigInteger.class, false, null, new QName("", "cursor"), new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger"), true) {


            @Override
            public BigInteger get(final ResumptionTokenType _instance_) {
                return ((_instance_ == null)?null:_instance_.cursor);
            }

            @Override
            public void set(final ResumptionTokenType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.cursor = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ResumptionTokenType.Selector<ResumptionTokenType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ResumptionTokenType.Select _root() {
            return new ResumptionTokenType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> value = null;
        private com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> expirationDate = null;
        private com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> completeListSize = null;
        private com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> cursor = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.value!= null) {
                products.put("value", this.value.init());
            }
            if (this.expirationDate!= null) {
                products.put("expirationDate", this.expirationDate.init());
            }
            if (this.completeListSize!= null) {
                products.put("completeListSize", this.completeListSize.init());
            }
            if (this.cursor!= null) {
                products.put("cursor", this.cursor.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> value() {
            return ((this.value == null)?this.value = new com.kscs.util.jaxb.Selector<>(this._root, this, "value"):this.value);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> expirationDate() {
            return ((this.expirationDate == null)?this.expirationDate = new com.kscs.util.jaxb.Selector<>(this._root, this, "expirationDate"):this.expirationDate);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> completeListSize() {
            return ((this.completeListSize == null)?this.completeListSize = new com.kscs.util.jaxb.Selector<>(this._root, this, "completeListSize"):this.completeListSize);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ResumptionTokenType.Selector<TRoot, TParent>> cursor() {
            return ((this.cursor == null)?this.cursor = new com.kscs.util.jaxb.Selector<>(this._root, this, "cursor"):this.cursor);
        }

    }

}
