
package org.javastro.ivoa.entities.resource.sia;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A query to be sent to the service
 * 
 * <p>Java class for Query complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Query">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="pos" type="{http://www.ivoa.net/xml/SIA/v1.1}SkyPos" minOccurs="0"/>
 *         <element name="size" type="{http://www.ivoa.net/xml/SIA/v1.1}SkySize" minOccurs="0"/>
 *         <element name="verb" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="extras" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Query", propOrder = {
    "pos",
    "size",
    "verb",
    "extras"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Query implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the center position of the rectangular region that 
     *                    should be used as part of the query to the SIA service.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected SkyPos pos;
    /**
     * the rectangular size of the region that should be 
     *                    used as part of the query to the SIA service.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected SkySize size;
    /**
     * the verbosity level to use where 0 means the bare
     *                    minimum set of columns and 3 means the full set of 
     *                    available columns.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected BigInteger verb;
    /**
     * this value should be in the form of name=value
     *                    pairs delimited with apersands (&).
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String extras;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Query.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Query() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Query(final SkyPos pos, final SkySize size, final BigInteger verb, final String extras) {
        this.pos = pos;
        this.size = size;
        this.verb = verb;
        this.extras = extras;
    }

    /**
     * the center position of the rectangular region that 
     *                    should be used as part of the query to the SIA service.
     * 
     * @return
     *     possible object is
     *     {@link SkyPos }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SkyPos getPos() {
        return pos;
    }

    /**
     * Sets the value of the pos property.
     * 
     * @param value
     *     allowed object is
     *     {@link SkyPos }
     *     
     * @see #getPos()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPos(SkyPos value) {
        this.pos = value;
    }

    /**
     * the rectangular size of the region that should be 
     *                    used as part of the query to the SIA service.
     * 
     * @return
     *     possible object is
     *     {@link SkySize }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public SkySize getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link SkySize }
     *     
     * @see #getSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSize(SkySize value) {
        this.size = value;
    }

    /**
     * the verbosity level to use where 0 means the bare
     *                    minimum set of columns and 3 means the full set of 
     *                    available columns.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BigInteger getVerb() {
        return verb;
    }

    /**
     * Sets the value of the verb property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getVerb()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setVerb(BigInteger value) {
        this.verb = value;
    }

    /**
     * this value should be in the form of name=value
     *                    pairs delimited with apersands (&).
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getExtras() {
        return extras;
    }

    /**
     * Sets the value of the extras property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getExtras()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setExtras(String value) {
        this.extras = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Query that = ((Query) object);
        {
            SkyPos leftPos;
            leftPos = this.getPos();
            SkyPos rightPos;
            rightPos = that.getPos();
            if (this.pos!= null) {
                if (that.pos!= null) {
                    if (!leftPos.equals(rightPos)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.pos!= null) {
                    return false;
                }
            }
        }
        {
            SkySize leftSize;
            leftSize = this.getSize();
            SkySize rightSize;
            rightSize = that.getSize();
            if (this.size!= null) {
                if (that.size!= null) {
                    if (!leftSize.equals(rightSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.size!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftVerb;
            leftVerb = this.getVerb();
            BigInteger rightVerb;
            rightVerb = that.getVerb();
            if (this.verb!= null) {
                if (that.verb!= null) {
                    if (!leftVerb.equals(rightVerb)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.verb!= null) {
                    return false;
                }
            }
        }
        {
            String leftExtras;
            leftExtras = this.getExtras();
            String rightExtras;
            rightExtras = that.getExtras();
            if (this.extras!= null) {
                if (that.extras!= null) {
                    if (!leftExtras.equals(rightExtras)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.extras!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            SkyPos thePos;
            thePos = this.getPos();
            if (this.pos!= null) {
                currentHashCode += thePos.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SkySize theSize;
            theSize = this.getSize();
            if (this.size!= null) {
                currentHashCode += theSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theVerb;
            theVerb = this.getVerb();
            if (this.verb!= null) {
                currentHashCode += theVerb.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theExtras;
            theExtras = this.getExtras();
            if (this.extras!= null) {
                currentHashCode += theExtras.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            SkyPos thePos;
            thePos = this.getPos();
            strategy.appendField(locator, this, "pos", buffer, thePos, (this.pos!= null));
        }
        {
            SkySize theSize;
            theSize = this.getSize();
            strategy.appendField(locator, this, "size", buffer, theSize, (this.size!= null));
        }
        {
            BigInteger theVerb;
            theVerb = this.getVerb();
            strategy.appendField(locator, this, "verb", buffer, theVerb, (this.verb!= null));
        }
        {
            String theExtras;
            theExtras = this.getExtras();
            strategy.appendField(locator, this, "extras", buffer, theExtras, (this.extras!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Query) {
            final Query target = this;
            final Query leftObject = ((Query) left);
            final Query rightObject = ((Query) right);
            {
                Boolean posShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.pos!= null), (rightObject.pos!= null));
                if (posShouldBeMergedAndSet == Boolean.TRUE) {
                    SkyPos lhsPos;
                    lhsPos = leftObject.getPos();
                    SkyPos rhsPos;
                    rhsPos = rightObject.getPos();
                    SkyPos mergedPos = ((SkyPos) strategy.merge(LocatorUtils.property(leftLocator, "pos", lhsPos), LocatorUtils.property(rightLocator, "pos", rhsPos), lhsPos, rhsPos, (leftObject.pos!= null), (rightObject.pos!= null)));
                    target.setPos(mergedPos);
                } else {
                    if (posShouldBeMergedAndSet == Boolean.FALSE) {
                        target.pos = null;
                    }
                }
            }
            {
                Boolean sizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.size!= null), (rightObject.size!= null));
                if (sizeShouldBeMergedAndSet == Boolean.TRUE) {
                    SkySize lhsSize;
                    lhsSize = leftObject.getSize();
                    SkySize rhsSize;
                    rhsSize = rightObject.getSize();
                    SkySize mergedSize = ((SkySize) strategy.merge(LocatorUtils.property(leftLocator, "size", lhsSize), LocatorUtils.property(rightLocator, "size", rhsSize), lhsSize, rhsSize, (leftObject.size!= null), (rightObject.size!= null)));
                    target.setSize(mergedSize);
                } else {
                    if (sizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.size = null;
                    }
                }
            }
            {
                Boolean verbShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.verb!= null), (rightObject.verb!= null));
                if (verbShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsVerb;
                    lhsVerb = leftObject.getVerb();
                    BigInteger rhsVerb;
                    rhsVerb = rightObject.getVerb();
                    BigInteger mergedVerb = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "verb", lhsVerb), LocatorUtils.property(rightLocator, "verb", rhsVerb), lhsVerb, rhsVerb, (leftObject.verb!= null), (rightObject.verb!= null)));
                    target.setVerb(mergedVerb);
                } else {
                    if (verbShouldBeMergedAndSet == Boolean.FALSE) {
                        target.verb = null;
                    }
                }
            }
            {
                Boolean extrasShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.extras!= null), (rightObject.extras!= null));
                if (extrasShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsExtras;
                    lhsExtras = leftObject.getExtras();
                    String rhsExtras;
                    rhsExtras = rightObject.getExtras();
                    String mergedExtras = ((String) strategy.merge(LocatorUtils.property(leftLocator, "extras", lhsExtras), LocatorUtils.property(rightLocator, "extras", rhsExtras), lhsExtras, rhsExtras, (leftObject.extras!= null), (rightObject.extras!= null)));
                    target.setExtras(mergedExtras);
                } else {
                    if (extrasShouldBeMergedAndSet == Boolean.FALSE) {
                        target.extras = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Query();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query clone() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.pos = ((this.pos == null)?null:this.pos.clone());
        _newObject.size = ((this.size == null)?null:this.size.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.pos = ((this.pos == null)?null:this.pos.createCopy());
        _newObject.size = ((this.size == null)?null:this.size.createCopy());
        _newObject.verb = this.verb;
        _newObject.extras = this.extras;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
            _newObject.pos = ((this.pos == null)?null:this.pos.createCopy(posPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _newObject.size = ((this.size == null)?null:this.size.createCopy(sizePropertyTree, _propertyTreeUse));
        }
        final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
            _newObject.verb = this.verb;
        }
        final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
            _newObject.extras = this.extras;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Query.Modifier();
        }
        return ((Query.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other) {
        _other.pos = ((this.pos == null)?null:this.pos.newCopyBuilder(_other));
        _other.size = ((this.size == null)?null:this.size.newCopyBuilder(_other));
        _other.verb = this.verb;
        _other.extras = this.extras;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Query.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> builder() {
        return new Query.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
            _other.pos = ((this.pos == null)?null:this.pos.newCopyBuilder(_other, posPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _other.size = ((this.size == null)?null:this.size.newCopyBuilder(_other, sizePropertyTree, _propertyTreeUse));
        }
        final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
            _other.verb = this.verb;
        }
        final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
            _other.extras = this.extras;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Query.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyExcept(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyOnly(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new SingleProperty<>(Query.PropInfo.POS, this))&&(this.pos!= null)) {
            this.pos.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Query.PropInfo.SIZE, this))&&(this.size!= null)) {
            this.size.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.VERB, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.EXTRAS, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Query _storedValue;
        private SkyPos.Builder<Query.Builder<_B>> pos;
        private SkySize.Builder<Query.Builder<_B>> size;
        private BigInteger verb;
        private String extras;

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.pos = ((_other.pos == null)?null:_other.pos.newCopyBuilder(this));
                    this.size = ((_other.size == null)?null:_other.size.newCopyBuilder(this));
                    this.verb = _other.verb;
                    this.extras = _other.extras;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
                        this.pos = ((_other.pos == null)?null:_other.pos.newCopyBuilder(this, posPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
                        this.size = ((_other.size == null)?null:_other.size.newCopyBuilder(this, sizePropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree verbPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("verb"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(verbPropertyTree!= null):((verbPropertyTree == null)||(!verbPropertyTree.isLeaf())))) {
                        this.verb = _other.verb;
                    }
                    final PropertyTree extrasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extras"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extrasPropertyTree!= null):((extrasPropertyTree == null)||(!extrasPropertyTree.isLeaf())))) {
                        this.extras = _other.extras;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Query >_P init(final _P _product) {
            _product.pos = ((this.pos == null)?null:this.pos.build());
            _product.size = ((this.size == null)?null:this.size.build());
            _product.verb = this.verb;
            _product.extras = this.extras;
            return _product;
        }

        /**
         * Sets the new value of "pos" (any previous value will be replaced)
         * 
         * @param pos
         *     New value of the "pos" property.
         */
        public Query.Builder<_B> withPos(final SkyPos pos) {
            this.pos = ((pos == null)?null:new SkyPos.Builder<>(this, pos, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "pos"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.sia.SkyPos.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "pos" property.
         *     Use {@link org.javastro.ivoa.entities.resource.sia.SkyPos.Builder#end()} to
         *     return to the current builder.
         */
        public SkyPos.Builder<? extends Query.Builder<_B>> withPos() {
            if (this.pos!= null) {
                return this.pos;
            }
            return this.pos = new SkyPos.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "size" (any previous value will be replaced)
         * 
         * @param size
         *     New value of the "size" property.
         */
        public Query.Builder<_B> withSize(final SkySize size) {
            this.size = ((size == null)?null:new SkySize.Builder<>(this, size, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "size"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "size" property.
         *     Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         *     return to the current builder.
         */
        public SkySize.Builder<? extends Query.Builder<_B>> withSize() {
            if (this.size!= null) {
                return this.size;
            }
            return this.size = new SkySize.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "verb" (any previous value will be replaced)
         * 
         * @param verb
         *     New value of the "verb" property.
         */
        public Query.Builder<_B> withVerb(final BigInteger verb) {
            this.verb = verb;
            return this;
        }

        /**
         * Sets the new value of "extras" (any previous value will be replaced)
         * 
         * @param extras
         *     New value of the "extras" property.
         */
        public Query.Builder<_B> withExtras(final String extras) {
            this.extras = extras;
            return this;
        }

        @Override
        public Query build() {
            if (_storedValue == null) {
                return this.init(new Query());
            } else {
                return ((Query) _storedValue);
            }
        }

        public Query.Builder<_B> copyOf(final Query _other) {
            _other.copyTo(this);
            return this;
        }

        public Query.Builder<_B> copyOf(final Query.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setPos(final SkyPos pos) {
            Query.this.setPos(pos);
        }

        public void setSize(final SkySize size) {
            Query.this.setSize(size);
        }

        public void setVerb(final BigInteger verb) {
            Query.this.setVerb(verb);
        }

        public void setExtras(final String extras) {
            Query.this.setExtras(extras);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Query, SkyPos> POS = new SinglePropertyInfo<Query,SkyPos>("pos", Query.class, SkyPos.class, false, null, new QName("", "pos"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "SkyPos"), false) {


            @Override
            public SkyPos get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.pos);
            }

            @Override
            public void set(final Query _instance_, final SkyPos _value_) {
                if (_instance_!= null) {
                    _instance_.pos = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, SkySize> SIZE = new SinglePropertyInfo<Query,SkySize>("size", Query.class, SkySize.class, false, null, new QName("", "size"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "SkySize"), false) {


            @Override
            public SkySize get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.size);
            }

            @Override
            public void set(final Query _instance_, final SkySize _value_) {
                if (_instance_!= null) {
                    _instance_.size = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, BigInteger> VERB = new SinglePropertyInfo<Query,BigInteger>("verb", Query.class, BigInteger.class, false, null, new QName("", "verb"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.verb);
            }

            @Override
            public void set(final Query _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.verb = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, String> EXTRAS = new SinglePropertyInfo<Query,String>("extras", Query.class, String.class, false, null, new QName("", "extras"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.extras);
            }

            @Override
            public void set(final Query _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.extras = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Query.Selector<Query.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Query.Select _root() {
            return new Query.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private SkyPos.Selector<TRoot, Query.Selector<TRoot, TParent>> pos = null;
        private SkySize.Selector<TRoot, Query.Selector<TRoot, TParent>> size = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> verb = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> extras = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.pos!= null) {
                products.put("pos", this.pos.init());
            }
            if (this.size!= null) {
                products.put("size", this.size.init());
            }
            if (this.verb!= null) {
                products.put("verb", this.verb.init());
            }
            if (this.extras!= null) {
                products.put("extras", this.extras.init());
            }
            return products;
        }

        public SkyPos.Selector<TRoot, Query.Selector<TRoot, TParent>> pos() {
            return ((this.pos == null)?this.pos = new SkyPos.Selector<>(this._root, this, "pos"):this.pos);
        }

        public SkySize.Selector<TRoot, Query.Selector<TRoot, TParent>> size() {
            return ((this.size == null)?this.size = new SkySize.Selector<>(this._root, this, "size"):this.size);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> verb() {
            return ((this.verb == null)?this.verb = new com.kscs.util.jaxb.Selector<>(this._root, this, "verb"):this.verb);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> extras() {
            return ((this.extras == null)?this.extras = new com.kscs.util.jaxb.Selector<>(this._root, this, "extras"):this.extras);
        }

    }

}
