
package org.javastro.ivoa.entities.resource.ssap;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * 
 * 
 * <p>Java class for CreationType</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="CreationType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="archival"/>
 *     <enumeration value="cutout"/>
 *     <enumeration value="filtered"/>
 *     <enumeration value="mosaic"/>
 *     <enumeration value="projection"/>
 *     <enumeration value="spectralExtraction"/>
 *     <enumeration value="catalogExtraction"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "CreationType")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum CreationType implements EnumValue<String>
{


    /**
     * The entire archival or project dataset is returned.
     *                   Transformations such as metadata or data model mediation
     *                   or format conversions may take place, but the content of 
     *                   the dataset is not substantially modified (e.g., all the 
     *                   data is returned and the sample values are not modified).
     * 
     */
    @XmlEnumValue("archival")
    ARCHIVAL("archival"),

    /**
     * The dataset is subsetted in some region of parameter 
     *                   space to produce a subset dataset. Sample values are not 
     *                   modified, e.g., cutouts could be recombined to reconstitute 
     *                   the original dataset.
     * 
     */
    @XmlEnumValue("cutout")
    CUTOUT("cutout"),

    /**
     * Filtering is often 
     *                   combined with other forms of processing, e.g., projection.
     * 
     */
    @XmlEnumValue("filtered")
    FILTERED("filtered"),

    /**
     * Data from multiple non- or partially-overlapping datasets 
     *                   are combined to produce a new dataset.
     * 
     */
    @XmlEnumValue("mosaic")
    MOSAIC("mosaic"),

    /**
     * Data is geometrically warped or dimensionally reduced by
     *                   projecting through a multidimensional dataset.
     * 
     */
    @XmlEnumValue("projection")
    PROJECTION("projection"),

    /**
     * Extraction of a spectrum from another dataset, e.g.,
     *                   extraction of a spectrum from a spectral data cube 
     *                   through a simulated aperture.
     * 
     */
    @XmlEnumValue("spectralExtraction")
    SPECTRAL_EXTRACTION("spectralExtraction"),

    /**
     * Extraction of a catalog of some form from another dataset,
     *                   e.g., extraction of a source catalog from an image, or
     *                   extraction of a line list catalog from a spectrum (not 
     *                   valid for a SSA service).
     * 
     */
    @XmlEnumValue("catalogExtraction")
    CATALOG_EXTRACTION("catalogExtraction");
    private final String value;

    CreationType(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static CreationType fromValue(String v) {
        for (CreationType c: CreationType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
