
package org.javastro.ivoa.entities.resource.ssap;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * The defined categories that specify where the spectral data 
 *            originally came from.
 * 
 * <p>Java class for DataSource</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="DataSource">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="survey"/>
 *     <enumeration value="pointed"/>
 *     <enumeration value="custom"/>
 *     <enumeration value="theory"/>
 *     <enumeration value="artificial"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "DataSource")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum DataSource implements EnumValue<String>
{


    /**
     * A survey dataset, which typically covers some region of 
     *                   observational parameter space in a uniform fashion, with 
     *                   as complete as possible coverage in the region of parameter 
     *                   space observed.
     * 
     */
    @XmlEnumValue("survey")
    SURVEY("survey"),

    /**
     * Typically, these are instrumental observations taken as 
     *                   part of some PI observing program. The data quality and 
     *                   characteristics may be variable, but the observations of 
     *                   a particular object or field may be more extensive than 
     *                   for a survey.
     * 
     */
    @XmlEnumValue("pointed")
    POINTED("pointed"),

    /**
     * Data which has been custom processed, e.g., as part of 
     *                   a specific research project.
     * 
     */
    @XmlEnumValue("custom")
    CUSTOM("custom"),

    /**
     * Theory data, or any data generated from a theoretical 
     *                   model, for example a synthetic spectrum.
     * 
     */
    @XmlEnumValue("theory")
    THEORY("theory"),

    /**
     * This is similar to theory data but need not be based on 
     *                   a physical model, and is often used for testing purposes.
     * 
     */
    @XmlEnumValue("artificial")
    ARTIFICIAL("artificial");
    private final String value;

    DataSource(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static DataSource fromValue(String v) {
        for (DataSource c: DataSource.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
