
package org.javastro.ivoa.entities.resource.ssap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * a position in the sky to search.
 * 
 * <p>Java class for PosParam complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PosParam">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="long" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="lat" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="refframe" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PosParam", propOrder = {
    "_long",
    "lat",
    "refframe"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class PosParam implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The longitude (e.g. Right Ascension) of the center of the
     *                   search position in decimal degrees.
     * 
     */
    @XmlElement(name = "long")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected double _long;
    /**
     * The latitude (e.g. Declination) of the center of the
     *                   search position in decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected double lat;
    /**
     * the coordinate system reference frame name indicating
     *                   the frame to assume for the given position.   If not 
     *                   provided, ICRS is assumed.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String refframe;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient PosParam.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public PosParam() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public PosParam(final double _long, final double lat, final String refframe) {
        this._long = _long;
        this.lat = lat;
        this.refframe = refframe;
    }

    /**
     * The longitude (e.g. Right Ascension) of the center of the
     *                   search position in decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public double getLong() {
        return _long;
    }

    /**
     * Sets the value of the long property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setLong(double value) {
        this._long = value;
    }

    /**
     * The latitude (e.g. Declination) of the center of the
     *                   search position in decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public double getLat() {
        return lat;
    }

    /**
     * Sets the value of the lat property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setLat(double value) {
        this.lat = value;
    }

    /**
     * the coordinate system reference frame name indicating
     *                   the frame to assume for the given position.   If not 
     *                   provided, ICRS is assumed.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getRefframe() {
        return refframe;
    }

    /**
     * Sets the value of the refframe property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getRefframe()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRefframe(String value) {
        this.refframe = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final PosParam that = ((PosParam) object);
        {
            double leftLong;
            leftLong = this.getLong();
            double rightLong;
            rightLong = that.getLong();
            if (Double.doubleToLongBits(leftLong)!= Double.doubleToLongBits(rightLong)) {
                return false;
            }
        }
        {
            double leftLat;
            leftLat = this.getLat();
            double rightLat;
            rightLat = that.getLat();
            if (Double.doubleToLongBits(leftLat)!= Double.doubleToLongBits(rightLat)) {
                return false;
            }
        }
        {
            String leftRefframe;
            leftRefframe = this.getRefframe();
            String rightRefframe;
            rightRefframe = that.getRefframe();
            if (this.refframe!= null) {
                if (that.refframe!= null) {
                    if (!leftRefframe.equals(rightRefframe)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.refframe!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            double theLong;
            theLong = this.getLong();
            final long theLongBits = Double.doubleToLongBits(theLong);
            currentHashCode += ((int)(theLongBits^(theLongBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theLat;
            theLat = this.getLat();
            final long theLatBits = Double.doubleToLongBits(theLat);
            currentHashCode += ((int)(theLatBits^(theLatBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRefframe;
            theRefframe = this.getRefframe();
            if (this.refframe!= null) {
                currentHashCode += theRefframe.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            double theLong;
            theLong = this.getLong();
            strategy.appendField(locator, this, "_long", buffer, theLong, true);
        }
        {
            double theLat;
            theLat = this.getLat();
            strategy.appendField(locator, this, "lat", buffer, theLat, true);
        }
        {
            String theRefframe;
            theRefframe = this.getRefframe();
            strategy.appendField(locator, this, "refframe", buffer, theRefframe, (this.refframe!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof PosParam) {
            final PosParam target = this;
            final PosParam leftObject = ((PosParam) left);
            final PosParam rightObject = ((PosParam) right);
            {
                Boolean _longShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (_longShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsLong;
                    lhsLong = leftObject.getLong();
                    double rhsLong;
                    rhsLong = rightObject.getLong();
                    double mergedLong = ((double) strategy.merge(LocatorUtils.property(leftLocator, "_long", lhsLong), LocatorUtils.property(rightLocator, "_long", rhsLong), lhsLong, rhsLong, true, true));
                    target.setLong(mergedLong);
                } else {
                    if (_longShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean latShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (latShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsLat;
                    lhsLat = leftObject.getLat();
                    double rhsLat;
                    rhsLat = rightObject.getLat();
                    double mergedLat = ((double) strategy.merge(LocatorUtils.property(leftLocator, "lat", lhsLat), LocatorUtils.property(rightLocator, "lat", rhsLat), lhsLat, rhsLat, true, true));
                    target.setLat(mergedLat);
                } else {
                    if (latShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean refframeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.refframe!= null), (rightObject.refframe!= null));
                if (refframeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsRefframe;
                    lhsRefframe = leftObject.getRefframe();
                    String rhsRefframe;
                    rhsRefframe = rightObject.getRefframe();
                    String mergedRefframe = ((String) strategy.merge(LocatorUtils.property(leftLocator, "refframe", lhsRefframe), LocatorUtils.property(rightLocator, "refframe", rhsRefframe), lhsRefframe, rhsRefframe, (leftObject.refframe!= null), (rightObject.refframe!= null)));
                    target.setRefframe(mergedRefframe);
                } else {
                    if (refframeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.refframe = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new PosParam();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam clone() {
        final PosParam _newObject;
        try {
            _newObject = ((PosParam) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam createCopy() {
        final PosParam _newObject;
        try {
            _newObject = ((PosParam) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject._long = this._long;
        _newObject.lat = this.lat;
        _newObject.refframe = this.refframe;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PosParam _newObject;
        try {
            _newObject = ((PosParam) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
            _newObject._long = this._long;
        }
        final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
            _newObject.lat = this.lat;
        }
        final PropertyTree refframePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refframe"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refframePropertyTree!= null):((refframePropertyTree == null)||(!refframePropertyTree.isLeaf())))) {
            _newObject.refframe = this.refframe;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new PosParam.Modifier();
        }
        return ((PosParam.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final PosParam.Builder<_B> _other) {
        _other._long = this._long;
        _other.lat = this.lat;
        _other.refframe = this.refframe;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >PosParam.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new PosParam.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static PosParam.Builder<Void> builder() {
        return new PosParam.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >PosParam.Builder<_B> copyOf(final PosParam _other) {
        final PosParam.Builder<_B> _newBuilder = new PosParam.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final PosParam.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
            _other._long = this._long;
        }
        final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
            _other.lat = this.lat;
        }
        final PropertyTree refframePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refframe"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refframePropertyTree!= null):((refframePropertyTree == null)||(!refframePropertyTree.isLeaf())))) {
            _other.refframe = this.refframe;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >PosParam.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new PosParam.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >PosParam.Builder<_B> copyOf(final PosParam _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PosParam.Builder<_B> _newBuilder = new PosParam.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static PosParam.Builder<Void> copyExcept(final PosParam _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static PosParam.Builder<Void> copyOnly(final PosParam _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(PosParam.PropInfo.LONG, this));
        _visitor_.visit(new SingleProperty<>(PosParam.PropInfo.LAT, this));
        _visitor_.visit(new SingleProperty<>(PosParam.PropInfo.REFFRAME, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final PosParam _storedValue;
        private double _long;
        private double lat;
        private String refframe;

        public Builder(final _B _parentBuilder, final PosParam _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this._long = _other._long;
                    this.lat = _other.lat;
                    this.refframe = _other.refframe;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final PosParam _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
                        this._long = _other._long;
                    }
                    final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
                        this.lat = _other.lat;
                    }
                    final PropertyTree refframePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("refframe"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(refframePropertyTree!= null):((refframePropertyTree == null)||(!refframePropertyTree.isLeaf())))) {
                        this.refframe = _other.refframe;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends PosParam >_P init(final _P _product) {
            _product._long = this._long;
            _product.lat = this.lat;
            _product.refframe = this.refframe;
            return _product;
        }

        /**
         * Sets the new value of "_long" (any previous value will be replaced)
         * 
         * @param _long
         *     New value of the "_long" property.
         */
        public PosParam.Builder<_B> withLong(final double _long) {
            this._long = _long;
            return this;
        }

        /**
         * Sets the new value of "lat" (any previous value will be replaced)
         * 
         * @param lat
         *     New value of the "lat" property.
         */
        public PosParam.Builder<_B> withLat(final double lat) {
            this.lat = lat;
            return this;
        }

        /**
         * Sets the new value of "refframe" (any previous value will be replaced)
         * 
         * @param refframe
         *     New value of the "refframe" property.
         */
        public PosParam.Builder<_B> withRefframe(final String refframe) {
            this.refframe = refframe;
            return this;
        }

        @Override
        public PosParam build() {
            if (_storedValue == null) {
                return this.init(new PosParam());
            } else {
                return ((PosParam) _storedValue);
            }
        }

        public PosParam.Builder<_B> copyOf(final PosParam _other) {
            _other.copyTo(this);
            return this;
        }

        public PosParam.Builder<_B> copyOf(final PosParam.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setLong(final double _long) {
            PosParam.this.setLong(_long);
        }

        public void setLat(final double lat) {
            PosParam.this.setLat(lat);
        }

        public void setRefframe(final String refframe) {
            PosParam.this.setRefframe(refframe);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<PosParam, Double> LONG = new SinglePropertyInfo<PosParam,Double>("_long", PosParam.class, Double.class, false, null, new QName("", "long"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final PosParam _instance_) {
                return ((_instance_ == null)?null:_instance_._long);
            }

            @Override
            public void set(final PosParam _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_._long = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PosParam, Double> LAT = new SinglePropertyInfo<PosParam,Double>("lat", PosParam.class, Double.class, false, null, new QName("", "lat"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final PosParam _instance_) {
                return ((_instance_ == null)?null:_instance_.lat);
            }

            @Override
            public void set(final PosParam _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.lat = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<PosParam, String> REFFRAME = new SinglePropertyInfo<PosParam,String>("refframe", PosParam.class, String.class, false, null, new QName("", "refframe"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final PosParam _instance_) {
                return ((_instance_ == null)?null:_instance_.refframe);
            }

            @Override
            public void set(final PosParam _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.refframe = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends PosParam.Selector<PosParam.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static PosParam.Select _root() {
            return new PosParam.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, PosParam.Selector<TRoot, TParent>> refframe = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.refframe!= null) {
                products.put("refframe", this.refframe.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, PosParam.Selector<TRoot, TParent>> refframe() {
            return ((this.refframe == null)?this.refframe = new com.kscs.util.jaxb.Selector<>(this._root, this, "refframe"):this.refframe);
        }

    }

}
