
package org.javastro.ivoa.entities.resource.ssap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A query to be sent to the service
 * 
 * <p>Java class for Query complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Query">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="pos" type="{http://www.ivoa.net/xml/SSA/v1.1}PosParam" minOccurs="0"/>
 *         <element name="size" type="{http://www.w3.org/2001/XMLSchema}double" minOccurs="0"/>
 *         <element name="queryDataCmd" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Query", propOrder = {
    "pos",
    "size",
    "queryDataCmd"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Query implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the center position the search cone given in
     *                    decimal degrees.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected PosParam pos;
    /**
     * the size of the search radius.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double size;
    /**
     * This value must be in the form of name=value
     *                    pairs delimited with ampersands (&).  A query
     *                    may then be formed by appending to the base URL the
     *                    request argument, "REQUEST=queryData&", followed
     *                    by the contents of this element.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String queryDataCmd;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected transient Query.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Query() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Query(final PosParam pos, final Double size, final String queryDataCmd) {
        this.pos = pos;
        this.size = size;
        this.queryDataCmd = queryDataCmd;
    }

    /**
     * the center position the search cone given in
     *                    decimal degrees.
     * 
     * @return
     *     possible object is
     *     {@link PosParam }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public PosParam getPos() {
        return pos;
    }

    /**
     * Sets the value of the pos property.
     * 
     * @param value
     *     allowed object is
     *     {@link PosParam }
     *     
     * @see #getPos()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPos(PosParam value) {
        this.pos = value;
    }

    /**
     * the size of the search radius.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     * @see #getSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSize(Double value) {
        this.size = value;
    }

    /**
     * This value must be in the form of name=value
     *                    pairs delimited with ampersands (&).  A query
     *                    may then be formed by appending to the base URL the
     *                    request argument, "REQUEST=queryData&", followed
     *                    by the contents of this element.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getQueryDataCmd() {
        return queryDataCmd;
    }

    /**
     * Sets the value of the queryDataCmd property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getQueryDataCmd()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setQueryDataCmd(String value) {
        this.queryDataCmd = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Query that = ((Query) object);
        {
            PosParam leftPos;
            leftPos = this.getPos();
            PosParam rightPos;
            rightPos = that.getPos();
            if (this.pos!= null) {
                if (that.pos!= null) {
                    if (!leftPos.equals(rightPos)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.pos!= null) {
                    return false;
                }
            }
        }
        {
            Double leftSize;
            leftSize = this.getSize();
            Double rightSize;
            rightSize = that.getSize();
            if (this.size!= null) {
                if (that.size!= null) {
                    if (!leftSize.equals(rightSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.size!= null) {
                    return false;
                }
            }
        }
        {
            String leftQueryDataCmd;
            leftQueryDataCmd = this.getQueryDataCmd();
            String rightQueryDataCmd;
            rightQueryDataCmd = that.getQueryDataCmd();
            if (this.queryDataCmd!= null) {
                if (that.queryDataCmd!= null) {
                    if (!leftQueryDataCmd.equals(rightQueryDataCmd)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.queryDataCmd!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            PosParam thePos;
            thePos = this.getPos();
            if (this.pos!= null) {
                currentHashCode += thePos.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double theSize;
            theSize = this.getSize();
            if (this.size!= null) {
                currentHashCode += theSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theQueryDataCmd;
            theQueryDataCmd = this.getQueryDataCmd();
            if (this.queryDataCmd!= null) {
                currentHashCode += theQueryDataCmd.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            PosParam thePos;
            thePos = this.getPos();
            strategy.appendField(locator, this, "pos", buffer, thePos, (this.pos!= null));
        }
        {
            Double theSize;
            theSize = this.getSize();
            strategy.appendField(locator, this, "size", buffer, theSize, (this.size!= null));
        }
        {
            String theQueryDataCmd;
            theQueryDataCmd = this.getQueryDataCmd();
            strategy.appendField(locator, this, "queryDataCmd", buffer, theQueryDataCmd, (this.queryDataCmd!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Query) {
            final Query target = this;
            final Query leftObject = ((Query) left);
            final Query rightObject = ((Query) right);
            {
                Boolean posShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.pos!= null), (rightObject.pos!= null));
                if (posShouldBeMergedAndSet == Boolean.TRUE) {
                    PosParam lhsPos;
                    lhsPos = leftObject.getPos();
                    PosParam rhsPos;
                    rhsPos = rightObject.getPos();
                    PosParam mergedPos = ((PosParam) strategy.merge(LocatorUtils.property(leftLocator, "pos", lhsPos), LocatorUtils.property(rightLocator, "pos", rhsPos), lhsPos, rhsPos, (leftObject.pos!= null), (rightObject.pos!= null)));
                    target.setPos(mergedPos);
                } else {
                    if (posShouldBeMergedAndSet == Boolean.FALSE) {
                        target.pos = null;
                    }
                }
            }
            {
                Boolean sizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.size!= null), (rightObject.size!= null));
                if (sizeShouldBeMergedAndSet == Boolean.TRUE) {
                    Double lhsSize;
                    lhsSize = leftObject.getSize();
                    Double rhsSize;
                    rhsSize = rightObject.getSize();
                    Double mergedSize = ((Double) strategy.merge(LocatorUtils.property(leftLocator, "size", lhsSize), LocatorUtils.property(rightLocator, "size", rhsSize), lhsSize, rhsSize, (leftObject.size!= null), (rightObject.size!= null)));
                    target.setSize(mergedSize);
                } else {
                    if (sizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.size = null;
                    }
                }
            }
            {
                Boolean queryDataCmdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.queryDataCmd!= null), (rightObject.queryDataCmd!= null));
                if (queryDataCmdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsQueryDataCmd;
                    lhsQueryDataCmd = leftObject.getQueryDataCmd();
                    String rhsQueryDataCmd;
                    rhsQueryDataCmd = rightObject.getQueryDataCmd();
                    String mergedQueryDataCmd = ((String) strategy.merge(LocatorUtils.property(leftLocator, "queryDataCmd", lhsQueryDataCmd), LocatorUtils.property(rightLocator, "queryDataCmd", rhsQueryDataCmd), lhsQueryDataCmd, rhsQueryDataCmd, (leftObject.queryDataCmd!= null), (rightObject.queryDataCmd!= null)));
                    target.setQueryDataCmd(mergedQueryDataCmd);
                } else {
                    if (queryDataCmdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.queryDataCmd = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Query();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query clone() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.pos = ((this.pos == null)?null:this.pos.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy() {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.pos = ((this.pos == null)?null:this.pos.createCopy());
        _newObject.size = this.size;
        _newObject.queryDataCmd = this.queryDataCmd;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query _newObject;
        try {
            _newObject = ((Query) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
            _newObject.pos = ((this.pos == null)?null:this.pos.createCopy(posPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _newObject.size = this.size;
        }
        final PropertyTree queryDataCmdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryDataCmd"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryDataCmdPropertyTree!= null):((queryDataCmdPropertyTree == null)||(!queryDataCmdPropertyTree.isLeaf())))) {
            _newObject.queryDataCmd = this.queryDataCmd;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Query.Modifier();
        }
        return ((Query.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other) {
        _other.pos = ((this.pos == null)?null:this.pos.newCopyBuilder(_other));
        _other.size = this.size;
        _other.queryDataCmd = this.queryDataCmd;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Query.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> builder() {
        return new Query.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Query.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
            _other.pos = ((this.pos == null)?null:this.pos.newCopyBuilder(_other, posPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _other.size = this.size;
        }
        final PropertyTree queryDataCmdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryDataCmd"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryDataCmdPropertyTree!= null):((queryDataCmdPropertyTree == null)||(!queryDataCmdPropertyTree.isLeaf())))) {
            _other.queryDataCmd = this.queryDataCmd;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Query.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Query.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Query.Builder<_B> copyOf(final Query _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Query.Builder<_B> _newBuilder = new Query.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyExcept(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Query.Builder<Void> copyOnly(final Query _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Query visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new SingleProperty<>(Query.PropInfo.POS, this))&&(this.pos!= null)) {
            this.pos.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.SIZE, this));
        _visitor_.visit(new SingleProperty<>(Query.PropInfo.QUERY_DATA_CMD, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Query _storedValue;
        private PosParam.Builder<Query.Builder<_B>> pos;
        private Double size;
        private String queryDataCmd;

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.pos = ((_other.pos == null)?null:_other.pos.newCopyBuilder(this));
                    this.size = _other.size;
                    this.queryDataCmd = _other.queryDataCmd;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Query _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree posPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pos"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(posPropertyTree!= null):((posPropertyTree == null)||(!posPropertyTree.isLeaf())))) {
                        this.pos = ((_other.pos == null)?null:_other.pos.newCopyBuilder(this, posPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
                        this.size = _other.size;
                    }
                    final PropertyTree queryDataCmdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryDataCmd"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryDataCmdPropertyTree!= null):((queryDataCmdPropertyTree == null)||(!queryDataCmdPropertyTree.isLeaf())))) {
                        this.queryDataCmd = _other.queryDataCmd;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Query >_P init(final _P _product) {
            _product.pos = ((this.pos == null)?null:this.pos.build());
            _product.size = this.size;
            _product.queryDataCmd = this.queryDataCmd;
            return _product;
        }

        /**
         * Sets the new value of "pos" (any previous value will be replaced)
         * 
         * @param pos
         *     New value of the "pos" property.
         */
        public Query.Builder<_B> withPos(final PosParam pos) {
            this.pos = ((pos == null)?null:new PosParam.Builder<>(this, pos, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "pos"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.ssap.PosParam.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "pos" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ssap.PosParam.Builder#end()} to
         *     return to the current builder.
         */
        public PosParam.Builder<? extends Query.Builder<_B>> withPos() {
            if (this.pos!= null) {
                return this.pos;
            }
            return this.pos = new PosParam.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "size" (any previous value will be replaced)
         * 
         * @param size
         *     New value of the "size" property.
         */
        public Query.Builder<_B> withSize(final Double size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the new value of "queryDataCmd" (any previous value will be replaced)
         * 
         * @param queryDataCmd
         *     New value of the "queryDataCmd" property.
         */
        public Query.Builder<_B> withQueryDataCmd(final String queryDataCmd) {
            this.queryDataCmd = queryDataCmd;
            return this;
        }

        @Override
        public Query build() {
            if (_storedValue == null) {
                return this.init(new Query());
            } else {
                return ((Query) _storedValue);
            }
        }

        public Query.Builder<_B> copyOf(final Query _other) {
            _other.copyTo(this);
            return this;
        }

        public Query.Builder<_B> copyOf(final Query.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setPos(final PosParam pos) {
            Query.this.setPos(pos);
        }

        public void setSize(final Double size) {
            Query.this.setSize(size);
        }

        public void setQueryDataCmd(final String queryDataCmd) {
            Query.this.setQueryDataCmd(queryDataCmd);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Query, PosParam> POS = new SinglePropertyInfo<Query,PosParam>("pos", Query.class, PosParam.class, false, null, new QName("", "pos"), new QName("http://www.ivoa.net/xml/SSA/v1.1", "PosParam"), false) {


            @Override
            public PosParam get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.pos);
            }

            @Override
            public void set(final Query _instance_, final PosParam _value_) {
                if (_instance_!= null) {
                    _instance_.pos = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, Double> SIZE = new SinglePropertyInfo<Query,Double>("size", Query.class, Double.class, false, null, new QName("", "size"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.size);
            }

            @Override
            public void set(final Query _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.size = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Query, String> QUERY_DATA_CMD = new SinglePropertyInfo<Query,String>("queryDataCmd", Query.class, String.class, false, null, new QName("", "queryDataCmd"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final Query _instance_) {
                return ((_instance_ == null)?null:_instance_.queryDataCmd);
            }

            @Override
            public void set(final Query _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.queryDataCmd = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Query.Selector<Query.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Query.Select _root() {
            return new Query.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private PosParam.Selector<TRoot, Query.Selector<TRoot, TParent>> pos = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> size = null;
        private com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> queryDataCmd = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.pos!= null) {
                products.put("pos", this.pos.init());
            }
            if (this.size!= null) {
                products.put("size", this.size.init());
            }
            if (this.queryDataCmd!= null) {
                products.put("queryDataCmd", this.queryDataCmd.init());
            }
            return products;
        }

        public PosParam.Selector<TRoot, Query.Selector<TRoot, TParent>> pos() {
            return ((this.pos == null)?this.pos = new PosParam.Selector<>(this._root, this, "pos"):this.pos);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> size() {
            return ((this.size == null)?this.size = new com.kscs.util.jaxb.Selector<>(this._root, this, "size"):this.size);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Query.Selector<TRoot, TParent>> queryDataCmd() {
            return ((this.queryDataCmd == null)?this.queryDataCmd = new com.kscs.util.jaxb.Selector<>(this._root, this, "queryDataCmd"):this.queryDataCmd);
        }

    }

}
