
package org.javastro.ivoa.entities.resource.ssap;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * A controlled list of space-time reference frame names
 *           defined from Table 3 (S 4.4.1.2.3) of the STC spec.
 * 
 * <p>Java class for SupportedFrame</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="SupportedFrame">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="FK4"/>
 *     <enumeration value="FK5"/>
 *     <enumeration value="ECLIPTIC"/>
 *     <enumeration value="ICRS"/>
 *     <enumeration value="GALACTIC_I"/>
 *     <enumeration value="GALACTIC_II"/>
 *     <enumeration value="SUPER_GALACTIC"/>
 *     <enumeration value="AZ_EL"/>
 *     <enumeration value="BODY"/>
 *     <enumeration value="GEO_C"/>
 *     <enumeration value="GEO_D"/>
 *     <enumeration value="MAG"/>
 *     <enumeration value="GSE"/>
 *     <enumeration value="GSM"/>
 *     <enumeration value="HGC"/>
 *     <enumeration value="HGS"/>
 *     <enumeration value="HEEQ"/>
 *     <enumeration value="HRTN"/>
 *     <enumeration value="HPC"/>
 *     <enumeration value="HPR"/>
 *     <enumeration value="HCC"/>
 *     <enumeration value="HGI"/>
 *     <enumeration value="MERCURY_C"/>
 *     <enumeration value="VENUS_C"/>
 *     <enumeration value="LUNA_C"/>
 *     <enumeration value="MARS_C"/>
 *     <enumeration value="JUPITER_C_III"/>
 *     <enumeration value="SATURN_C_III"/>
 *     <enumeration value="URANUS_C_III"/>
 *     <enumeration value="NEPTUNE_C_III"/>
 *     <enumeration value="PLUTO_C"/>
 *     <enumeration value="MERCURY_G"/>
 *     <enumeration value="VENUS_G"/>
 *     <enumeration value="LUNA_G"/>
 *     <enumeration value="MARS_G"/>
 *     <enumeration value="JUPITER_G_III"/>
 *     <enumeration value="SATURN_G_III"/>
 *     <enumeration value="URANUS_G_III"/>
 *     <enumeration value="NEPTUNE_G_III"/>
 *     <enumeration value="PLUTO_G"/>
 *     <enumeration value="UNKNOWN"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SupportedFrame")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public enum SupportedFrame implements EnumValue<String>
{


    /**
     * Spectrum data files will require a specification of
     *                   the equinox; if it is not expressed explicitly,
     *                   B1950.0 should be assumed.
     * 
     */
    @XmlEnumValue("FK4")
    FK_4("FK4"),

    /**
     * Spectrum data files will require a specification of
     *                   the equinox; if it is not expressed explicitly,
     *                   J2000.0 should be assumed.
     * 
     */
    @XmlEnumValue("FK5")
    FK_5("FK5"),

    /**
     * Ecliptic coordinates
     * 
     */
    ECLIPTIC("ECLIPTIC"),

    /**
     * International Celestial Reference System
     * 
     */
    ICRS("ICRS"),

    /**
     * old Galactic coordinates
     * 
     */
    GALACTIC_I("GALACTIC_I"),

    /**
     * old Galactic coordinates
     * 
     */
    GALACTIC_II("GALACTIC_II"),

    /**
     * Super-galactic coordinates with the north pole at
     *                   GALACTIC_II (47.37, +6.32) and the origin at 
     *                   GALACTIC_II (137.37, 0).
     * 
     */
    SUPER_GALACTIC("SUPER_GALACTIC"),

    /**
     * The local azimuth and elevation frame where azimuth 
     *                   increases from north through east.
     * 
     */
    AZ_EL("AZ_EL"),

    /**
     * If applicable, queries against this system should assume a 
     *                   default magnitude value or range in the absence of an 
     *                   applicable (non-standard) query constraint.  Service 
     *                   providers are encouraged to document the such assumptions 
     *                   in the resource or capability description.
     * 
     */
    BODY("BODY"),

    /**
     * If applicable, queries against this system should assume a 
     *                   default magnitude value or range in the absence of an 
     *                   applicable (non-standard) query constraint.  Service 
     *                   providers are encouraged to document the such assumptions 
     *                   in the resource or capability description.
     * 
     */
    GEO_C("GEO_C"),

    /**
     * Semi-major axis and inverse flattening of the
     *                   reference spheroid may need to be assumed; a 
     *                   default as defined by the IAU 1976 is recommended.
     * 
     */
    GEO_D("GEO_D"),

    /**
     * If applicable, queries against this system should assume a 
     *                   default magnitude value or range in the absence of an 
     *                   applicable (non-standard) query constraint.  Service 
     *                   providers are encouraged to document the such assumptions 
     *                   in the resource or capability description.
     * 
     */
    MAG("MAG"),

    /**
     * See Franz and Harper 2002, Planetary and Space
     *                   Science, vol 50, p. 217.
     * 
     */
    GSE("GSE"),

    /**
     * See Franz and Harper 2002, Planetary and Space
     *                   Science, vol 50, p. 217.
     * 
     */
    GSM("GSM"),

    /**
     * See Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.2
     * 
     */
    HGC("HGC"),

    /**
     * See Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.2
     * 
     */
    HGS("HGS"),

    /**
     * See Franz and Harper 2002, Planetary and Space
     *                   Science, vol 50, p. 217, and 
     *                   Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.1
     * 
     */
    HEEQ("HEEQ"),

    /**
     * See Franz and Harper 2002, Planetary and Space
     *                   Science, vol 50, p. 217.
     * 
     */
    HRTN("HRTN"),

    /**
     * See Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.1
     * 
     */
    HPC("HPC"),

    /**
     * See Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.1
     * 
     */
    HPR("HPR"),

    /**
     * See Thompson 2006, "Coordinate Systems for Solar
     *                   Image Data", A&A., Section 2.1
     * 
     */
    HCC("HCC"),

    /**
     * See Franz and Harper 2002, Planetary and Space
     *                   Science, vol 50, p. 217.
     * 
     */
    HGI("HGI"),

    /**
     * Planteocentric coordinates on Mercury
     * 
     */
    MERCURY_C("MERCURY_C"),

    /**
     * Planteocentric coordinates on Venus
     * 
     */
    VENUS_C("VENUS_C"),

    /**
     * Selenocentric coordinates (for the Moon)
     * 
     */
    LUNA_C("LUNA_C"),

    /**
     * Planteocentric coordinates on Mars
     * 
     */
    MARS_C("MARS_C"),

    /**
     * Planteocentric coordinates on Jupiter, system III
     * 
     */
    JUPITER_C_III("JUPITER_C_III"),

    /**
     * Planteocentric coordinates on Saturn, system III
     * 
     */
    SATURN_C_III("SATURN_C_III"),

    /**
     * Planteocentric coordinates on Uranus, system III
     * 
     */
    URANUS_C_III("URANUS_C_III"),

    /**
     * Planteocentric coordinates on Neptune, system III
     * 
     */
    NEPTUNE_C_III("NEPTUNE_C_III"),

    /**
     * Planteocentric coordinates on Mercury
     * 
     */
    PLUTO_C("PLUTO_C"),

    /**
     * Planteographic coordinates on Mercury
     * 
     */
    MERCURY_G("MERCURY_G"),

    /**
     * Planteographic coordinates on Venus
     * 
     */
    VENUS_G("VENUS_G"),

    /**
     * Selenographic coordinates (for the Moon)
     * 
     */
    LUNA_G("LUNA_G"),

    /**
     * Planteographic coordinates on Mars
     * 
     */
    MARS_G("MARS_G"),

    /**
     * Planteographic coordinates on Jupiter, system III
     * 
     */
    JUPITER_G_III("JUPITER_G_III"),

    /**
     * Planteographic coordinates on Saturn, system III
     * 
     */
    SATURN_G_III("SATURN_G_III"),

    /**
     * Planteographic coordinates on Uranus, system III
     * 
     */
    URANUS_G_III("URANUS_G_III"),

    /**
     * Planteographic coordinates on Neptune, system III
     * 
     */
    NEPTUNE_G_III("NEPTUNE_G_III"),

    /**
     * Planteographic coordinates on Mercury
     * 
     */
    PLUTO_G("PLUTO_G"),

    /**
     * Any available descriptive details should be
     *                   given (or referenced) in the capability's description.
     * 
     */
    UNKNOWN("UNKNOWN");
    private final String value;

    SupportedFrame(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static SupportedFrame fromValue(String v) {
        for (SupportedFrame c: SupportedFrame.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
