
package org.javastro.ivoa.entities.resource.standard;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * This typically refers to an IVOA standard but is not
 *            limited to such.
 * 
 * <p>Java class for Standard complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Standard">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Resource">
 *       <sequence>
 *         <element name="endorsedVersion" type="{http://www.ivoa.net/xml/StandardsRegExt/v1.0}EndorsedVersion" maxOccurs="unbounded"/>
 *         <element name="schema" type="{http://www.ivoa.net/xml/StandardsRegExt/v1.0}Schema" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="deprecated" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="key" type="{http://www.ivoa.net/xml/StandardsRegExt/v1.0}StandardKey" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Standard", propOrder = {
    "endorsedVersions",
    "schemas",
    "deprecated",
    "keies"
})
@XmlSeeAlso({
    ServiceStandard.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class Standard
    extends Resource
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * More than one version can be listed, indicating
     *                      that any of these versions are recognized as
     *                      acceptable for use.
     * 
     */
    @XmlElement(name = "endorsedVersion", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<EndorsedVersion> endorsedVersions;
    /**
     * This is most typically an XML Schema, but it need
     *                      not be strictly.
     * 
     */
    @XmlElement(name = "schema")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<Schema> schemas;
    /**
     * The explanation should indicate if another
     *                      standard should be preferred.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected String deprecated;
    /**
     * a defined key associated with this standard.
     * 
     */
    @XmlElement(name = "key")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<StandardKey> keies;

    /**
     * Default no-arg constructor
     * 
     */
    public Standard() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Standard(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final ZonedDateTime created, final ZonedDateTime updated, final String status, final String version, final List<EndorsedVersion> endorsedVersions, final List<Schema> schemas, final String deprecated, final List<StandardKey> keies) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.endorsedVersions = endorsedVersions;
        this.schemas = schemas;
        this.deprecated = deprecated;
        this.keies = keies;
    }

    /**
     * More than one version can be listed, indicating
     *                      that any of these versions are recognized as
     *                      acceptable for use.
     * 
     * Gets the value of the endorsedVersions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the endorsedVersions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEndorsedVersions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EndorsedVersion }
     * </p>
     * 
     * 
     * @return
     *     The value of the endorsedVersions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<EndorsedVersion> getEndorsedVersions() {
        if (endorsedVersions == null) {
            endorsedVersions = new ArrayList<>();
        }
        return this.endorsedVersions;
    }

    /**
     * This is most typically an XML Schema, but it need
     *                      not be strictly.
     * 
     * Gets the value of the schemas property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the schemas property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSchemas().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Schema }
     * </p>
     * 
     * 
     * @return
     *     The value of the schemas property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<Schema> getSchemas() {
        if (schemas == null) {
            schemas = new ArrayList<>();
        }
        return this.schemas;
    }

    /**
     * The explanation should indicate if another
     *                      standard should be preferred.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String getDeprecated() {
        return deprecated;
    }

    /**
     * Sets the value of the deprecated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDeprecated()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setDeprecated(String value) {
        this.deprecated = value;
    }

    /**
     * a defined key associated with this standard.
     * 
     * Gets the value of the keies property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the keies property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getKeies().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link StandardKey }
     * </p>
     * 
     * 
     * @return
     *     The value of the keies property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<StandardKey> getKeies() {
        if (keies == null) {
            keies = new ArrayList<>();
        }
        return this.keies;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Standard that = ((Standard) object);
        {
            List<EndorsedVersion> leftEndorsedVersions;
            leftEndorsedVersions = (((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty()))?this.getEndorsedVersions():null);
            List<EndorsedVersion> rightEndorsedVersions;
            rightEndorsedVersions = (((that.endorsedVersions!= null)&&(!that.endorsedVersions.isEmpty()))?that.getEndorsedVersions():null);
            if ((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty())) {
                if ((that.endorsedVersions!= null)&&(!that.endorsedVersions.isEmpty())) {
                    if (!leftEndorsedVersions.equals(rightEndorsedVersions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.endorsedVersions!= null)&&(!that.endorsedVersions.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Schema> leftSchemas;
            leftSchemas = (((this.schemas!= null)&&(!this.schemas.isEmpty()))?this.getSchemas():null);
            List<Schema> rightSchemas;
            rightSchemas = (((that.schemas!= null)&&(!that.schemas.isEmpty()))?that.getSchemas():null);
            if ((this.schemas!= null)&&(!this.schemas.isEmpty())) {
                if ((that.schemas!= null)&&(!that.schemas.isEmpty())) {
                    if (!leftSchemas.equals(rightSchemas)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.schemas!= null)&&(!that.schemas.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDeprecated;
            leftDeprecated = this.getDeprecated();
            String rightDeprecated;
            rightDeprecated = that.getDeprecated();
            if (this.deprecated!= null) {
                if (that.deprecated!= null) {
                    if (!leftDeprecated.equals(rightDeprecated)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.deprecated!= null) {
                    return false;
                }
            }
        }
        {
            List<StandardKey> leftKeies;
            leftKeies = (((this.keies!= null)&&(!this.keies.isEmpty()))?this.getKeies():null);
            List<StandardKey> rightKeies;
            rightKeies = (((that.keies!= null)&&(!that.keies.isEmpty()))?that.getKeies():null);
            if ((this.keies!= null)&&(!this.keies.isEmpty())) {
                if ((that.keies!= null)&&(!that.keies.isEmpty())) {
                    if (!leftKeies.equals(rightKeies)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.keies!= null)&&(!that.keies.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<EndorsedVersion> theEndorsedVersions;
            theEndorsedVersions = (((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty()))?this.getEndorsedVersions():null);
            if ((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty())) {
                currentHashCode += theEndorsedVersions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Schema> theSchemas;
            theSchemas = (((this.schemas!= null)&&(!this.schemas.isEmpty()))?this.getSchemas():null);
            if ((this.schemas!= null)&&(!this.schemas.isEmpty())) {
                currentHashCode += theSchemas.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDeprecated;
            theDeprecated = this.getDeprecated();
            if (this.deprecated!= null) {
                currentHashCode += theDeprecated.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<StandardKey> theKeies;
            theKeies = (((this.keies!= null)&&(!this.keies.isEmpty()))?this.getKeies():null);
            if ((this.keies!= null)&&(!this.keies.isEmpty())) {
                currentHashCode += theKeies.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<EndorsedVersion> theEndorsedVersions;
            theEndorsedVersions = (((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty()))?this.getEndorsedVersions():null);
            strategy.appendField(locator, this, "endorsedVersions", buffer, theEndorsedVersions, ((this.endorsedVersions!= null)&&(!this.endorsedVersions.isEmpty())));
        }
        {
            List<Schema> theSchemas;
            theSchemas = (((this.schemas!= null)&&(!this.schemas.isEmpty()))?this.getSchemas():null);
            strategy.appendField(locator, this, "schemas", buffer, theSchemas, ((this.schemas!= null)&&(!this.schemas.isEmpty())));
        }
        {
            String theDeprecated;
            theDeprecated = this.getDeprecated();
            strategy.appendField(locator, this, "deprecated", buffer, theDeprecated, (this.deprecated!= null));
        }
        {
            List<StandardKey> theKeies;
            theKeies = (((this.keies!= null)&&(!this.keies.isEmpty()))?this.getKeies():null);
            strategy.appendField(locator, this, "keies", buffer, theKeies, ((this.keies!= null)&&(!this.keies.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Standard) {
            final Standard target = this;
            final Standard leftObject = ((Standard) left);
            final Standard rightObject = ((Standard) right);
            {
                Boolean endorsedVersionsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.endorsedVersions!= null)&&(!leftObject.endorsedVersions.isEmpty())), ((rightObject.endorsedVersions!= null)&&(!rightObject.endorsedVersions.isEmpty())));
                if (endorsedVersionsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<EndorsedVersion> lhsEndorsedVersions;
                    lhsEndorsedVersions = (((leftObject.endorsedVersions!= null)&&(!leftObject.endorsedVersions.isEmpty()))?leftObject.getEndorsedVersions():null);
                    List<EndorsedVersion> rhsEndorsedVersions;
                    rhsEndorsedVersions = (((rightObject.endorsedVersions!= null)&&(!rightObject.endorsedVersions.isEmpty()))?rightObject.getEndorsedVersions():null);
                    List<EndorsedVersion> mergedEndorsedVersions = ((List<EndorsedVersion> ) strategy.merge(LocatorUtils.property(leftLocator, "endorsedVersions", lhsEndorsedVersions), LocatorUtils.property(rightLocator, "endorsedVersions", rhsEndorsedVersions), lhsEndorsedVersions, rhsEndorsedVersions, ((leftObject.endorsedVersions!= null)&&(!leftObject.endorsedVersions.isEmpty())), ((rightObject.endorsedVersions!= null)&&(!rightObject.endorsedVersions.isEmpty()))));
                    target.endorsedVersions = null;
                    if (mergedEndorsedVersions!= null) {
                        List<EndorsedVersion> uniqueEndorsedVersionsl = target.getEndorsedVersions();
                        uniqueEndorsedVersionsl.addAll(mergedEndorsedVersions);
                    }
                } else {
                    if (endorsedVersionsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.endorsedVersions = null;
                    }
                }
            }
            {
                Boolean schemasShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.schemas!= null)&&(!leftObject.schemas.isEmpty())), ((rightObject.schemas!= null)&&(!rightObject.schemas.isEmpty())));
                if (schemasShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Schema> lhsSchemas;
                    lhsSchemas = (((leftObject.schemas!= null)&&(!leftObject.schemas.isEmpty()))?leftObject.getSchemas():null);
                    List<Schema> rhsSchemas;
                    rhsSchemas = (((rightObject.schemas!= null)&&(!rightObject.schemas.isEmpty()))?rightObject.getSchemas():null);
                    List<Schema> mergedSchemas = ((List<Schema> ) strategy.merge(LocatorUtils.property(leftLocator, "schemas", lhsSchemas), LocatorUtils.property(rightLocator, "schemas", rhsSchemas), lhsSchemas, rhsSchemas, ((leftObject.schemas!= null)&&(!leftObject.schemas.isEmpty())), ((rightObject.schemas!= null)&&(!rightObject.schemas.isEmpty()))));
                    target.schemas = null;
                    if (mergedSchemas!= null) {
                        List<Schema> uniqueSchemasl = target.getSchemas();
                        uniqueSchemasl.addAll(mergedSchemas);
                    }
                } else {
                    if (schemasShouldBeMergedAndSet == Boolean.FALSE) {
                        target.schemas = null;
                    }
                }
            }
            {
                Boolean deprecatedShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.deprecated!= null), (rightObject.deprecated!= null));
                if (deprecatedShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDeprecated;
                    lhsDeprecated = leftObject.getDeprecated();
                    String rhsDeprecated;
                    rhsDeprecated = rightObject.getDeprecated();
                    String mergedDeprecated = ((String) strategy.merge(LocatorUtils.property(leftLocator, "deprecated", lhsDeprecated), LocatorUtils.property(rightLocator, "deprecated", rhsDeprecated), lhsDeprecated, rhsDeprecated, (leftObject.deprecated!= null), (rightObject.deprecated!= null)));
                    target.setDeprecated(mergedDeprecated);
                } else {
                    if (deprecatedShouldBeMergedAndSet == Boolean.FALSE) {
                        target.deprecated = null;
                    }
                }
            }
            {
                Boolean keiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.keies!= null)&&(!leftObject.keies.isEmpty())), ((rightObject.keies!= null)&&(!rightObject.keies.isEmpty())));
                if (keiesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<StandardKey> lhsKeies;
                    lhsKeies = (((leftObject.keies!= null)&&(!leftObject.keies.isEmpty()))?leftObject.getKeies():null);
                    List<StandardKey> rhsKeies;
                    rhsKeies = (((rightObject.keies!= null)&&(!rightObject.keies.isEmpty()))?rightObject.getKeies():null);
                    List<StandardKey> mergedKeies = ((List<StandardKey> ) strategy.merge(LocatorUtils.property(leftLocator, "keies", lhsKeies), LocatorUtils.property(rightLocator, "keies", rhsKeies), lhsKeies, rhsKeies, ((leftObject.keies!= null)&&(!leftObject.keies.isEmpty())), ((rightObject.keies!= null)&&(!rightObject.keies.isEmpty()))));
                    target.keies = null;
                    if (mergedKeies!= null) {
                        List<StandardKey> uniqueKeiesl = target.getKeies();
                        uniqueKeiesl.addAll(mergedKeies);
                    }
                } else {
                    if (keiesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.keies = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new Standard();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard clone() {
        final Standard _newObject;
        _newObject = ((Standard) super.clone());
        if (this.endorsedVersions == null) {
            _newObject.endorsedVersions = null;
        } else {
            _newObject.endorsedVersions = new ArrayList<>();
            for (EndorsedVersion _item: this.endorsedVersions) {
                _newObject.endorsedVersions.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.schemas == null) {
            _newObject.schemas = null;
        } else {
            _newObject.schemas = new ArrayList<>();
            for (Schema _item: this.schemas) {
                _newObject.schemas.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.keies == null) {
            _newObject.keies = null;
        } else {
            _newObject.keies = new ArrayList<>();
            for (StandardKey _item: this.keies) {
                _newObject.keies.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard createCopy() {
        final Standard _newObject = ((Standard) super.createCopy());
        if (this.endorsedVersions == null) {
            _newObject.endorsedVersions = null;
        } else {
            _newObject.endorsedVersions = new ArrayList<>();
            for (EndorsedVersion _item: this.endorsedVersions) {
                _newObject.endorsedVersions.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.schemas == null) {
            _newObject.schemas = null;
        } else {
            _newObject.schemas = new ArrayList<>();
            for (Schema _item: this.schemas) {
                _newObject.schemas.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.deprecated = this.deprecated;
        if (this.keies == null) {
            _newObject.keies = null;
        } else {
            _newObject.keies = new ArrayList<>();
            for (StandardKey _item: this.keies) {
                _newObject.keies.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Standard _newObject = ((Standard) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree endorsedVersionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endorsedVersions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endorsedVersionsPropertyTree!= null):((endorsedVersionsPropertyTree == null)||(!endorsedVersionsPropertyTree.isLeaf())))) {
            if (this.endorsedVersions == null) {
                _newObject.endorsedVersions = null;
            } else {
                _newObject.endorsedVersions = new ArrayList<>();
                for (EndorsedVersion _item: this.endorsedVersions) {
                    _newObject.endorsedVersions.add(((_item == null)?null:_item.createCopy(endorsedVersionsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree schemasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemas"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemasPropertyTree!= null):((schemasPropertyTree == null)||(!schemasPropertyTree.isLeaf())))) {
            if (this.schemas == null) {
                _newObject.schemas = null;
            } else {
                _newObject.schemas = new ArrayList<>();
                for (Schema _item: this.schemas) {
                    _newObject.schemas.add(((_item == null)?null:_item.createCopy(schemasPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree deprecatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("deprecated"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(deprecatedPropertyTree!= null):((deprecatedPropertyTree == null)||(!deprecatedPropertyTree.isLeaf())))) {
            _newObject.deprecated = this.deprecated;
        }
        final PropertyTree keiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("keies"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(keiesPropertyTree!= null):((keiesPropertyTree == null)||(!keiesPropertyTree.isLeaf())))) {
            if (this.keies == null) {
                _newObject.keies = null;
            } else {
                _newObject.keies = new ArrayList<>();
                for (StandardKey _item: this.keies) {
                    _newObject.keies.add(((_item == null)?null:_item.createCopy(keiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Standard.Modifier();
        }
        return ((Standard.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Standard.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.endorsedVersions == null) {
            _other.endorsedVersions = null;
        } else {
            _other.endorsedVersions = new ArrayList<>();
            for (EndorsedVersion _item: this.endorsedVersions) {
                _other.endorsedVersions.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.schemas == null) {
            _other.schemas = null;
        } else {
            _other.schemas = new ArrayList<>();
            for (Schema _item: this.schemas) {
                _other.schemas.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.deprecated = this.deprecated;
        if (this.keies == null) {
            _other.keies = null;
        } else {
            _other.keies = new ArrayList<>();
            for (StandardKey _item: this.keies) {
                _other.keies.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Standard.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Standard.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Standard.Builder<Void> builder() {
        return new Standard.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Standard.Builder<_B> copyOf(final Resource _other) {
        final Standard.Builder<_B> _newBuilder = new Standard.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Standard.Builder<_B> copyOf(final Standard _other) {
        final Standard.Builder<_B> _newBuilder = new Standard.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final Standard.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree endorsedVersionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endorsedVersions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endorsedVersionsPropertyTree!= null):((endorsedVersionsPropertyTree == null)||(!endorsedVersionsPropertyTree.isLeaf())))) {
            if (this.endorsedVersions == null) {
                _other.endorsedVersions = null;
            } else {
                _other.endorsedVersions = new ArrayList<>();
                for (EndorsedVersion _item: this.endorsedVersions) {
                    _other.endorsedVersions.add(((_item == null)?null:_item.newCopyBuilder(_other, endorsedVersionsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree schemasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemas"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemasPropertyTree!= null):((schemasPropertyTree == null)||(!schemasPropertyTree.isLeaf())))) {
            if (this.schemas == null) {
                _other.schemas = null;
            } else {
                _other.schemas = new ArrayList<>();
                for (Schema _item: this.schemas) {
                    _other.schemas.add(((_item == null)?null:_item.newCopyBuilder(_other, schemasPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree deprecatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("deprecated"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(deprecatedPropertyTree!= null):((deprecatedPropertyTree == null)||(!deprecatedPropertyTree.isLeaf())))) {
            _other.deprecated = this.deprecated;
        }
        final PropertyTree keiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("keies"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(keiesPropertyTree!= null):((keiesPropertyTree == null)||(!keiesPropertyTree.isLeaf())))) {
            if (this.keies == null) {
                _other.keies = null;
            } else {
                _other.keies = new ArrayList<>();
                for (StandardKey _item: this.keies) {
                    _other.keies.add(((_item == null)?null:_item.newCopyBuilder(_other, keiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >Standard.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Standard.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Standard.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Standard.Builder<_B> _newBuilder = new Standard.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >Standard.Builder<_B> copyOf(final Standard _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Standard.Builder<_B> _newBuilder = new Standard.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Standard.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Standard.Builder<Void> copyExcept(final Standard _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Standard.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static Standard.Builder<Void> copyOnly(final Standard _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Standard visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(Standard.PropInfo.ENDORSED_VERSIONS, this))&&(this.endorsedVersions!= null)) {
            for (EndorsedVersion _item_: this.endorsedVersions) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Standard.PropInfo.SCHEMAS, this))&&(this.schemas!= null)) {
            for (Schema _item_: this.schemas) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Standard.PropInfo.DEPRECATED, this));
        if (_visitor_.visit(new CollectionProperty<>(Standard.PropInfo.KEIES, this))&&(this.keies!= null)) {
            for (StandardKey _item_: this.keies) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends Resource.Builder<_B>
        implements Buildable
    {

        private List<EndorsedVersion.Builder<Standard.Builder<_B>>> endorsedVersions;
        private List<Schema.Builder<Standard.Builder<_B>>> schemas;
        private String deprecated;
        private List<StandardKey.Builder<Standard.Builder<_B>>> keies;

        public Builder(final _B _parentBuilder, final Standard _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.endorsedVersions == null) {
                    this.endorsedVersions = null;
                } else {
                    this.endorsedVersions = new ArrayList<>();
                    for (EndorsedVersion _item: _other.endorsedVersions) {
                        this.endorsedVersions.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.schemas == null) {
                    this.schemas = null;
                } else {
                    this.schemas = new ArrayList<>();
                    for (Schema _item: _other.schemas) {
                        this.schemas.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                this.deprecated = _other.deprecated;
                if (_other.keies == null) {
                    this.keies = null;
                } else {
                    this.keies = new ArrayList<>();
                    for (StandardKey _item: _other.keies) {
                        this.keies.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final Standard _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree endorsedVersionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("endorsedVersions"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(endorsedVersionsPropertyTree!= null):((endorsedVersionsPropertyTree == null)||(!endorsedVersionsPropertyTree.isLeaf())))) {
                    if (_other.endorsedVersions == null) {
                        this.endorsedVersions = null;
                    } else {
                        this.endorsedVersions = new ArrayList<>();
                        for (EndorsedVersion _item: _other.endorsedVersions) {
                            this.endorsedVersions.add(((_item == null)?null:_item.newCopyBuilder(this, endorsedVersionsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree schemasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("schemas"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(schemasPropertyTree!= null):((schemasPropertyTree == null)||(!schemasPropertyTree.isLeaf())))) {
                    if (_other.schemas == null) {
                        this.schemas = null;
                    } else {
                        this.schemas = new ArrayList<>();
                        for (Schema _item: _other.schemas) {
                            this.schemas.add(((_item == null)?null:_item.newCopyBuilder(this, schemasPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree deprecatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("deprecated"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(deprecatedPropertyTree!= null):((deprecatedPropertyTree == null)||(!deprecatedPropertyTree.isLeaf())))) {
                    this.deprecated = _other.deprecated;
                }
                final PropertyTree keiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("keies"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(keiesPropertyTree!= null):((keiesPropertyTree == null)||(!keiesPropertyTree.isLeaf())))) {
                    if (_other.keies == null) {
                        this.keies = null;
                    } else {
                        this.keies = new ArrayList<>();
                        for (StandardKey _item: _other.keies) {
                            this.keies.add(((_item == null)?null:_item.newCopyBuilder(this, keiesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends Standard >_P init(final _P _product) {
            if (this.endorsedVersions!= null) {
                final List<EndorsedVersion> endorsedVersions = new ArrayList<>(this.endorsedVersions.size());
                for (EndorsedVersion.Builder<Standard.Builder<_B>> _item: this.endorsedVersions) {
                    endorsedVersions.add(_item.build());
                }
                _product.endorsedVersions = endorsedVersions;
            }
            if (this.schemas!= null) {
                final List<Schema> schemas = new ArrayList<>(this.schemas.size());
                for (Schema.Builder<Standard.Builder<_B>> _item: this.schemas) {
                    schemas.add(_item.build());
                }
                _product.schemas = schemas;
            }
            _product.deprecated = this.deprecated;
            if (this.keies!= null) {
                final List<StandardKey> keies = new ArrayList<>(this.keies.size());
                for (StandardKey.Builder<Standard.Builder<_B>> _item: this.keies) {
                    keies.add(_item.build());
                }
                _product.keies = keies;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "endorsedVersions"
         * 
         * @param endorsedVersions
         *     Items to add to the value of the "endorsedVersions" property
         */
        public Standard.Builder<_B> addEndorsedVersions(final Iterable<? extends EndorsedVersion> endorsedVersions) {
            if (endorsedVersions!= null) {
                if (this.endorsedVersions == null) {
                    this.endorsedVersions = new ArrayList<>();
                }
                for (EndorsedVersion _item: endorsedVersions) {
                    this.endorsedVersions.add(new EndorsedVersion.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "endorsedVersions" (any previous value will be replaced)
         * 
         * @param endorsedVersions
         *     New value of the "endorsedVersions" property.
         */
        public Standard.Builder<_B> withEndorsedVersions(final Iterable<? extends EndorsedVersion> endorsedVersions) {
            if (this.endorsedVersions!= null) {
                this.endorsedVersions.clear();
            }
            return addEndorsedVersions(endorsedVersions);
        }

        /**
         * Adds the given items to the value of "endorsedVersions"
         * 
         * @param endorsedVersions
         *     Items to add to the value of the "endorsedVersions" property
         */
        public Standard.Builder<_B> addEndorsedVersions(EndorsedVersion... endorsedVersions) {
            addEndorsedVersions(Arrays.asList(endorsedVersions));
            return this;
        }

        /**
         * Sets the new value of "endorsedVersions" (any previous value will be replaced)
         * 
         * @param endorsedVersions
         *     New value of the "endorsedVersions" property.
         */
        public Standard.Builder<_B> withEndorsedVersions(EndorsedVersion... endorsedVersions) {
            withEndorsedVersions(Arrays.asList(endorsedVersions));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "EndorsedVersions"
         * property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.standard.EndorsedVersion.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "EndorsedVersions" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.standard.EndorsedVersion.Builder#end()} to
         *     return to the current builder.
         */
        public EndorsedVersion.Builder<? extends Standard.Builder<_B>> addEndorsedVersions() {
            if (this.endorsedVersions == null) {
                this.endorsedVersions = new ArrayList<>();
            }
            final EndorsedVersion.Builder<Standard.Builder<_B>> endorsedVersions_Builder = new EndorsedVersion.Builder<>(this, null, false);
            this.endorsedVersions.add(endorsedVersions_Builder);
            return endorsedVersions_Builder;
        }

        /**
         * Adds the given items to the value of "schemas"
         * 
         * @param schemas
         *     Items to add to the value of the "schemas" property
         */
        public Standard.Builder<_B> addSchemas(final Iterable<? extends Schema> schemas) {
            if (schemas!= null) {
                if (this.schemas == null) {
                    this.schemas = new ArrayList<>();
                }
                for (Schema _item: schemas) {
                    this.schemas.add(new Schema.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "schemas" (any previous value will be replaced)
         * 
         * @param schemas
         *     New value of the "schemas" property.
         */
        public Standard.Builder<_B> withSchemas(final Iterable<? extends Schema> schemas) {
            if (this.schemas!= null) {
                this.schemas.clear();
            }
            return addSchemas(schemas);
        }

        /**
         * Adds the given items to the value of "schemas"
         * 
         * @param schemas
         *     Items to add to the value of the "schemas" property
         */
        public Standard.Builder<_B> addSchemas(Schema... schemas) {
            addSchemas(Arrays.asList(schemas));
            return this;
        }

        /**
         * Sets the new value of "schemas" (any previous value will be replaced)
         * 
         * @param schemas
         *     New value of the "schemas" property.
         */
        public Standard.Builder<_B> withSchemas(Schema... schemas) {
            withSchemas(Arrays.asList(schemas));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Schemas" property.
         * Use {@link org.javastro.ivoa.entities.resource.standard.Schema.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Schemas" property.
         *     Use {@link org.javastro.ivoa.entities.resource.standard.Schema.Builder#end()} to
         *     return to the current builder.
         */
        public Schema.Builder<? extends Standard.Builder<_B>> addSchemas() {
            if (this.schemas == null) {
                this.schemas = new ArrayList<>();
            }
            final Schema.Builder<Standard.Builder<_B>> schemas_Builder = new Schema.Builder<>(this, null, false);
            this.schemas.add(schemas_Builder);
            return schemas_Builder;
        }

        /**
         * Sets the new value of "deprecated" (any previous value will be replaced)
         * 
         * @param deprecated
         *     New value of the "deprecated" property.
         */
        public Standard.Builder<_B> withDeprecated(final String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        /**
         * Adds the given items to the value of "keies"
         * 
         * @param keies
         *     Items to add to the value of the "keies" property
         */
        public Standard.Builder<_B> addKeies(final Iterable<? extends StandardKey> keies) {
            if (keies!= null) {
                if (this.keies == null) {
                    this.keies = new ArrayList<>();
                }
                for (StandardKey _item: keies) {
                    this.keies.add(new StandardKey.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "keies" (any previous value will be replaced)
         * 
         * @param keies
         *     New value of the "keies" property.
         */
        public Standard.Builder<_B> withKeies(final Iterable<? extends StandardKey> keies) {
            if (this.keies!= null) {
                this.keies.clear();
            }
            return addKeies(keies);
        }

        /**
         * Adds the given items to the value of "keies"
         * 
         * @param keies
         *     Items to add to the value of the "keies" property
         */
        public Standard.Builder<_B> addKeies(StandardKey... keies) {
            addKeies(Arrays.asList(keies));
            return this;
        }

        /**
         * Sets the new value of "keies" (any previous value will be replaced)
         * 
         * @param keies
         *     New value of the "keies" property.
         */
        public Standard.Builder<_B> withKeies(StandardKey... keies) {
            withKeies(Arrays.asList(keies));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Keies" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.standard.StandardKey.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Keies" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.standard.StandardKey.Builder#end()} to
         *     return to the current builder.
         */
        public StandardKey.Builder<? extends Standard.Builder<_B>> addKeies() {
            if (this.keies == null) {
                this.keies = new ArrayList<>();
            }
            final StandardKey.Builder<Standard.Builder<_B>> keies_Builder = new StandardKey.Builder<>(this, null, false);
            this.keies.add(keies_Builder);
            return keies_Builder;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Standard.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Standard.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Standard.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Standard.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public Standard.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public Standard.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public Standard.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Standard.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Standard.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Standard.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Standard.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public Standard.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends Standard.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends Standard.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public Standard.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends Standard.Builder<_B>> withContent() {
            return ((Content.Builder<? extends Standard.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public Standard.Builder<_B> withCreated(final ZonedDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public Standard.Builder<_B> withUpdated(final ZonedDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public Standard.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public Standard.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Standard build() {
            if (_storedValue == null) {
                return this.init(new Standard());
            } else {
                return ((Standard) _storedValue);
            }
        }

        public Standard.Builder<_B> copyOf(final Standard _other) {
            _other.copyTo(this);
            return this;
        }

        public Standard.Builder<_B> copyOf(final Standard.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Resource.Modifier
    {


        public List<EndorsedVersion> getEndorsedVersions() {
            if (Standard.this.endorsedVersions == null) {
                Standard.this.endorsedVersions = new ArrayList<>();
            }
            return Standard.this.endorsedVersions;
        }

        public List<Schema> getSchemas() {
            if (Standard.this.schemas == null) {
                Standard.this.schemas = new ArrayList<>();
            }
            return Standard.this.schemas;
        }

        public void setDeprecated(final String deprecated) {
            Standard.this.setDeprecated(deprecated);
        }

        public List<StandardKey> getKeies() {
            if (Standard.this.keies == null) {
                Standard.this.keies = new ArrayList<>();
            }
            return Standard.this.keies;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<Standard, EndorsedVersion> ENDORSED_VERSIONS = new CollectionPropertyInfo<Standard,EndorsedVersion>("endorsedVersions", Standard.class, EndorsedVersion.class, true, null, new QName("", "endorsedVersion"), new QName("http://www.ivoa.net/xml/StandardsRegExt/v1.0", "EndorsedVersion"), false) {


            @Override
            public List<EndorsedVersion> get(final Standard _instance_) {
                return ((_instance_ == null)?null:_instance_.endorsedVersions);
            }

            @Override
            public void set(final Standard _instance_, final List<EndorsedVersion> _value_) {
                if (_instance_!= null) {
                    _instance_.endorsedVersions = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Standard, Schema> SCHEMAS = new CollectionPropertyInfo<Standard,Schema>("schemas", Standard.class, Schema.class, true, null, new QName("", "schema"), new QName("http://www.ivoa.net/xml/StandardsRegExt/v1.0", "Schema"), false) {


            @Override
            public List<Schema> get(final Standard _instance_) {
                return ((_instance_ == null)?null:_instance_.schemas);
            }

            @Override
            public void set(final Standard _instance_, final List<Schema> _value_) {
                if (_instance_!= null) {
                    _instance_.schemas = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Standard, String> DEPRECATED = new SinglePropertyInfo<Standard,String>("deprecated", Standard.class, String.class, false, null, new QName("", "deprecated"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final Standard _instance_) {
                return ((_instance_ == null)?null:_instance_.deprecated);
            }

            @Override
            public void set(final Standard _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.deprecated = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Standard, StandardKey> KEIES = new CollectionPropertyInfo<Standard,StandardKey>("keies", Standard.class, StandardKey.class, true, null, new QName("", "key"), new QName("http://www.ivoa.net/xml/StandardsRegExt/v1.0", "StandardKey"), false) {


            @Override
            public List<StandardKey> get(final Standard _instance_) {
                return ((_instance_ == null)?null:_instance_.keies);
            }

            @Override
            public void set(final Standard _instance_, final List<StandardKey> _value_) {
                if (_instance_!= null) {
                    _instance_.keies = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Standard.Selector<Standard.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Standard.Select _root() {
            return new Standard.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Resource.Selector<TRoot, TParent>
    {

        private EndorsedVersion.Selector<TRoot, Standard.Selector<TRoot, TParent>> endorsedVersions = null;
        private Schema.Selector<TRoot, Standard.Selector<TRoot, TParent>> schemas = null;
        private com.kscs.util.jaxb.Selector<TRoot, Standard.Selector<TRoot, TParent>> deprecated = null;
        private StandardKey.Selector<TRoot, Standard.Selector<TRoot, TParent>> keies = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.endorsedVersions!= null) {
                products.put("endorsedVersions", this.endorsedVersions.init());
            }
            if (this.schemas!= null) {
                products.put("schemas", this.schemas.init());
            }
            if (this.deprecated!= null) {
                products.put("deprecated", this.deprecated.init());
            }
            if (this.keies!= null) {
                products.put("keies", this.keies.init());
            }
            return products;
        }

        public EndorsedVersion.Selector<TRoot, Standard.Selector<TRoot, TParent>> endorsedVersions() {
            return ((this.endorsedVersions == null)?this.endorsedVersions = new EndorsedVersion.Selector<>(this._root, this, "endorsedVersions"):this.endorsedVersions);
        }

        public Schema.Selector<TRoot, Standard.Selector<TRoot, TParent>> schemas() {
            return ((this.schemas == null)?this.schemas = new Schema.Selector<>(this._root, this, "schemas"):this.schemas);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Standard.Selector<TRoot, TParent>> deprecated() {
            return ((this.deprecated == null)?this.deprecated = new com.kscs.util.jaxb.Selector<>(this._root, this, "deprecated"):this.deprecated);
        }

        public StandardKey.Selector<TRoot, Standard.Selector<TRoot, TParent>> keies() {
            return ((this.keies == null)?this.keies = new StandardKey.Selector<>(this._root, this, "keies"):this.keies);
        }

    }

}
