
package org.javastro.ivoa.entities.resource.tap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The capabilities attempt to define most issues that the
 *       TAP standard leaves to the implementors ("may", "should").
 * 
 * <p>Java class for TableAccess complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TableAccess">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Capability">
 *       <sequence>
 *         <element name="dataModel" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}DataModelType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="language" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}Language" maxOccurs="unbounded"/>
 *         <element name="outputFormat" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}OutputFormat" maxOccurs="unbounded"/>
 *         <element name="uploadMethod" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}UploadMethod" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="retentionPeriod" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}TimeLimits" minOccurs="0"/>
 *         <element name="executionDuration" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}TimeLimits" minOccurs="0"/>
 *         <element name="outputLimit" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}DataLimits" minOccurs="0"/>
 *         <element name="uploadLimit" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}DataLimits" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TableAccess", propOrder = {
    "dataModels",
    "languages",
    "outputFormats",
    "uploadMethods",
    "retentionPeriod",
    "executionDuration",
    "outputLimit",
    "uploadLimit"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class TableAccess
    extends Capability
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Identifier of IVOA-approved data model supported by the 
     *               service.
     * 
     */
    @XmlElement(name = "dataModel")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<DataModelType> dataModels;
    /**
     * Language supported by the service.
     * 
     */
    @XmlElement(name = "language", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<Language> languages;
    /**
     * Output format supported by the service.
     * 
     */
    @XmlElement(name = "outputFormat", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<OutputFormat> outputFormats;
    /**
     * The absence of upload methods indicates
     *                 that the service does not support uploads
     *                 at all.
     * 
     */
    @XmlElement(name = "uploadMethod")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<UploadMethod> uploadMethods;
    /**
     * Limits on the time between job creation and
     *               destruction time.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected TimeLimits retentionPeriod;
    /**
     * Limits on executionDuration.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected TimeLimits executionDuration;
    /**
     * Limits on the size of data returned.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected DataLimits outputLimit;
    /**
     * Limits on the size of uploaded data.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected DataLimits uploadLimit;

    /**
     * Default no-arg constructor
     * 
     */
    public TableAccess() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public TableAccess(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID, final List<DataModelType> dataModels, final List<Language> languages, final List<OutputFormat> outputFormats, final List<UploadMethod> uploadMethods, final TimeLimits retentionPeriod, final TimeLimits executionDuration, final DataLimits outputLimit, final DataLimits uploadLimit) {
        super(validationLevels, description, interfaces, standardID);
        this.dataModels = dataModels;
        this.languages = languages;
        this.outputFormats = outputFormats;
        this.uploadMethods = uploadMethods;
        this.retentionPeriod = retentionPeriod;
        this.executionDuration = executionDuration;
        this.outputLimit = outputLimit;
        this.uploadLimit = uploadLimit;
    }

    /**
     * Identifier of IVOA-approved data model supported by the 
     *               service.
     * 
     * Gets the value of the dataModels property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dataModels property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDataModels().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DataModelType }
     * </p>
     * 
     * 
     * @return
     *     The value of the dataModels property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<DataModelType> getDataModels() {
        if (dataModels == null) {
            dataModels = new ArrayList<>();
        }
        return this.dataModels;
    }

    /**
     * Language supported by the service.
     * 
     * Gets the value of the languages property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the languages property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLanguages().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Language }
     * </p>
     * 
     * 
     * @return
     *     The value of the languages property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<Language> getLanguages() {
        if (languages == null) {
            languages = new ArrayList<>();
        }
        return this.languages;
    }

    /**
     * Output format supported by the service.
     * 
     * Gets the value of the outputFormats property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the outputFormats property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOutputFormats().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OutputFormat }
     * </p>
     * 
     * 
     * @return
     *     The value of the outputFormats property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<OutputFormat> getOutputFormats() {
        if (outputFormats == null) {
            outputFormats = new ArrayList<>();
        }
        return this.outputFormats;
    }

    /**
     * The absence of upload methods indicates
     *                 that the service does not support uploads
     *                 at all.
     * 
     * Gets the value of the uploadMethods property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the uploadMethods property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getUploadMethods().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UploadMethod }
     * </p>
     * 
     * 
     * @return
     *     The value of the uploadMethods property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<UploadMethod> getUploadMethods() {
        if (uploadMethods == null) {
            uploadMethods = new ArrayList<>();
        }
        return this.uploadMethods;
    }

    /**
     * Limits on the time between job creation and
     *               destruction time.
     * 
     * @return
     *     possible object is
     *     {@link TimeLimits }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeLimits getRetentionPeriod() {
        return retentionPeriod;
    }

    /**
     * Sets the value of the retentionPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeLimits }
     *     
     * @see #getRetentionPeriod()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setRetentionPeriod(TimeLimits value) {
        this.retentionPeriod = value;
    }

    /**
     * Limits on executionDuration.
     * 
     * @return
     *     possible object is
     *     {@link TimeLimits }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TimeLimits getExecutionDuration() {
        return executionDuration;
    }

    /**
     * Sets the value of the executionDuration property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeLimits }
     *     
     * @see #getExecutionDuration()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setExecutionDuration(TimeLimits value) {
        this.executionDuration = value;
    }

    /**
     * Limits on the size of data returned.
     * 
     * @return
     *     possible object is
     *     {@link DataLimits }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DataLimits getOutputLimit() {
        return outputLimit;
    }

    /**
     * Sets the value of the outputLimit property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataLimits }
     *     
     * @see #getOutputLimit()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setOutputLimit(DataLimits value) {
        this.outputLimit = value;
    }

    /**
     * Limits on the size of uploaded data.
     * 
     * @return
     *     possible object is
     *     {@link DataLimits }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public DataLimits getUploadLimit() {
        return uploadLimit;
    }

    /**
     * Sets the value of the uploadLimit property.
     * 
     * @param value
     *     allowed object is
     *     {@link DataLimits }
     *     
     * @see #getUploadLimit()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setUploadLimit(DataLimits value) {
        this.uploadLimit = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final TableAccess that = ((TableAccess) object);
        {
            List<DataModelType> leftDataModels;
            leftDataModels = (((this.dataModels!= null)&&(!this.dataModels.isEmpty()))?this.getDataModels():null);
            List<DataModelType> rightDataModels;
            rightDataModels = (((that.dataModels!= null)&&(!that.dataModels.isEmpty()))?that.getDataModels():null);
            if ((this.dataModels!= null)&&(!this.dataModels.isEmpty())) {
                if ((that.dataModels!= null)&&(!that.dataModels.isEmpty())) {
                    if (!leftDataModels.equals(rightDataModels)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.dataModels!= null)&&(!that.dataModels.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Language> leftLanguages;
            leftLanguages = (((this.languages!= null)&&(!this.languages.isEmpty()))?this.getLanguages():null);
            List<Language> rightLanguages;
            rightLanguages = (((that.languages!= null)&&(!that.languages.isEmpty()))?that.getLanguages():null);
            if ((this.languages!= null)&&(!this.languages.isEmpty())) {
                if ((that.languages!= null)&&(!that.languages.isEmpty())) {
                    if (!leftLanguages.equals(rightLanguages)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.languages!= null)&&(!that.languages.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<OutputFormat> leftOutputFormats;
            leftOutputFormats = (((this.outputFormats!= null)&&(!this.outputFormats.isEmpty()))?this.getOutputFormats():null);
            List<OutputFormat> rightOutputFormats;
            rightOutputFormats = (((that.outputFormats!= null)&&(!that.outputFormats.isEmpty()))?that.getOutputFormats():null);
            if ((this.outputFormats!= null)&&(!this.outputFormats.isEmpty())) {
                if ((that.outputFormats!= null)&&(!that.outputFormats.isEmpty())) {
                    if (!leftOutputFormats.equals(rightOutputFormats)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.outputFormats!= null)&&(!that.outputFormats.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<UploadMethod> leftUploadMethods;
            leftUploadMethods = (((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty()))?this.getUploadMethods():null);
            List<UploadMethod> rightUploadMethods;
            rightUploadMethods = (((that.uploadMethods!= null)&&(!that.uploadMethods.isEmpty()))?that.getUploadMethods():null);
            if ((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty())) {
                if ((that.uploadMethods!= null)&&(!that.uploadMethods.isEmpty())) {
                    if (!leftUploadMethods.equals(rightUploadMethods)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.uploadMethods!= null)&&(!that.uploadMethods.isEmpty())) {
                    return false;
                }
            }
        }
        {
            TimeLimits leftRetentionPeriod;
            leftRetentionPeriod = this.getRetentionPeriod();
            TimeLimits rightRetentionPeriod;
            rightRetentionPeriod = that.getRetentionPeriod();
            if (this.retentionPeriod!= null) {
                if (that.retentionPeriod!= null) {
                    if (!leftRetentionPeriod.equals(rightRetentionPeriod)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.retentionPeriod!= null) {
                    return false;
                }
            }
        }
        {
            TimeLimits leftExecutionDuration;
            leftExecutionDuration = this.getExecutionDuration();
            TimeLimits rightExecutionDuration;
            rightExecutionDuration = that.getExecutionDuration();
            if (this.executionDuration!= null) {
                if (that.executionDuration!= null) {
                    if (!leftExecutionDuration.equals(rightExecutionDuration)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.executionDuration!= null) {
                    return false;
                }
            }
        }
        {
            DataLimits leftOutputLimit;
            leftOutputLimit = this.getOutputLimit();
            DataLimits rightOutputLimit;
            rightOutputLimit = that.getOutputLimit();
            if (this.outputLimit!= null) {
                if (that.outputLimit!= null) {
                    if (!leftOutputLimit.equals(rightOutputLimit)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.outputLimit!= null) {
                    return false;
                }
            }
        }
        {
            DataLimits leftUploadLimit;
            leftUploadLimit = this.getUploadLimit();
            DataLimits rightUploadLimit;
            rightUploadLimit = that.getUploadLimit();
            if (this.uploadLimit!= null) {
                if (that.uploadLimit!= null) {
                    if (!leftUploadLimit.equals(rightUploadLimit)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.uploadLimit!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<DataModelType> theDataModels;
            theDataModels = (((this.dataModels!= null)&&(!this.dataModels.isEmpty()))?this.getDataModels():null);
            if ((this.dataModels!= null)&&(!this.dataModels.isEmpty())) {
                currentHashCode += theDataModels.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Language> theLanguages;
            theLanguages = (((this.languages!= null)&&(!this.languages.isEmpty()))?this.getLanguages():null);
            if ((this.languages!= null)&&(!this.languages.isEmpty())) {
                currentHashCode += theLanguages.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<OutputFormat> theOutputFormats;
            theOutputFormats = (((this.outputFormats!= null)&&(!this.outputFormats.isEmpty()))?this.getOutputFormats():null);
            if ((this.outputFormats!= null)&&(!this.outputFormats.isEmpty())) {
                currentHashCode += theOutputFormats.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<UploadMethod> theUploadMethods;
            theUploadMethods = (((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty()))?this.getUploadMethods():null);
            if ((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty())) {
                currentHashCode += theUploadMethods.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            TimeLimits theRetentionPeriod;
            theRetentionPeriod = this.getRetentionPeriod();
            if (this.retentionPeriod!= null) {
                currentHashCode += theRetentionPeriod.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            TimeLimits theExecutionDuration;
            theExecutionDuration = this.getExecutionDuration();
            if (this.executionDuration!= null) {
                currentHashCode += theExecutionDuration.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            DataLimits theOutputLimit;
            theOutputLimit = this.getOutputLimit();
            if (this.outputLimit!= null) {
                currentHashCode += theOutputLimit.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            DataLimits theUploadLimit;
            theUploadLimit = this.getUploadLimit();
            if (this.uploadLimit!= null) {
                currentHashCode += theUploadLimit.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<DataModelType> theDataModels;
            theDataModels = (((this.dataModels!= null)&&(!this.dataModels.isEmpty()))?this.getDataModels():null);
            strategy.appendField(locator, this, "dataModels", buffer, theDataModels, ((this.dataModels!= null)&&(!this.dataModels.isEmpty())));
        }
        {
            List<Language> theLanguages;
            theLanguages = (((this.languages!= null)&&(!this.languages.isEmpty()))?this.getLanguages():null);
            strategy.appendField(locator, this, "languages", buffer, theLanguages, ((this.languages!= null)&&(!this.languages.isEmpty())));
        }
        {
            List<OutputFormat> theOutputFormats;
            theOutputFormats = (((this.outputFormats!= null)&&(!this.outputFormats.isEmpty()))?this.getOutputFormats():null);
            strategy.appendField(locator, this, "outputFormats", buffer, theOutputFormats, ((this.outputFormats!= null)&&(!this.outputFormats.isEmpty())));
        }
        {
            List<UploadMethod> theUploadMethods;
            theUploadMethods = (((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty()))?this.getUploadMethods():null);
            strategy.appendField(locator, this, "uploadMethods", buffer, theUploadMethods, ((this.uploadMethods!= null)&&(!this.uploadMethods.isEmpty())));
        }
        {
            TimeLimits theRetentionPeriod;
            theRetentionPeriod = this.getRetentionPeriod();
            strategy.appendField(locator, this, "retentionPeriod", buffer, theRetentionPeriod, (this.retentionPeriod!= null));
        }
        {
            TimeLimits theExecutionDuration;
            theExecutionDuration = this.getExecutionDuration();
            strategy.appendField(locator, this, "executionDuration", buffer, theExecutionDuration, (this.executionDuration!= null));
        }
        {
            DataLimits theOutputLimit;
            theOutputLimit = this.getOutputLimit();
            strategy.appendField(locator, this, "outputLimit", buffer, theOutputLimit, (this.outputLimit!= null));
        }
        {
            DataLimits theUploadLimit;
            theUploadLimit = this.getUploadLimit();
            strategy.appendField(locator, this, "uploadLimit", buffer, theUploadLimit, (this.uploadLimit!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof TableAccess) {
            final TableAccess target = this;
            final TableAccess leftObject = ((TableAccess) left);
            final TableAccess rightObject = ((TableAccess) right);
            {
                Boolean dataModelsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.dataModels!= null)&&(!leftObject.dataModels.isEmpty())), ((rightObject.dataModels!= null)&&(!rightObject.dataModels.isEmpty())));
                if (dataModelsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<DataModelType> lhsDataModels;
                    lhsDataModels = (((leftObject.dataModels!= null)&&(!leftObject.dataModels.isEmpty()))?leftObject.getDataModels():null);
                    List<DataModelType> rhsDataModels;
                    rhsDataModels = (((rightObject.dataModels!= null)&&(!rightObject.dataModels.isEmpty()))?rightObject.getDataModels():null);
                    List<DataModelType> mergedDataModels = ((List<DataModelType> ) strategy.merge(LocatorUtils.property(leftLocator, "dataModels", lhsDataModels), LocatorUtils.property(rightLocator, "dataModels", rhsDataModels), lhsDataModels, rhsDataModels, ((leftObject.dataModels!= null)&&(!leftObject.dataModels.isEmpty())), ((rightObject.dataModels!= null)&&(!rightObject.dataModels.isEmpty()))));
                    target.dataModels = null;
                    if (mergedDataModels!= null) {
                        List<DataModelType> uniqueDataModelsl = target.getDataModels();
                        uniqueDataModelsl.addAll(mergedDataModels);
                    }
                } else {
                    if (dataModelsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.dataModels = null;
                    }
                }
            }
            {
                Boolean languagesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.languages!= null)&&(!leftObject.languages.isEmpty())), ((rightObject.languages!= null)&&(!rightObject.languages.isEmpty())));
                if (languagesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Language> lhsLanguages;
                    lhsLanguages = (((leftObject.languages!= null)&&(!leftObject.languages.isEmpty()))?leftObject.getLanguages():null);
                    List<Language> rhsLanguages;
                    rhsLanguages = (((rightObject.languages!= null)&&(!rightObject.languages.isEmpty()))?rightObject.getLanguages():null);
                    List<Language> mergedLanguages = ((List<Language> ) strategy.merge(LocatorUtils.property(leftLocator, "languages", lhsLanguages), LocatorUtils.property(rightLocator, "languages", rhsLanguages), lhsLanguages, rhsLanguages, ((leftObject.languages!= null)&&(!leftObject.languages.isEmpty())), ((rightObject.languages!= null)&&(!rightObject.languages.isEmpty()))));
                    target.languages = null;
                    if (mergedLanguages!= null) {
                        List<Language> uniqueLanguagesl = target.getLanguages();
                        uniqueLanguagesl.addAll(mergedLanguages);
                    }
                } else {
                    if (languagesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.languages = null;
                    }
                }
            }
            {
                Boolean outputFormatsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.outputFormats!= null)&&(!leftObject.outputFormats.isEmpty())), ((rightObject.outputFormats!= null)&&(!rightObject.outputFormats.isEmpty())));
                if (outputFormatsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<OutputFormat> lhsOutputFormats;
                    lhsOutputFormats = (((leftObject.outputFormats!= null)&&(!leftObject.outputFormats.isEmpty()))?leftObject.getOutputFormats():null);
                    List<OutputFormat> rhsOutputFormats;
                    rhsOutputFormats = (((rightObject.outputFormats!= null)&&(!rightObject.outputFormats.isEmpty()))?rightObject.getOutputFormats():null);
                    List<OutputFormat> mergedOutputFormats = ((List<OutputFormat> ) strategy.merge(LocatorUtils.property(leftLocator, "outputFormats", lhsOutputFormats), LocatorUtils.property(rightLocator, "outputFormats", rhsOutputFormats), lhsOutputFormats, rhsOutputFormats, ((leftObject.outputFormats!= null)&&(!leftObject.outputFormats.isEmpty())), ((rightObject.outputFormats!= null)&&(!rightObject.outputFormats.isEmpty()))));
                    target.outputFormats = null;
                    if (mergedOutputFormats!= null) {
                        List<OutputFormat> uniqueOutputFormatsl = target.getOutputFormats();
                        uniqueOutputFormatsl.addAll(mergedOutputFormats);
                    }
                } else {
                    if (outputFormatsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.outputFormats = null;
                    }
                }
            }
            {
                Boolean uploadMethodsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.uploadMethods!= null)&&(!leftObject.uploadMethods.isEmpty())), ((rightObject.uploadMethods!= null)&&(!rightObject.uploadMethods.isEmpty())));
                if (uploadMethodsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<UploadMethod> lhsUploadMethods;
                    lhsUploadMethods = (((leftObject.uploadMethods!= null)&&(!leftObject.uploadMethods.isEmpty()))?leftObject.getUploadMethods():null);
                    List<UploadMethod> rhsUploadMethods;
                    rhsUploadMethods = (((rightObject.uploadMethods!= null)&&(!rightObject.uploadMethods.isEmpty()))?rightObject.getUploadMethods():null);
                    List<UploadMethod> mergedUploadMethods = ((List<UploadMethod> ) strategy.merge(LocatorUtils.property(leftLocator, "uploadMethods", lhsUploadMethods), LocatorUtils.property(rightLocator, "uploadMethods", rhsUploadMethods), lhsUploadMethods, rhsUploadMethods, ((leftObject.uploadMethods!= null)&&(!leftObject.uploadMethods.isEmpty())), ((rightObject.uploadMethods!= null)&&(!rightObject.uploadMethods.isEmpty()))));
                    target.uploadMethods = null;
                    if (mergedUploadMethods!= null) {
                        List<UploadMethod> uniqueUploadMethodsl = target.getUploadMethods();
                        uniqueUploadMethodsl.addAll(mergedUploadMethods);
                    }
                } else {
                    if (uploadMethodsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.uploadMethods = null;
                    }
                }
            }
            {
                Boolean retentionPeriodShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.retentionPeriod!= null), (rightObject.retentionPeriod!= null));
                if (retentionPeriodShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeLimits lhsRetentionPeriod;
                    lhsRetentionPeriod = leftObject.getRetentionPeriod();
                    TimeLimits rhsRetentionPeriod;
                    rhsRetentionPeriod = rightObject.getRetentionPeriod();
                    TimeLimits mergedRetentionPeriod = ((TimeLimits) strategy.merge(LocatorUtils.property(leftLocator, "retentionPeriod", lhsRetentionPeriod), LocatorUtils.property(rightLocator, "retentionPeriod", rhsRetentionPeriod), lhsRetentionPeriod, rhsRetentionPeriod, (leftObject.retentionPeriod!= null), (rightObject.retentionPeriod!= null)));
                    target.setRetentionPeriod(mergedRetentionPeriod);
                } else {
                    if (retentionPeriodShouldBeMergedAndSet == Boolean.FALSE) {
                        target.retentionPeriod = null;
                    }
                }
            }
            {
                Boolean executionDurationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.executionDuration!= null), (rightObject.executionDuration!= null));
                if (executionDurationShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeLimits lhsExecutionDuration;
                    lhsExecutionDuration = leftObject.getExecutionDuration();
                    TimeLimits rhsExecutionDuration;
                    rhsExecutionDuration = rightObject.getExecutionDuration();
                    TimeLimits mergedExecutionDuration = ((TimeLimits) strategy.merge(LocatorUtils.property(leftLocator, "executionDuration", lhsExecutionDuration), LocatorUtils.property(rightLocator, "executionDuration", rhsExecutionDuration), lhsExecutionDuration, rhsExecutionDuration, (leftObject.executionDuration!= null), (rightObject.executionDuration!= null)));
                    target.setExecutionDuration(mergedExecutionDuration);
                } else {
                    if (executionDurationShouldBeMergedAndSet == Boolean.FALSE) {
                        target.executionDuration = null;
                    }
                }
            }
            {
                Boolean outputLimitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.outputLimit!= null), (rightObject.outputLimit!= null));
                if (outputLimitShouldBeMergedAndSet == Boolean.TRUE) {
                    DataLimits lhsOutputLimit;
                    lhsOutputLimit = leftObject.getOutputLimit();
                    DataLimits rhsOutputLimit;
                    rhsOutputLimit = rightObject.getOutputLimit();
                    DataLimits mergedOutputLimit = ((DataLimits) strategy.merge(LocatorUtils.property(leftLocator, "outputLimit", lhsOutputLimit), LocatorUtils.property(rightLocator, "outputLimit", rhsOutputLimit), lhsOutputLimit, rhsOutputLimit, (leftObject.outputLimit!= null), (rightObject.outputLimit!= null)));
                    target.setOutputLimit(mergedOutputLimit);
                } else {
                    if (outputLimitShouldBeMergedAndSet == Boolean.FALSE) {
                        target.outputLimit = null;
                    }
                }
            }
            {
                Boolean uploadLimitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.uploadLimit!= null), (rightObject.uploadLimit!= null));
                if (uploadLimitShouldBeMergedAndSet == Boolean.TRUE) {
                    DataLimits lhsUploadLimit;
                    lhsUploadLimit = leftObject.getUploadLimit();
                    DataLimits rhsUploadLimit;
                    rhsUploadLimit = rightObject.getUploadLimit();
                    DataLimits mergedUploadLimit = ((DataLimits) strategy.merge(LocatorUtils.property(leftLocator, "uploadLimit", lhsUploadLimit), LocatorUtils.property(rightLocator, "uploadLimit", rhsUploadLimit), lhsUploadLimit, rhsUploadLimit, (leftObject.uploadLimit!= null), (rightObject.uploadLimit!= null)));
                    target.setUploadLimit(mergedUploadLimit);
                } else {
                    if (uploadLimitShouldBeMergedAndSet == Boolean.FALSE) {
                        target.uploadLimit = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new TableAccess();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess clone() {
        final TableAccess _newObject;
        _newObject = ((TableAccess) super.clone());
        if (this.dataModels == null) {
            _newObject.dataModels = null;
        } else {
            _newObject.dataModels = new ArrayList<>();
            for (DataModelType _item: this.dataModels) {
                _newObject.dataModels.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.languages == null) {
            _newObject.languages = null;
        } else {
            _newObject.languages = new ArrayList<>();
            for (Language _item: this.languages) {
                _newObject.languages.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.outputFormats == null) {
            _newObject.outputFormats = null;
        } else {
            _newObject.outputFormats = new ArrayList<>();
            for (OutputFormat _item: this.outputFormats) {
                _newObject.outputFormats.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.uploadMethods == null) {
            _newObject.uploadMethods = null;
        } else {
            _newObject.uploadMethods = new ArrayList<>();
            for (UploadMethod _item: this.uploadMethods) {
                _newObject.uploadMethods.add(((_item == null)?null:_item.clone()));
            }
        }
        _newObject.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.clone());
        _newObject.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.clone());
        _newObject.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.clone());
        _newObject.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess createCopy() {
        final TableAccess _newObject = ((TableAccess) super.createCopy());
        if (this.dataModels == null) {
            _newObject.dataModels = null;
        } else {
            _newObject.dataModels = new ArrayList<>();
            for (DataModelType _item: this.dataModels) {
                _newObject.dataModels.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.languages == null) {
            _newObject.languages = null;
        } else {
            _newObject.languages = new ArrayList<>();
            for (Language _item: this.languages) {
                _newObject.languages.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.outputFormats == null) {
            _newObject.outputFormats = null;
        } else {
            _newObject.outputFormats = new ArrayList<>();
            for (OutputFormat _item: this.outputFormats) {
                _newObject.outputFormats.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.uploadMethods == null) {
            _newObject.uploadMethods = null;
        } else {
            _newObject.uploadMethods = new ArrayList<>();
            for (UploadMethod _item: this.uploadMethods) {
                _newObject.uploadMethods.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.createCopy());
        _newObject.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.createCopy());
        _newObject.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.createCopy());
        _newObject.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TableAccess _newObject = ((TableAccess) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree dataModelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataModels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataModelsPropertyTree!= null):((dataModelsPropertyTree == null)||(!dataModelsPropertyTree.isLeaf())))) {
            if (this.dataModels == null) {
                _newObject.dataModels = null;
            } else {
                _newObject.dataModels = new ArrayList<>();
                for (DataModelType _item: this.dataModels) {
                    _newObject.dataModels.add(((_item == null)?null:_item.createCopy(dataModelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree languagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languages"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languagesPropertyTree!= null):((languagesPropertyTree == null)||(!languagesPropertyTree.isLeaf())))) {
            if (this.languages == null) {
                _newObject.languages = null;
            } else {
                _newObject.languages = new ArrayList<>();
                for (Language _item: this.languages) {
                    _newObject.languages.add(((_item == null)?null:_item.createCopy(languagesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree outputFormatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputFormats"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputFormatsPropertyTree!= null):((outputFormatsPropertyTree == null)||(!outputFormatsPropertyTree.isLeaf())))) {
            if (this.outputFormats == null) {
                _newObject.outputFormats = null;
            } else {
                _newObject.outputFormats = new ArrayList<>();
                for (OutputFormat _item: this.outputFormats) {
                    _newObject.outputFormats.add(((_item == null)?null:_item.createCopy(outputFormatsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree uploadMethodsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadMethods"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadMethodsPropertyTree!= null):((uploadMethodsPropertyTree == null)||(!uploadMethodsPropertyTree.isLeaf())))) {
            if (this.uploadMethods == null) {
                _newObject.uploadMethods = null;
            } else {
                _newObject.uploadMethods = new ArrayList<>();
                for (UploadMethod _item: this.uploadMethods) {
                    _newObject.uploadMethods.add(((_item == null)?null:_item.createCopy(uploadMethodsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree retentionPeriodPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("retentionPeriod"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(retentionPeriodPropertyTree!= null):((retentionPeriodPropertyTree == null)||(!retentionPeriodPropertyTree.isLeaf())))) {
            _newObject.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.createCopy(retentionPeriodPropertyTree, _propertyTreeUse));
        }
        final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
            _newObject.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.createCopy(executionDurationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree outputLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputLimit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputLimitPropertyTree!= null):((outputLimitPropertyTree == null)||(!outputLimitPropertyTree.isLeaf())))) {
            _newObject.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.createCopy(outputLimitPropertyTree, _propertyTreeUse));
        }
        final PropertyTree uploadLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadLimit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadLimitPropertyTree!= null):((uploadLimitPropertyTree == null)||(!uploadLimitPropertyTree.isLeaf())))) {
            _newObject.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.createCopy(uploadLimitPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new TableAccess.Modifier();
        }
        return ((TableAccess.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final TableAccess.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.dataModels == null) {
            _other.dataModels = null;
        } else {
            _other.dataModels = new ArrayList<>();
            for (DataModelType _item: this.dataModels) {
                _other.dataModels.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.languages == null) {
            _other.languages = null;
        } else {
            _other.languages = new ArrayList<>();
            for (Language _item: this.languages) {
                _other.languages.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.outputFormats == null) {
            _other.outputFormats = null;
        } else {
            _other.outputFormats = new ArrayList<>();
            for (OutputFormat _item: this.outputFormats) {
                _other.outputFormats.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.uploadMethods == null) {
            _other.uploadMethods = null;
        } else {
            _other.uploadMethods = new ArrayList<>();
            for (UploadMethod _item: this.uploadMethods) {
                _other.uploadMethods.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.newCopyBuilder(_other));
        _other.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.newCopyBuilder(_other));
        _other.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.newCopyBuilder(_other));
        _other.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >TableAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new TableAccess.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TableAccess.Builder<Void> builder() {
        return new TableAccess.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TableAccess.Builder<_B> copyOf(final Capability _other) {
        final TableAccess.Builder<_B> _newBuilder = new TableAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TableAccess.Builder<_B> copyOf(final TableAccess _other) {
        final TableAccess.Builder<_B> _newBuilder = new TableAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final TableAccess.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree dataModelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataModels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataModelsPropertyTree!= null):((dataModelsPropertyTree == null)||(!dataModelsPropertyTree.isLeaf())))) {
            if (this.dataModels == null) {
                _other.dataModels = null;
            } else {
                _other.dataModels = new ArrayList<>();
                for (DataModelType _item: this.dataModels) {
                    _other.dataModels.add(((_item == null)?null:_item.newCopyBuilder(_other, dataModelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree languagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languages"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languagesPropertyTree!= null):((languagesPropertyTree == null)||(!languagesPropertyTree.isLeaf())))) {
            if (this.languages == null) {
                _other.languages = null;
            } else {
                _other.languages = new ArrayList<>();
                for (Language _item: this.languages) {
                    _other.languages.add(((_item == null)?null:_item.newCopyBuilder(_other, languagesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree outputFormatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputFormats"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputFormatsPropertyTree!= null):((outputFormatsPropertyTree == null)||(!outputFormatsPropertyTree.isLeaf())))) {
            if (this.outputFormats == null) {
                _other.outputFormats = null;
            } else {
                _other.outputFormats = new ArrayList<>();
                for (OutputFormat _item: this.outputFormats) {
                    _other.outputFormats.add(((_item == null)?null:_item.newCopyBuilder(_other, outputFormatsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree uploadMethodsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadMethods"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadMethodsPropertyTree!= null):((uploadMethodsPropertyTree == null)||(!uploadMethodsPropertyTree.isLeaf())))) {
            if (this.uploadMethods == null) {
                _other.uploadMethods = null;
            } else {
                _other.uploadMethods = new ArrayList<>();
                for (UploadMethod _item: this.uploadMethods) {
                    _other.uploadMethods.add(((_item == null)?null:_item.newCopyBuilder(_other, uploadMethodsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree retentionPeriodPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("retentionPeriod"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(retentionPeriodPropertyTree!= null):((retentionPeriodPropertyTree == null)||(!retentionPeriodPropertyTree.isLeaf())))) {
            _other.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.newCopyBuilder(_other, retentionPeriodPropertyTree, _propertyTreeUse));
        }
        final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
            _other.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.newCopyBuilder(_other, executionDurationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree outputLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputLimit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputLimitPropertyTree!= null):((outputLimitPropertyTree == null)||(!outputLimitPropertyTree.isLeaf())))) {
            _other.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.newCopyBuilder(_other, outputLimitPropertyTree, _propertyTreeUse));
        }
        final PropertyTree uploadLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadLimit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadLimitPropertyTree!= null):((uploadLimitPropertyTree == null)||(!uploadLimitPropertyTree.isLeaf())))) {
            _other.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.newCopyBuilder(_other, uploadLimitPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >TableAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new TableAccess.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TableAccess.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TableAccess.Builder<_B> _newBuilder = new TableAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >TableAccess.Builder<_B> copyOf(final TableAccess _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TableAccess.Builder<_B> _newBuilder = new TableAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TableAccess.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TableAccess.Builder<Void> copyExcept(final TableAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TableAccess.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static TableAccess.Builder<Void> copyOnly(final TableAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public TableAccess visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(TableAccess.PropInfo.DATA_MODELS, this))&&(this.dataModels!= null)) {
            for (DataModelType _item_: this.dataModels) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(TableAccess.PropInfo.LANGUAGES, this))&&(this.languages!= null)) {
            for (Language _item_: this.languages) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(TableAccess.PropInfo.OUTPUT_FORMATS, this))&&(this.outputFormats!= null)) {
            for (OutputFormat _item_: this.outputFormats) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(TableAccess.PropInfo.UPLOAD_METHODS, this))&&(this.uploadMethods!= null)) {
            for (UploadMethod _item_: this.uploadMethods) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new SingleProperty<>(TableAccess.PropInfo.RETENTION_PERIOD, this))&&(this.retentionPeriod!= null)) {
            this.retentionPeriod.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(TableAccess.PropInfo.EXECUTION_DURATION, this))&&(this.executionDuration!= null)) {
            this.executionDuration.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(TableAccess.PropInfo.OUTPUT_LIMIT, this))&&(this.outputLimit!= null)) {
            this.outputLimit.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(TableAccess.PropInfo.UPLOAD_LIMIT, this))&&(this.uploadLimit!= null)) {
            this.uploadLimit.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends Capability.Builder<_B>
        implements Buildable
    {

        private List<DataModelType.Builder<TableAccess.Builder<_B>>> dataModels;
        private List<Language.Builder<TableAccess.Builder<_B>>> languages;
        private List<OutputFormat.Builder<TableAccess.Builder<_B>>> outputFormats;
        private List<UploadMethod.Builder<TableAccess.Builder<_B>>> uploadMethods;
        private TimeLimits.Builder<TableAccess.Builder<_B>> retentionPeriod;
        private TimeLimits.Builder<TableAccess.Builder<_B>> executionDuration;
        private DataLimits.Builder<TableAccess.Builder<_B>> outputLimit;
        private DataLimits.Builder<TableAccess.Builder<_B>> uploadLimit;

        public Builder(final _B _parentBuilder, final TableAccess _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.dataModels == null) {
                    this.dataModels = null;
                } else {
                    this.dataModels = new ArrayList<>();
                    for (DataModelType _item: _other.dataModels) {
                        this.dataModels.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.languages == null) {
                    this.languages = null;
                } else {
                    this.languages = new ArrayList<>();
                    for (Language _item: _other.languages) {
                        this.languages.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.outputFormats == null) {
                    this.outputFormats = null;
                } else {
                    this.outputFormats = new ArrayList<>();
                    for (OutputFormat _item: _other.outputFormats) {
                        this.outputFormats.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.uploadMethods == null) {
                    this.uploadMethods = null;
                } else {
                    this.uploadMethods = new ArrayList<>();
                    for (UploadMethod _item: _other.uploadMethods) {
                        this.uploadMethods.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                this.retentionPeriod = ((_other.retentionPeriod == null)?null:_other.retentionPeriod.newCopyBuilder(this));
                this.executionDuration = ((_other.executionDuration == null)?null:_other.executionDuration.newCopyBuilder(this));
                this.outputLimit = ((_other.outputLimit == null)?null:_other.outputLimit.newCopyBuilder(this));
                this.uploadLimit = ((_other.uploadLimit == null)?null:_other.uploadLimit.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final TableAccess _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree dataModelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("dataModels"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(dataModelsPropertyTree!= null):((dataModelsPropertyTree == null)||(!dataModelsPropertyTree.isLeaf())))) {
                    if (_other.dataModels == null) {
                        this.dataModels = null;
                    } else {
                        this.dataModels = new ArrayList<>();
                        for (DataModelType _item: _other.dataModels) {
                            this.dataModels.add(((_item == null)?null:_item.newCopyBuilder(this, dataModelsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree languagesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languages"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languagesPropertyTree!= null):((languagesPropertyTree == null)||(!languagesPropertyTree.isLeaf())))) {
                    if (_other.languages == null) {
                        this.languages = null;
                    } else {
                        this.languages = new ArrayList<>();
                        for (Language _item: _other.languages) {
                            this.languages.add(((_item == null)?null:_item.newCopyBuilder(this, languagesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree outputFormatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputFormats"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputFormatsPropertyTree!= null):((outputFormatsPropertyTree == null)||(!outputFormatsPropertyTree.isLeaf())))) {
                    if (_other.outputFormats == null) {
                        this.outputFormats = null;
                    } else {
                        this.outputFormats = new ArrayList<>();
                        for (OutputFormat _item: _other.outputFormats) {
                            this.outputFormats.add(((_item == null)?null:_item.newCopyBuilder(this, outputFormatsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree uploadMethodsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadMethods"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadMethodsPropertyTree!= null):((uploadMethodsPropertyTree == null)||(!uploadMethodsPropertyTree.isLeaf())))) {
                    if (_other.uploadMethods == null) {
                        this.uploadMethods = null;
                    } else {
                        this.uploadMethods = new ArrayList<>();
                        for (UploadMethod _item: _other.uploadMethods) {
                            this.uploadMethods.add(((_item == null)?null:_item.newCopyBuilder(this, uploadMethodsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree retentionPeriodPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("retentionPeriod"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(retentionPeriodPropertyTree!= null):((retentionPeriodPropertyTree == null)||(!retentionPeriodPropertyTree.isLeaf())))) {
                    this.retentionPeriod = ((_other.retentionPeriod == null)?null:_other.retentionPeriod.newCopyBuilder(this, retentionPeriodPropertyTree, _propertyTreeUse));
                }
                final PropertyTree executionDurationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("executionDuration"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(executionDurationPropertyTree!= null):((executionDurationPropertyTree == null)||(!executionDurationPropertyTree.isLeaf())))) {
                    this.executionDuration = ((_other.executionDuration == null)?null:_other.executionDuration.newCopyBuilder(this, executionDurationPropertyTree, _propertyTreeUse));
                }
                final PropertyTree outputLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("outputLimit"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(outputLimitPropertyTree!= null):((outputLimitPropertyTree == null)||(!outputLimitPropertyTree.isLeaf())))) {
                    this.outputLimit = ((_other.outputLimit == null)?null:_other.outputLimit.newCopyBuilder(this, outputLimitPropertyTree, _propertyTreeUse));
                }
                final PropertyTree uploadLimitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("uploadLimit"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(uploadLimitPropertyTree!= null):((uploadLimitPropertyTree == null)||(!uploadLimitPropertyTree.isLeaf())))) {
                    this.uploadLimit = ((_other.uploadLimit == null)?null:_other.uploadLimit.newCopyBuilder(this, uploadLimitPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends TableAccess >_P init(final _P _product) {
            if (this.dataModels!= null) {
                final List<DataModelType> dataModels = new ArrayList<>(this.dataModels.size());
                for (DataModelType.Builder<TableAccess.Builder<_B>> _item: this.dataModels) {
                    dataModels.add(_item.build());
                }
                _product.dataModels = dataModels;
            }
            if (this.languages!= null) {
                final List<Language> languages = new ArrayList<>(this.languages.size());
                for (Language.Builder<TableAccess.Builder<_B>> _item: this.languages) {
                    languages.add(_item.build());
                }
                _product.languages = languages;
            }
            if (this.outputFormats!= null) {
                final List<OutputFormat> outputFormats = new ArrayList<>(this.outputFormats.size());
                for (OutputFormat.Builder<TableAccess.Builder<_B>> _item: this.outputFormats) {
                    outputFormats.add(_item.build());
                }
                _product.outputFormats = outputFormats;
            }
            if (this.uploadMethods!= null) {
                final List<UploadMethod> uploadMethods = new ArrayList<>(this.uploadMethods.size());
                for (UploadMethod.Builder<TableAccess.Builder<_B>> _item: this.uploadMethods) {
                    uploadMethods.add(_item.build());
                }
                _product.uploadMethods = uploadMethods;
            }
            _product.retentionPeriod = ((this.retentionPeriod == null)?null:this.retentionPeriod.build());
            _product.executionDuration = ((this.executionDuration == null)?null:this.executionDuration.build());
            _product.outputLimit = ((this.outputLimit == null)?null:this.outputLimit.build());
            _product.uploadLimit = ((this.uploadLimit == null)?null:this.uploadLimit.build());
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "dataModels"
         * 
         * @param dataModels
         *     Items to add to the value of the "dataModels" property
         */
        public TableAccess.Builder<_B> addDataModels(final Iterable<? extends DataModelType> dataModels) {
            if (dataModels!= null) {
                if (this.dataModels == null) {
                    this.dataModels = new ArrayList<>();
                }
                for (DataModelType _item: dataModels) {
                    this.dataModels.add(new DataModelType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "dataModels" (any previous value will be replaced)
         * 
         * @param dataModels
         *     New value of the "dataModels" property.
         */
        public TableAccess.Builder<_B> withDataModels(final Iterable<? extends DataModelType> dataModels) {
            if (this.dataModels!= null) {
                this.dataModels.clear();
            }
            return addDataModels(dataModels);
        }

        /**
         * Adds the given items to the value of "dataModels"
         * 
         * @param dataModels
         *     Items to add to the value of the "dataModels" property
         */
        public TableAccess.Builder<_B> addDataModels(DataModelType... dataModels) {
            addDataModels(Arrays.asList(dataModels));
            return this;
        }

        /**
         * Sets the new value of "dataModels" (any previous value will be replaced)
         * 
         * @param dataModels
         *     New value of the "dataModels" property.
         */
        public TableAccess.Builder<_B> withDataModels(DataModelType... dataModels) {
            withDataModels(Arrays.asList(dataModels));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "DataModels" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.DataModelType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "DataModels" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.DataModelType.Builder#end()}
         *     to return to the current builder.
         */
        public DataModelType.Builder<? extends TableAccess.Builder<_B>> addDataModels() {
            if (this.dataModels == null) {
                this.dataModels = new ArrayList<>();
            }
            final DataModelType.Builder<TableAccess.Builder<_B>> dataModels_Builder = new DataModelType.Builder<>(this, null, false);
            this.dataModels.add(dataModels_Builder);
            return dataModels_Builder;
        }

        /**
         * Adds the given items to the value of "languages"
         * 
         * @param languages
         *     Items to add to the value of the "languages" property
         */
        public TableAccess.Builder<_B> addLanguages(final Iterable<? extends Language> languages) {
            if (languages!= null) {
                if (this.languages == null) {
                    this.languages = new ArrayList<>();
                }
                for (Language _item: languages) {
                    this.languages.add(new Language.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "languages" (any previous value will be replaced)
         * 
         * @param languages
         *     New value of the "languages" property.
         */
        public TableAccess.Builder<_B> withLanguages(final Iterable<? extends Language> languages) {
            if (this.languages!= null) {
                this.languages.clear();
            }
            return addLanguages(languages);
        }

        /**
         * Adds the given items to the value of "languages"
         * 
         * @param languages
         *     Items to add to the value of the "languages" property
         */
        public TableAccess.Builder<_B> addLanguages(Language... languages) {
            addLanguages(Arrays.asList(languages));
            return this;
        }

        /**
         * Sets the new value of "languages" (any previous value will be replaced)
         * 
         * @param languages
         *     New value of the "languages" property.
         */
        public TableAccess.Builder<_B> withLanguages(Language... languages) {
            withLanguages(Arrays.asList(languages));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Languages" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.Language.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Languages" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.Language.Builder#end()} to
         *     return to the current builder.
         */
        public Language.Builder<? extends TableAccess.Builder<_B>> addLanguages() {
            if (this.languages == null) {
                this.languages = new ArrayList<>();
            }
            final Language.Builder<TableAccess.Builder<_B>> languages_Builder = new Language.Builder<>(this, null, false);
            this.languages.add(languages_Builder);
            return languages_Builder;
        }

        /**
         * Adds the given items to the value of "outputFormats"
         * 
         * @param outputFormats
         *     Items to add to the value of the "outputFormats" property
         */
        public TableAccess.Builder<_B> addOutputFormats(final Iterable<? extends OutputFormat> outputFormats) {
            if (outputFormats!= null) {
                if (this.outputFormats == null) {
                    this.outputFormats = new ArrayList<>();
                }
                for (OutputFormat _item: outputFormats) {
                    this.outputFormats.add(new OutputFormat.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "outputFormats" (any previous value will be replaced)
         * 
         * @param outputFormats
         *     New value of the "outputFormats" property.
         */
        public TableAccess.Builder<_B> withOutputFormats(final Iterable<? extends OutputFormat> outputFormats) {
            if (this.outputFormats!= null) {
                this.outputFormats.clear();
            }
            return addOutputFormats(outputFormats);
        }

        /**
         * Adds the given items to the value of "outputFormats"
         * 
         * @param outputFormats
         *     Items to add to the value of the "outputFormats" property
         */
        public TableAccess.Builder<_B> addOutputFormats(OutputFormat... outputFormats) {
            addOutputFormats(Arrays.asList(outputFormats));
            return this;
        }

        /**
         * Sets the new value of "outputFormats" (any previous value will be replaced)
         * 
         * @param outputFormats
         *     New value of the "outputFormats" property.
         */
        public TableAccess.Builder<_B> withOutputFormats(OutputFormat... outputFormats) {
            withOutputFormats(Arrays.asList(outputFormats));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "OutputFormats"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.OutputFormat.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "OutputFormats" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.OutputFormat.Builder#end()}
         *     to return to the current builder.
         */
        public OutputFormat.Builder<? extends TableAccess.Builder<_B>> addOutputFormats() {
            if (this.outputFormats == null) {
                this.outputFormats = new ArrayList<>();
            }
            final OutputFormat.Builder<TableAccess.Builder<_B>> outputFormats_Builder = new OutputFormat.Builder<>(this, null, false);
            this.outputFormats.add(outputFormats_Builder);
            return outputFormats_Builder;
        }

        /**
         * Adds the given items to the value of "uploadMethods"
         * 
         * @param uploadMethods
         *     Items to add to the value of the "uploadMethods" property
         */
        public TableAccess.Builder<_B> addUploadMethods(final Iterable<? extends UploadMethod> uploadMethods) {
            if (uploadMethods!= null) {
                if (this.uploadMethods == null) {
                    this.uploadMethods = new ArrayList<>();
                }
                for (UploadMethod _item: uploadMethods) {
                    this.uploadMethods.add(new UploadMethod.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "uploadMethods" (any previous value will be replaced)
         * 
         * @param uploadMethods
         *     New value of the "uploadMethods" property.
         */
        public TableAccess.Builder<_B> withUploadMethods(final Iterable<? extends UploadMethod> uploadMethods) {
            if (this.uploadMethods!= null) {
                this.uploadMethods.clear();
            }
            return addUploadMethods(uploadMethods);
        }

        /**
         * Adds the given items to the value of "uploadMethods"
         * 
         * @param uploadMethods
         *     Items to add to the value of the "uploadMethods" property
         */
        public TableAccess.Builder<_B> addUploadMethods(UploadMethod... uploadMethods) {
            addUploadMethods(Arrays.asList(uploadMethods));
            return this;
        }

        /**
         * Sets the new value of "uploadMethods" (any previous value will be replaced)
         * 
         * @param uploadMethods
         *     New value of the "uploadMethods" property.
         */
        public TableAccess.Builder<_B> withUploadMethods(UploadMethod... uploadMethods) {
            withUploadMethods(Arrays.asList(uploadMethods));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "UploadMethods"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.UploadMethod.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "UploadMethods" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.UploadMethod.Builder#end()}
         *     to return to the current builder.
         */
        public UploadMethod.Builder<? extends TableAccess.Builder<_B>> addUploadMethods() {
            if (this.uploadMethods == null) {
                this.uploadMethods = new ArrayList<>();
            }
            final UploadMethod.Builder<TableAccess.Builder<_B>> uploadMethods_Builder = new UploadMethod.Builder<>(this, null, false);
            this.uploadMethods.add(uploadMethods_Builder);
            return uploadMethods_Builder;
        }

        /**
         * Sets the new value of "retentionPeriod" (any previous value will be replaced)
         * 
         * @param retentionPeriod
         *     New value of the "retentionPeriod" property.
         */
        public TableAccess.Builder<_B> withRetentionPeriod(final TimeLimits retentionPeriod) {
            this.retentionPeriod = ((retentionPeriod == null)?null:new TimeLimits.Builder<>(this, retentionPeriod, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "retentionPeriod" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.TimeLimits.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "retentionPeriod" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.TimeLimits.Builder#end()} to
         *     return to the current builder.
         */
        public TimeLimits.Builder<? extends TableAccess.Builder<_B>> withRetentionPeriod() {
            if (this.retentionPeriod!= null) {
                return this.retentionPeriod;
            }
            return this.retentionPeriod = new TimeLimits.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "executionDuration" (any previous value will be replaced)
         * 
         * @param executionDuration
         *     New value of the "executionDuration" property.
         */
        public TableAccess.Builder<_B> withExecutionDuration(final TimeLimits executionDuration) {
            this.executionDuration = ((executionDuration == null)?null:new TimeLimits.Builder<>(this, executionDuration, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "executionDuration" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.TimeLimits.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "executionDuration" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.TimeLimits.Builder#end()} to
         *     return to the current builder.
         */
        public TimeLimits.Builder<? extends TableAccess.Builder<_B>> withExecutionDuration() {
            if (this.executionDuration!= null) {
                return this.executionDuration;
            }
            return this.executionDuration = new TimeLimits.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "outputLimit" (any previous value will be replaced)
         * 
         * @param outputLimit
         *     New value of the "outputLimit" property.
         */
        public TableAccess.Builder<_B> withOutputLimit(final DataLimits outputLimit) {
            this.outputLimit = ((outputLimit == null)?null:new DataLimits.Builder<>(this, outputLimit, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "outputLimit" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.DataLimits.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "outputLimit" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.DataLimits.Builder#end()} to
         *     return to the current builder.
         */
        public DataLimits.Builder<? extends TableAccess.Builder<_B>> withOutputLimit() {
            if (this.outputLimit!= null) {
                return this.outputLimit;
            }
            return this.outputLimit = new DataLimits.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "uploadLimit" (any previous value will be replaced)
         * 
         * @param uploadLimit
         *     New value of the "uploadLimit" property.
         */
        public TableAccess.Builder<_B> withUploadLimit(final DataLimits uploadLimit) {
            this.uploadLimit = ((uploadLimit == null)?null:new DataLimits.Builder<>(this, uploadLimit, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "uploadLimit" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.DataLimits.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "uploadLimit" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.DataLimits.Builder#end()} to
         *     return to the current builder.
         */
        public DataLimits.Builder<? extends TableAccess.Builder<_B>> withUploadLimit() {
            if (this.uploadLimit!= null) {
                return this.uploadLimit;
            }
            return this.uploadLimit = new DataLimits.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public TableAccess.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public TableAccess.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public TableAccess.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public TableAccess.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public TableAccess.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public TableAccess.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public TableAccess.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public TableAccess.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public TableAccess.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        @Override
        public TableAccess.Builder<_B> withStandardID(final String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public TableAccess build() {
            if (_storedValue == null) {
                return this.init(new TableAccess());
            } else {
                return ((TableAccess) _storedValue);
            }
        }

        public TableAccess.Builder<_B> copyOf(final TableAccess _other) {
            _other.copyTo(this);
            return this;
        }

        public TableAccess.Builder<_B> copyOf(final TableAccess.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Capability.Modifier
    {


        public List<DataModelType> getDataModels() {
            if (TableAccess.this.dataModels == null) {
                TableAccess.this.dataModels = new ArrayList<>();
            }
            return TableAccess.this.dataModels;
        }

        public List<Language> getLanguages() {
            if (TableAccess.this.languages == null) {
                TableAccess.this.languages = new ArrayList<>();
            }
            return TableAccess.this.languages;
        }

        public List<OutputFormat> getOutputFormats() {
            if (TableAccess.this.outputFormats == null) {
                TableAccess.this.outputFormats = new ArrayList<>();
            }
            return TableAccess.this.outputFormats;
        }

        public List<UploadMethod> getUploadMethods() {
            if (TableAccess.this.uploadMethods == null) {
                TableAccess.this.uploadMethods = new ArrayList<>();
            }
            return TableAccess.this.uploadMethods;
        }

        public void setRetentionPeriod(final TimeLimits retentionPeriod) {
            TableAccess.this.setRetentionPeriod(retentionPeriod);
        }

        public void setExecutionDuration(final TimeLimits executionDuration) {
            TableAccess.this.setExecutionDuration(executionDuration);
        }

        public void setOutputLimit(final DataLimits outputLimit) {
            TableAccess.this.setOutputLimit(outputLimit);
        }

        public void setUploadLimit(final DataLimits uploadLimit) {
            TableAccess.this.setUploadLimit(uploadLimit);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<TableAccess, DataModelType> DATA_MODELS = new CollectionPropertyInfo<TableAccess,DataModelType>("dataModels", TableAccess.class, DataModelType.class, true, null, new QName("", "dataModel"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "DataModelType"), false) {


            @Override
            public List<DataModelType> get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.dataModels);
            }

            @Override
            public void set(final TableAccess _instance_, final List<DataModelType> _value_) {
                if (_instance_!= null) {
                    _instance_.dataModels = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<TableAccess, Language> LANGUAGES = new CollectionPropertyInfo<TableAccess,Language>("languages", TableAccess.class, Language.class, true, null, new QName("", "language"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "Language"), false) {


            @Override
            public List<Language> get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.languages);
            }

            @Override
            public void set(final TableAccess _instance_, final List<Language> _value_) {
                if (_instance_!= null) {
                    _instance_.languages = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<TableAccess, OutputFormat> OUTPUT_FORMATS = new CollectionPropertyInfo<TableAccess,OutputFormat>("outputFormats", TableAccess.class, OutputFormat.class, true, null, new QName("", "outputFormat"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "OutputFormat"), false) {


            @Override
            public List<OutputFormat> get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.outputFormats);
            }

            @Override
            public void set(final TableAccess _instance_, final List<OutputFormat> _value_) {
                if (_instance_!= null) {
                    _instance_.outputFormats = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<TableAccess, UploadMethod> UPLOAD_METHODS = new CollectionPropertyInfo<TableAccess,UploadMethod>("uploadMethods", TableAccess.class, UploadMethod.class, true, null, new QName("", "uploadMethod"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "UploadMethod"), false) {


            @Override
            public List<UploadMethod> get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.uploadMethods);
            }

            @Override
            public void set(final TableAccess _instance_, final List<UploadMethod> _value_) {
                if (_instance_!= null) {
                    _instance_.uploadMethods = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableAccess, TimeLimits> RETENTION_PERIOD = new SinglePropertyInfo<TableAccess,TimeLimits>("retentionPeriod", TableAccess.class, TimeLimits.class, false, null, new QName("", "retentionPeriod"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "TimeLimits"), false) {


            @Override
            public TimeLimits get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.retentionPeriod);
            }

            @Override
            public void set(final TableAccess _instance_, final TimeLimits _value_) {
                if (_instance_!= null) {
                    _instance_.retentionPeriod = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableAccess, TimeLimits> EXECUTION_DURATION = new SinglePropertyInfo<TableAccess,TimeLimits>("executionDuration", TableAccess.class, TimeLimits.class, false, null, new QName("", "executionDuration"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "TimeLimits"), false) {


            @Override
            public TimeLimits get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.executionDuration);
            }

            @Override
            public void set(final TableAccess _instance_, final TimeLimits _value_) {
                if (_instance_!= null) {
                    _instance_.executionDuration = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableAccess, DataLimits> OUTPUT_LIMIT = new SinglePropertyInfo<TableAccess,DataLimits>("outputLimit", TableAccess.class, DataLimits.class, false, null, new QName("", "outputLimit"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "DataLimits"), false) {


            @Override
            public DataLimits get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.outputLimit);
            }

            @Override
            public void set(final TableAccess _instance_, final DataLimits _value_) {
                if (_instance_!= null) {
                    _instance_.outputLimit = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableAccess, DataLimits> UPLOAD_LIMIT = new SinglePropertyInfo<TableAccess,DataLimits>("uploadLimit", TableAccess.class, DataLimits.class, false, null, new QName("", "uploadLimit"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "DataLimits"), false) {


            @Override
            public DataLimits get(final TableAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.uploadLimit);
            }

            @Override
            public void set(final TableAccess _instance_, final DataLimits _value_) {
                if (_instance_!= null) {
                    _instance_.uploadLimit = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends TableAccess.Selector<TableAccess.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static TableAccess.Select _root() {
            return new TableAccess.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Capability.Selector<TRoot, TParent>
    {

        private DataModelType.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> dataModels = null;
        private Language.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> languages = null;
        private OutputFormat.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> outputFormats = null;
        private UploadMethod.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> uploadMethods = null;
        private TimeLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> retentionPeriod = null;
        private TimeLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> executionDuration = null;
        private DataLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> outputLimit = null;
        private DataLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> uploadLimit = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.dataModels!= null) {
                products.put("dataModels", this.dataModels.init());
            }
            if (this.languages!= null) {
                products.put("languages", this.languages.init());
            }
            if (this.outputFormats!= null) {
                products.put("outputFormats", this.outputFormats.init());
            }
            if (this.uploadMethods!= null) {
                products.put("uploadMethods", this.uploadMethods.init());
            }
            if (this.retentionPeriod!= null) {
                products.put("retentionPeriod", this.retentionPeriod.init());
            }
            if (this.executionDuration!= null) {
                products.put("executionDuration", this.executionDuration.init());
            }
            if (this.outputLimit!= null) {
                products.put("outputLimit", this.outputLimit.init());
            }
            if (this.uploadLimit!= null) {
                products.put("uploadLimit", this.uploadLimit.init());
            }
            return products;
        }

        public DataModelType.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> dataModels() {
            return ((this.dataModels == null)?this.dataModels = new DataModelType.Selector<>(this._root, this, "dataModels"):this.dataModels);
        }

        public Language.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> languages() {
            return ((this.languages == null)?this.languages = new Language.Selector<>(this._root, this, "languages"):this.languages);
        }

        public OutputFormat.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> outputFormats() {
            return ((this.outputFormats == null)?this.outputFormats = new OutputFormat.Selector<>(this._root, this, "outputFormats"):this.outputFormats);
        }

        public UploadMethod.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> uploadMethods() {
            return ((this.uploadMethods == null)?this.uploadMethods = new UploadMethod.Selector<>(this._root, this, "uploadMethods"):this.uploadMethods);
        }

        public TimeLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> retentionPeriod() {
            return ((this.retentionPeriod == null)?this.retentionPeriod = new TimeLimits.Selector<>(this._root, this, "retentionPeriod"):this.retentionPeriod);
        }

        public TimeLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> executionDuration() {
            return ((this.executionDuration == null)?this.executionDuration = new TimeLimits.Selector<>(this._root, this, "executionDuration"):this.executionDuration);
        }

        public DataLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> outputLimit() {
            return ((this.outputLimit == null)?this.outputLimit = new DataLimits.Selector<>(this._root, this, "outputLimit"):this.outputLimit);
        }

        public DataLimits.Selector<TRoot, TableAccess.Selector<TRoot, TParent>> uploadLimit() {
            return ((this.uploadLimit == null)?this.uploadLimit = new DataLimits.Selector<>(this._root, this, "uploadLimit"):this.uploadLimit);
        }

    }

}
