
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Astronomical area type
 * 
 * <p>Java class for astroCoordAreaType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="astroCoordAreaType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordAreaType">
 *       <sequence>
 *         <element name="TimeInterval" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}timeIntervalType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}PositionInterval" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}VelocityInterval" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="SpectralInterval" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}spectralIntervalType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="RedshiftInterval" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}redshiftIntervalType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "astroCoordAreaType", propOrder = {
    "timeIntervals",
    "positionInterval",
    "velocityIntervals",
    "spectralIntervals",
    "redshiftIntervals"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class AstroCoordAreaType
    extends CoordAreaType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "TimeInterval", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<TimeIntervalType> timeIntervals;
    /**
     * The spatial (position) coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     */
    @XmlElementRef(name = "PositionInterval", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class, required = false)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected JAXBElement<? extends CoordIntervalType> positionInterval;
    /**
     * The spatial (velocity) coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     */
    @XmlElementRef(name = "VelocityInterval", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class, required = false)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<JAXBElement<? extends CoordIntervalType>> velocityIntervals;
    @XmlElement(name = "SpectralInterval", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<SpectralIntervalType> spectralIntervals;
    @XmlElement(name = "RedshiftInterval", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected List<RedshiftIntervalType> redshiftIntervals;

    /**
     * Default no-arg constructor
     * 
     */
    public AstroCoordAreaType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public AstroCoordAreaType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<JAXBElement<? extends CoordIntervalType>> coordIntervals, final Object coordSystemId, final List<TimeIntervalType> timeIntervals, final JAXBElement<? extends CoordIntervalType> positionInterval, final List<JAXBElement<? extends CoordIntervalType>> velocityIntervals, final List<SpectralIntervalType> spectralIntervals, final List<RedshiftIntervalType> redshiftIntervals) {
        super(id, idref, ucd, type, href, idType, idrefType, coordIntervals, coordSystemId);
        this.timeIntervals = timeIntervals;
        this.positionInterval = positionInterval;
        this.velocityIntervals = velocityIntervals;
        this.spectralIntervals = spectralIntervals;
        this.redshiftIntervals = redshiftIntervals;
    }

    /**
     * Gets the value of the timeIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the timeIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTimeIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TimeIntervalType }
     * </p>
     * 
     * 
     * @return
     *     The value of the timeIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<TimeIntervalType> getTimeIntervals() {
        if (timeIntervals == null) {
            timeIntervals = new ArrayList<>();
        }
        return this.timeIntervals;
    }

    /**
     * The spatial (position) coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     * @return
     *     possible object is
     *     {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     *     {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     *     {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     *     {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     *     {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     *     {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     *     {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     *     {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Pos2VecIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Pos3VecIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PosScalarIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionFileType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SphereType }{@code >}
     *     {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public JAXBElement<? extends CoordIntervalType> getPositionInterval() {
        return positionInterval;
    }

    /**
     * Sets the value of the positionInterval property.
     * 
     * @param value
     *     allowed object is
     *     {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     *     {@link JAXBElement }{@code <}{@link AllSkyType }{@code >}
     *     {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     *     {@link JAXBElement }{@code <}{@link BoxType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CircleType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexHullType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link ConvexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link CoordIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     *     {@link JAXBElement }{@code <}{@link DiffType }{@code >}
     *     {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     *     {@link JAXBElement }{@code <}{@link EllipseType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link IntersectionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     *     {@link JAXBElement }{@code <}{@link NegationType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PolygonType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Pos2VecIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link Pos3VecIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link PosScalarIntervalType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionFileType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link RegionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SectorType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SkyIndexType }{@code >}
     *     {@link JAXBElement }{@code <}{@link SphereType }{@code >}
     *     {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     *     {@link JAXBElement }{@code <}{@link UnionType }{@code >}
     *     
     * @see #getPositionInterval()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setPositionInterval(JAXBElement<? extends CoordIntervalType> value) {
        this.positionInterval = value;
    }

    /**
     * The spatial (velocity) coordinate interval substitution group head element; such an element needs to contain a minimum or maximum scalar or vector value, or both; it needs to refer to a coordinate system; boundaries may or may not be inclusive; and it can have a fill factor
     * 
     * Gets the value of the velocityIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the velocityIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getVelocityIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link CoordIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link Vel2VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link Vel3VecIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link VelScalarIntervalType }{@code >}
     * {@link JAXBElement }{@code <}{@link VelocitySphereType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the velocityIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<JAXBElement<? extends CoordIntervalType>> getVelocityIntervals() {
        if (velocityIntervals == null) {
            velocityIntervals = new ArrayList<>();
        }
        return this.velocityIntervals;
    }

    /**
     * Gets the value of the spectralIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spectralIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSpectralIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpectralIntervalType }
     * </p>
     * 
     * 
     * @return
     *     The value of the spectralIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<SpectralIntervalType> getSpectralIntervals() {
        if (spectralIntervals == null) {
            spectralIntervals = new ArrayList<>();
        }
        return this.spectralIntervals;
    }

    /**
     * Gets the value of the redshiftIntervals property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the redshiftIntervals property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRedshiftIntervals().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RedshiftIntervalType }
     * </p>
     * 
     * 
     * @return
     *     The value of the redshiftIntervals property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public List<RedshiftIntervalType> getRedshiftIntervals() {
        if (redshiftIntervals == null) {
            redshiftIntervals = new ArrayList<>();
        }
        return this.redshiftIntervals;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final AstroCoordAreaType that = ((AstroCoordAreaType) object);
        {
            List<TimeIntervalType> leftTimeIntervals;
            leftTimeIntervals = (((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty()))?this.getTimeIntervals():null);
            List<TimeIntervalType> rightTimeIntervals;
            rightTimeIntervals = (((that.timeIntervals!= null)&&(!that.timeIntervals.isEmpty()))?that.getTimeIntervals():null);
            if ((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty())) {
                if ((that.timeIntervals!= null)&&(!that.timeIntervals.isEmpty())) {
                    if (!leftTimeIntervals.equals(rightTimeIntervals)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.timeIntervals!= null)&&(!that.timeIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            JAXBElement<? extends CoordIntervalType> leftPositionInterval;
            leftPositionInterval = this.getPositionInterval();
            JAXBElement<? extends CoordIntervalType> rightPositionInterval;
            rightPositionInterval = that.getPositionInterval();
            if (this.positionInterval!= null) {
                if (that.positionInterval!= null) {
                    {
                        final QName leftPositionIntervalName = leftPositionInterval.getName();
                        final QName rightPositionIntervalName = rightPositionInterval.getName();
                        if (leftPositionIntervalName!= null) {
                            if (rightPositionIntervalName!= null) {
                                if (!leftPositionIntervalName.equals(rightPositionIntervalName)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightPositionIntervalName!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final CoordIntervalType leftPositionIntervalValue = leftPositionInterval.getValue();
                        final CoordIntervalType rightPositionIntervalValue = rightPositionInterval.getValue();
                        if (leftPositionIntervalValue!= null) {
                            if (rightPositionIntervalValue!= null) {
                                if (!leftPositionIntervalValue.equals(rightPositionIntervalValue)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightPositionIntervalValue!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<? extends CoordIntervalType> leftPositionIntervalDeclaredType = leftPositionInterval.getDeclaredType();
                        final Class<? extends CoordIntervalType> rightPositionIntervalDeclaredType = rightPositionInterval.getDeclaredType();
                        if (leftPositionIntervalDeclaredType!= null) {
                            if (rightPositionIntervalDeclaredType!= null) {
                                if (!leftPositionIntervalDeclaredType.equals(rightPositionIntervalDeclaredType)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightPositionIntervalDeclaredType!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final Class<?> leftPositionIntervalScope = leftPositionInterval.getScope();
                        final Class<?> rightPositionIntervalScope = rightPositionInterval.getScope();
                        if (leftPositionIntervalScope!= null) {
                            if (rightPositionIntervalScope!= null) {
                                if (!leftPositionIntervalScope.equals(rightPositionIntervalScope)) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (rightPositionIntervalScope!= null) {
                                return false;
                            }
                        }
                    }
                    {
                        final boolean leftPositionIntervalNil = leftPositionInterval.isNil();
                        final boolean rightPositionIntervalNil = rightPositionInterval.isNil();
                        if (leftPositionIntervalNil!= rightPositionIntervalNil) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
            } else {
                if (that.positionInterval!= null) {
                    return false;
                }
            }
        }
        {
            List<JAXBElement<? extends CoordIntervalType>> leftVelocityIntervals;
            leftVelocityIntervals = (((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty()))?this.getVelocityIntervals():null);
            List<JAXBElement<? extends CoordIntervalType>> rightVelocityIntervals;
            rightVelocityIntervals = (((that.velocityIntervals!= null)&&(!that.velocityIntervals.isEmpty()))?that.getVelocityIntervals():null);
            if ((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty())) {
                if ((that.velocityIntervals!= null)&&(!that.velocityIntervals.isEmpty())) {
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> leftVelocityIntervalsListIterator = leftVelocityIntervals.listIterator();
                    final ListIterator<JAXBElement<? extends CoordIntervalType>> rightVelocityIntervalsListIterator = rightVelocityIntervals.listIterator();
                    while (rightVelocityIntervalsListIterator.hasNext()&&leftVelocityIntervalsListIterator.hasNext()) {
                        final JAXBElement<? extends CoordIntervalType> rightVelocityIntervalsListIteratorElement = rightVelocityIntervalsListIterator.next();
                        final JAXBElement<? extends CoordIntervalType> leftVelocityIntervalsListIteratorElement = leftVelocityIntervalsListIterator.next();
                        if (rightVelocityIntervalsListIteratorElement!= null) {
                            if (leftVelocityIntervalsListIteratorElement!= null) {
                                {
                                    final QName rightVelocityIntervalsListIteratorElementName = rightVelocityIntervalsListIteratorElement.getName();
                                    final QName leftVelocityIntervalsListIteratorElementName = leftVelocityIntervalsListIteratorElement.getName();
                                    if (rightVelocityIntervalsListIteratorElementName!= null) {
                                        if (leftVelocityIntervalsListIteratorElementName!= null) {
                                            if (!rightVelocityIntervalsListIteratorElementName.equals(leftVelocityIntervalsListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftVelocityIntervalsListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final CoordIntervalType rightVelocityIntervalsListIteratorElementValue = rightVelocityIntervalsListIteratorElement.getValue();
                                    final CoordIntervalType leftVelocityIntervalsListIteratorElementValue = leftVelocityIntervalsListIteratorElement.getValue();
                                    if (rightVelocityIntervalsListIteratorElementValue!= null) {
                                        if (leftVelocityIntervalsListIteratorElementValue!= null) {
                                            if (!rightVelocityIntervalsListIteratorElementValue.equals(leftVelocityIntervalsListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftVelocityIntervalsListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends CoordIntervalType> rightVelocityIntervalsListIteratorElementDeclaredType = rightVelocityIntervalsListIteratorElement.getDeclaredType();
                                    final Class<? extends CoordIntervalType> leftVelocityIntervalsListIteratorElementDeclaredType = leftVelocityIntervalsListIteratorElement.getDeclaredType();
                                    if (rightVelocityIntervalsListIteratorElementDeclaredType!= null) {
                                        if (leftVelocityIntervalsListIteratorElementDeclaredType!= null) {
                                            if (!rightVelocityIntervalsListIteratorElementDeclaredType.equals(leftVelocityIntervalsListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftVelocityIntervalsListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightVelocityIntervalsListIteratorElementScope = rightVelocityIntervalsListIteratorElement.getScope();
                                    final Class<?> leftVelocityIntervalsListIteratorElementScope = leftVelocityIntervalsListIteratorElement.getScope();
                                    if (rightVelocityIntervalsListIteratorElementScope!= null) {
                                        if (leftVelocityIntervalsListIteratorElementScope!= null) {
                                            if (!rightVelocityIntervalsListIteratorElementScope.equals(leftVelocityIntervalsListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftVelocityIntervalsListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightVelocityIntervalsListIteratorElementNil = rightVelocityIntervalsListIteratorElement.isNil();
                                    final boolean leftVelocityIntervalsListIteratorElementNil = leftVelocityIntervalsListIteratorElement.isNil();
                                    if (rightVelocityIntervalsListIteratorElementNil!= leftVelocityIntervalsListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftVelocityIntervalsListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightVelocityIntervalsListIterator.hasNext()||leftVelocityIntervalsListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.velocityIntervals!= null)&&(!that.velocityIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<SpectralIntervalType> leftSpectralIntervals;
            leftSpectralIntervals = (((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty()))?this.getSpectralIntervals():null);
            List<SpectralIntervalType> rightSpectralIntervals;
            rightSpectralIntervals = (((that.spectralIntervals!= null)&&(!that.spectralIntervals.isEmpty()))?that.getSpectralIntervals():null);
            if ((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty())) {
                if ((that.spectralIntervals!= null)&&(!that.spectralIntervals.isEmpty())) {
                    if (!leftSpectralIntervals.equals(rightSpectralIntervals)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.spectralIntervals!= null)&&(!that.spectralIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<RedshiftIntervalType> leftRedshiftIntervals;
            leftRedshiftIntervals = (((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty()))?this.getRedshiftIntervals():null);
            List<RedshiftIntervalType> rightRedshiftIntervals;
            rightRedshiftIntervals = (((that.redshiftIntervals!= null)&&(!that.redshiftIntervals.isEmpty()))?that.getRedshiftIntervals():null);
            if ((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty())) {
                if ((that.redshiftIntervals!= null)&&(!that.redshiftIntervals.isEmpty())) {
                    if (!leftRedshiftIntervals.equals(rightRedshiftIntervals)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.redshiftIntervals!= null)&&(!that.redshiftIntervals.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<TimeIntervalType> theTimeIntervals;
            theTimeIntervals = (((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty()))?this.getTimeIntervals():null);
            if ((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty())) {
                currentHashCode += theTimeIntervals.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            JAXBElement<? extends CoordIntervalType> thePositionInterval;
            thePositionInterval = this.getPositionInterval();
            if (this.positionInterval!= null) {
                {
                    currentHashCode = (currentHashCode* 31);
                    final QName thePositionIntervalName = thePositionInterval.getName();
                    if (thePositionIntervalName!= null) {
                        currentHashCode += thePositionIntervalName.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final CoordIntervalType thePositionIntervalValue = thePositionInterval.getValue();
                    if (thePositionIntervalValue!= null) {
                        currentHashCode += thePositionIntervalValue.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<? extends CoordIntervalType> thePositionIntervalDeclaredType = thePositionInterval.getDeclaredType();
                    if (thePositionIntervalDeclaredType!= null) {
                        currentHashCode += thePositionIntervalDeclaredType.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final Class<?> thePositionIntervalScope = thePositionInterval.getScope();
                    if (thePositionIntervalScope!= null) {
                        currentHashCode += thePositionIntervalScope.hashCode();
                    }
                }
                {
                    currentHashCode = (currentHashCode* 31);
                    final boolean thePositionIntervalNil = thePositionInterval.isNil();
                    currentHashCode += (thePositionIntervalNil? 1231 : 1237);
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends CoordIntervalType>> theVelocityIntervals;
            theVelocityIntervals = (((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty()))?this.getVelocityIntervals():null);
            if ((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty())) {
                final ListIterator<JAXBElement<? extends CoordIntervalType>> theVelocityIntervalsListIterator = theVelocityIntervals.listIterator();
                while (theVelocityIntervalsListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends CoordIntervalType> theVelocityIntervalsListIteratorElement = theVelocityIntervalsListIterator.next();
                    if (theVelocityIntervalsListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName theVelocityIntervalsListIteratorElementName = theVelocityIntervalsListIteratorElement.getName();
                            if (theVelocityIntervalsListIteratorElementName!= null) {
                                currentHashCode += theVelocityIntervalsListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final CoordIntervalType theVelocityIntervalsListIteratorElementValue = theVelocityIntervalsListIteratorElement.getValue();
                            if (theVelocityIntervalsListIteratorElementValue!= null) {
                                currentHashCode += theVelocityIntervalsListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends CoordIntervalType> theVelocityIntervalsListIteratorElementDeclaredType = theVelocityIntervalsListIteratorElement.getDeclaredType();
                            if (theVelocityIntervalsListIteratorElementDeclaredType!= null) {
                                currentHashCode += theVelocityIntervalsListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> theVelocityIntervalsListIteratorElementScope = theVelocityIntervalsListIteratorElement.getScope();
                            if (theVelocityIntervalsListIteratorElementScope!= null) {
                                currentHashCode += theVelocityIntervalsListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean theVelocityIntervalsListIteratorElementNil = theVelocityIntervalsListIteratorElement.isNil();
                            currentHashCode += (theVelocityIntervalsListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<SpectralIntervalType> theSpectralIntervals;
            theSpectralIntervals = (((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty()))?this.getSpectralIntervals():null);
            if ((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty())) {
                currentHashCode += theSpectralIntervals.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<RedshiftIntervalType> theRedshiftIntervals;
            theRedshiftIntervals = (((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty()))?this.getRedshiftIntervals():null);
            if ((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty())) {
                currentHashCode += theRedshiftIntervals.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<TimeIntervalType> theTimeIntervals;
            theTimeIntervals = (((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty()))?this.getTimeIntervals():null);
            strategy.appendField(locator, this, "timeIntervals", buffer, theTimeIntervals, ((this.timeIntervals!= null)&&(!this.timeIntervals.isEmpty())));
        }
        {
            JAXBElement<? extends CoordIntervalType> thePositionInterval;
            thePositionInterval = this.getPositionInterval();
            strategy.appendField(locator, this, "positionInterval", buffer, thePositionInterval, (this.positionInterval!= null));
        }
        {
            List<JAXBElement<? extends CoordIntervalType>> theVelocityIntervals;
            theVelocityIntervals = (((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty()))?this.getVelocityIntervals():null);
            strategy.appendField(locator, this, "velocityIntervals", buffer, theVelocityIntervals, ((this.velocityIntervals!= null)&&(!this.velocityIntervals.isEmpty())));
        }
        {
            List<SpectralIntervalType> theSpectralIntervals;
            theSpectralIntervals = (((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty()))?this.getSpectralIntervals():null);
            strategy.appendField(locator, this, "spectralIntervals", buffer, theSpectralIntervals, ((this.spectralIntervals!= null)&&(!this.spectralIntervals.isEmpty())));
        }
        {
            List<RedshiftIntervalType> theRedshiftIntervals;
            theRedshiftIntervals = (((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty()))?this.getRedshiftIntervals():null);
            strategy.appendField(locator, this, "redshiftIntervals", buffer, theRedshiftIntervals, ((this.redshiftIntervals!= null)&&(!this.redshiftIntervals.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof AstroCoordAreaType) {
            final AstroCoordAreaType target = this;
            final AstroCoordAreaType leftObject = ((AstroCoordAreaType) left);
            final AstroCoordAreaType rightObject = ((AstroCoordAreaType) right);
            {
                Boolean timeIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.timeIntervals!= null)&&(!leftObject.timeIntervals.isEmpty())), ((rightObject.timeIntervals!= null)&&(!rightObject.timeIntervals.isEmpty())));
                if (timeIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<TimeIntervalType> lhsTimeIntervals;
                    lhsTimeIntervals = (((leftObject.timeIntervals!= null)&&(!leftObject.timeIntervals.isEmpty()))?leftObject.getTimeIntervals():null);
                    List<TimeIntervalType> rhsTimeIntervals;
                    rhsTimeIntervals = (((rightObject.timeIntervals!= null)&&(!rightObject.timeIntervals.isEmpty()))?rightObject.getTimeIntervals():null);
                    List<TimeIntervalType> mergedTimeIntervals = ((List<TimeIntervalType> ) strategy.merge(LocatorUtils.property(leftLocator, "timeIntervals", lhsTimeIntervals), LocatorUtils.property(rightLocator, "timeIntervals", rhsTimeIntervals), lhsTimeIntervals, rhsTimeIntervals, ((leftObject.timeIntervals!= null)&&(!leftObject.timeIntervals.isEmpty())), ((rightObject.timeIntervals!= null)&&(!rightObject.timeIntervals.isEmpty()))));
                    target.timeIntervals = null;
                    if (mergedTimeIntervals!= null) {
                        List<TimeIntervalType> uniqueTimeIntervalsl = target.getTimeIntervals();
                        uniqueTimeIntervalsl.addAll(mergedTimeIntervals);
                    }
                } else {
                    if (timeIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timeIntervals = null;
                    }
                }
            }
            {
                Boolean positionIntervalShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.positionInterval!= null), (rightObject.positionInterval!= null));
                if (positionIntervalShouldBeMergedAndSet == Boolean.TRUE) {
                    JAXBElement<? extends CoordIntervalType> lhsPositionInterval;
                    lhsPositionInterval = leftObject.getPositionInterval();
                    JAXBElement<? extends CoordIntervalType> rhsPositionInterval;
                    rhsPositionInterval = rightObject.getPositionInterval();
                    JAXBElement<? extends CoordIntervalType> mergedPositionInterval = ((JAXBElement<? extends CoordIntervalType> ) strategy.merge(LocatorUtils.property(leftLocator, "positionInterval", lhsPositionInterval), LocatorUtils.property(rightLocator, "positionInterval", rhsPositionInterval), lhsPositionInterval, rhsPositionInterval, (leftObject.positionInterval!= null), (rightObject.positionInterval!= null)));
                    target.setPositionInterval(mergedPositionInterval);
                } else {
                    if (positionIntervalShouldBeMergedAndSet == Boolean.FALSE) {
                        target.positionInterval = null;
                    }
                }
            }
            {
                Boolean velocityIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.velocityIntervals!= null)&&(!leftObject.velocityIntervals.isEmpty())), ((rightObject.velocityIntervals!= null)&&(!rightObject.velocityIntervals.isEmpty())));
                if (velocityIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends CoordIntervalType>> lhsVelocityIntervals;
                    lhsVelocityIntervals = (((leftObject.velocityIntervals!= null)&&(!leftObject.velocityIntervals.isEmpty()))?leftObject.getVelocityIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> rhsVelocityIntervals;
                    rhsVelocityIntervals = (((rightObject.velocityIntervals!= null)&&(!rightObject.velocityIntervals.isEmpty()))?rightObject.getVelocityIntervals():null);
                    List<JAXBElement<? extends CoordIntervalType>> mergedVelocityIntervals = ((List<JAXBElement<? extends CoordIntervalType>> ) strategy.merge(LocatorUtils.property(leftLocator, "velocityIntervals", lhsVelocityIntervals), LocatorUtils.property(rightLocator, "velocityIntervals", rhsVelocityIntervals), lhsVelocityIntervals, rhsVelocityIntervals, ((leftObject.velocityIntervals!= null)&&(!leftObject.velocityIntervals.isEmpty())), ((rightObject.velocityIntervals!= null)&&(!rightObject.velocityIntervals.isEmpty()))));
                    target.velocityIntervals = null;
                    if (mergedVelocityIntervals!= null) {
                        List<JAXBElement<? extends CoordIntervalType>> uniqueVelocityIntervalsl = target.getVelocityIntervals();
                        uniqueVelocityIntervalsl.addAll(mergedVelocityIntervals);
                    }
                } else {
                    if (velocityIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.velocityIntervals = null;
                    }
                }
            }
            {
                Boolean spectralIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.spectralIntervals!= null)&&(!leftObject.spectralIntervals.isEmpty())), ((rightObject.spectralIntervals!= null)&&(!rightObject.spectralIntervals.isEmpty())));
                if (spectralIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<SpectralIntervalType> lhsSpectralIntervals;
                    lhsSpectralIntervals = (((leftObject.spectralIntervals!= null)&&(!leftObject.spectralIntervals.isEmpty()))?leftObject.getSpectralIntervals():null);
                    List<SpectralIntervalType> rhsSpectralIntervals;
                    rhsSpectralIntervals = (((rightObject.spectralIntervals!= null)&&(!rightObject.spectralIntervals.isEmpty()))?rightObject.getSpectralIntervals():null);
                    List<SpectralIntervalType> mergedSpectralIntervals = ((List<SpectralIntervalType> ) strategy.merge(LocatorUtils.property(leftLocator, "spectralIntervals", lhsSpectralIntervals), LocatorUtils.property(rightLocator, "spectralIntervals", rhsSpectralIntervals), lhsSpectralIntervals, rhsSpectralIntervals, ((leftObject.spectralIntervals!= null)&&(!leftObject.spectralIntervals.isEmpty())), ((rightObject.spectralIntervals!= null)&&(!rightObject.spectralIntervals.isEmpty()))));
                    target.spectralIntervals = null;
                    if (mergedSpectralIntervals!= null) {
                        List<SpectralIntervalType> uniqueSpectralIntervalsl = target.getSpectralIntervals();
                        uniqueSpectralIntervalsl.addAll(mergedSpectralIntervals);
                    }
                } else {
                    if (spectralIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spectralIntervals = null;
                    }
                }
            }
            {
                Boolean redshiftIntervalsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.redshiftIntervals!= null)&&(!leftObject.redshiftIntervals.isEmpty())), ((rightObject.redshiftIntervals!= null)&&(!rightObject.redshiftIntervals.isEmpty())));
                if (redshiftIntervalsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<RedshiftIntervalType> lhsRedshiftIntervals;
                    lhsRedshiftIntervals = (((leftObject.redshiftIntervals!= null)&&(!leftObject.redshiftIntervals.isEmpty()))?leftObject.getRedshiftIntervals():null);
                    List<RedshiftIntervalType> rhsRedshiftIntervals;
                    rhsRedshiftIntervals = (((rightObject.redshiftIntervals!= null)&&(!rightObject.redshiftIntervals.isEmpty()))?rightObject.getRedshiftIntervals():null);
                    List<RedshiftIntervalType> mergedRedshiftIntervals = ((List<RedshiftIntervalType> ) strategy.merge(LocatorUtils.property(leftLocator, "redshiftIntervals", lhsRedshiftIntervals), LocatorUtils.property(rightLocator, "redshiftIntervals", rhsRedshiftIntervals), lhsRedshiftIntervals, rhsRedshiftIntervals, ((leftObject.redshiftIntervals!= null)&&(!leftObject.redshiftIntervals.isEmpty())), ((rightObject.redshiftIntervals!= null)&&(!rightObject.redshiftIntervals.isEmpty()))));
                    target.redshiftIntervals = null;
                    if (mergedRedshiftIntervals!= null) {
                        List<RedshiftIntervalType> uniqueRedshiftIntervalsl = target.getRedshiftIntervals();
                        uniqueRedshiftIntervalsl.addAll(mergedRedshiftIntervals);
                    }
                } else {
                    if (redshiftIntervalsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.redshiftIntervals = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new AstroCoordAreaType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType clone() {
        final AstroCoordAreaType _newObject;
        _newObject = ((AstroCoordAreaType) super.clone());
        if (this.timeIntervals == null) {
            _newObject.timeIntervals = null;
        } else {
            _newObject.timeIntervals = new ArrayList<>();
            for (TimeIntervalType _item: this.timeIntervals) {
                _newObject.timeIntervals.add(((_item == null)?null:_item.clone()));
            }
        }
        _newObject.velocityIntervals = ((this.velocityIntervals == null)?null:new ArrayList<>(this.velocityIntervals));
        if (this.spectralIntervals == null) {
            _newObject.spectralIntervals = null;
        } else {
            _newObject.spectralIntervals = new ArrayList<>();
            for (SpectralIntervalType _item: this.spectralIntervals) {
                _newObject.spectralIntervals.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.redshiftIntervals == null) {
            _newObject.redshiftIntervals = null;
        } else {
            _newObject.redshiftIntervals = new ArrayList<>();
            for (RedshiftIntervalType _item: this.redshiftIntervals) {
                _newObject.redshiftIntervals.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType createCopy() {
        final AstroCoordAreaType _newObject = ((AstroCoordAreaType) super.createCopy());
        if (this.timeIntervals == null) {
            _newObject.timeIntervals = null;
        } else {
            _newObject.timeIntervals = new ArrayList<>();
            for (TimeIntervalType _item: this.timeIntervals) {
                _newObject.timeIntervals.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.positionInterval = this.positionInterval;
        _newObject.velocityIntervals = ((this.velocityIntervals == null)?null:new ArrayList<>(this.velocityIntervals));
        if (this.spectralIntervals == null) {
            _newObject.spectralIntervals = null;
        } else {
            _newObject.spectralIntervals = new ArrayList<>();
            for (SpectralIntervalType _item: this.spectralIntervals) {
                _newObject.spectralIntervals.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.redshiftIntervals == null) {
            _newObject.redshiftIntervals = null;
        } else {
            _newObject.redshiftIntervals = new ArrayList<>();
            for (RedshiftIntervalType _item: this.redshiftIntervals) {
                _newObject.redshiftIntervals.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordAreaType _newObject = ((AstroCoordAreaType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree timeIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeIntervalsPropertyTree!= null):((timeIntervalsPropertyTree == null)||(!timeIntervalsPropertyTree.isLeaf())))) {
            if (this.timeIntervals == null) {
                _newObject.timeIntervals = null;
            } else {
                _newObject.timeIntervals = new ArrayList<>();
                for (TimeIntervalType _item: this.timeIntervals) {
                    _newObject.timeIntervals.add(((_item == null)?null:_item.createCopy(timeIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree positionIntervalPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("positionInterval"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionIntervalPropertyTree!= null):((positionIntervalPropertyTree == null)||(!positionIntervalPropertyTree.isLeaf())))) {
            _newObject.positionInterval = this.positionInterval;
        }
        final PropertyTree velocityIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("velocityIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(velocityIntervalsPropertyTree!= null):((velocityIntervalsPropertyTree == null)||(!velocityIntervalsPropertyTree.isLeaf())))) {
            _newObject.velocityIntervals = ((this.velocityIntervals == null)?null:new ArrayList<>(this.velocityIntervals));
        }
        final PropertyTree spectralIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralIntervalsPropertyTree!= null):((spectralIntervalsPropertyTree == null)||(!spectralIntervalsPropertyTree.isLeaf())))) {
            if (this.spectralIntervals == null) {
                _newObject.spectralIntervals = null;
            } else {
                _newObject.spectralIntervals = new ArrayList<>();
                for (SpectralIntervalType _item: this.spectralIntervals) {
                    _newObject.spectralIntervals.add(((_item == null)?null:_item.createCopy(spectralIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree redshiftIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftIntervalsPropertyTree!= null):((redshiftIntervalsPropertyTree == null)||(!redshiftIntervalsPropertyTree.isLeaf())))) {
            if (this.redshiftIntervals == null) {
                _newObject.redshiftIntervals = null;
            } else {
                _newObject.redshiftIntervals = new ArrayList<>();
                for (RedshiftIntervalType _item: this.redshiftIntervals) {
                    _newObject.redshiftIntervals.add(((_item == null)?null:_item.createCopy(redshiftIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new AstroCoordAreaType.Modifier();
        }
        return ((AstroCoordAreaType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final AstroCoordAreaType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.timeIntervals == null) {
            _other.timeIntervals = null;
        } else {
            _other.timeIntervals = new ArrayList<>();
            for (TimeIntervalType _item: this.timeIntervals) {
                _other.timeIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.positionInterval = this.positionInterval;
        if (this.velocityIntervals == null) {
            _other.velocityIntervals = null;
        } else {
            _other.velocityIntervals = new ArrayList<>();
            for (JAXBElement<? extends CoordIntervalType> _item: this.velocityIntervals) {
                _other.velocityIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        if (this.spectralIntervals == null) {
            _other.spectralIntervals = null;
        } else {
            _other.spectralIntervals = new ArrayList<>();
            for (SpectralIntervalType _item: this.spectralIntervals) {
                _other.spectralIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.redshiftIntervals == null) {
            _other.redshiftIntervals = null;
        } else {
            _other.redshiftIntervals = new ArrayList<>();
            for (RedshiftIntervalType _item: this.redshiftIntervals) {
                _other.redshiftIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >AstroCoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new AstroCoordAreaType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> builder() {
        return new AstroCoordAreaType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final StcBaseType _other) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final CoordAreaType _other) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final AstroCoordAreaType _other) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final AstroCoordAreaType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree timeIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeIntervalsPropertyTree!= null):((timeIntervalsPropertyTree == null)||(!timeIntervalsPropertyTree.isLeaf())))) {
            if (this.timeIntervals == null) {
                _other.timeIntervals = null;
            } else {
                _other.timeIntervals = new ArrayList<>();
                for (TimeIntervalType _item: this.timeIntervals) {
                    _other.timeIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other, timeIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree positionIntervalPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("positionInterval"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionIntervalPropertyTree!= null):((positionIntervalPropertyTree == null)||(!positionIntervalPropertyTree.isLeaf())))) {
            _other.positionInterval = this.positionInterval;
        }
        final PropertyTree velocityIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("velocityIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(velocityIntervalsPropertyTree!= null):((velocityIntervalsPropertyTree == null)||(!velocityIntervalsPropertyTree.isLeaf())))) {
            if (this.velocityIntervals == null) {
                _other.velocityIntervals = null;
            } else {
                _other.velocityIntervals = new ArrayList<>();
                for (JAXBElement<? extends CoordIntervalType> _item: this.velocityIntervals) {
                    _other.velocityIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree spectralIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralIntervalsPropertyTree!= null):((spectralIntervalsPropertyTree == null)||(!spectralIntervalsPropertyTree.isLeaf())))) {
            if (this.spectralIntervals == null) {
                _other.spectralIntervals = null;
            } else {
                _other.spectralIntervals = new ArrayList<>();
                for (SpectralIntervalType _item: this.spectralIntervals) {
                    _other.spectralIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other, spectralIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree redshiftIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftIntervals"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftIntervalsPropertyTree!= null):((redshiftIntervalsPropertyTree == null)||(!redshiftIntervalsPropertyTree.isLeaf())))) {
            if (this.redshiftIntervals == null) {
                _other.redshiftIntervals = null;
            } else {
                _other.redshiftIntervals = new ArrayList<>();
                for (RedshiftIntervalType _item: this.redshiftIntervals) {
                    _other.redshiftIntervals.add(((_item == null)?null:_item.newCopyBuilder(_other, redshiftIntervalsPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >AstroCoordAreaType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new AstroCoordAreaType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final CoordAreaType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >AstroCoordAreaType.Builder<_B> copyOf(final AstroCoordAreaType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordAreaType.Builder<_B> _newBuilder = new AstroCoordAreaType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyExcept(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyExcept(final AstroCoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyOnly(final CoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static AstroCoordAreaType.Builder<Void> copyOnly(final AstroCoordAreaType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public AstroCoordAreaType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(AstroCoordAreaType.PropInfo.TIME_INTERVALS, this))&&(this.timeIntervals!= null)) {
            for (TimeIntervalType _item_: this.timeIntervals) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new SingleProperty<>(AstroCoordAreaType.PropInfo.POSITION_INTERVAL, this))&&(this.positionInterval!= null)) {
            this.positionInterval.getValue().visit(_visitor_);
        }
        if (_visitor_.visit(new IndirectCollectionProperty<>(AstroCoordAreaType.PropInfo.VELOCITY_INTERVALS, this))&&(this.velocityIntervals!= null)) {
            for (JAXBElement<? extends CoordIntervalType> _item_: this.velocityIntervals) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(AstroCoordAreaType.PropInfo.SPECTRAL_INTERVALS, this))&&(this.spectralIntervals!= null)) {
            for (SpectralIntervalType _item_: this.spectralIntervals) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(AstroCoordAreaType.PropInfo.REDSHIFT_INTERVALS, this))&&(this.redshiftIntervals!= null)) {
            for (RedshiftIntervalType _item_: this.redshiftIntervals) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordAreaType.Builder<_B>
        implements Buildable
    {

        private List<TimeIntervalType.Builder<AstroCoordAreaType.Builder<_B>>> timeIntervals;
        private JAXBElement<? extends CoordIntervalType> positionInterval;
        private List<Buildable> velocityIntervals;
        private List<SpectralIntervalType.Builder<AstroCoordAreaType.Builder<_B>>> spectralIntervals;
        private List<RedshiftIntervalType.Builder<AstroCoordAreaType.Builder<_B>>> redshiftIntervals;

        public Builder(final _B _parentBuilder, final AstroCoordAreaType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.timeIntervals == null) {
                    this.timeIntervals = null;
                } else {
                    this.timeIntervals = new ArrayList<>();
                    for (TimeIntervalType _item: _other.timeIntervals) {
                        this.timeIntervals.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                this.positionInterval = _other.positionInterval;
                if (_other.velocityIntervals == null) {
                    this.velocityIntervals = null;
                } else {
                    this.velocityIntervals = new ArrayList<>();
                    for (JAXBElement<? extends CoordIntervalType> _item: _other.velocityIntervals) {
                        this.velocityIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                if (_other.spectralIntervals == null) {
                    this.spectralIntervals = null;
                } else {
                    this.spectralIntervals = new ArrayList<>();
                    for (SpectralIntervalType _item: _other.spectralIntervals) {
                        this.spectralIntervals.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.redshiftIntervals == null) {
                    this.redshiftIntervals = null;
                } else {
                    this.redshiftIntervals = new ArrayList<>();
                    for (RedshiftIntervalType _item: _other.redshiftIntervals) {
                        this.redshiftIntervals.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final AstroCoordAreaType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree timeIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeIntervalsPropertyTree!= null):((timeIntervalsPropertyTree == null)||(!timeIntervalsPropertyTree.isLeaf())))) {
                    if (_other.timeIntervals == null) {
                        this.timeIntervals = null;
                    } else {
                        this.timeIntervals = new ArrayList<>();
                        for (TimeIntervalType _item: _other.timeIntervals) {
                            this.timeIntervals.add(((_item == null)?null:_item.newCopyBuilder(this, timeIntervalsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree positionIntervalPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("positionInterval"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(positionIntervalPropertyTree!= null):((positionIntervalPropertyTree == null)||(!positionIntervalPropertyTree.isLeaf())))) {
                    this.positionInterval = _other.positionInterval;
                }
                final PropertyTree velocityIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("velocityIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(velocityIntervalsPropertyTree!= null):((velocityIntervalsPropertyTree == null)||(!velocityIntervalsPropertyTree.isLeaf())))) {
                    if (_other.velocityIntervals == null) {
                        this.velocityIntervals = null;
                    } else {
                        this.velocityIntervals = new ArrayList<>();
                        for (JAXBElement<? extends CoordIntervalType> _item: _other.velocityIntervals) {
                            this.velocityIntervals.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree spectralIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralIntervalsPropertyTree!= null):((spectralIntervalsPropertyTree == null)||(!spectralIntervalsPropertyTree.isLeaf())))) {
                    if (_other.spectralIntervals == null) {
                        this.spectralIntervals = null;
                    } else {
                        this.spectralIntervals = new ArrayList<>();
                        for (SpectralIntervalType _item: _other.spectralIntervals) {
                            this.spectralIntervals.add(((_item == null)?null:_item.newCopyBuilder(this, spectralIntervalsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree redshiftIntervalsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftIntervals"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftIntervalsPropertyTree!= null):((redshiftIntervalsPropertyTree == null)||(!redshiftIntervalsPropertyTree.isLeaf())))) {
                    if (_other.redshiftIntervals == null) {
                        this.redshiftIntervals = null;
                    } else {
                        this.redshiftIntervals = new ArrayList<>();
                        for (RedshiftIntervalType _item: _other.redshiftIntervals) {
                            this.redshiftIntervals.add(((_item == null)?null:_item.newCopyBuilder(this, redshiftIntervalsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends AstroCoordAreaType >_P init(final _P _product) {
            if (this.timeIntervals!= null) {
                final List<TimeIntervalType> timeIntervals = new ArrayList<>(this.timeIntervals.size());
                for (TimeIntervalType.Builder<AstroCoordAreaType.Builder<_B>> _item: this.timeIntervals) {
                    timeIntervals.add(_item.build());
                }
                _product.timeIntervals = timeIntervals;
            }
            _product.positionInterval = this.positionInterval;
            if (this.velocityIntervals!= null) {
                final List<JAXBElement<? extends CoordIntervalType>> velocityIntervals = new ArrayList<>(this.velocityIntervals.size());
                for (Buildable _item: this.velocityIntervals) {
                    velocityIntervals.add(((JAXBElement<? extends CoordIntervalType> ) _item.build()));
                }
                _product.velocityIntervals = velocityIntervals;
            }
            if (this.spectralIntervals!= null) {
                final List<SpectralIntervalType> spectralIntervals = new ArrayList<>(this.spectralIntervals.size());
                for (SpectralIntervalType.Builder<AstroCoordAreaType.Builder<_B>> _item: this.spectralIntervals) {
                    spectralIntervals.add(_item.build());
                }
                _product.spectralIntervals = spectralIntervals;
            }
            if (this.redshiftIntervals!= null) {
                final List<RedshiftIntervalType> redshiftIntervals = new ArrayList<>(this.redshiftIntervals.size());
                for (RedshiftIntervalType.Builder<AstroCoordAreaType.Builder<_B>> _item: this.redshiftIntervals) {
                    redshiftIntervals.add(_item.build());
                }
                _product.redshiftIntervals = redshiftIntervals;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "timeIntervals"
         * 
         * @param timeIntervals
         *     Items to add to the value of the "timeIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addTimeIntervals(final Iterable<? extends TimeIntervalType> timeIntervals) {
            if (timeIntervals!= null) {
                if (this.timeIntervals == null) {
                    this.timeIntervals = new ArrayList<>();
                }
                for (TimeIntervalType _item: timeIntervals) {
                    this.timeIntervals.add(new TimeIntervalType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "timeIntervals" (any previous value will be replaced)
         * 
         * @param timeIntervals
         *     New value of the "timeIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withTimeIntervals(final Iterable<? extends TimeIntervalType> timeIntervals) {
            if (this.timeIntervals!= null) {
                this.timeIntervals.clear();
            }
            return addTimeIntervals(timeIntervals);
        }

        /**
         * Adds the given items to the value of "timeIntervals"
         * 
         * @param timeIntervals
         *     Items to add to the value of the "timeIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addTimeIntervals(TimeIntervalType... timeIntervals) {
            addTimeIntervals(Arrays.asList(timeIntervals));
            return this;
        }

        /**
         * Sets the new value of "timeIntervals" (any previous value will be replaced)
         * 
         * @param timeIntervals
         *     New value of the "timeIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withTimeIntervals(TimeIntervalType... timeIntervals) {
            withTimeIntervals(Arrays.asList(timeIntervals));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "TimeIntervals"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.TimeIntervalType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "TimeIntervals" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.TimeIntervalType.Builder#end()} to
         *     return to the current builder.
         */
        public TimeIntervalType.Builder<? extends AstroCoordAreaType.Builder<_B>> addTimeIntervals() {
            if (this.timeIntervals == null) {
                this.timeIntervals = new ArrayList<>();
            }
            final TimeIntervalType.Builder<AstroCoordAreaType.Builder<_B>> timeIntervals_Builder = new TimeIntervalType.Builder<>(this, null, false);
            this.timeIntervals.add(timeIntervals_Builder);
            return timeIntervals_Builder;
        }

        /**
         * Sets the new value of "positionInterval" (any previous value will be replaced)
         * 
         * @param positionInterval
         *     New value of the "positionInterval" property.
         */
        public AstroCoordAreaType.Builder<_B> withPositionInterval(final JAXBElement<? extends CoordIntervalType> positionInterval) {
            this.positionInterval = positionInterval;
            return this;
        }

        /**
         * Adds the given items to the value of "velocityIntervals"
         * 
         * @param velocityIntervals
         *     Items to add to the value of the "velocityIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addVelocityIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> velocityIntervals) {
            if (velocityIntervals!= null) {
                if (this.velocityIntervals == null) {
                    this.velocityIntervals = new ArrayList<>();
                }
                for (JAXBElement<? extends CoordIntervalType> _item: velocityIntervals) {
                    this.velocityIntervals.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "velocityIntervals" (any previous value will be replaced)
         * 
         * @param velocityIntervals
         *     New value of the "velocityIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withVelocityIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> velocityIntervals) {
            if (this.velocityIntervals!= null) {
                this.velocityIntervals.clear();
            }
            return addVelocityIntervals(velocityIntervals);
        }

        /**
         * Adds the given items to the value of "velocityIntervals"
         * 
         * @param velocityIntervals
         *     Items to add to the value of the "velocityIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addVelocityIntervals(JAXBElement<? extends CoordIntervalType> ... velocityIntervals) {
            addVelocityIntervals(Arrays.asList(velocityIntervals));
            return this;
        }

        /**
         * Sets the new value of "velocityIntervals" (any previous value will be replaced)
         * 
         * @param velocityIntervals
         *     New value of the "velocityIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withVelocityIntervals(JAXBElement<? extends CoordIntervalType> ... velocityIntervals) {
            withVelocityIntervals(Arrays.asList(velocityIntervals));
            return this;
        }

        /**
         * Adds the given items to the value of "spectralIntervals"
         * 
         * @param spectralIntervals
         *     Items to add to the value of the "spectralIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addSpectralIntervals(final Iterable<? extends SpectralIntervalType> spectralIntervals) {
            if (spectralIntervals!= null) {
                if (this.spectralIntervals == null) {
                    this.spectralIntervals = new ArrayList<>();
                }
                for (SpectralIntervalType _item: spectralIntervals) {
                    this.spectralIntervals.add(new SpectralIntervalType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "spectralIntervals" (any previous value will be replaced)
         * 
         * @param spectralIntervals
         *     New value of the "spectralIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withSpectralIntervals(final Iterable<? extends SpectralIntervalType> spectralIntervals) {
            if (this.spectralIntervals!= null) {
                this.spectralIntervals.clear();
            }
            return addSpectralIntervals(spectralIntervals);
        }

        /**
         * Adds the given items to the value of "spectralIntervals"
         * 
         * @param spectralIntervals
         *     Items to add to the value of the "spectralIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addSpectralIntervals(SpectralIntervalType... spectralIntervals) {
            addSpectralIntervals(Arrays.asList(spectralIntervals));
            return this;
        }

        /**
         * Sets the new value of "spectralIntervals" (any previous value will be replaced)
         * 
         * @param spectralIntervals
         *     New value of the "spectralIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withSpectralIntervals(SpectralIntervalType... spectralIntervals) {
            withSpectralIntervals(Arrays.asList(spectralIntervals));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "SpectralIntervals"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.SpectralIntervalType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "SpectralIntervals" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.SpectralIntervalType.Builder#end()}
         *     to return to the current builder.
         */
        public SpectralIntervalType.Builder<? extends AstroCoordAreaType.Builder<_B>> addSpectralIntervals() {
            if (this.spectralIntervals == null) {
                this.spectralIntervals = new ArrayList<>();
            }
            final SpectralIntervalType.Builder<AstroCoordAreaType.Builder<_B>> spectralIntervals_Builder = new SpectralIntervalType.Builder<>(this, null, false);
            this.spectralIntervals.add(spectralIntervals_Builder);
            return spectralIntervals_Builder;
        }

        /**
         * Adds the given items to the value of "redshiftIntervals"
         * 
         * @param redshiftIntervals
         *     Items to add to the value of the "redshiftIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addRedshiftIntervals(final Iterable<? extends RedshiftIntervalType> redshiftIntervals) {
            if (redshiftIntervals!= null) {
                if (this.redshiftIntervals == null) {
                    this.redshiftIntervals = new ArrayList<>();
                }
                for (RedshiftIntervalType _item: redshiftIntervals) {
                    this.redshiftIntervals.add(new RedshiftIntervalType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "redshiftIntervals" (any previous value will be replaced)
         * 
         * @param redshiftIntervals
         *     New value of the "redshiftIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withRedshiftIntervals(final Iterable<? extends RedshiftIntervalType> redshiftIntervals) {
            if (this.redshiftIntervals!= null) {
                this.redshiftIntervals.clear();
            }
            return addRedshiftIntervals(redshiftIntervals);
        }

        /**
         * Adds the given items to the value of "redshiftIntervals"
         * 
         * @param redshiftIntervals
         *     Items to add to the value of the "redshiftIntervals" property
         */
        public AstroCoordAreaType.Builder<_B> addRedshiftIntervals(RedshiftIntervalType... redshiftIntervals) {
            addRedshiftIntervals(Arrays.asList(redshiftIntervals));
            return this;
        }

        /**
         * Sets the new value of "redshiftIntervals" (any previous value will be replaced)
         * 
         * @param redshiftIntervals
         *     New value of the "redshiftIntervals" property.
         */
        public AstroCoordAreaType.Builder<_B> withRedshiftIntervals(RedshiftIntervalType... redshiftIntervals) {
            withRedshiftIntervals(Arrays.asList(redshiftIntervals));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "RedshiftIntervals"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RedshiftIntervalType.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "RedshiftIntervals" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RedshiftIntervalType.Builder#end()}
         *     to return to the current builder.
         */
        public RedshiftIntervalType.Builder<? extends AstroCoordAreaType.Builder<_B>> addRedshiftIntervals() {
            if (this.redshiftIntervals == null) {
                this.redshiftIntervals = new ArrayList<>();
            }
            final RedshiftIntervalType.Builder<AstroCoordAreaType.Builder<_B>> redshiftIntervals_Builder = new RedshiftIntervalType.Builder<>(this, null, false);
            this.redshiftIntervals.add(redshiftIntervals_Builder);
            return redshiftIntervals_Builder;
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        @Override
        public AstroCoordAreaType.Builder<_B> addCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            super.addCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Adds the given items to the value of "coordIntervals"
         * 
         * @param coordIntervals
         *     Items to add to the value of the "coordIntervals" property
         */
        @Override
        public AstroCoordAreaType.Builder<_B> addCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            super.addCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withCoordIntervals(final Iterable<? extends JAXBElement<? extends CoordIntervalType>> coordIntervals) {
            super.withCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordIntervals" (any previous value will be replaced)
         * 
         * @param coordIntervals
         *     New value of the "coordIntervals" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withCoordIntervals(JAXBElement<? extends CoordIntervalType> ... coordIntervals) {
            super.withCoordIntervals(coordIntervals);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public AstroCoordAreaType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public AstroCoordAreaType build() {
            if (_storedValue == null) {
                return this.init(new AstroCoordAreaType());
            } else {
                return ((AstroCoordAreaType) _storedValue);
            }
        }

        public AstroCoordAreaType.Builder<_B> copyOf(final AstroCoordAreaType _other) {
            _other.copyTo(this);
            return this;
        }

        public AstroCoordAreaType.Builder<_B> copyOf(final AstroCoordAreaType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordAreaType.Modifier
    {


        public List<TimeIntervalType> getTimeIntervals() {
            if (AstroCoordAreaType.this.timeIntervals == null) {
                AstroCoordAreaType.this.timeIntervals = new ArrayList<>();
            }
            return AstroCoordAreaType.this.timeIntervals;
        }

        public void setPositionInterval(final JAXBElement<? extends CoordIntervalType> positionInterval) {
            AstroCoordAreaType.this.setPositionInterval(positionInterval);
        }

        public List<JAXBElement<? extends CoordIntervalType>> getVelocityIntervals() {
            if (AstroCoordAreaType.this.velocityIntervals == null) {
                AstroCoordAreaType.this.velocityIntervals = new ArrayList<>();
            }
            return AstroCoordAreaType.this.velocityIntervals;
        }

        public List<SpectralIntervalType> getSpectralIntervals() {
            if (AstroCoordAreaType.this.spectralIntervals == null) {
                AstroCoordAreaType.this.spectralIntervals = new ArrayList<>();
            }
            return AstroCoordAreaType.this.spectralIntervals;
        }

        public List<RedshiftIntervalType> getRedshiftIntervals() {
            if (AstroCoordAreaType.this.redshiftIntervals == null) {
                AstroCoordAreaType.this.redshiftIntervals = new ArrayList<>();
            }
            return AstroCoordAreaType.this.redshiftIntervals;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<AstroCoordAreaType, TimeIntervalType> TIME_INTERVALS = new CollectionPropertyInfo<AstroCoordAreaType,TimeIntervalType>("timeIntervals", AstroCoordAreaType.class, TimeIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeIntervalType"), false) {


            @Override
            public List<TimeIntervalType> get(final AstroCoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.timeIntervals);
            }

            @Override
            public void set(final AstroCoordAreaType _instance_, final List<TimeIntervalType> _value_) {
                if (_instance_!= null) {
                    _instance_.timeIntervals = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstroCoordAreaType, CoordIntervalType> POSITION_INTERVAL = new SinglePropertyInfo<AstroCoordAreaType,CoordIntervalType>("positionInterval", AstroCoordAreaType.class, CoordIntervalType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PositionInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordIntervalType"), false) {


            @Override
            public CoordIntervalType get(final AstroCoordAreaType _instance_) {
                return ((_instance_ == null)?null:((_instance_.positionInterval == null)?null:_instance_.positionInterval.getValue()));
            }

            @Override
            public void set(final AstroCoordAreaType _instance_, final CoordIntervalType _value_) {
                if (_instance_!= null) {
                }
            }

        }
        ;
        public static final transient IndirectCollectionPropertyInfo<AstroCoordAreaType, CoordIntervalType> VELOCITY_INTERVALS = new IndirectCollectionPropertyInfo<AstroCoordAreaType,CoordIntervalType>("velocityIntervals", AstroCoordAreaType.class, CoordIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "VelocityInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordIntervalType"), false) {


            @Override
            public List<JAXBElement<? extends CoordIntervalType>> get(final AstroCoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.velocityIntervals);
            }

            @Override
            public void set(final AstroCoordAreaType _instance_, final List<JAXBElement<? extends CoordIntervalType>> _value_) {
                if (_instance_!= null) {
                    _instance_.velocityIntervals = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<AstroCoordAreaType, SpectralIntervalType> SPECTRAL_INTERVALS = new CollectionPropertyInfo<AstroCoordAreaType,SpectralIntervalType>("spectralIntervals", AstroCoordAreaType.class, SpectralIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SpectralInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "spectralIntervalType"), false) {


            @Override
            public List<SpectralIntervalType> get(final AstroCoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.spectralIntervals);
            }

            @Override
            public void set(final AstroCoordAreaType _instance_, final List<SpectralIntervalType> _value_) {
                if (_instance_!= null) {
                    _instance_.spectralIntervals = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<AstroCoordAreaType, RedshiftIntervalType> REDSHIFT_INTERVALS = new CollectionPropertyInfo<AstroCoordAreaType,RedshiftIntervalType>("redshiftIntervals", AstroCoordAreaType.class, RedshiftIntervalType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "RedshiftInterval"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "redshiftIntervalType"), false) {


            @Override
            public List<RedshiftIntervalType> get(final AstroCoordAreaType _instance_) {
                return ((_instance_ == null)?null:_instance_.redshiftIntervals);
            }

            @Override
            public void set(final AstroCoordAreaType _instance_, final List<RedshiftIntervalType> _value_) {
                if (_instance_!= null) {
                    _instance_.redshiftIntervals = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends AstroCoordAreaType.Selector<AstroCoordAreaType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static AstroCoordAreaType.Select _root() {
            return new AstroCoordAreaType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordAreaType.Selector<TRoot, TParent>
    {

        private TimeIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> timeIntervals = null;
        private com.kscs.util.jaxb.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> positionInterval = null;
        private com.kscs.util.jaxb.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> velocityIntervals = null;
        private SpectralIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> spectralIntervals = null;
        private RedshiftIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> redshiftIntervals = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.timeIntervals!= null) {
                products.put("timeIntervals", this.timeIntervals.init());
            }
            if (this.positionInterval!= null) {
                products.put("positionInterval", this.positionInterval.init());
            }
            if (this.velocityIntervals!= null) {
                products.put("velocityIntervals", this.velocityIntervals.init());
            }
            if (this.spectralIntervals!= null) {
                products.put("spectralIntervals", this.spectralIntervals.init());
            }
            if (this.redshiftIntervals!= null) {
                products.put("redshiftIntervals", this.redshiftIntervals.init());
            }
            return products;
        }

        public TimeIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> timeIntervals() {
            return ((this.timeIntervals == null)?this.timeIntervals = new TimeIntervalType.Selector<>(this._root, this, "timeIntervals"):this.timeIntervals);
        }

        public com.kscs.util.jaxb.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> positionInterval() {
            return ((this.positionInterval == null)?this.positionInterval = new com.kscs.util.jaxb.Selector<>(this._root, this, "positionInterval"):this.positionInterval);
        }

        public com.kscs.util.jaxb.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> velocityIntervals() {
            return ((this.velocityIntervals == null)?this.velocityIntervals = new com.kscs.util.jaxb.Selector<>(this._root, this, "velocityIntervals"):this.velocityIntervals);
        }

        public SpectralIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> spectralIntervals() {
            return ((this.spectralIntervals == null)?this.spectralIntervals = new SpectralIntervalType.Selector<>(this._root, this, "spectralIntervals"):this.spectralIntervals);
        }

        public RedshiftIntervalType.Selector<TRoot, AstroCoordAreaType.Selector<TRoot, TParent>> redshiftIntervals() {
            return ((this.redshiftIntervals == null)?this.redshiftIntervals = new RedshiftIntervalType.Selector<>(this._root, this, "redshiftIntervals"):this.redshiftIntervals);
        }

    }

}
