
package org.javastro.ivoa.entities.stc.v1;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Box shape: a rectangle defined by its center and size on both dimensions; since it is a polygon, it is redundant, but simple rectangles with great circle sides are awkward to define in spherical coordinates
 * 
 * <p>Java class for boxType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="boxType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}shapeType">
 *       <sequence>
 *         <element name="Center" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double2Type"/>
 *         <element name="Size" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}double2Type"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "boxType", propOrder = {
    "center",
    "size"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
public class BoxType
    extends ShapeType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The coordinates of the box's center
     * 
     */
    @XmlElement(name = "Center", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double2Type center;
    /**
     * The lengths of the box's sides
     * 
     */
    @XmlElement(name = "Size", required = true, nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    protected Double2Type size;

    /**
     * Default no-arg constructor
     * 
     */
    public BoxType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BoxType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final Boolean loInclude, final Boolean hiInclude, final Float fillFactor, final Object frameId, final BigDecimal epoch, final String unit, final RegionAreaType area, final String note, final Object coordSystemId, final Double2Type center, final Double2Type size) {
        super(id, idref, ucd, type, href, idType, idrefType, loInclude, hiInclude, fillFactor, frameId, epoch, unit, area, note, coordSystemId);
        this.center = center;
        this.size = size;
    }

    /**
     * The coordinates of the box's center
     * 
     * @return
     *     possible object is
     *     {@link Double2Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double2Type getCenter() {
        return center;
    }

    /**
     * Sets the value of the center property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double2Type }
     *     
     * @see #getCenter()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setCenter(Double2Type value) {
        this.center = value;
    }

    /**
     * The lengths of the box's sides
     * 
     * @return
     *     possible object is
     *     {@link Double2Type }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Double2Type getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double2Type }
     *     
     * @see #getSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void setSize(Double2Type value) {
        this.size = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final BoxType that = ((BoxType) object);
        {
            Double2Type leftCenter;
            leftCenter = this.getCenter();
            Double2Type rightCenter;
            rightCenter = that.getCenter();
            if (this.center!= null) {
                if (that.center!= null) {
                    if (!leftCenter.equals(rightCenter)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.center!= null) {
                    return false;
                }
            }
        }
        {
            Double2Type leftSize;
            leftSize = this.getSize();
            Double2Type rightSize;
            rightSize = that.getSize();
            if (this.size!= null) {
                if (that.size!= null) {
                    if (!leftSize.equals(rightSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.size!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            Double2Type theCenter;
            theCenter = this.getCenter();
            if (this.center!= null) {
                currentHashCode += theCenter.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Double2Type theSize;
            theSize = this.getSize();
            if (this.size!= null) {
                currentHashCode += theSize.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            Double2Type theCenter;
            theCenter = this.getCenter();
            strategy.appendField(locator, this, "center", buffer, theCenter, (this.center!= null));
        }
        {
            Double2Type theSize;
            theSize = this.getSize();
            strategy.appendField(locator, this, "size", buffer, theSize, (this.size!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof BoxType) {
            final BoxType target = this;
            final BoxType leftObject = ((BoxType) left);
            final BoxType rightObject = ((BoxType) right);
            {
                Boolean centerShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.center!= null), (rightObject.center!= null));
                if (centerShouldBeMergedAndSet == Boolean.TRUE) {
                    Double2Type lhsCenter;
                    lhsCenter = leftObject.getCenter();
                    Double2Type rhsCenter;
                    rhsCenter = rightObject.getCenter();
                    Double2Type mergedCenter = ((Double2Type) strategy.merge(LocatorUtils.property(leftLocator, "center", lhsCenter), LocatorUtils.property(rightLocator, "center", rhsCenter), lhsCenter, rhsCenter, (leftObject.center!= null), (rightObject.center!= null)));
                    target.setCenter(mergedCenter);
                } else {
                    if (centerShouldBeMergedAndSet == Boolean.FALSE) {
                        target.center = null;
                    }
                }
            }
            {
                Boolean sizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.size!= null), (rightObject.size!= null));
                if (sizeShouldBeMergedAndSet == Boolean.TRUE) {
                    Double2Type lhsSize;
                    lhsSize = leftObject.getSize();
                    Double2Type rhsSize;
                    rhsSize = rightObject.getSize();
                    Double2Type mergedSize = ((Double2Type) strategy.merge(LocatorUtils.property(leftLocator, "size", lhsSize), LocatorUtils.property(rightLocator, "size", rhsSize), lhsSize, rhsSize, (leftObject.size!= null), (rightObject.size!= null)));
                    target.setSize(mergedSize);
                } else {
                    if (sizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.size = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public Object createNewInstance() {
        return new BoxType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType clone() {
        final BoxType _newObject;
        _newObject = ((BoxType) super.clone());
        _newObject.center = ((this.center == null)?null:this.center.clone());
        _newObject.size = ((this.size == null)?null:this.size.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType createCopy() {
        final BoxType _newObject = ((BoxType) super.createCopy());
        _newObject.center = ((this.center == null)?null:this.center.createCopy());
        _newObject.size = ((this.size == null)?null:this.size.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType _newObject = ((BoxType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _newObject.center = ((this.center == null)?null:this.center.createCopy(centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _newObject.size = ((this.size == null)?null:this.size.createCopy(sizePropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new BoxType.Modifier();
        }
        return ((BoxType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final BoxType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other));
        _other.size = ((this.size == null)?null:this.size.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >BoxType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new BoxType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> builder() {
        return new BoxType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final StcBaseType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final CoordIntervalType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final SpatialIntervalType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final RegionType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final ShapeType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final BoxType _other) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >void copyTo(final BoxType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
            _other.center = ((this.center == null)?null:this.center.newCopyBuilder(_other, centerPropertyTree, _propertyTreeUse));
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _other.size = ((this.size == null)?null:this.size.newCopyBuilder(_other, sizePropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public<_B >BoxType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new BoxType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final CoordIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final SpatialIntervalType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final RegionType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final ShapeType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static<_B >BoxType.Builder<_B> copyOf(final BoxType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final BoxType.Builder<_B> _newBuilder = new BoxType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyExcept(final BoxType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final CoordIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final SpatialIntervalType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final RegionType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final ShapeType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public static BoxType.Builder<Void> copyOnly(final BoxType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-09-10T09:00:07+01:00")
    public BoxType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(BoxType.PropInfo.CENTER, this))&&(this.center!= null)) {
            this.center.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(BoxType.PropInfo.SIZE, this))&&(this.size!= null)) {
            this.size.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends ShapeType.Builder<_B>
        implements Buildable
    {

        private Double2Type.Builder<BoxType.Builder<_B>> center;
        private Double2Type.Builder<BoxType.Builder<_B>> size;

        public Builder(final _B _parentBuilder, final BoxType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this));
                this.size = ((_other.size == null)?null:_other.size.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final BoxType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree centerPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("center"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(centerPropertyTree!= null):((centerPropertyTree == null)||(!centerPropertyTree.isLeaf())))) {
                    this.center = ((_other.center == null)?null:_other.center.newCopyBuilder(this, centerPropertyTree, _propertyTreeUse));
                }
                final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
                    this.size = ((_other.size == null)?null:_other.size.newCopyBuilder(this, sizePropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends BoxType >_P init(final _P _product) {
            _product.center = ((this.center == null)?null:this.center.build());
            _product.size = ((this.size == null)?null:this.size.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "center" (any previous value will be replaced)
         * 
         * @param center
         *     New value of the "center" property.
         */
        public BoxType.Builder<_B> withCenter(final Double2Type center) {
            this.center = ((center == null)?null:new Double2Type.Builder<>(this, center, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "center"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "center" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double2Type.Builder<? extends BoxType.Builder<_B>> withCenter() {
            if (this.center!= null) {
                return this.center;
            }
            return this.center = new Double2Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "size" (any previous value will be replaced)
         * 
         * @param size
         *     New value of the "size" property.
         */
        public BoxType.Builder<_B> withSize(final Double2Type size) {
            this.size = ((size == null)?null:new Double2Type.Builder<>(this, size, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "size"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "size" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.Double2Type.Builder#end()} to
         *     return to the current builder.
         */
        public Double2Type.Builder<? extends BoxType.Builder<_B>> withSize() {
            if (this.size!= null) {
                return this.size;
            }
            return this.size = new Double2Type.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "area" (any previous value will be replaced)
         * 
         * @param area
         *     New value of the "area" property.
         */
        @Override
        public BoxType.Builder<_B> withArea(final RegionAreaType area) {
            super.withArea(area);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the "area"
         * property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "area" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RegionAreaType.Builder#end()} to
         *     return to the current builder.
         */
        public RegionAreaType.Builder<? extends BoxType.Builder<_B>> withArea() {
            return ((RegionAreaType.Builder<? extends BoxType.Builder<_B>> ) super.withArea());
        }

        /**
         * Sets the new value of "note" (any previous value will be replaced)
         * 
         * @param note
         *     New value of the "note" property.
         */
        @Override
        public BoxType.Builder<_B> withNote(final String note) {
            super.withNote(note);
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        @Override
        public BoxType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            super.withCoordSystemId(coordSystemId);
            return this;
        }

        /**
         * Sets the new value of "epoch" (any previous value will be replaced)
         * 
         * @param epoch
         *     New value of the "epoch" property.
         */
        @Override
        public BoxType.Builder<_B> withEpoch(final BigDecimal epoch) {
            super.withEpoch(epoch);
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        @Override
        public BoxType.Builder<_B> withUnit(final String unit) {
            super.withUnit(unit);
            return this;
        }

        /**
         * Sets the new value of "loInclude" (any previous value will be replaced)
         * 
         * @param loInclude
         *     New value of the "loInclude" property.
         */
        @Override
        public BoxType.Builder<_B> withLoInclude(final Boolean loInclude) {
            super.withLoInclude(loInclude);
            return this;
        }

        /**
         * Sets the new value of "hiInclude" (any previous value will be replaced)
         * 
         * @param hiInclude
         *     New value of the "hiInclude" property.
         */
        @Override
        public BoxType.Builder<_B> withHiInclude(final Boolean hiInclude) {
            super.withHiInclude(hiInclude);
            return this;
        }

        /**
         * Sets the new value of "fillFactor" (any previous value will be replaced)
         * 
         * @param fillFactor
         *     New value of the "fillFactor" property.
         */
        @Override
        public BoxType.Builder<_B> withFillFactor(final Float fillFactor) {
            super.withFillFactor(fillFactor);
            return this;
        }

        /**
         * Sets the new value of "frameId" (any previous value will be replaced)
         * 
         * @param frameId
         *     New value of the "frameId" property.
         */
        @Override
        public BoxType.Builder<_B> withFrameId(final Object frameId) {
            super.withFrameId(frameId);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public BoxType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public BoxType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public BoxType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public BoxType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public BoxType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public BoxType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public BoxType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public BoxType build() {
            if (_storedValue == null) {
                return this.init(new BoxType());
            } else {
                return ((BoxType) _storedValue);
            }
        }

        public BoxType.Builder<_B> copyOf(final BoxType _other) {
            _other.copyTo(this);
            return this;
        }

        public BoxType.Builder<_B> copyOf(final BoxType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ShapeType.Modifier
    {


        public void setCenter(final Double2Type center) {
            BoxType.this.setCenter(center);
        }

        public void setSize(final Double2Type size) {
            BoxType.this.setSize(size);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<BoxType, Double2Type> CENTER = new SinglePropertyInfo<BoxType,Double2Type>("center", BoxType.class, Double2Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Center"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double2Type"), false) {


            @Override
            public Double2Type get(final BoxType _instance_) {
                return ((_instance_ == null)?null:_instance_.center);
            }

            @Override
            public void set(final BoxType _instance_, final Double2Type _value_) {
                if (_instance_!= null) {
                    _instance_.center = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<BoxType, Double2Type> SIZE = new SinglePropertyInfo<BoxType,Double2Type>("size", BoxType.class, Double2Type.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Size"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "double2Type"), false) {


            @Override
            public Double2Type get(final BoxType _instance_) {
                return ((_instance_ == null)?null:_instance_.size);
            }

            @Override
            public void set(final BoxType _instance_, final Double2Type _value_) {
                if (_instance_!= null) {
                    _instance_.size = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends BoxType.Selector<BoxType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static BoxType.Select _root() {
            return new BoxType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ShapeType.Selector<TRoot, TParent>
    {

        private Double2Type.Selector<TRoot, BoxType.Selector<TRoot, TParent>> center = null;
        private Double2Type.Selector<TRoot, BoxType.Selector<TRoot, TParent>> size = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.center!= null) {
                products.put("center", this.center.init());
            }
            if (this.size!= null) {
                products.put("size", this.size.init());
            }
            return products;
        }

        public Double2Type.Selector<TRoot, BoxType.Selector<TRoot, TParent>> center() {
            return ((this.center == null)?this.center = new Double2Type.Selector<>(this._root, this, "center"):this.center);
        }

        public Double2Type.Selector<TRoot, BoxType.Selector<TRoot, TParent>> size() {
            return ((this.size == null)?this.size = new Double2Type.Selector<>(this._root, this, "size"):this.size);
        }

    }

}
